/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_beziersh.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:30:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#include "cmdid.h"

// auto strip #ifndef _SVDVIEW_HXX //autogen
// auto strip #include <bf_svx/svdview.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_SRCHITEM_HXX //autogen
// auto strip #include <bf_svx/srchitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_WHITER_HXX //autogen
// auto strip #include <svtools/whiter.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOPATH_HXX //autogen
// auto strip #include <bf_svx/svdopath.hxx>
// auto strip #endif
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWFRM_HXX
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_BINDINGS_HXX //autogen
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #endif
#ifndef _SFXOBJFACE_HXX //autogen
#include <bf_sfx2/objface.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

// auto strip #include "wrtsh.hxx"
#include "view.hxx"
// auto strip #include "edtwin.hxx"
#include "helpid.h"
#include "globals.hrc"
// auto strip #include "drawbase.hxx"
#include "beziersh.hxx"

#include "popup.hrc"
#include "shells.hrc"

#define SwBezierShell
#include "itemdef.hxx"
namespace binfilter {
#include "swslots.hxx"

#define C2S(cChar) UniString::CreateFromAscii(cChar)
/*N*/ SFX_IMPL_INTERFACE(SwBezierShell, SwBezierShell, SW_RES(STR_SHELLNAME_BEZIER))
/*N*/ {
//STRIP001 /*N*/ 	SFX_POPUPMENU_REGISTRATION(SW_RES(MN_DRAW_POPUPMENU));
//STRIP001 /*N*/ 	SFX_OBJECTBAR_REGISTRATION(SFX_OBJECTBAR_OBJECT, SW_RES(RID_BEZIER_TOOLBOX));
/*N*/ 	SFX_OBJECTMENU_REGISTRATION(SID_OBJECTMENU0, SW_RES(MN_OBJECTMENU_DRAW));
/*N*/ }

//STRIP001 TYPEINIT1(SwBezierShell,SwBaseShell)

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/


//STRIP001 SwBezierShell::SwBezierShell(SwView &rView):
//STRIP001 	SwBaseShell( rView )
//STRIP001 {
//STRIP001 	SetName(C2S("Bezier"));
//STRIP001 	SetHelpId(SW_BEZIERSHELL);
//STRIP001 
//STRIP001 	SwWrtShell *pSh = &GetShell();
//STRIP001 	SdrView*	pSdrView = pSh->GetDrawView();
//STRIP001 	pSdrView->SetEliminatePolyPointLimitAngle(1500L);
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/


//STRIP001 void SwBezierShell::Execute(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	SwWrtShell *pSh = &GetShell();
//STRIP001 	SdrView*	pSdrView = pSh->GetDrawView();
//STRIP001 	const SfxItemSet *pArgs = rReq.GetArgs();
//STRIP001 	USHORT		nSlotId = rReq.GetSlot();
//STRIP001 	BOOL		bChanged = pSdrView->GetModel()->IsChanged();
//STRIP001 	pSdrView->GetModel()->SetChanged(FALSE);
//STRIP001 	const SfxPoolItem* pItem;
//STRIP001 	if(pArgs)
//STRIP001 		pArgs->GetItemState(nSlotId, FALSE, &pItem);
//STRIP001 
//STRIP001 	switch (nSlotId)
//STRIP001 	{
//STRIP001 		case SID_DELETE:
//STRIP001 		case FN_BACKSPACE:
//STRIP001 			if (pSh->IsObjSelected())
//STRIP001 			{
//STRIP001 				if (pSdrView->HasMarkedPoints())
//STRIP001 					pSh->GetView().GetViewFrame()->GetDispatcher()->Execute(SID_BEZIER_DELETE, FALSE);
//STRIP001 				else
//STRIP001 				{
//STRIP001 					pSh->DelSelectedObj();
//STRIP001 					if (pSh->IsSelFrmMode())
//STRIP001 					{
//STRIP001 						pSh->LeaveSelFrmMode();
//STRIP001 						pSh->NoEdit();
//STRIP001 					}
//STRIP001 					GetView().AttrChangedNotify(pSh); // ggf Shellwechsel...
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FN_ESCAPE:
//STRIP001 			if (pSdrView->HasMarkedPoints())
//STRIP001 				pSdrView->UnmarkAllPoints();
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if ( pSh->IsDrawCreate() )
//STRIP001 				{
//STRIP001 					GetView().GetDrawFuncPtr()->BreakCreate();
//STRIP001 					GetView().AttrChangedNotify(pSh); // ggf Shellwechsel...
//STRIP001 				}
//STRIP001 				else if ( pSh->HasSelection() || GetView().IsDrawMode() )
//STRIP001 				{
//STRIP001 					GetView().LeaveDrawCreate();
//STRIP001 					pSh->EnterStdMode();
//STRIP001 					GetView().AttrChangedNotify(pSh); // ggf Shellwechsel...
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_BEZIER_MOVE:
//STRIP001 		case SID_BEZIER_INSERT:
//STRIP001 			{
//STRIP001 				GetView().GetEditWin().SetBezierMode(nSlotId);
//STRIP001 				static USHORT __READONLY_DATA aInva[] =
//STRIP001 								{
//STRIP001 									SID_BEZIER_INSERT,
//STRIP001 									SID_BEZIER_MOVE,
//STRIP001 									0
//STRIP001 								};
//STRIP001 				GetView().GetViewFrame()->GetBindings().Invalidate(aInva);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_BEZIER_DELETE:
//STRIP001 		case SID_BEZIER_CUTLINE:
//STRIP001 		case SID_BEZIER_CONVERT:
//STRIP001 		case SID_BEZIER_EDGE:
//STRIP001 		case SID_BEZIER_SMOOTH:
//STRIP001 		case SID_BEZIER_SYMMTR:
//STRIP001 		case SID_BEZIER_CLOSE:
//STRIP001 		case SID_BEZIER_ELIMINATE_POINTS:
//STRIP001 		{
//STRIP001 			const SdrMarkList& rMarkList = pSdrView->GetMarkList();
//STRIP001 
//STRIP001 			if (rMarkList.GetMark(0) && !pSdrView->IsAction())
//STRIP001 			{
//STRIP001 				switch (nSlotId)
//STRIP001 				{
//STRIP001 					case SID_BEZIER_DELETE:
//STRIP001 						pSdrView->DeleteMarkedPoints();
//STRIP001 						break;
//STRIP001 
//STRIP001 					case SID_BEZIER_CUTLINE:
//STRIP001 						{
//STRIP001 							pSdrView->RipUpAtMarkedPoints();
//STRIP001 							pSh->CheckUnboundObjects();
//STRIP001 						}
//STRIP001 						break;
//STRIP001 
//STRIP001 					case SID_BEZIER_CONVERT:
//STRIP001 					{
//STRIP001 						pSdrView->SetMarkedSegmentsKind(SDRPATHSEGMENT_TOGGLE);
//STRIP001 						break;
//STRIP001 					}
//STRIP001 
//STRIP001 					case SID_BEZIER_EDGE:
//STRIP001 					case SID_BEZIER_SMOOTH:
//STRIP001 					case SID_BEZIER_SYMMTR:
//STRIP001 					{
//STRIP001 						SdrPathSmoothKind eKind;
//STRIP001 
//STRIP001 						switch (nSlotId)
//STRIP001 						{
//STRIP001 							case SID_BEZIER_EDGE:   eKind = SDRPATHSMOOTH_ANGULAR; break;
//STRIP001 							case SID_BEZIER_SMOOTH: eKind = SDRPATHSMOOTH_ASYMMETRIC; break;
//STRIP001 							case SID_BEZIER_SYMMTR: eKind = SDRPATHSMOOTH_SYMMETRIC; break;
//STRIP001 						}
//STRIP001 
//STRIP001 						SdrPathSmoothKind eSmooth = pSdrView->GetMarkedPointsSmooth();
//STRIP001 						if (eKind != eSmooth)
//STRIP001 						{
//STRIP001 							pSdrView->SetMarkedPointsSmooth(eKind);
//STRIP001 
//STRIP001 							static USHORT __READONLY_DATA aInva[] =
//STRIP001 											{
//STRIP001 												SID_BEZIER_SMOOTH,
//STRIP001 												SID_BEZIER_EDGE,
//STRIP001 												SID_BEZIER_SYMMTR,
//STRIP001 												0
//STRIP001 											};
//STRIP001 							GetView().GetViewFrame()->GetBindings().Invalidate(aInva);
//STRIP001 						}
//STRIP001 						break;
//STRIP001 					}
//STRIP001 
//STRIP001 					case SID_BEZIER_CLOSE:
//STRIP001 					{
//STRIP001 						SdrPathObj* pPathObj = (SdrPathObj*) rMarkList.GetMark(0)->GetObj();
//STRIP001 						pSdrView->UnmarkAllPoints();
//STRIP001 						Size aDist(GetView().GetEditWin().PixelToLogic(Size(8,8)));
//STRIP001 						pPathObj->ToggleClosed(aDist.Width());
//STRIP001 						break;
//STRIP001 					}
//STRIP001 
//STRIP001 					case SID_BEZIER_ELIMINATE_POINTS:
//STRIP001 						pSdrView->SetEliminatePolyPoints(!pSdrView->IsEliminatePolyPoints());
//STRIP001 						break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pSdrView->GetModel()->IsChanged())
//STRIP001 		GetShell().SetModified();
//STRIP001 	else if (bChanged)
//STRIP001 		pSdrView->GetModel()->SetChanged(TRUE);
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/


//STRIP001 void SwBezierShell::GetState(SfxItemSet &rSet)
//STRIP001 {
//STRIP001 	SdrView* pSdrView = GetShell().GetDrawView();
//STRIP001 
//STRIP001 	SfxWhichIter aIter( rSet );
//STRIP001 	USHORT nWhich = aIter.FirstWhich();
//STRIP001 
//STRIP001 	while( nWhich )
//STRIP001 	{
//STRIP001 		switch( nWhich )
//STRIP001 		{
//STRIP001 			case SID_BEZIER_MOVE:
//STRIP001 			case SID_BEZIER_INSERT:
//STRIP001 			{
//STRIP001 				USHORT nEditMode = GetView().GetEditWin().GetBezierMode();
//STRIP001 
//STRIP001 				rSet.Put(SfxBoolItem(nWhich, nEditMode == nWhich));
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case SID_BEZIER_CUTLINE:
//STRIP001 				if (!pSdrView->IsRipUpAtMarkedPointsPossible())
//STRIP001 				{
//STRIP001 					rSet.DisableItem(SID_BEZIER_CUTLINE);
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_BEZIER_DELETE:
//STRIP001 				if (!pSdrView->IsDeleteMarkedPointsPossible())
//STRIP001 				{
//STRIP001 					rSet.DisableItem(SID_BEZIER_DELETE);
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_BEZIER_CONVERT:
//STRIP001 				if (!pSdrView->IsSetMarkedSegmentsKindPossible())
//STRIP001 				{
//STRIP001 					rSet.DisableItem(SID_BEZIER_CONVERT);
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					SdrPathSegmentKind eSegm = pSdrView->GetMarkedSegmentsKind();
//STRIP001 					switch (eSegm)
//STRIP001 					{
//STRIP001 						case SDRPATHSEGMENT_DONTCARE: rSet.InvalidateItem(SID_BEZIER_CONVERT); break;
//STRIP001 						case SDRPATHSEGMENT_LINE    : rSet.Put(SfxBoolItem(SID_BEZIER_CONVERT,FALSE)); break; // Button reingedrueckt = Kurve
//STRIP001 						case SDRPATHSEGMENT_CURVE   : rSet.Put(SfxBoolItem(SID_BEZIER_CONVERT,TRUE));  break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_BEZIER_EDGE:
//STRIP001 			case SID_BEZIER_SMOOTH:
//STRIP001 			case SID_BEZIER_SYMMTR:
//STRIP001 				if (!pSdrView->IsSetMarkedPointsSmoothPossible())
//STRIP001 					rSet.DisableItem(nWhich);
//STRIP001 				else
//STRIP001 				{
//STRIP001 					SdrPathSmoothKind eSmooth = pSdrView->GetMarkedPointsSmooth();
//STRIP001 					BOOL bEnable = FALSE;
//STRIP001 					switch (eSmooth)
//STRIP001 					{
//STRIP001 						case SDRPATHSMOOTH_DONTCARE  :
//STRIP001 							break;
//STRIP001 						case SDRPATHSMOOTH_ANGULAR   :
//STRIP001 							bEnable = nWhich == SID_BEZIER_EDGE;
//STRIP001 							break;
//STRIP001 						case SDRPATHSMOOTH_ASYMMETRIC:
//STRIP001 							bEnable = nWhich == SID_BEZIER_SMOOTH;
//STRIP001 							break;
//STRIP001 						case SDRPATHSMOOTH_SYMMETRIC :
//STRIP001 							bEnable = nWhich == SID_BEZIER_SYMMTR;
//STRIP001 							break;
//STRIP001 					}
//STRIP001 					rSet.Put(SfxBoolItem(nWhich, bEnable));
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_BEZIER_CLOSE:
//STRIP001 				if (!pSdrView->IsOpenCloseMarkedObjectsPossible())
//STRIP001 				{
//STRIP001 					rSet.DisableItem(SID_BEZIER_CLOSE);
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					SdrObjClosedKind eClose = pSdrView->GetMarkedObjectsClosedState();
//STRIP001 					switch (eClose)
//STRIP001 					{
//STRIP001 						case SDROBJCLOSED_DONTCARE: rSet.InvalidateItem(SID_BEZIER_CLOSE); break;
//STRIP001 						case SDROBJCLOSED_OPEN    : rSet.Put(SfxBoolItem(SID_BEZIER_CLOSE,FALSE)); break;
//STRIP001 						case SDROBJCLOSED_CLOSED  : rSet.Put(SfxBoolItem(SID_BEZIER_CLOSE,TRUE)); break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_BEZIER_ELIMINATE_POINTS:
//STRIP001 				rSet.Put(SfxBoolItem(SID_BEZIER_ELIMINATE_POINTS, pSdrView->IsEliminatePolyPoints()));
//STRIP001 				break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 }



}
