/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_swdbtoolsclient.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 04:29:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

//STRIP001 #ifndef _COM_SUN_STAR_SDBC_XCONNECTION_HPP_
//STRIP001 #include <com/sun/star/sdbc/XConnection.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_UTIL_XNUMBERFORMATSSUPPLIER_HPP_
//STRIP001 #include <com/sun/star/util/XNumberFormatsSupplier.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_SDBC_XDATASOURCE_HPP_
//STRIP001 #include <com/sun/star/sdbc/XDataSource.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_SDB_SQLCONTEXT_HPP_
//STRIP001 #include <com/sun/star/sdb/SQLContext.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _SWDBTOOLSCLIENT_HXX
//STRIP001 #include <swdbtoolsclient.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _OSL_DIAGNOSE_H_
//STRIP001 #include <osl/diagnose.h>
//STRIP001 #endif

//........................................................................

//STRIP001 using namespace ::connectivity::simple;
//STRIP001 using namespace ::com::sun::star::sdbc;
//STRIP001 using namespace ::com::sun::star::lang;
//STRIP001 using namespace ::com::sun::star::util;
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 using namespace ::com::sun::star::beans;
//STRIP001 using namespace ::com::sun::star::sdb;

//====================================================================
//= SwDbtoolsClient
//====================================================================
//STRIP001 namespace
//STRIP001 {
//STRIP001 	// -----------------------------------------------------------------------------
//STRIP001 	// this namespace contains access to all static members of the class SwDbtoolsClient
//STRIP001 	// to make the initialize of the dll a little bit faster
//STRIP001 	// -----------------------------------------------------------------------------
//STRIP001 	::osl::Mutex& getDbtoolsClientMutex()
//STRIP001 	{
//STRIP001 		static  ::osl::Mutex aMutex;
//STRIP001 		return aMutex;
//STRIP001 	}
//STRIP001 	// -----------------------------------------------------------------------------
//STRIP001 	sal_Int32& getDbToolsClientClients()
//STRIP001 	{
//STRIP001 		static  sal_Int32 nClients = 0;
//STRIP001 		return nClients;
//STRIP001 	}
//STRIP001 	// -----------------------------------------------------------------------------
//STRIP001 	oslModule& getDbToolsClientModule()
//STRIP001 	{
//STRIP001 		static oslModule hDbtoolsModule = NULL;
//STRIP001 		return hDbtoolsModule;
//STRIP001 	}
//STRIP001 	// -----------------------------------------------------------------------------
//STRIP001 	createDataAccessToolsFactoryFunction& getDbToolsClientFactoryFunction()
//STRIP001 	{
//STRIP001 		static createDataAccessToolsFactoryFunction pFactoryCreationFunc = NULL;
//STRIP001 		return pFactoryCreationFunc;
//STRIP001 	}
//STRIP001 	// -----------------------------------------------------------------------------
//STRIP001 }
// -----------------------------------------------------------------------------
//STRIP001 SwDbtoolsClient::SwDbtoolsClient()
//STRIP001 {
//STRIP001 }

//--------------------------------------------------------------------
//STRIP001 SwDbtoolsClient::~SwDbtoolsClient()
//STRIP001 {
//STRIP001     if(m_xDataAccessFactory.is())
//STRIP001     {
//STRIP001         // clear the factory _before_ revoking the client
//STRIP001         // (the revocation may unload the DBT lib)
//STRIP001         m_xDataAccessFactory = NULL;
//STRIP001         // revoke the client
//STRIP001         revokeClient();
//STRIP001     }
//STRIP001 }

//--------------------------------------------------------------------
//STRIP001 void SwDbtoolsClient::registerClient()
//STRIP001 {
//STRIP001     ::osl::MutexGuard aGuard(getDbtoolsClientMutex());
//STRIP001     if (1 == ++getDbToolsClientClients())
//STRIP001     {
//STRIP001         OSL_ENSURE(NULL == getDbToolsClientModule(), "SwDbtoolsClient::registerClient: inconsistence: already have a module!");
//STRIP001         OSL_ENSURE(NULL == getDbToolsClientFactoryFunction(), "SwDbtoolsClient::registerClient: inconsistence: already have a factory function!");
//STRIP001 
//STRIP001         const ::rtl::OUString sModuleName = ::rtl::OUString::createFromAscii(
//STRIP001             SAL_MODULENAME( "dbtools2" )
//STRIP001         );
//STRIP001 
//STRIP001         // load the dbtools library
//STRIP001         getDbToolsClientModule() = osl_loadModule(sModuleName.pData, 0);
//STRIP001         OSL_ENSURE(NULL != getDbToolsClientModule(), "SwDbtoolsClient::registerClient: could not load the dbtools library!");
//STRIP001         if (NULL != getDbToolsClientModule())
//STRIP001         {
//STRIP001             // get the symbol for the method creating the factory
//STRIP001             const ::rtl::OUString sFactoryCreationFunc = ::rtl::OUString::createFromAscii("createDataAccessToolsFactory");
//STRIP001             getDbToolsClientFactoryFunction() = reinterpret_cast<createDataAccessToolsFactoryFunction>(
//STRIP001                 osl_getSymbol(getDbToolsClientModule(), sFactoryCreationFunc.pData));
//STRIP001 
//STRIP001             if (NULL == getDbToolsClientFactoryFunction())
//STRIP001             {   // did not find the symbol
//STRIP001                 OSL_ENSURE(sal_False, "SwDbtoolsClient::registerClient: could not find the symbol for creating the factory!");
//STRIP001                 osl_unloadModule(getDbToolsClientModule());
//STRIP001                 getDbToolsClientModule() = NULL;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 }

//--------------------------------------------------------------------
//STRIP001 void SwDbtoolsClient::revokeClient()
//STRIP001 {
//STRIP001     ::osl::MutexGuard aGuard(getDbtoolsClientMutex());
//STRIP001     if (0 == --getDbToolsClientClients())
//STRIP001     {
//STRIP001         getDbToolsClientFactoryFunction() = NULL;
//STRIP001         if (getDbToolsClientModule())
//STRIP001             osl_unloadModule(getDbToolsClientModule());
//STRIP001         getDbToolsClientModule() = NULL;
//STRIP001     }
//STRIP001 }
/* -----------------------------30.08.2001 14:58------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SwDbtoolsClient::getFactory()
//STRIP001 {
//STRIP001     if(!m_xDataAccessFactory.is())
//STRIP001     {
//STRIP001         registerClient();
//STRIP001         if(getDbToolsClientFactoryFunction())
//STRIP001 		{	// loading the lib succeeded
//STRIP001             void* pUntypedFactory = (*getDbToolsClientFactoryFunction())();
//STRIP001 			IDataAccessToolsFactory* pDBTFactory = static_cast<IDataAccessToolsFactory*>(pUntypedFactory);
//STRIP001             OSL_ENSURE(pDBTFactory, "SwDbtoolsClient::SwDbtoolsClient: no factory returned!");
//STRIP001 			if (pDBTFactory)
//STRIP001 			{
//STRIP001 				m_xDataAccessFactory = pDBTFactory;
//STRIP001 				// by definition, the factory was aquired once
//STRIP001 				m_xDataAccessFactory->release();
//STRIP001 			}
//STRIP001 		}
//STRIP001     }
//STRIP001 }
/* -----------------------------30.08.2001 11:32------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 ::rtl::Reference< ::connectivity::simple::IDataAccessTools >
//STRIP001     SwDbtoolsClient::getDataAccessTools()
//STRIP001 {
//STRIP001     if(!m_xDataAccessTools.is())
//STRIP001     {
//STRIP001         getFactory();
//STRIP001         if(m_xDataAccessFactory.is())
//STRIP001             m_xDataAccessTools = m_xDataAccessFactory->getDataAccessTools();
//STRIP001     }
//STRIP001     return m_xDataAccessTools;
//STRIP001 }
/* -----------------------------30.08.2001 12:40------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 ::rtl::Reference< ::connectivity::simple::IDataAccessTypeConversion >
//STRIP001     SwDbtoolsClient::getAccessTypeConversion()
//STRIP001 {
//STRIP001     if(!m_xAccessTypeConversion.is())
//STRIP001     {
//STRIP001         getFactory();
//STRIP001         if(m_xDataAccessFactory.is())
//STRIP001             m_xAccessTypeConversion = m_xDataAccessFactory->getTypeConversionHelper();
//STRIP001     }
//STRIP001     return m_xAccessTypeConversion;
//STRIP001 }

/* -----------------------------30.08.2001 11:37------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 Reference< XDataSource > SwDbtoolsClient::getDataSource(
//STRIP001         const ::rtl::OUString& rRegisteredName,
//STRIP001         const Reference< XMultiServiceFactory>& xFactory
//STRIP001             )
//STRIP001 {
//STRIP001     Reference< XDataSource > xRet;
//STRIP001     ::rtl::Reference< ::connectivity::simple::IDataAccessTools >    xAccess = getDataAccessTools();
//STRIP001     if(xAccess.is())
//STRIP001         xRet = xAccess->getDataSource(rRegisteredName, xFactory);
//STRIP001     return xRet;
//STRIP001 }
/* -----------------------------30.08.2001 12:06------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 sal_Int32 SwDbtoolsClient::getDefaultNumberFormat(
//STRIP001         const Reference< XPropertySet >& rxColumn,
//STRIP001         const Reference< XNumberFormatTypes >& rxTypes,
//STRIP001         const Locale& rLocale
//STRIP001             )
//STRIP001 {
//STRIP001     sal_Int32 nRet = -1;
//STRIP001     ::rtl::Reference< ::connectivity::simple::IDataAccessTools >    xAccess = getDataAccessTools();
//STRIP001     if(xAccess.is())
//STRIP001         nRet = xAccess->getDefaultNumberFormat( rxColumn, rxTypes, rLocale);
//STRIP001     return nRet;
//STRIP001 }
/* -----------------------------30.08.2001 12:38------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 ::rtl::OUString SwDbtoolsClient::getValue(
//STRIP001         const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet>& _rxColumn,
//STRIP001         const ::com::sun::star::uno::Reference< ::com::sun::star::util::XNumberFormatter>& _rxFormatter,
//STRIP001         const ::com::sun::star::lang::Locale& _rLocale,
//STRIP001         const ::com::sun::star::util::Date& _rNullDate
//STRIP001             )
//STRIP001 
//STRIP001 {
//STRIP001     ::rtl::Reference< ::connectivity::simple::IDataAccessTypeConversion > xConversion =
//STRIP001                     getAccessTypeConversion();
//STRIP001     ::rtl::OUString sRet;
//STRIP001     if(xConversion.is())
//STRIP001         sRet = xConversion->getValue(_rxColumn, _rxFormatter, _rLocale, _rNullDate);
//STRIP001     return sRet;
//STRIP001 }

}
