//STRIP001 #ifndef _PAGEPREVIEWLAYOUT_HXX
//STRIP001 #include <pagepreviewlayout.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _PREVWPAGE_HXX
//STRIP001 #include <prevwpage.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #include <algorithm>
//STRIP001 
//STRIP001 #ifndef _SV_WINDOW_HXX
//STRIP001 #include <vcl/window.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_OUTDEV_HXX
//STRIP001 #include <vcl/outdev.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_MAPMOD_HXX
//STRIP001 #include <vcl/mapmod.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _ROOTFRM_HXX
//STRIP001 #include <rootfrm.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _PAGEFRM_HXX
//STRIP001 #include <pagefrm.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _VIEWSH_HXX
//STRIP001 #include <viewsh.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _VIEWIMP_HXX
//STRIP001 #include <viewimp.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _VIEWOPT_HXX
//STRIP001 #include <viewopt.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SWREGION_HXX
//STRIP001 #include <swregion.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _COMCORE_HRC
//STRIP001 #include <comcore.hrc>
//STRIP001 #endif
//STRIP001 // OD 19.02.2003 #107369# - method <SwAlignRect(..)>
//STRIP001 #ifndef _FRMTOOL_HXX
//STRIP001 #include <frmtool.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 // OD 20.02.2003 #107369# - method to update statics for paint
//STRIP001 // Note: method defined in '/sw/source/core/layout/paintfrm.cxx'
//STRIP001 extern void SwCalcPixStatics( OutputDevice *pOut );
//STRIP001 
//STRIP001 // =============================================================================
//STRIP001 // methods to initialize page preview layout
//STRIP001 // =============================================================================
//STRIP001 SwPagePreviewLayout::SwPagePreviewLayout( ViewShell& _rParentViewShell,
//STRIP001                                           const SwRootFrm& _rLayoutRootFrm )
//STRIP001     : mnXFree ( 4*142 ),
//STRIP001       mnYFree ( 4*142 ),
//STRIP001       mrParentViewShell( _rParentViewShell ),
//STRIP001       mrLayoutRootFrm ( _rLayoutRootFrm )
//STRIP001 {
//STRIP001     _Clear();
namespace binfilter {
//STRIP001 }
//STRIP001 
//STRIP001 void SwPagePreviewLayout::_Clear()
//STRIP001 {
//STRIP001     mbLayoutInfoValid = mbLayoutSizesValid = mbPaintInfoValid = false;
//STRIP001 
//STRIP001     maWinSize.Width() = 0;
//STRIP001     maWinSize.Height() = 0;
//STRIP001     mnCols = mnRows = 0;
//STRIP001     // OD 19.02.2003 #107369#
//STRIP001     mbLeaveLeftTopBlank = false;
//STRIP001 
//STRIP001     _ClearPrevwLayoutSizes();
//STRIP001 
//STRIP001     mbDoesLayoutRowsFitIntoWindow = false;
//STRIP001     mbDoesLayoutColsFitIntoWindow = false;
//STRIP001 
//STRIP001     mnPaintPhyStartPageNum = 0;
//STRIP001     mnPaintStartCol = mnPaintStartRow = 0;
//STRIP001     mbNoPageVisible = false;
//STRIP001     maPaintStartPageOffset.X() = 0;
//STRIP001     maPaintStartPageOffset.Y() = 0;
//STRIP001     maPaintPreviewDocOffset.X() = 0;
//STRIP001     maPaintPreviewDocOffset.Y() = 0;
//STRIP001     maAdditionalPaintOffset.X() = 0;
//STRIP001     maAdditionalPaintOffset.Y() = 0;
//STRIP001     maPaintedPrevwDocRect.Left() = 0;
//STRIP001     maPaintedPrevwDocRect.Top() = 0;
//STRIP001     maPaintedPrevwDocRect.Right() = 0;
//STRIP001     maPaintedPrevwDocRect.Bottom() = 0;
//STRIP001     mnSelectedPageNum = 0;
//STRIP001     _ClearPrevwPageData();
//STRIP001 }
//STRIP001 
//STRIP001 void SwPagePreviewLayout::_ClearPrevwLayoutSizes()
//STRIP001 {
//STRIP001     mnPages = 0;
//STRIP001 
//STRIP001     maMaxPageSize.Width() = 0;
//STRIP001     maMaxPageSize.Height() = 0;
//STRIP001     maPreviewDocRect.Left() = maPreviewDocRect.Top() = 0;
//STRIP001     maPreviewDocRect.Right() = maPreviewDocRect.Bottom() = 0;
//STRIP001     mnColWidth = mnRowHeight = 0;
//STRIP001     mnPrevwLayoutWidth = mnPrevwLayoutHeight = 0;
//STRIP001 }
//STRIP001 
//STRIP001 void SwPagePreviewLayout::_ClearPrevwPageData()
//STRIP001 {
//STRIP001     for ( std::vector<PrevwPage*>::iterator aPageDelIter = maPrevwPages.begin();
//STRIP001           aPageDelIter != maPrevwPages.end();
//STRIP001           ++aPageDelIter )
//STRIP001     {
//STRIP001         delete (*aPageDelIter);
//STRIP001     }
//STRIP001     maPrevwPages.clear();
//STRIP001 }
//STRIP001 
//STRIP001 /** calculate page preview layout sizes
//STRIP001 
//STRIP001     OD 18.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 void SwPagePreviewLayout::_CalcPrevwLayoutSizes()
//STRIP001 {
//STRIP001     // calculate maximal page size; calculate also number of pages
//STRIP001 
//STRIP001     const SwPageFrm* pPage = static_cast<const SwPageFrm*>(mrLayoutRootFrm.Lower());
//STRIP001     while ( pPage )
//STRIP001     {
//STRIP001         ++mnPages;
//STRIP001         pPage->Calc();
//STRIP001         register const Size& rPageSize = pPage->Frm().SSize();
//STRIP001         if ( rPageSize.Width() > maMaxPageSize.Width() )
//STRIP001             maMaxPageSize.Width() = rPageSize.Width();
//STRIP001         if ( rPageSize.Height() > maMaxPageSize.Height() )
//STRIP001             maMaxPageSize.Height() = rPageSize.Height();
//STRIP001         pPage = static_cast<const SwPageFrm*>(pPage->GetNext());
//STRIP001     }
//STRIP001     // calculate and set column width and row height
//STRIP001     mnColWidth = maMaxPageSize.Width() + mnXFree;
//STRIP001     mnRowHeight = maMaxPageSize.Height() + mnYFree;
//STRIP001 
//STRIP001     // calculate and set preview layout width and height
//STRIP001     mnPrevwLayoutWidth = mnCols * mnColWidth + mnXFree;
//STRIP001     mnPrevwLayoutHeight = mnRows * mnRowHeight + mnYFree;
//STRIP001 
//STRIP001     // calculate document rectangle in preview layout
//STRIP001     {
//STRIP001         Size aDocSize;
//STRIP001         // document width
//STRIP001         aDocSize.Width() = mnPrevwLayoutWidth;
//STRIP001 
//STRIP001         // document height
//STRIP001         // determine number of rows needed for <nPages> in preview layout
//STRIP001         // OD 19.02.2003 #107369# - use method <GetRowOfPage(..)>.
//STRIP001         sal_uInt16 nDocRows = GetRowOfPage( mnPages );
//STRIP001         aDocSize.Height() = nDocRows * maMaxPageSize.Height() +
//STRIP001                             (nDocRows+1) * mnYFree;
//STRIP001         maPreviewDocRect.SetPos( Point( 0, 0 ) );
//STRIP001         maPreviewDocRect.SetSize( aDocSize );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 /** init page preview layout
//STRIP001 
//STRIP001     OD 11.12.2002 #103492#
//STRIP001     initialize the page preview settings for a given layout.
//STRIP001     side effects:
//STRIP001     (1) If parameter <_bCalcScale> is true, mapping mode with calculated
//STRIP001     scaling is set at the output device and the zoom at the view options of
//STRIP001     the given view shell is set with the calculated scaling.
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 bool SwPagePreviewLayout::Init( const sal_uInt16 _nCols,
//STRIP001                                 const sal_uInt16 _nRows,
//STRIP001                                 const Size&      _rPxWinSize,
//STRIP001                                 const bool       _bCalcScale
//STRIP001                               )
//STRIP001 {
//STRIP001     // check environment and parameters
//STRIP001     {
//STRIP001         bool bColsRowsValid = (_nCols != 0) && (_nRows != 0);
//STRIP001         ASSERT( bColsRowsValid, "preview layout parameters not correct - preview layout can *not* be initialized" );
//STRIP001         if ( !bColsRowsValid )
//STRIP001             return false;
//STRIP001 
//STRIP001         bool bPxWinSizeValid = (_rPxWinSize.Width() >= 0) &&
//STRIP001                                (_rPxWinSize.Height() >= 0);
//STRIP001         ASSERT( bPxWinSizeValid, "no window size - preview layout can *not* be initialized" );
//STRIP001         if ( !bPxWinSizeValid )
//STRIP001             return false;
//STRIP001     }
//STRIP001 
//STRIP001     // environment and parameters ok
//STRIP001 
//STRIP001     // clear existing preview settings
//STRIP001     _Clear();
//STRIP001 
//STRIP001     // set layout information columns and rows
//STRIP001     mnCols = _nCols;
//STRIP001     mnRows = _nRows;
//STRIP001 
//STRIP001     _CalcPrevwLayoutSizes();
//STRIP001 
//STRIP001     // validate layout information
//STRIP001     mbLayoutInfoValid = true;
//STRIP001 
//STRIP001     if ( _bCalcScale )
//STRIP001     {
//STRIP001         // calculate scaling
//STRIP001         MapMode aMapMode( MAP_TWIP );
//STRIP001         Size aWinSize = mrParentViewShell.GetOut()->PixelToLogic( _rPxWinSize, aMapMode );
//STRIP001         Fraction aXScale( aWinSize.Width(), mnPrevwLayoutWidth );
//STRIP001         Fraction aYScale( aWinSize.Height(), mnPrevwLayoutHeight );
//STRIP001         if( aXScale < aYScale )
//STRIP001             aYScale = aXScale;
//STRIP001         {
//STRIP001             // adjust scaling for Drawing layer.
//STRIP001             aYScale *= Fraction( 1000, 1 );
//STRIP001             long nNewNuminator = aYScale.operator long();
//STRIP001             if( nNewNuminator < 1 )
//STRIP001                 nNewNuminator = 1;
//STRIP001             aYScale = Fraction( nNewNuminator, 1000 );
//STRIP001             // propagate scaling as zoom percentage to view options for font cache
//STRIP001             _ApplyNewZoomAtViewShell( static_cast<sal_uInt8>(nNewNuminator/10) );
//STRIP001         }
//STRIP001         aMapMode.SetScaleY( aYScale );
//STRIP001         aMapMode.SetScaleX( aYScale );
//STRIP001         // set created mapping mode with calculated scaling at output device.
//STRIP001         mrParentViewShell.GetOut()->SetMapMode( aMapMode );
//STRIP001         // OD 20.02.2003 #107369# - update statics for paint.
//STRIP001         ::SwCalcPixStatics( mrParentViewShell.GetOut() );
//STRIP001     }
//STRIP001 
//STRIP001     // set window size in twips
//STRIP001     maWinSize = mrParentViewShell.GetOut()->PixelToLogic( _rPxWinSize );
//STRIP001     // validate layout sizes
//STRIP001     mbLayoutSizesValid = true;
//STRIP001 
//STRIP001     return true;
//STRIP001 }
//STRIP001 
//STRIP001 /** apply new zoom at given view shell
//STRIP001 
//STRIP001     OD 11.12.2002 #103492# - implementation of <_ApplyNewZoomAtViewShell>
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 void SwPagePreviewLayout::_ApplyNewZoomAtViewShell( sal_uInt8 _aNewZoom )
//STRIP001 {
//STRIP001     SwViewOption aNewViewOptions = *(mrParentViewShell.GetViewOptions());
//STRIP001     if ( aNewViewOptions.GetZoom() != _aNewZoom )
//STRIP001     {
//STRIP001         aNewViewOptions.SetZoom( _aNewZoom );
//STRIP001         mrParentViewShell.ApplyViewOptions( aNewViewOptions );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 /** method to adjust page preview layout to document changes
//STRIP001 
//STRIP001     OD 18.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 bool SwPagePreviewLayout::ReInit()
//STRIP001 {
//STRIP001     // check environment and parameters
//STRIP001     {
//STRIP001         bool bLayoutSettingsValid = mbLayoutInfoValid && mbLayoutSizesValid;
//STRIP001         ASSERT( bLayoutSettingsValid,
//STRIP001                 "no valid preview layout info/sizes - no re-init of page preview layout");
//STRIP001         if ( !bLayoutSettingsValid )
//STRIP001             return false;
//STRIP001     }
//STRIP001 
//STRIP001     _ClearPrevwLayoutSizes();
//STRIP001     _CalcPrevwLayoutSizes();
//STRIP001 
//STRIP001     return true;
//STRIP001 }
//STRIP001 
//STRIP001 // =============================================================================
//STRIP001 // methods to prepare paint of page preview
//STRIP001 // =============================================================================
//STRIP001 /** prepare paint of page preview
//STRIP001 
//STRIP001     OD 12.12.2002 #103492#
//STRIP001     OD 21.03.2003 #108282# - delete parameter _onStartPageVirtNum
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 bool SwPagePreviewLayout::Prepare( const sal_uInt16 _nProposedStartPageNum,
//STRIP001                                    const Point      _aProposedStartPos,
//STRIP001                                    const Size&      _rPxWinSize,
//STRIP001                                    sal_uInt16&      _onStartPageNum,
//STRIP001                                    Rectangle&       _orDocPreviewPaintRect,
//STRIP001                                    const bool       _bStartWithPageAtFirstCol
//STRIP001                                  )
//STRIP001 {
//STRIP001     sal_uInt16 nProposedStartPageNum = _nProposedStartPageNum;
//STRIP001     // check environment and parameters
//STRIP001     {
//STRIP001         bool bLayoutSettingsValid = mbLayoutInfoValid && mbLayoutSizesValid;
//STRIP001         ASSERT( bLayoutSettingsValid,
//STRIP001                 "no valid preview layout info/sizes - no prepare of preview paint");
//STRIP001         if ( !bLayoutSettingsValid )
//STRIP001             return false;
//STRIP001 
//STRIP001         bool bStartPageRangeValid = _nProposedStartPageNum <= mnPages;
//STRIP001         ASSERT( bStartPageRangeValid,
//STRIP001                 "proposed start page not existing - no prepare of preview paint");
//STRIP001         if ( !bStartPageRangeValid )
//STRIP001             return false;
//STRIP001 
//STRIP001         bool bStartPosRangeValid =
//STRIP001                 _aProposedStartPos.X() >= 0 && _aProposedStartPos.Y() >= 0 &&
//STRIP001                 _aProposedStartPos.X() <= maPreviewDocRect.Right() &&
//STRIP001                 _aProposedStartPos.Y() <= maPreviewDocRect.Bottom();
//STRIP001         ASSERT( bStartPosRangeValid,
//STRIP001                 "proposed start position out of range - no prepare of preview paint");
//STRIP001         if ( !bStartPosRangeValid )
//STRIP001             return false;
//STRIP001 
//STRIP001         bool bWinSizeValid = _rPxWinSize.Width() != 0 && _rPxWinSize.Height() != 0;
//STRIP001         ASSERT ( bWinSizeValid, "no window size - no prepare of preview paint");
//STRIP001         if ( !bWinSizeValid )
//STRIP001             return false;
//STRIP001 
//STRIP001         bool bStartInfoValid = _nProposedStartPageNum > 0 ||
//STRIP001                                _aProposedStartPos != Point(0,0);
//STRIP001         if ( !bStartInfoValid )
//STRIP001             nProposedStartPageNum = 1;
//STRIP001     }
//STRIP001 
//STRIP001     // environment and parameter ok
//STRIP001 
//STRIP001     // update window size at preview setting data
//STRIP001     maWinSize = mrParentViewShell.GetOut()->PixelToLogic( _rPxWinSize );
//STRIP001 
//STRIP001     mbNoPageVisible = false;
//STRIP001     if ( nProposedStartPageNum > 0 )
//STRIP001     {
//STRIP001         // determine column and row of proposed start page in virtual preview layout
//STRIP001         sal_uInt16 nColOfProposed = GetColOfPage( nProposedStartPageNum );
//STRIP001         sal_uInt16 nRowOfProposed = GetRowOfPage( nProposedStartPageNum );
//STRIP001         // determine start page
//STRIP001         if ( _bStartWithPageAtFirstCol )
//STRIP001         {
//STRIP001             // OD 19.02.2003 #107369# - leaving left-top-corner blank is
//STRIP001             // controlled by <mbLeaveLeftTopBlank>.
//STRIP001             if ( mbLeaveLeftTopBlank &&
//STRIP001                  ( nProposedStartPageNum == 1 || nRowOfProposed == 1 )
//STRIP001                )
//STRIP001                 mnPaintPhyStartPageNum = 1;
//STRIP001             else
//STRIP001                 mnPaintPhyStartPageNum = nProposedStartPageNum - (nColOfProposed-1);
//STRIP001         }
//STRIP001         else
//STRIP001             mnPaintPhyStartPageNum = nProposedStartPageNum;
//STRIP001         // set starting column
//STRIP001         if ( _bStartWithPageAtFirstCol )
//STRIP001             mnPaintStartCol = 1;
//STRIP001         else
//STRIP001             mnPaintStartCol = nColOfProposed;
//STRIP001         // set starting row
//STRIP001         mnPaintStartRow = nRowOfProposed;
//STRIP001         // page offset == (-1,-1), indicating no offset and paint of free space.
//STRIP001         maPaintStartPageOffset.X() = -1;
//STRIP001         maPaintStartPageOffset.Y() = -1;
//STRIP001         // virtual preview document offset.
//STRIP001         if ( _bStartWithPageAtFirstCol )
//STRIP001             maPaintPreviewDocOffset.X() = 0;
//STRIP001         else
//STRIP001             maPaintPreviewDocOffset.X() = (nColOfProposed-1) * mnColWidth;
//STRIP001         maPaintPreviewDocOffset.Y() = (nRowOfProposed-1) * mnRowHeight;
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         // determine column and row of proposed start position.
//STRIP001         // Note: paint starts at point (0,0)
//STRIP001         sal_uInt16 nColOfProposed =
//STRIP001                 static_cast<sal_uInt16>(_aProposedStartPos.X() / mnColWidth) + 1;
//STRIP001         sal_uInt16 nRowOfProposed =
//STRIP001                 static_cast<sal_uInt16>(_aProposedStartPos.Y() / mnRowHeight) + 1;
//STRIP001         // determine start page == page at proposed start position
//STRIP001         // OD 19.02.2003 #107369# - leaving left-top-corner blank is
//STRIP001         // controlled by <mbLeaveLeftTopBlank>.
//STRIP001         if ( mbLeaveLeftTopBlank &&
//STRIP001              ( nRowOfProposed == 1 && nColOfProposed == 1 )
//STRIP001            )
//STRIP001             mnPaintPhyStartPageNum = 1;
//STRIP001         else
//STRIP001         {
//STRIP001             // OD 19.02.2003 #107369# - leaving left-top-corner blank is
//STRIP001             // controlled by <mbLeaveLeftTopBlank>.
//STRIP001             mnPaintPhyStartPageNum = (nRowOfProposed-1) * mnCols + nColOfProposed;
//STRIP001             if ( mbLeaveLeftTopBlank )
//STRIP001                 --mnPaintPhyStartPageNum;
//STRIP001             if ( mnPaintPhyStartPageNum > mnPages )
//STRIP001             {
//STRIP001                 // no page will be visible, because shown part of document
//STRIP001                 // preview is the last row to the right of the last page
//STRIP001                 mnPaintPhyStartPageNum = mnPages;
//STRIP001                 mbNoPageVisible = true;
//STRIP001             }
//STRIP001         }
//STRIP001         // set starting column and starting row
//STRIP001         mnPaintStartCol = nColOfProposed;
//STRIP001         mnPaintStartRow = nRowOfProposed;
//STRIP001         // page offset
//STRIP001         maPaintStartPageOffset.X() =
//STRIP001                 (_aProposedStartPos.X() % mnColWidth) - mnXFree;
//STRIP001         maPaintStartPageOffset.Y() =
//STRIP001                 (_aProposedStartPos.Y() % mnRowHeight) - mnYFree;
//STRIP001         // virtual preview document offset.
//STRIP001         maPaintPreviewDocOffset = _aProposedStartPos;
//STRIP001     }
//STRIP001 
//STRIP001     // determine additional paint offset, if preview layout fits into window.
//STRIP001     _CalcAdditionalPaintOffset();
//STRIP001 
//STRIP001     // determine rectangle to be painted from document preview
//STRIP001     _CalcDocPrevwPaintRect();
//STRIP001     _orDocPreviewPaintRect = maPaintedPrevwDocRect;
//STRIP001 
//STRIP001     // OD 20.01.2003 #103492# - shift visible preview document area to the left,
//STRIP001     // if on the right is an area left blank.
//STRIP001     if ( !mbDoesLayoutColsFitIntoWindow &&
//STRIP001          maPaintedPrevwDocRect.GetWidth() < maWinSize.Width() )
//STRIP001     {
//STRIP001         maPaintedPrevwDocRect.Move(
//STRIP001                 -(maWinSize.Width() - maPaintedPrevwDocRect.GetWidth()), 0 );
//STRIP001         Prepare( 0, maPaintedPrevwDocRect.TopLeft(),
//STRIP001                  _rPxWinSize, _onStartPageNum,
//STRIP001                  _orDocPreviewPaintRect, _bStartWithPageAtFirstCol );
//STRIP001     }
//STRIP001 
//STRIP001     /* OD 23.01.2003 - deactivate code, but not delete, because probably useful in the future
//STRIP001     // OD 20.01.2003 #103492# - shift visible preview document area to the top,
//STRIP001     // if on the botton is an area left blank.
//STRIP001     if ( maPaintedPrevwDocRect.Bottom() == maPreviewDocRect.Bottom() &&
//STRIP001          maPaintedPrevwDocRect.GetHeight() < maWinSize.Height() )
//STRIP001     {
//STRIP001         if ( mbDoesLayoutRowsFitIntoWindow )
//STRIP001         {
//STRIP001             if ( maPaintedPrevwDocRect.GetHeight() < mnPrevwLayoutHeight)
//STRIP001             {
//STRIP001                 maPaintedPrevwDocRect.Move(
//STRIP001                         0, -(mnPrevwLayoutHeight - maPaintedPrevwDocRect.GetHeight()) );
//STRIP001                 Prepare( 0, maPaintedPrevwDocRect.TopLeft(),
//STRIP001                          _rPxWinSize, _onStartPageNum, _onStartPageVirtNum,
//STRIP001                          _orDocPreviewPaintRect, _bStartWithPageAtFirstCol );
//STRIP001             }
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             maPaintedPrevwDocRect.Move(
//STRIP001                     0, -(maWinSize.Height() - maPaintedPrevwDocRect.GetHeight()) );
//STRIP001             Prepare( 0, maPaintedPrevwDocRect.TopLeft(),
//STRIP001                      _rPxWinSize, _onStartPageNum, _onStartPageVirtNum,
//STRIP001                      _orDocPreviewPaintRect, _bStartWithPageAtFirstCol );
//STRIP001         }
//STRIP001     }
//STRIP001     */
//STRIP001 
//STRIP001     // determine preview pages - visible pages with needed data for paint and
//STRIP001     // accessible pages with needed data.
//STRIP001     _CalcPreviewPages();
//STRIP001 
//STRIP001     // validate paint data
//STRIP001     mbPaintInfoValid = true;
//STRIP001 
//STRIP001     // return start page
//STRIP001     _onStartPageNum = mnPaintPhyStartPageNum;
//STRIP001     /*
//STRIP001     // return virtual page number of start page
//STRIP001     _onStartPageVirtNum = 0;
//STRIP001     if ( mnPaintPhyStartPageNum <= mnPages )
//STRIP001     {
//STRIP001         const SwPageFrm* pPage = static_cast<const SwPageFrm*>( mrLayoutRootFrm.Lower() );
//STRIP001         while ( pPage && pPage->GetPhyPageNum() < mnPaintPhyStartPageNum )
//STRIP001         {
//STRIP001             pPage = static_cast<const SwPageFrm*>( pPage->GetNext() );
//STRIP001         }
//STRIP001         if ( pPage )
//STRIP001             _onStartPageVirtNum = pPage->GetVirtPageNum();
//STRIP001     }
//STRIP001     */
//STRIP001     return true;
//STRIP001 }
//STRIP001 
//STRIP001 /** calculate additional paint offset
//STRIP001 
//STRIP001     OD 12.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 void SwPagePreviewLayout::_CalcAdditionalPaintOffset()
//STRIP001 {
//STRIP001     if ( mnPrevwLayoutWidth <= maWinSize.Width() &&
//STRIP001          maPaintStartPageOffset.X() <= 0 )
//STRIP001     {
//STRIP001         mbDoesLayoutColsFitIntoWindow = true;
//STRIP001         maAdditionalPaintOffset.X() = (maWinSize.Width() - mnPrevwLayoutWidth) / 2;
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         mbDoesLayoutColsFitIntoWindow = false;
//STRIP001         maAdditionalPaintOffset.X() = 0;
//STRIP001     }
//STRIP001 
//STRIP001     if ( mnPrevwLayoutHeight <= maWinSize.Height() &&
//STRIP001          maPaintStartPageOffset.Y() <= 0 )
//STRIP001     {
//STRIP001         mbDoesLayoutRowsFitIntoWindow = true;
//STRIP001         maAdditionalPaintOffset.Y() = (maWinSize.Height() - mnPrevwLayoutHeight) / 2;
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         mbDoesLayoutRowsFitIntoWindow = false;
//STRIP001         maAdditionalPaintOffset.Y() = 0;
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 /** calculate painted preview document rectangle
//STRIP001 
//STRIP001     OD 12.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 void SwPagePreviewLayout::_CalcDocPrevwPaintRect()
//STRIP001 {
//STRIP001     Point aTopLeftPos = maPaintPreviewDocOffset;
//STRIP001     maPaintedPrevwDocRect.SetPos( aTopLeftPos );
//STRIP001 
//STRIP001     Size aSize;
//STRIP001     if ( mbDoesLayoutColsFitIntoWindow )
//STRIP001         //aSize.Width() = mnPrevwLayoutWidth;
//STRIP001         aSize.Width() = Min( mnPrevwLayoutWidth,
//STRIP001                              maPreviewDocRect.GetWidth() - aTopLeftPos.X() );
//STRIP001     else
//STRIP001         aSize.Width() = Min( maPreviewDocRect.GetWidth() - aTopLeftPos.X(),
//STRIP001                              maWinSize.Width() - maAdditionalPaintOffset.X() );
//STRIP001     if ( mbDoesLayoutRowsFitIntoWindow )
//STRIP001         //aSize.Height() = mnPrevwLayoutHeight;
//STRIP001         aSize.Height() = Min( mnPrevwLayoutHeight,
//STRIP001                               maPreviewDocRect.GetHeight() - aTopLeftPos.Y() );
//STRIP001     else
//STRIP001         aSize.Height() = Min( maPreviewDocRect.GetHeight() - aTopLeftPos.Y(),
//STRIP001                               maWinSize.Height() - maAdditionalPaintOffset.Y() );
//STRIP001     maPaintedPrevwDocRect.SetSize( aSize );
//STRIP001     long nHTmp = maPaintedPrevwDocRect.GetHeight();
//STRIP001     long nWTmp = maPaintedPrevwDocRect.GetWidth();
//STRIP001 }
//STRIP001 
//STRIP001 /** calculate preview pages
//STRIP001 
//STRIP001     OD 12.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 void SwPagePreviewLayout::_CalcPreviewPages()
//STRIP001 {
//STRIP001     _ClearPrevwPageData();
//STRIP001 
//STRIP001     if ( mbNoPageVisible )
//STRIP001         return;
//STRIP001 
//STRIP001     // determine start page frame
//STRIP001     const SwPageFrm* pStartPage = mrLayoutRootFrm.GetPageByPageNum( mnPaintPhyStartPageNum );
//STRIP001 
//STRIP001     // calculate initial paint offset
//STRIP001     Point aInitialPaintOffset;
//STRIP001     if ( maPaintStartPageOffset != Point( -1, -1 ) )
//STRIP001         aInitialPaintOffset = Point(0,0) - maPaintStartPageOffset;
//STRIP001     else
//STRIP001         aInitialPaintOffset = Point( mnXFree, mnYFree );
//STRIP001     aInitialPaintOffset += maAdditionalPaintOffset;
//STRIP001 
//STRIP001     // prepare loop data
//STRIP001     const SwPageFrm* pPage = pStartPage;
//STRIP001     sal_uInt16 nCurrCol = mnPaintStartCol;
//STRIP001     sal_uInt16 nConsideredRows = 0;
//STRIP001     Point aCurrPaintOffset = aInitialPaintOffset;
//STRIP001     // loop on pages to determine preview background retangles
//STRIP001     while ( pPage &&
//STRIP001             (!mbDoesLayoutRowsFitIntoWindow || nConsideredRows < mnRows) &&
//STRIP001             aCurrPaintOffset.Y() < maWinSize.Height()
//STRIP001           )
//STRIP001     {
//STRIP001         pPage->Calc();
//STRIP001 
//STRIP001         // consider only pages, which have to be painted.
//STRIP001         if ( nCurrCol < mnPaintStartCol )
//STRIP001         {
//STRIP001             // calculate data of unvisible page needed for accessibility
//STRIP001             PrevwPage* pPrevwPage = new PrevwPage;
//STRIP001             Point aCurrAccOffset = aCurrPaintOffset -
//STRIP001                            Point( (mnPaintStartCol-nCurrCol) * mnColWidth, 0 );
//STRIP001             _CalcPreviewDataForPage( *(pPage), aCurrAccOffset, pPrevwPage );
//STRIP001             pPrevwPage->bVisible = false;
//STRIP001             maPrevwPages.push_back( pPrevwPage );
//STRIP001             // continue with next page and next column
//STRIP001             pPage = static_cast<const SwPageFrm*>(pPage->GetNext());
//STRIP001             ++nCurrCol;
//STRIP001             continue;
//STRIP001         }
//STRIP001         if ( aCurrPaintOffset.X() < maWinSize.Width() )
//STRIP001         {
//STRIP001             // OD 19.02.2003 #107369# - leaving left-top-corner blank is
//STRIP001             // controlled by <mbLeaveLeftTopBlank>.
//STRIP001             if ( mbLeaveLeftTopBlank &&
//STRIP001                  pPage->GetPhyPageNum() == 1 && mnCols != 1 && nCurrCol == 1
//STRIP001                )
//STRIP001             {
//STRIP001                 // first page in 2nd column
//STRIP001                 // --> continue with increased paint offset and next column
//STRIP001                 aCurrPaintOffset.X() += mnColWidth;
//STRIP001                 ++nCurrCol;
//STRIP001                 continue;
//STRIP001             }
//STRIP001 
//STRIP001             // calculate data of visible page
//STRIP001             PrevwPage* pPrevwPage = new PrevwPage;
//STRIP001             _CalcPreviewDataForPage( *(pPage), aCurrPaintOffset, pPrevwPage );
//STRIP001             pPrevwPage->bVisible = true;
//STRIP001             maPrevwPages.push_back( pPrevwPage );
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             // calculate data of unvisible page needed for accessibility
//STRIP001             PrevwPage* pPrevwPage = new PrevwPage;
//STRIP001             _CalcPreviewDataForPage( *(pPage), aCurrPaintOffset, pPrevwPage );
//STRIP001             pPrevwPage->bVisible = false;
//STRIP001             maPrevwPages.push_back( pPrevwPage );
//STRIP001         }
//STRIP001 
//STRIP001         // prepare data for next loop
//STRIP001         pPage = static_cast<const SwPageFrm*>(pPage->GetNext());
//STRIP001         aCurrPaintOffset.X() += mnColWidth;
//STRIP001         ++nCurrCol;
//STRIP001         if ( nCurrCol > mnCols )
//STRIP001         {
//STRIP001             ++nConsideredRows;
//STRIP001             aCurrPaintOffset.X() = aInitialPaintOffset.X();
//STRIP001             nCurrCol = 1;
//STRIP001             aCurrPaintOffset.Y() += mnRowHeight;
//STRIP001         }
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 /** determines preview data for a given page and a given preview offset
//STRIP001 
//STRIP001     OD 13.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 bool SwPagePreviewLayout::_CalcPreviewDataForPage( const SwPageFrm& _rPage,
//STRIP001                                                    const Point& _rPrevwOffset,
//STRIP001                                                    PrevwPage* _opPrevwPage )
//STRIP001 {
//STRIP001     // page frame
//STRIP001     _opPrevwPage->pPage = &_rPage;
//STRIP001     // size of page frame
//STRIP001     if ( _rPage.IsEmptyPage() )
//STRIP001     {
//STRIP001         if ( _rPage.GetPhyPageNum() % 2 == 0 )
//STRIP001             _opPrevwPage->aPageSize = _rPage.GetPrev()->Frm().SSize();
//STRIP001         else
//STRIP001             _opPrevwPage->aPageSize = _rPage.GetNext()->Frm().SSize();
//STRIP001     }
//STRIP001     else
//STRIP001         _opPrevwPage->aPageSize = _rPage.Frm().SSize();
//STRIP001     // position of page in preview window
//STRIP001     Point aPrevwWinOffset( _rPrevwOffset );
//STRIP001     if ( _opPrevwPage->aPageSize.Width() < maMaxPageSize.Width() )
//STRIP001         aPrevwWinOffset.X() += ( maMaxPageSize.Width() - _opPrevwPage->aPageSize.Width() ) / 2;
//STRIP001     if ( _opPrevwPage->aPageSize.Height() < maMaxPageSize.Height() )
//STRIP001         aPrevwWinOffset.Y() += ( maMaxPageSize.Height() - _opPrevwPage->aPageSize.Height() ) / 2;
//STRIP001     _opPrevwPage->aPrevwWinPos = aPrevwWinOffset;
//STRIP001     // logic position of page and mapping offset for paint
//STRIP001     if ( _rPage.IsEmptyPage() )
//STRIP001     {
//STRIP001         _opPrevwPage->aLogicPos = _opPrevwPage->aPrevwWinPos;
//STRIP001         _opPrevwPage->aMapOffset = Point( 0, 0 );
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         _opPrevwPage->aLogicPos = _rPage.Frm().Pos();
//STRIP001         _opPrevwPage->aMapOffset = _opPrevwPage->aPrevwWinPos - _opPrevwPage->aLogicPos;
//STRIP001     }
//STRIP001 
//STRIP001     return true;
//STRIP001 }
//STRIP001 
//STRIP001 // =============================================================================
//STRIP001 // methods to determine new data for changing the current shown part of the
//STRIP001 // document preview.
//STRIP001 // =============================================================================
//STRIP001 /** calculate start position for new scale
//STRIP001 
//STRIP001     OD 12.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 Point SwPagePreviewLayout::GetPreviewStartPosForNewScale(
//STRIP001                           const Fraction& _aNewScale,
//STRIP001                           const Fraction& _aOldScale,
//STRIP001                           const Size&     _aNewWinSize ) const
//STRIP001 {
//STRIP001     Point aNewPaintStartPos = maPaintedPrevwDocRect.TopLeft();
//STRIP001     if ( _aNewScale < _aOldScale )
//STRIP001     {
//STRIP001         // increase paint width by moving start point to left.
//STRIP001         if ( mnPrevwLayoutWidth < _aNewWinSize.Width() )
//STRIP001             aNewPaintStartPos.X() = 0;
//STRIP001         else if ( maPaintedPrevwDocRect.GetWidth() < _aNewWinSize.Width() )
//STRIP001         {
//STRIP001             aNewPaintStartPos.X() -=
//STRIP001                 (_aNewWinSize.Width() - maPaintedPrevwDocRect.GetWidth()) / 2;
//STRIP001             if ( aNewPaintStartPos.X() < 0)
//STRIP001                 aNewPaintStartPos.X() = 0;
//STRIP001         }
//STRIP001 
//STRIP001         if ( !mbDoesLayoutRowsFitIntoWindow )
//STRIP001         {
//STRIP001             // increase paint height by moving start point to top.
//STRIP001             if ( mnPrevwLayoutHeight < _aNewWinSize.Height() )
//STRIP001             {
//STRIP001                 aNewPaintStartPos.Y() =
//STRIP001                     ( (mnPaintStartRow - 1) * mnRowHeight );
//STRIP001             }
//STRIP001             else if ( maPaintedPrevwDocRect.GetHeight() < _aNewWinSize.Height() )
//STRIP001             {
//STRIP001                 aNewPaintStartPos.Y() -=
//STRIP001                     (_aNewWinSize.Height() - maPaintedPrevwDocRect.GetHeight()) / 2;
//STRIP001                 if ( aNewPaintStartPos.Y() < 0)
//STRIP001                     aNewPaintStartPos.Y() = 0;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         // decrease paint width by moving start point to right
//STRIP001         if ( maPaintedPrevwDocRect.GetWidth() > _aNewWinSize.Width() )
//STRIP001             aNewPaintStartPos.X() +=
//STRIP001                 (maPaintedPrevwDocRect.GetWidth() - _aNewWinSize.Width()) / 2;
//STRIP001         // decrease paint height by moving start point to bottom
//STRIP001         if ( maPaintedPrevwDocRect.GetHeight() > _aNewWinSize.Height() )
//STRIP001         {
//STRIP001             aNewPaintStartPos.Y() +=
//STRIP001                 (maPaintedPrevwDocRect.GetHeight() - _aNewWinSize.Height()) / 2;
//STRIP001             // check, if new y-position is outside document preview
//STRIP001             if ( aNewPaintStartPos.Y() > maPreviewDocRect.Bottom() )
//STRIP001                 aNewPaintStartPos.Y() =
//STRIP001                         Max( 0L, maPreviewDocRect.Bottom() - mnPrevwLayoutHeight );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return aNewPaintStartPos;
//STRIP001 }
//STRIP001 
//STRIP001 /** determines, if page with given page number is visible in preview
//STRIP001 
//STRIP001     OD 12.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 bool SwPagePreviewLayout::IsPageVisible( const sal_uInt16 _nPageNum ) const
//STRIP001 {
//STRIP001     const PrevwPage* pPrevwPage = _GetPrevwPageByPageNum( _nPageNum );
//STRIP001     return pPrevwPage && pPrevwPage->bVisible;
//STRIP001 }
//STRIP001 
//STRIP001 /** calculate data to bring new selected page into view.
//STRIP001 
//STRIP001     OD 12.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 bool SwPagePreviewLayout::CalcStartValuesForSelectedPageMove(
//STRIP001                                 const sal_Int16  _nHoriMove,
//STRIP001                                 const sal_Int16  _nVertMove,
//STRIP001                                 sal_uInt16&      _orNewSelectedPage,
//STRIP001                                 sal_uInt16&      _orNewStartPage,
//STRIP001                                 Point&           _orNewStartPos ) const
//STRIP001 {
//STRIP001     // determine position of current selected page
//STRIP001     sal_uInt16 nTmpSelPageNum = mnSelectedPageNum;
//STRIP001     // OD 19.02.2003 #107369# - leaving left-top-corner blank is controlled
//STRIP001     // by <mbLeaveLeftTopBlank>.
//STRIP001     if ( mbLeaveLeftTopBlank )
//STRIP001     {
//STRIP001         // Note: consider that left-top-corner is left blank --> +1
//STRIP001         ++nTmpSelPageNum;
//STRIP001     }
//STRIP001     sal_uInt16 nTmpCol = nTmpSelPageNum % mnCols;
//STRIP001     sal_uInt16 nCurrCol = nTmpCol > 0 ? nTmpCol : mnCols;
//STRIP001     sal_uInt16 nCurrRow = nTmpSelPageNum / mnCols;
//STRIP001     if ( nTmpCol > 0 )
//STRIP001         ++nCurrRow;
//STRIP001 
//STRIP001     // determine new selected page number
//STRIP001     sal_uInt16 nNewSelectedPageNum = mnSelectedPageNum;
//STRIP001     {
//STRIP001         if ( _nHoriMove != 0 )
//STRIP001         {
//STRIP001             if ( (nNewSelectedPageNum + _nHoriMove) < 1 )
//STRIP001                 nNewSelectedPageNum = 1;
//STRIP001             else if ( (nNewSelectedPageNum + _nHoriMove) > mnPages )
//STRIP001                 nNewSelectedPageNum = mnPages;
//STRIP001             else
//STRIP001                 nNewSelectedPageNum += _nHoriMove;
//STRIP001         }
//STRIP001         if ( _nVertMove != 0 )
//STRIP001         {
//STRIP001             if ( (nNewSelectedPageNum + (_nVertMove * mnCols)) < 1 )
//STRIP001                 nNewSelectedPageNum = 1;
//STRIP001             else if ( (nNewSelectedPageNum + (_nVertMove * mnCols)) > mnPages )
//STRIP001                 nNewSelectedPageNum = mnPages;
//STRIP001             else
//STRIP001                 nNewSelectedPageNum += ( _nVertMove * mnCols );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     sal_uInt16 nNewStartPage = mnPaintPhyStartPageNum;
//STRIP001     Point aNewStartPos = Point(0,0);
//STRIP001 
//STRIP001     if ( !IsPageVisible( nNewSelectedPageNum ) )
//STRIP001     {
//STRIP001         if ( _nHoriMove != 0 && _nVertMove != 0 )
//STRIP001         {
//STRIP001             ASSERT( false, "missing implementation for moving preview selected page horizontal AND vertical");
//STRIP001             return false;
//STRIP001         }
//STRIP001 
//STRIP001         // new selected page has to be brought into view considering current
//STRIP001         // visible preview.
//STRIP001         sal_Int16 nTotalRows = GetRowOfPage( mnPages );
//STRIP001         if ( (_nHoriMove > 0 || _nVertMove > 0) &&
//STRIP001              mbDoesLayoutRowsFitIntoWindow &&
//STRIP001              mbDoesLayoutColsFitIntoWindow && // OD 20.02.2003 #107369# - add condition
//STRIP001              nCurrRow > nTotalRows - mnRows
//STRIP001            )
//STRIP001             // new proposed start page = left-top-corner of last possible
//STRIP001             // preview page.
//STRIP001             nNewStartPage = (nTotalRows - mnRows) * mnCols + 1;
//STRIP001             // OD 19.02.2003 #107369# - leaving left-top-corner blank is controlled
//STRIP001             // by <mbLeaveLeftTopBlank>.
//STRIP001             if ( mbLeaveLeftTopBlank )
//STRIP001             {
//STRIP001                 // Note: decrease new proposed start page number by one,
//STRIP001                 // because of blank left-top-corner
//STRIP001                 --nNewStartPage;
//STRIP001             }
//STRIP001         else
//STRIP001             // new proposed start page = new selected page.
//STRIP001             nNewStartPage = nNewSelectedPageNum;
//STRIP001     }
//STRIP001 
//STRIP001     _orNewSelectedPage = nNewSelectedPageNum;
//STRIP001     _orNewStartPage = nNewStartPage;
//STRIP001     _orNewStartPos = aNewStartPos;
//STRIP001 
//STRIP001     return true;
//STRIP001 }
//STRIP001 
//STRIP001 /** checks, if given position is inside a shown document page
//STRIP001 
//STRIP001     OD 17.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 struct PrevwPosInsidePagePred
//STRIP001 {
//STRIP001     const Point mnPrevwPos;
//STRIP001     PrevwPosInsidePagePred( const Point _nPrevwPos ) : mnPrevwPos( _nPrevwPos ) {};
//STRIP001     bool operator() ( const PrevwPage* _pPrevwPage )
//STRIP001     {
//STRIP001         if ( _pPrevwPage->bVisible )
//STRIP001         {
//STRIP001             Rectangle aPrevwPageRect( _pPrevwPage->aPrevwWinPos, _pPrevwPage->aPageSize );
//STRIP001             return aPrevwPageRect.IsInside( mnPrevwPos ) ? true : false;
//STRIP001         }
//STRIP001         else
//STRIP001             return false;
//STRIP001     }
//STRIP001 };
//STRIP001 
//STRIP001 bool SwPagePreviewLayout::IsPrevwPosInDocPrevwPage( const Point  _aPrevwPos,
//STRIP001                                                     Point&       _orDocPos,
//STRIP001                                                     bool&        _obPosInEmptyPage,
//STRIP001                                                     sal_uInt16&  _onPageNum ) const
//STRIP001 {
//STRIP001     bool bIsPosInsideDoc;
//STRIP001 
//STRIP001     // initialize variable parameter values.
//STRIP001     _orDocPos.X() = 0;
//STRIP001     _orDocPos.Y() = 0;
//STRIP001     _obPosInEmptyPage = false;
//STRIP001     _onPageNum = 0;
//STRIP001 
//STRIP001     std::vector<PrevwPage*>::const_iterator aFoundPrevwPageIter =
//STRIP001             std::find_if( maPrevwPages.begin(), maPrevwPages.end(),
//STRIP001                           PrevwPosInsidePagePred( _aPrevwPos ) );
//STRIP001 
//STRIP001     if ( aFoundPrevwPageIter == maPrevwPages.end() )
//STRIP001         // given preview position outside a document page.
//STRIP001         bIsPosInsideDoc = false;
//STRIP001     else
//STRIP001     {
//STRIP001         _onPageNum = (*aFoundPrevwPageIter)->pPage->GetPhyPageNum();
//STRIP001         if ( (*aFoundPrevwPageIter)->pPage->IsEmptyPage() )
//STRIP001         {
//STRIP001             // given preview position inside an empty page
//STRIP001             bIsPosInsideDoc = false;
//STRIP001             _obPosInEmptyPage = true;
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             // given preview position inside a normal page
//STRIP001             bIsPosInsideDoc = true;
//STRIP001             _orDocPos = _aPrevwPos -
//STRIP001                         (*aFoundPrevwPageIter)->aPrevwWinPos +
//STRIP001                         (*aFoundPrevwPageIter)->aLogicPos;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return bIsPosInsideDoc;
//STRIP001 }
//STRIP001 
//STRIP001 /** determine window page scroll amount
//STRIP001 
//STRIP001     OD 17.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 SwTwips SwPagePreviewLayout::GetWinPagesScrollAmount(
//STRIP001                                 const sal_Int16 _nWinPagesToScroll ) const
//STRIP001 {
//STRIP001     SwTwips nScrollAmount;
//STRIP001     if ( mbDoesLayoutRowsFitIntoWindow )
//STRIP001     {
//STRIP001         nScrollAmount = (mnPrevwLayoutHeight - mnYFree) * _nWinPagesToScroll;
//STRIP001     }
//STRIP001     else
//STRIP001         nScrollAmount = _nWinPagesToScroll * maPaintedPrevwDocRect.GetHeight();
//STRIP001 
//STRIP001     // OD 19.02.2003 #107369# - check, if preview layout size values are valid.
//STRIP001     // If not, the checks for an adjustment of the scroll amount aren't useful.
//STRIP001     if ( mbLayoutSizesValid )
//STRIP001     {
//STRIP001         if ( (maPaintedPrevwDocRect.Top() + nScrollAmount) <= 0 )
//STRIP001             nScrollAmount = -maPaintedPrevwDocRect.Top();
//STRIP001 
//STRIP001         // OD 14.02.2003 #107369# - correct scroll amount
//STRIP001         if ( nScrollAmount > 0 &&
//STRIP001              maPaintedPrevwDocRect.Bottom() == maPreviewDocRect.Bottom()
//STRIP001            )
//STRIP001         {
//STRIP001             nScrollAmount = 0;
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             while ( (maPaintedPrevwDocRect.Top() + nScrollAmount + mnYFree) >= maPreviewDocRect.GetHeight() )
//STRIP001             {
//STRIP001                 nScrollAmount -= mnRowHeight;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return nScrollAmount;
//STRIP001 }
//STRIP001 
//STRIP001 /** determine window preview page the page with the given number is on.
//STRIP001 
//STRIP001     OD 17.01.2003 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 
//STRIP001     @param _nPageNum
//STRIP001     input parameter - physical page number of page, for which the preview
//STRIP001     window page number has to be calculated.
//STRIP001 
//STRIP001     @return number of preview window page the page with the given physical
//STRIP001     page number is on
//STRIP001 */
//STRIP001 sal_uInt16 SwPagePreviewLayout::GetWinPageNumOfPage( sal_uInt16 _nPageNum ) const
//STRIP001 {
//STRIP001     ASSERT( PreviewLayoutValid(), "PagePreviewLayout not valid" );
//STRIP001     {
//STRIP001         ASSERT( _nPageNum <= mnPages,
//STRIP001                 "parameter <_nPageNum> out of range - SwPagePreviewLayout::GetWinPageNumOfPage() will return 0!" );
//STRIP001         if ( _nPageNum > mnPages )
//STRIP001             return 0;
//STRIP001     }
//STRIP001 
//STRIP001     // OD 19.02.2003 #107369# - leaving left-top-corner blank is controlled
//STRIP001     // by <mbLeaveLeftTopBlank>.
//STRIP001     if ( mbLeaveLeftTopBlank )
//STRIP001     {
//STRIP001         // Note: increase given physical page number by one, because left-top-corner
//STRIP001         //       in the preview layout is left blank.
//STRIP001         ++_nPageNum;
//STRIP001     }
//STRIP001 
//STRIP001     sal_uInt16 nPagesPerWinPage = mnRows * mnCols;
//STRIP001 
//STRIP001     sal_uInt16 nWinPageNum = (_nPageNum) / nPagesPerWinPage;
//STRIP001     if ( ( (_nPageNum) % nPagesPerWinPage ) > 0 )
//STRIP001         ++nWinPageNum;
//STRIP001 
//STRIP001     return nWinPageNum;
//STRIP001 }
//STRIP001 
//STRIP001 // =============================================================================
//STRIP001 // methods to paint page preview layout
//STRIP001 // =============================================================================
//STRIP001 /** paint prepared preview
//STRIP001 
//STRIP001     OD 12.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 bool SwPagePreviewLayout::Paint( const Rectangle  _aOutRect ) const
//STRIP001 {
//STRIP001     // check environment and parameters
//STRIP001     {
//STRIP001         if ( !mrParentViewShell.GetWin() &&
//STRIP001              !mrParentViewShell.GetOut()->GetConnectMetaFile() )
//STRIP001             return false;
//STRIP001 
//STRIP001         ASSERT( mbPaintInfoValid,
//STRIP001                 "invalid preview settings - no paint of preview" );
//STRIP001         if ( !mbPaintInfoValid )
//STRIP001             return false;
//STRIP001     }
//STRIP001 
//STRIP001     // environment and parameter ok
//STRIP001 
//STRIP001     OutputDevice* pOutputDev = mrParentViewShell.GetOut();
//STRIP001 
//STRIP001     // prepare paint
//STRIP001     if ( maPrevwPages.size() > 0 )
//STRIP001     {
//STRIP001         mrParentViewShell.Imp()->bFirstPageInvalid = FALSE;
//STRIP001         mrParentViewShell.Imp()->pFirstVisPage =
//STRIP001                 const_cast<SwPageFrm*>(maPrevwPages[0]->pPage);
//STRIP001     }
//STRIP001 
//STRIP001     // paint preview background
//STRIP001     {
//STRIP001         SwRegionRects aPreviewBackgrdRegion( _aOutRect );
//STRIP001         // calculate preview background rectangles
//STRIP001         for ( std::vector<PrevwPage*>::const_iterator aPageIter = maPrevwPages.begin();
//STRIP001               aPageIter != maPrevwPages.end();
//STRIP001               ++aPageIter )
//STRIP001         {
//STRIP001             if ( (*aPageIter)->bVisible )
//STRIP001             {
//STRIP001                 aPreviewBackgrdRegion -=
//STRIP001                         SwRect( (*aPageIter)->aPrevwWinPos, (*aPageIter)->aPageSize );
//STRIP001             }
//STRIP001         }
//STRIP001         // paint preview background rectangles
//STRIP001         mrParentViewShell._PaintDesktop( aPreviewBackgrdRegion );
//STRIP001     }
//STRIP001 
//STRIP001     // prepare data for paint of pages
//STRIP001     const Rectangle aPxOutRect( pOutputDev->LogicToPixel( _aOutRect ) );
//STRIP001 
//STRIP001     MapMode aMapMode( pOutputDev->GetMapMode() );
//STRIP001     MapMode aSavedMapMode = aMapMode;
//STRIP001 
//STRIP001     Font* pEmptyPgFont = 0;
//STRIP001 
//STRIP001     Color aEmptyPgShadowBorderColor = SwViewOption::GetFontColor();
//STRIP001 
//STRIP001     for ( std::vector<PrevwPage*>::const_iterator aPageIter = maPrevwPages.begin();
//STRIP001           aPageIter != maPrevwPages.end();
//STRIP001           ++aPageIter )
//STRIP001     {
//STRIP001         if ( !(*aPageIter)->bVisible )
//STRIP001             continue;
//STRIP001 
//STRIP001         Rectangle aPageRect( (*aPageIter)->aLogicPos, (*aPageIter)->aPageSize );
//STRIP001         aMapMode.SetOrigin( (*aPageIter)->aMapOffset );
//STRIP001         pOutputDev->SetMapMode( aMapMode );
//STRIP001         Rectangle aPxPaintRect = pOutputDev->LogicToPixel( aPageRect );
//STRIP001         if ( aPxOutRect.IsOver( aPxPaintRect) )
//STRIP001         {
//STRIP001             if ( (*aPageIter)->pPage->IsEmptyPage() )
//STRIP001             {
//STRIP001                 const Color aRetouche( mrParentViewShell.Imp()->GetRetoucheColor() );
//STRIP001                 if( pOutputDev->GetFillColor() != aRetouche )
//STRIP001                     pOutputDev->SetFillColor( aRetouche );
//STRIP001                 pOutputDev->SetLineColor(); // OD 20.02.2003 #107369# - no line color
//STRIP001                 // OD 20.02.2003 #107369# - use aligned page rectangle
//STRIP001                 {
//STRIP001                     SwRect aTmpPageRect( aPageRect );
//STRIP001                     ::SwAlignRect( aTmpPageRect, &mrParentViewShell);
//STRIP001                     aPageRect = aTmpPageRect.SVRect();
//STRIP001                 }
//STRIP001                 pOutputDev->DrawRect( aPageRect );
//STRIP001                 // paint empty page text
//STRIP001                 if( !pEmptyPgFont )
//STRIP001                 {
//STRIP001                     pEmptyPgFont = new Font;
//STRIP001                     pEmptyPgFont->SetSize( Size( 0, 80 * 20 )); // == 80 pt
//STRIP001                     pEmptyPgFont->SetWeight( WEIGHT_BOLD );
//STRIP001                     pEmptyPgFont->SetStyleName( aEmptyStr );
//STRIP001                     pEmptyPgFont->SetName( String::CreateFromAscii(
//STRIP001                             RTL_CONSTASCII_STRINGPARAM( "Helvetica" )) );
//STRIP001                     pEmptyPgFont->SetFamily( FAMILY_SWISS );
//STRIP001                     pEmptyPgFont->SetTransparent( TRUE );
//STRIP001                     pEmptyPgFont->SetColor( COL_GRAY );
//STRIP001                 }
//STRIP001                 Font aOldFont( pOutputDev->GetFont() );
//STRIP001                 pOutputDev->SetFont( *pEmptyPgFont );
//STRIP001                 pOutputDev->DrawText( aPageRect, SW_RESSTR( STR_EMPTYPAGE ),
//STRIP001                                     TEXT_DRAW_VCENTER |
//STRIP001                                     TEXT_DRAW_CENTER |
//STRIP001                                     TEXT_DRAW_CLIP );
//STRIP001                 pOutputDev->SetFont( aOldFont );
//STRIP001                 // paint shadow and border for empty page
//STRIP001                 // OD 19.02.2003 #107369# - use new method to paint page border and
//STRIP001                 // shadow
//STRIP001                 (*aPageIter)->pPage->PaintBorderAndShadow( aPageRect, &mrParentViewShell );
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 mrParentViewShell.aVisArea = aPageRect;
//STRIP001                 aPxPaintRect.Intersection( aPxOutRect );
//STRIP001                 Rectangle aPaintRect = pOutputDev->PixelToLogic( aPxPaintRect );
//STRIP001                 mrParentViewShell.Paint( aPaintRect );
//STRIP001             }
//STRIP001             if ( (*aPageIter)->pPage->GetPhyPageNum() == mnSelectedPageNum )
//STRIP001             {
//STRIP001                 _PaintSelectMarkAtPage( (*aPageIter) );
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     // update at accessiblilty interface
//STRIP001     mrParentViewShell.Imp()->UpdateAccessiblePreview(
//STRIP001                     maPrevwPages,
//STRIP001                     aMapMode.GetScaleX(),
//STRIP001                     mrLayoutRootFrm.GetPageByPageNum( mnSelectedPageNum ),
//STRIP001                     maWinSize );
//STRIP001 
//STRIP001     delete pEmptyPgFont;
//STRIP001     pOutputDev->SetMapMode( aSavedMapMode );
//STRIP001     mrParentViewShell.aVisArea.Clear();
//STRIP001 
//STRIP001     return true;
//STRIP001 }
//STRIP001 
//STRIP001 /** repaint pages on page preview
//STRIP001 
//STRIP001     OD 18.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 void SwPagePreviewLayout::Repaint( const Rectangle _aInvalidCoreRect ) const
//STRIP001 {
//STRIP001     // check environment and parameters
//STRIP001     {
//STRIP001         if ( !mrParentViewShell.GetWin() &&
//STRIP001              !mrParentViewShell.GetOut()->GetConnectMetaFile() )
//STRIP001             return;
//STRIP001 
//STRIP001         ASSERT( mbPaintInfoValid,
//STRIP001                 "invalid preview settings - no paint of preview" );
//STRIP001         if ( !mbPaintInfoValid )
//STRIP001             return;
//STRIP001     }
//STRIP001 
//STRIP001     // environment and parameter ok
//STRIP001 
//STRIP001     // prepare paint
//STRIP001     if ( maPrevwPages.size() > 0 )
//STRIP001     {
//STRIP001         mrParentViewShell.Imp()->bFirstPageInvalid = FALSE;
//STRIP001         mrParentViewShell.Imp()->pFirstVisPage =
//STRIP001                 const_cast<SwPageFrm*>(maPrevwPages[0]->pPage);
//STRIP001     }
//STRIP001 
//STRIP001     // invalidate visible pages, which overlap the invalid core rectangle
//STRIP001     for ( std::vector<PrevwPage*>::const_iterator aPageIter = maPrevwPages.begin();
//STRIP001           aPageIter != maPrevwPages.end();
//STRIP001           ++aPageIter )
//STRIP001     {
//STRIP001         if ( !(*aPageIter)->bVisible )
//STRIP001             continue;
//STRIP001 
//STRIP001         Rectangle aPageRect( (*aPageIter)->aLogicPos, (*aPageIter)->aPageSize );
//STRIP001         if ( _aInvalidCoreRect.IsOver( aPageRect ) )
//STRIP001         {
//STRIP001             aPageRect.Intersection( _aInvalidCoreRect );
//STRIP001             Rectangle aInvalidPrevwRect = aPageRect;
//STRIP001             aInvalidPrevwRect.SetPos( aInvalidPrevwRect.TopLeft() -
//STRIP001                                       (*aPageIter)->aLogicPos +
//STRIP001                                       (*aPageIter)->aPrevwWinPos );
//STRIP001             mrParentViewShell.GetWin()->Invalidate( aInvalidPrevwRect );
//STRIP001         }
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 /** paint selection mark at page
//STRIP001 
//STRIP001     OD 17.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 const void SwPagePreviewLayout::_PaintSelectMarkAtPage(
//STRIP001                                     const PrevwPage* _aSelectedPrevwPage ) const
//STRIP001 {
//STRIP001     OutputDevice* pOutputDev = mrParentViewShell.GetOut();
//STRIP001     MapMode aMapMode( pOutputDev->GetMapMode() );
//STRIP001     // save mapping mode of output device
//STRIP001     MapMode aSavedMapMode = aMapMode;
//STRIP001     // save fill and line color of output device
//STRIP001     Color aFill( pOutputDev->GetFillColor() );
//STRIP001     Color aLine( pOutputDev->GetLineColor() );
//STRIP001 
//STRIP001     // determine selection mark color
//STRIP001     Color aSelPgLineColor(COL_LIGHTBLUE);
//STRIP001     const StyleSettings& rSettings =
//STRIP001         mrParentViewShell.GetWin()->GetSettings().GetStyleSettings();
//STRIP001     if ( rSettings.GetHighContrastMode() )
//STRIP001         aSelPgLineColor = rSettings.GetHighlightTextColor();
//STRIP001 
//STRIP001     // set needed mapping mode at output device
//STRIP001     aMapMode.SetOrigin( _aSelectedPrevwPage->aMapOffset );
//STRIP001     pOutputDev->SetMapMode( aMapMode );
//STRIP001 
//STRIP001     // calculate page rectangle in pixel coordinates
//STRIP001     SwRect aPageRect( _aSelectedPrevwPage->aLogicPos,
//STRIP001                          _aSelectedPrevwPage->aPageSize );
//STRIP001     // OD 19.02.2003 #107369# - use aligned page rectangle, as it is used for
//STRIP001     // page border and shadow paint - see <SwPageFrm::PaintBorderAndShadow(..)>
//STRIP001     ::SwAlignRect( aPageRect, &mrParentViewShell);
//STRIP001     Rectangle aPxPageRect = pOutputDev->LogicToPixel( aPageRect.SVRect() );
//STRIP001 
//STRIP001     // draw two rectangle
//STRIP001     // OD 19.02.2003 #107369# - adjust position of select mark rectangle
//STRIP001     Rectangle aRect( aPxPageRect.Left(), aPxPageRect.Top(),
//STRIP001                        aPxPageRect.Right(), aPxPageRect.Bottom() );
//STRIP001     aRect = pOutputDev->PixelToLogic( aRect );
//STRIP001     pOutputDev->SetFillColor(); // OD 20.02.2003 #107369# - no fill color
//STRIP001     pOutputDev->SetLineColor( aSelPgLineColor );
//STRIP001     pOutputDev->DrawRect( aRect );
//STRIP001     // OD 19.02.2003 #107369# - adjust position of select mark rectangle
//STRIP001     aRect = Rectangle( aPxPageRect.Left()+1, aPxPageRect.Top()+1,
//STRIP001                        aPxPageRect.Right()-1, aPxPageRect.Bottom()-1 );
//STRIP001     aRect = pOutputDev->PixelToLogic( aRect );
//STRIP001     pOutputDev->DrawRect( aRect );
//STRIP001 
//STRIP001     // reset fill and line color of output device
//STRIP001     pOutputDev->SetFillColor( aFill );
//STRIP001     pOutputDev->SetLineColor( aLine );
//STRIP001 
//STRIP001     // reset mapping mode of output device
//STRIP001     pOutputDev->SetMapMode( aSavedMapMode );
//STRIP001 }
//STRIP001 
//STRIP001 /** paint to mark new selected page
//STRIP001 
//STRIP001     OD 17.12.2002 #103492#
//STRIP001     Perform paint for current selected page in order to unmark it.
//STRIP001     Set new selected page and perform paint to mark this page.
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 void SwPagePreviewLayout::MarkNewSelectedPage( const sal_uInt16 _nSelectedPage )
//STRIP001 {
//STRIP001     sal_uInt16 nOldSelectedPageNum = mnSelectedPageNum;
//STRIP001     mnSelectedPageNum = _nSelectedPage;
//STRIP001 
//STRIP001     // re-paint for current selected page in order to umark it.
//STRIP001     const PrevwPage* pOldSelectedPrevwPage = _GetPrevwPageByPageNum( nOldSelectedPageNum );
//STRIP001     if ( pOldSelectedPrevwPage && pOldSelectedPrevwPage->bVisible )
//STRIP001     {
//STRIP001         // OD 20.02.2003 #107369# - invalidate only areas of selection mark.
//STRIP001         SwRect aPageRect( pOldSelectedPrevwPage->aPrevwWinPos,
//STRIP001                               pOldSelectedPrevwPage->aPageSize );
//STRIP001         ::SwAlignRect( aPageRect, &mrParentViewShell);
//STRIP001         OutputDevice* pOutputDev = mrParentViewShell.GetOut();
//STRIP001         Rectangle aPxPageRect = pOutputDev->LogicToPixel( aPageRect.SVRect() );
//STRIP001         // invalidate top mark line
//STRIP001         Rectangle aInvalPxRect( aPxPageRect.Left(), aPxPageRect.Top(),
//STRIP001                                 aPxPageRect.Right(), aPxPageRect.Top()+1 );
//STRIP001         mrParentViewShell.GetWin()->Invalidate( pOutputDev->PixelToLogic( aInvalPxRect ) );
//STRIP001         // invalidate right mark line
//STRIP001         aInvalPxRect = Rectangle( aPxPageRect.Right()-1, aPxPageRect.Top(),
//STRIP001                                   aPxPageRect.Right(), aPxPageRect.Bottom() );
//STRIP001         mrParentViewShell.GetWin()->Invalidate( pOutputDev->PixelToLogic( aInvalPxRect ) );
//STRIP001         // invalidate bottom mark line
//STRIP001         aInvalPxRect = Rectangle( aPxPageRect.Left(), aPxPageRect.Bottom()-1,
//STRIP001                                   aPxPageRect.Right(), aPxPageRect.Bottom() );
//STRIP001         mrParentViewShell.GetWin()->Invalidate( pOutputDev->PixelToLogic( aInvalPxRect ) );
//STRIP001         // invalidate left mark line
//STRIP001         aInvalPxRect = Rectangle( aPxPageRect.Left(), aPxPageRect.Top(),
//STRIP001                                   aPxPageRect.Left()+1, aPxPageRect.Bottom() );
//STRIP001         mrParentViewShell.GetWin()->Invalidate( pOutputDev->PixelToLogic( aInvalPxRect ) );
//STRIP001     }
//STRIP001 
//STRIP001     // re-paint for new selected page in order to mark it.
//STRIP001     const PrevwPage* pNewSelectedPrevwPage = _GetPrevwPageByPageNum( _nSelectedPage );
//STRIP001     if ( pNewSelectedPrevwPage && pNewSelectedPrevwPage->bVisible )
//STRIP001         _PaintSelectMarkAtPage( pNewSelectedPrevwPage );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // =============================================================================
//STRIP001 // helper methods
//STRIP001 // =============================================================================
//STRIP001 /** get preview page by physical page number
//STRIP001 
//STRIP001     OD 17.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 struct EqualsPageNumPred
//STRIP001 {
//STRIP001     const sal_uInt16 mnPageNum;
//STRIP001     EqualsPageNumPred( const sal_uInt16 _nPageNum ) : mnPageNum( _nPageNum ) {};
//STRIP001     bool operator() ( const PrevwPage* _pPrevwPage )
//STRIP001     {
//STRIP001         return _pPrevwPage->pPage->GetPhyPageNum() == mnPageNum;
//STRIP001     }
//STRIP001 };
//STRIP001 
//STRIP001 const PrevwPage* SwPagePreviewLayout::_GetPrevwPageByPageNum( const sal_uInt16 _nPageNum ) const
//STRIP001 {
//STRIP001     std::vector<PrevwPage*>::const_iterator aFoundPrevwPageIter =
//STRIP001             std::find_if( maPrevwPages.begin(), maPrevwPages.end(),
//STRIP001                           EqualsPageNumPred( _nPageNum ) );
//STRIP001 
//STRIP001     if ( aFoundPrevwPageIter == maPrevwPages.end() )
//STRIP001         return 0;
//STRIP001     else
//STRIP001         return (*aFoundPrevwPageIter);
//STRIP001 }
//STRIP001 
//STRIP001 /** determine row the page with the given number is in
//STRIP001 
//STRIP001     OD 17.01.2003 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 sal_uInt16 SwPagePreviewLayout::GetRowOfPage( sal_uInt16 _nPageNum ) const
//STRIP001 {
//STRIP001     // OD 19.02.2003 #107369# - leaving left-top-corner blank is controlled
//STRIP001     // by <mbLeaveLeftTopBlank>.
//STRIP001     if ( mbLeaveLeftTopBlank )
//STRIP001     {
//STRIP001         // Note: increase given physical page number by one, because left-top-corner
//STRIP001         //       in the preview layout is left blank.
//STRIP001         ++_nPageNum;
//STRIP001     }
//STRIP001 
//STRIP001     sal_uInt16 nRow = (_nPageNum) / mnCols;
//STRIP001     if ( ( (_nPageNum) % mnCols ) > 0 )
//STRIP001         ++nRow;
//STRIP001 
//STRIP001     return nRow;
//STRIP001 }
//STRIP001 
//STRIP001 /** determine column the page with the given number is in
//STRIP001 
//STRIP001     OD 17.01.2003 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 sal_uInt16 SwPagePreviewLayout::GetColOfPage( sal_uInt16 _nPageNum ) const
//STRIP001 {
//STRIP001     // OD 19.02.2003 #107369# - leaving left-top-corner blank is controlled
//STRIP001     // by <mbLeaveLeftTopBlank>.
//STRIP001     if ( mbLeaveLeftTopBlank )
//STRIP001     {
//STRIP001         // Note: increase given physical page number by one, because left-top-corner
//STRIP001         //       in the preview layout is left blank.
//STRIP001         ++_nPageNum;
//STRIP001     }
//STRIP001 
//STRIP001     sal_uInt16 nCol = (_nPageNum) % mnCols;
//STRIP001     if ( nCol == 0 )
//STRIP001         nCol = mnCols;
//STRIP001 
//STRIP001     return nCol;
//STRIP001 }
//STRIP001 
//STRIP001 Size SwPagePreviewLayout::GetMaxPageSize() const
//STRIP001 {
//STRIP001     ASSERT( PreviewLayoutValid(), "PagePreviewLayout not valid" );
//STRIP001     return maMaxPageSize;
//STRIP001 }
//STRIP001 
//STRIP001 Size SwPagePreviewLayout::GetPrevwDocSize() const
//STRIP001 {
//STRIP001     ASSERT( PreviewLayoutValid(), "PagePreviewLayout not valid" );
//STRIP001     return maPreviewDocRect.GetSize();
//STRIP001 }
//STRIP001 
//STRIP001 /** get size of a preview page by its physical page number
//STRIP001 
//STRIP001     OD 15.01.2003 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 Size SwPagePreviewLayout::GetPrevwPageSizeByPageNum( sal_uInt16 _nPageNum ) const
//STRIP001 {
//STRIP001     const PrevwPage* pPrevwPage = _GetPrevwPageByPageNum( _nPageNum );
//STRIP001     if ( pPrevwPage )
//STRIP001     {
//STRIP001         return pPrevwPage->aPageSize;
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         return Size( 0, 0 );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 /** get virtual page number by its physical page number
//STRIP001 
//STRIP001     OD 21.03.2003 #108282#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 sal_uInt16 SwPagePreviewLayout::GetVirtPageNumByPageNum( sal_uInt16 _nPageNum ) const
//STRIP001 {
//STRIP001     const PrevwPage* pPrevwPage = _GetPrevwPageByPageNum( _nPageNum );
//STRIP001     if ( pPrevwPage )
//STRIP001     {
//STRIP001         return pPrevwPage->pPage->GetVirtPageNum();
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         return 0;
//STRIP001     }
//STRIP001 }
}
