/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fmsrcimp.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:04:40 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _FMSRCIMP_HXX
#define _FMSRCIMP_HXX

// auto strip #ifndef _SVX_FMTOOLS_HXX
// auto strip #include "fmtools.hxx"
// auto strip #endif // _SVX_FMTOOLS_HXX

// auto strip #ifndef _VOS_THREAD_HXX_ //autogen
// auto strip #include <vos/thread.hxx>
// auto strip #endif

// auto strip #ifndef _OSL_MUTEX_HXX_ //autogen
// auto strip #include <osl/mutex.hxx>
// auto strip #endif

// auto strip #ifndef _FMSEARCH_HXX
// auto strip #include "fmsearch.hxx"
// auto strip #endif // _FMSEARCH_HXX

// auto strip #ifndef _COM_SUN_STAR_AWT_XTEXTCOMPONENT_HPP_
// auto strip #include <com/sun/star/awt/XTextComponent.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_AWT_XCHECKBOX_HPP_
// auto strip #include <com/sun/star/awt/XCheckBox.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_AWT_XLISTBOX_HPP_
// auto strip #include <com/sun/star/awt/XListBox.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_XNUMBERFORMATSSUPPLIER_HPP_
// auto strip #include <com/sun/star/util/XNumberFormatsSupplier.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_XNUMBERFORMATTER_HPP_
// auto strip #include <com/sun/star/util/XNumberFormatter.hpp>
// auto strip #endif

// auto strip #ifndef _COMPHELPER_STLTYPES_HXX_
// auto strip #include <comphelper/stl_types.hxx>
// auto strip #endif
// auto strip #ifndef _CPPUHELPER_IMPLBASE1_HXX_
// auto strip #include <cppuhelper/implbase1.hxx>
// auto strip #endif

// auto strip #ifndef _UNOTOOLS_CHARCLASS_HXX 
// auto strip #include <unotools/charclass.hxx>
// auto strip #endif
#ifndef _UNOTOOLS_COLLATORWRAPPER_HXX 
#include <unotools/collatorwrapper.hxx>
#endif
namespace binfilter {

// ===================================================================================================
// Hilfsstrukturen

//STRIP001 SV_DECL_OBJARR(SvInt32Array, sal_Int32, 16, 16)//STRIP008 ;

// ===================================================================================================
// = class FmSearchThread - wie der Name schon sagt
// ===================================================================================================

//STRIP001 class FmSearchThread : public ::vos::OThread
//STRIP001 {
//STRIP001 	FmSearchEngine*		m_pEngine;
//STRIP001 	Link				m_aTerminationHdl;
//STRIP001 
//STRIP001 	virtual void SAL_CALL run();
//STRIP001 	virtual void SAL_CALL onTerminated();
//STRIP001 
//STRIP001 public:
//STRIP001 	FmSearchThread(FmSearchEngine* pEngine) : m_pEngine(pEngine) { }
//STRIP001 	void setTerminationHandler(Link aHdl) { m_aTerminationHdl = aHdl; }
//STRIP001 };

// ===================================================================================================
// = struct FmSearchProgress - diese Struktur bekommt der Owner der SearchEngine fuer Status-Updates
// = (und am Ende der Suche)
// ===================================================================================================

struct FmSearchProgress
{
	enum STATE { STATE_PROGRESS, STATE_PROGRESS_COUNTING, STATE_CANCELED, STATE_SUCCESSFULL, STATE_NOTHINGFOUND, STATE_ERROR };
		// (Bewegung auf neuen Datensatz; Fortschritt beim Zaehlen von Datensaetzen; abgebrochen; Datensatz gefunden;
		// nichts gefunden, irgendein nicht zu handelnder Fehler)
	STATE	aSearchState;

	// aktueller Datensatz - immer gueltig (ist zum Beispiel bei Abbrechen auch fuer das Weitersuchen interesant)
	sal_uInt32	nCurrentRecord;
	// Ueberlauf - nur gueltig bei STATE_PROGRESS
	sal_Bool	bOverflow;

	// die Position des Such-Cursors - bei STATE_SUCCESSFULL, STATE_CANCELED und STATE_NOTHING_FOUND gueltig
	::com::sun::star::uno::Any	aBookmark;
	// das Feld, in dem der Text gefunden wurde - bei STATE_SUCCESSFULL gueltig
	sal_Int32	nFieldIndex;
};

// ===================================================================================================
// = class FmRecordCountListener - Hilfsklasse fuer FmSearchEngine, lauscht an einem Cursor und teilt
// =								Aenderungem im RecordCount mit
// ===================================================================================================

//STRIP001 class FmRecordCountListener : public ::cppu::WeakImplHelper1< ::com::sun::star::beans::XPropertyChangeListener>
//STRIP001 {
//STRIP001 // Atribute
//STRIP001 	Link			m_lnkWhoWantsToKnow;
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > 	m_xListening;
//STRIP001 
//STRIP001 // Attribut-Zugriff
//STRIP001 public:
//STRIP001 	Link SetPropChangeHandler(const Link& lnk);
//STRIP001 
//STRIP001 // Oprationen
//STRIP001 public:
//STRIP001 	FmRecordCountListener(const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XResultSet >& dbcCursor);
//STRIP001 		// the set has to support the sdb::ResultSet service
//STRIP001 	virtual ~FmRecordCountListener();
//STRIP001 
//STRIP001 	//	DECLARE_UNO3_AGG_DEFAULTS(FmPropertyListener, UsrObject);
//STRIP001 	//	virtual sal_Bool queryInterface(::com::sun::star::uno::Uik aUik, ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >& rOut);
//STRIP001 
//STRIP001 // ::com::sun::star::lang::XEventListener
//STRIP001 	virtual void SAL_CALL disposing(const ::com::sun::star::lang::EventObject& Source) throw(::com::sun::star::uno::RuntimeException);
//STRIP001 
//STRIP001 // ::com::sun::star::beans::XPropertyChangeListener
//STRIP001 	virtual void SAL_CALL propertyChange(const ::com::sun::star::beans::PropertyChangeEvent& evt) throw(::com::sun::star::uno::RuntimeException);
//STRIP001 
//STRIP001 	void DisConnect();
//STRIP001 
//STRIP001 private:
//STRIP001 	void NotifyCurrentCount();
//STRIP001 
//STRIP001 };

// ===================================================================================================
// = class FmSearchEngine - Impl-Klasse fuer FmSearchDialog
// ===================================================================================================

namespace svxform {
	// We have three possible control types we may search in, determined by the supported interfaces : ::com::sun::star::awt::XTextComponent, ::com::sun::star::awt::XListBox, ::com::sun::star::awt::XCheckBox.
	// While searching we don't want to do this distinction for every control in every round. So we need some helpers.
	class ControlTextWrapper
	{
		// attributes
		::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface > 	m_xControl;
		// attribute access
	public:
		::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >  getControl() const{ return m_xControl; }
	public:
		ControlTextWrapper(const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >& _xControl) { m_xControl = _xControl; }
		virtual ~ControlTextWrapper() { }

		virtual ::rtl::OUString getCurrentText() const = 0;
	};
//STRIP001 	class SimpleTextWrapper : public ControlTextWrapper
//STRIP001 	{
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::awt::XTextComponent >  m_xText;
//STRIP001 	public:
//STRIP001 		SimpleTextWrapper(const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XTextComponent >& _xText);
//STRIP001 		virtual ::rtl::OUString getCurrentText() const;
//STRIP001 	};
//STRIP001 	class ListBoxWrapper : public ControlTextWrapper
//STRIP001 	{
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::awt::XListBox >  m_xBox;
//STRIP001 	public:
//STRIP001 		ListBoxWrapper(const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XListBox >& _xBox);
//STRIP001 		virtual ::rtl::OUString getCurrentText() const;
//STRIP001 	};
//STRIP001 	class CheckBoxWrapper : public ControlTextWrapper
//STRIP001 	{
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::awt::XCheckBox >  m_xBox;
//STRIP001 	public:
//STRIP001 		CheckBoxWrapper(const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XCheckBox >& _xBox);
//STRIP001 		virtual ::rtl::OUString getCurrentText() const;
//STRIP001 	};
}

//STRIP001 class FmSearchEngine
//STRIP001 {
//STRIP001 	friend class FmSearchThread;
//STRIP001 
//STRIP001 	enum SEARCH_RESULT { SR_FOUND, SR_NOTFOUND, SR_ERROR, SR_CANCELED };
//STRIP001 	enum SEARCHFOR_TYPE { SEARCHFOR_STRING, SEARCHFOR_NULL, SEARCHFOR_NOTNULL };
//STRIP001 
//STRIP001 	// zugrundeliegende Daten
//STRIP001 	CursorWrapper			m_xSearchCursor;
//STRIP001 	SvInt32Array			m_arrFieldMapping;
//STRIP001 		// da der Iterator durchaus mehr Spalten haben kann, als ich eigentlich verwalte (in meiner Feld-Listbox),
//STRIP001 		// muss ich mir hier ein Mapping dieser ::com::sun::star::form-Schluessel auf die Indizies der entsprechenden Spalten im Iterator halten
//STRIP001 
//STRIP001 	// der Formatter
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::util::XNumberFormatsSupplier > 	m_xFormatSupplier;
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::util::XNumberFormatter > 		m_xFormatter;
//STRIP001 
//STRIP001 	CharClass				m_aCharacterClassficator;
//STRIP001 	CollatorWrapper			m_aStringCompare;
//STRIP001 
//STRIP001 	// die Sammlung aller interesanten Felder (bzw. ihre ::com::sun::star::data::XDatabaseVariant-Interfaces und ihre FormatKeys)
//STRIP001 	struct FieldInfo
//STRIP001 	{
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::sdb::XColumn > 			xContents;
//STRIP001 		sal_uInt32				nFormatKey;
//STRIP001 		sal_Bool				bDoubleHandling;
//STRIP001 	};
//STRIP001 
//STRIP001 	DECLARE_STL_VECTOR(FieldInfo, FieldCollection);
//STRIP001 	FieldCollection				m_arrUsedFields;
//STRIP001 	sal_Int32					m_nCurrentFieldIndex;	// der letzte Parameter von RebuildUsedFields, ermoeglicht mir Checks in FormatField
//STRIP001 
//STRIP001 	DECLARE_STL_VECTOR(svxform::ControlTextWrapper*, ControlTextSuppliers);
//STRIP001 	ControlTextSuppliers	m_aControlTexts;
//STRIP001 
//STRIP001 	sal_Bool				m_bUsingTextComponents;
//STRIP001 	CursorWrapper			m_xOriginalIterator;
//STRIP001 	CursorWrapper			m_xClonedIterator;
//STRIP001 
//STRIP001 	// Daten fuer Entscheidung, in welchem Feld ich ein "Found" akzeptiere
//STRIP001 	::com::sun::star::uno::Any	m_aPreviousLocBookmark;				// Position, an der ich zuletzt fuendig war
//STRIP001 	FieldCollectionIterator		m_iterPreviousLocField;				// dito Feld
//STRIP001 
//STRIP001 	// Kommunikation mit dem Thread, der die eigentliche Suche durchfuehrt
//STRIP001 	::rtl::OUString				m_strSearchExpression;				// Hinrichtung
//STRIP001 	SEARCHFOR_TYPE		m_eSearchForType;					// dito
//STRIP001 	SEARCH_RESULT		m_srResult;							// Rueckrichtung
//STRIP001 
//STRIP001 	// der Link, dem ich Fortschritte und Ergebnisse mitteile
//STRIP001 	Link				m_aProgressHandler;
//STRIP001 	sal_Bool			m_bSearchingCurrently;			// laeuft gerade eine (asynchrone) Suche ?
//STRIP001 	sal_Bool			m_bCancelAsynchRequest : 1;		// soll abgebrochen werden ?
//STRIP001 	::osl::Mutex		m_aCancelAsynchAccess;			// Zugriff auf m_bCancelAsynchRequest (eigentlich nur bei
//STRIP001 														// m_eMode == SM_USETHREAD interesant)
//STRIP001 	FmSearchDialog::SEARCH_MODE	m_eMode;				// der aktuelle Modus
//STRIP001 
//STRIP001 	// Parameter fuer die Suche
//STRIP001 	sal_Bool	m_bFormatter : 1;		// Feldformatierung benutzen
//STRIP001 	sal_Bool	m_bForward : 1;			// Richtung
//STRIP001 	sal_Bool	m_bWildcard : 1;		// Platzhalter-Suche ?
//STRIP001 	sal_Bool	m_bRegular : 1;			// regulaerer Ausdruck
//STRIP001 	sal_Bool	m_bLevenshtein : 1;		// Levenshtein-Suche
//STRIP001 	sal_Bool	m_bTransliteration : 1;	// Levenshtein-Suche
//STRIP001 
//STRIP001 	sal_Bool	m_bLevRelaxed : 1;		// Parameter fuer Levenshtein-Suche
//STRIP001 	sal_uInt16	m_nLevOther;
//STRIP001 	sal_uInt16	m_nLevShorter;
//STRIP001 	sal_uInt16	m_nLevLonger;
//STRIP001 
//STRIP001 	sal_uInt16	m_nPosition;			// wenn nicht regulaer oder lev, dann einer der MATCHING_...-Werte
//STRIP001 
//STRIP001 	sal_Int32	m_nTransliterationFlags;
//STRIP001 
//STRIP001 // -------------
//STRIP001 // Memberzugriff
//STRIP001 private:
//STRIP001 	sal_Bool	CancelRequested();		// liefert eine durch m_aCancelAsynchAccess gesicherte Auswertung von m_bCancelAsynchRequest
//STRIP001 
//STRIP001 public:
//STRIP001 	void		SetCaseSensitive(sal_Bool bSet);
//STRIP001 	sal_Bool	GetCaseSensitive() const;
//STRIP001 
//STRIP001 	void		SetFormatterUsing(sal_Bool bSet);	// das ist etwas umfangreicher, deshalb kein hier inline ....
//STRIP001 	sal_Bool	GetFormatterUsing() const			{ return m_bFormatter; }
//STRIP001 
//STRIP001 	void		SetDirection(sal_Bool bForward)		{ m_bForward = bForward; }
//STRIP001 	sal_Bool	GetDirection() const				{ return m_bForward; }
//STRIP001 
//STRIP001 	void		SetWildcard(sal_Bool bSet)			{ m_bWildcard = bSet; }
//STRIP001 	sal_Bool	GetWildcard() const					{ return m_bWildcard; }
//STRIP001 
//STRIP001 	void		SetRegular(sal_Bool bSet)			{ m_bRegular = bSet; }
//STRIP001 	sal_Bool	GetRegular() const					{ return m_bRegular; }
//STRIP001 
//STRIP001 	void		SetLevenshtein(sal_Bool bSet)		{ m_bLevenshtein = bSet; }
//STRIP001 	sal_Bool	GetLevenshtein() const				{ return m_bLevenshtein; }
//STRIP001 
//STRIP001 	void		SetIgnoreWidthCJK(sal_Bool bSet);
//STRIP001 	sal_Bool	GetIgnoreWidthCJK() const;
//STRIP001 
//STRIP001 	void		SetTransliteration(sal_Bool bSet)	{ m_bTransliteration = bSet; }
//STRIP001 	sal_Bool	GetTransliteration() const			{ return m_bTransliteration; }
//STRIP001 
//STRIP001 	void		SetLevRelaxed(sal_Bool bSet)		{ m_bLevRelaxed = bSet; }
//STRIP001 	sal_Bool	GetLevRelaxed() const				{ return m_bLevRelaxed; }
//STRIP001 	void		SetLevOther(sal_uInt16 nHowMuch)	{ m_nLevOther = nHowMuch; }
//STRIP001 	sal_uInt16	GetLevOther() const					{ return m_nLevOther; }
//STRIP001 	void		SetLevShorter(sal_uInt16 nHowMuch)	{ m_nLevShorter = nHowMuch; }
//STRIP001 	sal_uInt16	GetLevShorter() const				{ return m_nLevShorter; }
//STRIP001 	void		SetLevLonger(sal_uInt16 nHowMuch)	{ m_nLevLonger = nHowMuch; }
//STRIP001 	sal_uInt16	GetLevLonger() const				{ return m_nLevLonger; }
//STRIP001 		// die ganzen Lev-Werte werden nur bei  m_bLevenshtein==sal_True beachtet
//STRIP001 
//STRIP001 	void		SetTransliterationFlags(sal_Int32 _nFlags)	{ m_nTransliterationFlags = _nFlags; }
//STRIP001 	sal_Int32	GetTransliterationFlags() const				{ return m_nTransliterationFlags; }
//STRIP001 
//STRIP001 	void	SetPosition(sal_uInt16 nValue)		{ m_nPosition = nValue; }
//STRIP001 	sal_uInt16	GetPosition() const				{ return m_nPosition; }
//STRIP001 		// Position wird bei m_bWildCard==sal_True nicht beachtet
//STRIP001 
//STRIP001 	sal_Bool	GetSearchMode() const { return m_eMode; }
//STRIP001 
//STRIP001 public:
//STRIP001 	/**	zwei Constructoren, beide analog zu denen des FmSearchDialog, Erklaerung siehe also dort ....
//STRIP001 		xCursor muss jeweils den ::com::sun::star::data::DatabaseCursor-Service implementieren.
//STRIP001 		wenn eMode == SM_USETHREAD, sollte ein ProgressHandler gesetzt sein, da dann die Ergebnisuebermittlung ueber diesen
//STRIP001 		Handler erfolgt.
//STRIP001 		Ist eMode != SM_USETHREAD, kehren SearchNext und StarOver nicht zurueck, bevor die Suche (erfolgreich oder nicht) beendet
//STRIP001 		wurde, dann kann man das Ergebnis danach abfragen. Ist zusaetzlich der ProgressHandler gesetzt, wird dieser fuer jeden neuen
//STRIP001 		Datensatz sowie am Ende der Suche aufgerufen.
//STRIP001 	*/
//STRIP001 	FmSearchEngine(
//STRIP001 		const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB,
//STRIP001 		const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XResultSet >& xCursor,
//STRIP001 		const ::rtl::OUString& strVisibleFields,
//STRIP001 		const ::com::sun::star::uno::Reference< ::com::sun::star::util::XNumberFormatsSupplier >& xFormat,
//STRIP001 		FmSearchDialog::SEARCH_MODE eMode);
//STRIP001 	FmSearchEngine(
//STRIP001 		const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB,
//STRIP001 		const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XResultSet >& xCursor,
//STRIP001 		const ::rtl::OUString& strVisibleFields,
//STRIP001 		const InterfaceArray& arrFields,
//STRIP001 		FmSearchDialog::SEARCH_MODE eMode);
//STRIP001 
//STRIP001 	virtual ~FmSearchEngine();
//STRIP001 
//STRIP001 	/**	der Link wird fuer jeden Datensatz und nach Beendigung der Suche aufgerufen, Parameter ist ein Zeiger auf
//STRIP001 		eine FmSearchProgress-Struktur
//STRIP001 		der Handler sollte auf jeden Fall Thread-sicher sein
//STRIP001 	*/
//STRIP001 	void SetProgressHandler(Link aHdl) { m_aProgressHandler = aHdl; }
//STRIP001 
//STRIP001 	///	das naechste Vorkommen suchen (Werte fuer nDirection siehe DIRECTION_*-defines)
//STRIP001 	void SearchNext(const ::rtl::OUString& strExpression);
//STRIP001 	/// analogous, search for "NULL" (_bSearchForNull==sal_True) or "not NULL"
//STRIP001 	void SearchNextSpecial(sal_Bool _bSearchForNull);
//STRIP001 	///	das naechste Vorkommen suchen, abhaengig von nDirection wird dabei am Anfang oder am Ende neu begonnen
//STRIP001 	void StartOver(const ::rtl::OUString& strExpression);
//STRIP001 	/// analogous, search for "NULL" (_bSearchForNull==sal_True) or "not NULL"
//STRIP001 	void StartOverSpecial(sal_Bool _bSearchForNull);
//STRIP001 	/// die Angaben ueber letzte Fundstelle invalidieren
//STRIP001 	void InvalidatePreviousLoc();
//STRIP001 
//STRIP001 	/**	baut m_arrUsedFields neu auf (nFieldIndex==-1 bedeutet alle Felder, ansonsten gibt es den Feldindex an)
//STRIP001 		wenn bForce nicht gesetzt ist, passiert bei nFieldIndex == m_nCurrentFieldIndex nichts
//STRIP001 		(ruft InvalidatePreviousLoc auf)
//STRIP001 	*/
//STRIP001 	void RebuildUsedFields(sal_Int32 nFieldIndex, sal_Bool bForce = sal_False);
//STRIP001 	::rtl::OUString FormatField(sal_Int32 nWhich);
//STRIP001 
//STRIP001 	/// kehrt sofort zurueck; nachdem wirklich abgebrochen wurde, wird der ProgressHandler mit STATE_CANCELED aufgerufen
//STRIP001 	void CancelSearch();
//STRIP001 
//STRIP001 	/**	nur gueltig, wenn nicht gerade eine (asynchrone) Suche laeuft, die naechste Suche wird dann auf dem neuen Iterator
//STRIP001 		mit den neuen Parametern durchgefuehrt
//STRIP001 	*/
//STRIP001 	sal_Bool SwitchToContext(const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XResultSet >& xCursor, const ::rtl::OUString& strVisibleFields, const InterfaceArray& arrFields,
//STRIP001 		sal_Int32 nFieldIndex);
//STRIP001 
//STRIP001 protected:
//STRIP001 	void Init(const ::rtl::OUString& strVisibleFields);
//STRIP001 
//STRIP001 	void SearchNextImpl();
//STRIP001 		// diese Impl-Methode laeuft im SearchThread
//STRIP001 
//STRIP001 	// start a thread-search (or call SearchNextImpl directly, depending on the search mode)
//STRIP001 	void ImplStartNextSearch();
//STRIP001 
//STRIP001 private:
//STRIP001 	void clearControlTexts();
//STRIP001 	void fillControlTexts(const InterfaceArray& arrFields);
//STRIP001 
//STRIP001 	// three methods implementing a complete search loop (null/not null, wildcard, SearchText)
//STRIP001 	// (they all have some code in common, but with this solution we have do do a distinction only once per search (before
//STRIP001 	// starting the loop), not in every loop step
//STRIP001 	SEARCH_RESULT SearchSpecial(sal_Bool _bSearchForNull, sal_Int32& nFieldPos, FieldCollectionIterator& iterFieldLoop,
//STRIP001 		const FieldCollectionIterator& iterBegin, const FieldCollectionIterator& iterEnd);
//STRIP001 	SEARCH_RESULT SearchWildcard(const ::rtl::OUString& strExpression, sal_Int32& nFieldPos, FieldCollectionIterator& iterFieldLoop,
//STRIP001 		const FieldCollectionIterator& iterBegin, const FieldCollectionIterator& iterEnd);
//STRIP001 	SEARCH_RESULT SearchRegularApprox(const ::rtl::OUString& strExpression, sal_Int32& nFieldPos, FieldCollectionIterator& iterFieldLoop,
//STRIP001 		const FieldCollectionIterator& iterBegin, const FieldCollectionIterator& iterEnd);
//STRIP001 
//STRIP001 	void PropagateProgress(sal_Bool _bDontPropagateOverflow);
//STRIP001 		// ruft den ProgressHandler mit STATE_PROGRESS und der aktuellen Position des SearchIterators auf
//STRIP001 
//STRIP001 	// helpers, die ich mehrmals brauche
//STRIP001 	sal_Bool MoveCursor();
//STRIP001 		// bewegt m_xSearchIterator unter Beachtung von Richtung/Ueberlauf Cursor
//STRIP001 	sal_Bool MoveField(sal_Int32& nPos, FieldCollectionIterator& iter, const FieldCollectionIterator& iterBegin, const FieldCollectionIterator& iterEnd);
//STRIP001 		// bewegt den Iterator unter Beachtung von Richtung/Ueberlauf Iterator/Ueberlauf Cursor
//STRIP001 	void BuildAndInsertFieldInfo(const ::com::sun::star::uno::Reference< ::com::sun::star::container::XIndexAccess >& xAllFields, sal_Int32 nField);
//STRIP001 		// baut eine FieldInfo zum Feld Nummer nField (in xAllFields) auf und fuegt sie zu m_arrUsedFields hinzu
//STRIP001 		// xAllFields muss den DatabaseRecord-Service unterstuetzen
//STRIP001 	::rtl::OUString FormatField(const FieldInfo& rField);
//STRIP001 		// formatiert das Feld mit dem NumberFormatter
//STRIP001 
//STRIP001 	sal_Bool HasPreviousLoc() { return m_aPreviousLocBookmark.hasValue(); }
//STRIP001 
//STRIP001 	DECL_LINK(OnSearchTerminated, FmSearchThread*);
//STRIP001 		// wird vom SuchThread benutzt, nach Rueckkehr aus diesem Handler loescht sich der Thread selber
//STRIP001 	DECL_LINK(OnNewRecordCount, void*);
//STRIP001 };

}//end of namespace binfilter
#endif // _FMSRCIMP_HXX

