/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_textanim.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:08:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif
#pragma hdrstop

#include "dialogs.hrc"

#ifndef _SVX_TEXTANIM_CXX
#define _SVX_TEXTANIM_CXX
#endif
#include "textanim.hxx"
#include "textanim.hrc"
#include "textattr.hxx"
#include "dialmgr.hxx"
#include "dlgutil.hxx"
namespace binfilter {

//STRIP001 static USHORT pRanges[] =
//STRIP001 {
//STRIP001 	SDRATTR_TEXT_ANIKIND,
//STRIP001 	SDRATTR_TEXT_ANIAMOUNT,
//STRIP001 	0
//STRIP001 };

/*************************************************************************
|*
|* Konstruktor des Tab-Dialogs: Fuegt die Seiten zum Dialog hinzu
|*
\************************************************************************/

//STRIP001 __EXPORT SvxTextTabDialog::SvxTextTabDialog( Window* pParent,
//STRIP001 								const SfxItemSet* pAttr,
//STRIP001 								const SdrView* pSdrView ) :
//STRIP001 		SfxTabDialog        ( pParent, ResId( RID_SVXDLG_TEXT, DIALOG_MGR() ), pAttr ),
//STRIP001 		rOutAttrs			( *pAttr ),
//STRIP001 		pView				( pSdrView )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	AddTabPage( RID_SVXPAGE_TEXTATTR, SvxTextAttrPage::Create, 0);
//STRIP001 	AddTabPage( RID_SVXPAGE_TEXTANIMATION, SvxTextAnimationPage::Create, 0);
//STRIP001 }

/*************************************************************************
|*
|* PageCreated()
|*
\************************************************************************/

//STRIP001 void __EXPORT SvxTextTabDialog::PageCreated( USHORT nId, SfxTabPage &rPage )
//STRIP001 {
//STRIP001 	switch( nId )
//STRIP001 	{
//STRIP001 		case RID_SVXPAGE_TEXTATTR:
//STRIP001 		{
//STRIP001 			( (SvxTextAttrPage&) rPage ).SetView( pView );
//STRIP001 			( (SvxTextAttrPage&) rPage ).Construct();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case RID_SVXPAGE_TEXTANIMATION:
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* Page
|*
\************************************************************************/

//STRIP001 SvxTextAnimationPage::SvxTextAnimationPage( Window* pWindow, const SfxItemSet& rInAttrs ) :
//STRIP001 				SfxTabPage		( pWindow, ResId( RID_SVXPAGE_TEXTANIMATION, DIALOG_MGR() ),
//STRIP001 								  rInAttrs ),
//STRIP001 				aFlEffect		( this, ResId(FL_EFFECT)),
//STRIP001 				aFtEffects		( this, ResId(FT_EFFECTS)),
//STRIP001 				aLbEffect		( this, ResId( LB_EFFECT ) ),
//STRIP001 				//aCtlEffect		( this, ResId( CTL_EFFECT ) ),
//STRIP001 				aFtDirection	( this, ResId(FT_DIRECTION) ),
//STRIP001 				aBtnUp   		( this, ResId( BTN_UP ) ),
//STRIP001 				aBtnLeft  		( this, ResId( BTN_LEFT ) ),
//STRIP001 				aBtnRight 		( this, ResId( BTN_RIGHT ) ),
//STRIP001 				aBtnDown		( this, ResId( BTN_DOWN ) ),
//STRIP001 
//STRIP001 				aFlProperties   ( this, ResId(FL_PROPERTIES)),
//STRIP001 				aTsbStartInside	( this, ResId( TSB_START_INSIDE ) ),
//STRIP001 				aTsbStopInside	( this, ResId( TSB_STOP_INSIDE ) ),
//STRIP001 
//STRIP001 				aFtCount		( this, ResId(FT_COUNT)),
//STRIP001 				aTsbEndless		( this, ResId( TSB_ENDLESS ) ),
//STRIP001 				aNumFldCount	( this, ResId( NUM_FLD_COUNT ) ),
//STRIP001 
//STRIP001 				aFtAmount		( this, ResId(FT_AMOUNT)),
//STRIP001 				aTsbPixel		( this, ResId( TSB_PIXEL ) ),
//STRIP001 				aMtrFldAmount	( this, ResId( MTR_FLD_AMOUNT ) ),
//STRIP001 
//STRIP001 				aFtDelay		( this, ResId(FT_DELAY)),
//STRIP001 				aTsbAuto   		( this, ResId( TSB_AUTO ) ),
//STRIP001 				aMtrFldDelay	( this, ResId( MTR_FLD_DELAY ) ),
//STRIP001 
//STRIP001 				rOutAttrs		( rInAttrs ),
//STRIP001 				eAniKind		( SDRTEXTANI_NONE )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	eFUnit = GetModuleFieldUnit( &rInAttrs );
//STRIP001 	SfxItemPool* pPool = rOutAttrs.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	eUnit = pPool->GetMetric( SDRATTR_TEXT_LEFTDIST );
//STRIP001 
//STRIP001 	Construct();
//STRIP001 
//STRIP001 	aLbEffect.SetSelectHdl(
//STRIP001 		LINK( this, SvxTextAnimationPage, SelectEffectHdl_Impl ) );
//STRIP001 	aTsbEndless.SetClickHdl(
//STRIP001 		LINK( this, SvxTextAnimationPage, ClickEndlessHdl_Impl ) );
//STRIP001 	aTsbAuto.SetClickHdl(
//STRIP001 		LINK( this, SvxTextAnimationPage, ClickAutoHdl_Impl ) );
//STRIP001 	aTsbPixel.SetClickHdl(
//STRIP001 		LINK( this, SvxTextAnimationPage, ClickPixelHdl_Impl ) );
//STRIP001 
//STRIP001 	Link aLink( LINK( this, SvxTextAnimationPage, ClickDirectionHdl_Impl ) );
//STRIP001 	aBtnUp.SetClickHdl( aLink );
//STRIP001 	aBtnLeft.SetClickHdl( aLink );
//STRIP001 	aBtnRight.SetClickHdl( aLink );
//STRIP001 	aBtnDown.SetClickHdl( aLink );
//STRIP001 }

/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

//STRIP001 SvxTextAnimationPage::~SvxTextAnimationPage()
//STRIP001 {
//STRIP001 }

/*************************************************************************
|*
|* Liest uebergebenen Item-Set
|*
\************************************************************************/

//STRIP001 void __EXPORT SvxTextAnimationPage::Reset( const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	const SfxItemPool* pPool = rAttrs.GetPool();
//STRIP001 
//STRIP001 	// Animationstyp
//STRIP001 	const SfxPoolItem* pItem = GetItem( rAttrs, SDRATTR_TEXT_ANIKIND );
//STRIP001 
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_TEXT_ANIKIND );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		eAniKind = ( ( const SdrTextAniKindItem* )pItem )->GetValue();
//STRIP001 		aLbEffect.SelectEntryPos( eAniKind );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aLbEffect.SetNoSelection();
//STRIP001 	aLbEffect.SaveValue();
//STRIP001 
//STRIP001 	// Animationsrichtung
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_TEXT_ANIDIRECTION );
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_TEXT_ANIDIRECTION );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		SdrTextAniDirection eValue = ( ( const SdrTextAniDirectionItem* )pItem )->GetValue();
//STRIP001 		SelectDirection( eValue );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnUp.Check( FALSE );
//STRIP001 		aBtnLeft.Check( FALSE );
//STRIP001 		aBtnRight.Check( FALSE );
//STRIP001 		aBtnDown.Check( FALSE );
//STRIP001 	}
//STRIP001 	aBtnUp.SaveValue();
//STRIP001 	aBtnLeft.SaveValue();
//STRIP001 	aBtnRight.SaveValue();
//STRIP001 	aBtnDown.SaveValue();
//STRIP001 
//STRIP001 	// Start inside
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_TEXT_ANISTARTINSIDE );
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_TEXT_ANISTARTINSIDE );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		aTsbStartInside.EnableTriState( FALSE );
//STRIP001 		BOOL bValue = ( ( const SdrTextAniStartInsideItem* )pItem )->GetValue();
//STRIP001 		if( bValue )
//STRIP001 			aTsbStartInside.SetState( STATE_CHECK );
//STRIP001 		else
//STRIP001 			aTsbStartInside.SetState( STATE_NOCHECK );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aTsbStartInside.SetState( STATE_DONTKNOW );
//STRIP001 	aTsbStartInside.SaveValue();
//STRIP001 
//STRIP001 	// Stop inside
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_TEXT_ANISTOPINSIDE );
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_TEXT_ANISTOPINSIDE );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		aTsbStopInside.EnableTriState( FALSE );
//STRIP001 		BOOL bValue = ( ( const SdrTextAniStopInsideItem* )pItem )->GetValue();
//STRIP001 		if( bValue )
//STRIP001 			aTsbStopInside.SetState( STATE_CHECK );
//STRIP001 		else
//STRIP001 			aTsbStopInside.SetState( STATE_NOCHECK );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aTsbStopInside.SetState( STATE_DONTKNOW );
//STRIP001 	aTsbStopInside.SaveValue();
//STRIP001 
//STRIP001 	// Anzahl
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_TEXT_ANICOUNT );
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_TEXT_ANICOUNT );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		aTsbEndless.EnableTriState( FALSE );
//STRIP001 		long nValue = (long) ( ( const SdrTextAniCountItem* )pItem )->GetValue();
//STRIP001 		aNumFldCount.SetValue( nValue );
//STRIP001 		if( nValue == 0 )
//STRIP001 		{
//STRIP001 			if( eAniKind == SDRTEXTANI_SLIDE )
//STRIP001 			{
//STRIP001 				aTsbEndless.SetState( STATE_NOCHECK );
//STRIP001 				aTsbEndless.Enable( FALSE );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aTsbEndless.SetState( STATE_CHECK );
//STRIP001 				aNumFldCount.SetEmptyFieldValue();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aTsbEndless.SetState( STATE_NOCHECK );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aNumFldCount.SetEmptyFieldValue();
//STRIP001 		aTsbEndless.SetState( STATE_DONTKNOW );
//STRIP001 	}
//STRIP001 	aTsbEndless.SaveValue();
//STRIP001 	aNumFldCount.SaveValue();
//STRIP001 
//STRIP001 	// Verzoegerung
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_TEXT_ANIDELAY );
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_TEXT_ANIDELAY );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		aTsbAuto.EnableTriState( FALSE );
//STRIP001 		long nValue = (long) ( ( const SdrTextAniDelayItem* )pItem )->GetValue();
//STRIP001 		aMtrFldDelay.SetValue( nValue );
//STRIP001 		if( nValue == 0 )
//STRIP001 		{
//STRIP001 			aTsbAuto.SetState( STATE_CHECK );
//STRIP001 			aMtrFldDelay.SetEmptyFieldValue();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aTsbAuto.SetState( STATE_NOCHECK );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aMtrFldDelay.SetEmptyFieldValue();
//STRIP001 		aTsbAuto.SetState( STATE_DONTKNOW );
//STRIP001 	}
//STRIP001 	aTsbAuto.SaveValue();
//STRIP001 	aMtrFldDelay.SaveValue();
//STRIP001 
//STRIP001 	// Schrittweite
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_TEXT_ANIAMOUNT );
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_TEXT_ANIAMOUNT );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		aTsbPixel.EnableTriState( FALSE );
//STRIP001 		long nValue = (long) ( ( const SdrTextAniAmountItem* )pItem )->GetValue();
//STRIP001 		if( nValue <= 0 )
//STRIP001 		{
//STRIP001 			aTsbPixel.SetState( STATE_CHECK );
//STRIP001 			nValue = -nValue;
//STRIP001 			if( nValue == 0 )
//STRIP001 				nValue++;
//STRIP001 			aMtrFldAmount.SetUnit( FUNIT_CUSTOM );
//STRIP001 			aMtrFldAmount.SetDecimalDigits( 0 );
//STRIP001 
//STRIP001 			aMtrFldAmount.SetSpinSize( 1 );
//STRIP001 			aMtrFldAmount.SetMin( 1 );
//STRIP001 			aMtrFldAmount.SetFirst( 1 );
//STRIP001 			aMtrFldAmount.SetMax( 100 );
//STRIP001 			aMtrFldAmount.SetLast( 100 );
//STRIP001 
//STRIP001 			aMtrFldAmount.SetValue( nValue );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aTsbPixel.SetState( STATE_NOCHECK );
//STRIP001 			aMtrFldAmount.SetUnit( eFUnit );
//STRIP001 			aMtrFldAmount.SetDecimalDigits( 2 );
//STRIP001 
//STRIP001 			aMtrFldAmount.SetSpinSize( 10 );
//STRIP001 			aMtrFldAmount.SetMin( 1 );
//STRIP001 			aMtrFldAmount.SetFirst( 1 );
//STRIP001 			aMtrFldAmount.SetMax( 10000 );
//STRIP001 			aMtrFldAmount.SetLast( 10000 );
//STRIP001 
//STRIP001 			SetMetricValue( aMtrFldAmount, nValue, eUnit );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aMtrFldAmount.Disable();
//STRIP001 		aMtrFldAmount.SetEmptyFieldValue();
//STRIP001 		aTsbPixel.SetState( STATE_DONTKNOW );
//STRIP001 	}
//STRIP001 	aTsbPixel.SaveValue();
//STRIP001 	aMtrFldAmount.SaveValue();
//STRIP001 
//STRIP001 
//STRIP001 	SelectEffectHdl_Impl( NULL );
//STRIP001 	ClickEndlessHdl_Impl( NULL );
//STRIP001 	ClickAutoHdl_Impl( NULL );
//STRIP001 	//ClickPixelHdl_Impl( NULL );
//STRIP001 }

/*************************************************************************
|*
|* Fuellt uebergebenen Item-Set mit Dialogbox-Attributen
|*
\************************************************************************/

//STRIP001 BOOL SvxTextAnimationPage::FillItemSet( SfxItemSet& rAttrs)
//STRIP001 {
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 	USHORT nPos;
//STRIP001 	TriState eState;
//STRIP001 
//STRIP001 	// Animationstyp
//STRIP001 	nPos = aLbEffect.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND &&
//STRIP001 		nPos != aLbEffect.GetSavedValue() )
//STRIP001 	{
//STRIP001 		rAttrs.Put( SdrTextAniKindItem( (SdrTextAniKind) nPos ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Animationsrichtung
//STRIP001 	if( aBtnUp.GetSavedValue() != aBtnUp.IsChecked() ||
//STRIP001 		aBtnLeft.GetSavedValue() != aBtnLeft.IsChecked() ||
//STRIP001 		aBtnRight.GetSavedValue() != aBtnRight.IsChecked() ||
//STRIP001 		aBtnDown.GetSavedValue() != aBtnDown.IsChecked() )
//STRIP001 	{
//STRIP001 		SdrTextAniDirection eValue = (SdrTextAniDirection) GetSelectedDirection();
//STRIP001 		rAttrs.Put( SdrTextAniDirectionItem( eValue ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Start inside
//STRIP001 	eState = aTsbStartInside.GetState();
//STRIP001 	if( eState != aTsbStartInside.GetSavedValue() )
//STRIP001 	{
//STRIP001 		rAttrs.Put( SdrTextAniStartInsideItem( (BOOL) STATE_CHECK == eState ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Stop inside
//STRIP001 	eState = aTsbStopInside.GetState();
//STRIP001 	if( eState != aTsbStopInside.GetSavedValue() )
//STRIP001 	{
//STRIP001 		rAttrs.Put( SdrTextAniStopInsideItem( (BOOL) STATE_CHECK == eState ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Anzahl
//STRIP001 	eState = aTsbEndless.GetState();
//STRIP001 	String aStr = aNumFldCount.GetText();
//STRIP001 	if( eState != aTsbEndless.GetSavedValue() ||
//STRIP001 		aStr != aNumFldCount.GetSavedValue() )
//STRIP001 	{
//STRIP001 		long nValue = 0;
//STRIP001 		if( eState == STATE_CHECK /*#89844#*/ && aTsbEndless.IsEnabled())
//STRIP001 			bModified = TRUE;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if( aStr != aNumFldCount.GetSavedValue() )
//STRIP001 			{
//STRIP001 				nValue = aNumFldCount.GetValue();
//STRIP001 				bModified = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if( bModified )
//STRIP001 			rAttrs.Put( SdrTextAniCountItem( (UINT16) nValue ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Verzoegerung
//STRIP001 	eState = aTsbAuto.GetState();
//STRIP001 	aStr = aMtrFldDelay.GetText();
//STRIP001 	if( eState != aTsbAuto.GetSavedValue() ||
//STRIP001 		aStr != aMtrFldDelay.GetSavedValue() )
//STRIP001 	{
//STRIP001 		long nValue = 0;
//STRIP001 		if( eState == STATE_CHECK )
//STRIP001 			bModified = TRUE;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if( aStr != aMtrFldDelay.GetSavedValue() )
//STRIP001 			{
//STRIP001 				nValue = aMtrFldDelay.GetValue();
//STRIP001 				bModified = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if( bModified )
//STRIP001 			rAttrs.Put( SdrTextAniDelayItem( (UINT16) nValue ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Schrittweite
//STRIP001 	eState = aTsbPixel.GetState();
//STRIP001 	aStr = aMtrFldAmount.GetText();
//STRIP001 	if( eState != aTsbPixel.GetSavedValue() ||
//STRIP001 		aStr != aMtrFldAmount.GetSavedValue() )
//STRIP001 	{
//STRIP001 		long nValue = 0;
//STRIP001 		if( eState == STATE_CHECK )
//STRIP001 		{
//STRIP001 			nValue = aMtrFldAmount.GetValue();
//STRIP001 			nValue = -nValue;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nValue = GetCoreValue( aMtrFldAmount, eUnit );
//STRIP001 		}
//STRIP001 		rAttrs.Put( SdrTextAniAmountItem( (INT16) nValue ) );
//STRIP001 
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return( bModified );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxTextAnimationPage::Construct()
//STRIP001 {
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 USHORT*	SvxTextAnimationPage::GetRanges()
//STRIP001 {
//STRIP001 	return( pRanges );
//STRIP001 }

/*************************************************************************
|*
|* Erzeugt die Seite
|*
\************************************************************************/

//STRIP001 SfxTabPage* SvxTextAnimationPage::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	return( new SvxTextAnimationPage( pWindow, rAttrs ) );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxTextAnimationPage, SelectEffectHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT nPos = aLbEffect.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		eAniKind = (SdrTextAniKind) nPos;
//STRIP001 		switch( eAniKind )
//STRIP001 		{
//STRIP001 			case SDRTEXTANI_NONE:
//STRIP001 			{
//STRIP001                 aFtDirection.Disable();
//STRIP001                 aBtnUp.Disable();
//STRIP001 				aBtnLeft.Disable();
//STRIP001 				aBtnRight.Disable();
//STRIP001 				aBtnDown.Disable();
//STRIP001 				aTsbStartInside.Disable();
//STRIP001 				aTsbStopInside.Disable();
//STRIP001 
//STRIP001 				aTsbEndless.Disable();
//STRIP001 				aNumFldCount.Disable();
//STRIP001 				aFtCount.Disable();
//STRIP001 
//STRIP001 				aTsbAuto.Disable();
//STRIP001 				aMtrFldDelay.Disable();
//STRIP001 				aFtDelay.Disable();
//STRIP001 
//STRIP001 				aTsbPixel.Disable();
//STRIP001 				aMtrFldAmount.Disable();
//STRIP001 				aFtAmount.Disable();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case SDRTEXTANI_BLINK:
//STRIP001 			case SDRTEXTANI_SCROLL:
//STRIP001 			case SDRTEXTANI_ALTERNATE:
//STRIP001 			case SDRTEXTANI_SLIDE:
//STRIP001 			{
//STRIP001 				if( eAniKind == SDRTEXTANI_SLIDE )
//STRIP001 				{
//STRIP001 					aTsbStartInside.Disable();
//STRIP001 					aTsbStopInside.Disable();
//STRIP001 
//STRIP001 					aTsbEndless.Disable();
//STRIP001 					aNumFldCount.Enable();
//STRIP001 					aNumFldCount.SetValue( aNumFldCount.GetValue() );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					aTsbStartInside.Enable();
//STRIP001 					aTsbStopInside.Enable();
//STRIP001 
//STRIP001 					aTsbEndless.Enable();
//STRIP001 					ClickEndlessHdl_Impl( NULL );
//STRIP001 				}
//STRIP001 				aFtCount.Enable();
//STRIP001 
//STRIP001 				aTsbAuto.Enable();
//STRIP001 				aFtDelay.Enable();
//STRIP001 				ClickAutoHdl_Impl( NULL );
//STRIP001 
//STRIP001 				if( eAniKind == SDRTEXTANI_BLINK )
//STRIP001 				{
//STRIP001                     aFtDirection.Disable();
//STRIP001                     aBtnUp.Disable();
//STRIP001 					aBtnLeft.Disable();
//STRIP001 					aBtnRight.Disable();
//STRIP001 					aBtnDown.Disable();
//STRIP001 
//STRIP001 					aTsbPixel.Disable();
//STRIP001 					aMtrFldAmount.Disable();
//STRIP001 					aFtAmount.Disable();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001                     aFtDirection.Enable();
//STRIP001                     aBtnUp.Enable();
//STRIP001 					aBtnLeft.Enable();
//STRIP001 					aBtnRight.Enable();
//STRIP001 					aBtnDown.Enable();
//STRIP001 
//STRIP001 					aTsbPixel.Enable();
//STRIP001 					aMtrFldAmount.Enable();
//STRIP001 					aFtAmount.Enable();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxTextAnimationPage, ClickEndlessHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 
//STRIP001 	if( eAniKind != SDRTEXTANI_SLIDE )
//STRIP001 	{
//STRIP001 		TriState eState = aTsbEndless.GetState();
//STRIP001 		if( eState != STATE_NOCHECK )
//STRIP001 		{
//STRIP001 			aNumFldCount.Disable();
//STRIP001 			aNumFldCount.SetEmptyFieldValue();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aNumFldCount.Enable();
//STRIP001 			aNumFldCount.SetValue( aNumFldCount.GetValue() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxTextAnimationPage, ClickAutoHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	TriState eState = aTsbAuto.GetState();
//STRIP001 	if( eState != STATE_NOCHECK )
//STRIP001 	{
//STRIP001 		aMtrFldDelay.Disable();
//STRIP001 		aMtrFldDelay.SetEmptyFieldValue();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aMtrFldDelay.Enable();
//STRIP001 		aMtrFldDelay.SetValue( aMtrFldDelay.GetValue() );
//STRIP001 	}
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxTextAnimationPage, ClickPixelHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	TriState eState = aTsbPixel.GetState();
//STRIP001 	if( eState == STATE_CHECK )
//STRIP001 	{
//STRIP001 		long nValue = aMtrFldAmount.GetValue() / 10;
//STRIP001 		aMtrFldAmount.Enable();
//STRIP001 		aMtrFldAmount.SetUnit( FUNIT_CUSTOM );
//STRIP001 		//SetFieldUnit( aMtrFldAmount, FUNIT_CUSTOM );
//STRIP001 		aMtrFldAmount.SetDecimalDigits( 0 );
//STRIP001 
//STRIP001 		aMtrFldAmount.SetSpinSize( 1 );
//STRIP001 		aMtrFldAmount.SetMin( 1 );
//STRIP001 		aMtrFldAmount.SetFirst( 1 );
//STRIP001 		aMtrFldAmount.SetMax( 100 );
//STRIP001 		aMtrFldAmount.SetLast( 100 );
//STRIP001 
//STRIP001 		aMtrFldAmount.SetValue( nValue );
//STRIP001 	}
//STRIP001 	else if( eState == STATE_NOCHECK )
//STRIP001 	{
//STRIP001 		long nValue = aMtrFldAmount.GetValue() * 10;
//STRIP001 		aMtrFldAmount.Enable();
//STRIP001 		aMtrFldAmount.SetUnit( eFUnit );
//STRIP001 		//SetFieldUnit( aMtrFldAmount, eFUnit );
//STRIP001 		aMtrFldAmount.SetDecimalDigits( 2 );
//STRIP001 
//STRIP001 		aMtrFldAmount.SetSpinSize( 10 );
//STRIP001 		aMtrFldAmount.SetMin( 1 );
//STRIP001 		aMtrFldAmount.SetFirst( 1 );
//STRIP001 		aMtrFldAmount.SetMax( 10000 );
//STRIP001 		aMtrFldAmount.SetLast( 10000 );
//STRIP001 
//STRIP001 		aMtrFldAmount.SetValue( nValue );
//STRIP001 	}
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxTextAnimationPage, ClickDirectionHdl_Impl, ImageButton *, pBtn )
//STRIP001 {
//STRIP001 	aBtnUp.Check( pBtn == &aBtnUp );
//STRIP001 	aBtnLeft.Check( pBtn == &aBtnLeft );
//STRIP001 	aBtnRight.Check( pBtn == &aBtnRight );
//STRIP001 	aBtnDown.Check( pBtn == &aBtnDown );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxTextAnimationPage::SelectDirection( USHORT nValue )
//STRIP001 {
//STRIP001 	aBtnUp.Check( nValue == SDRTEXTANI_UP );
//STRIP001 	aBtnLeft.Check( nValue == SDRTEXTANI_LEFT );
//STRIP001 	aBtnRight.Check( nValue == SDRTEXTANI_RIGHT );
//STRIP001 	aBtnDown.Check( nValue == SDRTEXTANI_DOWN );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 USHORT SvxTextAnimationPage::GetSelectedDirection()
//STRIP001 {
//STRIP001 	USHORT nValue = 0;
//STRIP001 
//STRIP001 	if( aBtnUp.IsChecked() )
//STRIP001 		nValue = SDRTEXTANI_UP;
//STRIP001 	else if( aBtnLeft.IsChecked() )
//STRIP001 		nValue = SDRTEXTANI_LEFT;
//STRIP001 	else if( aBtnRight.IsChecked() )
//STRIP001 		nValue = SDRTEXTANI_RIGHT;
//STRIP001 	else if( aBtnDown.IsChecked() )
//STRIP001 		nValue = SDRTEXTANI_DOWN;
//STRIP001 
//STRIP001 	return( nValue );
//STRIP001 }


}
