/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_dlgctl3d.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:40:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include "dialogs.hrc"

#include <math.h>

#ifndef _SVX_XFLCLIT_HXX //autogen
#include <xflclit.hxx>
#endif
#ifndef _SVX_FMMODEL_HXX
#include <fmmodel.hxx>
#endif
#ifndef _SVX_FMPAGE_HXX
#include <fmpage.hxx>
#endif
#ifndef _E3D_VIEW3D_HXX //autogen
#include <view3d.hxx>
#endif
#ifndef _E3D_POLYSC3D_HXX //autogen
#include <polysc3d.hxx>
#endif
#ifndef _E3D_OBJ3D_HXX //autogen
#include <obj3d.hxx>
#endif
#ifndef _CAMERA3D_HXX //autogen
#include <camera3d.hxx>
#endif
#ifndef _VOLUME3D_HXX //autogen
#include <volume3d.hxx>
#endif
#ifndef _E3D_SPHERE3D_HXX //autogen
#include <sphere3d.hxx>
#endif
#ifndef _E3D_CUBE3D_HXX //autogen
#include <cube3d.hxx>
#endif
#ifndef _SV_EVENT_HXX //autogen
#include <vcl/event.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX
#include <svtools/itempool.hxx>
#endif
#ifndef _SFXSTYLE_HXX
#include <svtools/style.hxx>
#endif

#include "dlgctl3d.hxx"
#include <goodies/base3d.hxx>
#include <tools/link.hxx>
namespace binfilter {

/*************************************************************************
|*  3D Preview Control
|*  Ctor
\************************************************************************/
//STRIP001 Svx3DPreviewControl::Svx3DPreviewControl( Window* pParent, const ResId& rResId ) :
//STRIP001 			Control		( pParent, rResId ),
//STRIP001 			pModel		( NULL ),
//STRIP001 			pFmPage		( NULL ),
//STRIP001 			pScene		( NULL ),
//STRIP001 			p3DView		( NULL ),
//STRIP001 			p3DObj		( NULL ),
//STRIP001 			nObjectType	( PREVIEW_OBJECTTYPE_SPHERE )
//STRIP001 {
//STRIP001 	Construct();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* Ctor
//STRIP001 \************************************************************************/
//STRIP001 Svx3DPreviewControl::Svx3DPreviewControl( Window* pParent, WinBits nStyle ) :
//STRIP001 			Control		( pParent, nStyle ),
//STRIP001 			pModel		( NULL ),
//STRIP001 			pFmPage		( NULL ),
//STRIP001 			pScene		( NULL ),
//STRIP001 			p3DView		( NULL ),
//STRIP001 			p3DObj		( NULL ),
//STRIP001 			nObjectType	( PREVIEW_OBJECTTYPE_SPHERE )
//STRIP001 {
//STRIP001 	Construct();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* Dtor
//STRIP001 \************************************************************************/
//STRIP001 Svx3DPreviewControl::~Svx3DPreviewControl()
//STRIP001 {
//STRIP001 	delete p3DView;
//STRIP001 	delete pModel;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* Svx3DPreviewControl::Construct
//STRIP001 \************************************************************************/
//STRIP001 void Svx3DPreviewControl::Construct()
//STRIP001 {
//STRIP001     // Do never mirror the preview window.  This explicitly includes right
//STRIP001     // to left writing environments.
//STRIP001     EnableRTL (FALSE);
//STRIP001 
//STRIP001 	SetMapMode( MAP_100TH_MM );
//STRIP001 
//STRIP001 	// Model
//STRIP001 	pModel = new FmFormModel();
//STRIP001 	pModel->GetItemPool().FreezeIdRanges();
//STRIP001 
//STRIP001 	// Page
//STRIP001 	pFmPage = new FmFormPage( *pModel, NULL );
//STRIP001 	pModel->InsertPage( pFmPage, 0 );
//STRIP001 
//STRIP001 	// 3D View
//STRIP001 	p3DView = new E3dView( pModel, this );
//STRIP001 
//STRIP001 	// 3D Scene
//STRIP001 	pScene = new E3dPolyScene(p3DView->Get3DDefaultAttributes());
//STRIP001 
//STRIP001 	// Objekt
//STRIP001 	SetObjectType(PREVIEW_OBJECTTYPE_SPHERE);
//STRIP001 
//STRIP001 	// Kameraeinstellungen, Perspektive ...
//STRIP001 	Camera3D& rCamera  = (Camera3D&) pScene->GetCamera();
//STRIP001 	const Volume3D& rVolume = pScene->GetBoundVolume();
//STRIP001 	double fW = rVolume.GetWidth();
//STRIP001 	double fH = rVolume.GetHeight();
//STRIP001 	double fCamZ = rVolume.MaxVec().Z() + ((fW + fH) / 2.0);
//STRIP001 
//STRIP001 	rCamera.SetAutoAdjustProjection(FALSE);
//STRIP001 	rCamera.SetViewWindow(- fW / 2, - fH / 2, fW, fH);
//STRIP001 	Vector3D aLookAt;
//STRIP001 	double fDefaultCamPosZ = p3DView->GetDefaultCamPosZ();
//STRIP001 	Vector3D aCamPos(0.0, 0.0, fCamZ < fDefaultCamPosZ ? fDefaultCamPosZ : fCamZ);
//STRIP001 	rCamera.SetPosAndLookAt(aCamPos, aLookAt);
//STRIP001 	double fDefaultCamFocal = p3DView->GetDefaultCamFocal();
//STRIP001 	rCamera.SetFocalLength(fDefaultCamFocal);
//STRIP001 	rCamera.SetDefaults(Vector3D(0.0, 0.0, fDefaultCamPosZ), aLookAt, fDefaultCamFocal);
//STRIP001 
//STRIP001 	pScene->SetCamera( rCamera );
//STRIP001 	pFmPage->InsertObject( pScene );
//STRIP001 
//STRIP001 	pScene->RotateX( DEG2RAD( 25 ) );
//STRIP001 	pScene->RotateY( DEG2RAD( 40 ) ); // Weil es auch ein Wuerfel sein kann
//STRIP001 
//STRIP001 	// SnapRects der Objekte ungueltig
//STRIP001 	pScene->SetRectsDirty();
//STRIP001 
//STRIP001 	// Transformationen initialisieren, damit bei RecalcSnapRect()
//STRIP001 	// richtig gerechnet wird
//STRIP001 	pScene->InitTransformationSet();
//STRIP001 
//STRIP001 	SfxItemSet aSet( pModel->GetItemPool(),
//STRIP001 		XATTR_LINESTYLE, XATTR_LINESTYLE,
//STRIP001 		XATTR_FILL_FIRST, XATTR_FILLBITMAP, 0 );
//STRIP001 	aSet.Put( XLineStyleItem( XLINE_NONE ) );
//STRIP001 	aSet.Put( XFillStyleItem( XFILL_SOLID ) );
//STRIP001 	aSet.Put( XFillColorItem( String(), Color( COL_WHITE ) ) );
//STRIP001 
//STRIP001 //-/	pScene->NbcSetAttributes( aSet, FALSE );
//STRIP001 	pScene->SetItemSet(aSet);
//STRIP001 
//STRIP001 	// Default-Attribute holen (ohne markiertes Objekt)
//STRIP001 //	SfxItemSet aDefaultSet = p3DView->Get3DAttributes();
//STRIP001 
//STRIP001 	// PageView
//STRIP001 	SdrPageView* pPageView = p3DView->ShowPage( pFmPage, Point() );
//STRIP001 	p3DView->SetMarkHdlHidden( TRUE );
//STRIP001 
//STRIP001 	// Szene markieren
//STRIP001 	p3DView->MarkObj( pScene, pPageView );
//STRIP001 
//STRIP001 	// Initiale Groesse
//STRIP001 	pScene->FitSnapRectToBoundVol();
//STRIP001 //	Set3DAttributes(aDefaultSet);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* Svx3DPreviewControl::Resize
//STRIP001 \************************************************************************/
//STRIP001 void Svx3DPreviewControl::Resize()
//STRIP001 {
//STRIP001 	// Seite der Page
//STRIP001 	Size aSize( GetSizePixel() );
//STRIP001 	aSize = PixelToLogic( aSize );
//STRIP001 	pFmPage->SetSize( aSize );
//STRIP001 
//STRIP001 	// Groesse setzen
//STRIP001 	Size aObjSize( aSize.Width()*5/6, aSize.Height()*5/6 );
//STRIP001 	Point aObjPoint( (aSize.Width() - aObjSize.Width()) / 2,
//STRIP001 		(aSize.Height() - aObjSize.Height()) / 2);
//STRIP001 	Rectangle aRect( aObjPoint, aObjSize);
//STRIP001 	pScene->SetSnapRect( aRect );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* Svx3DPreviewControl::Paint
//STRIP001 \************************************************************************/
//STRIP001 void Svx3DPreviewControl::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	p3DView->InitRedraw( this, Region( rRect ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* Svx3DPreviewControl::MouseButtonDown
//STRIP001 \************************************************************************/
//STRIP001 void Svx3DPreviewControl::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	Control::MouseButtonDown( rMEvt );
//STRIP001 	if( rMEvt.IsShift() && rMEvt.IsMod1() )
//STRIP001 	{
//STRIP001 		SetObjectType( (nObjectType+1) % 2 );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* Svx3DPreviewControl::SetObjectType
//STRIP001 \************************************************************************/
//STRIP001 void Svx3DPreviewControl::SetObjectType( UINT16 nType )
//STRIP001 {
//STRIP001 	if( nObjectType != nType || !p3DObj)
//STRIP001 	{
//STRIP001 		SfxItemSet aSet(pModel->GetItemPool(),
//STRIP001 			SDRATTR_START,	SDRATTR_END,
//STRIP001 			0, 0);
//STRIP001 		nObjectType = nType;
//STRIP001 
//STRIP001 		if( p3DObj )
//STRIP001 		{
//STRIP001 //-/			p3DObj->TakeAttributes( aSet, FALSE, FALSE );
//STRIP001 			aSet.Put(p3DObj->GetItemSet());
//STRIP001 
//STRIP001 			pScene->Remove3DObj( p3DObj );
//STRIP001 			delete p3DObj;
//STRIP001 			p3DObj = NULL;
//STRIP001 		}
//STRIP001 
//STRIP001 		switch( nType )
//STRIP001 		{
//STRIP001 			case PREVIEW_OBJECTTYPE_SPHERE:
//STRIP001 			{
//STRIP001 				// Kugel erzeugen
//STRIP001 				p3DObj = new E3dSphereObj(
//STRIP001 					p3DView->Get3DDefaultAttributes(),
//STRIP001 					Vector3D( 0, 0, 0 ),
//STRIP001 					Vector3D( 5000, 5000, 5000 ));
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case PREVIEW_OBJECTTYPE_CUBE:
//STRIP001 			{
//STRIP001 				// Wuerfel erzeugen
//STRIP001 				p3DObj = new E3dCubeObj(
//STRIP001 					p3DView->Get3DDefaultAttributes(),
//STRIP001 					Vector3D( -2500, -2500, -2500 ),
//STRIP001 					Vector3D( 5000, 5000, 5000 ));
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		// Rein in die Szene
//STRIP001 		pScene->Insert3DObj( p3DObj );
//STRIP001 
//STRIP001 //-/		p3DObj->NbcSetAttributes( aSet, FALSE );
//STRIP001 		p3DObj->SetItemSet(aSet);
//STRIP001 
//STRIP001 		// Refresh
//STRIP001 		Resize();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* Svx3DPreviewControl::Get3DAttributes
//STRIP001 \************************************************************************/
//STRIP001 SfxItemSet Svx3DPreviewControl::Get3DAttributes() const
//STRIP001 {
//STRIP001 	return( p3DView->Get3DAttributes( pScene ) );
//STRIP001 }
//STRIP001 /*************************************************************************
//STRIP001 |* Svx3DPreviewControl::Set3DAttributes
//STRIP001 \************************************************************************/
//STRIP001 void Svx3DPreviewControl::Set3DAttributes( const SfxItemSet& rAttr )
//STRIP001 {
//STRIP001 	p3DView->Set3DAttributes( rAttr, pScene, TRUE );
//STRIP001 	Resize();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |* Svx3DPreviewControl::SetObjectType
//STRIP001 \************************************************************************/
//STRIP001 void Svx3DPreviewControl::Set3DObject( const E3dObject* pObj )
//STRIP001 {
//STRIP001 	if( pObj->ISA( E3dCompoundObject ) )
//STRIP001 	{
//STRIP001 		pScene->Remove3DObj( p3DObj );
//STRIP001 		delete p3DObj;
//STRIP001 		p3DObj = (E3dCompoundObject*)pObj->Clone();
//STRIP001 		pScene->Insert3DObj( p3DObj );
//STRIP001 		Resize();
//STRIP001 	}
//STRIP001 	else if( pObj->ISA( E3dPolyScene ) )
//STRIP001 	{
//STRIP001 		delete pFmPage->RemoveObject( pScene->GetOrdNum() );
//STRIP001 		p3DObj = NULL;
//STRIP001 		pScene = (E3dPolyScene*)pObj->Clone();
//STRIP001 		pFmPage->InsertObject( pScene );
//STRIP001 		Resize();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*  Control zur Darstellung und Auswahl der Eckpunkte (und Mittelpunkt)
//STRIP001 |*  eines 3D-Objekts
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxRectCtl3D::SvxRectCtl3D( Window* pParent,
//STRIP001 							const ResId& rResId,
//STRIP001 							USHORT nBorderWidth,
//STRIP001 							USHORT nBorderHeight,
//STRIP001 							USHORT nCircle ) :
//STRIP001 						Control( pParent, rResId ),
//STRIP001 						nBW( nBorderWidth ),
//STRIP001 						nBH( nBorderHeight ),
//STRIP001 						nRadius( nCircle)
//STRIP001 
//STRIP001 {
//STRIP001     // Do never mirror the preview window.  This explicitly includes right
//STRIP001     // to left writing environments.
//STRIP001     EnableRTL (FALSE);
//STRIP001 
//STRIP001 	SetMapMode( MAP_100TH_MM );
//STRIP001 	SetBackground( Wallpaper( Color( COL_LIGHTGRAY ) ) );
//STRIP001 
//STRIP001 	aSize = GetOutputSize();
//STRIP001 	long nW = aSize.Width() - nBW;
//STRIP001 	long nH = aSize.Height() - nBH;
//STRIP001 	long nBWh = nBW / 2; // BorderWidthHalf
//STRIP001 	long nBHh = nBH / 2; // BorderHeightHalf
//STRIP001 
//STRIP001 	// PointArray wird mit Koordinaten des Controls gefuellt,
//STRIP001 	// um schneller painten zu knnen
//STRIP001 
//STRIP001 	aPointArray[0]  = Point(); // Leer -> dummy
//STRIP001 	aPointArray[1]  = Point( nW*1/2 + nBWh, 0      + nBHh );
//STRIP001 	aPointArray[2]  = Point( nW*1/4 + nBWh, nH*1/8 + nBHh );
//STRIP001 	aPointArray[3]  = Point( nW*3/4 + nBWh, nH*1/8 + nBHh );
//STRIP001 	aPointArray[4]  = Point( 0      + nBWh, nH*2/8 + nBHh );
//STRIP001 	aPointArray[5]  = Point( nW*1/2 + nBWh, nH*2/8 + nBHh );
//STRIP001 	aPointArray[6]  = Point( nW     + nBWh, nH*2/8 + nBHh );
//STRIP001 	aPointArray[7]  = Point( nW*1/4 + nBWh, nH*3/8 + nBHh );
//STRIP001 	aPointArray[8]  = Point( nW*3/4 + nBWh, nH*3/8 + nBHh );
//STRIP001 	aPointArray[9]  = Point( 0      + nBWh, nH*4/8 + nBHh );
//STRIP001 	aPointArray[10] = Point( nW*1/2 + nBWh, nH*4/8 + nBHh );
//STRIP001 	aPointArray[11] = Point( nW     + nBWh, nH*4/8 + nBHh );
//STRIP001 	aPointArray[12] = Point( nW*1/4 + nBWh, nH*5/8 + nBHh );
//STRIP001 	aPointArray[13] = Point( nW*3/4 + nBWh, nH*5/8 + nBHh );
//STRIP001 	aPointArray[14] = Point( 0      + nBWh, nH*6/8 + nBHh );
//STRIP001 	aPointArray[15] = Point( nW*1/2 + nBWh, nH*6/8 + nBHh );
//STRIP001 	aPointArray[16] = Point( nW     + nBWh, nH*6/8 + nBHh );
//STRIP001 	aPointArray[17] = Point( nW*1/4 + nBWh, nH*7/8 + nBHh );
//STRIP001 	aPointArray[18] = Point( nW*3/4 + nBWh, nH*7/8 + nBHh );
//STRIP001 	aPointArray[19] = Point( nW*1/2 + nBWh, nH     + nBHh );
//STRIP001 
//STRIP001 	// Distanz -> halbe Rahmenbreite
//STRIP001 	nDist = (short) nBWh;
//STRIP001 
//STRIP001 	aPolyPoints1[0] = Point( aPointArray[19].X(),
//STRIP001 						 aPointArray[19].Y() - nDist );
//STRIP001 	aPolyPoints1[1] = Point( ( aPointArray[14].X() + aPointArray[17].X() ) / 2,
//STRIP001 						 ( aPointArray[14].Y() + aPointArray[17].Y() ) / 2 - nDist );
//STRIP001 	aPolyPoints1[2] = Point( ( aPointArray[4].X() + aPointArray[7].X() ) / 2,
//STRIP001 						 ( aPointArray[4].Y() + aPointArray[7].Y() ) / 2 + nDist );
//STRIP001 	aPolyPoints1[3] = Point( aPointArray[10].X(),
//STRIP001 						 aPointArray[10].Y() + nDist );
//STRIP001 
//STRIP001 	aPolyPoints2[0] = aPolyPoints1[0];
//STRIP001 	aPolyPoints2[1] = Point( ( aPointArray[16].X() + aPointArray[18].X() ) / 2,
//STRIP001 						 ( aPointArray[16].Y() + aPointArray[18].Y() ) / 2 - nDist);
//STRIP001 	aPolyPoints2[2] = Point( ( aPointArray[6].X() + aPointArray[8].X() ) / 2,
//STRIP001 						 ( aPointArray[6].Y() + aPointArray[8].Y() ) / 2 + nDist );
//STRIP001 	aPolyPoints2[3] = aPolyPoints1[3];
//STRIP001 
//STRIP001 	aPolyPoints3[0] = aPolyPoints1[3];
//STRIP001 	aPolyPoints3[1] = aPolyPoints1[2];
//STRIP001 	aPolyPoints3[2] = Point( ( aPointArray[2].X() + aPointArray[3].X() ) / 2,
//STRIP001 						 ( aPointArray[2].Y() + aPointArray[3].Y() ) / 2 + nDist );
//STRIP001 	aPolyPoints3[3] = aPolyPoints2[2];
//STRIP001 
//STRIP001 	aPoly1 = Polygon( 4, aPolyPoints1 );
//STRIP001 	aPoly2 = Polygon( 4, aPolyPoints2 );
//STRIP001 	aPoly3 = Polygon( 4, aPolyPoints3 );
//STRIP001 
//STRIP001 	Reset();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*  Dtor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxRectCtl3D::~SvxRectCtl3D()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*  Zeichnet das Control (Rechteck mit 9 Kreisen)
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxRectCtl3D::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 
//STRIP001 	if( IsEnabled() )
//STRIP001 		SetLineColor( Color( COL_BLACK ) );
//STRIP001 	else
//STRIP001 		SetLineColor( Color( COL_GRAY ) );
//STRIP001 
//STRIP001 	// Zeichnen des Polygons ( Darstellungsobjekt )
//STRIP001 	SetFillColor( Color( COL_GRAY ) );
//STRIP001 	DrawPolygon( aPoly1 );
//STRIP001 	SetFillColor( Color( COL_CYAN ) );
//STRIP001 	DrawPolygon( aPoly2 );
//STRIP001 	SetFillColor( Color( COL_LIGHTGRAY ) );
//STRIP001 	DrawPolygon( aPoly3 );
//STRIP001 
//STRIP001 	// Zeichnen des Drahtgeruestes
//STRIP001 	DrawLine( aPointArray[ 1], aPointArray[ 4] );
//STRIP001 	DrawLine( aPointArray[ 1], aPointArray[ 6] );
//STRIP001 	DrawLine( aPointArray[ 4], aPointArray[10] );
//STRIP001 	DrawLine( aPointArray[ 6], aPointArray[10] );
//STRIP001 	DrawLine( aPointArray[ 4], aPointArray[14] );
//STRIP001 	DrawLine( aPointArray[10], aPointArray[19] );
//STRIP001 	DrawLine( aPointArray[ 6], aPointArray[16] );
//STRIP001 	DrawLine( aPointArray[14], aPointArray[19] );
//STRIP001 	DrawLine( aPointArray[16], aPointArray[19] );
//STRIP001 
//STRIP001 	// Zeichnen der Kreise
//STRIP001 	if( IsEnabled() )
//STRIP001 	{
//STRIP001 		SetLineColor( Color( COL_LIGHTBLUE ) );
//STRIP001 		SetFillColor( Color( COL_WHITE ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SetLineColor( Color( COL_GRAY ) );
//STRIP001 		SetFillColor( Color( COL_LIGHTGRAY ) );
//STRIP001 	}
//STRIP001 	for( int i = 1; i < 20; i++ )
//STRIP001 	{
//STRIP001 		if( nActPoint == i )
//STRIP001 		{
//STRIP001 			const Color& rOldLineColor = GetLineColor();
//STRIP001 			const Color& rOldFillColor = GetFillColor();
//STRIP001 
//STRIP001 			SetLineColor( Color( COL_YELLOW ) );
//STRIP001 			SetFillColor( Color( COL_WHITE ) );
//STRIP001 
//STRIP001 			DrawEllipse( Rectangle(
//STRIP001 					aPointArray[i] - Point( nRadius+100, nRadius+100 ),
//STRIP001 					aPointArray[i] + Point( nRadius+100, nRadius+100 ) ) );
//STRIP001 
//STRIP001 			DrawEllipse( Rectangle(
//STRIP001 					aPointArray[i] - Point( nRadius+50, nRadius+50 ),
//STRIP001 					aPointArray[i] + Point( nRadius+50, nRadius+50 ) ) );
//STRIP001 
//STRIP001 			SetFillColor( Color( COL_YELLOW ) );
//STRIP001 
//STRIP001 			DrawEllipse( Rectangle(
//STRIP001 					aPointArray[i] - Point( nRadius, nRadius ),
//STRIP001 					aPointArray[i] + Point( nRadius, nRadius ) ) );
//STRIP001 
//STRIP001 			SetLineColor( rOldLineColor );
//STRIP001 			SetFillColor( rOldFillColor );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			DrawEllipse( Rectangle(
//STRIP001 				aPointArray[i] - Point( nRadius, nRadius ),
//STRIP001 				aPointArray[i] + Point( nRadius, nRadius ) ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*  Das angeklickte Rechteck wird ermittelt um die Farbe zu wechseln
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxRectCtl3D::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	Point aPt = PixelToLogic( rMEvt.GetPosPixel() );
//STRIP001 
//STRIP001 	for( int i = 1; i < 20; i++ )
//STRIP001 	{
//STRIP001 		Rectangle aRect( aPointArray[i] - Point( nRadius, nRadius ),
//STRIP001 						 aPointArray[i] + Point( nRadius, nRadius ) );
//STRIP001 		if( aRect.IsInside( aPt ) )
//STRIP001 		{
//STRIP001 			nOldPoint = nActPoint;
//STRIP001 			nActPoint = i;
//STRIP001 
//STRIP001 			// Neuen Kreis neu Zeichnen
//STRIP001 			aRect = Rectangle( aPointArray[i] - Point( nRadius+100, nRadius+100 ),
//STRIP001 						aPointArray[i] + Point( nRadius+100, nRadius+100 ) );
//STRIP001 			Invalidate( aRect );
//STRIP001 
//STRIP001 			// Alten Kreis neu Zeichnen
//STRIP001 			aRect = Rectangle( aPointArray[nOldPoint] - Point( nRadius+100, nRadius+100 ),
//STRIP001 						aPointArray[nOldPoint] + Point( nRadius+100, nRadius+100 ) );
//STRIP001 			Invalidate( aRect );
//STRIP001 
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*  Bewirkt den Ursprungszustand des Controls
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxRectCtl3D::Reset()
//STRIP001 {
//STRIP001 	nActPoint = 10;
//STRIP001 	nOldPoint = 0;
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*  Gibt den aktuell ausgewaehlten Point als Vector zurueck
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 Vector3D SvxRectCtl3D::GetVector()
//STRIP001 {
//STRIP001 	return( PointNumToVector( nActPoint ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*  Setzt den uebergebenen Vector als Point
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxRectCtl3D::SetPoint( Vector3D nVect )
//STRIP001 {
//STRIP001 	nActPoint = VectorToPointNum( nVect );
//STRIP001 	if( nActPoint )
//STRIP001 		Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*  Konvertiert den uebergebenen Punkt in einen Vector3D
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 Vector3D SvxRectCtl3D::PointNumToVector( short nPoint )
//STRIP001 {
//STRIP001 	Vector3D aVect;
//STRIP001 
//STRIP001 	switch( nPoint )
//STRIP001 	{
//STRIP001 		case  1: aVect.X() =  0.0;  aVect.Y() =  1.0; aVect.Z() = -1.0; break;
//STRIP001 		case  2: aVect.X() = -1.0;  aVect.Y() =  1.0; aVect.Z() = -1.0; break;
//STRIP001 		case  3: aVect.X() =  1.0;  aVect.Y() =  1.0; aVect.Z() = -1.0; break;
//STRIP001 		case  4: aVect.X() = -1.0;  aVect.Y() =  1.0; aVect.Z() =  0.0; break;
//STRIP001 		case  5: aVect.X() =  0.0;  aVect.Y() =  1.0; aVect.Z() =  0.0; break;
//STRIP001 		case  6: aVect.X() =  1.0;  aVect.Y() =  1.0; aVect.Z() =  0.0; break;
//STRIP001 		case  7: aVect.X() = -1.0;  aVect.Y() =  1.0; aVect.Z() =  1.0; break;
//STRIP001 		case  8: aVect.X() =  1.0;  aVect.Y() =  1.0; aVect.Z() =  1.0; break;
//STRIP001 		case  9: aVect.X() = -1.0;  aVect.Y() =  0.0; aVect.Z() =  0.0; break;
//STRIP001 		case 10: aVect.X() =  0.0;  aVect.Y() =  1.0; aVect.Z() =  1.0; break;
//STRIP001 		case 11: aVect.X() =  1.0;  aVect.Y() =  0.0; aVect.Z() =  0.0; break;
//STRIP001 		case 12: aVect.X() = -1.0;  aVect.Y() =  0.0; aVect.Z() =  1.0; break;
//STRIP001 		case 13: aVect.X() =  1.0;  aVect.Y() =  0.0; aVect.Z() =  1.0; break;
//STRIP001 		case 14: aVect.X() = -1.0;  aVect.Y() = -1.0; aVect.Z() =  0.0; break;
//STRIP001 		case 15: aVect.X() =  0.0;  aVect.Y() =  0.0; aVect.Z() =  1.0; break;
//STRIP001 		case 16: aVect.X() =  1.0;  aVect.Y() = -1.0; aVect.Z() =  0.0; break;
//STRIP001 		case 17: aVect.X() = -1.0;  aVect.Y() = -1.0; aVect.Z() =  1.0; break;
//STRIP001 		case 18: aVect.X() =  1.0;  aVect.Y() = -1.0; aVect.Z() =  1.0; break;
//STRIP001 		case 19: aVect.X() =  0.0;  aVect.Y() = -1.0; aVect.Z() =  1.0; break;
//STRIP001 		default: aVect.X() = -1.0;  aVect.Y() = -1.0; aVect.Z() = -1.0; break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return( aVect );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*  Konvertiert den uebergebenen Vector3D in einen Punkt
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 short SvxRectCtl3D::VectorToPointNum( Vector3D aVect )
//STRIP001 {
//STRIP001 	short nPoint = 0;
//STRIP001 
//STRIP001 	if	   ( fabs (aVect.X()          ) < 1e-3 && fabs (aVect.Y() - 0.70711) < 1e-3 && fabs (aVect.Z() + 0.70711) < 1e-3 ) nPoint =  1;
//STRIP001 	else if( fabs (aVect.X() + 0.57735) < 1e-3 && fabs (aVect.Y() - 0.57735) < 1e-3 && fabs (aVect.Z() + 0.57735) < 1e-3 ) nPoint =  2;
//STRIP001 	else if( fabs (aVect.X() - 0.57735) < 1e-3 && fabs (aVect.Y() - 0.57735) < 1e-3 && fabs (aVect.Z() + 0.57735) < 1e-3 ) nPoint =  3;
//STRIP001 	else if( fabs (aVect.X() + 0.70711) < 1e-3 && fabs (aVect.Y() - 0.70711) < 1e-3 && fabs (aVect.Z()          ) < 1e-3 ) nPoint =  4;
//STRIP001 	else if( fabs (aVect.X()          ) < 1e-3 && fabs (aVect.Y() - 1.0    ) < 1e-3 && fabs (aVect.Z()          ) < 1e-3 ) nPoint =  5;
//STRIP001 	else if( fabs (aVect.X() - 0.70711) < 1e-3 && fabs (aVect.Y() - 0.70711) < 1e-3 && fabs (aVect.Z()          ) < 1e-3 ) nPoint =  6;
//STRIP001 	else if( fabs (aVect.X() + 0.57735) < 1e-3 && fabs (aVect.Y() - 0.57735) < 1e-3 && fabs (aVect.Z() - 0.57735) < 1e-3 ) nPoint =  7;
//STRIP001 	else if( fabs (aVect.X() - 0.57735) < 1e-3 && fabs (aVect.Y() - 0.57735) < 1e-3 && fabs (aVect.Z() - 0.57735) < 1e-3 ) nPoint =  8;
//STRIP001 	else if( fabs (aVect.X() + 1.0    ) < 1e-3 && fabs (aVect.Y()          ) < 1e-3 && fabs (aVect.Z()          ) < 1e-3 ) nPoint =  9;
//STRIP001 	else if( fabs (aVect.X()          ) < 1e-3 && fabs (aVect.Y() - 0.70711) < 1e-3 && fabs (aVect.Z() - 0.70711) < 1e-3 ) nPoint = 10;
//STRIP001 	else if( fabs (aVect.X() - 1.0    ) < 1e-3 && fabs (aVect.Y()          ) < 1e-3 && fabs (aVect.Z()          ) < 1e-3 ) nPoint = 11;
//STRIP001 	else if( fabs (aVect.X() + 0.70711) < 1e-3 && fabs (aVect.Y()          ) < 1e-3 && fabs (aVect.Z() - 0.70711) < 1e-3 ) nPoint = 12;
//STRIP001 	else if( fabs (aVect.X() - 0.70711) < 1e-3 && fabs (aVect.Y()          ) < 1e-3 && fabs (aVect.Z() - 0.70711) < 1e-3 ) nPoint = 13;
//STRIP001 	else if( fabs (aVect.X() + 0.70711) < 1e-3 && fabs (aVect.Y() + 0.70711) < 1e-3 && fabs (aVect.Z()          ) < 1e-3 ) nPoint = 14;
//STRIP001 	else if( fabs (aVect.X()          ) < 1e-3 && fabs (aVect.Y()          ) < 1e-3 && fabs (aVect.Z() - 1.0    ) < 1e-3 ) nPoint = 15;
//STRIP001 	else if( fabs (aVect.X() - 0.70711) < 1e-3 && fabs (aVect.Y() + 0.70711) < 1e-3 && fabs (aVect.Z()          ) < 1e-3 ) nPoint = 16;
//STRIP001 	else if( fabs (aVect.X() + 0.57735) < 1e-3 && fabs (aVect.Y() + 0.57735) < 1e-3 && fabs (aVect.Z() - 0.57735) < 1e-3 ) nPoint = 17;
//STRIP001 	else if( fabs (aVect.X() - 0.57735) < 1e-3 && fabs (aVect.Y() + 0.57735) < 1e-3 && fabs (aVect.Z() - 0.57735) < 1e-3 ) nPoint = 18;
//STRIP001 	else if( fabs (aVect.X()          ) < 1e-3 && fabs (aVect.Y() + 0.70711) < 1e-3 && fabs (aVect.Z() - 0.70711) < 1e-3 ) nPoint = 19;
//STRIP001 
//STRIP001 	return( nPoint );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	3D Preview Control
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxPreviewCtl3D::SvxPreviewCtl3D( Window* pParent, const ResId& rResId)
//STRIP001 :	Control( pParent, rResId )
//STRIP001 {
//STRIP001 	// Members initialisieren
//STRIP001 	Init();
//STRIP001 }
//STRIP001 
//STRIP001 SvxPreviewCtl3D::SvxPreviewCtl3D( Window* pParent, WinBits nStyle)
//STRIP001 :	Control( pParent, nStyle)
//STRIP001 {
//STRIP001 	// Members initialisieren
//STRIP001 	Init();
//STRIP001 }
//STRIP001 
//STRIP001 void SvxPreviewCtl3D::Init()
//STRIP001 {
//STRIP001 	// Members mit Defaults fuellen
//STRIP001 	bGeometryCube=FALSE;
//STRIP001 	fRotateX=-20.0;
//STRIP001 	fRotateY=45.0;
//STRIP001 	fRotateZ=0.0;
//STRIP001 	fDistance=10.0;
//STRIP001 	fDeviceSize=1.5;
//STRIP001 
//STRIP001 	// MapMode waehlen
//STRIP001 	SetMapMode( MAP_100TH_MM );
//STRIP001 
//STRIP001 	// Hintergrund in einem schoenen neutralen Grau
//STRIP001 //	SetBackground( Wallpaper( Color( COL_GRAY ) ) );
//STRIP001 
//STRIP001 	// Segmente
//STRIP001 	nHorSegs = 24;
//STRIP001 	nVerSegs = 12;
//STRIP001 
//STRIP001 	// Normalenmodus
//STRIP001 	nNormalMode = PREVIEW_NORMAL_MODE_OBJECT;
//STRIP001 
//STRIP001 	// ShadeMode
//STRIP001 	nShadeMode = PREVIEW_SHADEMODE_GOURAUD;
//STRIP001 
//STRIP001 	// Geometrie erzeugen
//STRIP001 	CreateGeometry();
//STRIP001 
//STRIP001 	// Material initialisieren
//STRIP001 	Color aColWhite(COL_WHITE);
//STRIP001 	Color aColBlack(COL_BLACK);
//STRIP001 
//STRIP001 	aObjectMaterial.SetMaterial(aColWhite, Base3DMaterialAmbient);
//STRIP001 	aObjectMaterial.SetMaterial(aColWhite, Base3DMaterialDiffuse);
//STRIP001 	aObjectMaterial.SetMaterial(aColWhite, Base3DMaterialSpecular);
//STRIP001 	aObjectMaterial.SetMaterial(aColBlack, Base3DMaterialEmission);
//STRIP001 	aObjectMaterial.SetShininess(32);
//STRIP001 }
//STRIP001 
//STRIP001 SvxPreviewCtl3D::~SvxPreviewCtl3D()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 void SvxPreviewCtl3D::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	// Base3D anfordern
//STRIP001 	Base3D* pBase3D = Base3D::Create(this, nShadeMode == PREVIEW_SHADEMODE_DRAFT);
//STRIP001 
//STRIP001 	Rectangle aVisible(Point(0,0), GetOutputSizePixel());
//STRIP001 	aVisible = PixelToLogic(aVisible);
//STRIP001 
//STRIP001 	// Orientierung
//STRIP001 	Matrix4D mOrient;
//STRIP001 	aCameraSet.SetObjectTrans(mOrient);
//STRIP001 	mOrient.Orientation(
//STRIP001 		Point4D(0.0, 0.0, fDistance, 1.0),
//STRIP001 		Vector3D(0.0, 0.0, 1.0),
//STRIP001 		Vector3D(0.0, 1.0, 0.0));
//STRIP001 	aCameraSet.SetOrientation(mOrient);
//STRIP001 
//STRIP001 	// Matritzen setzen
//STRIP001 	pBase3D->SetTransformationSet(&aCameraSet);
//STRIP001 
//STRIP001 	// Licht setzen
//STRIP001 	pBase3D->SetLightGroup(&aLights);
//STRIP001 
//STRIP001 	// ShadeMode setzen
//STRIP001 	if(nShadeMode == PREVIEW_SHADEMODE_FLAT || nShadeMode == PREVIEW_SHADEMODE_DRAFT)
//STRIP001 		pBase3D->SetShadeModel(Base3DFlat);
//STRIP001 	else if(nShadeMode == PREVIEW_SHADEMODE_GOURAUD)
//STRIP001 		pBase3D->SetShadeModel(Base3DSmooth);
//STRIP001 	else
//STRIP001 		pBase3D->SetShadeModel(Base3DPhong);
//STRIP001 
//STRIP001 	// Ausgaberechteck setzen
//STRIP001 	aCameraSet.SetDeviceRectangle(-fDeviceSize, fDeviceSize, -fDeviceSize, fDeviceSize, FALSE);
//STRIP001 	aCameraSet.SetFrontClippingPlane(fDistance - fDeviceSize);
//STRIP001 	aCameraSet.SetBackClippingPlane(fDistance + fDeviceSize);
//STRIP001 	aCameraSet.SetViewportRectangle(aVisible);
//STRIP001 
//STRIP001 	// Matritzen setzen
//STRIP001 	pBase3D->SetTransformationSet(&aCameraSet);
//STRIP001 
//STRIP001 	// Werte fuer Objekt setzen
//STRIP001 	pBase3D->SetActiveTexture();
//STRIP001 	pBase3D->SetMaterial(aObjectMaterial.GetMaterial(Base3DMaterialAmbient), Base3DMaterialAmbient);
//STRIP001 	pBase3D->SetMaterial(aObjectMaterial.GetMaterial(Base3DMaterialDiffuse), Base3DMaterialDiffuse);
//STRIP001 	pBase3D->SetMaterial(aObjectMaterial.GetMaterial(Base3DMaterialSpecular), Base3DMaterialSpecular);
//STRIP001 	pBase3D->SetMaterial(aObjectMaterial.GetMaterial(Base3DMaterialEmission), Base3DMaterialEmission);
//STRIP001 	pBase3D->SetShininess(aObjectMaterial.GetShininess());
//STRIP001 
//STRIP001 	pBase3D->SetRenderMode(Base3DRenderFill);
//STRIP001 	pBase3D->SetCullMode(Base3DCullBack);
//STRIP001 
//STRIP001 	// ScissorRegion defaultmaessig disablen
//STRIP001 	pBase3D->ActivateScissorRegion(FALSE);
//STRIP001 
//STRIP001 	// Nicht flach
//STRIP001 	pBase3D->SetForceFlat(FALSE);
//STRIP001 
//STRIP001 	// Geometrie ausgeben
//STRIP001 	DrawGeometryClip(pBase3D);
//STRIP001 }
//STRIP001 
//STRIP001 void SvxPreviewCtl3D::DrawGeometryClip(Base3D *pBase3D)
//STRIP001 {
//STRIP001 	// spezielles Clipping fuer OpenGL, um keine floating windows ueberzumalen
//STRIP001 	if(pBase3D->GetBase3DType() == BASE3D_TYPE_OPENGL
//STRIP001 		&& GetOutDevType() == OUTDEV_WINDOW
//STRIP001 		&& pBase3D->GetTransformationSet())
//STRIP001 	{
//STRIP001 		Window* pWin = (Window*)this;
//STRIP001 		Region aClipRegion = pWin->GetActiveClipRegion();
//STRIP001 
//STRIP001 		// ClipRegion ist gesetzt, benutze diese
//STRIP001 		RegionHandle aRegionHandle = aClipRegion.BeginEnumRects();
//STRIP001 		Rectangle aClipRect;
//STRIP001 
//STRIP001 		while(aClipRegion.GetEnumRects(aRegionHandle, aClipRect))
//STRIP001 		{
//STRIP001 			if(aClipRect.IsOver(pBase3D->GetTransformationSet()->GetLogicalViewportBounds()))
//STRIP001 			{
//STRIP001 				// Viewport setzen
//STRIP001 				pBase3D->SetScissorRegion(aClipRect, TRUE);
//STRIP001 
//STRIP001 				// Zeichne alle Objekte
//STRIP001 				pBase3D->StartScene();
//STRIP001 				DrawGeometry(pBase3D);
//STRIP001 				pBase3D->EndScene();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		aClipRegion.EndEnumRects(aRegionHandle);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Zeichne alle Objekte
//STRIP001 		pBase3D->StartScene();
//STRIP001 		DrawGeometry(pBase3D);
//STRIP001 		pBase3D->EndScene();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxPreviewCtl3D::DrawGeometry(Base3D *pBase3D)
//STRIP001 {
//STRIP001 	pBase3D->DrawPolygonGeometry(aGeometry);
//STRIP001 }
//STRIP001 
//STRIP001 void SvxPreviewCtl3D::SetGeometry(BOOL bGeomCube)
//STRIP001 {
//STRIP001 	if(bGeometryCube != bGeomCube)
//STRIP001 	{
//STRIP001 		bGeometryCube = bGeomCube;
//STRIP001 		CreateGeometry();
//STRIP001 	}
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 void SvxPreviewCtl3D::SetRotation(double fRotX, double fRotY, double fRotZ)
//STRIP001 {
//STRIP001 	if(fRotX != fRotateX || fRotY != fRotateY || fRotZ != fRotateZ)
//STRIP001 	{
//STRIP001 		fRotateX = fRotX;
//STRIP001 		fRotateY = fRotY;
//STRIP001 		fRotateZ = fRotZ;
//STRIP001 		CreateGeometry();
//STRIP001 	}
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 void SvxPreviewCtl3D::GetRotation(double& rRotX, double& rRotY, double& rRotZ)
//STRIP001 {
//STRIP001 	rRotX = fRotateX;
//STRIP001 	rRotY = fRotateY;
//STRIP001 	rRotZ = fRotateZ;
//STRIP001 }
//STRIP001 
//STRIP001 // Zugriffsfunktionen Materialien
//STRIP001 void SvxPreviewCtl3D::SetMaterial(Color rNew, Base3DMaterialValue eVal)
//STRIP001 {
//STRIP001 	if(aObjectMaterial.GetMaterial(eVal) != rNew)
//STRIP001 	{
//STRIP001 		aObjectMaterial.SetMaterial(rNew, eVal);
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 Color SvxPreviewCtl3D::GetMaterial(Base3DMaterialValue eVal)
//STRIP001 {
//STRIP001 	return aObjectMaterial.GetMaterial(eVal);
//STRIP001 }
//STRIP001 
//STRIP001 void SvxPreviewCtl3D::SetShininess(UINT16 nNew)
//STRIP001 {
//STRIP001 	if(aObjectMaterial.GetShininess() != nNew)
//STRIP001 	{
//STRIP001 		aObjectMaterial.SetShininess(nNew);
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 UINT16 SvxPreviewCtl3D::GetShininess()
//STRIP001 {
//STRIP001 	return aObjectMaterial.GetShininess();
//STRIP001 }
//STRIP001 
//STRIP001 // Lichtquellen setzen
//STRIP001 void SvxPreviewCtl3D::SetLightGroup(B3dLightGroup* pNew)
//STRIP001 {
//STRIP001 	if(pNew)
//STRIP001 	{
//STRIP001 		aLights = *pNew;
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // View-Einstellungen
//STRIP001 void SvxPreviewCtl3D::SetUserDistance(double fNew)
//STRIP001 {
//STRIP001 	if(fNew != fDistance)
//STRIP001 	{
//STRIP001 		fDistance = fNew;
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxPreviewCtl3D::SetDeviceSize(double fNew)
//STRIP001 {
//STRIP001 	if(fNew != fDeviceSize)
//STRIP001 	{
//STRIP001 		fDeviceSize = fNew;
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // Zugriffsfunktionen Segmentierung
//STRIP001 void SvxPreviewCtl3D::SetHorizontalSegments(UINT16 nNew)
//STRIP001 {
//STRIP001 	if(nNew != nHorSegs)
//STRIP001 	{
//STRIP001 		nHorSegs = nNew;
//STRIP001 		CreateGeometry();
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxPreviewCtl3D::SetVerticalSegments(UINT16 nNew)
//STRIP001 {
//STRIP001 	if(nNew != nVerSegs)
//STRIP001 	{
//STRIP001 		nVerSegs = nNew;
//STRIP001 		CreateGeometry();
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxPreviewCtl3D::SetSegments(UINT16 nNewHor, UINT16 nNewVer)
//STRIP001 {
//STRIP001 	if(nNewHor != nHorSegs || nNewVer != nVerSegs)
//STRIP001 	{
//STRIP001 		nHorSegs = nNewHor;
//STRIP001 		nVerSegs = nNewVer;
//STRIP001 		CreateGeometry();
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // Zugriff Normalenmodus
//STRIP001 void SvxPreviewCtl3D::SetNormalMode(UINT16 nNew)
//STRIP001 {
//STRIP001 	if(nNew != nNormalMode)
//STRIP001 	{
//STRIP001 		nNormalMode = nNew;
//STRIP001 		CreateGeometry();
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // Zugriff auf ShadeMode
//STRIP001 void SvxPreviewCtl3D::SetShadeMode(UINT16 nNew)
//STRIP001 {
//STRIP001 	if(nNew != nShadeMode)
//STRIP001 	{
//STRIP001 		nShadeMode = nNew;
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxPreviewCtl3D::CreateGeometry()
//STRIP001 {
//STRIP001 	// Wuerfel erzeugen fuer Objektgroesse
//STRIP001 	B3dVolume aVolume;
//STRIP001 	aVolume.MinVec() = Vector3D(-1.0, -1.0, -1.0);
//STRIP001 	aVolume.MaxVec() = Vector3D( 1.0,  1.0,  1.0);
//STRIP001 
//STRIP001 	if(bGeometryCube)
//STRIP001 	{
//STRIP001 		// Wuerfel erzeugen
//STRIP001 		aGeometry.CreateCube(aVolume);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// AHCTUNG: Das PreviewControl hat bis zu dieser Stelle KEINE
//STRIP001 		// Begrenzung in der Anzahl der Hor/Ver Segmente. Diese wird hier nun
//STRIP001 		// explizit eingeschraenkt.
//STRIP001 		double fHSegs = (nHorSegs > 50) ? 50.0 : (double)nHorSegs;
//STRIP001 		double fVSegs = (nVerSegs > 50) ? 50.0 : (double)nVerSegs;
//STRIP001 
//STRIP001 		// Kugel erzeugen
//STRIP001 		aGeometry.CreateSphere(aVolume, fHSegs, fVSegs);
//STRIP001 	}
//STRIP001 
//STRIP001 	if(nNormalMode != PREVIEW_NORMAL_MODE_OBJECT)
//STRIP001 	{
//STRIP001 		if(!(nNormalMode == PREVIEW_NORMAL_MODE_FLAT))
//STRIP001 		{
//STRIP001 			aGeometry.CreateDefaultNormalsSphere();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Gesetzte Rotation ausfuehren
//STRIP001 	if(fRotateX != 0.0 || fRotateY != 0.0 || fRotateZ != 0.0)
//STRIP001 	{
//STRIP001 		Matrix4D aRotMat;
//STRIP001 		if(fRotateY != 0.0)
//STRIP001 			aRotMat.RotateY(fRotateY * F_PI180);
//STRIP001 		if(fRotateX != 0.0)
//STRIP001 			aRotMat.RotateX(-fRotateX * F_PI180);
//STRIP001 		if(fRotateZ != 0.0)
//STRIP001 			aRotMat.RotateZ(fRotateZ * F_PI180);
//STRIP001 		aGeometry.Transform(aRotMat);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	3D Light Control
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxLightPrevievCtl3D::SvxLightPrevievCtl3D( Window* pParent, const ResId& rResId)
//STRIP001 :	SvxPreviewCtl3D(pParent, rResId)
//STRIP001 {
//STRIP001 	// Members initialisieren
//STRIP001 	Init();
//STRIP001 }
//STRIP001 
//STRIP001 SvxLightPrevievCtl3D::SvxLightPrevievCtl3D( Window* pParent, WinBits nStyle )
//STRIP001 :	SvxPreviewCtl3D(pParent, nStyle)
//STRIP001 {
//STRIP001 	// Members initialisieren
//STRIP001 	Init();
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightPrevievCtl3D::Init()
//STRIP001 {
//STRIP001     // Do never mirror the preview window.  This explicitly includes right
//STRIP001     // to left writing environments.
//STRIP001     EnableRTL (FALSE);
//STRIP001 
//STRIP001 	// Lokale Parameter fuellen
//STRIP001 	eSelectedLight = Base3DLightNone;
//STRIP001 	fObjectRadius = 1.414;
//STRIP001 	fDistanceToObject = 0.4;
//STRIP001 	fScaleSizeSelected = 1.8;
//STRIP001 	fLampSize = 0.1;
//STRIP001 	nInteractionStartDistance = 5 * 5 * 2;
//STRIP001 	bMouseMoved = FALSE;
//STRIP001 	bGeometrySelected = FALSE;
//STRIP001 
//STRIP001 	// Device groesser, da Lampen angezeigt werden
//STRIP001 	SetDeviceSize(2.0);
//STRIP001 
//STRIP001 	// Geometrie fuer Lampenobjekt erzeugen
//STRIP001 	CreateLightGeometry();
//STRIP001 }
//STRIP001 
//STRIP001 SvxLightPrevievCtl3D::~SvxLightPrevievCtl3D()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightPrevievCtl3D::SelectLight(Base3DLightNumber eNew)
//STRIP001 {
//STRIP001 	if(eNew != eSelectedLight)
//STRIP001 	{
//STRIP001 		eSelectedLight = eNew;
//STRIP001 		bGeometrySelected = FALSE;
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightPrevievCtl3D::SelectGeometry()
//STRIP001 {
//STRIP001 	if(!bGeometrySelected)
//STRIP001 	{
//STRIP001 		bGeometrySelected = TRUE;
//STRIP001 		eSelectedLight = Base3DLightNone;
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightPrevievCtl3D::SetObjectRadius(double fNew)
//STRIP001 {
//STRIP001 	if(fObjectRadius != fNew)
//STRIP001 	{
//STRIP001 		fObjectRadius = fNew;
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightPrevievCtl3D::SetDistanceToObject(double fNew)
//STRIP001 {
//STRIP001 	if(fDistanceToObject != fNew)
//STRIP001 	{
//STRIP001 		fDistanceToObject = fNew;
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightPrevievCtl3D::SetScaleSizeSelected(double fNew)
//STRIP001 {
//STRIP001 	if(fScaleSizeSelected != fNew)
//STRIP001 	{
//STRIP001 		fScaleSizeSelected = fNew;
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightPrevievCtl3D::SetLampSize(double fNew)
//STRIP001 {
//STRIP001 	if(fLampSize != fNew)
//STRIP001 	{
//STRIP001 		fLampSize = fNew;
//STRIP001 		CreateLightGeometry();
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightPrevievCtl3D::DrawGeometry(Base3D *pBase3D)
//STRIP001 {
//STRIP001 	// call parent; zeichnet das Objekt selbst
//STRIP001 	SvxPreviewCtl3D::DrawGeometry(pBase3D);
//STRIP001 
//STRIP001 	// Lichter zeichnen
//STRIP001 	for(UINT16 a=0;a<BASE3D_MAX_NUMBER_LIGHTS;a++)
//STRIP001 	{
//STRIP001 		Base3DLightNumber eLightNum = (Base3DLightNumber)(Base3DLight0 + a);
//STRIP001 		if(aLights.IsEnabled(eLightNum))
//STRIP001 			DrawLightGeometry(eLightNum, pBase3D);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightPrevievCtl3D::DrawLightGeometry(Base3DLightNumber eLightNum,
//STRIP001 	Base3D* pBase3D)
//STRIP001 {
//STRIP001 	// Geometrie bereitstellen
//STRIP001 	B3dGeometry aNew;
//STRIP001 	Matrix4D aTrans;
//STRIP001 	double fRadius = fObjectRadius + fDistanceToObject;
//STRIP001 	Color aLineColor(COL_YELLOW);
//STRIP001 	aNew = aLightGeometry;
//STRIP001 
//STRIP001 	if(eLightNum == eSelectedLight)
//STRIP001 		aTrans.Scale(fScaleSizeSelected, fScaleSizeSelected, fScaleSizeSelected);
//STRIP001 
//STRIP001 	Vector3D aDirection = aLights.GetDirection(eLightNum);
//STRIP001 	aDirection.Normalize();
//STRIP001 	aDirection *= fRadius;
//STRIP001 	aTrans.Translate(aDirection);
//STRIP001 
//STRIP001 	aNew.Transform(aTrans);
//STRIP001 
//STRIP001 	// Material setzen
//STRIP001 	Color aZwi;
//STRIP001 	aZwi = aLights.GetIntensity(Base3DMaterialDiffuse, eLightNum);
//STRIP001 	pBase3D->SetMaterial(aZwi, Base3DMaterialAmbient);
//STRIP001 //	pBase3D->SetMaterial(aZwi, Base3DMaterialDiffuse);
//STRIP001 	pBase3D->SetMaterial(aZwi, Base3DMaterialEmission);
//STRIP001 	aZwi = aLights.GetIntensity(Base3DMaterialSpecular, eLightNum);
//STRIP001 	pBase3D->SetMaterial(aZwi, Base3DMaterialSpecular);
//STRIP001 
//STRIP001 	// Lampe Zeichnen
//STRIP001 	pBase3D->SetRenderMode(Base3DRenderLine);
//STRIP001 	pBase3D->DrawPolygonGeometry(aNew);
//STRIP001 
//STRIP001 	if(eLightNum == eSelectedLight)
//STRIP001 	{
//STRIP001 		// Beleuchtung aus und Linienfarbe setzen
//STRIP001 		BOOL bLightingWasEnabled = aLights.IsLightingEnabled();
//STRIP001 		aLights.EnableLighting(FALSE);
//STRIP001 		pBase3D->SetLightGroup(&aLights);
//STRIP001 		pBase3D->SetLineWidth();
//STRIP001 
//STRIP001 		// Kreis am Boden zeichnen
//STRIP001 		Vector3D aPoint(0.0, -fRadius, fRadius);
//STRIP001 		pBase3D->StartPrimitive(Base3DLineLoop);
//STRIP001 		pBase3D->SetColor(aLineColor);
//STRIP001 
//STRIP001 		double fWink;
//STRIP001 		for(fWink=-F_PI;fWink < F_PI; fWink += F_2PI/24.0)
//STRIP001 		{
//STRIP001 			aPoint.Z() = -cos(fWink) * fRadius;
//STRIP001 			aPoint.X() = -sin(fWink) * fRadius;
//STRIP001 			pBase3D->AddVertex(aPoint);
//STRIP001 		}
//STRIP001 		pBase3D->EndPrimitive();
//STRIP001 
//STRIP001 		// Kreisbogen zeichnen
//STRIP001 		double fBodenWinkel = atan2(-aDirection.X(), -aDirection.Z());
//STRIP001 		double fSinBoden = sin(fBodenWinkel) * fRadius;
//STRIP001 		double fCosBoden = cos(fBodenWinkel) * fRadius;
//STRIP001 		pBase3D->StartPrimitive(Base3DLineStrip);
//STRIP001 		pBase3D->SetColor(aLineColor);
//STRIP001 
//STRIP001 		for(fWink=-F_PI2;fWink < F_PI2; fWink += F_PI/12.0)
//STRIP001 		{
//STRIP001 			aPoint.X() = cos(fWink) * -fSinBoden;
//STRIP001 			aPoint.Y() = sin(fWink) * fRadius;
//STRIP001 			aPoint.Z() = cos(fWink) * -fCosBoden;
//STRIP001 			pBase3D->AddVertex(aPoint);
//STRIP001 		}
//STRIP001 		pBase3D->EndPrimitive();
//STRIP001 
//STRIP001 		// Verbindung zeichnen
//STRIP001 		pBase3D->StartPrimitive(Base3DLineStrip);
//STRIP001 		pBase3D->SetColor(aLineColor);
//STRIP001 		aPoint = Vector3D(0.0, -fRadius, 0.0);
//STRIP001 		pBase3D->AddVertex(aPoint);
//STRIP001 		aPoint.X() = -fSinBoden;
//STRIP001 		aPoint.Z() = -fCosBoden;
//STRIP001 		pBase3D->AddVertex(aPoint);
//STRIP001 		aPoint.Y() = 0.0;
//STRIP001 		pBase3D->AddVertex(aPoint);
//STRIP001 		pBase3D->EndPrimitive();
//STRIP001 
//STRIP001 		// Beleuchtung wieder eischalten
//STRIP001 		aLights.EnableLighting(bLightingWasEnabled);
//STRIP001 		pBase3D->SetLightGroup(&aLights);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightPrevievCtl3D::CreateLightGeometry()
//STRIP001 {
//STRIP001 	// Wuerfel erzeugen fuer Objektgroesse
//STRIP001 	B3dVolume aVolume;
//STRIP001 	aVolume.MinVec() = Vector3D(-fLampSize, -fLampSize, -fLampSize);
//STRIP001 	aVolume.MaxVec() = Vector3D( fLampSize,  fLampSize,  fLampSize);
//STRIP001 
//STRIP001 	// Kugel erzeugen
//STRIP001 	aLightGeometry.CreateSphere(aVolume, 4.0, 3.0);
//STRIP001 }
//STRIP001 
//STRIP001 // Selektion gueltig? D.h.: Lampe ist Selektiert un auch EINGESCHALTET
//STRIP001 BOOL SvxLightPrevievCtl3D::IsSelectionValid()
//STRIP001 {
//STRIP001 	if((eSelectedLight != Base3DLightNone)
//STRIP001 		&& (aLights.GetLightObject(eSelectedLight).IsEnabled()))
//STRIP001 	{
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 // Selektierte Lampe Position in Polarkoordinaten holen/setzen
//STRIP001 // dabei geht Hor:[0..360.0[ und Ver:[-90..90] Grad
//STRIP001 void SvxLightPrevievCtl3D::GetPosition(double& rHor, double& rVer)
//STRIP001 {
//STRIP001 	if(IsSelectionValid())
//STRIP001 	{
//STRIP001 		Vector3D aDirection = aLights.GetDirection(eSelectedLight);
//STRIP001 		aDirection.Normalize();
//STRIP001 		rHor = atan2(-aDirection.X(), -aDirection.Z()) + F_PI; // 0..2PI
//STRIP001 		rVer = atan2(aDirection.Y(), aDirection.GetXZLength()); // -PI2..PI2
//STRIP001 		rHor /= F_PI180; // 0..360.0
//STRIP001 		rVer /= F_PI180; // -90.0..90.0
//STRIP001 	}
//STRIP001 	if(IsGeometrySelected())
//STRIP001 	{
//STRIP001 		rHor = fRotateY;
//STRIP001 		rVer = fRotateX;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightPrevievCtl3D::SetPosition(double fHor, double fVer)
//STRIP001 {
//STRIP001 	if(IsSelectionValid())
//STRIP001 	{
//STRIP001 		Vector3D aDirection;
//STRIP001 		fHor = (fHor * F_PI180) - F_PI; // -PI..PI
//STRIP001 		fVer *= F_PI180; // -PI2..PI2
//STRIP001 		aDirection.X() = cos(fVer) * -sin(fHor);
//STRIP001 		aDirection.Y() = sin(fVer);
//STRIP001 		aDirection.Z() = cos(fVer) * -cos(fHor);
//STRIP001 		aDirection.Normalize();
//STRIP001 		aLights.SetDirection(aDirection, eSelectedLight);
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 	if(IsGeometrySelected())
//STRIP001 	{
//STRIP001 		SetRotation(fVer, fHor, fRotateZ);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // Interaktion
//STRIP001 void SvxLightPrevievCtl3D::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	BOOL bCallParent = TRUE;
//STRIP001 
//STRIP001 	// Status switchen
//STRIP001 	if(rMEvt.IsLeft())
//STRIP001 	{
//STRIP001 		if(IsSelectionValid() || bGeometrySelected)
//STRIP001 		{
//STRIP001 			bMouseMoved = FALSE;
//STRIP001 			bCallParent = FALSE;
//STRIP001 			aActionStartPoint = rMEvt.GetPosPixel();
//STRIP001 			StartTracking();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Einfacher Click ohne viel Bewegen, versuche eine
//STRIP001 			// Selektion
//STRIP001 			TrySelection(rMEvt.GetPosPixel());
//STRIP001 			bCallParent = FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// call parent
//STRIP001 	if(bCallParent)
//STRIP001 		SvxPreviewCtl3D::MouseButtonDown(rMEvt);
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightPrevievCtl3D::Tracking( const TrackingEvent& rTEvt )
//STRIP001 {
//STRIP001 	if(rTEvt.IsTrackingEnded())
//STRIP001 	{
//STRIP001 		if(rTEvt.IsTrackingCanceled())
//STRIP001 		{
//STRIP001 			if(bMouseMoved)
//STRIP001 			{
//STRIP001 				// Interaktion abbrechen
//STRIP001 				bMouseMoved = FALSE;
//STRIP001 				if(bGeometrySelected)
//STRIP001 				{
//STRIP001 					SetRotation(fSaveActionStartVer, fSaveActionStartHor, fSaveActionStartRotZ);
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					SetPosition(fSaveActionStartHor, fSaveActionStartVer);
//STRIP001 				}
//STRIP001 				if(aChangeCallback.IsSet())
//STRIP001 					aChangeCallback.Call(this);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			const MouseEvent& rMEvt = rTEvt.GetMouseEvent();
//STRIP001 			if(bMouseMoved)
//STRIP001 			{
//STRIP001 				// Wurde interaktiv veraendert
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// Einfacher Click ohne viel Bewegen, versuche eine
//STRIP001 				// Selektion
//STRIP001 				TrySelection(rMEvt.GetPosPixel());
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		const MouseEvent& rMEvt = rTEvt.GetMouseEvent();
//STRIP001 		Point aDeltaPos = rMEvt.GetPosPixel() - aActionStartPoint;
//STRIP001 
//STRIP001 		if(!bMouseMoved)
//STRIP001 		{
//STRIP001 			if(INT32(aDeltaPos.X() * aDeltaPos.X() + aDeltaPos.Y() * aDeltaPos.Y())
//STRIP001 				> nInteractionStartDistance)
//STRIP001 			{
//STRIP001 				if(bGeometrySelected)
//STRIP001 				{
//STRIP001 					GetRotation(fSaveActionStartVer, fSaveActionStartHor, fSaveActionStartRotZ);
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					// Start der Interaktion, Werte Sichern
//STRIP001 					GetPosition(fSaveActionStartHor, fSaveActionStartVer);
//STRIP001 				}
//STRIP001 				bMouseMoved = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if(bMouseMoved)
//STRIP001 		{
//STRIP001 			if(bGeometrySelected)
//STRIP001 			{
//STRIP001 				double fNewRotX = fSaveActionStartVer - ((double)aDeltaPos.Y());
//STRIP001 				double fNewRotY = fSaveActionStartHor + ((double)aDeltaPos.X());
//STRIP001 
//STRIP001 				// Horizontal abgleichen
//STRIP001 				while(fNewRotY < 0.0)
//STRIP001 					fNewRotY += 360.0;
//STRIP001 				while(fNewRotY >= 360.0)
//STRIP001 					fNewRotY -= 360.0;
//STRIP001 
//STRIP001 				// Vertikal cutten
//STRIP001 				if(fNewRotX < -90.0)
//STRIP001 					fNewRotX = -90.0;
//STRIP001 				if(fNewRotX > 90.0)
//STRIP001 					fNewRotX = 90.0;
//STRIP001 
//STRIP001 				SetRotation(fNewRotX, fNewRotY, fSaveActionStartRotZ);
//STRIP001 
//STRIP001 				if(aChangeCallback.IsSet())
//STRIP001 					aChangeCallback.Call(this);
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// Interaktion im vollen Gange
//STRIP001 				double fNewPosHor = fSaveActionStartHor + ((double)aDeltaPos.X());
//STRIP001 				double fNewPosVer = fSaveActionStartVer - ((double)aDeltaPos.Y());
//STRIP001 
//STRIP001 				// Horizontal abgleichen
//STRIP001 				while(fNewPosHor < 0.0)
//STRIP001 					fNewPosHor += 360.0;
//STRIP001 				while(fNewPosHor >= 360.0)
//STRIP001 					fNewPosHor -= 360.0;
//STRIP001 
//STRIP001 				// Vertikal cutten
//STRIP001 				if(fNewPosVer < -90.0)
//STRIP001 					fNewPosVer = -90.0;
//STRIP001 				if(fNewPosVer > 90.0)
//STRIP001 					fNewPosVer = 90.0;
//STRIP001 
//STRIP001 				SetPosition(fNewPosHor, fNewPosVer);
//STRIP001 
//STRIP001 				if(aChangeCallback.IsSet())
//STRIP001 					aChangeCallback.Call(this);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // Selektion einer Lampe
//STRIP001 void SvxLightPrevievCtl3D::TrySelection(Point aPosPixel)
//STRIP001 {
//STRIP001 	BOOL bNewSelection(FALSE);
//STRIP001 	Base3DLightNumber eNew = Base3DLightNone;
//STRIP001 
//STRIP001 	for(UINT16 a=0;a<BASE3D_MAX_NUMBER_LIGHTS;a++)
//STRIP001 	{
//STRIP001 		Base3DLightNumber eActualLight = (Base3DLightNumber)(Base3DLight0 + a);
//STRIP001 		if(aLights.IsEnabled(eActualLight))
//STRIP001 		{
//STRIP001 			Vector3D aLightPos = aLights.GetDirection(eActualLight);
//STRIP001 			aLightPos.Normalize();
//STRIP001 			aLightPos *= GetObjectRadius() + GetDistanceToObject();
//STRIP001 			Vector3D aScreenPos = aCameraSet.ObjectToViewCoor(aLightPos);
//STRIP001 			Point aScreenPosPixel((long)(aScreenPos.X() + 0.5), (long)(aScreenPos.Y() + 0.5));
//STRIP001 			aScreenPosPixel = LogicToPixel(aScreenPosPixel);
//STRIP001 			aScreenPosPixel -= aPosPixel;
//STRIP001 			INT32 nDistance = (aScreenPosPixel.X() * aScreenPosPixel.X())
//STRIP001 				+ (aScreenPosPixel.Y() * aScreenPosPixel.Y());
//STRIP001 			if(nDistance < nInteractionStartDistance)
//STRIP001 			{
//STRIP001 				eNew = eActualLight;
//STRIP001 				bNewSelection = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if(bNewSelection && eSelectedLight != eNew)
//STRIP001 	{
//STRIP001 		// Auswaehlen
//STRIP001 		SelectLight(eNew);
//STRIP001 
//STRIP001 		// Falls tatsaechlich eine andere Lampe selektiert
//STRIP001 		// wurde, rufe den entsprechenden Callback
//STRIP001 		if(aSelectionChangeCallback.IsSet())
//STRIP001 			aSelectionChangeCallback.Call(this);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Punkt in logische Koordinaten umrechnen
//STRIP001 		Point aPosLogic = PixelToLogic(aPosPixel);
//STRIP001 
//STRIP001 		// Punkte generieren
//STRIP001 		Vector3D aHitFront(aPosLogic.X(), aPosLogic.Y(), 0.0);
//STRIP001 		Vector3D aHitBack(aPosLogic.X(), aPosLogic.Y(), ZBUFFER_DEPTH_RANGE);
//STRIP001 
//STRIP001 		// Umrechnen
//STRIP001 		aHitFront = aCameraSet.ViewToObjectCoor(aHitFront);
//STRIP001 		aHitBack = aCameraSet.ViewToObjectCoor(aHitBack);
//STRIP001 
//STRIP001 		// Eventuell die Geometrie des Beispielobjektes waehlen
//STRIP001 		if(aGeometry.CheckHit(aHitFront, aHitBack, 0))
//STRIP001 		{
//STRIP001 			// Auswaehlen
//STRIP001 			SelectGeometry();
//STRIP001 
//STRIP001 			// Falls tatsaechlich eine andere Lampe selektiert
//STRIP001 			// wurde, rufe den entsprechenden Callback
//STRIP001 			if(aSelectionChangeCallback.IsSet())
//STRIP001 				aSelectionChangeCallback.Call(this);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	3D Light Control Konstruktor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxLightCtl3D::SvxLightCtl3D( Window* pParent, const ResId& rResId)
//STRIP001 :	Control(pParent, rResId),
//STRIP001 	aLightControl(this, 0),
//STRIP001 	aHorScroller(this, WB_HORZ | WB_DRAG),
//STRIP001 	aVerScroller(this, WB_VERT | WB_DRAG),
//STRIP001 	aSwitcher(this, 0)
//STRIP001 {
//STRIP001 	// Members initialisieren
//STRIP001 	Init();
//STRIP001 }
//STRIP001 
//STRIP001 SvxLightCtl3D::SvxLightCtl3D( Window* pParent, WinBits nStyle )
//STRIP001 :	Control(pParent, nStyle),
//STRIP001 	aLightControl(this, 0),
//STRIP001 	aHorScroller(this, WB_HORZ | WB_DRAG),
//STRIP001 	aVerScroller(this, WB_VERT | WB_DRAG),
//STRIP001 	aSwitcher(this, 0)
//STRIP001 {
//STRIP001 	// Members initialisieren
//STRIP001 	Init();
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightCtl3D::Init()
//STRIP001 {
//STRIP001 	// Lokale Parameter setzen
//STRIP001 	bSphereUsed = TRUE;
//STRIP001 	bVectorValid = FALSE;
//STRIP001 
//STRIP001 	// Light preview
//STRIP001 	aLightControl.Show();
//STRIP001 	aLightControl.SetChangeCallback( LINK(this, SvxLightCtl3D, InternalInteractiveChange) );
//STRIP001 	aLightControl.SetSelectionChangeCallback( LINK(this, SvxLightCtl3D, InternalSelectionChange) );
//STRIP001 
//STRIP001 	// Horiz Scrollbar
//STRIP001 	aHorScroller.Show();
//STRIP001 	aHorScroller.SetRange(Range(0, 36000));
//STRIP001 	aHorScroller.SetLineSize(100);
//STRIP001 	aHorScroller.SetPageSize(1000);
//STRIP001 	aHorScroller.SetScrollHdl( LINK(this, SvxLightCtl3D, ScrollBarMove) );
//STRIP001 
//STRIP001 	// Vert Scrollbar
//STRIP001 	aVerScroller.Show();
//STRIP001 	aVerScroller.SetRange(Range(0, 18000));
//STRIP001 	aVerScroller.SetLineSize(100);
//STRIP001 	aVerScroller.SetPageSize(1000);
//STRIP001 	aVerScroller.SetScrollHdl( LINK(this, SvxLightCtl3D, ScrollBarMove) );
//STRIP001 
//STRIP001 	// Switch Button
//STRIP001 	aSwitcher.Show();
//STRIP001 	aSwitcher.SetClickHdl( LINK(this, SvxLightCtl3D, ButtonPress) );
//STRIP001 
//STRIP001 	// Selektion klaeren
//STRIP001 	CheckSelection();
//STRIP001 
//STRIP001 	// Neues Layout
//STRIP001 	NewLayout();
//STRIP001 }
//STRIP001 
//STRIP001 SvxLightCtl3D::~SvxLightCtl3D()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightCtl3D::SetVector(const Vector3D& rNew)
//STRIP001 {
//STRIP001 	aVector = rNew;
//STRIP001 	aVector.Normalize();
//STRIP001 	bVectorValid = TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 const Vector3D& SvxLightCtl3D::GetVector()
//STRIP001 {
//STRIP001 	// Grobe Anbindung an altes Verhalten, um eine Reaktion zu haben
//STRIP001 	aVector = aLightControl.GetLightGroup()->GetDirection(aLightControl.GetSelectedLight());
//STRIP001 	aVector.Normalize();
//STRIP001 	return aVector;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightCtl3D::Resize()
//STRIP001 {
//STRIP001 	// call parent
//STRIP001 	Control::Resize();
//STRIP001 
//STRIP001 	// Neues Layout
//STRIP001 	NewLayout();
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightCtl3D::NewLayout()
//STRIP001 {
//STRIP001 	// Layout members
//STRIP001 	Size aSize = GetOutputSizePixel();
//STRIP001 	long nScrollSize = aHorScroller.GetSizePixel().Height();
//STRIP001 
//STRIP001 	// Preview Fenster
//STRIP001 	Point aPoint(0, 0);
//STRIP001 	Size aDestSize(aSize.Width() - nScrollSize, aSize.Height() - nScrollSize);
//STRIP001 	aLightControl.SetPosSizePixel(aPoint, aDestSize);
//STRIP001 
//STRIP001 	// Horizontaler Scrollbar
//STRIP001 	aPoint.Y() = aSize.Height() - nScrollSize;
//STRIP001 	aDestSize.Height() = nScrollSize;
//STRIP001 	aHorScroller.SetPosSizePixel(aPoint, aDestSize);
//STRIP001 
//STRIP001 	// Vertikaler Scrollbar
//STRIP001 	aPoint.X() = aSize.Width() - nScrollSize;
//STRIP001 	aPoint.Y() = 0;
//STRIP001 	aDestSize.Width() = nScrollSize;
//STRIP001 	aDestSize.Height() = aSize.Height() - nScrollSize;
//STRIP001 	aVerScroller.SetPosSizePixel(aPoint, aDestSize);
//STRIP001 
//STRIP001 	// Button
//STRIP001 	aPoint.Y() = aSize.Height() - nScrollSize;
//STRIP001 	aDestSize.Height() = nScrollSize;
//STRIP001 	aSwitcher.SetPosSizePixel(aPoint, aDestSize);
//STRIP001 }
//STRIP001 
//STRIP001 // Selektion auf Gueltigkeit pruefen
//STRIP001 void SvxLightCtl3D::CheckSelection()
//STRIP001 {
//STRIP001 	BOOL bSelectionValid = (aLightControl.IsSelectionValid()
//STRIP001 		|| aLightControl.IsGeometrySelected());
//STRIP001 	aHorScroller.Enable(bSelectionValid);
//STRIP001 	aVerScroller.Enable(bSelectionValid);
//STRIP001 
//STRIP001 	if(bSelectionValid)
//STRIP001 	{
//STRIP001 		double fHor, fVer;
//STRIP001 		aLightControl.GetPosition(fHor, fVer);
//STRIP001 		aHorScroller.SetThumbPos( INT32(fHor * 100.0) );
//STRIP001 		aVerScroller.SetThumbPos( 18000 - INT32((fVer + 90.0) * 100.0) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightCtl3D::move( double fDeltaHor, double fDeltaVer )
//STRIP001 {
//STRIP001 	double fHor, fVer;
//STRIP001 
//STRIP001 	aLightControl.GetPosition(fHor, fVer);
//STRIP001 
//STRIP001 	fHor += fDeltaHor;
//STRIP001 	fVer += fDeltaVer;
//STRIP001 
//STRIP001 	if( fVer > 90.0 )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( fVer < -90.0 )
//STRIP001 		return;
//STRIP001 
//STRIP001 	aLightControl.SetPosition(fHor, fVer);
//STRIP001 	aHorScroller.SetThumbPos( INT32(fHor * 100.0) );
//STRIP001 	aVerScroller.SetThumbPos( 18000 - INT32((fVer + 90.0) * 100.0) );
//STRIP001 
//STRIP001 	if(aUserInteractiveChangeCallback.IsSet())
//STRIP001 		aUserInteractiveChangeCallback.Call(this);
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightCtl3D::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001     KeyCode aCode = rKEvt.GetKeyCode();
//STRIP001 
//STRIP001     if( aCode.GetModifier() )
//STRIP001     {
//STRIP001         Control::KeyInput( rKEvt );
//STRIP001         return;
//STRIP001     }
//STRIP001 
//STRIP001     switch ( aCode.GetCode() )
//STRIP001     {
//STRIP001         case KEY_SPACE:
//STRIP001             ;
//STRIP001             break;
//STRIP001         case KEY_LEFT:
//STRIP001             move(  4.0,  0.0 );
//STRIP001             break;
//STRIP001         case KEY_RIGHT:
//STRIP001             move( -4.0,  0.0 );
//STRIP001             break;
//STRIP001         case KEY_UP:
//STRIP001             move(  0.0,  4.0 );
//STRIP001             break;
//STRIP001         case KEY_DOWN:
//STRIP001             move(  0.0, -4.0 );
//STRIP001             break;
//STRIP001         case KEY_PAGEUP:
//STRIP001 			{
//STRIP001 				B3dLightGroup* pLights = aLightControl.GetLightGroup();
//STRIP001 				int eLight = aLightControl.GetSelectedLight() - 1;
//STRIP001 
//STRIP001 				while( (eLight >= Base3DLight0) && !pLights->IsEnabled((Base3DLightNumber)eLight) )
//STRIP001 					eLight--;
//STRIP001 
//STRIP001 				if( eLight < Base3DLight0 )
//STRIP001 				{
//STRIP001 					eLight =  Base3DLight7;
//STRIP001 					while( (eLight >= Base3DLight0) && !pLights->IsEnabled((Base3DLightNumber)eLight) )
//STRIP001 						eLight--;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( eLight >= Base3DLight0 )
//STRIP001 				{
//STRIP001 					aLightControl.SelectLight((Base3DLightNumber)eLight);
//STRIP001 					CheckSelection();
//STRIP001 					if(aUserSelectionChangeCallback.IsSet())
//STRIP001 						aUserSelectionChangeCallback.Call(this);
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			}
//STRIP001         case KEY_PAGEDOWN:
//STRIP001 			{
//STRIP001 				B3dLightGroup* pLights = aLightControl.GetLightGroup();
//STRIP001 				int eLight = aLightControl.GetSelectedLight() + 1;
//STRIP001 
//STRIP001 				while( (eLight < Base3DLightNone) && !pLights->IsEnabled((Base3DLightNumber)eLight) )
//STRIP001 					eLight++;
//STRIP001 
//STRIP001 				if( eLight == Base3DLightNone )
//STRIP001 				{
//STRIP001 					eLight = Base3DLight0;
//STRIP001 					while( (eLight < Base3DLightNone) && !pLights->IsEnabled((Base3DLightNumber)eLight) )
//STRIP001 						eLight++;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( eLight < Base3DLightNone )
//STRIP001 				{
//STRIP001 					aLightControl.SelectLight((Base3DLightNumber)eLight);
//STRIP001 					CheckSelection();
//STRIP001 					if(aUserSelectionChangeCallback.IsSet())
//STRIP001 						aUserSelectionChangeCallback.Call(this);
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		default:
//STRIP001 	        Control::KeyInput( rKEvt );
//STRIP001 			break;
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightCtl3D::GetFocus()
//STRIP001 {
//STRIP001 	Control::GetFocus();
//STRIP001 
//STRIP001 	if( HasFocus() && IsEnabled() )
//STRIP001 	{
//STRIP001 		CheckSelection();
//STRIP001 
//STRIP001 		Size aFocusSize = aLightControl.GetOutputSizePixel();
//STRIP001 
//STRIP001 		aFocusSize.Width() -= 4;
//STRIP001 		aFocusSize.Height() -= 4;
//STRIP001 
//STRIP001 		Rectangle aFocusRect( Point( 2, 2 ), aFocusSize );
//STRIP001 
//STRIP001 		aFocusRect = aLightControl.PixelToLogic( aFocusRect );
//STRIP001 
//STRIP001 		aLightControl.ShowFocus( aFocusRect );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLightCtl3D::LoseFocus()
//STRIP001 {
//STRIP001 	Control::LoseFocus();
//STRIP001 
//STRIP001 	aLightControl.HideFocus();
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SvxLightCtl3D, ScrollBarMove, void*, pNil)
//STRIP001 {
//STRIP001 	INT32 nHor = aHorScroller.GetThumbPos();
//STRIP001 	INT32 nVer = aVerScroller.GetThumbPos();
//STRIP001 
//STRIP001 	aLightControl.SetPosition(
//STRIP001 		((double)nHor) / 100.0,
//STRIP001 		((double)((18000 - nVer) - 9000)) / 100.0);
//STRIP001 
//STRIP001 	if(aUserInteractiveChangeCallback.IsSet())
//STRIP001 		aUserInteractiveChangeCallback.Call(this);
//STRIP001 
//STRIP001 	// ...um Kompatibel zu bleiben, kann spaeter wieder raus
//STRIP001 	//InteractiveChange(NULL);
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SvxLightCtl3D, ButtonPress, void*, pNil)
//STRIP001 {
//STRIP001 	aLightControl.SetGeometry(bSphereUsed);
//STRIP001 	bSphereUsed = !bSphereUsed;
//STRIP001 	return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SvxLightCtl3D, InternalInteractiveChange, void*, pNil)
//STRIP001 {
//STRIP001 	double fHor, fVer;
//STRIP001 
//STRIP001 	aLightControl.GetPosition(fHor, fVer);
//STRIP001 	aHorScroller.SetThumbPos( INT32(fHor * 100.0) );
//STRIP001 	aVerScroller.SetThumbPos( 18000 - INT32((fVer + 90.0) * 100.0) );
//STRIP001 
//STRIP001 	if(aUserInteractiveChangeCallback.IsSet())
//STRIP001 		aUserInteractiveChangeCallback.Call(this);
//STRIP001 
//STRIP001 	// ...um Kompatibel zu bleiben, kann spaeter wieder raus
//STRIP001 	//InteractiveChange(NULL);
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SvxLightCtl3D, InternalSelectionChange, void*, pNil)
//STRIP001 {
//STRIP001 	CheckSelection();
//STRIP001 
//STRIP001 	if(aUserSelectionChangeCallback.IsSet())
//STRIP001 		aUserSelectionChangeCallback.Call(this);
//STRIP001 
//STRIP001 	// ...um Kompatibel zu bleiben, kann spaeter wieder raus
//STRIP001 	//SelectionChange(NULL);
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 // ...um Kompatibel zu bleiben, kann spaeter wieder raus
//STRIP001 /*
//STRIP001 IMPL_LINK( SvxLightCtl3D, InteractiveChange, void*, pNil)
//STRIP001 {
//STRIP001 	return NULL;
//STRIP001 } */
//STRIP001 
//STRIP001 /*
//STRIP001 IMPL_LINK( SvxLightCtl3D, SelectionChange, void*, pNil)
//STRIP001 {
//STRIP001 	return NULL;
//STRIP001 }*/


}
