/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_macro.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:43:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001 #include <tools/stream.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #include "macro.hxx"
//STRIP001 #include "request.hxx"
//STRIP001 #include "msg.hxx"
//STRIP001 
//STRIP001 //====================================================================
//STRIP001 
//STRIP001 SV_DECL_PTRARR_DEL( SfxStatements_Impl, SfxMacroStatement*, 16, 8 )//STRIP008 ;
//STRIP001 SV_IMPL_PTRARR( SfxStatements_Impl, SfxMacroStatement* );
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 struct SfxMacro_Impl
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Implementations-Struktur der Klasse <SfxMacro>.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	SfxMacroMode		eMode;	/*	Zweck der <SfxMacro>-Instanz,
//STRIP001 									Bedeutung siehe enum <SfxMacroMode> */
//STRIP001 	SfxStatements_Impl	aList;  /* 	Liste von aufgezeichneten Statements */
//STRIP001 };
//STRIP001 
//STRIP001 //====================================================================
//STRIP001 
//STRIP001 SfxMacroStatement::SfxMacroStatement
//STRIP001 (
//STRIP001 	const SfxShell& rShell, 		// <SfxShell>, die den Request ausf"uhrte
//STRIP001 	const String&	rTarget,		// Name des Zielobjektes vor der Ausf"urhung
//STRIP001 	BOOL			bAbsolute,		// obsolet
//STRIP001 	const SfxSlot&	rSlot,			// der <SfxSlot>, der das Statement abspielen kann
//STRIP001 	BOOL			bRequestDone,	// wurde der Request tats"achlich ausgef"uhrt
//STRIP001     ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& rArgs
//STRIP001 )
//STRIP001 
//STRIP001 /* 	[Beschreibung]
//STRIP001 
//STRIP001 	Dieser Konstruktor der Klasse SfxMacroStatement erzeugt ein Statement,
//STRIP001 	bei dem ein Objekt angesprochen wird, welches durch 'rShell' angegeben
//STRIP001 	ist. Dabei erfolgt die Addressierung je nach 'bAbsolute' absolut,
//STRIP001 	also z.B. als '[mydoc.sdc]' oder relativ, also z.B. 'ActiveDocument'.
//STRIP001 
//STRIP001 	Je nach Art der Subklasse von 'rShell' ergeben sich folgende
//STRIP001 	Ausdr"ucke:
//STRIP001 
//STRIP001 						  |absolut					relativ
//STRIP001 	-----------------------------------------------------------------------
//STRIP001 	SfxApplication'       | 'StarCalc'  			'Application'
//STRIP001 	SfxViewFrame'		  |'[mydoc.sdc:1]'       	'ActiveWindow'
//STRIP001 	SfxViewShell'         | '[mydoc.sdc:1]'         'AvtiveWindow'
//STRIP001 	SfxObjectShell'       | '[mydoc.sdc]'           'ActiveDocument'
//STRIP001 	sonstige (Sub-Shells) | '[mydoc.sdc:1]'			'ActiveWindow'
//STRIP001 
//STRIP001 	Dabei sind 'StarCalc' stellvertretend fr den Namen der Applikation
//STRIP001 	(Application::GetAppName()const). In der absoluten Fassung k"onnte
//STRIP001 	die Selektion auch deskriptiv z.B. als 'CellSelection("A5-D8")')
//STRIP001 	angesprochen werden, dazu mu\ jedoch vom Anwendungsprogrammierer der
//STRIP001 	Konstruktor <SfxMacroStatement::SfxMacroStatement(const String&,
//STRIP001 	const SfxSlot&,BOOL,SfxArguments*)> verwendet werden.
//STRIP001 
//STRIP001 	F"ur das so bezeichnete Objekt wird dann je nach Typ des Slots
//STRIP001 	eine Zuweisung an eines seiner Properties oder der Aufruf einer seiner
//STRIP001 	Methoden ausgedr"uckt.
//STRIP001 
//STRIP001 
//STRIP001 	[Beispiele]
//STRIP001 
//STRIP001 	absolut:
//STRIP001 	SCalc3.OpenDocument( "\docs\mydoc.sdd", "StarDraw Presentation", 0, 0 )
//STRIP001 	[mydoc.sdd].Activate()
//STRIP001 	[mydoc.sdd:1].SwitchToView( 2 )
//STRIP001 	[mydoc.sdc:1:1].CellSelection( "A5-D8" ).LineColor = 192357
//STRIP001 
//STRIP001 	relativ:
//STRIP001 	ActiveWindow.LineColor = 192357
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxMacroStatement::SfxMacroStatement(const String&,const SfxSlot&,BOOL,SfxArguments*)>
//STRIP001 	<SfxMacroStatement::SfxMacroStatement(const String&)>
//STRIP001 */
//STRIP001 
//STRIP001 :	nSlotId( rSlot.GetSlotId() ),
//STRIP001     aArgs( rArgs ),
//STRIP001 	bDone( bRequestDone ),
//STRIP001 	pDummy( 0 )
//STRIP001 {
//STRIP001 	// Workaround Recording nicht exportierter Slots (#25386#)
//STRIP001 	if ( !rSlot.pName )
//STRIP001 		return;
//STRIP001 /*
//STRIP001 	// Objekt-Typ bestimmen
//STRIP001 	FASTBOOL bIsApp = rShell.ISA(SfxApplication);
//STRIP001 	FASTBOOL bIsDoc = rShell.ISA(SfxObjectShell);
//STRIP001 	FASTBOOL bIsWin = !bIsApp && !bIsDoc &&
//STRIP001 					  ( rShell.ISA(SfxViewShell) || rShell.ISA(SfxViewFrame) );
//STRIP001 	FASTBOOL bIsSel = !bIsApp && !bIsDoc && !bIsWin;
//STRIP001 
//STRIP001 	// Objekt nicht schon im Slot-Namen enthalten?
//STRIP001 	if ( bIsSel || rSlot.pName[0] == '.' )
//STRIP001 	{
//STRIP001 		// absolutes Aufzeichnen?
//STRIP001 		if ( rSlot.IsMode( SFX_SLOT_RECORDABSOLUTE ) )
//STRIP001 		{
//STRIP001 			// an der Applikation oder am Modul
//STRIP001 			if ( rShell.ISA(SfxApplication) || rShell.ISA(SfxModule) )
//STRIP001 				aStatement = rTarget;
//STRIP001 
//STRIP001 			// am Dokument?
//STRIP001 			// '[' = 5Bh
//STRIP001 			// ']' = 5Dh
//STRIP001 			else if ( rShell.ISA(SfxObjectShell) )
//STRIP001 			{
//STRIP001 				aStatement = 0x005B;
//STRIP001 				aStatement += rTarget;
//STRIP001 				aStatement += 0x005D;
//STRIP001 			}
//STRIP001 
//STRIP001 			else if ( rShell.ISA(SfxViewFrame) )
//STRIP001 			{
//STRIP001 				aStatement = 0x005B;
//STRIP001                 aStatement += String::CreateFromAscii("ViewFrame");//rShell.GetSbxObject()->GetName();
//STRIP001 				aStatement += 0x005D;
//STRIP001 			}
//STRIP001 
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// an der View oder Sub-Shell
//STRIP001 				SfxViewShell *pViewShell = rShell.GetViewShell();
//STRIP001 				aStatement = 0x005B;
//STRIP001                 aStatement += String::CreateFromAscii("ViewShell");//pViewShell->GetViewFrame()->GetSbxObject()->GetName();
//STRIP001 				aStatement += 0x005D;
//STRIP001 				if ( !rShell.ISA(SfxViewFrame) )
//STRIP001 					// an einer Sub-Shell zus"atlich ?Selection?anh"angen
//STRIP001 					aStatement += DEFINE_CONST_UNICODE(".Selection");
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else // relatives Aufzeichnen
//STRIP001 		{
//STRIP001 			// an der Application?
//STRIP001 			if ( rShell.ISA(SfxApplication) )
//STRIP001 				aStatement = DEFINE_CONST_UNICODE("Application");
//STRIP001 
//STRIP001 			// am Modul?
//STRIP001 			else if ( rShell.ISA(SfxModule) )
//STRIP001 				aStatement = DEFINE_CONST_UNICODE("ActiveModule");
//STRIP001 
//STRIP001 			// am Dokument
//STRIP001 			else if ( rShell.ISA(SfxObjectShell) )
//STRIP001 				aStatement = DEFINE_CONST_UNICODE("ActiveDocument");
//STRIP001 
//STRIP001 			// am Window
//STRIP001 			else if ( rShell.ISA(SfxViewShell) || rShell.ISA(SfxViewFrame) )
//STRIP001 				aStatement = DEFINE_CONST_UNICODE("ActiveWindow");
//STRIP001 
//STRIP001 			else
//STRIP001 				// an einer Sub-Shell
//STRIP001 				aStatement = DEFINE_CONST_UNICODE("Selection");
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bIsSel )
//STRIP001 	{
//STRIP001 		// bei Selection ggf. noch den Namen der SubShell anh"angen
//STRIP001 		const SfxShellObject *pShObj =
//STRIP001 					(const SfxShellObject*) rShell.GetSbxObject();
//STRIP001 		if ( pShObj )
//STRIP001 		{
//STRIP001 			const SfxShellObject *pParentObj =
//STRIP001 						(const SfxShellObject*) pShObj->GetParent();
//STRIP001 			SfxShell *pParentSh = pParentObj->GetShell();
//STRIP001 			DBG_ASSERT( pParentSh->ISA(SfxViewFrame),
//STRIP001 						"parent of SubShell must be a Frame" );
//STRIP001 			if ( rSlot.pName[0] == '.' )
//STRIP001 			{
//STRIP001 				aStatement += '.';
//STRIP001 				aStatement += rShell.GetSbxObject()->GetName();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			DBG_ASSERT( rSlot.pName[0] != '0', "recording unnamed object" );
//STRIP001 	}
//STRIP001 */
//STRIP001     aStatement = DEFINE_CONST_UNICODE("Selection");
//STRIP001 
//STRIP001 	// an diesen Objekt-Ausdruck den Methoden-/Property-Namen und Parameter
//STRIP001     GenerateNameAndArgs_Impl( SfxRequest::GetRecordingMacro(), rSlot, bRequestDone, aArgs);
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxMacroStatement::SfxMacroStatement
//STRIP001 (
//STRIP001 	const String&   rTarget,		// Objekt, was beim Playing angesprochen wird
//STRIP001 	const SfxSlot&	rSlot,			// der <SfxSlot>, der das Statement abspielen kann
//STRIP001 	BOOL			bRequestDone,	// wurde der Request tats"achlich ausgef"uhrt
//STRIP001     ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& rArgs
//STRIP001 )
//STRIP001 
//STRIP001 /* 	[Beschreibung]
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxMacroStatement::SfxMacroStatement(const String&)>
//STRIP001 	<SfxMacroStatement::SfxMacroStatement(const SfxShell&,BOOL,const SfxSlot&,BOOL,SfxArguments*)>
//STRIP001 */
//STRIP001 
//STRIP001 :	nSlotId( rSlot.GetSlotId() ),
//STRIP001     aArgs( rArgs ),
//STRIP001 	bDone( bRequestDone ),
//STRIP001 	pDummy( 0 )
//STRIP001 {
//STRIP001 	aStatement = rTarget;
//STRIP001 	aStatement += 0x002E; // '.' = 2Eh
//STRIP001     GenerateNameAndArgs_Impl( SfxRequest::GetRecordingMacro(), rSlot, bRequestDone, aArgs);
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxMacroStatement::SfxMacroStatement
//STRIP001 (
//STRIP001 	const String&   rStatement  	// manuell erzeugte(s) Statement(s)
//STRIP001 )
//STRIP001 
//STRIP001 /* 	[Beschreibung]
//STRIP001 
//STRIP001 	Dieser Konstruktor erzeugt eine SfxMacroStatement-Instanz, deren
//STRIP001 	Aufbau vollst"andig vom Applikationsentwickler bestimmt wird. Da der
//STRIP001 	angegebene String auch mehrere mit CR/LF getrennte Statements
//STRIP001 	enthalten darf, ist damit ein weitgehender Eingriff in das Aufzeichnen
//STRIP001 	von BASIC-Makros m"oglich, um Spezialf"alle zu behandeln.
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxMacroStatement::SfxMacroStatement(const String&,const SfxSlot&,BOOL,SfxArguments*)>
//STRIP001 	<SfxMacroStatement::SfxMacroStatement(const SfxShell&,BOOL,const SfxSlot&,BOOL,SfxArguments*)>
//STRIP001 */
//STRIP001 
//STRIP001 :	aStatement( rStatement ),
//STRIP001 	nSlotId( 0 ),
//STRIP001 	bDone( TRUE ),
//STRIP001 	pDummy( 0 )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxMacroStatement::SfxMacroStatement
//STRIP001 (
//STRIP001 	const SfxMacroStatement&	rOrig // Original, von dem kopiert wird
//STRIP001 )
//STRIP001 
//STRIP001 /* 	[Beschreibung]
//STRIP001 
//STRIP001 	Copy-Konstruktor der SfxMacroStatement-Klasse.
//STRIP001 */
//STRIP001 
//STRIP001 :	aStatement( rOrig.aStatement ),
//STRIP001 	nSlotId( rOrig.nSlotId ),
//STRIP001 	bDone( rOrig.bDone ),
//STRIP001 	pDummy( 0 )
//STRIP001 {
//STRIP001     aArgs = rOrig.aArgs;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxMacroStatement::~SfxMacroStatement()
//STRIP001 
//STRIP001 /* 	[Beschreibung]
//STRIP001 
//STRIP001 	Destruktor der Klasse SfxMacroStatement. Gibt die Liste der
//STRIP001 	aktuellen Parameter frei.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxMacroStatement::GenerateNameAndArgs_Impl
//STRIP001 (
//STRIP001 	SfxMacro*		pMacro,			// darin wird aufgezeichnet
//STRIP001 	const SfxSlot&	rSlot,			// der Slot, der das Statement abspielen kann
//STRIP001 	BOOL			bRequestDone,	// TRUE=wurde ausgef"uhrt, FALSE=abgebrochen
//STRIP001     ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& rArgs
//STRIP001 )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Interne Hilfsmethode zum generieren des Funktions-/Property-Names
//STRIP001 	sowie der Parameter. Diese Methode wird nur verwendet, wenn der
//STRIP001 	Anwendungsprogrammierer keinen eigenen Source an den <SfxRequest>
//STRIP001 	geh"angt hat.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	// '.' = 2Eh
//STRIP001 	if ( aStatement.Len() && aStatement.GetChar( aStatement.Len() - 1 ) != 0x002E &&
//STRIP001 		rSlot.pName[0] != 0x002E )
//STRIP001 		aStatement += 0x002E;
//STRIP001 
//STRIP001 	// der Name des Slots ist der Name der Methode / des Properties
//STRIP001 	aStatement += String::CreateFromAscii(rSlot.pName);
//STRIP001 	if ( rSlot.IsMode(SFX_SLOT_METHOD) )
//STRIP001 		aStatement += DEFINE_CONST_UNICODE("( ");
//STRIP001 	else
//STRIP001 		aStatement += DEFINE_CONST_UNICODE(" = ");
//STRIP001 
//STRIP001 	// alle zusammengesuchten Parameter rausschreiben
//STRIP001     if ( aArgs.getLength() )
//STRIP001         for ( USHORT nArg = 0; nArg < aArgs.getLength(); ++nArg )
//STRIP001 		{
//STRIP001 			// den Parameter textuell darstellen
//STRIP001 			String aArg;
//STRIP001             ::com::sun::star::uno::Any& rValue = aArgs[nArg].Value;
//STRIP001             ::com::sun::star::uno::Type pType = rValue.getValueType();
//STRIP001 			if ( pType == ::getBooleanCppuType() )
//STRIP001 			{
//STRIP001                 sal_Bool bTemp;
//STRIP001                 rValue >>= bTemp;
//STRIP001                 aArg = bTemp ? DEFINE_CONST_UNICODE("TRUE") : DEFINE_CONST_UNICODE("FALSE");
//STRIP001 			}
//STRIP001             else if ( pType == ::getCppuType((const sal_Int16*)0) )
//STRIP001 			{
//STRIP001                 sal_uInt16 nTemp;
//STRIP001                 rValue >>= nTemp;
//STRIP001                 aArg = String::CreateFromInt32( (sal_Int32) nTemp );
//STRIP001 			}
//STRIP001             else if ( pType == ::getCppuType((const sal_Int32*)0) )
//STRIP001 			{
//STRIP001                 sal_uInt32 nTemp;
//STRIP001                 rValue >>= nTemp;
//STRIP001                 aArg = String::CreateFromInt32( nTemp );
//STRIP001 			}
//STRIP001 			else if ( pType == ::getCppuType((const ::rtl::OUString*)0) )
//STRIP001 			{
//STRIP001                 ::rtl::OUString sTemp;
//STRIP001                 rValue >>= sTemp;
//STRIP001 
//STRIP001                 // Anf"uhrungszeichen werden verdoppelt
//STRIP001                 XubString aRecordable( sTemp );
//STRIP001                 USHORT nPos = 0;
//STRIP001                 while ( TRUE )
//STRIP001                 {
//STRIP001                     nPos = aRecordable.SearchAndReplace( DEFINE_CONST_UNICODE('"'), DEFINE_CONST_UNICODE("\"\""), nPos );
//STRIP001                     if ( STRING_NOTFOUND == nPos )
//STRIP001                         break;
//STRIP001                     nPos += 2;
//STRIP001                 }
//STRIP001 
//STRIP001                 // nicht druckbare Zeichen werden als chr$(...) geschrieben
//STRIP001                 FASTBOOL bPrevReplaced = FALSE;
//STRIP001                 for ( USHORT n = 0; n < aRecordable.Len(); ++n )
//STRIP001                 {
//STRIP001                     sal_Unicode cChar = aRecordable.GetChar(n);
//STRIP001                     if ( !( cChar>=32 && cChar!=127 ) ) // ALS ERSATZ FUER String::IsPrintable()!
//STRIP001                     {
//STRIP001                         XubString aReplacement( DEFINE_CONST_UNICODE("+chr$(") );
//STRIP001                         aReplacement += cChar;
//STRIP001 
//STRIP001                         if ( bPrevReplaced )
//STRIP001                         {
//STRIP001                             aRecordable.Insert( aReplacement, n - 2 );
//STRIP001                             n += aReplacement.Len();
//STRIP001                             aRecordable.SetChar((unsigned short) (n-2), 0x0029);// ')' = 29h
//STRIP001                             aRecordable.Replace( n-1, 2, DEFINE_CONST_UNICODE("+\"") );
//STRIP001                             // ++n;
//STRIP001                         }
//STRIP001                         else
//STRIP001                         {
//STRIP001                             aReplacement += DEFINE_CONST_UNICODE(")+\"");
//STRIP001                             aRecordable.SetChar(n, 0x0022 );// '"' = 22h
//STRIP001                             aRecordable.Insert( aReplacement, n + 1 );
//STRIP001                             n += aReplacement.Len();
//STRIP001                         }
//STRIP001                         bPrevReplaced = TRUE;
//STRIP001                     }
//STRIP001                     else
//STRIP001                         bPrevReplaced = FALSE;
//STRIP001 
//STRIP001                     // Argument in Anf"uhrungszeichen
//STRIP001                     aArg = 0x0022; // '"' = 22h
//STRIP001                     aArg += aRecordable;
//STRIP001                     aArg += 0x0022;
//STRIP001                 }
//STRIP001 /*
//STRIP001 				case SbxBYTE:
//STRIP001 				{
//STRIP001 					// als Zahl darstellen
//STRIP001 					aArg = (USHORT) rVar.GetByte();
//STRIP001 					break;
//STRIP001 				}
//STRIP001 */
//STRIP001 			}
//STRIP001             else if ( pType != ::getVoidCppuType() )
//STRIP001                 DBG_ERROR("Unknown Type in recorder!");
//STRIP001 
//STRIP001 			// den Parameter anh"angen
//STRIP001 			aStatement += aArg;
//STRIP001 			aStatement += DEFINE_CONST_UNICODE(", ");
//STRIP001 		}
//STRIP001 
//STRIP001 	// Statement beeden
//STRIP001     if ( aArgs.getLength() )
//STRIP001 		aStatement.Erase( aStatement.Len() - 2, 1 );
//STRIP001 	else
//STRIP001 		aStatement.Erase( aStatement.Len() - 1, 1 );
//STRIP001 	if ( rSlot.IsMode(SFX_SLOT_METHOD) )
//STRIP001 		aStatement += 0x0029; // ')' = 29h
//STRIP001 
//STRIP001 	if ( !bRequestDone )
//STRIP001 		// nicht als "Done()" gekennzeichnete Statements auskommentieren
//STRIP001 		aStatement.InsertAscii( "rem ", 0 );
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxMacro::SfxMacro
//STRIP001 (
//STRIP001 	SfxMacroMode 	eMode		// Zweck der Instanz, siehe <SfxMacroMode>
//STRIP001 )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Konstruktor der Klasse SfxMacro. Instanzen dieser Klasse werden im
//STRIP001 	SFx zu zwei Zwecken ben"otigt:
//STRIP001 
//STRIP001 	1. zum Aufzeichnen von Makros
//STRIP001 	In diesem Fall wird der Konstruktor mit SFX_MACRO_RECORDINGABSOLUTE
//STRIP001 	oder SFX_MACRO_RECORDINGRELATIVE aufgerufen. Es sollte sich um eine
//STRIP001 	Instanz einer abgeleiteten Klasse handeln, um in der Ableitung
//STRIP001 	die Information dar"uber unterzubringen, wo das Makro gespeichert
//STRIP001 	werden soll. Ein solches Makro solle sich dann in seinem Destruktor
//STRIP001 	an der vom Benutzer gew"ahlten Stelle speichern.
//STRIP001 
//STRIP001 	2. zum Zuordnen von exisitierenden Makros
//STRIP001 	In diesem Fall wird der Konstruktor mit SFX_MACRO_EXISTING aufgerufen.
//STRIP001 	Eine solche Instanz wird z.B. ben"otigt, wenn Makros auf Events
//STRIP001 	oder <SfxControllerItem>s konfiguriert werden sollen.
//STRIP001 */
//STRIP001 
//STRIP001 :	pImp( new SfxMacro_Impl )
//STRIP001 
//STRIP001 {
//STRIP001 	pImp->eMode = eMode;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxMacro::~SfxMacro()
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Virtueller Destruktor der Klasse SfxMacro. Dieser sollte in den
//STRIP001 	abgeleiteten Klassen "uberladen werden, um in den Modi
//STRIP001 	SFX_MACRO_RECORDINGABSOLUTE und SFX_MACRO_RECORDINGRELATIVE den
//STRIP001 	aufgezeichneten Source abzuspeichern.
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxMacro::GenerateSource()const>
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001     SvFileStream aStream( String::CreateFromAscii("file:///f:/testmacro.bas" ), STREAM_STD_READWRITE | STREAM_TRUNC );
//STRIP001     aStream << ByteString( GenerateSource(), RTL_TEXTENCODING_UTF8 ).GetBuffer();
//STRIP001 #endif
//STRIP001 	delete pImp;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxMacroMode SfxMacro::GetMode() const
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Liefert den Modus, der besagt zu welchem Zweck das SfxMacro konstruiert
//STRIP001 	wurde.
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	enum <SfxMacroMode>
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return pImp->eMode;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxMacro::Record
//STRIP001 (
//STRIP001 	SfxMacroStatement*	pStatement 	// aufzuzeichnendes <SfxMacroStatement>
//STRIP001 )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Diese Methode zeichnet das als Parameter "ubergeben Statement auf.
//STRIP001 	Die Instanz auf die der "ubergebe Pointer zeigt, geht in das Eigentum
//STRIP001 	des SfxMacro "uber.
//STRIP001 
//STRIP001 	Der Aufruf ist nur g"ultig, wenn es sich um ein SfxMacro handelt,
//STRIP001 	welches mit SFX_MACRO_RECORDINGABSOLUTE oder SFX_MACRO_RECORDINGRELATIVE
//STRIP001 	konstruiert wirde.
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxMacro::Replace(SfxMacroStatement*)>
//STRIP001 	<SfxMacro::Remove()>
//STRIP001 	<SfxMacro::GetLastStatement()const>
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001     DBG_ASSERT( pImp->eMode != SFX_MACRO_EXISTING, "invalid call to non-recording SfxMacro" );
//STRIP001 	pImp->aList.C40_INSERT( SfxMacroStatement, pStatement, pImp->aList.Count() );
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxMacro::Replace
//STRIP001 (
//STRIP001 	SfxMacroStatement*	pStatement	// aufzuzeichnendes <SfxMacroStatement>
//STRIP001 )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Diese Methode zeichnet das als Parameter "ubergeben Statement auf.
//STRIP001 	Dabei wird das jeweils zuletzt aufgezeichnete Statement "uberschrieben.
//STRIP001 	Die Instanz auf die der "ubergebe Pointer zeigt, geht in das Eigentum
//STRIP001 	des SfxMacro "uber.
//STRIP001 
//STRIP001 	Mit dieser Methode ist es m"oglich, Statements zusammenzufassen. Z.B.
//STRIP001 	anstelle f"unfmal hintereinander 'CursorLeft()' aufzurufen, k"onnte
//STRIP001 	das zu 'CursorLeft(5)' zusammengefa\st werden. Oder anstelle ein Wort
//STRIP001 	Buchstabe f"ur Buchstabe aufzubauen, k"onnte dies durch ein einziges
//STRIP001 	Statement 'InsertString("Hallo")' ersetzt werden.
//STRIP001 
//STRIP001 	Der Aufruf ist nur g"ultig, wenn es sich um ein SfxMacro handelt,
//STRIP001 	welches mit SFX_MACRO_RECORDINGABSOLUTE oder SFX_MACRO_RECORDINGRELATIVE
//STRIP001 	konstruiert wurde und bereits ein aufgezeichnetes Statement vorhanden
//STRIP001 	ist.
//STRIP001 
//STRIP001 
//STRIP001 	[Anmerkung]
//STRIP001 
//STRIP001 	Diese Methode wird typischerweise aus den Execute-Methoden der
//STRIP001 	<SfxSlot>s von den Applikationsentwicklern gerufen.
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxMacro::Record(SfxMacroStatement*)>
//STRIP001 	<SfxMacro::Remove()>
//STRIP001 	<SfxMacro::GetLastStatement()const>
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001     DBG_ASSERT( pImp->eMode != SFX_MACRO_EXISTING, "invalid call to non-recording SfxMacro" );
//STRIP001 	DBG_ASSERT( pImp->aList.Count(), "no replaceable statement available" )
//STRIP001 	pImp->aList.Remove( pImp->aList.Count() - 1 );
//STRIP001 	pImp->aList.C40_INSERT( SfxMacroStatement,pStatement, pImp->aList.Count() );
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxMacro::Remove()
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Diese Methode l"oscht das zuletzt aufgezeichnete <SfxMacroStatement>
//STRIP001 	und entfernt es aus dem Macro.
//STRIP001 
//STRIP001 	Mit dieser Methode ist es m"oglich, Statements zusammenzufassen. Z.B.
//STRIP001 	anstelle f"unfmal hintereinander 'CursorLeft()' aufzurufen, k"onnte
//STRIP001 	das zu 'CursorLeft(5)' zusammengefa\st werden. Oder anstelle ein Wort
//STRIP001 	Buchstabe f"ur Buchstabe aufzubauen, k"onnte dies durch ein einziges
//STRIP001 	Statement 'InsertString("Hallo")' ersetzt werden.
//STRIP001 
//STRIP001 	Der Aufruf ist nur g"ultig, wenn es sich um ein SfxMacro handelt,
//STRIP001 	welches mit SFX_MACRO_RECORDINGABSOLUTE oder SFX_MACRO_RECORDINGRELATIVE
//STRIP001 	konstruiert wurde und bereits ein aufgezeichnetes Statement vorhanden
//STRIP001 	ist.
//STRIP001 
//STRIP001 
//STRIP001 	[Anmerkung]
//STRIP001 
//STRIP001 	Diese Methode wird typischerweise aus den Execute-Methoden der
//STRIP001 	<SfxSlot>s von den Applikationsentwicklern gerufen.
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxMacro::Replace(SfxMacroStatement*)>
//STRIP001 	<SfxMacro::Record(SfxMacroStatement*)>
//STRIP001 	<SfxMacro::GetLastStatement()const>
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001     DBG_ASSERT( pImp->eMode != SFX_MACRO_EXISTING, "invalid call to non-recording SfxMacro" );
//STRIP001 	DBG_ASSERT( pImp->aList.Count(), "no replaceable statement available" )
//STRIP001 	pImp->aList.Remove( pImp->aList.Count() - 1 );
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 const SfxMacroStatement* SfxMacro::GetLastStatement() const
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Mit dieser Methode kann auf das jeweils zuletzt aufgezeichnete Statement
//STRIP001 	lesend zugegriffen werden. Zusammen mit der Methode
//STRIP001 	<SfxMacro::Replace(SfxMacroStatement*)> ergibt sich dadurch die
//STRIP001 	M"oglichkeit, Statements zusammenzufassen.
//STRIP001 
//STRIP001 	Der Aufruf ist nur g"ultig, wenn es sich um ein SfxMacro handelt,
//STRIP001 	welches mit SFX_MACRO_RECORDINGABSOLUTE oder SFX_MACRO_RECORDINGRELATIVE
//STRIP001 	konstruiert wurde.
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxMacro::Record(SfxMacroStatement*)>
//STRIP001 	<SfxMacro::Replace(SfxMacroStatement*)>
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001     DBG_ASSERT( pImp->eMode != SFX_MACRO_EXISTING, "invalid call to non-recording SfxMacro" );
//STRIP001 	if ( pImp->aList.Count() )
//STRIP001 		return pImp->aList.GetObject( pImp->aList.Count() - 1 );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 String SfxMacro::GenerateSource() const
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Diese Funktion generiert aus den, seit dem Konstruieren der Instanz
//STRIP001 	bis zum Zeitpunkt des Aufrufs dieser Methode aufgezeichneten
//STRIP001 	<SfxMacroStatement>s einen BASIC-Sourcecode, der die Statements,
//STRIP001 	jedoch nicht den Header ('Sub X') und den Footer ('End Sub') enth"alt.
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxMacro::Record(SfxMacroStatement*)>
//STRIP001 	<SfxMacro::Repeat(SfxMacroStatement*)>
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001     DBG_ASSERT( pImp->eMode != SFX_MACRO_EXISTING, "invalid call to non-recording SfxMacro" );
//STRIP001 	String aSource;
//STRIP001 	for ( USHORT n = 0; n < pImp->aList.Count(); ++n )
//STRIP001 	{
//STRIP001 		aSource += pImp->aList.GetObject(n)->GetStatement();
//STRIP001 		if ( (n+1) < pImp->aList.Count() )
//STRIP001 			aSource += DEFINE_CONST_UNICODE("\n");
//STRIP001 	}
//STRIP001 
//STRIP001 	return aSource;
//STRIP001 }

}
