/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_layertab.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:41:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SVDLAYER_HXX
// auto strip #include <bf_svx/svdlayer.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif

#pragma hdrstop

// auto strip #include "sdattr.hxx"
// auto strip #include "app.hxx"
#include "helpids.h"
#include "app.hrc"
#include "glob.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
// auto strip #include "layertab.hxx"
#include "drviewsh.hxx"
// auto strip #include "sdwindow.hxx"
// auto strip #include "sdview.hxx"
// auto strip #include "drawdoc.hxx"
// auto strip #include "sdresid.hxx"
// auto strip #include "docshell.hxx"
// auto strip #include "drawview.hxx"
// auto strip #include "undolayer.hxx"
namespace binfilter {
	

#define SWITCH_TIMEOUT  20


/*************************************************************************
|*
|* Standard-Konstruktor
|*
\************************************************************************/

/*N*/ SdLayerTab::SdLayerTab(SdDrawViewShell* pViewSh, Window* pParent) :
/*N*/ 	TabBar( pParent, WinBits( WB_BORDER | WB_3DLOOK | WB_SCROLL | WB_SIZEABLE ) ),
/*N*/ 	DropTargetHelper( this ),
/*N*/ 	pDrViewSh(pViewSh)
/*N*/ {
/*N*/ 	EnableEditMode();
/*N*/ 	SetSizePixel(Size(0, 0));
/*N*/ 	SetMaxPageWidth( 150 );
/*N*/     SetHelpId( HID_SD_TABBAR_LAYERS );
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SdLayerTab::~SdLayerTab()
/*N*/ {
/*N*/ }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 void SdLayerTab::Select()
//STRIP001 {
//STRIP001 	SfxDispatcher* pDispatcher = pDrViewSh->GetViewFrame()->GetDispatcher();
//STRIP001 	pDispatcher->Execute(SID_SWITCHLAYER, SFX_CALLMODE_ASYNCHRON);
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 void SdLayerTab::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	BOOL bSetPageID=FALSE;
//STRIP001 
//STRIP001 	if (rMEvt.IsLeft() && !rMEvt.IsMod1() && !rMEvt.IsMod2())
//STRIP001 	{
//STRIP001 		Point aPosPixel = rMEvt.GetPosPixel();
//STRIP001 		USHORT aLayerId = GetPageId( PixelToLogic(aPosPixel) );
//STRIP001 
//STRIP001 		if (aLayerId == 0)
//STRIP001 		{
//STRIP001 			SfxDispatcher* pDispatcher = pDrViewSh->GetViewFrame()->GetDispatcher();
//STRIP001 			pDispatcher->Execute(SID_INSERTLAYER, SFX_CALLMODE_SYNCHRON);
//STRIP001 
//STRIP001 			bSetPageID=TRUE;
//STRIP001 		}
//STRIP001 		else if (rMEvt.IsShift())
//STRIP001 		{
//STRIP001 			// Toggle zw. Layer sichtbar / unsichtbar
//STRIP001 			String aName(GetPageText(aLayerId));
//STRIP001 			SdrPageView* pPV = pDrViewSh->GetView()->GetPageViewPvNum(0);
//STRIP001 			BOOL bVisible = pPV->IsLayerVisible(aName);
//STRIP001 			pPV->SetLayerVisible(aName, !bVisible);
//STRIP001 			pDrViewSh->ResetActualLayer();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// If you insert a new layer you must not call TabBar::MouseButtonDown(rMEvt);
//STRIP001 	// because you want to activate the new layer
//STRIP001 	if( !bSetPageID )
//STRIP001 		TabBar::MouseButtonDown(rMEvt);
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 void SdLayerTab::DoubleClick()
//STRIP001 {
//STRIP001 	if (GetCurPageId() != 0)
//STRIP001 	{
//STRIP001 		SfxDispatcher* pDispatcher = pDrViewSh->GetViewFrame()->GetDispatcher();
//STRIP001 		pDispatcher->Execute( SID_MODIFYLAYER, SFX_CALLMODE_SYNCHRON );
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* AcceptDrop-Event
|*
\************************************************************************/

//STRIP001 sal_Int8 SdLayerTab::AcceptDrop( const AcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001 	sal_Int8 nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if( rEvt.mbLeaving )		
//STRIP001 		EndSwitchPage();
//STRIP001 
//STRIP001 	if( !pDrViewSh->GetDocSh()->IsReadOnly() )
//STRIP001 	{
//STRIP001 		USHORT			nPageId = SDRPAGE_NOTFOUND;
//STRIP001 		Point			aPos( PixelToLogic( rEvt.maPosPixel ) );
//STRIP001 		USHORT			nLayerId = pDrViewSh->GetView()->GetDoc()->GetLayerAdmin().GetLayerID( GetPageText( GetPageId( aPos ) ), FALSE );
//STRIP001 
//STRIP001 		nRet = pDrViewSh->AcceptDrop( rEvt, *this, NULL, nPageId, nLayerId );
//STRIP001 
//STRIP001 		SwitchPage( aPos );
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

/*************************************************************************
|*
|* ExecuteDrop-Event
|*
\************************************************************************/

//STRIP001 sal_Int8 SdLayerTab::ExecuteDrop( const ExecuteDropEvent& rEvt )
//STRIP001 {
//STRIP001 	USHORT			nPageId = SDRPAGE_NOTFOUND;
//STRIP001 	USHORT			nLayerId = pDrViewSh->GetView()->GetDoc()->GetLayerAdmin().GetLayerID( GetPageText( GetPageId( PixelToLogic( rEvt.maPosPixel ) ) ), FALSE );
//STRIP001 	sal_Int8		nRet = pDrViewSh->ExecuteDrop( rEvt, *this, NULL, nPageId, nLayerId );
//STRIP001 
//STRIP001 	EndSwitchPage();
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 void  SdLayerTab::Command(const CommandEvent& rCEvt)
//STRIP001 {
//STRIP001 	if ( rCEvt.GetCommand() == COMMAND_CONTEXTMENU )
//STRIP001 	{
//STRIP001 		SfxDispatcher* pDispatcher = pDrViewSh->GetViewFrame()->GetDispatcher();
//STRIP001 		pDispatcher->ExecutePopup(SdResId(RID_LAYERTAB_POPUP));
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
\************************************************************************/
//STRIP001 long SdLayerTab::StartRenaming()
//STRIP001 {
//STRIP001 	BOOL bOK = TRUE;
//STRIP001 	String aLayerName = GetPageText( GetEditPageId() );
//STRIP001 	String aLayoutLayer ( SdResId(STR_LAYER_LAYOUT) );
//STRIP001 	String aControlsLayer ( SdResId(STR_LAYER_CONTROLS) );
//STRIP001 	String aMeasureLinesLayer ( SdResId(STR_LAYER_MEASURELINES) );
//STRIP001 	String aBackgroundLayer( SdResId(STR_LAYER_BCKGRND) );
//STRIP001 	String aBackgroundObjLayer( SdResId(STR_LAYER_BCKGRNDOBJ) );
//STRIP001 
//STRIP001 	if ( aLayerName == aLayoutLayer       || aLayerName == aControlsLayer  ||
//STRIP001 		 aLayerName == aMeasureLinesLayer ||
//STRIP001 		 aLayerName == aBackgroundLayer   || aLayerName == aBackgroundObjLayer )
//STRIP001 	{
//STRIP001 		// Diese Namen duerfen nicht veraendert werden
//STRIP001 		bOK = FALSE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SdView* pView = pDrViewSh->GetView();
//STRIP001 
//STRIP001 		if ( pView->IsTextEdit() )
//STRIP001 		{
//STRIP001 			pView->EndTextEdit();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return(bOK);
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 long SdLayerTab::AllowRenaming()
//STRIP001 {
//STRIP001 	BOOL bOK = TRUE;
//STRIP001 
//STRIP001 	// Ueberpruefung auf schon vorhandene Namen
//STRIP001 	SdView* pView = pDrViewSh->GetView();
//STRIP001 	SdDrawDocument* pDoc = pView->GetDoc();
//STRIP001 	String aLayerName = pView->GetActiveLayer();
//STRIP001 	SdrLayerAdmin& rLayerAdmin = pDoc->GetLayerAdmin();
//STRIP001 	String aNewName( GetEditText() );
//STRIP001 
//STRIP001 	if ( aNewName.Len() == 0 ||
//STRIP001 		(rLayerAdmin.GetLayer( aNewName, FALSE ) && aLayerName != aNewName) )
//STRIP001 	{
//STRIP001 		// Name ist schon vorhanden
//STRIP001 		WarningBox aWarningBox( &pDrViewSh->GetViewFrame()->GetWindow(), WinBits( WB_OK ),
//STRIP001 								String(SdResId( STR_WARN_NAME_DUPLICATE ) ) );
//STRIP001 		aWarningBox.Execute();
//STRIP001 		bOK = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bOK)
//STRIP001 	{
//STRIP001 		String aLayoutLayer ( SdResId(STR_LAYER_LAYOUT) );
//STRIP001 		String aControlsLayer ( SdResId(STR_LAYER_CONTROLS) );
//STRIP001 		String aMeasureLinesLayer ( SdResId(STR_LAYER_MEASURELINES) );
//STRIP001 		String aBackgroundLayer( SdResId(STR_LAYER_BCKGRND) );
//STRIP001 		String aBackgroundObjLayer( SdResId(STR_LAYER_BCKGRNDOBJ) );
//STRIP001 
//STRIP001 		if ( aNewName == aLayoutLayer       || aNewName == aControlsLayer  ||
//STRIP001 			 aNewName == aMeasureLinesLayer ||
//STRIP001 			 aNewName == aBackgroundLayer   || aNewName == aBackgroundObjLayer )
//STRIP001 		{
//STRIP001 			// Diese Namen duerfen nicht vergeben werden
//STRIP001 			bOK = FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return(bOK);
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 void SdLayerTab::EndRenaming()
//STRIP001 {
//STRIP001 	if( !IsEditModeCanceled() )
//STRIP001 	{
//STRIP001 		SdView* pView = pDrViewSh->GetView();
//STRIP001 		SdDrawView* pDrView = PTR_CAST( SdDrawView, pView );
//STRIP001 
//STRIP001 		SdDrawDocument* pDoc = pView->GetDoc();
//STRIP001 		String aLayerName = pView->GetActiveLayer();
//STRIP001 		SdrLayerAdmin& rLayerAdmin = pDoc->GetLayerAdmin();
//STRIP001 		SdrLayer* pLayer = rLayerAdmin.GetLayer(aLayerName, FALSE);
//STRIP001 
//STRIP001 		if (pLayer)
//STRIP001 		{
//STRIP001 			String aNewName( GetEditText() );
//STRIP001 
//STRIP001 			DBG_ASSERT( pDrView, "Rename layer undo action is only working with a SdDrawView" );
//STRIP001 			if( pDrView )
//STRIP001 			{
//STRIP001 				SfxUndoManager* pManager = pDoc->GetDocSh()->GetUndoManager();
//STRIP001 				SdLayerModifyUndoAction* pAction = new SdLayerModifyUndoAction(
//STRIP001 					pDoc,
//STRIP001 					pLayer,
//STRIP001 					aLayerName,
//STRIP001 					pDrView->IsLayerVisible(aLayerName),
//STRIP001 					pDrView->IsLayerLocked(aLayerName),
//STRIP001 					pDrView->IsLayerPrintable(aLayerName),
//STRIP001 					aNewName,
//STRIP001 					pDrView->IsLayerVisible(aLayerName),
//STRIP001 					pDrView->IsLayerLocked(aLayerName),
//STRIP001 					pDrView->IsLayerPrintable(aLayerName)
//STRIP001 					);
//STRIP001 				pManager->AddUndoAction( pAction );
//STRIP001 			}
//STRIP001 
//STRIP001 			// Zuerst View benachrichtigen, da innerhalb von SetName() schon
//STRIP001 			// ResetActualLayer() gerufen wird und an der View der Layer dann
//STRIP001 			// schon bekannt sein muss.
//STRIP001 			pView->SetActiveLayer(aNewName);
//STRIP001 			pLayer->SetName(aNewName);
//STRIP001 			pDoc->SetChanged(TRUE);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
\************************************************************************/

//STRIP001 void SdLayerTab::ActivatePage()
//STRIP001 {
//STRIP001 	if ( /*IsInSwitching*/ 1 )
//STRIP001 	{
//STRIP001 		SfxDispatcher* pDispatcher = pDrViewSh->GetViewFrame()->GetDispatcher();
//STRIP001 		pDispatcher->Execute(SID_SWITCHLAYER, SFX_CALLMODE_ASYNCHRON);
//STRIP001 	}
//STRIP001 }




//STRIP001 void SdLayerTab::SendActivatePageEvent (void)
//STRIP001 {
//STRIP001     CallEventListeners (VCLEVENT_TABBAR_PAGEACTIVATED,
//STRIP001         reinterpret_cast<void*>(GetCurPageId()));
//STRIP001 }




//STRIP001 void SdLayerTab::SendDeactivatePageEvent (void)
//STRIP001 {
//STRIP001 	CallEventListeners (VCLEVENT_TABBAR_PAGEDEACTIVATED,
//STRIP001         reinterpret_cast<void*>(GetCurPageId()));
//STRIP001 }
}
