/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sdview.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:06:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SD_SDVIEW_HXX
#define _SD_SDVIEW_HXX

#ifndef _PRESENTATION_HXX
#include "pres.hxx"
#endif
#ifndef _GEN_HXX //autogen
#include <tools/gen.hxx>
#endif
#ifndef _TRANSFER_HXX //autogen
#include <svtools/transfer.hxx>
#endif
#ifndef _SVX_FMVIEW_HXX
#include <bf_svx/fmview.hxx>
#endif
#ifndef _SVDMARK_HXX //autogen
#include <bf_svx/svdmark.hxx>
#endif
#ifndef _SVDVMARK_HXX //autogen
#include <bf_svx/svdvmark.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <bf_svx/svdpage.hxx>
#endif
class OutputDevice;
class VirtualDevice;
class ImageMap;
class Point;
class Graphic;
class TransferableDataHelper;
namespace binfilter {

class SdWindow;
class SdDrawDocument;
class SdDrawDocShell;
class SdViewShell;
class SdrOle2Obj;
class SdrGrafObj;
class SdrOutliner;
struct StyleRequestData;
struct SdNavigatorDropEvent;

// -------------------
// - SdViewRedrawRec -
// -------------------

struct SdViewRedrawRec
{
	OutputDevice* pOut;
	Rectangle	  aRect;
};

// ----------
// - SdView -
// ----------

class SdView : public FmFormView
{
protected:

	SdDrawDocument* 	    pDoc;
	SdDrawDocShell* 	    pDocSh;
	SdViewShell*		    pViewSh;
	SdrMarkList*		    pDragSrcMarkList;
	SdrObject*			    pDropMarkerObj;
	SdrViewUserMarker*	    pDropMarker;
	USHORT				    nDragSrcPgNum;
	Point				    aDropPos;
	::std::vector< String >	aDropFileVector;
	sal_Int8			    nAction;
	Timer				    aDropErrorTimer;
	Timer				    aDropInsertFileTimer;
	USHORT				    nLockRedrawSmph;
	List*				    pLockedRedraws;
	BOOL				    bIsDropAllowed;

					        DECL_LINK( DropErrorHdl, Timer* );
					        DECL_LINK( DropInsertFileHdl, Timer* );
//STRIP001 					        DECL_LINK( ExecuteNavigatorDrop, SdNavigatorDropEvent* pSdNavigatorDropEvent );
public:

	                        TYPEINFO();

	                        SdView( SdDrawDocument* pDrawDoc, OutputDevice* pOutDev, SdViewShell* pViewSh=NULL );
	virtual                 ~SdView();

//STRIP001 	void                    InitRedraw( OutputDevice* pOutDev, const Region& rReg );

//STRIP001 	virtual BOOL 	        GetAttributes( SfxItemSet& rTargetSet, BOOL bOnlyHardAttr=FALSE ) const;
//STRIP001 	virtual BOOL   	        SetAttributes(const SfxItemSet& rSet, BOOL bReplaceAll = FALSE);
	virtual void	        MarkListHasChanged();
	virtual BOOL	        HasMarkedObj() const { return SdrView::HasMarkedObj(); }
	virtual void	        ModelHasChanged();
//STRIP001 	virtual void            SelectAll();
//STRIP001 	virtual void            DoCut(Window* pWindow=NULL);
//STRIP001 	virtual void            DoCopy(Window* pWindow=NULL);
//STRIP001 	virtual void            DoPaste(Window* pWindow=NULL);
//STRIP001 	virtual void            DoConnect(SdrOle2Obj* pOleObj);
//STRIP001 	virtual BOOL            SetStyleSheet(SfxStyleSheet* pStyleSheet, BOOL bDontRemoveHardAttr = FALSE);
//STRIP001     virtual void            StartDrag( const Point& rStartPos, Window* pWindow );
//STRIP001 	virtual void            DragFinished( sal_Int8 nDropAction );
//STRIP001 	virtual sal_Int8        AcceptDrop( const AcceptDropEvent& rEvt, DropTargetHelper& rTargetHelper,
//STRIP001                                         SdWindow* pTargetWindow = NULL, USHORT nPage = SDRPAGE_NOTFOUND, USHORT nLayer = SDRPAGE_NOTFOUND );
//STRIP001 	virtual sal_Int8        ExecuteDrop( const ExecuteDropEvent& rEvt, DropTargetHelper& rTargetHelper,
//STRIP001                                          SdWindow* pTargetWindow = NULL, USHORT nPage = SDRPAGE_NOTFOUND, USHORT nLayer = SDRPAGE_NOTFOUND );

//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable >	CreateClipboardDataObject( SdView*, Window& rWindow );
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable >	CreateDragDataObject( SdView*, Window& rWindow, const Point& rDragPos );
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable >	CreateSelectionDataObject( SdView*, Window& rWindow );

    void                    UpdateSelectionClipboard( BOOL bForceDeselect );

	SdDrawDocShell*         GetDocSh() const { return pDocSh; }
	SdDrawDocument*         GetDoc() const { return pDoc; }

//STRIP001 	BOOL                    BegTextEdit( SdrObject* pObj, SdrPageView* pPV=NULL, Window* pWin=NULL, BOOL bIsNewObj=FALSE,
//STRIP001 					                     SdrOutliner* pGivenOutliner=NULL, OutlinerView* pGivenOutlinerView=NULL,
//STRIP001 					                     BOOL bDontDeleteOutliner=FALSE, BOOL bOnlyOneView=FALSE );
//STRIP001 	SdrEndTextEditKind      EndTextEdit(BOOL bDontDeleteReally=FALSE);

//STRIP001 	BOOL		            InsertData( const TransferableDataHelper& rDataHelper,
//STRIP001 							            const Point& rPos, sal_Int8& rDnDAction, BOOL bDrag,
//STRIP001 							            ULONG nFormat = 0, USHORT nPage = SDRPAGE_NOTFOUND, USHORT nLayer = SDRLAYER_NOTFOUND );
//STRIP001 	SdrGrafObj*             InsertGraphic( const Graphic& rGraphic,
//STRIP001 							               sal_Int8& rAction, const Point& rPos,
//STRIP001 							               SdrObject* pSelectedObj, ImageMap* pImageMap );

//STRIP001 	BOOL	                IsPresObjSelected(BOOL bOnPage=TRUE, BOOL bOnMasterPage=TRUE, BOOL bCheckPresObjListOnly=FALSE) const;

//STRIP001 	void	                SetMarkedOriginalSize();

//STRIP001 	VirtualDevice*          CreatePageVDev(USHORT nSdPage, PageKind ePageKind, ULONG nWidthPixel);

//STRIP001 	void	                LockRedraw(BOOL bLock);

	BOOL	                IsMorphingAllowed() const;
	BOOL	                IsVectorizeAllowed() const;

//STRIP001 	virtual SfxStyleSheet*  GetStyleSheet() const;

//STRIP001 	BOOL	                GetExchangeList( List*& rpExchangeList, List* pBookmarkList, USHORT nType );

//STRIP001 	virtual void onAccessibilityOptionsChanged();

//STRIP001 	virtual SdrModel*   GetMarkedObjModel() const;
//STRIP001 	virtual BOOL		Paste(const SdrModel& rMod, const Point& rPos, SdrObjList* pLst=NULL, UINT32 nOptions=0);
};

} //namespace binfilter
#endif // _SD_SDVIEW_HXX
