/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_dpsdbtab.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:46:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#include "core_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE --------------------------------------------------------------

#include <tools/debug.hxx>
#include <vcl/msgbox.hxx>
#include <svtools/zforlist.hxx>
#include <comphelper/processfactory.hxx>
#include <comphelper/types.hxx>

#include <com/sun/star/sheet/DataImportMode.hpp>
#include <com/sun/star/beans/XPropertySet.hpp>
#include <com/sun/star/sdb/CommandType.hpp>
#include <com/sun/star/sdb/XCompletedExecution.hpp>
#include <com/sun/star/sdbc/DataType.hpp>
#include <com/sun/star/sdbc/XRow.hpp>
#include <com/sun/star/sdbc/XRowSet.hpp>
#include <com/sun/star/sdbc/XResultSetMetaDataSupplier.hpp>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>

#include "dpsdbtab.hxx"
#include "collect.hxx"
#include "global.hxx"
#include "globstr.hrc"
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {
using namespace ::com::sun::star;

#define SC_SERVICE_ROWSET			"com.sun.star.sdb.RowSet"
#define SC_SERVICE_INTHANDLER		"com.sun.star.sdb.InteractionHandler"

//!	move to a header file?
#define SC_DBPROP_DATASOURCENAME	"DataSourceName"
#define SC_DBPROP_COMMAND			"Command"
#define SC_DBPROP_COMMANDTYPE		"CommandType"

// -----------------------------------------------------------------------

//STRIP001 class ScDatabaseDPData_Impl
//STRIP001 {
//STRIP001 public:
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > xServiceManager;
//STRIP001 	ScImportSourceDesc	aDesc;
//STRIP001 	long				nColCount;
//STRIP001 	BOOL				bValid;
//STRIP001 	BOOL				bAtStart;
//STRIP001 	String*				pTitles;
//STRIP001 	TypedStrCollection** ppStrings;
//STRIP001 	uno::Reference<sdbc::XRowSet> xRowSet;
//STRIP001 	sal_Int32*			pTypes;
//STRIP001 	SvNumberFormatter*	pFormatter;
//STRIP001 
//STRIP001 	ScDatabaseDPData_Impl() {}
//STRIP001 };
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 ScDatabaseDPData::ScDatabaseDPData(
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > xSMgr,
//STRIP001 	const ScImportSourceDesc& rImport )
//STRIP001 {
//STRIP001 	pImpl = new ScDatabaseDPData_Impl;
//STRIP001 	pImpl->xServiceManager = xSMgr;
//STRIP001 	pImpl->aDesc = rImport;
//STRIP001 	pImpl->nColCount = 0;
//STRIP001 	pImpl->bValid = FALSE;
//STRIP001 	pImpl->bAtStart = FALSE;
//STRIP001 	pImpl->pTitles = NULL;
//STRIP001 	pImpl->ppStrings = NULL;
//STRIP001 	pImpl->pTypes = NULL;
//STRIP001 	pImpl->pFormatter = NULL;		// created on demand
//STRIP001 
//STRIP001 	OpenDatabase();
//STRIP001 }
//STRIP001 
//STRIP001 ScDatabaseDPData::~ScDatabaseDPData()
//STRIP001 {
//STRIP001 	::comphelper::disposeComponent( pImpl->xRowSet );
//STRIP001 
//STRIP001 	delete[] pImpl->pTypes;
//STRIP001 	if ( pImpl->ppStrings )
//STRIP001 	{
//STRIP001 		for (long i=0; i<pImpl->nColCount; i++)
//STRIP001 			delete pImpl->ppStrings[i];
//STRIP001 		delete[] pImpl->ppStrings;
//STRIP001 	}
//STRIP001 	delete[] pImpl->pTitles;
//STRIP001 	delete pImpl->pFormatter;		// NumberFormatter is local for this object
//STRIP001 	delete pImpl;
//STRIP001 }
//STRIP001 
//STRIP001 void ScDatabaseDPData::DisposeData()
//STRIP001 {
//STRIP001 	//!	use OpenDatabase here?
//STRIP001 
//STRIP001 	//!	column titles ???
//STRIP001 
//STRIP001 	//	collections for column entries
//STRIP001 	if ( pImpl->ppStrings )
//STRIP001 	{
//STRIP001 		for (long i=0; i<pImpl->nColCount; i++)
//STRIP001 		{
//STRIP001 			delete pImpl->ppStrings[i];
//STRIP001 			pImpl->ppStrings[i] = NULL;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//!	init entries on demand!
//STRIP001 	InitAllColumnEntries();				//! configurable ???
//STRIP001 }
//STRIP001 
//STRIP001 BOOL ScDatabaseDPData::OpenDatabase()
//STRIP001 {
//STRIP001 	sal_Int32 nSdbType = -1;
//STRIP001 	switch ( pImpl->aDesc.nType )
//STRIP001 	{
//STRIP001 		case sheet::DataImportMode_SQL:		nSdbType = sdb::CommandType::COMMAND;	break;
//STRIP001 		case sheet::DataImportMode_TABLE:	nSdbType = sdb::CommandType::TABLE;		break;
//STRIP001 		case sheet::DataImportMode_QUERY:	nSdbType = sdb::CommandType::QUERY;		break;
//STRIP001 		default:
//STRIP001 			return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bSuccess = FALSE;
//STRIP001 	try
//STRIP001 	{
//STRIP001 		pImpl->xRowSet = uno::Reference<sdbc::XRowSet>(
//STRIP001 				::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance(
//STRIP001 					::rtl::OUString::createFromAscii( SC_SERVICE_ROWSET ) ),
//STRIP001 				uno::UNO_QUERY);
//STRIP001 		uno::Reference<beans::XPropertySet> xRowProp( pImpl->xRowSet, uno::UNO_QUERY );
//STRIP001 		DBG_ASSERT( xRowProp.is(), "can't get RowSet" );
//STRIP001 		if ( xRowProp.is() )
//STRIP001 		{
//STRIP001 			//
//STRIP001 			//	set source parameters
//STRIP001 			//
//STRIP001 
//STRIP001 			uno::Any aAny;
//STRIP001 
//STRIP001 			aAny <<= ::rtl::OUString( pImpl->aDesc.aDBName );
//STRIP001 			xRowProp->setPropertyValue(
//STRIP001 						::rtl::OUString::createFromAscii(SC_DBPROP_DATASOURCENAME), aAny );
//STRIP001 
//STRIP001 			aAny <<= ::rtl::OUString( pImpl->aDesc.aObject );
//STRIP001 			xRowProp->setPropertyValue(
//STRIP001 						::rtl::OUString::createFromAscii(SC_DBPROP_COMMAND), aAny );
//STRIP001 
//STRIP001 			aAny <<= nSdbType;
//STRIP001 			xRowProp->setPropertyValue(
//STRIP001 						::rtl::OUString::createFromAscii(SC_DBPROP_COMMANDTYPE), aAny );
//STRIP001 
//STRIP001 			uno::Reference<sdb::XCompletedExecution> xExecute( pImpl->xRowSet, uno::UNO_QUERY );
//STRIP001 			if ( xExecute.is() )
//STRIP001 			{
//STRIP001 				uno::Reference<task::XInteractionHandler> xHandler(
//STRIP001 						::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance(
//STRIP001 							::rtl::OUString::createFromAscii( SC_SERVICE_INTHANDLER ) ),
//STRIP001 						uno::UNO_QUERY);
//STRIP001 				xExecute->executeWithCompletion( xHandler );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pImpl->xRowSet->execute();
//STRIP001 
//STRIP001 			pImpl->bAtStart = TRUE;
//STRIP001 
//STRIP001 			//
//STRIP001 			//	get column descriptions
//STRIP001 			//
//STRIP001 
//STRIP001 			pImpl->nColCount = 0;
//STRIP001 			uno::Reference<sdbc::XResultSetMetaData> xMeta;
//STRIP001 			uno::Reference<sdbc::XResultSetMetaDataSupplier> xMetaSupp( pImpl->xRowSet, uno::UNO_QUERY );
//STRIP001 			if ( xMetaSupp.is() )
//STRIP001 				xMeta = xMetaSupp->getMetaData();
//STRIP001 			if ( xMeta.is() )
//STRIP001 				pImpl->nColCount = xMeta->getColumnCount();	// this is the number of real columns
//STRIP001 
//STRIP001 			uno::Reference<sdbc::XResultSet> xResSet( pImpl->xRowSet, uno::UNO_QUERY );
//STRIP001 			if ( pImpl->nColCount > 0 && xResSet.is() )
//STRIP001 			{
//STRIP001 				//	get column titles
//STRIP001 				pImpl->pTitles = new String[pImpl->nColCount];
//STRIP001 				pImpl->pTypes = new sal_Int32[pImpl->nColCount];
//STRIP001 				for (long nCol=0; nCol<pImpl->nColCount; nCol++)
//STRIP001 				{
//STRIP001 					pImpl->pTitles[nCol] = xMeta->getColumnLabel( nCol+1 );
//STRIP001 					pImpl->pTypes[nCol]  = xMeta->getColumnType( nCol+1 );
//STRIP001 				}
//STRIP001 
//STRIP001 				//	collections for column entries
//STRIP001 				pImpl->ppStrings = new TypedStrCollection*[pImpl->nColCount];
//STRIP001 				for (long i=0; i<pImpl->nColCount; i++)
//STRIP001 					pImpl->ppStrings[i] = NULL;
//STRIP001 
//STRIP001 				//!	init entries on demand!
//STRIP001 				InitAllColumnEntries();				//! configurable ???
//STRIP001 
//STRIP001 				bSuccess = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch ( sdbc::SQLException& rError )
//STRIP001 	{
//STRIP001 		//!	store error message
//STRIP001 		InfoBox aInfoBox( 0, String(rError.Message) );
//STRIP001 		aInfoBox.Execute();
//STRIP001 	}
//STRIP001 	catch ( uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERROR("Unexpected exception in database");
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	if (!bSuccess)
//STRIP001 		::comphelper::disposeComponent( pImpl->xRowSet );
//STRIP001 
//STRIP001 	pImpl->bValid = bSuccess;
//STRIP001 	return bSuccess;
//STRIP001 }
//STRIP001 
//STRIP001 long ScDatabaseDPData::GetColumnCount()
//STRIP001 {
//STRIP001 	return pImpl->nColCount;
//STRIP001 }
//STRIP001 
//STRIP001 void lcl_FillItemData( ScDPItemData& rData,
//STRIP001 						const uno::Reference<sdbc::XRow>& xRow, long nRowPos,
//STRIP001 						long nType, BOOL bStringForVal, ScDatabaseDPData_Impl* pImpl )
//STRIP001 {
//STRIP001 	//!	merge with lcl_PutData in dbdocimp.cxx
//STRIP001 
//STRIP001 	rData.aString.Erase();
//STRIP001 	rData.fValue = 0.0;
//STRIP001 	rData.bHasValue = FALSE;
//STRIP001 	short nNumType = NUMBERFORMAT_NUMBER;
//STRIP001 	BOOL bEmptyFlag = FALSE;
//STRIP001 
//STRIP001 	if (!xRow.is())
//STRIP001 		return;
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		switch ( nType )
//STRIP001 		{
//STRIP001 			case sdbc::DataType::BIT:
//STRIP001 				nNumType = NUMBERFORMAT_LOGICAL;
//STRIP001 				rData.fValue = (xRow->getBoolean(nRowPos) ? 1 : 0);
//STRIP001 				bEmptyFlag = ( rData.fValue == 0.0 ) && xRow->wasNull();
//STRIP001 				rData.bHasValue = TRUE;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case sdbc::DataType::TINYINT:
//STRIP001 			case sdbc::DataType::SMALLINT:
//STRIP001 			case sdbc::DataType::INTEGER:
//STRIP001 			case sdbc::DataType::BIGINT:
//STRIP001 			case sdbc::DataType::FLOAT:
//STRIP001 			case sdbc::DataType::REAL:
//STRIP001 			case sdbc::DataType::DOUBLE:
//STRIP001 			case sdbc::DataType::NUMERIC:
//STRIP001 			case sdbc::DataType::DECIMAL:
//STRIP001 				//!	do the conversion here?
//STRIP001 				rData.fValue = xRow->getDouble(nRowPos);
//STRIP001 				bEmptyFlag = ( rData.fValue == 0.0 ) && xRow->wasNull();
//STRIP001 				rData.bHasValue = TRUE;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case sdbc::DataType::CHAR:
//STRIP001 			case sdbc::DataType::VARCHAR:
//STRIP001 			case sdbc::DataType::LONGVARCHAR:
//STRIP001 				rData.aString = xRow->getString(nRowPos);
//STRIP001 				bEmptyFlag = ( rData.aString.Len() == 0 ) && xRow->wasNull();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case sdbc::DataType::DATE:
//STRIP001 				{
//STRIP001 					nNumType = NUMBERFORMAT_DATE;
//STRIP001 
//STRIP001 					if (!pImpl->pFormatter)
//STRIP001 						pImpl->pFormatter = new SvNumberFormatter( pImpl->xServiceManager, ScGlobal::eLnge );
//STRIP001 
//STRIP001 					util::Date aDate = xRow->getDate(nRowPos);
//STRIP001 					rData.fValue = Date( aDate.Day, aDate.Month, aDate.Year ) -
//STRIP001 												*pImpl->pFormatter->GetNullDate();
//STRIP001 					bEmptyFlag = xRow->wasNull();
//STRIP001 					rData.bHasValue = TRUE;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			//! case sdbc::DataType::TIME:
//STRIP001 			//! case sdbc::DataType::TIMESTAMP:
//STRIP001 
//STRIP001 			case sdbc::DataType::SQLNULL:
//STRIP001 				//bEmptyFlag = TRUE;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case sdbc::DataType::BINARY:
//STRIP001 			case sdbc::DataType::VARBINARY:
//STRIP001 			case sdbc::DataType::LONGVARBINARY:
//STRIP001 			default:
//STRIP001 				//bError = TRUE;		// unknown type
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch ( uno::Exception& )
//STRIP001 	{
//STRIP001 		//bError = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bEmptyFlag )
//STRIP001 		rData.bHasValue = FALSE;		// empty -> empty string
//STRIP001 
//STRIP001 	if ( rData.bHasValue && bStringForVal )
//STRIP001 	{
//STRIP001 		if (!pImpl->pFormatter)
//STRIP001 			pImpl->pFormatter = new SvNumberFormatter( pImpl->xServiceManager, ScGlobal::eLnge );
//STRIP001 
//STRIP001 		ULONG nIndex = pImpl->pFormatter->GetStandardFormat( nNumType, ScGlobal::eLnge );
//STRIP001 		pImpl->pFormatter->GetInputLineString( rData.fValue, nIndex, rData.aString );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void lcl_Reset( const uno::Reference<sdbc::XRowSet>& xRowSet )
//STRIP001 					throw(sdbc::SQLException, uno::RuntimeException)
//STRIP001 {
//STRIP001 	//	isBeforeFirst / beforeFirst is not always available
//STRIP001 	//!	query if it is allowed
//STRIP001 
//STRIP001 	xRowSet->execute();		// restart
//STRIP001 }
//STRIP001 
//STRIP001 void ScDatabaseDPData::InitAllColumnEntries()
//STRIP001 {
//STRIP001 	DBG_ASSERT( pImpl->ppStrings, "GetColumnEntries: no entries" );
//STRIP001 	long nCol;
//STRIP001 	for ( nCol=0; nCol<pImpl->nColCount; nCol++ )
//STRIP001 		if (!pImpl->ppStrings[nCol])
//STRIP001 			pImpl->ppStrings[nCol] = new TypedStrCollection;
//STRIP001 
//STRIP001 //	Sound::Beep();		//! Test !!!
//STRIP001 
//STRIP001 	uno::Reference<sdbc::XRowSet> xRowSet = pImpl->xRowSet;
//STRIP001 	uno::Reference<sdbc::XRow> xRow( xRowSet, uno::UNO_QUERY );
//STRIP001 	if ( xRow.is() )
//STRIP001 	{
//STRIP001 		ScDPItemData aItemData;
//STRIP001 
//STRIP001 		try
//STRIP001 		{
//STRIP001 			if ( !pImpl->bAtStart )
//STRIP001 				lcl_Reset( xRowSet );
//STRIP001 
//STRIP001 			pImpl->bAtStart = FALSE;
//STRIP001 			while ( xRowSet->next() )
//STRIP001 			{
//STRIP001 				for ( nCol=0; nCol<pImpl->nColCount; nCol++ )
//STRIP001 				{
//STRIP001 					//!	get string for value data only if value hasn't been inserted yet
//STRIP001 					lcl_FillItemData( aItemData, xRow, nCol+1, pImpl->pTypes[nCol], TRUE, pImpl );
//STRIP001 					TypedStrData* pNew = new TypedStrData(
//STRIP001 							aItemData.aString, aItemData.fValue,
//STRIP001 							aItemData.bHasValue ? SC_STRTYPE_VALUE : SC_STRTYPE_STANDARD );
//STRIP001 					if (!pImpl->ppStrings[nCol]->Insert(pNew))
//STRIP001 						delete pNew;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		catch ( sdbc::SQLException& rError )
//STRIP001 		{
//STRIP001 			//!	store error message
//STRIP001 			InfoBox aInfoBox( 0, String(rError.Message) );
//STRIP001 			aInfoBox.Execute();
//STRIP001 		}
//STRIP001 		catch ( uno::Exception& )
//STRIP001 		{
//STRIP001 			DBG_ERROR("Unexpected exception in database");
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 const TypedStrCollection& ScDatabaseDPData::GetColumnEntries(long nColumn)
//STRIP001 {
//STRIP001 	DBG_ASSERT( pImpl->ppStrings && nColumn < pImpl->nColCount, "GetColumnEntries: no entries" );
//STRIP001 	if (!pImpl->ppStrings[nColumn])
//STRIP001 	{
//STRIP001 		TypedStrCollection* pColl = new TypedStrCollection;
//STRIP001 
//STRIP001 		//!	select distinct values directly from database
//STRIP001 
//STRIP001 //		Sound::Beep();		//! Test !!!
//STRIP001 
//STRIP001 		uno::Reference<sdbc::XRowSet> xRowSet = pImpl->xRowSet;
//STRIP001 		uno::Reference<sdbc::XRow> xRow( xRowSet, uno::UNO_QUERY );
//STRIP001 		if ( xRow.is() )
//STRIP001 		{
//STRIP001 			ScDPItemData aItemData;
//STRIP001 
//STRIP001 			try
//STRIP001 			{
//STRIP001 				if ( !pImpl->bAtStart )
//STRIP001 					lcl_Reset( xRowSet );
//STRIP001 
//STRIP001 				pImpl->bAtStart = FALSE;
//STRIP001 				while ( xRowSet->next() )
//STRIP001 				{
//STRIP001 					//!	get string for value data only if value hasn't been inserted yet
//STRIP001 					lcl_FillItemData( aItemData, xRow, nColumn+1, pImpl->pTypes[nColumn], TRUE, pImpl );
//STRIP001 					TypedStrData* pNew = new TypedStrData(
//STRIP001 							aItemData.aString, aItemData.fValue,
//STRIP001 							aItemData.bHasValue ? SC_STRTYPE_VALUE : SC_STRTYPE_STANDARD );
//STRIP001 					if (!pColl->Insert(pNew))
//STRIP001 						delete pNew;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			catch ( sdbc::SQLException& rError )
//STRIP001 			{
//STRIP001 				//!	store error message
//STRIP001 				InfoBox aInfoBox( 0, String(rError.Message) );
//STRIP001 				aInfoBox.Execute();
//STRIP001 			}
//STRIP001 			catch ( uno::Exception& )
//STRIP001 			{
//STRIP001 				DBG_ERROR("Unexpected exception in database");
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		pImpl->ppStrings[nColumn] = pColl;
//STRIP001 	}
//STRIP001 	return *pImpl->ppStrings[nColumn];
//STRIP001 }
//STRIP001 
//STRIP001 String ScDatabaseDPData::getDimensionName(long nColumn)
//STRIP001 {
//STRIP001 	if (getIsDataLayoutDimension(nColumn))
//STRIP001 	{
//STRIP001 		//!	different internal and display names?
//STRIP001 		//return "Data";
//STRIP001 		return ScGlobal::GetRscString(STR_PIVOT_DATA);
//STRIP001 	}
//STRIP001 	else if ( pImpl->pTitles && nColumn < pImpl->nColCount )
//STRIP001 	{
//STRIP001 		return pImpl->pTitles[nColumn];
//STRIP001 	}
//STRIP001 	DBG_ERROR("getDimensionName: invalid dimension");
//STRIP001 	return String();
//STRIP001 }
//STRIP001 
//STRIP001 BOOL ScDatabaseDPData::getIsDataLayoutDimension(long nColumn)
//STRIP001 {
//STRIP001 	return ( nColumn == pImpl->nColCount );
//STRIP001 }
//STRIP001 
//STRIP001 BOOL ScDatabaseDPData::IsDateDimension(long nDim)
//STRIP001 {
//STRIP001 	//!	later...
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 void ScDatabaseDPData::SetEmptyFlags( BOOL bIgnoreEmptyRows, BOOL bRepeatIfEmpty )
//STRIP001 {
//STRIP001 	//	not used for database data
//STRIP001 	//!	disable flags
//STRIP001 }
//STRIP001 
//STRIP001 void ScDatabaseDPData::ResetIterator()
//STRIP001 {
//STRIP001 	try
//STRIP001 	{
//STRIP001 		uno::Reference<sdbc::XRowSet> xRowSet = pImpl->xRowSet;
//STRIP001 		if ( xRowSet.is() && !pImpl->bAtStart )
//STRIP001 		{
//STRIP001 			lcl_Reset( xRowSet );
//STRIP001 			pImpl->bAtStart = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch ( sdbc::SQLException& rError )
//STRIP001 	{
//STRIP001 		//!	store error message
//STRIP001 		InfoBox aInfoBox( 0, String(rError.Message) );
//STRIP001 		aInfoBox.Execute();
//STRIP001 	}
//STRIP001 	catch ( uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERROR("Unexpected exception in database");
//STRIP001 	}
//STRIP001 
//STRIP001 //	Sound::Beep();		//! Test !!!
//STRIP001 }
//STRIP001 
//STRIP001 BOOL ScDatabaseDPData::GetNextRow( const ScDPTableIteratorParam& rParam )
//STRIP001 {
//STRIP001 	BOOL bSuccess = FALSE;
//STRIP001 	uno::Reference<sdbc::XRowSet> xRowSet = pImpl->xRowSet;
//STRIP001 	uno::Reference<sdbc::XRow> xRow( xRowSet, uno::UNO_QUERY );
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		pImpl->bAtStart = FALSE;
//STRIP001 		if ( xRow.is() && xRowSet->next() )
//STRIP001 		{
//STRIP001 			long i;
//STRIP001 
//STRIP001 			for (i=0; i<rParam.nColCount; i++)
//STRIP001 			{
//STRIP001 				long nDim = rParam.pCols[i];
//STRIP001 				if ( getIsDataLayoutDimension(nDim) )
//STRIP001 					rParam.pColData[i].SetString( String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("x")) );
//STRIP001 				else
//STRIP001 					lcl_FillItemData( rParam.pColData[i], xRow, nDim+1, pImpl->pTypes[nDim], FALSE, pImpl );
//STRIP001 			}
//STRIP001 
//STRIP001 			for (i=0; i<rParam.nRowCount; i++)
//STRIP001 			{
//STRIP001 				long nDim = rParam.pRows[i];
//STRIP001 				if ( getIsDataLayoutDimension(nDim) )
//STRIP001 					rParam.pRowData[i].SetString( String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("x")) );
//STRIP001 				else
//STRIP001 					lcl_FillItemData( rParam.pRowData[i], xRow, nDim+1, pImpl->pTypes[nDim], FALSE, pImpl );
//STRIP001 			}
//STRIP001 
//STRIP001 			for (i=0; i<rParam.nDatCount; i++)
//STRIP001 			{
//STRIP001 				//!	merge this with lcl_FillItemData, distinguish all SC_VALTYPE_... types
//STRIP001 
//STRIP001 				long nDim = rParam.pDats[i];
//STRIP001 
//STRIP001 				double fVal = 0.0;
//STRIP001 				BYTE nType = SC_VALTYPE_EMPTY;
//STRIP001 				try
//STRIP001 				{
//STRIP001 					fVal = xRow->getDouble( nDim+1 );
//STRIP001 				}
//STRIP001 				catch ( uno::Exception& )
//STRIP001 				{
//STRIP001 					//	anything that can't be converted to a number is a string
//STRIP001 					nType = SC_VALTYPE_STRING;
//STRIP001 				}
//STRIP001 				rParam.pValues[i].Set( fVal, SC_VALTYPE_VALUE );
//STRIP001 			}
//STRIP001 
//STRIP001 			bSuccess = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch ( sdbc::SQLException& rError )
//STRIP001 	{
//STRIP001 		//!	store error message
//STRIP001 		InfoBox aInfoBox( 0, String(rError.Message) );
//STRIP001 		aInfoBox.Execute();
//STRIP001 	}
//STRIP001 	catch ( uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERROR("Unexpected exception in database");
//STRIP001 	}
//STRIP001 
//STRIP001 	return bSuccess;
//STRIP001 }

// -----------------------------------------------------------------------





}
