/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: b2dmbmp.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:21:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _B2D_MBMP_HXX
#include "b2dmbmp.hxx"
#endif

//************************************************************
//   InterActionObjectBitmap
//************************************************************

TYPEINIT1(B2dIAOBitmapObj, B2dIAObject);

B2dIAOBitmapObj::B2dIAOBitmapObj(B2dIAOManager* pMan, Point aPos, 
	const Bitmap& rBmp, UINT16 nCenX, UINT16 nCenY, BOOL bUTCol, Color aTransCol)
:	B2dIAObject(pMan, aPos, aTransCol),
	aBmp(rBmp),
	nCenterX(nCenX),
	nCenterY(nCenY),
	bUseTransCol(bUTCol)
{
}

B2dIAOBitmapObj::~B2dIAOBitmapObj() 
{
}

void B2dIAOBitmapObj::CreateGeometry()
{
	Region aOverRegion = GetManager()->GetClipRegion();
	aOverRegion.Intersect(Region(GetBaseRect()));
	
	if(!aOverRegion.IsEmpty())
	{
		Point aUpperLeft(GetBasePositionPixel());
		aUpperLeft.X() -= (INT32)nCenterX;
		aUpperLeft.Y() -= (INT32)nCenterY;

		if(bUseTransCol)
		{
			BitmapEx aBmpEx(aBmp, GetBaseColor());
			AddBitmap(aUpperLeft, aBmpEx);
		}
		else
		{
			BitmapEx aBmpEx(aBmp);
			AddBitmap(aUpperLeft, aBmpEx);
		}
	}
}

void B2dIAOBitmapObj::CreateBaseRect()
{
	Point aUpperLeft(GetBasePositionPixel());
	aUpperLeft.X() -= (INT32)nCenterX;
	aUpperLeft.Y() -= (INT32)nCenterY;
	SetBaseRect(Rectangle(aUpperLeft, aBmp.GetSizePixel()));
}

void B2dIAOBitmapObj::SetBitmap(const Bitmap& rNew)
{
	if(rNew != aBmp)
	{
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// remember new Bitmap
		aBmp = rNew;
	}
}

void B2dIAOBitmapObj::SetTransparenceUsed(BOOL bNew)
{
	if(bNew != bUseTransCol)
	{
		// throw away geometry
		GeometryChange(); 

		// remember new value
		bUseTransCol = bNew;
	}
}

void B2dIAOBitmapObj::SetCenterXY(UINT16 nNewX, UINT16 nNewY)
{
	if(nNewX != nCenterX || nNewY != nCenterY)
	{
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// remember new values
		if(nNewX != nCenterX)
			nCenterX = nNewX;
		if(nNewY != nCenterY)
			nCenterY = nNewY;
	}
}

//************************************************************
//   InterActionObjectBitmapEx
//************************************************************

TYPEINIT1(B2dIAOBitmapEx, B2dIAObject);

B2dIAOBitmapEx::B2dIAOBitmapEx(B2dIAOManager* pMan, Point aPos, const BitmapEx& rBmpEx,
	UINT16 nCenX, UINT16 nCenY)
:	B2dIAObject(pMan, aPos, Color(COL_LIGHTGREEN)),
	aBmpEx(rBmpEx),
	nCenterX(nCenX),
	nCenterY(nCenY)
{
}

B2dIAOBitmapEx::~B2dIAOBitmapEx() 
{
}

void B2dIAOBitmapEx::CreateGeometry()
{
	Region aOverRegion = GetManager()->GetClipRegion();
	aOverRegion.Intersect(Region(GetBaseRect()));
	
	if(!aOverRegion.IsEmpty())
	{
		Point aUpperLeft(GetBasePositionPixel());
		aUpperLeft.X() -= (INT32)nCenterX;
		aUpperLeft.Y() -= (INT32)nCenterY;
		AddBitmap(aUpperLeft, aBmpEx);
	}
}

void B2dIAOBitmapEx::CreateBaseRect()
{
	Point aUpperLeft(GetBasePositionPixel());
	aUpperLeft.X() -= (INT32)nCenterX;
	aUpperLeft.Y() -= (INT32)nCenterY;
	SetBaseRect(Rectangle(aUpperLeft, aBmpEx.GetSizePixel()));
}

void B2dIAOBitmapEx::SetBitmapEx(const BitmapEx& rNew)
{
	if(rNew != aBmpEx)
	{
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// remember new BitmapEx
		aBmpEx = rNew;
	}
}

void B2dIAOBitmapEx::SetCenterXY(UINT16 nNewX, UINT16 nNewY)
{
	if(nNewX != nCenterX || nNewY != nCenterY)
	{
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// remember new values
		if(nNewX != nCenterX)
			nCenterX = nNewX;
		if(nNewY != nCenterY)
			nCenterY = nNewY;
	}
}

//************************************************************
//   InterActionObjectBitmapExReference
//************************************************************

//TYPEINIT1(B2dIAOBitmapExReference, B2dIAObject);

//B2dIAOBitmapExReference::B2dIAOBitmapExReference(B2dIAOManager* pMan, Point aPos, BitmapEx* pBEx,
//	UINT16 nCenX, UINT16 nCenY)
//:	B2dIAObject(pMan, aPos, Color(COL_LIGHTGREEN)),
//	pBmpEx(pBEx),
//	nCenterX(nCenX),
//	nCenterY(nCenY)
//{
//}

//B2dIAOBitmapExReference::~B2dIAOBitmapExReference() 
//{
//}

//void B2dIAOBitmapExReference::CreateGeometry()
//{
//	Region aOverRegion = GetManager()->GetClipRegion();
//	aOverRegion.Intersect(Region(GetBaseRect()));
//	
//	if(!aOverRegion.IsEmpty())
//	{
//		Point aUpperLeft(GetBasePositionPixel());
//		aUpperLeft.X() -= (INT32)nCenterX;
//		aUpperLeft.Y() -= (INT32)nCenterY;
//		AddBmpRef(aUpperLeft, pBmpEx);
//	}
//}

//void B2dIAOBitmapExReference::CreateBaseRect()
//{
//	Point aUpperLeft(GetBasePositionPixel());
//	aUpperLeft.X() -= (INT32)nCenterX;
//	aUpperLeft.Y() -= (INT32)nCenterY;
//	SetBaseRect(Rectangle(aUpperLeft, pBmpEx->GetSizePixel()));
//}

//void B2dIAOBitmapExReference::SetBitmapEx(BitmapEx* pNew)
//{
//	if(*pNew != *pBmpEx)
//	{
//		// throw away geometry
//		GeometryChange(); 
//		BaseRectChange();
//
//		// remember new BitmapEx
//		pBmpEx = pNew;
//	}
//}

//void B2dIAOBitmapExReference::SetCenterXY(UINT16 nNewX, UINT16 nNewY)
//{
//	if(nNewX != nCenterX || nNewY != nCenterY)
//	{
//		// throw away geometry
//		GeometryChange(); 
//		BaseRectChange();
//
//		// remember new values
//		if(nNewX != nCenterX)
//			nCenterX = nNewX;
//		if(nNewY != nCenterY)
//			nCenterY = nNewY;
//	}
//}

//************************************************************
//   InterActionObjectAnimBitmapExReference
//************************************************************

// #97016# II
TYPEINIT1(B2dIAOAnimatedBitmapEx, B2dIAObject);

B2dIAOAnimatedBitmapEx::B2dIAOAnimatedBitmapEx(
	B2dIAOManager* pMan, 
	Point aPos, 
	const BitmapEx& rBEx1, 
	const BitmapEx& rBEx2,
	UINT16 nCenX1, 
	UINT16 nCenY1,
	UINT16 nCenX2, 
	UINT16 nCenY2)
:	B2dIAObject(pMan, aPos, Color(COL_LIGHTGREEN)),
	aBmpEx1(rBEx1),
	aBmpEx2(rBEx2),
	nCenterX1(nCenX1),
	nCenterY1(nCenY1),
	nCenterX2(nCenX2),
	nCenterY2(nCenY2)
{
	nStartCount = 0;
	nStartAdd = 0;
	SetAnimation(TRUE);
}

B2dIAOAnimatedBitmapEx::~B2dIAOAnimatedBitmapEx() 
{
}

void B2dIAOAnimatedBitmapEx::AnimationStep(UINT32 nAnimCounter)
{
	nStartCount++;

	if(((nStartAdd % 2) && nStartCount == 80) || (nStartCount == 30))
	{
		// all three times when the counter comes
		nStartAdd++;
		GeometryChange();
		BaseRectChange();

		// reset counter
		nStartCount = 0;
	}
}

void B2dIAOAnimatedBitmapEx::CreateGeometry()
{
	Region aOverRegion = GetManager()->GetClipRegion();
	aOverRegion.Intersect(Region(GetBaseRect()));
	
	if(!aOverRegion.IsEmpty())
	{
		Point aUpperLeft(GetBasePositionPixel());

		if(nStartAdd % 2)
		{
			aUpperLeft.X() -= (INT32)nCenterX1;
			aUpperLeft.Y() -= (INT32)nCenterY1;
			AddBitmap(aUpperLeft, aBmpEx1);
		}
		else
		{
			aUpperLeft.X() -= (INT32)nCenterX2;
			aUpperLeft.Y() -= (INT32)nCenterY2;
			AddBitmap(aUpperLeft, aBmpEx2);
		}
	}
}

void B2dIAOAnimatedBitmapEx::CreateBaseRect()
{
	Point aUpperLeft(GetBasePositionPixel());

	if(nStartAdd % 2)
	{
		aUpperLeft.X() -= (INT32)nCenterX1;
		aUpperLeft.Y() -= (INT32)nCenterY1;
		SetBaseRect(Rectangle(aUpperLeft, aBmpEx1.GetSizePixel()));
	}
	else
	{
		aUpperLeft.X() -= (INT32)nCenterX2;
		aUpperLeft.Y() -= (INT32)nCenterY2;
		SetBaseRect(Rectangle(aUpperLeft, aBmpEx2.GetSizePixel()));
	}
}

void B2dIAOAnimatedBitmapEx::SetBitmapEx1(const BitmapEx& rNew)
{
	if(rNew != aBmpEx1)
	{
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// remember new BitmapEx
		aBmpEx1 = rNew;
	}
}

void B2dIAOAnimatedBitmapEx::SetBitmapEx2(const BitmapEx& rNew)
{
	if(rNew != aBmpEx2)
	{
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// remember new BitmapEx
		aBmpEx2 = rNew;
	}
}

void B2dIAOAnimatedBitmapEx::SetCenterXY1(UINT16 nNewX, UINT16 nNewY)
{
	if(nNewX != nCenterX1 || nNewY != nCenterY1)
	{
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// remember new values
		if(nNewX != nCenterX1)
			nCenterX1 = nNewX;
		if(nNewY != nCenterY1)
			nCenterY1 = nNewY;
	}
}

void B2dIAOAnimatedBitmapEx::SetCenterXY2(UINT16 nNewX, UINT16 nNewY)
{
	if(nNewX != nCenterX2 || nNewY != nCenterY2)
	{
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// remember new values
		if(nNewX != nCenterX2)
			nCenterX2 = nNewX;
		if(nNewY != nCenterY2)
			nCenterY2 = nNewY;
	}
}

// eof
