/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: componentclientmonitor.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 16:12:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef DBAUI_COMPONENTCLIENTMONITOR_HXX
#include "componentclientmonitor.hxx"
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

//.........................................................................
namespace dbaui
{
//.........................................................................

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;

	//=====================================================================
	//= OComponentClientMonitor
	//=====================================================================

	DBG_NAME( OComponentClientMonitor )

	//---------------------------------------------------------------------
	//--- 31.08.01 16:53:46 -----------------------------------------------

	OComponentClientMonitor::OComponentClientMonitor( const Reference< XComponent >& _rxComponent ) SAL_THROW(())
		:m_nAnonymousClients( 0 )
		,m_xComponent( _rxComponent )
	{
		DBG_CTOR( OComponentClientMonitor, NULL );

		try
		{
			DBG_ASSERT( m_xComponent.is(), "OComponentClientMonitor::OComponentClientMonitor: invalid component!" );
			if ( m_xComponent.is() )
				m_xComponent->addEventListener( this );
		}
		catch( const Exception& e )
		{
			e; // make compiler happy
			DBG_ERROR( "OComponentClientMonitor::OComponentClientMonitor: caught an exception!" );
		}
	}

	//---------------------------------------------------------------------
	//--- 31.08.01 16:54:21 -----------------------------------------------

	OComponentClientMonitor::~OComponentClientMonitor() SAL_THROW(())
	{
		DBG_DTOR( OComponentClientMonitor, NULL );
	}

	//---------------------------------------------------------------------
	//--- 31.08.01 17:14:39 -----------------------------------------------

	void OComponentClientMonitor::registerAnonymousClient() SAL_THROW(())
	{
		::osl::MutexGuard aGuard( m_aMutex );
		++m_nAnonymousClients;
	}

	//---------------------------------------------------------------------
	//--- 31.08.01 17:19:29 -----------------------------------------------

	void OComponentClientMonitor::revokeAnonymousClient()
	{
		::osl::MutexGuard aGuard( m_aMutex );
		--m_nAnonymousClients;
		clientGone( ); 
	}

	//---------------------------------------------------------------------
	//--- 31.08.01 17:01:50 -----------------------------------------------

	void OComponentClientMonitor::registerClient( const Reference< XComponent >& _rxClient ) SAL_THROW(())
	{
		::osl::MutexGuard aGuard( m_aMutex );

		DBG_ASSERT( _rxClient.is(), "OComponentClientMonitor::registerClient: invalid client (NULL)!" );
		DBG_ASSERT( m_aClients.end() == ::std::find( m_aClients.begin(), m_aClients.end(), _rxClient ),
			"OComponentClientMonitor::registerClient: already have this client!" );

		try
		{
			if ( _rxClient.is() )
			{	// remember the client
				_rxClient->addEventListener( this );
				m_aClients.push_back( _rxClient );
			}
		}
		catch( const Exception& e )
		{
			e; // make compiler happy
			DBG_ERROR( "OComponentClientMonitor::registerClient: caught an exception!" );
		}
	}

	//---------------------------------------------------------------------
	//--- 31.08.01 16:56:01 -----------------------------------------------

	void SAL_CALL OComponentClientMonitor::disposing( const EventObject& _rEvent ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex );

		try
		{
			if ( _rEvent.Source == m_xComponent )
			{
				DBG_ASSERT( m_aClients.empty(), "OComponentClientMonitor::disposing: somebody else disposed our connection!" );
					// we are the owner of the connection, and we're the only one which should be allowed to dispose it
				m_xComponent = NULL;
			}
			else
			{
				// look which of our clients is beeing disposed
				Reference< XComponent > xSource( _rEvent.Source, UNO_QUERY );
				ComponentArray::iterator aDisposedClient = ::std::find( m_aClients.begin(), m_aClients.end(), xSource );
				DBG_ASSERT( m_aClients.end() != aDisposedClient, "OComponentClientMonitor::disposing: where did this come from?" );

				if ( m_aClients.end() != aDisposedClient )
				{
					// forget about this client
					m_aClients.erase( aDisposedClient );
					clientGone( ); 
				}
			}
		}
		catch( const Exception& e )
		{
			e; // make compiler happy
			DBG_ERROR( "OComponentClientMonitor::disposing: caught an exception!" );
		}
	}

	//---------------------------------------------------------------------
	//--- 31.08.01 17:16:33 -----------------------------------------------

	void OComponentClientMonitor::clientGone( ) SAL_THROW(())
	{
		if ( ( 0 == m_nAnonymousClients ) && m_aClients.empty() )
		{
			// we can dispose the connection
			DBG_ASSERT( m_xComponent.is(), "OComponentClientMonitor::clientGone: why do we have no connection!" );

			try
			{
				m_xComponent->dispose( );
				m_xComponent.clear( );
			}
			catch( const Exception& e )
			{
				e; // make compiler happy
				DBG_ERROR( "OComponentClientMonitor::clientGone: caught an exception!" );
			}
		}
	}

//.........................................................................
}	// namespace dbaui
//.........................................................................

