/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SearchServer.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:34:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.qe;

import java.util.*;
import java.io.*;
import java.net.*;
import com.sun.xmlsearch.util.*;

public class SearchServer implements Runnable {
  
  class Searcher extends Thread {
    public void run() {
      while (true) {
	try {
	  Thread.sleep(300);
	  //	  System.out.println("check");
	  if (shuttle()) {
	    System.out.println("searching");
	    long start = System.currentTimeMillis();
	    _shuttle.startSearch();
	    System.out.println((System.currentTimeMillis()-start)
			       +" msec search");
	    _shuttle.results();
	    System.out.println((System.currentTimeMillis()-start)
			       +" msec search + results");
	  }
	}
	catch (Exception e) {
	  e.printStackTrace();
	}
      }
    }
  }

  private Thread           _responder = null;
  private int              _port = 6789;
  private ServerSocket     _listenSocket;
  private Searcher           _searcher = null;
  
  private LiteMorph _morph = LiteMorph_en.getMorph();
  private static double INFLpenalty = 0.5;
  private SearchEnvironment _env;
  private Search _search;
  private Search _shuttle;
  private int _queryCount = 0;

  public synchronized boolean shuttle() {
    if (_queryCount > 0) {
      _queryCount = 0;
      _shuttle = _search;
      _search = new Search(_env);
      return true;
    }
    else
      return false;
  }

  public SearchServer(String[] args) {
    try {
      _listenSocket = new ServerSocket(_port);
      
      _responder = new Thread(this, "SearchServer responder");
      _responder.start();
      
      _searcher = new Searcher();
      _searcher.start();

      System.out.println("SearchServer: listening on port " + _port);
      _env = new SearchEnvironment(args[0]);
      _search = new Search(_env);
    }
    catch (Exception e) {
    }
  }
  
  public synchronized int fetch(String term) throws Exception {
    return _env.fetch(term);
  }

  public synchronized String[] variantsOf(String term) {
    return _morph.variantsOf(term);
  }

  public synchronized Query registerQuery(int nColumns, int[] primary,
					  IntegerArray[] columns) {
    Query query = _search.addQuery(nColumns);
    for (int i = 0; i < nColumns; i++) {
      if (primary[i] > 0)
	_search.addTerm(i, primary[i], 0.0, _queryCount);
      for (int j = 0; j < columns[i].cardinality(); j++)
	_search.addTerm(i, columns[i].at(j), INFLpenalty, _queryCount);
    }
    _queryCount++;
    return query;
  }

  // The body of the server thread.  Loop forever, listening for and
  // accepting connections from clients.  For each connection, 
  // create a Connection object to handle communication through the
  // new Socket.
  public void run() {
    while (true)
      try {
	new QueryConnection(_listenSocket.accept(), this);
      } catch (IOException e) {
	System.err.println(e);
      }
  }
  
  // Start the server up, listening on an optionally specified port
  public static void main(String[] args) {
    new SearchServer(args);
  }
}

// This class is the thread that handles all communication with a client
class QueryConnection extends Thread {
  protected Socket              _client;
  protected LineInput           _in;
  protected PrintStream         _out;
  private SearchServer _server;

  // Initialize the streams and start the thread
  public QueryConnection(Socket clientSocket, SearchServer svr) { 
    _client = clientSocket;
    _server = svr;
    try { 
      _in = new LineInput(_client.getInputStream());
      _out = new PrintStream(_client.getOutputStream());
    }
    catch (IOException e) {
      try {
	_client.close();
      }
      catch (IOException e2) { ; }
      System.err.println("Exception while getting socket streams: " + e);
      return;
    }
    start();
  }
    
  private void processQuery(String queryLine, int nHits) throws Exception {
    StringTokenizer terms = new StringTokenizer(queryLine);
    int nTerms = terms.countTokens();
    IntegerArray[] columns = new IntegerArray[nTerms];
    int[] primary = new int[nTerms];
    int nValidTerms = 0;
    while (terms.hasMoreTokens()) {
      String term = terms.nextToken().toLowerCase();
      String[] variants = _server.variantsOf(term);
      int id = _server.fetch(term);
      IntegerArray ids = new IntegerArray();
      StringTokenizer forms = new StringTokenizer(term);
      for (int i = 0; i < variants.length; i++) {
	int formID = _server.fetch(variants[i]);
	if (formID > 0 && formID != id)
	  ids.add(formID);
      }
      if (ids.cardinality() > 0 || id > 0) {
	columns[nValidTerms] = ids;
	primary[nValidTerms] = id;
	nValidTerms++;
      }
    }
    Query query = _server.registerQuery(nValidTerms, primary, columns);
    synchronized (query) {
      query.wait();
    }
    query.printHits(_out, nHits);
  }

  public void run() {
    try {
      String query = _in.readLine();
      System.out.println("QS: " + query);
      processQuery(query, 50);
      _out.println("**END**");
      _out.flush();
    }
    catch (Exception e) {
      System.err.println(e);
    }
    finally {
      try {
	_client.close();
	System.out.println("client closed");
      }
      catch (IOException e2) {
	System.err.println(e2 + "error closing client socket");
      }
    }
  }
}
