#
#  ATSchemaEditorNG TestCase
#

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from ZPublisher.HTTPRequest import record

from atse_testcase import ATSETestCase
from Products.Archetypes.public import StringField, StringWidget

class NewStringWidget(StringWidget):
    pass

class TestSchemaEditor(ATSETestCase):

    def afterSetUp(self):
        self.installDependencies()
        self.createBasicSetup()

    def test_addField(self):
        original_schema = self.target1.Schema().copy()
        name = 'addedField'
        self.failIf(original_schema.has_key(name))

        self.container.atse_addField(self.target1.portal_type, 'default', '' , name)
        # updating all portal_types
        self.container.atse_updateManagedSchema(self.target1.portal_type, '')
        new_schema = self.target1.Schema()
        self.failUnless(new_schema.has_key(name))
        
    def test_updateObjectSchema(self):
        original_schema = self.target1.Schema().copy()
        name = 'additionalField'
        # deleting
        self.container.atse_delField(self.target1.portal_type, '' , name)
        # updating all portal_types
        self.container.atse_updateManagedSchema(self.target1.portal_type, '')
        new_schema = self.target1.Schema()
        self.assertNotEqual([x.getName() for x in original_schema.fields()], [x.getName() for x in new_schema.fields()])

    def test_registerWidget(self):
        self.container.atse_registerWidget('NewStringWidget', NewStringWidget(),
                                           visible=True)
        widget_info = self.container.atse_getWidgetInfo()
        right_widget_data = ('NewStringWidget', {'widget':NewStringWidget(),
                                                 'visible':True})
        last_widget_data = widget_info[-1]
        self.assertEqual(last_widget_data[0], right_widget_data[0])
        self.assertEqual(last_widget_data[1]['visible'],
                         right_widget_data[1]['visible'])
        self.assertEqual(last_widget_data[1]['widget'].__class__,
                         right_widget_data[1]['widget'].__class__)
        
        widget_map = self.container.atse_getWidgetMap()
        self.failUnless(widget_map.has_key(right_widget_data[0]))
        self.assertEqual(widget_map, dict(widget_info))

    def test_registerField(self):
        new_field_type_name = 'NewStringField'
        self.container.atse_registerFieldType(new_field_type_name)
        field_types = self.container.atse_getFieldTypes()
        self.failUnless(new_field_type_name in field_types)

    def test_referenceField(self):
        name = 'refField'
        self.container.atse_addField(self.target1.portal_type, 'default', '', name)

        field_data = {'type': 'ReferenceField',
                      'schemata': 'default', 'name': name,
                      'widget': 'ReferenceBrowserWidget',
                      'label': 'refField', 'storage': 'Attribute',
                      'relationship': 'testRelation'}
        fd = record()
        for key, value in field_data.items():
            setattr(fd, key, value)
        self.container.atse_update(self.target1.portal_type, '', fd,
                                   self.container.REQUEST)
        
        self.container.atse_updateManagedSchema(self.target1.portal_type, '')
        self.target1.addReference(self.target2, relationship='testRelation')
        field = self.target1.getField(name)
        self.failUnless(field.getAccessor(self.target1)() == self.target2)
        self.failUnless(field.getEditAccessor(self.target1)() == \
                        self.target2.UID())


def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    suite.addTest(makeSuite(TestSchemaEditor))
    return suite

if __name__ == '__main__':
    framework()
