module Schleuder

  class Utils
    def self.random_password(size = 32)
      chars = (('a'..'z').to_a + ('A'..'Z').to_a + ('0'..'9').to_a) + "+*%/()=?![]{}-_.,;:<>".split(//)
      Utils.generate_random_str(size,chars)
    end
    def self.generate_random_str(size=32,chars = nil)
      chars = (('a'..'z').to_a + ('A'..'Z').to_a + ('0'..'9').to_a) if chars.nil?
      (1..size).collect{|a| chars[rand(chars.size)] }.join.to_s
    end

    def self.verify_addr(name, address)
      begin
        testaddr = TMail::Address.parse(address).address
      rescue TMail::SyntaxError
        testaddr = 'TMail::SyntaxError'
      rescue TypeError
        testaddr = 'TypeError'
      end
      unless testaddr == address
        raise "Invalid #{name}: #{address}"
      end
    end

    def self.get_pretty_fingerprint(key)
      "No such key!" if key.nil?
      key.subkeys.first.fingerprint.gsub(/(.{4})/, "\\1 ").strip
    end

    def self.generate_message_id(listname='')
      listname = listname + '-' unless listname.empty?
      '<'+Utils.generate_random_str+"@#{listname}schleuder>"
    end

    def self.schleuder_id?(message_id,listname='')
      return false unless message_id
      listname = listname + '-' unless listname.empty?
      /<\w*@#{Regexp.quote(listname)}schleuder>/ === message_id
    end
  end
end

class Symbol
  include Comparable

  def <=>(other)
    self.to_s <=> other.to_s
  end
end

class Hash
  # Replacing the to_yaml function so it'll serialize hashes sorted (by their keys)
  #
  # Original function is in /usr/lib/ruby/1.8/yaml/rubytypes.rb
  def to_yaml( opts = {} )
    YAML::quick_emit( object_id, opts ) do |out|
      out.map( taguri, to_yaml_style ) do |map|
        sort.each do |k, v|   # <-- here's my addition (the 'sort')
          map.add( k, v )
        end
      end
    end
  end
end
