/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "jobview.h"
#include "kbanking.h"
#include "timport.h"
#include <aqbanking/jobgetbalance.h>
#include <aqbanking/jobgettransactions.h>
#include <aqbanking/jobsingletransfer.h>
#include <aqbanking/jobsingledebitnote.h>
#include <aqbanking/jobeutransfer.h>

#include <qevent.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qmessagebox.h>
#include <qlayout.h>

#include <gwenhywfar/debug.h>



#define BUTTON_WIDTH 110


JobView::JobView(KBanking *kb,
                 QWidget* parent,
                 const char* name,
                 WFlags fl)
:JobViewUi(parent, name, fl), _app(kb) {
  assert(kb);

  // Manually create and add layout here because the .ui-generated
  // QGroupBox doesn't have one.
  jobBox->setColumnLayout(0, Qt::Vertical );
  QBoxLayout *jobBoxLayout = new QHBoxLayout( jobBox->layout() );
  jobBoxLayout->setAlignment( Qt::AlignTop );

  _jobList=new QBJobListView(jobBox, name);
  _jobList->setSelectionMode(QListView::Extended);
  jobBoxLayout->addWidget(_jobList);

  QObject::connect(_app->flagStaff(), SIGNAL(signalQueueUpdated()),
                   this, SLOT(slotQueueUpdated()));
  QObject::connect(executeButton, SIGNAL(clicked()),
                   this, SLOT(slotExecute()));
  QObject::connect(dequeueButton, SIGNAL(clicked()),
                   this, SLOT(slotDequeue()));

}



JobView::~JobView(){
}


bool JobView::init(){
  GWEN_DB_NODE *dbConfig=NULL;
  int rv;

  rv=_app->loadAppSubConfig("gui/views/jobview", &dbConfig);
  if (rv<0) {
    DBG_INFO(0, "here (%d)", rv);
  }
  else {
    int i, j;

    /* found settings */
    for (i=0; i<_jobList->columns(); i++) {
      _jobList->setColumnWidthMode(i, QListView::Manual);
      j=GWEN_DB_GetIntValue(dbConfig, "columns", i, -1);
      if (j!=-1)
	_jobList->setColumnWidth(i, j);
    } /* for */
    GWEN_DB_Group_free(dbConfig);
  } /* if settings */

  _jobList->addJobs(_app->getEnqueuedJobs());
  _app->outboxCountChanged(_jobList->childCount());

  return true;
}



bool JobView::fini(){
  GWEN_DB_NODE *dbConfig;
  int rv;
  int i, j;

  dbConfig=GWEN_DB_Group_new("config");
  assert(dbConfig);

  for (i=0; i<_jobList->columns(); i++) {
    j=_jobList->columnWidth(i);
    GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_DEFAULT,
			"columns", j);
  } /* for */

  rv=_app->saveAppSubConfig("gui/views/jobview", dbConfig);
  GWEN_DB_Group_free(dbConfig);
  if (rv<0) {
    DBG_INFO(0, "here (%d)", rv);
    return false;
  }

  return true;
}


void JobView::slotQueueUpdated(){
  DBG_DEBUG(0, "Job queue updated");
  _jobList->clear();
  _jobList->addJobs(_app->getEnqueuedJobs());
  _app->outboxCountChanged(_jobList->childCount());
}



void JobView::slotExecute(){
  std::list<AB_JOB*> jl;
  std::list<AB_JOB*>::iterator jit;
  int rv;
  bool updated;
  AB_IMEXPORTER_CONTEXT *ctx;
  QBGui *gui;

  updated=false;
  _app->nextSession();
  jl=_app->getEnqueuedJobs();
  if (jl.size()==0) {
    QMessageBox::warning(this,
                         tr("No Jobs"),
                         tr("There are no jobs in the queue."),
                         tr("Dismiss"), QString::null);
    return;
  }

  DBG_INFO(0, "Executing queue");
  /* clear password DB */
  GWEN_Gui_SetPasswordStatus(NULL, NULL, GWEN_Gui_PasswordStatus_Remove, 0);

  ctx=AB_ImExporterContext_new();
  gui=_app->getGui();
  if (gui)
    gui->pushParentWidget(this);
  rv=_app->executeQueue(ctx);
  if (gui)
    gui->popParentWidget();
  if (rv) {
    DBG_NOTICE(0, "Error %d", rv);
  }

  /* handle results of all jobs */
  if (!rv) {
    AB_IMEXPORTER_ACCOUNTINFO *ai;
  
    ai=AB_ImExporterContext_GetFirstAccountInfo(ctx);
    while(ai) {
      Account *a;

      a=_app->findAccount(AB_ImExporterAccountInfo_GetBankCode(ai),
                          AB_ImExporterAccountInfo_GetAccountNumber(ai));
      if (a) {
	if (1) { /* TODO */
	  DBG_DEBUG(0, "Clearing standing orders for account %s / %s",
		    a->getBankCode().c_str(),
		    a->getAccountNumber().c_str());
	  a->clearStandingOrders();
	}
	else {
          DBG_DEBUG(0, "Not clearing standing orders for account %s / %s",
                    a->getBankCode().c_str(),
                    a->getAccountNumber().c_str());
        }
	if (1) { /* TODO */
	  DBG_DEBUG(0, "Clearing standing orders for account %s / %s",
		    a->getBankCode().c_str(),
		    a->getAccountNumber().c_str());
	  a->clearDatedTransfers();
	}
	else {
	  DBG_DEBUG(0, "Not clearing standing orders for account %s / %s",
		    a->getBankCode().c_str(),
		    a->getAccountNumber().c_str());
	}
      }
      ai=AB_ImExporterContext_GetNextAccountInfo(ctx);
    } /* while */

    _app->importContext(ctx,
                        TRANSACTION_IMPORTER_FLAGS_COMPLETE_DAYS /*|
                        TRANSACTION_IMPORTER_FLAGS_OVERWRITE_DAYS */);
  }
  AB_ImExporterContext_free(ctx);
}



void JobView::slotDequeue(){
  std::list<AB_JOB*> jl;
  std::list<AB_JOB*>::iterator jit;
  bool foundTransferJob=FALSE;

  jl=_jobList->getSelectedJobs();
  if (jl.empty()) {
    DBG_DEBUG(0, "No job selected");
    QMessageBox::warning(this,
			 tr("No Selection"),
                         tr("Please select a job first."),
			 tr("Dismiss"), QString::null);
    return;
  }

  int res = QMessageBox::warning(this,
			   tr("Delete job"),
			   tr("Do you really want to delete the "
			      "selected job(s)?"),
			   QMessageBox::Yes,QMessageBox::No);
  if (res != 0 && res != QMessageBox::Yes)
    return;

  for (jit=jl.begin(); jit!=jl.end(); jit++) {
    int rv;
    AB_JOB *j;
    const AB_TRANSACTION *t=NULL;

    j=*jit;
    switch(AB_Job_GetType(j)) {
    case AB_Job_TypeTransfer:
      t=AB_JobSingleTransfer_GetTransaction(j);
      break;
    case AB_Job_TypeDebitNote:
      t=AB_JobSingleDebitNote_GetTransaction(j);
      break;
    case AB_Job_TypeEuTransfer:
      t=AB_JobEuTransfer_GetTransaction(j);
      break;
    default:
      break;
    }

    if (t) {
      RefPointer<Transfer> rt;

      rt=_app->findTransferByJobId(AB_Job_GetJobId(j));
      if (rt.isValid()) {
	rt.ref().setStatus(Transfer::StatusAborted);
        foundTransferJob=TRUE;
      }
      else {
	DBG_ERROR(0, "Transaction %08x not found",
		  AB_Job_GetJobId(j));
      }
    }
    else {
      DBG_ERROR(0, "No transaction in this job, ignoring");
    }

    rv=_app->dequeueJob(j);
    if (rv) {
      DBG_ERROR(0, "Error dequeing job (%d)", rv);
    }
  } // for

  slotQueueUpdated();
  if (foundTransferJob)
    _app->transfersUpdated();
}









