/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ChXChartAxis.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 11:37:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _CHXCHART_AXIS_HXX
#define _CHXCHART_AXIS_HXX

// header for SvNumberFormatsSupplierObj
#ifndef _NUMUNO_HXX
#include <svtools/numuno.hxx>
#endif

#ifndef _COM_SUN_STAR_UTIL_XNUMBERFORMATSSUPPLIER_HPP_
#include <com/sun/star/util/XNumberFormatsSupplier.hpp>
#endif

#include "ChXChartObject.hxx"
namespace binfilter {

class ChXChartAxis :
	public ::com::sun::star::util::XNumberFormatsSupplier,
	public ChXChartObject
{
private:
	::com::sun::star::uno::Reference<
		::com::sun::star::util::XNumberFormatsSupplier >	rNumberFormatter;

	::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > maTypeSequence;

public:
	ChXChartAxis( ChartModel* _Model, long _WhichId );
	virtual ~ChXChartAxis();

	virtual void InitNumberFormatter() throw( ::com::sun::star::uno::RuntimeException );

	static const ::com::sun::star::uno::Sequence< sal_Int8 > & getUnoTunnelId() throw();
	static ChXChartAxis* getImplementation( ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface > ) throw();

	// XServiceInfo
	virtual ::rtl::OUString SAL_CALL getImplementationName() throw( ::com::sun::star::uno::RuntimeException );
	virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames() throw( ::com::sun::star::uno::RuntimeException );

	// XNumberFormatsSupplier
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > SAL_CALL getNumberFormatSettings()
		throw( ::com::sun::star::uno::RuntimeException );
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::util::XNumberFormats > SAL_CALL getNumberFormats()
		throw( ::com::sun::star::uno::RuntimeException );

	// XPropertySet
	virtual void SAL_CALL setPropertyValue( const ::rtl::OUString& aPropertyName,
											const ::com::sun::star::uno::Any& aValue )
		throw( ::com::sun::star::beans::UnknownPropertyException,
			   ::com::sun::star::beans::PropertyVetoException,
			   ::com::sun::star::lang::IllegalArgumentException,
			   ::com::sun::star::lang::WrappedTargetException,
			   ::com::sun::star::uno::RuntimeException );
	virtual ::com::sun::star::uno::Any SAL_CALL getPropertyValue( const ::rtl::OUString& PropertyName )
		throw( ::com::sun::star::beans::UnknownPropertyException,
			   ::com::sun::star::lang::WrappedTargetException,
			   ::com::sun::star::uno::RuntimeException );

	// XInterface
	virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( const ::com::sun::star::uno::Type & rType )
		throw ( ::com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL acquire() throw();
	virtual void SAL_CALL release() throw();

	// XTypeProvider
	virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > SAL_CALL getTypes()
		throw( ::com::sun::star::uno::RuntimeException );
    virtual ::com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL getImplementationId()
		throw( ::com::sun::star::uno::RuntimeException );

	// XShapeDescriptor
    virtual ::rtl::OUString SAL_CALL getShapeType() throw( ::com::sun::star::uno::RuntimeException );

	// XUnoTunnel
    virtual sal_Int64 SAL_CALL getSomething( const ::com::sun::star::uno::Sequence< sal_Int8 >& aIdentifier )
		throw( ::com::sun::star::uno::RuntimeException );
		
	//	ChXChartObject::XMultiPropertySet
	virtual void SAL_CALL setPropertyValues	(
				const ::com::sun::star::uno::Sequence< ::rtl::OUString >& aPropertyNames,
				const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& aValues ) 
		throw (	::com::sun::star::beans::PropertyVetoException,
				::com::sun::star::lang::IllegalArgumentException,
				::com::sun::star::lang::WrappedTargetException,
				::com::sun::star::uno::RuntimeException);

protected:
	/**	@descr	Creates an item set with a which range specific to chart axes.
		@return	Returns a pointer to an item set.  The caller is responsible for deleting it.
	*/				
	virtual	SfxItemSet * CreateItemSet	(void);
	
	/**	@descr	Handle the axis special cases and call the base class method for all other.
			See there for further documentation.
		@see	ChxChartObject::GetPropertyValue.
	*/
	virtual	void	GetPropertyValue	(const SfxItemPropertyMap & rProperty,
										::com::sun::star::uno::Any & rValue, 
										SfxItemSet & rAttributes);
};

} //namespace binfilter
#endif	// _CHXCHART_AXIS_HXX

