/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: emptyproperties.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: hr $ $Date: 2007/06/27 18:52:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#ifndef _SDR_PROPERTIES_EMPTYPROPERTIES_HXX
#include <svx/sdr/properties/emptyproperties.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif

#ifndef _SVDDEF_HXX
#include <svx/svddef.hxx>
#endif

#ifndef _SVDOBJ_HXX
#include <svx/svdobj.hxx>
#endif

#ifndef _SVDPOOL_HXX
#include <svx/svdpool.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		// create a new itemset
		SfxItemSet& EmptyProperties::CreateObjectSpecificItemSet(SfxItemPool& rPool)
		{
			// Basic implementation; Basic object has NO attributes
			DBG_ASSERT(sal_False, "EmptyProperties::CreateObjectSpecificItemSet() should never be called");
			return *(new SfxItemSet(rPool));
		}

		EmptyProperties::EmptyProperties(SdrObject& rObj)
		:	BaseProperties(rObj),
			mpEmptyItemSet(0L)
		{
		}

		EmptyProperties::EmptyProperties(const EmptyProperties& rProps, SdrObject& rObj)
		:	BaseProperties(rProps, rObj),
			mpEmptyItemSet(0L)
		{
			// #115593#
			// do not gererate an assert, else derivations like PageProperties will generate an assert
			// using the Clone() operator path.
		}

		EmptyProperties::~EmptyProperties()
		{
			if(mpEmptyItemSet)
			{
				delete mpEmptyItemSet;
				mpEmptyItemSet = 0L;
			}
		}
		
		BaseProperties& EmptyProperties::Clone(SdrObject& rObj) const
		{
			return *(new EmptyProperties(*this, rObj));
		}

		const SfxItemSet& EmptyProperties::GetObjectItemSet() const
		{
			if(!mpEmptyItemSet)
			{
				((EmptyProperties*)this)->mpEmptyItemSet = &(((EmptyProperties*)this)->CreateObjectSpecificItemSet(*GetSdrObject().GetObjectItemPool()));
			}

			DBG_ASSERT(mpEmptyItemSet, "Could not create an SfxItemSet(!)");
			DBG_ASSERT(sal_False, "EmptyProperties::GetObjectItemSet() should never be called (!)");

			return *mpEmptyItemSet;
		}

		void EmptyProperties::SetObjectItem(const SfxPoolItem& /*rItem*/)
		{
			DBG_ASSERT(sal_False, "EmptyProperties::SetObjectItem() should never be called (!)");
		}

		void EmptyProperties::SetObjectItemDirect(const SfxPoolItem& /*rItem*/)
		{
			DBG_ASSERT(sal_False, "EmptyProperties::SetObjectItemDirect() should never be called (!)");
		}

		void EmptyProperties::ClearObjectItem(const sal_uInt16 /*nWhich*/)
		{
			DBG_ASSERT(sal_False, "EmptyProperties::ClearObjectItem() should never be called (!)");
		}

		void EmptyProperties::ClearObjectItemDirect(const sal_uInt16 /*nWhich*/)
		{
			DBG_ASSERT(sal_False, "EmptyProperties::ClearObjectItemDirect() should never be called (!)");
		}

		void EmptyProperties::SetObjectItemSet(const SfxItemSet& /*rSet*/)
		{
			DBG_ASSERT(sal_False, "EmptyProperties::SetObjectItemSet() should never be called (!)");
		}

		void EmptyProperties::ItemSetChanged(const SfxItemSet& /*rSet*/)
		{
			DBG_ASSERT(sal_False, "EmptyProperties::ItemSetChanged() should never be called (!)");
		}

		sal_Bool EmptyProperties::AllowItemChange(const sal_uInt16 /*nWhich*/, const SfxPoolItem* /*pNewItem*/) const
		{
			DBG_ASSERT(sal_False, "EmptyProperties::AllowItemChange() should never be called (!)");
			return sal_True;
		}

		void EmptyProperties::ItemChange(const sal_uInt16 /*nWhich*/, const SfxPoolItem* /*pNewItem*/)
		{
			DBG_ASSERT(sal_False, "EmptyProperties::ItemChange() should never be called (!)");
		}

		void EmptyProperties::PostItemChange(const sal_uInt16 /*nWhich*/)
		{
			DBG_ASSERT(sal_False, "EmptyProperties::PostItemChange() should never be called (!)");
		}

		void EmptyProperties::SetStyleSheet(SfxStyleSheet* /*pNewStyleSheet*/, sal_Bool /*bDontRemoveHardAttr*/)
		{
			DBG_ASSERT(sal_False, "EmptyProperties::SetStyleSheet() should never be called (!)");
		}

		SfxStyleSheet* EmptyProperties::GetStyleSheet() const
		{
			DBG_ASSERT(sal_False, "EmptyProperties::GetStyleSheet() should never be called (!)");
			return 0L;
		}
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
