-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.0.27-standard


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema sakila
--

CREATE DATABASE IF NOT EXISTS sakila;
USE sakila;
DROP TABLE IF EXISTS `film_list`;
DROP VIEW IF EXISTS `film_list`;
CREATE TABLE `film_list` (
  `FID` smallint(5) unsigned,
  `title` varchar(255),
  `description` text,
  `category` varchar(25),
  `price` decimal(4,2),
  `length` smallint(5) unsigned,
  `rating` enum('G','PG','PG-13','R','NC-17'),
  `actors` varchar(341)
);
DROP TABLE IF EXISTS `actor_info`;
DROP VIEW IF EXISTS `actor_info`;
CREATE TABLE `actor_info` (
  `actor_id` smallint(5) unsigned,
  `first_name` varchar(45),
  `last_name` varchar(45),
  `film_info` varchar(341)
);
DROP TABLE IF EXISTS `sales_by_store`;
DROP VIEW IF EXISTS `sales_by_store`;
CREATE TABLE `sales_by_store` (
  `store` varchar(101),
  `manager` varchar(91),
  `total_sales` decimal(27,2)
);

DROP TABLE IF EXISTS `actor`;
CREATE TABLE `actor` (
  `actor_id` smallint(5) unsigned NOT NULL auto_increment,
  `first_name` varchar(45) NOT NULL,
  `last_name` varchar(45) NOT NULL,
  `last_update` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`actor_id`),
  KEY `idx_actor_last_name` (`last_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `actor` VALUES   (1,'PENELOPE','GUINESS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (2,'NICK','WAHLBERG','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (3,'ED','CHASE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (4,'JENNIFER','DAVIS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (5,'JOHNNY','LOLLOBRIGIDA','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (6,'BETTE','NICHOLSON','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (7,'GRACE','MOSTEL','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (8,'MATTHEW','JOHANSSON','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (9,'JOE','SWANK','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (10,'CHRISTIAN','GABLE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (11,'ZERO','CAGE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (12,'KARL','BERRY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (13,'UMA','WOOD','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (14,'VIVIEN','BERGEN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (15,'CUBA','OLIVIER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (16,'FRED','COSTNER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (17,'HELEN','VOIGHT','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (18,'DAN','TORN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (19,'BOB','FAWCETT','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (20,'LUCILLE','TRACY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (21,'KIRSTEN','PALTROW','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (22,'ELVIS','MARX','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (23,'SANDRA','KILMER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (24,'CAMERON','STREEP','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (25,'KEVIN','BLOOM','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (26,'RIP','CRAWFORD','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (27,'JULIA','MCQUEEN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (28,'WOODY','HOFFMAN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (29,'ALEC','WAYNE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (30,'SANDRA','PECK','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (31,'SISSY','SOBIESKI','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (32,'TIM','HACKMAN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (33,'MILLA','PECK','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (34,'AUDREY','OLIVIER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (35,'JUDY','DEAN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (36,'BURT','DUKAKIS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (37,'VAL','BOLGER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (38,'TOM','MCKELLEN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (39,'GOLDIE','BRODY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (40,'JOHNNY','CAGE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (41,'JODIE','DEGENERES','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (42,'TOM','MIRANDA','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (43,'KIRK','JOVOVICH','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (44,'NICK','STALLONE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (45,'REESE','KILMER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (46,'PARKER','GOLDBERG','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (47,'JULIA','BARRYMORE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (48,'FRANCES','DAY-LEWIS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (49,'ANNE','CRONYN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (50,'NATALIE','HOPKINS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (51,'GARY','PHOENIX','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (52,'CARMEN','HUNT','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (53,'MENA','TEMPLE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (54,'PENELOPE','PINKETT','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (55,'FAY','KILMER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (56,'DAN','HARRIS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (57,'JUDE','CRUISE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (58,'CHRISTIAN','AKROYD','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (59,'DUSTIN','TAUTOU','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (60,'HENRY','BERRY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (61,'CHRISTIAN','NEESON','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (62,'JAYNE','NEESON','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (63,'CAMERON','WRAY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (64,'RAY','JOHANSSON','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (65,'ANGELA','HUDSON','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (66,'MARY','TANDY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (67,'JESSICA','BAILEY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (68,'RIP','WINSLET','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (69,'KENNETH','PALTROW','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (70,'MICHELLE','MCCONAUGHEY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (71,'ADAM','GRANT','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (72,'SEAN','WILLIAMS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (73,'GARY','PENN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (74,'MILLA','KEITEL','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (75,'BURT','POSEY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (76,'ANGELINA','ASTAIRE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (77,'CARY','MCCONAUGHEY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (78,'GROUCHO','SINATRA','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (79,'MAE','HOFFMAN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (80,'RALPH','CRUZ','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (81,'SCARLETT','DAMON','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (82,'WOODY','JOLIE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (83,'BEN','WILLIS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (84,'JAMES','PITT','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (85,'MINNIE','ZELLWEGER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (86,'GREG','CHAPLIN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (87,'SPENCER','PECK','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (88,'KENNETH','PESCI','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (89,'CHARLIZE','DENCH','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (90,'SEAN','GUINESS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (91,'CHRISTOPHER','BERRY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (92,'KIRSTEN','AKROYD','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (93,'ELLEN','PRESLEY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (94,'KENNETH','TORN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (95,'DARYL','WAHLBERG','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (96,'GENE','WILLIS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (97,'MEG','HAWKE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (98,'CHRIS','BRIDGES','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (99,'JIM','MOSTEL','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (100,'SPENCER','DEPP','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (101,'SUSAN','DAVIS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (102,'WALTER','TORN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (103,'MATTHEW','LEIGH','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (104,'PENELOPE','CRONYN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (105,'SIDNEY','CROWE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (106,'GROUCHO','DUNST','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (107,'GINA','DEGENERES','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (108,'WARREN','NOLTE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (109,'SYLVESTER','DERN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (110,'SUSAN','DAVIS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (111,'CAMERON','ZELLWEGER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (112,'RUSSELL','BACALL','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (113,'MORGAN','HOPKINS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (114,'MORGAN','MCDORMAND','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (115,'HARRISON','BALE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (116,'DAN','STREEP','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (117,'RENEE','TRACY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (118,'CUBA','ALLEN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (119,'WARREN','JACKMAN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (120,'PENELOPE','MONROE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (121,'LIZA','BERGMAN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (122,'SALMA','NOLTE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (123,'JULIANNE','DENCH','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (124,'SCARLETT','BENING','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (125,'ALBERT','NOLTE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (126,'FRANCES','TOMEI','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (127,'KEVIN','GARLAND','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (128,'CATE','MCQUEEN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (129,'DARYL','CRAWFORD','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (130,'GRETA','KEITEL','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (131,'JANE','JACKMAN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (132,'ADAM','HOPPER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (133,'RICHARD','PENN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (134,'GENE','HOPKINS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (135,'RITA','REYNOLDS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (136,'ED','MANSFIELD','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (137,'MORGAN','WILLIAMS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (138,'LUCILLE','DEE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (139,'EWAN','GOODING','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (140,'WHOOPI','HURT','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (141,'CATE','HARRIS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (142,'JADA','RYDER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (143,'RIVER','DEAN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (144,'ANGELA','WITHERSPOON','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (145,'KIM','ALLEN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (146,'ALBERT','JOHANSSON','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (147,'FAY','WINSLET','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (148,'EMILY','DEE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (149,'RUSSELL','TEMPLE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (150,'JAYNE','NOLTE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (151,'GEOFFREY','HESTON','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (152,'BEN','HARRIS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (153,'MINNIE','KILMER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (154,'MERYL','GIBSON','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (155,'IAN','TANDY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (156,'FAY','WOOD','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (157,'GRETA','MALDEN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (158,'VIVIEN','BASINGER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (159,'LAURA','BRODY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (160,'CHRIS','DEPP','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (161,'HARVEY','HOPE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (162,'OPRAH','KILMER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (163,'CHRISTOPHER','WEST','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (164,'HUMPHREY','WILLIS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (165,'AL','GARLAND','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (166,'NICK','DEGENERES','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (167,'LAURENCE','BULLOCK','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (168,'WILL','WILSON','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (169,'KENNETH','HOFFMAN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (170,'MENA','HOPPER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (171,'OLYMPIA','PFEIFFER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (172,'GROUCHO','WILLIAMS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (173,'ALAN','DREYFUSS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (174,'MICHAEL','BENING','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (175,'WILLIAM','HACKMAN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (176,'JON','CHASE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (177,'GENE','MCKELLEN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (178,'LISA','MONROE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (179,'ED','GUINESS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (180,'JEFF','SILVERSTONE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (181,'MATTHEW','CARREY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (182,'DEBBIE','AKROYD','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (183,'RUSSELL','CLOSE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (184,'HUMPHREY','GARLAND','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (185,'MICHAEL','BOLGER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (186,'JULIA','ZELLWEGER','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (187,'RENEE','BALL','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (188,'ROCK','DUKAKIS','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (189,'CUBA','BIRCH','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (190,'AUDREY','BAILEY','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (191,'GREGORY','GOODING','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (192,'JOHN','SUVARI','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (193,'BURT','TEMPLE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (194,'MERYL','ALLEN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (195,'JAYNE','SILVERSTONE','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (196,'BELA','WALKEN','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (197,'REESE','WEST','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (198,'MARY','KEITEL','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (199,'JULIA','FAWCETT','2006-02-15 04:34:33');
INSERT INTO `actor` VALUES   (200,'THORA','TEMPLE','2006-02-15 04:34:33');

DROP TABLE IF EXISTS `film`;
CREATE TABLE `film` (
  `film_id` smallint(5) unsigned NOT NULL auto_increment,
  `title` varchar(255) NOT NULL,
  `description` text,
  `release_year` year(4) default NULL,
  `language_id` tinyint(3) unsigned NOT NULL,
  `original_language_id` tinyint(3) unsigned default NULL,
  `rental_duration` tinyint(3) unsigned NOT NULL default '3',
  `rental_rate` decimal(4,2) NOT NULL default '4.99',
  `length` smallint(5) unsigned default NULL,
  `replacement_cost` decimal(5,2) NOT NULL default '19.99',
  `rating` enum('G','PG','PG-13','R','NC-17') default 'G',
  `special_features` set('Trailers','Commentaries','Deleted Scenes','Behind the Scenes') default NULL,
  `last_update` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`film_id`),
  KEY `idx_title` (`title`),
  KEY `idx_fk_language_id` (`language_id`),
  KEY `idx_fk_original_language_id` (`original_language_id`),
  CONSTRAINT `fk_film_language` FOREIGN KEY (`language_id`) REFERENCES `language` (`language_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_film_language_original` FOREIGN KEY (`original_language_id`) REFERENCES `language` (`language_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `film` VALUES   (1,'ACADEMY DINOSAUR','A Epic Drama of a Feminist And a Mad Scientist who must Battle a Teacher in The Canadian Rockies',2006,1,NULL,6,'0.99',86,'20.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (2,'ACE GOLDFINGER','A Astounding Epistle of a Database Administrator And a Explorer who must Find a Car in Ancient China',2006,1,NULL,3,'4.99',48,'12.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (3,'ADAPTATION HOLES','A Astounding Reflection of a Lumberjack And a Car who must Sink a Lumberjack in A Baloon Factory',2006,1,NULL,7,'2.99',50,'18.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (4,'AFFAIR PREJUDICE','A Fanciful Documentary of a Frisbee And a Lumberjack who must Chase a Monkey in A Shark Tank',2006,1,NULL,5,'2.99',117,'26.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (5,'AFRICAN EGG','A Fast-Paced Documentary of a Pastry Chef And a Dentist who must Pursue a Forensic Psychologist in The Gulf of Mexico',2006,1,NULL,6,'2.99',130,'22.99','G','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (6,'AGENT TRUMAN','A Intrepid Panorama of a Robot And a Boy who must Escape a Sumo Wrestler in Ancient China',2006,1,NULL,3,'2.99',169,'17.99','PG','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (7,'AIRPLANE SIERRA','A Touching Saga of a Hunter And a Butler who must Discover a Butler in A Jet Boat',2006,1,NULL,6,'4.99',62,'28.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (8,'AIRPORT POLLOCK','A Epic Tale of a Moose And a Girl who must Confront a Monkey in Ancient India',2006,1,NULL,6,'4.99',54,'15.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (9,'ALABAMA DEVIL','A Thoughtful Panorama of a Database Administrator And a Mad Scientist who must Outgun a Mad Scientist in A Jet Boat',2006,1,NULL,3,'2.99',114,'21.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (10,'ALADDIN CALENDAR','A Action-Packed Tale of a Man And a Lumberjack who must Reach a Feminist in Ancient China',2006,1,NULL,6,'4.99',63,'24.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (11,'ALAMO VIDEOTAPE','A Boring Epistle of a Butler And a Cat who must Fight a Pastry Chef in A MySQL Convention',2006,1,NULL,6,'0.99',126,'16.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (12,'ALASKA PHANTOM','A Fanciful Saga of a Hunter And a Pastry Chef who must Vanquish a Boy in Australia',2006,1,NULL,6,'0.99',136,'22.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (13,'ALI FOREVER','A Action-Packed Drama of a Dentist And a Crocodile who must Battle a Feminist in The Canadian Rockies',2006,1,NULL,4,'4.99',150,'21.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (14,'ALICE FANTASIA','A Emotional Drama of a A Shark And a Database Administrator who must Vanquish a Pioneer in Soviet Georgia',2006,1,NULL,6,'0.99',94,'23.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (15,'ALIEN CENTER','A Brilliant Drama of a Cat And a Mad Scientist who must Battle a Feminist in A MySQL Convention',2006,1,NULL,5,'2.99',46,'10.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (16,'ALLEY EVOLUTION','A Fast-Paced Drama of a Robot And a Composer who must Battle a Astronaut in New Orleans',2006,1,NULL,6,'2.99',180,'23.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (17,'ALONE TRIP','A Fast-Paced Character Study of a Composer And a Dog who must Outgun a Boat in An Abandoned Fun House',2006,1,NULL,3,'0.99',82,'14.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (18,'ALTER VICTORY','A Thoughtful Drama of a Composer And a Feminist who must Meet a Secret Agent in The Canadian Rockies',2006,1,NULL,6,'0.99',57,'27.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (19,'AMADEUS HOLY','A Emotional Display of a Pioneer And a Technical Writer who must Battle a Man in A Baloon',2006,1,NULL,6,'0.99',113,'20.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (20,'AMELIE HELLFIGHTERS','A Boring Drama of a Woman And a Squirrel who must Conquer a Student in A Baloon',2006,1,NULL,4,'4.99',79,'23.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (21,'AMERICAN CIRCUS','A Insightful Drama of a Girl And a Astronaut who must Face a Database Administrator in A Shark Tank',2006,1,NULL,3,'4.99',129,'17.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (22,'AMISTAD MIDSUMMER','A Emotional Character Study of a Dentist And a Crocodile who must Meet a Sumo Wrestler in California',2006,1,NULL,6,'2.99',85,'10.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (23,'ANACONDA CONFESSIONS','A Lacklusture Display of a Dentist And a Dentist who must Fight a Girl in Australia',2006,1,NULL,3,'0.99',92,'9.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (24,'ANALYZE HOOSIERS','A Thoughtful Display of a Explorer And a Pastry Chef who must Overcome a Feminist in The Sahara Desert',2006,1,NULL,6,'2.99',181,'19.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (25,'ANGELS LIFE','A Thoughtful Display of a Woman And a Astronaut who must Battle a Robot in Berlin',2006,1,NULL,3,'2.99',74,'15.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (26,'ANNIE IDENTITY','A Amazing Panorama of a Pastry Chef And a Boat who must Escape a Woman in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',86,'15.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (27,'ANONYMOUS HUMAN','A Amazing Reflection of a Database Administrator And a Astronaut who must Outrace a Database Administrator in A Shark Tank',2006,1,NULL,7,'0.99',179,'12.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (28,'ANTHEM LUKE','A Touching Panorama of a Waitress And a Woman who must Outrace a Dog in An Abandoned Amusement Park',2006,1,NULL,5,'4.99',91,'16.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (29,'ANTITRUST TOMATOES','A Fateful Yarn of a Womanizer And a Feminist who must Succumb a Database Administrator in Ancient India',2006,1,NULL,5,'2.99',168,'11.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (30,'ANYTHING SAVANNAH','A Epic Story of a Pastry Chef And a Woman who must Chase a Feminist in An Abandoned Fun House',2006,1,NULL,4,'2.99',82,'27.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (31,'APACHE DIVINE','A Awe-Inspiring Reflection of a Pastry Chef And a Teacher who must Overcome a Sumo Wrestler in A U-Boat',2006,1,NULL,5,'4.99',92,'16.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (32,'APOCALYPSE FLAMINGOS','A Astounding Story of a Dog And a Squirrel who must Defeat a Woman in An Abandoned Amusement Park',2006,1,NULL,6,'4.99',119,'11.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (33,'APOLLO TEEN','A Action-Packed Reflection of a Crocodile And a Explorer who must Find a Sumo Wrestler in An Abandoned Mine Shaft',2006,1,NULL,5,'2.99',153,'15.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (34,'ARABIA DOGMA','A Touching Epistle of a Madman And a Mad Cow who must Defeat a Student in Nigeria',2006,1,NULL,6,'0.99',62,'29.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (35,'ARACHNOPHOBIA ROLLERCOASTER','A Action-Packed Reflection of a Pastry Chef And a Composer who must Discover a Mad Scientist in The First Manned Space Station',2006,1,NULL,4,'2.99',147,'24.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (36,'ARGONAUTS TOWN','A Emotional Epistle of a Forensic Psychologist And a Butler who must Challenge a Waitress in An Abandoned Mine Shaft',2006,1,NULL,7,'0.99',127,'12.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (37,'ARIZONA BANG','A Brilliant Panorama of a Mad Scientist And a Mad Cow who must Meet a Pioneer in A Monastery',2006,1,NULL,3,'2.99',121,'28.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (38,'ARK RIDGEMONT','A Beautiful Yarn of a Pioneer And a Monkey who must Pursue a Explorer in The Sahara Desert',2006,1,NULL,6,'0.99',68,'25.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (39,'ARMAGEDDON LOST','A Fast-Paced Tale of a Boat And a Teacher who must Succumb a Composer in An Abandoned Mine Shaft',2006,1,NULL,5,'0.99',99,'10.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (40,'ARMY FLINTSTONES','A Boring Saga of a Database Administrator And a Womanizer who must Battle a Waitress in Nigeria',2006,1,NULL,4,'0.99',148,'22.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (41,'ARSENIC INDEPENDENCE','A Fanciful Documentary of a Mad Cow And a Womanizer who must Find a Dentist in Berlin',2006,1,NULL,4,'0.99',137,'17.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (42,'ARTIST COLDBLOODED','A Stunning Reflection of a Robot And a Moose who must Challenge a Woman in California',2006,1,NULL,5,'2.99',170,'10.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (43,'ATLANTIS CAUSE','A Thrilling Yarn of a Feminist And a Hunter who must Fight a Technical Writer in A Shark Tank',2006,1,NULL,6,'2.99',170,'15.99','G','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (44,'ATTACKS HATE','A Fast-Paced Panorama of a Technical Writer And a Mad Scientist who must Find a Feminist in An Abandoned Mine Shaft',2006,1,NULL,5,'4.99',113,'21.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (45,'ATTRACTION NEWTON','A Astounding Panorama of a Composer And a Frisbee who must Reach a Husband in Ancient Japan',2006,1,NULL,5,'4.99',83,'14.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (46,'AUTUMN CROW','A Beautiful Tale of a Dentist And a Mad Cow who must Battle a Moose in The Sahara Desert',2006,1,NULL,3,'4.99',108,'13.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (47,'BABY HALL','A Boring Character Study of a A Shark And a Girl who must Outrace a Feminist in An Abandoned Mine Shaft',2006,1,NULL,5,'4.99',153,'23.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (48,'BACKLASH UNDEFEATED','A Stunning Character Study of a Mad Scientist And a Mad Cow who must Kill a Car in A Monastery',2006,1,NULL,3,'4.99',118,'24.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (49,'BADMAN DAWN','A Emotional Panorama of a Pioneer And a Composer who must Escape a Mad Scientist in A Jet Boat',2006,1,NULL,6,'2.99',162,'22.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (50,'BAKED CLEOPATRA','A Stunning Drama of a Forensic Psychologist And a Husband who must Overcome a Waitress in A Monastery',2006,1,NULL,3,'2.99',182,'20.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (51,'BALLOON HOMEWARD','A Insightful Panorama of a Forensic Psychologist And a Mad Cow who must Build a Mad Scientist in The First Manned Space Station',2006,1,NULL,5,'2.99',75,'10.99','NC-17','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (52,'BALLROOM MOCKINGBIRD','A Thrilling Documentary of a Composer And a Monkey who must Find a Feminist in California',2006,1,NULL,6,'0.99',173,'29.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (53,'BANG KWAI','A Epic Drama of a Madman And a Cat who must Face a A Shark in An Abandoned Amusement Park',2006,1,NULL,5,'2.99',87,'25.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (54,'BANGER PINOCCHIO','A Awe-Inspiring Drama of a Car And a Pastry Chef who must Chase a Crocodile in The First Manned Space Station',2006,1,NULL,5,'0.99',113,'15.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (55,'BARBARELLA STREETCAR','A Awe-Inspiring Story of a Feminist And a Cat who must Conquer a Dog in A Monastery',2006,1,NULL,6,'2.99',65,'27.99','G','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (56,'BAREFOOT MANCHURIAN','A Intrepid Story of a Cat And a Student who must Vanquish a Girl in An Abandoned Amusement Park',2006,1,NULL,6,'2.99',129,'15.99','G','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (57,'BASIC EASY','A Stunning Epistle of a Man And a Husband who must Reach a Mad Scientist in A Jet Boat',2006,1,NULL,4,'2.99',90,'18.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (58,'BEACH HEARTBREAKERS','A Fateful Display of a Womanizer And a Mad Scientist who must Outgun a A Shark in Soviet Georgia',2006,1,NULL,6,'2.99',122,'16.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (59,'BEAR GRACELAND','A Astounding Saga of a Dog And a Boy who must Kill a Teacher in The First Manned Space Station',2006,1,NULL,4,'2.99',160,'20.99','R','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (60,'BEAST HUNCHBACK','A Awe-Inspiring Epistle of a Student And a Squirrel who must Defeat a Boy in Ancient China',2006,1,NULL,3,'4.99',89,'22.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (61,'BEAUTY GREASE','A Fast-Paced Display of a Composer And a Moose who must Sink a Robot in An Abandoned Mine Shaft',2006,1,NULL,5,'4.99',175,'28.99','G','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (62,'BED HIGHBALL','A Astounding Panorama of a Lumberjack And a Dog who must Redeem a Woman in An Abandoned Fun House',2006,1,NULL,5,'2.99',106,'23.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (63,'BEDAZZLED MARRIED','A Astounding Character Study of a Madman And a Robot who must Meet a Mad Scientist in An Abandoned Fun House',2006,1,NULL,6,'0.99',73,'21.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (64,'BEETHOVEN EXORCIST','A Epic Display of a Pioneer And a Student who must Challenge a Butler in The Gulf of Mexico',2006,1,NULL,6,'0.99',151,'26.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (65,'BEHAVIOR RUNAWAY','A Unbelieveable Drama of a Student And a Husband who must Outrace a Sumo Wrestler in Berlin',2006,1,NULL,3,'4.99',100,'20.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (66,'BENEATH RUSH','A Astounding Panorama of a Man And a Monkey who must Discover a Man in The First Manned Space Station',2006,1,NULL,6,'0.99',53,'27.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (67,'BERETS AGENT','A Taut Saga of a Crocodile And a Boy who must Overcome a Technical Writer in Ancient China',2006,1,NULL,5,'2.99',77,'24.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (68,'BETRAYED REAR','A Emotional Character Study of a Boat And a Pioneer who must Find a Explorer in A Shark Tank',2006,1,NULL,5,'4.99',122,'26.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (69,'BEVERLY OUTLAW','A Fanciful Documentary of a Womanizer And a Boat who must Defeat a Madman in The First Manned Space Station',2006,1,NULL,3,'2.99',85,'21.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (70,'BIKINI BORROWERS','A Astounding Drama of a Astronaut And a Cat who must Discover a Woman in The First Manned Space Station',2006,1,NULL,7,'4.99',142,'26.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (71,'BILKO ANONYMOUS','A Emotional Reflection of a Teacher And a Man who must Meet a Cat in The First Manned Space Station',2006,1,NULL,3,'4.99',100,'25.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (72,'BILL OTHERS','A Stunning Saga of a Mad Scientist And a Forensic Psychologist who must Challenge a Squirrel in A MySQL Convention',2006,1,NULL,6,'2.99',93,'12.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (73,'BINGO TALENTED','A Touching Tale of a Girl And a Crocodile who must Discover a Waitress in Nigeria',2006,1,NULL,5,'2.99',150,'22.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (74,'BIRCH ANTITRUST','A Fanciful Panorama of a Husband And a Pioneer who must Outgun a Dog in A Baloon',2006,1,NULL,4,'4.99',162,'18.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (75,'BIRD INDEPENDENCE','A Thrilling Documentary of a Car And a Student who must Sink a Hunter in The Canadian Rockies',2006,1,NULL,6,'4.99',163,'14.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (76,'BIRDCAGE CASPER','A Fast-Paced Saga of a Frisbee And a Astronaut who must Overcome a Feminist in Ancient India',2006,1,NULL,4,'0.99',103,'23.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (77,'BIRDS PERDITION','A Boring Story of a Womanizer And a Pioneer who must Face a Dog in California',2006,1,NULL,5,'4.99',61,'15.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (78,'BLACKOUT PRIVATE','A Intrepid Yarn of a Pastry Chef And a Mad Scientist who must Challenge a Secret Agent in Ancient Japan',2006,1,NULL,7,'2.99',85,'12.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (79,'BLADE POLISH','A Thoughtful Character Study of a Frisbee And a Pastry Chef who must Fight a Dentist in The First Manned Space Station',2006,1,NULL,5,'0.99',114,'10.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (80,'BLANKET BEVERLY','A Emotional Documentary of a Student And a Girl who must Build a Boat in Nigeria',2006,1,NULL,7,'2.99',148,'21.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (81,'BLINDNESS GUN','A Touching Drama of a Robot And a Dentist who must Meet a Hunter in A Jet Boat',2006,1,NULL,6,'4.99',103,'29.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (82,'BLOOD ARGONAUTS','A Boring Drama of a Explorer And a Man who must Kill a Lumberjack in A Manhattan Penthouse',2006,1,NULL,3,'0.99',71,'13.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (83,'BLUES INSTINCT','A Insightful Documentary of a Boat And a Composer who must Meet a Forensic Psychologist in An Abandoned Fun House',2006,1,NULL,5,'2.99',50,'18.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (84,'BOILED DARES','A Awe-Inspiring Story of a Waitress And a Dog who must Discover a Dentist in Ancient Japan',2006,1,NULL,7,'4.99',102,'13.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (85,'BONNIE HOLOCAUST','A Fast-Paced Story of a Crocodile And a Robot who must Find a Moose in Ancient Japan',2006,1,NULL,4,'0.99',63,'29.99','G','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (86,'BOOGIE AMELIE','A Lacklusture Character Study of a Husband And a Sumo Wrestler who must Succumb a Technical Writer in The Gulf of Mexico',2006,1,NULL,6,'4.99',121,'11.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (87,'BOONDOCK BALLROOM','A Fateful Panorama of a Crocodile And a Boy who must Defeat a Monkey in The Gulf of Mexico',2006,1,NULL,7,'0.99',76,'14.99','NC-17','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (88,'BORN SPINAL','A Touching Epistle of a Frisbee And a Husband who must Pursue a Student in Nigeria',2006,1,NULL,7,'4.99',179,'17.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (89,'BORROWERS BEDAZZLED','A Brilliant Epistle of a Teacher And a Sumo Wrestler who must Defeat a Man in An Abandoned Fun House',2006,1,NULL,7,'0.99',63,'22.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (90,'BOULEVARD MOB','A Fateful Epistle of a Moose And a Monkey who must Confront a Lumberjack in Ancient China',2006,1,NULL,3,'0.99',63,'11.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (91,'BOUND CHEAPER','A Thrilling Panorama of a Database Administrator And a Astronaut who must Challenge a Lumberjack in A Baloon',2006,1,NULL,5,'0.99',98,'17.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (92,'BOWFINGER GABLES','A Fast-Paced Yarn of a Waitress And a Composer who must Outgun a Dentist in California',2006,1,NULL,7,'4.99',72,'19.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (93,'BRANNIGAN SUNRISE','A Amazing Epistle of a Moose And a Crocodile who must Outrace a Dog in Berlin',2006,1,NULL,4,'4.99',121,'27.99','PG','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (94,'BRAVEHEART HUMAN','A Insightful Story of a Dog And a Pastry Chef who must Battle a Girl in Berlin',2006,1,NULL,7,'2.99',176,'14.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (95,'BREAKFAST GOLDFINGER','A Beautiful Reflection of a Student And a Student who must Fight a Moose in Berlin',2006,1,NULL,5,'4.99',123,'18.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (96,'BREAKING HOME','A Beautiful Display of a Secret Agent And a Monkey who must Battle a Sumo Wrestler in An Abandoned Mine Shaft',2006,1,NULL,4,'2.99',169,'21.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (97,'BRIDE INTRIGUE','A Epic Tale of a Robot And a Monkey who must Vanquish a Man in New Orleans',2006,1,NULL,7,'0.99',56,'24.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (98,'BRIGHT ENCOUNTERS','A Fateful Yarn of a Lumberjack And a Feminist who must Conquer a Student in A Jet Boat',2006,1,NULL,4,'4.99',73,'12.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (99,'BRINGING HYSTERICAL','A Fateful Saga of a A Shark And a Technical Writer who must Find a Woman in A Jet Boat',2006,1,NULL,7,'2.99',136,'14.99','PG','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (100,'BROOKLYN DESERT','A Beautiful Drama of a Dentist And a Composer who must Battle a Sumo Wrestler in The First Manned Space Station',2006,1,NULL,7,'4.99',161,'21.99','R','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (101,'BROTHERHOOD BLANKET','A Fateful Character Study of a Butler And a Technical Writer who must Sink a Astronaut in Ancient Japan',2006,1,NULL,3,'0.99',73,'26.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (102,'BUBBLE GROSSE','A Awe-Inspiring Panorama of a Crocodile And a Moose who must Confront a Girl in A Baloon',2006,1,NULL,4,'4.99',60,'20.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (103,'BUCKET BROTHERHOOD','A Amazing Display of a Girl And a Womanizer who must Succumb a Lumberjack in A Baloon Factory',2006,1,NULL,7,'4.99',133,'27.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (104,'BUGSY SONG','A Awe-Inspiring Character Study of a Secret Agent And a Boat who must Find a Squirrel in The First Manned Space Station',2006,1,NULL,4,'2.99',119,'17.99','G','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (105,'BULL SHAWSHANK','A Fanciful Drama of a Moose And a Squirrel who must Conquer a Pioneer in The Canadian Rockies',2006,1,NULL,6,'0.99',125,'21.99','NC-17','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (106,'BULWORTH COMMANDMENTS','A Amazing Display of a Mad Cow And a Pioneer who must Redeem a Sumo Wrestler in The Outback',2006,1,NULL,4,'2.99',61,'14.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (107,'BUNCH MINDS','A Emotional Story of a Feminist And a Feminist who must Escape a Pastry Chef in A MySQL Convention',2006,1,NULL,4,'2.99',63,'13.99','G','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (108,'BUTCH PANTHER','A Lacklusture Yarn of a Feminist And a Database Administrator who must Face a Hunter in New Orleans',2006,1,NULL,6,'0.99',67,'19.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (109,'BUTTERFLY CHOCOLAT','A Fateful Story of a Girl And a Composer who must Conquer a Husband in A Shark Tank',2006,1,NULL,3,'0.99',89,'17.99','G','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (110,'CABIN FLASH','A Stunning Epistle of a Boat And a Man who must Challenge a A Shark in A Baloon Factory',2006,1,NULL,4,'0.99',53,'25.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (111,'CADDYSHACK JEDI','A Awe-Inspiring Epistle of a Woman And a Madman who must Fight a Robot in Soviet Georgia',2006,1,NULL,3,'0.99',52,'17.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (112,'CALENDAR GUNFIGHT','A Thrilling Drama of a Frisbee And a Lumberjack who must Sink a Man in Nigeria',2006,1,NULL,4,'4.99',120,'22.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (113,'CALIFORNIA BIRDS','A Thrilling Yarn of a Database Administrator And a Robot who must Battle a Database Administrator in Ancient India',2006,1,NULL,4,'4.99',75,'19.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (114,'CAMELOT VACATION','A Touching Character Study of a Woman And a Waitress who must Battle a Pastry Chef in A MySQL Convention',2006,1,NULL,3,'0.99',61,'26.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (115,'CAMPUS REMEMBER','A Astounding Drama of a Crocodile And a Mad Cow who must Build a Robot in A Jet Boat',2006,1,NULL,5,'2.99',167,'27.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (116,'CANDIDATE PERDITION','A Brilliant Epistle of a Composer And a Database Administrator who must Vanquish a Mad Scientist in The First Manned Space Station',2006,1,NULL,4,'2.99',70,'10.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (117,'CANDLES GRAPES','A Fanciful Character Study of a Monkey And a Explorer who must Build a Astronaut in An Abandoned Fun House',2006,1,NULL,6,'4.99',135,'15.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (118,'CANYON STOCK','A Thoughtful Reflection of a Waitress And a Feminist who must Escape a Squirrel in A Manhattan Penthouse',2006,1,NULL,7,'0.99',85,'26.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (119,'CAPER MOTIONS','A Fateful Saga of a Moose And a Car who must Pursue a Woman in A MySQL Convention',2006,1,NULL,6,'0.99',176,'22.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (120,'CARIBBEAN LIBERTY','A Fanciful Tale of a Pioneer And a Technical Writer who must Outgun a Pioneer in A Shark Tank',2006,1,NULL,3,'4.99',92,'16.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (121,'CAROL TEXAS','A Astounding Character Study of a Composer And a Student who must Overcome a Composer in A Monastery',2006,1,NULL,4,'2.99',151,'15.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (122,'CARRIE BUNCH','A Amazing Epistle of a Student And a Astronaut who must Discover a Frisbee in The Canadian Rockies',2006,1,NULL,7,'0.99',114,'11.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (123,'CASABLANCA SUPER','A Amazing Panorama of a Crocodile And a Forensic Psychologist who must Pursue a Secret Agent in The First Manned Space Station',2006,1,NULL,6,'4.99',85,'22.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (124,'CASPER DRAGONFLY','A Intrepid Documentary of a Boat And a Crocodile who must Chase a Robot in The Sahara Desert',2006,1,NULL,3,'4.99',163,'16.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (125,'CASSIDY WYOMING','A Intrepid Drama of a Frisbee And a Hunter who must Kill a Secret Agent in New Orleans',2006,1,NULL,5,'2.99',61,'19.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (126,'CASUALTIES ENCINO','A Insightful Yarn of a A Shark And a Pastry Chef who must Face a Boy in A Monastery',2006,1,NULL,3,'4.99',179,'16.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (127,'CAT CONEHEADS','A Fast-Paced Panorama of a Girl And a A Shark who must Confront a Boy in Ancient India',2006,1,NULL,5,'4.99',112,'14.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (128,'CATCH AMISTAD','A Boring Reflection of a Lumberjack And a Feminist who must Discover a Woman in Nigeria',2006,1,NULL,7,'0.99',183,'10.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (129,'CAUSE DATE','A Taut Tale of a Explorer And a Pastry Chef who must Conquer a Hunter in A MySQL Convention',2006,1,NULL,3,'2.99',179,'16.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (130,'CELEBRITY HORN','A Amazing Documentary of a Secret Agent And a Astronaut who must Vanquish a Hunter in A Shark Tank',2006,1,NULL,7,'0.99',110,'24.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (131,'CENTER DINOSAUR','A Beautiful Character Study of a Sumo Wrestler And a Dentist who must Find a Dog in California',2006,1,NULL,5,'4.99',152,'12.99','PG','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (132,'CHAINSAW UPTOWN','A Beautiful Documentary of a Boy And a Robot who must Discover a Squirrel in Australia',2006,1,NULL,6,'0.99',114,'25.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (133,'CHAMBER ITALIAN','A Fateful Reflection of a Moose And a Husband who must Overcome a Monkey in Nigeria',2006,1,NULL,7,'4.99',117,'14.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (134,'CHAMPION FLATLINERS','A Amazing Story of a Mad Cow And a Dog who must Kill a Husband in A Monastery',2006,1,NULL,4,'4.99',51,'21.99','PG','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (135,'CHANCE RESURRECTION','A Astounding Story of a Forensic Psychologist And a Forensic Psychologist who must Overcome a Moose in Ancient China',2006,1,NULL,3,'2.99',70,'22.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (136,'CHAPLIN LICENSE','A Boring Drama of a Dog And a Forensic Psychologist who must Outrace a Explorer in Ancient India',2006,1,NULL,7,'2.99',146,'26.99','NC-17','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (137,'CHARADE DUFFEL','A Action-Packed Display of a Man And a Waitress who must Build a Dog in A MySQL Convention',2006,1,NULL,3,'2.99',66,'21.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (138,'CHARIOTS CONSPIRACY','A Unbelieveable Epistle of a Robot And a Husband who must Chase a Robot in The First Manned Space Station',2006,1,NULL,5,'2.99',71,'29.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (139,'CHASING FIGHT','A Astounding Saga of a Technical Writer And a Butler who must Battle a Butler in A Shark Tank',2006,1,NULL,7,'4.99',114,'21.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (140,'CHEAPER CLYDE','A Emotional Character Study of a Pioneer And a Girl who must Discover a Dog in Ancient Japan',2006,1,NULL,6,'0.99',87,'23.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (141,'CHICAGO NORTH','A Fateful Yarn of a Mad Cow And a Waitress who must Battle a Student in California',2006,1,NULL,6,'4.99',185,'11.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (142,'CHICKEN HELLFIGHTERS','A Emotional Drama of a Dog And a Explorer who must Outrace a Technical Writer in Australia',2006,1,NULL,3,'0.99',122,'24.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (143,'CHILL LUCK','A Lacklusture Epistle of a Boat And a Technical Writer who must Fight a A Shark in The Canadian Rockies',2006,1,NULL,6,'0.99',142,'17.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (144,'CHINATOWN GLADIATOR','A Brilliant Panorama of a Technical Writer And a Lumberjack who must Escape a Butler in Ancient India',2006,1,NULL,7,'4.99',61,'24.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (145,'CHISUM BEHAVIOR','A Epic Documentary of a Sumo Wrestler And a Butler who must Kill a Car in Ancient India',2006,1,NULL,5,'4.99',124,'25.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (146,'CHITTY LOCK','A Boring Epistle of a Boat And a Database Administrator who must Kill a Sumo Wrestler in The First Manned Space Station',2006,1,NULL,6,'2.99',107,'24.99','G','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (147,'CHOCOLAT HARRY','A Action-Packed Epistle of a Dentist And a Moose who must Meet a Mad Cow in Ancient Japan',2006,1,NULL,5,'0.99',101,'16.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (148,'CHOCOLATE DUCK','A Unbelieveable Story of a Mad Scientist And a Technical Writer who must Discover a Composer in Ancient China',2006,1,NULL,3,'2.99',132,'13.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (149,'CHRISTMAS MOONSHINE','A Action-Packed Epistle of a Feminist And a Astronaut who must Conquer a Boat in A Manhattan Penthouse',2006,1,NULL,7,'0.99',150,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (150,'CIDER DESIRE','A Stunning Character Study of a Composer And a Mad Cow who must Succumb a Cat in Soviet Georgia',2006,1,NULL,7,'2.99',101,'9.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (151,'CINCINATTI WHISPERER','A Brilliant Saga of a Pastry Chef And a Hunter who must Confront a Butler in Berlin',2006,1,NULL,5,'4.99',143,'26.99','NC-17','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (152,'CIRCUS YOUTH','A Thoughtful Drama of a Pastry Chef And a Dentist who must Pursue a Girl in A Baloon',2006,1,NULL,5,'2.99',90,'13.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (153,'CITIZEN SHREK','A Fanciful Character Study of a Technical Writer And a Husband who must Redeem a Robot in The Outback',2006,1,NULL,7,'0.99',165,'18.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (154,'CLASH FREDDY','A Amazing Yarn of a Composer And a Squirrel who must Escape a Astronaut in Australia',2006,1,NULL,6,'2.99',81,'12.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (155,'CLEOPATRA DEVIL','A Fanciful Documentary of a Crocodile And a Technical Writer who must Fight a A Shark in A Baloon',2006,1,NULL,6,'0.99',150,'26.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (156,'CLERKS ANGELS','A Thrilling Display of a Sumo Wrestler And a Girl who must Confront a Man in A Baloon',2006,1,NULL,3,'4.99',164,'15.99','G','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (157,'CLOCKWORK PARADISE','A Insightful Documentary of a Technical Writer And a Feminist who must Challenge a Cat in A Baloon',2006,1,NULL,7,'0.99',143,'29.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (158,'CLONES PINOCCHIO','A Amazing Drama of a Car And a Robot who must Pursue a Dentist in New Orleans',2006,1,NULL,6,'2.99',124,'16.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (159,'CLOSER BANG','A Unbelieveable Panorama of a Frisbee And a Hunter who must Vanquish a Monkey in Ancient India',2006,1,NULL,5,'4.99',58,'12.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (160,'CLUB GRAFFITI','A Epic Tale of a Pioneer And a Hunter who must Escape a Girl in A U-Boat',2006,1,NULL,4,'0.99',65,'12.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (161,'CLUE GRAIL','A Taut Tale of a Butler And a Mad Scientist who must Build a Crocodile in Ancient China',2006,1,NULL,6,'4.99',70,'27.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (162,'CLUELESS BUCKET','A Taut Tale of a Car And a Pioneer who must Conquer a Sumo Wrestler in An Abandoned Fun House',2006,1,NULL,4,'2.99',95,'13.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (163,'CLYDE THEORY','A Beautiful Yarn of a Astronaut And a Frisbee who must Overcome a Explorer in A Jet Boat',2006,1,NULL,4,'0.99',139,'29.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (164,'COAST RAINBOW','A Astounding Documentary of a Mad Cow And a Pioneer who must Challenge a Butler in The Sahara Desert',2006,1,NULL,4,'0.99',55,'20.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (165,'COLDBLOODED DARLING','A Brilliant Panorama of a Dentist And a Moose who must Find a Student in The Gulf of Mexico',2006,1,NULL,7,'4.99',70,'27.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (166,'COLOR PHILADELPHIA','A Thoughtful Panorama of a Car And a Crocodile who must Sink a Monkey in The Sahara Desert',2006,1,NULL,6,'2.99',149,'19.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (167,'COMA HEAD','A Awe-Inspiring Drama of a Boy And a Frisbee who must Escape a Pastry Chef in California',2006,1,NULL,6,'4.99',109,'10.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (168,'COMANCHEROS ENEMY','A Boring Saga of a Lumberjack And a Monkey who must Find a Monkey in The Gulf of Mexico',2006,1,NULL,5,'0.99',67,'23.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (169,'COMFORTS RUSH','A Unbelieveable Panorama of a Pioneer And a Husband who must Meet a Mad Cow in An Abandoned Mine Shaft',2006,1,NULL,3,'2.99',76,'19.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (170,'COMMAND DARLING','A Awe-Inspiring Tale of a Forensic Psychologist And a Woman who must Challenge a Database Administrator in Ancient Japan',2006,1,NULL,5,'4.99',120,'28.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (171,'COMMANDMENTS EXPRESS','A Fanciful Saga of a Student And a Mad Scientist who must Battle a Hunter in An Abandoned Mine Shaft',2006,1,NULL,6,'4.99',59,'13.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (172,'CONEHEADS SMOOCHY','A Touching Story of a Womanizer And a Composer who must Pursue a Husband in Nigeria',2006,1,NULL,7,'4.99',112,'12.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (173,'CONFESSIONS MAGUIRE','A Insightful Story of a Car And a Boy who must Battle a Technical Writer in A Baloon',2006,1,NULL,7,'4.99',65,'25.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (174,'CONFIDENTIAL INTERVIEW','A Stunning Reflection of a Cat And a Woman who must Find a Astronaut in Ancient Japan',2006,1,NULL,6,'4.99',180,'13.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (175,'CONFUSED CANDLES','A Stunning Epistle of a Cat And a Forensic Psychologist who must Confront a Pioneer in A Baloon',2006,1,NULL,3,'2.99',122,'27.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (176,'CONGENIALITY QUEST','A Touching Documentary of a Cat And a Pastry Chef who must Find a Lumberjack in A Baloon',2006,1,NULL,6,'0.99',87,'21.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (177,'CONNECTICUT TRAMP','A Unbelieveable Drama of a Crocodile And a Mad Cow who must Reach a Dentist in A Shark Tank',2006,1,NULL,4,'4.99',172,'20.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (178,'CONNECTION MICROCOSMOS','A Fateful Documentary of a Crocodile And a Husband who must Face a Husband in The First Manned Space Station',2006,1,NULL,6,'0.99',115,'25.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (179,'CONQUERER NUTS','A Taut Drama of a Mad Scientist And a Man who must Escape a Pioneer in An Abandoned Mine Shaft',2006,1,NULL,4,'4.99',173,'14.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (180,'CONSPIRACY SPIRIT','A Awe-Inspiring Story of a Student And a Frisbee who must Conquer a Crocodile in An Abandoned Mine Shaft',2006,1,NULL,4,'2.99',184,'27.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (181,'CONTACT ANONYMOUS','A Insightful Display of a A Shark And a Monkey who must Face a Database Administrator in Ancient India',2006,1,NULL,7,'2.99',166,'10.99','PG-13','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (182,'CONTROL ANTHEM','A Fateful Documentary of a Robot And a Student who must Battle a Cat in A Monastery',2006,1,NULL,7,'4.99',185,'9.99','G','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (183,'CONVERSATION DOWNHILL','A Taut Character Study of a Husband And a Waitress who must Sink a Squirrel in A MySQL Convention',2006,1,NULL,4,'4.99',112,'14.99','R','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (184,'CORE SUIT','A Unbelieveable Tale of a Car And a Explorer who must Confront a Boat in A Manhattan Penthouse',2006,1,NULL,3,'2.99',92,'24.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (185,'COWBOY DOOM','A Astounding Drama of a Boy And a Lumberjack who must Fight a Butler in A Baloon',2006,1,NULL,3,'2.99',146,'10.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (186,'CRAFT OUTFIELD','A Lacklusture Display of a Explorer And a Hunter who must Succumb a Database Administrator in A Baloon Factory',2006,1,NULL,6,'0.99',64,'17.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (187,'CRANES RESERVOIR','A Fanciful Documentary of a Teacher And a Dog who must Outgun a Forensic Psychologist in A Baloon Factory',2006,1,NULL,5,'2.99',57,'12.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (188,'CRAZY HOME','A Fanciful Panorama of a Boy And a Woman who must Vanquish a Database Administrator in The Outback',2006,1,NULL,7,'2.99',136,'24.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (189,'CREATURES SHAKESPEARE','A Emotional Drama of a Womanizer And a Squirrel who must Vanquish a Crocodile in Ancient India',2006,1,NULL,3,'0.99',139,'23.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (190,'CREEPERS KANE','A Awe-Inspiring Reflection of a Squirrel And a Boat who must Outrace a Car in A Jet Boat',2006,1,NULL,5,'4.99',172,'23.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (191,'CROOKED FROGMEN','A Unbelieveable Drama of a Hunter And a Database Administrator who must Battle a Crocodile in An Abandoned Amusement Park',2006,1,NULL,6,'0.99',143,'27.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (192,'CROSSING DIVORCE','A Beautiful Documentary of a Dog And a Robot who must Redeem a Womanizer in Berlin',2006,1,NULL,4,'4.99',50,'19.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (193,'CROSSROADS CASUALTIES','A Intrepid Documentary of a Sumo Wrestler And a Astronaut who must Battle a Composer in The Outback',2006,1,NULL,5,'2.99',153,'20.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (194,'CROW GREASE','A Awe-Inspiring Documentary of a Woman And a Husband who must Sink a Database Administrator in The First Manned Space Station',2006,1,NULL,6,'0.99',104,'22.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (195,'CROWDS TELEMARK','A Intrepid Documentary of a Astronaut And a Forensic Psychologist who must Find a Frisbee in An Abandoned Fun House',2006,1,NULL,3,'4.99',112,'16.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (196,'CRUELTY UNFORGIVEN','A Brilliant Tale of a Car And a Moose who must Battle a Dentist in Nigeria',2006,1,NULL,7,'0.99',69,'29.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (197,'CRUSADE HONEY','A Fast-Paced Reflection of a Explorer And a Butler who must Battle a Madman in An Abandoned Amusement Park',2006,1,NULL,4,'2.99',112,'27.99','R','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (198,'CRYSTAL BREAKING','A Fast-Paced Character Study of a Feminist And a Explorer who must Face a Pastry Chef in Ancient Japan',2006,1,NULL,6,'2.99',184,'22.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (199,'CUPBOARD SINNERS','A Emotional Reflection of a Frisbee And a Boat who must Reach a Pastry Chef in An Abandoned Amusement Park',2006,1,NULL,4,'2.99',56,'29.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (200,'CURTAIN VIDEOTAPE','A Boring Reflection of a Dentist And a Mad Cow who must Chase a Secret Agent in A Shark Tank',2006,1,NULL,7,'0.99',133,'27.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (201,'CYCLONE FAMILY','A Lacklusture Drama of a Student And a Monkey who must Sink a Womanizer in A MySQL Convention',2006,1,NULL,7,'2.99',176,'18.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (202,'DADDY PITTSBURGH','A Epic Story of a A Shark And a Student who must Confront a Explorer in The Gulf of Mexico',2006,1,NULL,5,'4.99',161,'26.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (203,'DAISY MENAGERIE','A Fast-Paced Saga of a Pastry Chef And a Monkey who must Sink a Composer in Ancient India',2006,1,NULL,5,'4.99',84,'9.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (204,'DALMATIONS SWEDEN','A Emotional Epistle of a Moose And a Hunter who must Overcome a Robot in A Manhattan Penthouse',2006,1,NULL,4,'0.99',106,'25.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (205,'DANCES NONE','A Insightful Reflection of a A Shark And a Dog who must Kill a Butler in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',58,'22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (206,'DANCING FEVER','A Stunning Story of a Explorer And a Forensic Psychologist who must Face a Crocodile in A Shark Tank',2006,1,NULL,6,'0.99',144,'25.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (207,'DANGEROUS UPTOWN','A Unbelieveable Story of a Mad Scientist And a Woman who must Overcome a Dog in California',2006,1,NULL,7,'4.99',121,'26.99','PG','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (208,'DARES PLUTO','A Fateful Story of a Robot And a Dentist who must Defeat a Astronaut in New Orleans',2006,1,NULL,7,'2.99',89,'16.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (209,'DARKNESS WAR','A Touching Documentary of a Husband And a Hunter who must Escape a Boy in The Sahara Desert',2006,1,NULL,6,'2.99',99,'24.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (210,'DARKO DORADO','A Stunning Reflection of a Frisbee And a Husband who must Redeem a Dog in New Orleans',2006,1,NULL,3,'4.99',130,'13.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (211,'DARLING BREAKING','A Brilliant Documentary of a Astronaut And a Squirrel who must Succumb a Student in The Gulf of Mexico',2006,1,NULL,7,'4.99',165,'20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (212,'DARN FORRESTER','A Fateful Story of a A Shark And a Explorer who must Succumb a Technical Writer in A Jet Boat',2006,1,NULL,7,'4.99',185,'14.99','G','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (213,'DATE SPEED','A Touching Saga of a Composer And a Moose who must Discover a Dentist in A MySQL Convention',2006,1,NULL,4,'0.99',104,'19.99','R','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (214,'DAUGHTER MADIGAN','A Beautiful Tale of a Hunter And a Mad Scientist who must Confront a Squirrel in The First Manned Space Station',2006,1,NULL,3,'4.99',59,'13.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (215,'DAWN POND','A Thoughtful Documentary of a Dentist And a Forensic Psychologist who must Defeat a Waitress in Berlin',2006,1,NULL,4,'4.99',57,'27.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (216,'DAY UNFAITHFUL','A Stunning Documentary of a Composer And a Mad Scientist who must Find a Technical Writer in A U-Boat',2006,1,NULL,3,'4.99',113,'16.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (217,'DAZED PUNK','A Action-Packed Story of a Pioneer And a Technical Writer who must Discover a Forensic Psychologist in An Abandoned Amusement Park',2006,1,NULL,6,'4.99',120,'20.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (218,'DECEIVER BETRAYED','A Taut Story of a Moose And a Squirrel who must Build a Husband in Ancient India',2006,1,NULL,7,'0.99',122,'22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (219,'DEEP CRUSADE','A Amazing Tale of a Crocodile And a Squirrel who must Discover a Composer in Australia',2006,1,NULL,6,'4.99',51,'20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (220,'DEER VIRGINIAN','A Thoughtful Story of a Mad Cow And a Womanizer who must Overcome a Mad Scientist in Soviet Georgia',2006,1,NULL,7,'2.99',106,'13.99','NC-17','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (221,'DELIVERANCE MULHOLLAND','A Astounding Saga of a Monkey And a Moose who must Conquer a Butler in A Shark Tank',2006,1,NULL,4,'0.99',100,'9.99','R','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (222,'DESERT POSEIDON','A Brilliant Documentary of a Butler And a Frisbee who must Build a Astronaut in New Orleans',2006,1,NULL,4,'4.99',64,'27.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (223,'DESIRE ALIEN','A Fast-Paced Tale of a Dog And a Forensic Psychologist who must Meet a Astronaut in The First Manned Space Station',2006,1,NULL,7,'2.99',76,'24.99','NC-17','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (224,'DESPERATE TRAINSPOTTING','A Epic Yarn of a Forensic Psychologist And a Teacher who must Face a Lumberjack in California',2006,1,NULL,7,'4.99',81,'29.99','G','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (225,'DESTINATION JERK','A Beautiful Yarn of a Teacher And a Cat who must Build a Car in A U-Boat',2006,1,NULL,3,'0.99',76,'19.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (226,'DESTINY SATURDAY','A Touching Drama of a Crocodile And a Crocodile who must Conquer a Explorer in Soviet Georgia',2006,1,NULL,4,'4.99',56,'20.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (227,'DETAILS PACKER','A Epic Saga of a Waitress And a Composer who must Face a Boat in A U-Boat',2006,1,NULL,4,'4.99',88,'17.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (228,'DETECTIVE VISION','A Fanciful Documentary of a Pioneer And a Woman who must Redeem a Hunter in Ancient Japan',2006,1,NULL,4,'0.99',143,'16.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (229,'DEVIL DESIRE','A Beautiful Reflection of a Monkey And a Dentist who must Face a Database Administrator in Ancient Japan',2006,1,NULL,6,'4.99',87,'12.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (230,'DIARY PANIC','A Thoughtful Character Study of a Frisbee And a Mad Cow who must Outgun a Man in Ancient India',2006,1,NULL,7,'2.99',107,'20.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (231,'DINOSAUR SECRETARY','A Action-Packed Drama of a Feminist And a Girl who must Reach a Robot in The Canadian Rockies',2006,1,NULL,7,'2.99',63,'27.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (232,'DIRTY ACE','A Action-Packed Character Study of a Forensic Psychologist And a Girl who must Build a Dentist in The Outback',2006,1,NULL,7,'2.99',147,'29.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (233,'DISCIPLE MOTHER','A Touching Reflection of a Mad Scientist And a Boat who must Face a Moose in A Shark Tank',2006,1,NULL,3,'0.99',141,'17.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (234,'DISTURBING SCARFACE','A Lacklusture Display of a Crocodile And a Butler who must Overcome a Monkey in A U-Boat',2006,1,NULL,6,'2.99',94,'27.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (235,'DIVIDE MONSTER','A Intrepid Saga of a Man And a Forensic Psychologist who must Reach a Squirrel in A Monastery',2006,1,NULL,6,'2.99',68,'13.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (236,'DIVINE RESURRECTION','A Boring Character Study of a Man And a Womanizer who must Succumb a Teacher in An Abandoned Amusement Park',2006,1,NULL,4,'2.99',100,'19.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (237,'DIVORCE SHINING','A Unbelieveable Saga of a Crocodile And a Student who must Discover a Cat in Ancient India',2006,1,NULL,3,'2.99',47,'21.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (238,'DOCTOR GRAIL','A Insightful Drama of a Womanizer And a Waitress who must Reach a Forensic Psychologist in The Outback',2006,1,NULL,4,'2.99',57,'29.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (239,'DOGMA FAMILY','A Brilliant Character Study of a Database Administrator And a Monkey who must Succumb a Astronaut in New Orleans',2006,1,NULL,5,'4.99',122,'16.99','G','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (240,'DOLLS RAGE','A Thrilling Display of a Pioneer And a Frisbee who must Escape a Teacher in The Outback',2006,1,NULL,7,'2.99',120,'10.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (241,'DONNIE ALLEY','A Awe-Inspiring Tale of a Butler And a Frisbee who must Vanquish a Teacher in Ancient Japan',2006,1,NULL,4,'0.99',125,'20.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (242,'DOOM DANCING','A Astounding Panorama of a Car And a Mad Scientist who must Battle a Lumberjack in A MySQL Convention',2006,1,NULL,4,'0.99',68,'13.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (243,'DOORS PRESIDENT','A Awe-Inspiring Display of a Squirrel And a Woman who must Overcome a Boy in The Gulf of Mexico',2006,1,NULL,3,'4.99',49,'22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (244,'DORADO NOTTING','A Action-Packed Tale of a Sumo Wrestler And a A Shark who must Meet a Frisbee in California',2006,1,NULL,5,'4.99',139,'26.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (245,'DOUBLE WRATH','A Thoughtful Yarn of a Womanizer And a Dog who must Challenge a Madman in The Gulf of Mexico',2006,1,NULL,4,'0.99',177,'28.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (246,'DOUBTFIRE LABYRINTH','A Intrepid Panorama of a Butler And a Composer who must Meet a Mad Cow in The Sahara Desert',2006,1,NULL,5,'4.99',154,'16.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (247,'DOWNHILL ENOUGH','A Emotional Tale of a Pastry Chef And a Forensic Psychologist who must Succumb a Monkey in The Sahara Desert',2006,1,NULL,3,'0.99',47,'19.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (248,'DOZEN LION','A Taut Drama of a Cat And a Girl who must Defeat a Frisbee in The Canadian Rockies',2006,1,NULL,6,'4.99',177,'20.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (249,'DRACULA CRYSTAL','A Thrilling Reflection of a Feminist And a Cat who must Find a Frisbee in An Abandoned Fun House',2006,1,NULL,7,'0.99',176,'26.99','G','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (250,'DRAGON SQUAD','A Taut Reflection of a Boy And a Waitress who must Outgun a Teacher in Ancient China',2006,1,NULL,4,'0.99',170,'26.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (251,'DRAGONFLY STRANGERS','A Boring Documentary of a Pioneer And a Man who must Vanquish a Man in Nigeria',2006,1,NULL,6,'4.99',133,'19.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (252,'DREAM PICKUP','A Epic Display of a Car And a Composer who must Overcome a Forensic Psychologist in The Gulf of Mexico',2006,1,NULL,6,'2.99',135,'18.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (253,'DRIFTER COMMANDMENTS','A Epic Reflection of a Womanizer And a Squirrel who must Discover a Husband in A Jet Boat',2006,1,NULL,5,'4.99',61,'18.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (254,'DRIVER ANNIE','A Lacklusture Character Study of a Butler And a Car who must Redeem a Boat in An Abandoned Fun House',2006,1,NULL,4,'2.99',159,'11.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (255,'DRIVING POLISH','A Action-Packed Yarn of a Feminist And a Technical Writer who must Sink a Boat in An Abandoned Mine Shaft',2006,1,NULL,6,'4.99',175,'21.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (256,'DROP WATERFRONT','A Fanciful Documentary of a Husband And a Explorer who must Reach a Madman in Ancient China',2006,1,NULL,6,'4.99',178,'20.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (257,'DRUMLINE CYCLONE','A Insightful Panorama of a Monkey And a Sumo Wrestler who must Outrace a Mad Scientist in The Canadian Rockies',2006,1,NULL,3,'0.99',110,'14.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (258,'DRUMS DYNAMITE','A Epic Display of a Crocodile And a Crocodile who must Confront a Dog in An Abandoned Amusement Park',2006,1,NULL,6,'0.99',96,'11.99','PG','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (259,'DUCK RACER','A Lacklusture Yarn of a Teacher And a Squirrel who must Overcome a Dog in A Shark Tank',2006,1,NULL,4,'2.99',116,'15.99','NC-17','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (260,'DUDE BLINDNESS','A Stunning Reflection of a Husband And a Lumberjack who must Face a Frisbee in An Abandoned Fun House',2006,1,NULL,3,'4.99',132,'9.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (261,'DUFFEL APOCALYPSE','A Emotional Display of a Boat And a Explorer who must Challenge a Madman in A MySQL Convention',2006,1,NULL,5,'0.99',171,'13.99','G','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (262,'DUMBO LUST','A Touching Display of a Feminist And a Dentist who must Conquer a Husband in The Gulf of Mexico',2006,1,NULL,5,'0.99',119,'17.99','NC-17','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (263,'DURHAM PANKY','A Brilliant Panorama of a Girl And a Boy who must Face a Mad Scientist in An Abandoned Mine Shaft',2006,1,NULL,6,'4.99',154,'14.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (264,'DWARFS ALTER','A Emotional Yarn of a Girl And a Dog who must Challenge a Composer in Ancient Japan',2006,1,NULL,6,'2.99',101,'13.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (265,'DYING MAKER','A Intrepid Tale of a Boat And a Monkey who must Kill a Cat in California',2006,1,NULL,5,'4.99',168,'28.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (266,'DYNAMITE TARZAN','A Intrepid Documentary of a Forensic Psychologist And a Mad Scientist who must Face a Explorer in A U-Boat',2006,1,NULL,4,'0.99',141,'27.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (267,'EAGLES PANKY','A Thoughtful Story of a Car And a Boy who must Find a A Shark in The Sahara Desert',2006,1,NULL,4,'4.99',140,'14.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (268,'EARLY HOME','A Amazing Panorama of a Mad Scientist And a Husband who must Meet a Woman in The Outback',2006,1,NULL,6,'4.99',96,'27.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (269,'EARRING INSTINCT','A Stunning Character Study of a Dentist And a Mad Cow who must Find a Teacher in Nigeria',2006,1,NULL,3,'0.99',98,'22.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (270,'EARTH VISION','A Stunning Drama of a Butler And a Madman who must Outrace a Womanizer in Ancient India',2006,1,NULL,7,'0.99',85,'29.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (271,'EASY GLADIATOR','A Fateful Story of a Monkey And a Girl who must Overcome a Pastry Chef in Ancient India',2006,1,NULL,5,'4.99',148,'12.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (272,'EDGE KISSING','A Beautiful Yarn of a Composer And a Mad Cow who must Redeem a Mad Scientist in A Jet Boat',2006,1,NULL,5,'4.99',153,'9.99','NC-17','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (273,'EFFECT GLADIATOR','A Beautiful Display of a Pastry Chef And a Pastry Chef who must Outgun a Forensic Psychologist in A Manhattan Penthouse',2006,1,NULL,6,'0.99',107,'14.99','PG','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (274,'EGG IGBY','A Beautiful Documentary of a Boat And a Sumo Wrestler who must Succumb a Database Administrator in The First Manned Space Station',2006,1,NULL,4,'2.99',67,'20.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (275,'EGYPT TENENBAUMS','A Intrepid Story of a Madman And a Secret Agent who must Outrace a Astronaut in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',85,'11.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (276,'ELEMENT FREDDY','A Awe-Inspiring Reflection of a Waitress And a Squirrel who must Kill a Mad Cow in A Jet Boat',2006,1,NULL,6,'4.99',115,'28.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (277,'ELEPHANT TROJAN','A Beautiful Panorama of a Lumberjack And a Forensic Psychologist who must Overcome a Frisbee in A Baloon',2006,1,NULL,4,'4.99',126,'24.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (278,'ELF MURDER','A Action-Packed Story of a Frisbee And a Woman who must Reach a Girl in An Abandoned Mine Shaft',2006,1,NULL,4,'4.99',155,'19.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (279,'ELIZABETH SHANE','A Lacklusture Display of a Womanizer And a Dog who must Face a Sumo Wrestler in Ancient Japan',2006,1,NULL,7,'4.99',152,'11.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (280,'EMPIRE MALKOVICH','A Amazing Story of a Feminist And a Cat who must Face a Car in An Abandoned Fun House',2006,1,NULL,7,'0.99',177,'26.99','G','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (281,'ENCINO ELF','A Astounding Drama of a Feminist And a Teacher who must Confront a Husband in A Baloon',2006,1,NULL,6,'0.99',143,'9.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (282,'ENCOUNTERS CURTAIN','A Insightful Epistle of a Pastry Chef And a Womanizer who must Build a Boat in New Orleans',2006,1,NULL,5,'0.99',92,'20.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (283,'ENDING CROWDS','A Unbelieveable Display of a Dentist And a Madman who must Vanquish a Squirrel in Berlin',2006,1,NULL,6,'0.99',85,'10.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (284,'ENEMY ODDS','A Fanciful Panorama of a Mad Scientist And a Woman who must Pursue a Astronaut in Ancient India',2006,1,NULL,5,'4.99',77,'23.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (285,'ENGLISH BULWORTH','A Intrepid Epistle of a Pastry Chef And a Pastry Chef who must Pursue a Crocodile in Ancient China',2006,1,NULL,3,'0.99',51,'18.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (286,'ENOUGH RAGING','A Astounding Character Study of a Boat And a Secret Agent who must Find a Mad Cow in The Sahara Desert',2006,1,NULL,7,'2.99',158,'16.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (287,'ENTRAPMENT SATISFACTION','A Thoughtful Panorama of a Hunter And a Teacher who must Reach a Mad Cow in A U-Boat',2006,1,NULL,5,'0.99',176,'19.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (288,'ESCAPE METROPOLIS','A Taut Yarn of a Astronaut And a Technical Writer who must Outgun a Boat in New Orleans',2006,1,NULL,7,'2.99',167,'20.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (289,'EVE RESURRECTION','A Awe-Inspiring Yarn of a Pastry Chef And a Database Administrator who must Challenge a Teacher in A Baloon',2006,1,NULL,5,'4.99',66,'25.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (290,'EVERYONE CRAFT','A Fateful Display of a Waitress And a Dentist who must Reach a Butler in Nigeria',2006,1,NULL,4,'0.99',163,'29.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (291,'EVOLUTION ALTER','A Fanciful Character Study of a Feminist And a Madman who must Find a Explorer in A Baloon Factory',2006,1,NULL,5,'0.99',174,'10.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (292,'EXCITEMENT EVE','A Brilliant Documentary of a Monkey And a Car who must Conquer a Crocodile in A Shark Tank',2006,1,NULL,3,'0.99',51,'20.99','G','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (293,'EXORCIST STING','A Touching Drama of a Dog And a Sumo Wrestler who must Conquer a Mad Scientist in Berlin',2006,1,NULL,6,'2.99',167,'17.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (294,'EXPECATIONS NATURAL','A Amazing Drama of a Butler And a Husband who must Reach a A Shark in A U-Boat',2006,1,NULL,5,'4.99',138,'26.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (295,'EXPENDABLE STALLION','A Amazing Character Study of a Mad Cow And a Squirrel who must Discover a Hunter in A U-Boat',2006,1,NULL,3,'0.99',97,'14.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (296,'EXPRESS LONELY','A Boring Drama of a Astronaut And a Boat who must Face a Boat in California',2006,1,NULL,5,'2.99',178,'23.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (297,'EXTRAORDINARY CONQUERER','A Stunning Story of a Dog And a Feminist who must Face a Forensic Psychologist in Berlin',2006,1,NULL,6,'2.99',122,'29.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (298,'EYES DRIVING','A Thrilling Story of a Cat And a Waitress who must Fight a Explorer in The Outback',2006,1,NULL,4,'2.99',172,'13.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (299,'FACTORY DRAGON','A Action-Packed Saga of a Teacher And a Frisbee who must Escape a Lumberjack in The Sahara Desert',2006,1,NULL,4,'0.99',144,'9.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (300,'FALCON VOLUME','A Fateful Saga of a Sumo Wrestler And a Hunter who must Redeem a A Shark in New Orleans',2006,1,NULL,5,'4.99',102,'21.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (301,'FAMILY SWEET','A Epic Documentary of a Teacher And a Boy who must Escape a Woman in Berlin',2006,1,NULL,4,'0.99',155,'24.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (302,'FANTASIA PARK','A Thoughtful Documentary of a Mad Scientist And a A Shark who must Outrace a Feminist in Australia',2006,1,NULL,5,'2.99',131,'29.99','G','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (303,'FANTASY TROOPERS','A Touching Saga of a Teacher And a Monkey who must Overcome a Secret Agent in A MySQL Convention',2006,1,NULL,6,'0.99',58,'27.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (304,'FARGO GANDHI','A Thrilling Reflection of a Pastry Chef And a Crocodile who must Reach a Teacher in The Outback',2006,1,NULL,3,'2.99',130,'28.99','G','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (305,'FATAL HAUNTED','A Beautiful Drama of a Student And a Secret Agent who must Confront a Dentist in Ancient Japan',2006,1,NULL,6,'2.99',91,'24.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (306,'FEATHERS METAL','A Thoughtful Yarn of a Monkey And a Teacher who must Find a Dog in Australia',2006,1,NULL,3,'0.99',104,'12.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (307,'FELLOWSHIP AUTUMN','A Lacklusture Reflection of a Dentist And a Hunter who must Meet a Teacher in A Baloon',2006,1,NULL,6,'4.99',77,'9.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (308,'FERRIS MOTHER','A Touching Display of a Frisbee And a Frisbee who must Kill a Girl in The Gulf of Mexico',2006,1,NULL,3,'2.99',142,'13.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (309,'FEUD FROGMEN','A Brilliant Reflection of a Database Administrator And a Mad Cow who must Chase a Woman in The Canadian Rockies',2006,1,NULL,6,'0.99',98,'29.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (310,'FEVER EMPIRE','A Insightful Panorama of a Cat And a Boat who must Defeat a Boat in The Gulf of Mexico',2006,1,NULL,5,'4.99',158,'20.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (311,'FICTION CHRISTMAS','A Emotional Yarn of a A Shark And a Student who must Battle a Robot in An Abandoned Mine Shaft',2006,1,NULL,4,'0.99',72,'14.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (312,'FIDDLER LOST','A Boring Tale of a Squirrel And a Dog who must Challenge a Madman in The Gulf of Mexico',2006,1,NULL,4,'4.99',75,'20.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (313,'FIDELITY DEVIL','A Awe-Inspiring Drama of a Technical Writer And a Composer who must Reach a Pastry Chef in A U-Boat',2006,1,NULL,5,'4.99',118,'11.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (314,'FIGHT JAWBREAKER','A Intrepid Panorama of a Womanizer And a Girl who must Escape a Girl in A Manhattan Penthouse',2006,1,NULL,3,'0.99',91,'13.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (315,'FINDING ANACONDA','A Fateful Tale of a Database Administrator And a Girl who must Battle a Squirrel in New Orleans',2006,1,NULL,4,'0.99',156,'10.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (316,'FIRE WOLVES','A Intrepid Documentary of a Frisbee And a Dog who must Outrace a Lumberjack in Nigeria',2006,1,NULL,5,'4.99',173,'18.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (317,'FIREBALL PHILADELPHIA','A Amazing Yarn of a Dentist And a A Shark who must Vanquish a Madman in An Abandoned Mine Shaft',2006,1,NULL,4,'0.99',148,'25.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (318,'FIREHOUSE VIETNAM','A Awe-Inspiring Character Study of a Boat And a Boy who must Kill a Pastry Chef in The Sahara Desert',2006,1,NULL,7,'0.99',103,'14.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (319,'FISH OPUS','A Touching Display of a Feminist And a Girl who must Confront a Astronaut in Australia',2006,1,NULL,4,'2.99',125,'22.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (320,'FLAMINGOS CONNECTICUT','A Fast-Paced Reflection of a Composer And a Composer who must Meet a Cat in The Sahara Desert',2006,1,NULL,4,'4.99',80,'28.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (321,'FLASH WARS','A Astounding Saga of a Moose And a Pastry Chef who must Chase a Student in The Gulf of Mexico',2006,1,NULL,3,'4.99',123,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (322,'FLATLINERS KILLER','A Taut Display of a Secret Agent And a Waitress who must Sink a Robot in An Abandoned Mine Shaft',2006,1,NULL,5,'2.99',100,'29.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (323,'FLIGHT LIES','A Stunning Character Study of a Crocodile And a Pioneer who must Pursue a Teacher in New Orleans',2006,1,NULL,7,'4.99',179,'22.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (324,'FLINTSTONES HAPPINESS','A Fateful Story of a Husband And a Moose who must Vanquish a Boy in California',2006,1,NULL,3,'4.99',148,'11.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (325,'FLOATS GARDEN','A Action-Packed Epistle of a Robot And a Car who must Chase a Boat in Ancient Japan',2006,1,NULL,6,'2.99',145,'29.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (326,'FLYING HOOK','A Thrilling Display of a Mad Cow And a Dog who must Challenge a Frisbee in Nigeria',2006,1,NULL,6,'2.99',69,'18.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (327,'FOOL MOCKINGBIRD','A Lacklusture Tale of a Crocodile And a Composer who must Defeat a Madman in A U-Boat',2006,1,NULL,3,'4.99',158,'24.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (328,'FOREVER CANDIDATE','A Unbelieveable Panorama of a Technical Writer And a Man who must Pursue a Frisbee in A U-Boat',2006,1,NULL,7,'2.99',131,'28.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (329,'FORREST SONS','A Thrilling Documentary of a Forensic Psychologist And a Butler who must Defeat a Explorer in A Jet Boat',2006,1,NULL,4,'2.99',63,'15.99','R','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (330,'FORRESTER COMANCHEROS','A Fateful Tale of a Squirrel And a Forensic Psychologist who must Redeem a Man in Nigeria',2006,1,NULL,7,'4.99',112,'22.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (331,'FORWARD TEMPLE','A Astounding Display of a Forensic Psychologist And a Mad Scientist who must Challenge a Girl in New Orleans',2006,1,NULL,6,'2.99',90,'25.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (332,'FRANKENSTEIN STRANGER','A Insightful Character Study of a Feminist And a Pioneer who must Pursue a Pastry Chef in Nigeria',2006,1,NULL,7,'0.99',159,'16.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (333,'FREAKY POCUS','A Fast-Paced Documentary of a Pastry Chef And a Crocodile who must Chase a Squirrel in The Gulf of Mexico',2006,1,NULL,7,'2.99',126,'16.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (334,'FREDDY STORM','A Intrepid Saga of a Man And a Lumberjack who must Vanquish a Husband in The Outback',2006,1,NULL,6,'4.99',65,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (335,'FREEDOM CLEOPATRA','A Emotional Reflection of a Dentist And a Mad Cow who must Face a Squirrel in A Baloon',2006,1,NULL,5,'0.99',133,'23.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (336,'FRENCH HOLIDAY','A Thrilling Epistle of a Dog And a Feminist who must Kill a Madman in Berlin',2006,1,NULL,5,'4.99',99,'22.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (337,'FRIDA SLIPPER','A Fateful Story of a Lumberjack And a Car who must Escape a Boat in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',73,'11.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (338,'FRISCO FORREST','A Beautiful Documentary of a Woman And a Pioneer who must Pursue a Mad Scientist in A Shark Tank',2006,1,NULL,6,'4.99',51,'23.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (339,'FROGMEN BREAKING','A Unbelieveable Yarn of a Mad Scientist And a Cat who must Chase a Lumberjack in Australia',2006,1,NULL,5,'0.99',111,'17.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (340,'FRONTIER CABIN','A Emotional Story of a Madman And a Waitress who must Battle a Teacher in An Abandoned Fun House',2006,1,NULL,6,'4.99',183,'14.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (341,'FROST HEAD','A Amazing Reflection of a Lumberjack And a Cat who must Discover a Husband in A MySQL Convention',2006,1,NULL,5,'0.99',82,'13.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (342,'FUGITIVE MAGUIRE','A Taut Epistle of a Feminist And a Sumo Wrestler who must Battle a Crocodile in Australia',2006,1,NULL,7,'4.99',83,'28.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (343,'FULL FLATLINERS','A Beautiful Documentary of a Astronaut And a Moose who must Pursue a Monkey in A Shark Tank',2006,1,NULL,6,'2.99',94,'14.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (344,'FURY MURDER','A Lacklusture Reflection of a Boat And a Forensic Psychologist who must Fight a Waitress in A Monastery',2006,1,NULL,3,'0.99',178,'28.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (345,'GABLES METROPOLIS','A Fateful Display of a Cat And a Pioneer who must Challenge a Pastry Chef in A Baloon Factory',2006,1,NULL,3,'0.99',161,'17.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (346,'GALAXY SWEETHEARTS','A Emotional Reflection of a Womanizer And a Pioneer who must Face a Squirrel in Berlin',2006,1,NULL,4,'4.99',128,'13.99','R','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (347,'GAMES BOWFINGER','A Astounding Documentary of a Butler And a Explorer who must Challenge a Butler in A Monastery',2006,1,NULL,7,'4.99',119,'17.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (348,'GANDHI KWAI','A Thoughtful Display of a Mad Scientist And a Secret Agent who must Chase a Boat in Berlin',2006,1,NULL,7,'0.99',86,'9.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (349,'GANGS PRIDE','A Taut Character Study of a Woman And a A Shark who must Confront a Frisbee in Berlin',2006,1,NULL,4,'2.99',185,'27.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (350,'GARDEN ISLAND','A Unbelieveable Character Study of a Womanizer And a Madman who must Reach a Man in The Outback',2006,1,NULL,3,'4.99',80,'21.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (351,'GASLIGHT CRUSADE','A Amazing Epistle of a Boy And a Astronaut who must Redeem a Man in The Gulf of Mexico',2006,1,NULL,4,'2.99',106,'10.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (352,'GATHERING CALENDAR','A Intrepid Tale of a Pioneer And a Moose who must Conquer a Frisbee in A MySQL Convention',2006,1,NULL,4,'0.99',176,'22.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (353,'GENTLEMEN STAGE','A Awe-Inspiring Reflection of a Monkey And a Student who must Overcome a Dentist in The First Manned Space Station',2006,1,NULL,6,'2.99',125,'22.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (354,'GHOST GROUNDHOG','A Brilliant Panorama of a Madman And a Composer who must Succumb a Car in Ancient India',2006,1,NULL,6,'4.99',85,'18.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (355,'GHOSTBUSTERS ELF','A Thoughtful Epistle of a Dog And a Feminist who must Chase a Composer in Berlin',2006,1,NULL,7,'0.99',101,'18.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (356,'GIANT TROOPERS','A Fateful Display of a Feminist And a Monkey who must Vanquish a Monkey in The Canadian Rockies',2006,1,NULL,5,'2.99',102,'10.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (357,'GILBERT PELICAN','A Fateful Tale of a Man And a Feminist who must Conquer a Crocodile in A Manhattan Penthouse',2006,1,NULL,7,'0.99',114,'13.99','G','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (358,'GILMORE BOILED','A Unbelieveable Documentary of a Boat And a Husband who must Succumb a Student in A U-Boat',2006,1,NULL,5,'0.99',163,'29.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (359,'GLADIATOR WESTWARD','A Astounding Reflection of a Squirrel And a Sumo Wrestler who must Sink a Dentist in Ancient Japan',2006,1,NULL,6,'4.99',173,'20.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (360,'GLASS DYING','A Astounding Drama of a Frisbee And a Astronaut who must Fight a Dog in Ancient Japan',2006,1,NULL,4,'0.99',103,'24.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (361,'GLEAMING JAWBREAKER','A Amazing Display of a Composer And a Forensic Psychologist who must Discover a Car in The Canadian Rockies',2006,1,NULL,5,'2.99',89,'25.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (362,'GLORY TRACY','A Amazing Saga of a Woman And a Womanizer who must Discover a Cat in The First Manned Space Station',2006,1,NULL,7,'2.99',115,'13.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (363,'GO PURPLE','A Fast-Paced Display of a Car And a Database Administrator who must Battle a Woman in A Baloon',2006,1,NULL,3,'0.99',54,'12.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (364,'GODFATHER DIARY','A Stunning Saga of a Lumberjack And a Squirrel who must Chase a Car in The Outback',2006,1,NULL,3,'2.99',73,'14.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (365,'GOLD RIVER','A Taut Documentary of a Database Administrator And a Waitress who must Reach a Mad Scientist in A Baloon Factory',2006,1,NULL,4,'4.99',154,'21.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (366,'GOLDFINGER SENSIBILITY','A Insightful Drama of a Mad Scientist And a Hunter who must Defeat a Pastry Chef in New Orleans',2006,1,NULL,3,'0.99',93,'29.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (367,'GOLDMINE TYCOON','A Brilliant Epistle of a Composer And a Frisbee who must Conquer a Husband in The Outback',2006,1,NULL,6,'0.99',153,'20.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (368,'GONE TROUBLE','A Insightful Character Study of a Mad Cow And a Forensic Psychologist who must Conquer a A Shark in A Manhattan Penthouse',2006,1,NULL,7,'2.99',84,'20.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (369,'GOODFELLAS SALUTE','A Unbelieveable Tale of a Dog And a Explorer who must Sink a Mad Cow in A Baloon Factory',2006,1,NULL,4,'4.99',56,'22.99','PG','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (370,'GORGEOUS BINGO','A Action-Packed Display of a Sumo Wrestler And a Car who must Overcome a Waitress in A Baloon Factory',2006,1,NULL,4,'2.99',108,'26.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (371,'GOSFORD DONNIE','A Epic Panorama of a Mad Scientist And a Monkey who must Redeem a Secret Agent in Berlin',2006,1,NULL,5,'4.99',129,'17.99','G','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (372,'GRACELAND DYNAMITE','A Taut Display of a Cat And a Girl who must Overcome a Database Administrator in New Orleans',2006,1,NULL,5,'4.99',140,'26.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (373,'GRADUATE LORD','A Lacklusture Epistle of a Girl And a A Shark who must Meet a Mad Scientist in Ancient China',2006,1,NULL,7,'2.99',156,'14.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (374,'GRAFFITI LOVE','A Unbelieveable Epistle of a Sumo Wrestler And a Hunter who must Build a Composer in Berlin',2006,1,NULL,3,'0.99',117,'29.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (375,'GRAIL FRANKENSTEIN','A Unbelieveable Saga of a Teacher And a Monkey who must Fight a Girl in An Abandoned Mine Shaft',2006,1,NULL,4,'2.99',85,'17.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (376,'GRAPES FURY','A Boring Yarn of a Mad Cow And a Sumo Wrestler who must Meet a Robot in Australia',2006,1,NULL,4,'0.99',155,'20.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (377,'GREASE YOUTH','A Emotional Panorama of a Secret Agent And a Waitress who must Escape a Composer in Soviet Georgia',2006,1,NULL,7,'0.99',135,'20.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (378,'GREATEST NORTH','A Astounding Character Study of a Secret Agent And a Robot who must Build a A Shark in Berlin',2006,1,NULL,5,'2.99',93,'24.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (379,'GREEDY ROOTS','A Amazing Reflection of a A Shark And a Butler who must Chase a Hunter in The Canadian Rockies',2006,1,NULL,7,'0.99',166,'14.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (380,'GREEK EVERYONE','A Stunning Display of a Butler And a Teacher who must Confront a A Shark in The First Manned Space Station',2006,1,NULL,7,'2.99',176,'11.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (381,'GRINCH MASSAGE','A Intrepid Display of a Madman And a Feminist who must Pursue a Pioneer in The First Manned Space Station',2006,1,NULL,7,'4.99',150,'25.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (382,'GRIT CLOCKWORK','A Thoughtful Display of a Dentist And a Squirrel who must Confront a Lumberjack in A Shark Tank',2006,1,NULL,3,'0.99',137,'21.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (383,'GROOVE FICTION','A Unbelieveable Reflection of a Moose And a A Shark who must Defeat a Lumberjack in An Abandoned Mine Shaft',2006,1,NULL,6,'0.99',111,'13.99','NC-17','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (384,'GROSSE WONDERFUL','A Epic Drama of a Cat And a Explorer who must Redeem a Moose in Australia',2006,1,NULL,5,'4.99',49,'19.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (385,'GROUNDHOG UNCUT','A Brilliant Panorama of a Astronaut And a Technical Writer who must Discover a Butler in A Manhattan Penthouse',2006,1,NULL,6,'4.99',139,'26.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (386,'GUMP DATE','A Intrepid Yarn of a Explorer And a Student who must Kill a Husband in An Abandoned Mine Shaft',2006,1,NULL,3,'4.99',53,'12.99','NC-17','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (387,'GUN BONNIE','A Boring Display of a Sumo Wrestler And a Husband who must Build a Waitress in The Gulf of Mexico',2006,1,NULL,7,'0.99',100,'27.99','G','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (388,'GUNFIGHT MOON','A Epic Reflection of a Pastry Chef And a Explorer who must Reach a Dentist in The Sahara Desert',2006,1,NULL,5,'0.99',70,'16.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (389,'GUNFIGHTER MUSSOLINI','A Touching Saga of a Robot And a Boy who must Kill a Man in Ancient Japan',2006,1,NULL,3,'2.99',127,'9.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (390,'GUYS FALCON','A Boring Story of a Woman And a Feminist who must Redeem a Squirrel in A U-Boat',2006,1,NULL,4,'4.99',84,'20.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (391,'HALF OUTFIELD','A Epic Epistle of a Database Administrator And a Crocodile who must Face a Madman in A Jet Boat',2006,1,NULL,6,'2.99',146,'25.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (392,'HALL CASSIDY','A Beautiful Panorama of a Pastry Chef And a A Shark who must Battle a Pioneer in Soviet Georgia',2006,1,NULL,5,'4.99',51,'13.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (393,'HALLOWEEN NUTS','A Amazing Panorama of a Forensic Psychologist And a Technical Writer who must Fight a Dentist in A U-Boat',2006,1,NULL,6,'2.99',47,'19.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (394,'HAMLET WISDOM','A Touching Reflection of a Man And a Man who must Sink a Robot in The Outback',2006,1,NULL,7,'2.99',146,'21.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (395,'HANDICAP BOONDOCK','A Beautiful Display of a Pioneer And a Squirrel who must Vanquish a Sumo Wrestler in Soviet Georgia',2006,1,NULL,4,'0.99',108,'28.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (396,'HANGING DEEP','A Action-Packed Yarn of a Boat And a Crocodile who must Build a Monkey in Berlin',2006,1,NULL,5,'4.99',62,'18.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (397,'HANKY OCTOBER','A Boring Epistle of a Database Administrator And a Explorer who must Pursue a Madman in Soviet Georgia',2006,1,NULL,5,'2.99',107,'26.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (398,'HANOVER GALAXY','A Stunning Reflection of a Girl And a Secret Agent who must Succumb a Boy in A MySQL Convention',2006,1,NULL,5,'4.99',47,'21.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (399,'HAPPINESS UNITED','A Action-Packed Panorama of a Husband And a Feminist who must Meet a Forensic Psychologist in Ancient Japan',2006,1,NULL,6,'2.99',100,'23.99','G','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (400,'HARDLY ROBBERS','A Emotional Character Study of a Hunter And a Car who must Kill a Woman in Berlin',2006,1,NULL,7,'2.99',72,'15.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (401,'HAROLD FRENCH','A Stunning Saga of a Sumo Wrestler And a Student who must Outrace a Moose in The Sahara Desert',2006,1,NULL,6,'0.99',168,'10.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (402,'HARPER DYING','A Awe-Inspiring Reflection of a Woman And a Cat who must Confront a Feminist in The Sahara Desert',2006,1,NULL,3,'0.99',52,'15.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (403,'HARRY IDAHO','A Taut Yarn of a Technical Writer And a Feminist who must Outrace a Dog in California',2006,1,NULL,5,'4.99',121,'18.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (404,'HATE HANDICAP','A Intrepid Reflection of a Mad Scientist And a Pioneer who must Overcome a Hunter in The First Manned Space Station',2006,1,NULL,4,'0.99',107,'26.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (405,'HAUNTED ANTITRUST','A Amazing Saga of a Man And a Dentist who must Reach a Technical Writer in Ancient India',2006,1,NULL,6,'4.99',76,'13.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (406,'HAUNTING PIANIST','A Fast-Paced Story of a Database Administrator And a Composer who must Defeat a Squirrel in An Abandoned Amusement Park',2006,1,NULL,5,'0.99',181,'22.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (407,'HAWK CHILL','A Action-Packed Drama of a Mad Scientist And a Composer who must Outgun a Car in Australia',2006,1,NULL,5,'0.99',47,'12.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (408,'HEAD STRANGER','A Thoughtful Saga of a Hunter And a Crocodile who must Confront a Dog in The Gulf of Mexico',2006,1,NULL,4,'4.99',69,'28.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (409,'HEARTBREAKERS BRIGHT','A Awe-Inspiring Documentary of a A Shark And a Dentist who must Outrace a Pastry Chef in The Canadian Rockies',2006,1,NULL,3,'4.99',59,'9.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (410,'HEAVEN FREEDOM','A Intrepid Story of a Butler And a Car who must Vanquish a Man in New Orleans',2006,1,NULL,7,'2.99',48,'19.99','PG','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (411,'HEAVENLY GUN','A Beautiful Yarn of a Forensic Psychologist And a Frisbee who must Battle a Moose in A Jet Boat',2006,1,NULL,5,'4.99',49,'13.99','NC-17','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (412,'HEAVYWEIGHTS BEAST','A Unbelieveable Story of a Composer And a Dog who must Overcome a Womanizer in An Abandoned Amusement Park',2006,1,NULL,6,'4.99',102,'25.99','G','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (413,'HEDWIG ALTER','A Action-Packed Yarn of a Womanizer And a Lumberjack who must Chase a Sumo Wrestler in A Monastery',2006,1,NULL,7,'2.99',169,'16.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (414,'HELLFIGHTERS SIERRA','A Taut Reflection of a A Shark And a Dentist who must Battle a Boat in Soviet Georgia',2006,1,NULL,3,'2.99',75,'23.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (415,'HIGH ENCINO','A Fateful Saga of a Waitress And a Hunter who must Outrace a Sumo Wrestler in Australia',2006,1,NULL,3,'2.99',84,'23.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (416,'HIGHBALL POTTER','A Action-Packed Saga of a Husband And a Dog who must Redeem a Database Administrator in The Sahara Desert',2006,1,NULL,6,'0.99',110,'10.99','R','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (417,'HILLS NEIGHBORS','A Epic Display of a Hunter And a Feminist who must Sink a Car in A U-Boat',2006,1,NULL,5,'0.99',93,'29.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (418,'HOBBIT ALIEN','A Emotional Drama of a Husband And a Girl who must Outgun a Composer in The First Manned Space Station',2006,1,NULL,5,'0.99',157,'27.99','PG-13','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (419,'HOCUS FRIDA','A Awe-Inspiring Tale of a Girl And a Madman who must Outgun a Student in A Shark Tank',2006,1,NULL,4,'2.99',141,'19.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (420,'HOLES BRANNIGAN','A Fast-Paced Reflection of a Technical Writer And a Student who must Fight a Boy in The Canadian Rockies',2006,1,NULL,7,'4.99',128,'27.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (421,'HOLIDAY GAMES','A Insightful Reflection of a Waitress And a Madman who must Pursue a Boy in Ancient Japan',2006,1,NULL,7,'4.99',78,'10.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (422,'HOLLOW JEOPARDY','A Beautiful Character Study of a Robot And a Astronaut who must Overcome a Boat in A Monastery',2006,1,NULL,7,'4.99',136,'25.99','NC-17','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (423,'HOLLYWOOD ANONYMOUS','A Fast-Paced Epistle of a Boy And a Explorer who must Escape a Dog in A U-Boat',2006,1,NULL,7,'0.99',69,'29.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (424,'HOLOCAUST HIGHBALL','A Awe-Inspiring Yarn of a Composer And a Man who must Find a Robot in Soviet Georgia',2006,1,NULL,6,'0.99',149,'12.99','R','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (425,'HOLY TADPOLE','A Action-Packed Display of a Feminist And a Pioneer who must Pursue a Dog in A Baloon Factory',2006,1,NULL,6,'0.99',88,'20.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (426,'HOME PITY','A Touching Panorama of a Man And a Secret Agent who must Challenge a Teacher in A MySQL Convention',2006,1,NULL,7,'4.99',185,'15.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (427,'HOMEWARD CIDER','A Taut Reflection of a Astronaut And a Squirrel who must Fight a Squirrel in A Manhattan Penthouse',2006,1,NULL,5,'0.99',103,'19.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (428,'HOMICIDE PEACH','A Astounding Documentary of a Hunter And a Boy who must Confront a Boy in A MySQL Convention',2006,1,NULL,6,'2.99',141,'21.99','PG-13','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (429,'HONEY TIES','A Taut Story of a Waitress And a Crocodile who must Outrace a Lumberjack in A Shark Tank',2006,1,NULL,3,'0.99',84,'29.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (430,'HOOK CHARIOTS','A Insightful Story of a Boy And a Dog who must Redeem a Boy in Australia',2006,1,NULL,7,'0.99',49,'23.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (431,'HOOSIERS BIRDCAGE','A Astounding Display of a Explorer And a Boat who must Vanquish a Car in The First Manned Space Station',2006,1,NULL,3,'2.99',176,'12.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (432,'HOPE TOOTSIE','A Amazing Documentary of a Student And a Sumo Wrestler who must Outgun a A Shark in A Shark Tank',2006,1,NULL,4,'2.99',139,'22.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (433,'HORN WORKING','A Stunning Display of a Mad Scientist And a Technical Writer who must Succumb a Monkey in A Shark Tank',2006,1,NULL,4,'2.99',95,'23.99','PG','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (434,'HORROR REIGN','A Touching Documentary of a A Shark And a Car who must Build a Husband in Nigeria',2006,1,NULL,3,'0.99',139,'25.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (435,'HOTEL HAPPINESS','A Thrilling Yarn of a Pastry Chef And a A Shark who must Challenge a Mad Scientist in The Outback',2006,1,NULL,6,'4.99',181,'28.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (436,'HOURS RAGE','A Fateful Story of a Explorer And a Feminist who must Meet a Technical Writer in Soviet Georgia',2006,1,NULL,4,'0.99',122,'14.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (437,'HOUSE DYNAMITE','A Taut Story of a Pioneer And a Squirrel who must Battle a Student in Soviet Georgia',2006,1,NULL,7,'2.99',109,'13.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (438,'HUMAN GRAFFITI','A Beautiful Reflection of a Womanizer And a Sumo Wrestler who must Chase a Database Administrator in The Gulf of Mexico',2006,1,NULL,3,'2.99',68,'22.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (439,'HUNCHBACK IMPOSSIBLE','A Touching Yarn of a Frisbee And a Dentist who must Fight a Composer in Ancient Japan',2006,1,NULL,4,'4.99',151,'28.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (440,'HUNGER ROOF','A Unbelieveable Yarn of a Student And a Database Administrator who must Outgun a Husband in An Abandoned Mine Shaft',2006,1,NULL,6,'0.99',105,'21.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (441,'HUNTER ALTER','A Emotional Drama of a Mad Cow And a Boat who must Redeem a Secret Agent in A Shark Tank',2006,1,NULL,5,'2.99',125,'21.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (442,'HUNTING MUSKETEERS','A Thrilling Reflection of a Pioneer And a Dentist who must Outrace a Womanizer in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',65,'24.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (443,'HURRICANE AFFAIR','A Lacklusture Epistle of a Database Administrator And a Woman who must Meet a Hunter in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',49,'11.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (444,'HUSTLER PARTY','A Emotional Reflection of a Sumo Wrestler And a Monkey who must Conquer a Robot in The Sahara Desert',2006,1,NULL,3,'4.99',83,'22.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (445,'HYDE DOCTOR','A Fanciful Documentary of a Boy And a Woman who must Redeem a Womanizer in A Jet Boat',2006,1,NULL,5,'2.99',100,'11.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (446,'HYSTERICAL GRAIL','A Amazing Saga of a Madman And a Dentist who must Build a Car in A Manhattan Penthouse',2006,1,NULL,5,'4.99',150,'19.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (447,'ICE CROSSING','A Fast-Paced Tale of a Butler And a Moose who must Overcome a Pioneer in A Manhattan Penthouse',2006,1,NULL,5,'2.99',131,'28.99','R','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (448,'IDAHO LOVE','A Fast-Paced Drama of a Student And a Crocodile who must Meet a Database Administrator in The Outback',2006,1,NULL,3,'2.99',172,'25.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (449,'IDENTITY LOVER','A Boring Tale of a Composer And a Mad Cow who must Defeat a Car in The Outback',2006,1,NULL,4,'2.99',119,'12.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (450,'IDOLS SNATCHERS','A Insightful Drama of a Car And a Composer who must Fight a Man in A Monastery',2006,1,NULL,5,'2.99',84,'29.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (451,'IGBY MAKER','A Epic Documentary of a Hunter And a Dog who must Outgun a Dog in A Baloon Factory',2006,1,NULL,7,'4.99',160,'12.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (452,'ILLUSION AMELIE','A Emotional Epistle of a Boat And a Mad Scientist who must Outrace a Robot in An Abandoned Mine Shaft',2006,1,NULL,4,'0.99',122,'15.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (453,'IMAGE PRINCESS','A Lacklusture Panorama of a Secret Agent And a Crocodile who must Discover a Madman in The Canadian Rockies',2006,1,NULL,3,'2.99',178,'17.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (454,'IMPACT ALADDIN','A Epic Character Study of a Frisbee And a Moose who must Outgun a Technical Writer in A Shark Tank',2006,1,NULL,6,'0.99',180,'20.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (455,'IMPOSSIBLE PREJUDICE','A Awe-Inspiring Yarn of a Monkey And a Hunter who must Chase a Teacher in Ancient China',2006,1,NULL,7,'4.99',103,'11.99','NC-17','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (456,'INCH JET','A Fateful Saga of a Womanizer And a Student who must Defeat a Butler in A Monastery',2006,1,NULL,6,'4.99',167,'18.99','NC-17','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (457,'INDEPENDENCE HOTEL','A Thrilling Tale of a Technical Writer And a Boy who must Face a Pioneer in A Monastery',2006,1,NULL,5,'0.99',157,'21.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (458,'INDIAN LOVE','A Insightful Saga of a Mad Scientist And a Mad Scientist who must Kill a Astronaut in An Abandoned Fun House',2006,1,NULL,4,'0.99',135,'26.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (459,'INFORMER DOUBLE','A Action-Packed Display of a Woman And a Dentist who must Redeem a Forensic Psychologist in The Canadian Rockies',2006,1,NULL,4,'4.99',74,'23.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (460,'INNOCENT USUAL','A Beautiful Drama of a Pioneer And a Crocodile who must Challenge a Student in The Outback',2006,1,NULL,3,'4.99',178,'26.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (461,'INSECTS STONE','A Epic Display of a Butler And a Dog who must Vanquish a Crocodile in A Manhattan Penthouse',2006,1,NULL,3,'0.99',123,'14.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (462,'INSIDER ARIZONA','A Astounding Saga of a Mad Scientist And a Hunter who must Pursue a Robot in A Baloon Factory',2006,1,NULL,5,'2.99',78,'17.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (463,'INSTINCT AIRPORT','A Touching Documentary of a Mad Cow And a Explorer who must Confront a Butler in A Manhattan Penthouse',2006,1,NULL,4,'2.99',116,'21.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (464,'INTENTIONS EMPIRE','A Astounding Epistle of a Cat And a Cat who must Conquer a Mad Cow in A U-Boat',2006,1,NULL,3,'2.99',107,'13.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (465,'INTERVIEW LIAISONS','A Action-Packed Reflection of a Student And a Butler who must Discover a Database Administrator in A Manhattan Penthouse',2006,1,NULL,4,'4.99',59,'17.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (466,'INTOLERABLE INTENTIONS','A Awe-Inspiring Story of a Monkey And a Pastry Chef who must Succumb a Womanizer in A MySQL Convention',2006,1,NULL,6,'4.99',63,'20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (467,'INTRIGUE WORST','A Fanciful Character Study of a Explorer And a Mad Scientist who must Vanquish a Squirrel in A Jet Boat',2006,1,NULL,6,'0.99',181,'10.99','G','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (468,'INVASION CYCLONE','A Lacklusture Character Study of a Mad Scientist And a Womanizer who must Outrace a Explorer in A Monastery',2006,1,NULL,5,'2.99',97,'12.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (469,'IRON MOON','A Fast-Paced Documentary of a Mad Cow And a Boy who must Pursue a Dentist in A Baloon',2006,1,NULL,7,'4.99',46,'27.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (470,'ISHTAR ROCKETEER','A Astounding Saga of a Dog And a Squirrel who must Conquer a Dog in An Abandoned Fun House',2006,1,NULL,4,'4.99',79,'24.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (471,'ISLAND EXORCIST','A Fanciful Panorama of a Technical Writer And a Boy who must Find a Dentist in An Abandoned Fun House',2006,1,NULL,7,'2.99',84,'23.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (472,'ITALIAN AFRICAN','A Astounding Character Study of a Monkey And a Moose who must Outgun a Cat in A U-Boat',2006,1,NULL,3,'4.99',174,'24.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (473,'JACKET FRISCO','A Insightful Reflection of a Womanizer And a Husband who must Conquer a Pastry Chef in A Baloon',2006,1,NULL,5,'2.99',181,'16.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (474,'JADE BUNCH','A Insightful Panorama of a Squirrel And a Mad Cow who must Confront a Student in The First Manned Space Station',2006,1,NULL,6,'2.99',174,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (475,'JAPANESE RUN','A Awe-Inspiring Epistle of a Feminist And a Girl who must Sink a Girl in The Outback',2006,1,NULL,6,'0.99',135,'29.99','G','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (476,'JASON TRAP','A Thoughtful Tale of a Woman And a A Shark who must Conquer a Dog in A Monastery',2006,1,NULL,5,'2.99',130,'9.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (477,'JAWBREAKER BROOKLYN','A Stunning Reflection of a Boat And a Pastry Chef who must Succumb a A Shark in A Jet Boat',2006,1,NULL,5,'0.99',118,'15.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (478,'JAWS HARRY','A Thrilling Display of a Database Administrator And a Monkey who must Overcome a Dog in An Abandoned Fun House',2006,1,NULL,4,'2.99',112,'10.99','G','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (479,'JEDI BENEATH','A Astounding Reflection of a Explorer And a Dentist who must Pursue a Student in Nigeria',2006,1,NULL,7,'0.99',128,'12.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (480,'JEEPERS WEDDING','A Astounding Display of a Composer And a Dog who must Kill a Pastry Chef in Soviet Georgia',2006,1,NULL,3,'2.99',84,'29.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (481,'JEKYLL FROGMEN','A Fanciful Epistle of a Student And a Astronaut who must Kill a Waitress in A Shark Tank',2006,1,NULL,4,'2.99',58,'22.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (482,'JEOPARDY ENCINO','A Boring Panorama of a Man And a Mad Cow who must Face a Explorer in Ancient India',2006,1,NULL,3,'0.99',102,'12.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (483,'JERICHO MULAN','A Amazing Yarn of a Hunter And a Butler who must Defeat a Boy in A Jet Boat',2006,1,NULL,3,'2.99',171,'29.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (484,'JERK PAYCHECK','A Touching Character Study of a Pastry Chef And a Database Administrator who must Reach a A Shark in Ancient Japan',2006,1,NULL,3,'2.99',172,'13.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (485,'JERSEY SASSY','A Lacklusture Documentary of a Madman And a Mad Cow who must Find a Feminist in Ancient Japan',2006,1,NULL,6,'4.99',60,'16.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (486,'JET NEIGHBORS','A Amazing Display of a Lumberjack And a Teacher who must Outrace a Woman in A U-Boat',2006,1,NULL,7,'4.99',59,'14.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (487,'JINGLE SAGEBRUSH','A Epic Character Study of a Feminist And a Student who must Meet a Woman in A Baloon',2006,1,NULL,6,'4.99',124,'29.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (488,'JOON NORTHWEST','A Thrilling Panorama of a Technical Writer And a Car who must Discover a Forensic Psychologist in A Shark Tank',2006,1,NULL,3,'0.99',105,'23.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (489,'JUGGLER HARDLY','A Epic Story of a Mad Cow And a Astronaut who must Challenge a Car in California',2006,1,NULL,4,'0.99',54,'14.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (490,'JUMANJI BLADE','A Intrepid Yarn of a Husband And a Womanizer who must Pursue a Mad Scientist in New Orleans',2006,1,NULL,4,'2.99',121,'13.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (491,'JUMPING WRATH','A Touching Epistle of a Monkey And a Feminist who must Discover a Boat in Berlin',2006,1,NULL,4,'0.99',74,'18.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (492,'JUNGLE CLOSER','A Boring Character Study of a Boy And a Woman who must Battle a Astronaut in Australia',2006,1,NULL,6,'0.99',134,'11.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (493,'KANE EXORCIST','A Epic Documentary of a Composer And a Robot who must Overcome a Car in Berlin',2006,1,NULL,5,'0.99',92,'18.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (494,'KARATE MOON','A Astounding Yarn of a Womanizer And a Dog who must Reach a Waitress in A MySQL Convention',2006,1,NULL,4,'0.99',120,'21.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (495,'KENTUCKIAN GIANT','A Stunning Yarn of a Woman And a Frisbee who must Escape a Waitress in A U-Boat',2006,1,NULL,5,'2.99',169,'10.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (496,'KICK SAVANNAH','A Emotional Drama of a Monkey And a Robot who must Defeat a Monkey in New Orleans',2006,1,NULL,3,'0.99',179,'10.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (497,'KILL BROTHERHOOD','A Touching Display of a Hunter And a Secret Agent who must Redeem a Husband in The Outback',2006,1,NULL,4,'0.99',54,'15.99','G','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (498,'KILLER INNOCENT','A Fanciful Character Study of a Student And a Explorer who must Succumb a Composer in An Abandoned Mine Shaft',2006,1,NULL,7,'2.99',161,'11.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (499,'KING EVOLUTION','A Action-Packed Tale of a Boy And a Lumberjack who must Chase a Madman in A Baloon',2006,1,NULL,3,'4.99',184,'24.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (500,'KISS GLORY','A Lacklusture Reflection of a Girl And a Husband who must Find a Robot in The Canadian Rockies',2006,1,NULL,5,'4.99',163,'11.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (501,'KISSING DOLLS','A Insightful Reflection of a Pioneer And a Teacher who must Build a Composer in The First Manned Space Station',2006,1,NULL,3,'4.99',141,'9.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (502,'KNOCK WARLOCK','A Unbelieveable Story of a Teacher And a Boat who must Confront a Moose in A Baloon',2006,1,NULL,4,'2.99',71,'21.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (503,'KRAMER CHOCOLATE','A Amazing Yarn of a Robot And a Pastry Chef who must Redeem a Mad Scientist in The Outback',2006,1,NULL,3,'2.99',171,'24.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (504,'KWAI HOMEWARD','A Amazing Drama of a Car And a Squirrel who must Pursue a Car in Soviet Georgia',2006,1,NULL,5,'0.99',46,'25.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (505,'LABYRINTH LEAGUE','A Awe-Inspiring Saga of a Composer And a Frisbee who must Succumb a Pioneer in The Sahara Desert',2006,1,NULL,6,'2.99',46,'24.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (506,'LADY STAGE','A Beautiful Character Study of a Woman And a Man who must Pursue a Explorer in A U-Boat',2006,1,NULL,4,'4.99',67,'14.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (507,'LADYBUGS ARMAGEDDON','A Fateful Reflection of a Dog And a Mad Scientist who must Meet a Mad Scientist in New Orleans',2006,1,NULL,4,'0.99',113,'13.99','NC-17','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (508,'LAMBS CINCINATTI','A Insightful Story of a Man And a Feminist who must Fight a Composer in Australia',2006,1,NULL,6,'4.99',144,'18.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (509,'LANGUAGE COWBOY','A Epic Yarn of a Cat And a Madman who must Vanquish a Dentist in An Abandoned Amusement Park',2006,1,NULL,5,'0.99',78,'26.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (510,'LAWLESS VISION','A Insightful Yarn of a Boy And a Sumo Wrestler who must Outgun a Car in The Outback',2006,1,NULL,6,'4.99',181,'29.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (511,'LAWRENCE LOVE','A Fanciful Yarn of a Database Administrator And a Mad Cow who must Pursue a Womanizer in Berlin',2006,1,NULL,7,'0.99',175,'23.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (512,'LEAGUE HELLFIGHTERS','A Thoughtful Saga of a A Shark And a Monkey who must Outgun a Student in Ancient China',2006,1,NULL,5,'4.99',110,'25.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (513,'LEATHERNECKS DWARFS','A Fateful Reflection of a Dog And a Mad Cow who must Outrace a Teacher in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',153,'21.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (514,'LEBOWSKI SOLDIERS','A Beautiful Epistle of a Secret Agent And a Pioneer who must Chase a Astronaut in Ancient China',2006,1,NULL,6,'2.99',69,'17.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (515,'LEGALLY SECRETARY','A Astounding Tale of a A Shark And a Moose who must Meet a Womanizer in The Sahara Desert',2006,1,NULL,7,'4.99',113,'14.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (516,'LEGEND JEDI','A Awe-Inspiring Epistle of a Pioneer And a Student who must Outgun a Crocodile in The Outback',2006,1,NULL,7,'0.99',59,'18.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (517,'LESSON CLEOPATRA','A Emotional Display of a Man And a Explorer who must Build a Boy in A Manhattan Penthouse',2006,1,NULL,3,'0.99',167,'28.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (518,'LIAISONS SWEET','A Boring Drama of a A Shark And a Explorer who must Redeem a Waitress in The Canadian Rockies',2006,1,NULL,5,'4.99',140,'15.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (519,'LIBERTY MAGNIFICENT','A Boring Drama of a Student And a Cat who must Sink a Technical Writer in A Baloon',2006,1,NULL,3,'2.99',138,'27.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (520,'LICENSE WEEKEND','A Insightful Story of a Man And a Husband who must Overcome a Madman in A Monastery',2006,1,NULL,7,'2.99',91,'28.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (521,'LIES TREATMENT','A Fast-Paced Character Study of a Dentist And a Moose who must Defeat a Composer in The First Manned Space Station',2006,1,NULL,7,'4.99',147,'28.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (522,'LIFE TWISTED','A Thrilling Reflection of a Teacher And a Composer who must Find a Man in The First Manned Space Station',2006,1,NULL,4,'2.99',137,'9.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (523,'LIGHTS DEER','A Unbelieveable Epistle of a Dog And a Woman who must Confront a Moose in The Gulf of Mexico',2006,1,NULL,7,'0.99',174,'21.99','R','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (524,'LION UNCUT','A Intrepid Display of a Pastry Chef And a Cat who must Kill a A Shark in Ancient China',2006,1,NULL,6,'0.99',50,'13.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (525,'LOATHING LEGALLY','A Boring Epistle of a Pioneer And a Mad Scientist who must Escape a Frisbee in The Gulf of Mexico',2006,1,NULL,4,'0.99',140,'29.99','R','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (526,'LOCK REAR','A Thoughtful Character Study of a Squirrel And a Technical Writer who must Outrace a Student in Ancient Japan',2006,1,NULL,7,'2.99',120,'10.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (527,'LOLA AGENT','A Astounding Tale of a Mad Scientist And a Husband who must Redeem a Database Administrator in Ancient Japan',2006,1,NULL,4,'4.99',85,'24.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (528,'LOLITA WORLD','A Thrilling Drama of a Girl And a Robot who must Redeem a Waitress in An Abandoned Mine Shaft',2006,1,NULL,4,'2.99',155,'25.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (529,'LONELY ELEPHANT','A Intrepid Story of a Student And a Dog who must Challenge a Explorer in Soviet Georgia',2006,1,NULL,3,'2.99',67,'12.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (530,'LORD ARIZONA','A Action-Packed Display of a Frisbee And a Pastry Chef who must Pursue a Crocodile in A Jet Boat',2006,1,NULL,5,'2.99',108,'27.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (531,'LOSE INCH','A Stunning Reflection of a Student And a Technical Writer who must Battle a Butler in The First Manned Space Station',2006,1,NULL,3,'0.99',137,'18.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (532,'LOSER HUSTLER','A Stunning Drama of a Robot And a Feminist who must Outgun a Butler in Nigeria',2006,1,NULL,5,'4.99',80,'28.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (533,'LOST BIRD','A Emotional Character Study of a Robot And a A Shark who must Defeat a Technical Writer in A Manhattan Penthouse',2006,1,NULL,4,'2.99',98,'21.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (534,'LOUISIANA HARRY','A Lacklusture Drama of a Girl And a Technical Writer who must Redeem a Monkey in A Shark Tank',2006,1,NULL,5,'0.99',70,'18.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (535,'LOVE SUICIDES','A Brilliant Panorama of a Hunter And a Explorer who must Pursue a Dentist in An Abandoned Fun House',2006,1,NULL,6,'0.99',181,'21.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (536,'LOVELY JINGLE','A Fanciful Yarn of a Crocodile And a Forensic Psychologist who must Discover a Crocodile in The Outback',2006,1,NULL,3,'2.99',65,'18.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (537,'LOVER TRUMAN','A Emotional Yarn of a Robot And a Boy who must Outgun a Technical Writer in A U-Boat',2006,1,NULL,3,'2.99',75,'29.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (538,'LOVERBOY ATTACKS','A Boring Story of a Car And a Butler who must Build a Girl in Soviet Georgia',2006,1,NULL,7,'0.99',162,'19.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (539,'LUCK OPUS','A Boring Display of a Moose And a Squirrel who must Outrace a Teacher in A Shark Tank',2006,1,NULL,7,'2.99',152,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (540,'LUCKY FLYING','A Lacklusture Character Study of a A Shark And a Man who must Find a Forensic Psychologist in A U-Boat',2006,1,NULL,7,'2.99',97,'10.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (541,'LUKE MUMMY','A Taut Character Study of a Boy And a Robot who must Redeem a Mad Scientist in Ancient India',2006,1,NULL,5,'2.99',74,'21.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (542,'LUST LOCK','A Fanciful Panorama of a Hunter And a Dentist who must Meet a Secret Agent in The Sahara Desert',2006,1,NULL,3,'2.99',52,'28.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (543,'MADIGAN DORADO','A Astounding Character Study of a A Shark And a A Shark who must Discover a Crocodile in The Outback',2006,1,NULL,5,'4.99',116,'20.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (544,'MADISON TRAP','A Awe-Inspiring Reflection of a Monkey And a Dentist who must Overcome a Pioneer in A U-Boat',2006,1,NULL,4,'2.99',147,'11.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (545,'MADNESS ATTACKS','A Fanciful Tale of a Squirrel And a Boat who must Defeat a Crocodile in The Gulf of Mexico',2006,1,NULL,4,'0.99',178,'14.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (546,'MADRE GABLES','A Intrepid Panorama of a Sumo Wrestler And a Forensic Psychologist who must Discover a Moose in The First Manned Space Station',2006,1,NULL,7,'2.99',98,'27.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (547,'MAGIC MALLRATS','A Touching Documentary of a Pastry Chef And a Pastry Chef who must Build a Mad Scientist in California',2006,1,NULL,3,'0.99',117,'19.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (548,'MAGNIFICENT CHITTY','A Insightful Story of a Teacher And a Hunter who must Face a Mad Cow in California',2006,1,NULL,3,'2.99',53,'27.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (549,'MAGNOLIA FORRESTER','A Thoughtful Documentary of a Composer And a Explorer who must Conquer a Dentist in New Orleans',2006,1,NULL,4,'0.99',171,'28.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (550,'MAGUIRE APACHE','A Fast-Paced Reflection of a Waitress And a Hunter who must Defeat a Forensic Psychologist in A Baloon',2006,1,NULL,6,'2.99',74,'22.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (551,'MAIDEN HOME','A Lacklusture Saga of a Moose And a Teacher who must Kill a Forensic Psychologist in A MySQL Convention',2006,1,NULL,3,'4.99',138,'9.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (552,'MAJESTIC FLOATS','A Thrilling Character Study of a Moose And a Student who must Escape a Butler in The First Manned Space Station',2006,1,NULL,5,'0.99',130,'15.99','PG','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (553,'MAKER GABLES','A Stunning Display of a Moose And a Database Administrator who must Pursue a Composer in A Jet Boat',2006,1,NULL,4,'0.99',136,'12.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (554,'MALKOVICH PET','A Intrepid Reflection of a Waitress And a A Shark who must Kill a Squirrel in The Outback',2006,1,NULL,6,'2.99',159,'22.99','G','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (555,'MALLRATS UNITED','A Thrilling Yarn of a Waitress And a Dentist who must Find a Hunter in A Monastery',2006,1,NULL,4,'0.99',133,'25.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (556,'MALTESE HOPE','A Fast-Paced Documentary of a Crocodile And a Sumo Wrestler who must Conquer a Explorer in California',2006,1,NULL,6,'4.99',127,'26.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (557,'MANCHURIAN CURTAIN','A Stunning Tale of a Mad Cow And a Boy who must Battle a Boy in Berlin',2006,1,NULL,5,'2.99',177,'27.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (558,'MANNEQUIN WORST','A Astounding Saga of a Mad Cow And a Pastry Chef who must Discover a Husband in Ancient India',2006,1,NULL,3,'2.99',71,'18.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (559,'MARRIED GO','A Fanciful Story of a Womanizer And a Dog who must Face a Forensic Psychologist in The Sahara Desert',2006,1,NULL,7,'2.99',114,'22.99','G','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (560,'MARS ROMAN','A Boring Drama of a Car And a Dog who must Succumb a Madman in Soviet Georgia',2006,1,NULL,6,'0.99',62,'21.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (561,'MASK PEACH','A Boring Character Study of a Student And a Robot who must Meet a Woman in California',2006,1,NULL,6,'2.99',123,'26.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (562,'MASKED BUBBLE','A Fanciful Documentary of a Pioneer And a Boat who must Pursue a Pioneer in An Abandoned Mine Shaft',2006,1,NULL,6,'0.99',151,'12.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (563,'MASSACRE USUAL','A Fateful Reflection of a Waitress And a Crocodile who must Challenge a Forensic Psychologist in California',2006,1,NULL,6,'4.99',165,'16.99','R','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (564,'MASSAGE IMAGE','A Fateful Drama of a Frisbee And a Crocodile who must Vanquish a Dog in The First Manned Space Station',2006,1,NULL,4,'2.99',161,'11.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (565,'MATRIX SNOWMAN','A Action-Packed Saga of a Womanizer And a Woman who must Overcome a Student in California',2006,1,NULL,6,'4.99',56,'9.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (566,'MAUDE MOD','A Beautiful Documentary of a Forensic Psychologist And a Cat who must Reach a Astronaut in Nigeria',2006,1,NULL,6,'0.99',72,'20.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (567,'MEET CHOCOLATE','A Boring Documentary of a Dentist And a Butler who must Confront a Monkey in A MySQL Convention',2006,1,NULL,3,'2.99',80,'26.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (568,'MEMENTO ZOOLANDER','A Touching Epistle of a Squirrel And a Explorer who must Redeem a Pastry Chef in The Sahara Desert',2006,1,NULL,4,'4.99',77,'11.99','NC-17','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (569,'MENAGERIE RUSHMORE','A Unbelieveable Panorama of a Composer And a Butler who must Overcome a Database Administrator in The First Manned Space Station',2006,1,NULL,7,'2.99',147,'18.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (570,'MERMAID INSECTS','A Lacklusture Drama of a Waitress And a Husband who must Fight a Husband in California',2006,1,NULL,5,'4.99',104,'20.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (571,'METAL ARMAGEDDON','A Thrilling Display of a Lumberjack And a Crocodile who must Meet a Monkey in A Baloon Factory',2006,1,NULL,6,'2.99',161,'26.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (572,'METROPOLIS COMA','A Emotional Saga of a Database Administrator And a Pastry Chef who must Confront a Teacher in A Baloon Factory',2006,1,NULL,4,'2.99',64,'9.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (573,'MICROCOSMOS PARADISE','A Touching Character Study of a Boat And a Student who must Sink a A Shark in Nigeria',2006,1,NULL,6,'2.99',105,'22.99','PG-13','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (574,'MIDNIGHT WESTWARD','A Taut Reflection of a Husband And a A Shark who must Redeem a Pastry Chef in A Monastery',2006,1,NULL,3,'0.99',86,'19.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (575,'MIDSUMMER GROUNDHOG','A Fateful Panorama of a Moose And a Dog who must Chase a Crocodile in Ancient Japan',2006,1,NULL,3,'4.99',48,'27.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (576,'MIGHTY LUCK','A Astounding Epistle of a Mad Scientist And a Pioneer who must Escape a Database Administrator in A MySQL Convention',2006,1,NULL,7,'2.99',122,'13.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (577,'MILE MULAN','A Lacklusture Epistle of a Cat And a Husband who must Confront a Boy in A MySQL Convention',2006,1,NULL,4,'0.99',64,'10.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (578,'MILLION ACE','A Brilliant Documentary of a Womanizer And a Squirrel who must Find a Technical Writer in The Sahara Desert',2006,1,NULL,4,'4.99',142,'16.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (579,'MINDS TRUMAN','A Taut Yarn of a Mad Scientist And a Crocodile who must Outgun a Database Administrator in A Monastery',2006,1,NULL,3,'4.99',149,'22.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (580,'MINE TITANS','A Amazing Yarn of a Robot And a Womanizer who must Discover a Forensic Psychologist in Berlin',2006,1,NULL,3,'4.99',166,'12.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (581,'MINORITY KISS','A Insightful Display of a Lumberjack And a Sumo Wrestler who must Meet a Man in The Outback',2006,1,NULL,4,'0.99',59,'16.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (582,'MIRACLE VIRTUAL','A Touching Epistle of a Butler And a Boy who must Find a Mad Scientist in The Sahara Desert',2006,1,NULL,3,'2.99',162,'19.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (583,'MISSION ZOOLANDER','A Intrepid Story of a Sumo Wrestler And a Teacher who must Meet a A Shark in An Abandoned Fun House',2006,1,NULL,3,'4.99',164,'26.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (584,'MIXED DOORS','A Taut Drama of a Womanizer And a Lumberjack who must Succumb a Pioneer in Ancient India',2006,1,NULL,6,'2.99',180,'26.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (585,'MOB DUFFEL','A Unbelieveable Documentary of a Frisbee And a Boat who must Meet a Boy in The Canadian Rockies',2006,1,NULL,4,'0.99',105,'25.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (586,'MOCKINGBIRD HOLLYWOOD','A Thoughtful Panorama of a Man And a Car who must Sink a Composer in Berlin',2006,1,NULL,4,'0.99',60,'27.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (587,'MOD SECRETARY','A Boring Documentary of a Mad Cow And a Cat who must Build a Lumberjack in New Orleans',2006,1,NULL,6,'4.99',77,'20.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (588,'MODEL FISH','A Beautiful Panorama of a Boat And a Crocodile who must Outrace a Dog in Australia',2006,1,NULL,4,'4.99',175,'11.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (589,'MODERN DORADO','A Awe-Inspiring Story of a Butler And a Sumo Wrestler who must Redeem a Boy in New Orleans',2006,1,NULL,3,'0.99',74,'20.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (590,'MONEY HAROLD','A Touching Tale of a Explorer And a Boat who must Defeat a Robot in Australia',2006,1,NULL,3,'2.99',135,'17.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (591,'MONSOON CAUSE','A Astounding Tale of a Crocodile And a Car who must Outrace a Squirrel in A U-Boat',2006,1,NULL,6,'4.99',182,'20.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (592,'MONSTER SPARTACUS','A Fast-Paced Story of a Waitress And a Cat who must Fight a Girl in Australia',2006,1,NULL,6,'2.99',107,'28.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (593,'MONTEREY LABYRINTH','A Awe-Inspiring Drama of a Monkey And a Composer who must Escape a Feminist in A U-Boat',2006,1,NULL,6,'0.99',158,'13.99','G','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (594,'MONTEZUMA COMMAND','A Thrilling Reflection of a Waitress And a Butler who must Battle a Butler in A Jet Boat',2006,1,NULL,6,'0.99',126,'22.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (595,'MOON BUNCH','A Beautiful Tale of a Astronaut And a Mad Cow who must Challenge a Cat in A Baloon Factory',2006,1,NULL,7,'0.99',83,'20.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (596,'MOONSHINE CABIN','A Thoughtful Display of a Astronaut And a Feminist who must Chase a Frisbee in A Jet Boat',2006,1,NULL,4,'4.99',171,'25.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (597,'MOONWALKER FOOL','A Epic Drama of a Feminist And a Pioneer who must Sink a Composer in New Orleans',2006,1,NULL,5,'4.99',184,'12.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (598,'MOSQUITO ARMAGEDDON','A Thoughtful Character Study of a Waitress And a Feminist who must Build a Teacher in Ancient Japan',2006,1,NULL,6,'0.99',57,'22.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (599,'MOTHER OLEANDER','A Boring Tale of a Husband And a Boy who must Fight a Squirrel in Ancient China',2006,1,NULL,3,'0.99',103,'20.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (600,'MOTIONS DETAILS','A Awe-Inspiring Reflection of a Dog And a Student who must Kill a Car in An Abandoned Fun House',2006,1,NULL,5,'0.99',166,'16.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (601,'MOULIN WAKE','A Astounding Story of a Forensic Psychologist And a Cat who must Battle a Teacher in An Abandoned Mine Shaft',2006,1,NULL,4,'0.99',79,'20.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (602,'MOURNING PURPLE','A Lacklusture Display of a Waitress And a Lumberjack who must Chase a Pioneer in New Orleans',2006,1,NULL,5,'0.99',146,'14.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (603,'MOVIE SHAKESPEARE','A Insightful Display of a Database Administrator And a Student who must Build a Hunter in Berlin',2006,1,NULL,6,'4.99',53,'27.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (604,'MULAN MOON','A Emotional Saga of a Womanizer And a Pioneer who must Overcome a Dentist in A Baloon',2006,1,NULL,4,'0.99',160,'10.99','G','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (605,'MULHOLLAND BEAST','A Awe-Inspiring Display of a Husband And a Squirrel who must Battle a Sumo Wrestler in A Jet Boat',2006,1,NULL,7,'2.99',157,'13.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (606,'MUMMY CREATURES','A Fateful Character Study of a Crocodile And a Monkey who must Meet a Dentist in Australia',2006,1,NULL,3,'0.99',160,'15.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (607,'MUPPET MILE','A Lacklusture Story of a Madman And a Teacher who must Kill a Frisbee in The Gulf of Mexico',2006,1,NULL,5,'4.99',50,'18.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (608,'MURDER ANTITRUST','A Brilliant Yarn of a Car And a Database Administrator who must Escape a Boy in A MySQL Convention',2006,1,NULL,6,'2.99',166,'11.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (609,'MUSCLE BRIGHT','A Stunning Panorama of a Sumo Wrestler And a Husband who must Redeem a Madman in Ancient India',2006,1,NULL,7,'2.99',185,'23.99','G','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (610,'MUSIC BOONDOCK','A Thrilling Tale of a Butler And a Astronaut who must Battle a Explorer in The First Manned Space Station',2006,1,NULL,7,'0.99',129,'17.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (611,'MUSKETEERS WAIT','A Touching Yarn of a Student And a Moose who must Fight a Mad Cow in Australia',2006,1,NULL,7,'4.99',73,'17.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (612,'MUSSOLINI SPOILERS','A Thrilling Display of a Boat And a Monkey who must Meet a Composer in Ancient China',2006,1,NULL,6,'2.99',180,'10.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (613,'MYSTIC TRUMAN','A Epic Yarn of a Teacher And a Hunter who must Outgun a Explorer in Soviet Georgia',2006,1,NULL,5,'0.99',92,'19.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (614,'NAME DETECTIVE','A Touching Saga of a Sumo Wrestler And a Cat who must Pursue a Mad Scientist in Nigeria',2006,1,NULL,5,'4.99',178,'11.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (615,'NASH CHOCOLAT','A Epic Reflection of a Monkey And a Mad Cow who must Kill a Forensic Psychologist in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',180,'21.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (616,'NATIONAL STORY','A Taut Epistle of a Mad Scientist And a Girl who must Escape a Monkey in California',2006,1,NULL,4,'2.99',92,'19.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (617,'NATURAL STOCK','A Fast-Paced Story of a Sumo Wrestler And a Girl who must Defeat a Car in A Baloon Factory',2006,1,NULL,4,'0.99',50,'24.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (618,'NECKLACE OUTBREAK','A Astounding Epistle of a Database Administrator And a Mad Scientist who must Pursue a Cat in California',2006,1,NULL,3,'0.99',132,'21.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (619,'NEIGHBORS CHARADE','A Fanciful Reflection of a Crocodile And a Astronaut who must Outrace a Feminist in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',161,'20.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (620,'NEMO CAMPUS','A Lacklusture Reflection of a Monkey And a Squirrel who must Outrace a Womanizer in A Manhattan Penthouse',2006,1,NULL,5,'2.99',131,'23.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (621,'NETWORK PEAK','A Unbelieveable Reflection of a Butler And a Boat who must Outgun a Mad Scientist in California',2006,1,NULL,5,'2.99',75,'23.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (622,'NEWSIES STORY','A Action-Packed Character Study of a Dog And a Lumberjack who must Outrace a Moose in The Gulf of Mexico',2006,1,NULL,4,'0.99',159,'25.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (623,'NEWTON LABYRINTH','A Intrepid Character Study of a Moose And a Waitress who must Find a A Shark in Ancient India',2006,1,NULL,4,'0.99',75,'9.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (624,'NIGHTMARE CHILL','A Brilliant Display of a Robot And a Butler who must Fight a Waitress in An Abandoned Mine Shaft',2006,1,NULL,3,'4.99',149,'25.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (625,'NONE SPIKING','A Boring Reflection of a Secret Agent And a Astronaut who must Face a Composer in A Manhattan Penthouse',2006,1,NULL,3,'0.99',83,'18.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (626,'NOON PAPI','A Unbelieveable Character Study of a Mad Scientist And a Astronaut who must Find a Pioneer in A Manhattan Penthouse',2006,1,NULL,5,'2.99',57,'12.99','G','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (627,'NORTH TEQUILA','A Beautiful Character Study of a Mad Cow And a Robot who must Reach a Womanizer in New Orleans',2006,1,NULL,4,'4.99',67,'9.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (628,'NORTHWEST POLISH','A Boring Character Study of a Boy And a A Shark who must Outrace a Womanizer in The Outback',2006,1,NULL,5,'2.99',172,'24.99','PG','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (629,'NOTORIOUS REUNION','A Amazing Epistle of a Woman And a Squirrel who must Fight a Hunter in A Baloon',2006,1,NULL,7,'0.99',128,'9.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (630,'NOTTING SPEAKEASY','A Thoughtful Display of a Butler And a Womanizer who must Find a Waitress in The Canadian Rockies',2006,1,NULL,7,'0.99',48,'19.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (631,'NOVOCAINE FLIGHT','A Fanciful Display of a Student And a Teacher who must Outgun a Crocodile in Nigeria',2006,1,NULL,4,'0.99',64,'11.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (632,'NUTS TIES','A Thoughtful Drama of a Explorer And a Womanizer who must Meet a Teacher in California',2006,1,NULL,5,'4.99',145,'10.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (633,'OCTOBER SUBMARINE','A Taut Epistle of a Monkey And a Boy who must Confront a Husband in A Jet Boat',2006,1,NULL,6,'4.99',54,'10.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (634,'ODDS BOOGIE','A Thrilling Yarn of a Feminist And a Madman who must Battle a Hunter in Berlin',2006,1,NULL,6,'0.99',48,'14.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (635,'OKLAHOMA JUMANJI','A Thoughtful Drama of a Dentist And a Womanizer who must Meet a Husband in The Sahara Desert',2006,1,NULL,7,'0.99',58,'15.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (636,'OLEANDER CLUE','A Boring Story of a Teacher And a Monkey who must Succumb a Forensic Psychologist in A Jet Boat',2006,1,NULL,5,'0.99',161,'12.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (637,'OPEN AFRICAN','A Lacklusture Drama of a Secret Agent And a Explorer who must Discover a Car in A U-Boat',2006,1,NULL,7,'4.99',131,'16.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (638,'OPERATION OPERATION','A Intrepid Character Study of a Man And a Frisbee who must Overcome a Madman in Ancient China',2006,1,NULL,7,'2.99',156,'23.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (639,'OPPOSITE NECKLACE','A Fateful Epistle of a Crocodile And a Moose who must Kill a Explorer in Nigeria',2006,1,NULL,7,'4.99',92,'9.99','PG','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (640,'OPUS ICE','A Fast-Paced Drama of a Hunter And a Boy who must Discover a Feminist in The Sahara Desert',2006,1,NULL,5,'4.99',102,'21.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (641,'ORANGE GRAPES','A Astounding Documentary of a Butler And a Womanizer who must Face a Dog in A U-Boat',2006,1,NULL,4,'0.99',76,'21.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (642,'ORDER BETRAYED','A Amazing Saga of a Dog And a A Shark who must Challenge a Cat in The Sahara Desert',2006,1,NULL,7,'2.99',120,'13.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (643,'ORIENT CLOSER','A Astounding Epistle of a Technical Writer And a Teacher who must Fight a Squirrel in The Sahara Desert',2006,1,NULL,3,'2.99',118,'22.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (644,'OSCAR GOLD','A Insightful Tale of a Database Administrator And a Dog who must Face a Madman in Soviet Georgia',2006,1,NULL,7,'2.99',115,'29.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (645,'OTHERS SOUP','A Lacklusture Documentary of a Mad Cow And a Madman who must Sink a Moose in The Gulf of Mexico',2006,1,NULL,7,'2.99',118,'18.99','PG','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (646,'OUTBREAK DIVINE','A Unbelieveable Yarn of a Database Administrator And a Woman who must Succumb a A Shark in A U-Boat',2006,1,NULL,6,'0.99',169,'12.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (647,'OUTFIELD MASSACRE','A Thoughtful Drama of a Husband And a Secret Agent who must Pursue a Database Administrator in Ancient India',2006,1,NULL,4,'0.99',129,'18.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (648,'OUTLAW HANKY','A Thoughtful Story of a Astronaut And a Composer who must Conquer a Dog in The Sahara Desert',2006,1,NULL,7,'4.99',148,'17.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (649,'OZ LIAISONS','A Epic Yarn of a Mad Scientist And a Cat who must Confront a Womanizer in A Baloon Factory',2006,1,NULL,4,'2.99',85,'14.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (650,'PACIFIC AMISTAD','A Thrilling Yarn of a Dog And a Moose who must Kill a Pastry Chef in A Manhattan Penthouse',2006,1,NULL,3,'0.99',144,'27.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (651,'PACKER MADIGAN','A Epic Display of a Sumo Wrestler And a Forensic Psychologist who must Build a Woman in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',84,'20.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (652,'PAJAMA JAWBREAKER','A Emotional Drama of a Boy And a Technical Writer who must Redeem a Sumo Wrestler in California',2006,1,NULL,3,'0.99',126,'14.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (653,'PANIC CLUB','A Fanciful Display of a Teacher And a Crocodile who must Succumb a Girl in A Baloon',2006,1,NULL,3,'4.99',102,'15.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (654,'PANKY SUBMARINE','A Touching Documentary of a Dentist And a Sumo Wrestler who must Overcome a Boy in The Gulf of Mexico',2006,1,NULL,4,'4.99',93,'19.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (655,'PANTHER REDS','A Brilliant Panorama of a Moose And a Man who must Reach a Teacher in The Gulf of Mexico',2006,1,NULL,5,'4.99',109,'22.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (656,'PAPI NECKLACE','A Fanciful Display of a Car And a Monkey who must Escape a Squirrel in Ancient Japan',2006,1,NULL,3,'0.99',128,'9.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (657,'PARADISE SABRINA','A Intrepid Yarn of a Car And a Moose who must Outrace a Crocodile in A Manhattan Penthouse',2006,1,NULL,5,'2.99',48,'12.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (658,'PARIS WEEKEND','A Intrepid Story of a Squirrel And a Crocodile who must Defeat a Monkey in The Outback',2006,1,NULL,7,'2.99',121,'19.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (659,'PARK CITIZEN','A Taut Epistle of a Sumo Wrestler And a Girl who must Face a Husband in Ancient Japan',2006,1,NULL,3,'4.99',109,'14.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (660,'PARTY KNOCK','A Fateful Display of a Technical Writer And a Butler who must Battle a Sumo Wrestler in An Abandoned Mine Shaft',2006,1,NULL,7,'2.99',107,'11.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (661,'PAST SUICIDES','A Intrepid Tale of a Madman And a Astronaut who must Challenge a Hunter in A Monastery',2006,1,NULL,5,'4.99',157,'17.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (662,'PATHS CONTROL','A Astounding Documentary of a Butler And a Cat who must Find a Frisbee in Ancient China',2006,1,NULL,3,'4.99',118,'9.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (663,'PATIENT SISTER','A Emotional Epistle of a Squirrel And a Robot who must Confront a Lumberjack in Soviet Georgia',2006,1,NULL,7,'0.99',99,'29.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (664,'PATRIOT ROMAN','A Taut Saga of a Robot And a Database Administrator who must Challenge a Astronaut in California',2006,1,NULL,6,'2.99',65,'12.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (665,'PATTON INTERVIEW','A Thrilling Documentary of a Composer And a Secret Agent who must Succumb a Cat in Berlin',2006,1,NULL,4,'2.99',175,'22.99','PG','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (666,'PAYCHECK WAIT','A Awe-Inspiring Reflection of a Boy And a Man who must Discover a Moose in The Sahara Desert',2006,1,NULL,4,'4.99',145,'27.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (667,'PEACH INNOCENT','A Action-Packed Drama of a Monkey And a Dentist who must Chase a Butler in Berlin',2006,1,NULL,3,'2.99',160,'20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (668,'PEAK FOREVER','A Insightful Reflection of a Boat And a Secret Agent who must Vanquish a Astronaut in An Abandoned Mine Shaft',2006,1,NULL,7,'4.99',80,'25.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (669,'PEARL DESTINY','A Lacklusture Yarn of a Astronaut And a Pastry Chef who must Sink a Dog in A U-Boat',2006,1,NULL,3,'2.99',74,'10.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (670,'PELICAN COMFORTS','A Epic Documentary of a Boy And a Monkey who must Pursue a Astronaut in Berlin',2006,1,NULL,4,'4.99',48,'17.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (671,'PERDITION FARGO','A Fast-Paced Story of a Car And a Cat who must Outgun a Hunter in Berlin',2006,1,NULL,7,'4.99',99,'27.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (672,'PERFECT GROOVE','A Thrilling Yarn of a Dog And a Dog who must Build a Husband in A Baloon',2006,1,NULL,7,'2.99',82,'17.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (673,'PERSONAL LADYBUGS','A Epic Saga of a Hunter And a Technical Writer who must Conquer a Cat in Ancient Japan',2006,1,NULL,3,'0.99',118,'19.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (674,'PET HAUNTING','A Unbelieveable Reflection of a Explorer And a Boat who must Conquer a Woman in California',2006,1,NULL,3,'0.99',99,'11.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (675,'PHANTOM GLORY','A Beautiful Documentary of a Astronaut And a Crocodile who must Discover a Madman in A Monastery',2006,1,NULL,6,'2.99',60,'17.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (676,'PHILADELPHIA WIFE','A Taut Yarn of a Hunter And a Astronaut who must Conquer a Database Administrator in The Sahara Desert',2006,1,NULL,7,'4.99',137,'16.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (677,'PIANIST OUTFIELD','A Intrepid Story of a Boy And a Technical Writer who must Pursue a Lumberjack in A Monastery',2006,1,NULL,6,'0.99',136,'25.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (678,'PICKUP DRIVING','A Touching Documentary of a Husband And a Boat who must Meet a Pastry Chef in A Baloon Factory',2006,1,NULL,3,'2.99',77,'23.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (679,'PILOT HOOSIERS','A Awe-Inspiring Reflection of a Crocodile And a Sumo Wrestler who must Meet a Forensic Psychologist in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',50,'17.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (680,'PINOCCHIO SIMON','A Action-Packed Reflection of a Mad Scientist And a A Shark who must Find a Feminist in California',2006,1,NULL,4,'4.99',103,'21.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (681,'PIRATES ROXANNE','A Stunning Drama of a Woman And a Lumberjack who must Overcome a A Shark in The Canadian Rockies',2006,1,NULL,4,'0.99',100,'20.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (682,'PITTSBURGH HUNCHBACK','A Thrilling Epistle of a Boy And a Boat who must Find a Student in Soviet Georgia',2006,1,NULL,4,'4.99',134,'17.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (683,'PITY BOUND','A Boring Panorama of a Feminist And a Moose who must Defeat a Database Administrator in Nigeria',2006,1,NULL,5,'4.99',60,'19.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (684,'PIZZA JUMANJI','A Epic Saga of a Cat And a Squirrel who must Outgun a Robot in A U-Boat',2006,1,NULL,4,'2.99',173,'11.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (685,'PLATOON INSTINCT','A Thrilling Panorama of a Man And a Woman who must Reach a Woman in Australia',2006,1,NULL,6,'4.99',132,'10.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (686,'PLUTO OLEANDER','A Action-Packed Reflection of a Car And a Moose who must Outgun a Car in A Shark Tank',2006,1,NULL,5,'4.99',84,'9.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (687,'POCUS PULP','A Intrepid Yarn of a Frisbee And a Dog who must Build a Astronaut in A Baloon Factory',2006,1,NULL,6,'0.99',138,'15.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (688,'POLISH BROOKLYN','A Boring Character Study of a Database Administrator And a Lumberjack who must Reach a Madman in The Outback',2006,1,NULL,6,'0.99',61,'12.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (689,'POLLOCK DELIVERANCE','A Intrepid Story of a Madman And a Frisbee who must Outgun a Boat in The Sahara Desert',2006,1,NULL,5,'2.99',137,'14.99','PG','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (690,'POND SEATTLE','A Stunning Drama of a Teacher And a Boat who must Battle a Feminist in Ancient China',2006,1,NULL,7,'2.99',185,'25.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (691,'POSEIDON FOREVER','A Thoughtful Epistle of a Womanizer And a Monkey who must Vanquish a Dentist in A Monastery',2006,1,NULL,6,'4.99',159,'29.99','PG-13','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (692,'POTLUCK MIXED','A Beautiful Story of a Dog And a Technical Writer who must Outgun a Student in A Baloon',2006,1,NULL,3,'2.99',179,'10.99','G','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (693,'POTTER CONNECTICUT','A Thrilling Epistle of a Frisbee And a Cat who must Fight a Technical Writer in Berlin',2006,1,NULL,5,'2.99',115,'16.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (694,'PREJUDICE OLEANDER','A Epic Saga of a Boy And a Dentist who must Outrace a Madman in A U-Boat',2006,1,NULL,6,'4.99',98,'15.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (695,'PRESIDENT BANG','A Fateful Panorama of a Technical Writer And a Moose who must Battle a Robot in Soviet Georgia',2006,1,NULL,6,'4.99',144,'12.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (696,'PRIDE ALAMO','A Thoughtful Drama of a A Shark And a Forensic Psychologist who must Vanquish a Student in Ancient India',2006,1,NULL,6,'0.99',114,'20.99','NC-17','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (697,'PRIMARY GLASS','A Fateful Documentary of a Pastry Chef And a Butler who must Build a Dog in The Canadian Rockies',2006,1,NULL,7,'0.99',53,'16.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (698,'PRINCESS GIANT','A Thrilling Yarn of a Pastry Chef And a Monkey who must Battle a Monkey in A Shark Tank',2006,1,NULL,3,'2.99',71,'29.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (699,'PRIVATE DROP','A Stunning Story of a Technical Writer And a Hunter who must Succumb a Secret Agent in A Baloon',2006,1,NULL,7,'4.99',106,'26.99','PG','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (700,'PRIX UNDEFEATED','A Stunning Saga of a Mad Scientist And a Boat who must Overcome a Dentist in Ancient China',2006,1,NULL,4,'2.99',115,'13.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (701,'PSYCHO SHRUNK','A Amazing Panorama of a Crocodile And a Explorer who must Fight a Husband in Nigeria',2006,1,NULL,5,'2.99',155,'11.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (702,'PULP BEVERLY','A Unbelieveable Display of a Dog And a Crocodile who must Outrace a Man in Nigeria',2006,1,NULL,4,'2.99',89,'12.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (703,'PUNK DIVORCE','A Fast-Paced Tale of a Pastry Chef And a Boat who must Face a Frisbee in The Canadian Rockies',2006,1,NULL,6,'4.99',100,'18.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (704,'PURE RUNNER','A Thoughtful Documentary of a Student And a Madman who must Challenge a Squirrel in A Manhattan Penthouse',2006,1,NULL,3,'2.99',121,'25.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (705,'PURPLE MOVIE','A Boring Display of a Pastry Chef And a Sumo Wrestler who must Discover a Frisbee in An Abandoned Amusement Park',2006,1,NULL,4,'2.99',88,'9.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (706,'QUEEN LUKE','A Astounding Story of a Girl And a Boy who must Challenge a Composer in New Orleans',2006,1,NULL,5,'4.99',163,'22.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (707,'QUEST MUSSOLINI','A Fateful Drama of a Husband And a Sumo Wrestler who must Battle a Pastry Chef in A Baloon Factory',2006,1,NULL,5,'2.99',177,'29.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (708,'QUILLS BULL','A Thoughtful Story of a Pioneer And a Woman who must Reach a Moose in Australia',2006,1,NULL,4,'4.99',112,'19.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (709,'RACER EGG','A Emotional Display of a Monkey And a Waitress who must Reach a Secret Agent in California',2006,1,NULL,7,'2.99',147,'19.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (710,'RAGE GAMES','A Fast-Paced Saga of a Astronaut And a Secret Agent who must Escape a Hunter in An Abandoned Amusement Park',2006,1,NULL,4,'4.99',120,'18.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (711,'RAGING AIRPLANE','A Astounding Display of a Secret Agent And a Technical Writer who must Escape a Mad Scientist in A Jet Boat',2006,1,NULL,4,'4.99',154,'18.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (712,'RAIDERS ANTITRUST','A Amazing Drama of a Teacher And a Feminist who must Meet a Woman in The First Manned Space Station',2006,1,NULL,4,'0.99',82,'11.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (713,'RAINBOW SHOCK','A Action-Packed Story of a Hunter And a Boy who must Discover a Lumberjack in Ancient India',2006,1,NULL,3,'4.99',74,'14.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (714,'RANDOM GO','A Fateful Drama of a Frisbee And a Student who must Confront a Cat in A Shark Tank',2006,1,NULL,6,'2.99',73,'29.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (715,'RANGE MOONWALKER','A Insightful Documentary of a Hunter And a Dentist who must Confront a Crocodile in A Baloon',2006,1,NULL,3,'4.99',147,'25.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (716,'REAP UNFAITHFUL','A Thrilling Epistle of a Composer And a Sumo Wrestler who must Challenge a Mad Cow in A MySQL Convention',2006,1,NULL,6,'2.99',136,'26.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (717,'REAR TRADING','A Awe-Inspiring Reflection of a Forensic Psychologist And a Secret Agent who must Succumb a Pastry Chef in Soviet Georgia',2006,1,NULL,6,'0.99',97,'23.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (718,'REBEL AIRPORT','A Intrepid Yarn of a Database Administrator And a Boat who must Outrace a Husband in Ancient India',2006,1,NULL,7,'0.99',73,'24.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (719,'RECORDS ZORRO','A Amazing Drama of a Mad Scientist And a Composer who must Build a Husband in The Outback',2006,1,NULL,7,'4.99',182,'11.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (720,'REDEMPTION COMFORTS','A Emotional Documentary of a Dentist And a Woman who must Battle a Mad Scientist in Ancient China',2006,1,NULL,3,'2.99',179,'20.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (721,'REDS POCUS','A Lacklusture Yarn of a Sumo Wrestler And a Squirrel who must Redeem a Monkey in Soviet Georgia',2006,1,NULL,7,'4.99',182,'23.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (722,'REEF SALUTE','A Action-Packed Saga of a Teacher And a Lumberjack who must Battle a Dentist in A Baloon',2006,1,NULL,5,'0.99',123,'26.99','NC-17','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (723,'REIGN GENTLEMEN','A Emotional Yarn of a Composer And a Man who must Escape a Butler in The Gulf of Mexico',2006,1,NULL,3,'2.99',82,'29.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (724,'REMEMBER DIARY','A Insightful Tale of a Technical Writer And a Waitress who must Conquer a Monkey in Ancient India',2006,1,NULL,5,'2.99',110,'15.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (725,'REQUIEM TYCOON','A Unbelieveable Character Study of a Cat And a Database Administrator who must Pursue a Teacher in A Monastery',2006,1,NULL,6,'4.99',167,'25.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (726,'RESERVOIR ADAPTATION','A Intrepid Drama of a Teacher And a Moose who must Kill a Car in California',2006,1,NULL,7,'2.99',61,'29.99','PG-13','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (727,'RESURRECTION SILVERADO','A Epic Yarn of a Robot And a Explorer who must Challenge a Girl in A MySQL Convention',2006,1,NULL,6,'0.99',117,'12.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (728,'REUNION WITCHES','A Unbelieveable Documentary of a Database Administrator And a Frisbee who must Redeem a Mad Scientist in A Baloon Factory',2006,1,NULL,3,'0.99',63,'26.99','R','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (729,'RIDER CADDYSHACK','A Taut Reflection of a Monkey And a Womanizer who must Chase a Moose in Nigeria',2006,1,NULL,5,'2.99',177,'28.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (730,'RIDGEMONT SUBMARINE','A Unbelieveable Drama of a Waitress And a Composer who must Sink a Mad Cow in Ancient Japan',2006,1,NULL,3,'0.99',46,'28.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (731,'RIGHT CRANES','A Fateful Character Study of a Boat And a Cat who must Find a Database Administrator in A Jet Boat',2006,1,NULL,7,'4.99',153,'29.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (732,'RINGS HEARTBREAKERS','A Amazing Yarn of a Sumo Wrestler And a Boat who must Conquer a Waitress in New Orleans',2006,1,NULL,5,'0.99',58,'17.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (733,'RIVER OUTLAW','A Thrilling Character Study of a Squirrel And a Lumberjack who must Face a Hunter in A MySQL Convention',2006,1,NULL,4,'0.99',149,'29.99','PG-13','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (734,'ROAD ROXANNE','A Boring Character Study of a Waitress And a Astronaut who must Fight a Crocodile in Ancient Japan',2006,1,NULL,4,'4.99',158,'12.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (735,'ROBBERS JOON','A Thoughtful Story of a Mad Scientist And a Waitress who must Confront a Forensic Psychologist in Soviet Georgia',2006,1,NULL,7,'2.99',102,'26.99','PG-13','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (736,'ROBBERY BRIGHT','A Taut Reflection of a Robot And a Squirrel who must Fight a Boat in Ancient Japan',2006,1,NULL,4,'0.99',134,'21.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (737,'ROCK INSTINCT','A Astounding Character Study of a Robot And a Moose who must Overcome a Astronaut in Ancient India',2006,1,NULL,4,'0.99',102,'28.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (738,'ROCKETEER MOTHER','A Awe-Inspiring Character Study of a Robot And a Sumo Wrestler who must Discover a Womanizer in A Shark Tank',2006,1,NULL,3,'0.99',178,'27.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (739,'ROCKY WAR','A Fast-Paced Display of a Squirrel And a Explorer who must Outgun a Mad Scientist in Nigeria',2006,1,NULL,4,'4.99',145,'17.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (740,'ROLLERCOASTER BRINGING','A Beautiful Drama of a Robot And a Lumberjack who must Discover a Technical Writer in A Shark Tank',2006,1,NULL,5,'2.99',153,'13.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (741,'ROMAN PUNK','A Thoughtful Panorama of a Mad Cow And a Student who must Battle a Forensic Psychologist in Berlin',2006,1,NULL,7,'0.99',81,'28.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (742,'ROOF CHAMPION','A Lacklusture Reflection of a Car And a Explorer who must Find a Monkey in A Baloon',2006,1,NULL,7,'0.99',101,'25.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (743,'ROOM ROMAN','A Awe-Inspiring Panorama of a Composer And a Secret Agent who must Sink a Composer in A Shark Tank',2006,1,NULL,7,'0.99',60,'27.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (744,'ROOTS REMEMBER','A Brilliant Drama of a Mad Cow And a Hunter who must Escape a Hunter in Berlin',2006,1,NULL,4,'0.99',89,'23.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (745,'ROSES TREASURE','A Astounding Panorama of a Monkey And a Secret Agent who must Defeat a Woman in The First Manned Space Station',2006,1,NULL,5,'4.99',162,'23.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (746,'ROUGE SQUAD','A Awe-Inspiring Drama of a Astronaut And a Frisbee who must Conquer a Mad Scientist in Australia',2006,1,NULL,3,'0.99',118,'10.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (747,'ROXANNE REBEL','A Astounding Story of a Pastry Chef And a Database Administrator who must Fight a Man in The Outback',2006,1,NULL,5,'0.99',171,'9.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (748,'RUGRATS SHAKESPEARE','A Touching Saga of a Crocodile And a Crocodile who must Discover a Technical Writer in Nigeria',2006,1,NULL,4,'0.99',109,'16.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (749,'RULES HUMAN','A Beautiful Epistle of a Astronaut And a Student who must Confront a Monkey in An Abandoned Fun House',2006,1,NULL,6,'4.99',153,'19.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (750,'RUN PACIFIC','A Touching Tale of a Cat And a Pastry Chef who must Conquer a Pastry Chef in A MySQL Convention',2006,1,NULL,3,'0.99',145,'25.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (751,'RUNAWAY TENENBAUMS','A Thoughtful Documentary of a Boat And a Man who must Meet a Boat in An Abandoned Fun House',2006,1,NULL,6,'0.99',181,'17.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (752,'RUNNER MADIGAN','A Thoughtful Documentary of a Crocodile And a Robot who must Outrace a Womanizer in The Outback',2006,1,NULL,6,'0.99',101,'27.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (753,'RUSH GOODFELLAS','A Emotional Display of a Man And a Dentist who must Challenge a Squirrel in Australia',2006,1,NULL,3,'0.99',48,'20.99','PG','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (754,'RUSHMORE MERMAID','A Boring Story of a Woman And a Moose who must Reach a Husband in A Shark Tank',2006,1,NULL,6,'2.99',150,'17.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (755,'SABRINA MIDNIGHT','A Emotional Story of a Squirrel And a Crocodile who must Succumb a Husband in The Sahara Desert',2006,1,NULL,5,'4.99',99,'11.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (756,'SADDLE ANTITRUST','A Stunning Epistle of a Feminist And a A Shark who must Battle a Woman in An Abandoned Fun House',2006,1,NULL,7,'2.99',80,'10.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (757,'SAGEBRUSH CLUELESS','A Insightful Story of a Lumberjack And a Hunter who must Kill a Boy in Ancient Japan',2006,1,NULL,4,'2.99',106,'28.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (758,'SAINTS BRIDE','A Fateful Tale of a Technical Writer And a Composer who must Pursue a Explorer in The Gulf of Mexico',2006,1,NULL,5,'2.99',125,'11.99','G','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (759,'SALUTE APOLLO','A Awe-Inspiring Character Study of a Boy And a Feminist who must Sink a Crocodile in Ancient China',2006,1,NULL,4,'2.99',73,'29.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (760,'SAMURAI LION','A Fast-Paced Story of a Pioneer And a Astronaut who must Reach a Boat in A Baloon',2006,1,NULL,5,'2.99',110,'21.99','G','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (761,'SANTA PARIS','A Emotional Documentary of a Moose And a Car who must Redeem a Mad Cow in A Baloon Factory',2006,1,NULL,7,'2.99',154,'23.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (762,'SASSY PACKER','A Fast-Paced Documentary of a Dog And a Teacher who must Find a Moose in A Manhattan Penthouse',2006,1,NULL,6,'0.99',154,'29.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (763,'SATISFACTION CONFIDENTIAL','A Lacklusture Yarn of a Dentist And a Butler who must Meet a Secret Agent in Ancient China',2006,1,NULL,3,'4.99',75,'26.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (764,'SATURDAY LAMBS','A Thoughtful Reflection of a Mad Scientist And a Moose who must Kill a Husband in A Baloon',2006,1,NULL,3,'4.99',150,'28.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (765,'SATURN NAME','A Fateful Epistle of a Butler And a Boy who must Redeem a Teacher in Berlin',2006,1,NULL,7,'4.99',182,'18.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (766,'SAVANNAH TOWN','A Awe-Inspiring Tale of a Astronaut And a Database Administrator who must Chase a Secret Agent in The Gulf of Mexico',2006,1,NULL,5,'0.99',84,'25.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (767,'SCALAWAG DUCK','A Fateful Reflection of a Car And a Teacher who must Confront a Waitress in A Monastery',2006,1,NULL,6,'4.99',183,'13.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (768,'SCARFACE BANG','A Emotional Yarn of a Teacher And a Girl who must Find a Teacher in A Baloon Factory',2006,1,NULL,3,'4.99',102,'11.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (769,'SCHOOL JACKET','A Intrepid Yarn of a Monkey And a Boy who must Fight a Composer in A Manhattan Penthouse',2006,1,NULL,5,'4.99',151,'21.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (770,'SCISSORHANDS SLUMS','A Awe-Inspiring Drama of a Girl And a Technical Writer who must Meet a Feminist in The Canadian Rockies',2006,1,NULL,5,'2.99',147,'13.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (771,'SCORPION APOLLO','A Awe-Inspiring Documentary of a Technical Writer And a Husband who must Meet a Monkey in An Abandoned Fun House',2006,1,NULL,3,'4.99',137,'23.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (772,'SEA VIRGIN','A Fast-Paced Documentary of a Technical Writer And a Pastry Chef who must Escape a Moose in A U-Boat',2006,1,NULL,4,'2.99',80,'24.99','PG','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (773,'SEABISCUIT PUNK','A Insightful Saga of a Man And a Forensic Psychologist who must Discover a Mad Cow in A MySQL Convention',2006,1,NULL,6,'2.99',112,'28.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (774,'SEARCHERS WAIT','A Fast-Paced Tale of a Car And a Mad Scientist who must Kill a Womanizer in Ancient Japan',2006,1,NULL,3,'2.99',182,'22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (775,'SEATTLE EXPECATIONS','A Insightful Reflection of a Crocodile And a Sumo Wrestler who must Meet a Technical Writer in The Sahara Desert',2006,1,NULL,4,'4.99',110,'18.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (776,'SECRET GROUNDHOG','A Astounding Story of a Cat And a Database Administrator who must Build a Technical Writer in New Orleans',2006,1,NULL,6,'4.99',90,'11.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (777,'SECRETARY ROUGE','A Action-Packed Panorama of a Mad Cow And a Composer who must Discover a Robot in A Baloon Factory',2006,1,NULL,5,'4.99',158,'10.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (778,'SECRETS PARADISE','A Fateful Saga of a Cat And a Frisbee who must Kill a Girl in A Manhattan Penthouse',2006,1,NULL,3,'4.99',109,'24.99','G','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (779,'SENSE GREEK','A Taut Saga of a Lumberjack And a Pastry Chef who must Escape a Sumo Wrestler in An Abandoned Fun House',2006,1,NULL,4,'4.99',54,'23.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (780,'SENSIBILITY REAR','A Emotional Tale of a Robot And a Sumo Wrestler who must Redeem a Pastry Chef in A Baloon Factory',2006,1,NULL,7,'4.99',98,'15.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (781,'SEVEN SWARM','A Unbelieveable Character Study of a Dog And a Mad Cow who must Kill a Monkey in Berlin',2006,1,NULL,4,'4.99',127,'15.99','R','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (782,'SHAKESPEARE SADDLE','A Fast-Paced Panorama of a Lumberjack And a Database Administrator who must Defeat a Madman in A MySQL Convention',2006,1,NULL,6,'2.99',60,'26.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (783,'SHANE DARKNESS','A Action-Packed Saga of a Moose And a Lumberjack who must Find a Woman in Berlin',2006,1,NULL,5,'2.99',93,'22.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (784,'SHANGHAI TYCOON','A Fast-Paced Character Study of a Crocodile And a Lumberjack who must Build a Husband in An Abandoned Fun House',2006,1,NULL,7,'2.99',47,'20.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (785,'SHAWSHANK BUBBLE','A Lacklusture Story of a Moose And a Monkey who must Confront a Butler in An Abandoned Amusement Park',2006,1,NULL,6,'4.99',80,'20.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (786,'SHEPHERD MIDSUMMER','A Thoughtful Drama of a Robot And a Womanizer who must Kill a Lumberjack in A Baloon',2006,1,NULL,7,'0.99',113,'14.99','R','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (787,'SHINING ROSES','A Awe-Inspiring Character Study of a Astronaut And a Forensic Psychologist who must Challenge a Madman in Ancient India',2006,1,NULL,4,'0.99',125,'12.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (788,'SHIP WONDERLAND','A Thrilling Saga of a Monkey And a Frisbee who must Escape a Explorer in The Outback',2006,1,NULL,5,'2.99',104,'15.99','R','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (789,'SHOCK CABIN','A Fateful Tale of a Mad Cow And a Crocodile who must Meet a Husband in New Orleans',2006,1,NULL,7,'2.99',79,'15.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (790,'SHOOTIST SUPERFLY','A Fast-Paced Story of a Crocodile And a A Shark who must Sink a Pioneer in Berlin',2006,1,NULL,6,'0.99',67,'22.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (791,'SHOW LORD','A Fanciful Saga of a Student And a Girl who must Find a Butler in Ancient Japan',2006,1,NULL,3,'4.99',167,'24.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (792,'SHREK LICENSE','A Fateful Yarn of a Secret Agent And a Feminist who must Find a Feminist in A Jet Boat',2006,1,NULL,7,'2.99',154,'15.99','PG-13','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (793,'SHRUNK DIVINE','A Fateful Character Study of a Waitress And a Technical Writer who must Battle a Hunter in A Baloon',2006,1,NULL,6,'2.99',139,'14.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (794,'SIDE ARK','A Stunning Panorama of a Crocodile And a Womanizer who must Meet a Feminist in The Canadian Rockies',2006,1,NULL,5,'0.99',52,'28.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (795,'SIEGE MADRE','A Boring Tale of a Frisbee And a Crocodile who must Vanquish a Moose in An Abandoned Mine Shaft',2006,1,NULL,7,'0.99',111,'23.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (796,'SIERRA DIVIDE','A Emotional Character Study of a Frisbee And a Mad Scientist who must Build a Madman in California',2006,1,NULL,3,'0.99',135,'12.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (797,'SILENCE KANE','A Emotional Drama of a Sumo Wrestler And a Dentist who must Confront a Sumo Wrestler in A Baloon',2006,1,NULL,7,'0.99',67,'23.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (798,'SILVERADO GOLDFINGER','A Stunning Epistle of a Sumo Wrestler And a Man who must Challenge a Waitress in Ancient India',2006,1,NULL,4,'4.99',74,'11.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (799,'SIMON NORTH','A Thrilling Documentary of a Technical Writer And a A Shark who must Face a Pioneer in A Shark Tank',2006,1,NULL,3,'0.99',51,'26.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (800,'SINNERS ATLANTIS','A Epic Display of a Dog And a Boat who must Succumb a Mad Scientist in An Abandoned Mine Shaft',2006,1,NULL,7,'2.99',126,'19.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (801,'SISTER FREDDY','A Stunning Saga of a Butler And a Woman who must Pursue a Explorer in Australia',2006,1,NULL,5,'4.99',152,'19.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (802,'SKY MIRACLE','A Epic Drama of a Mad Scientist And a Explorer who must Succumb a Waitress in An Abandoned Fun House',2006,1,NULL,7,'2.99',132,'15.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (803,'SLACKER LIAISONS','A Fast-Paced Tale of a A Shark And a Student who must Meet a Crocodile in Ancient China',2006,1,NULL,7,'4.99',179,'29.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (804,'SLEEPING SUSPECTS','A Stunning Reflection of a Sumo Wrestler And a Explorer who must Sink a Frisbee in A MySQL Convention',2006,1,NULL,7,'4.99',129,'13.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (805,'SLEEPLESS MONSOON','A Amazing Saga of a Moose And a Pastry Chef who must Escape a Butler in Australia',2006,1,NULL,5,'4.99',64,'12.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (806,'SLEEPY JAPANESE','A Emotional Epistle of a Moose And a Composer who must Fight a Technical Writer in The Outback',2006,1,NULL,4,'2.99',137,'25.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (807,'SLEUTH ORIENT','A Fateful Character Study of a Husband And a Dog who must Find a Feminist in Ancient India',2006,1,NULL,4,'0.99',87,'25.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (808,'SLING LUKE','A Intrepid Character Study of a Robot And a Monkey who must Reach a Secret Agent in An Abandoned Amusement Park',2006,1,NULL,5,'0.99',84,'10.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (809,'SLIPPER FIDELITY','A Taut Reflection of a Secret Agent And a Man who must Redeem a Explorer in A MySQL Convention',2006,1,NULL,5,'0.99',156,'14.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (810,'SLUMS DUCK','A Amazing Character Study of a Teacher And a Database Administrator who must Defeat a Waitress in A Jet Boat',2006,1,NULL,5,'0.99',147,'21.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (811,'SMILE EARRING','A Intrepid Drama of a Teacher And a Butler who must Build a Pastry Chef in Berlin',2006,1,NULL,4,'2.99',60,'29.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (812,'SMOKING BARBARELLA','A Lacklusture Saga of a Mad Cow And a Mad Scientist who must Sink a Cat in A MySQL Convention',2006,1,NULL,7,'0.99',50,'13.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (813,'SMOOCHY CONTROL','A Thrilling Documentary of a Husband And a Feminist who must Face a Mad Scientist in Ancient China',2006,1,NULL,7,'0.99',184,'18.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (814,'SNATCH SLIPPER','A Insightful Panorama of a Woman And a Feminist who must Defeat a Forensic Psychologist in Berlin',2006,1,NULL,6,'4.99',110,'15.99','PG','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (815,'SNATCHERS MONTEZUMA','A Boring Epistle of a Sumo Wrestler And a Woman who must Escape a Man in The Canadian Rockies',2006,1,NULL,4,'2.99',74,'14.99','PG-13','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (816,'SNOWMAN ROLLERCOASTER','A Fateful Display of a Lumberjack And a Girl who must Succumb a Mad Cow in A Manhattan Penthouse',2006,1,NULL,3,'0.99',62,'27.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (817,'SOLDIERS EVOLUTION','A Lacklusture Panorama of a A Shark And a Pioneer who must Confront a Student in The First Manned Space Station',2006,1,NULL,7,'4.99',185,'27.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (818,'SOMETHING DUCK','A Boring Character Study of a Car And a Husband who must Outgun a Frisbee in The First Manned Space Station',2006,1,NULL,4,'4.99',180,'17.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (819,'SONG HEDWIG','A Amazing Documentary of a Man And a Husband who must Confront a Squirrel in A MySQL Convention',2006,1,NULL,3,'0.99',165,'29.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (820,'SONS INTERVIEW','A Taut Character Study of a Explorer And a Mad Cow who must Battle a Hunter in Ancient China',2006,1,NULL,3,'2.99',184,'11.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (821,'SORORITY QUEEN','A Fast-Paced Display of a Squirrel And a Composer who must Fight a Forensic Psychologist in A Jet Boat',2006,1,NULL,6,'0.99',184,'17.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (822,'SOUP WISDOM','A Fast-Paced Display of a Robot And a Butler who must Defeat a Butler in A MySQL Convention',2006,1,NULL,6,'0.99',169,'12.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (823,'SOUTH WAIT','A Amazing Documentary of a Car And a Robot who must Escape a Lumberjack in An Abandoned Amusement Park',2006,1,NULL,4,'2.99',143,'21.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (824,'SPARTACUS CHEAPER','A Thrilling Panorama of a Pastry Chef And a Secret Agent who must Overcome a Student in A Manhattan Penthouse',2006,1,NULL,4,'4.99',52,'19.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (825,'SPEAKEASY DATE','A Lacklusture Drama of a Forensic Psychologist And a Car who must Redeem a Man in A Manhattan Penthouse',2006,1,NULL,6,'2.99',165,'22.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (826,'SPEED SUIT','A Brilliant Display of a Frisbee And a Mad Scientist who must Succumb a Robot in Ancient China',2006,1,NULL,7,'4.99',124,'19.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (827,'SPICE SORORITY','A Fateful Display of a Pioneer And a Hunter who must Defeat a Husband in An Abandoned Mine Shaft',2006,1,NULL,5,'4.99',141,'22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (828,'SPIKING ELEMENT','A Lacklusture Epistle of a Dentist And a Technical Writer who must Find a Dog in A Monastery',2006,1,NULL,7,'2.99',79,'12.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (829,'SPINAL ROCKY','A Lacklusture Epistle of a Sumo Wrestler And a Squirrel who must Defeat a Explorer in California',2006,1,NULL,7,'2.99',138,'12.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (830,'SPIRIT FLINTSTONES','A Brilliant Yarn of a Cat And a Car who must Confront a Explorer in Ancient Japan',2006,1,NULL,7,'0.99',149,'23.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (831,'SPIRITED CASUALTIES','A Taut Story of a Waitress And a Man who must Face a Car in A Baloon Factory',2006,1,NULL,5,'0.99',138,'20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (832,'SPLASH GUMP','A Taut Saga of a Crocodile And a Boat who must Conquer a Hunter in A Shark Tank',2006,1,NULL,5,'0.99',175,'16.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (833,'SPLENDOR PATTON','A Taut Story of a Dog And a Explorer who must Find a Astronaut in Berlin',2006,1,NULL,5,'0.99',134,'20.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (834,'SPOILERS HELLFIGHTERS','A Fanciful Story of a Technical Writer And a Squirrel who must Defeat a Dog in The Gulf of Mexico',2006,1,NULL,4,'0.99',151,'26.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (835,'SPY MILE','A Thrilling Documentary of a Feminist And a Feminist who must Confront a Feminist in A Baloon',2006,1,NULL,6,'2.99',112,'13.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (836,'SQUAD FISH','A Fast-Paced Display of a Pastry Chef And a Dog who must Kill a Teacher in Berlin',2006,1,NULL,3,'2.99',136,'14.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (837,'STAGE WORLD','A Lacklusture Panorama of a Woman And a Frisbee who must Chase a Crocodile in A Jet Boat',2006,1,NULL,4,'2.99',85,'19.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (838,'STAGECOACH ARMAGEDDON','A Touching Display of a Pioneer And a Butler who must Chase a Car in California',2006,1,NULL,5,'4.99',112,'25.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (839,'STALLION SUNDANCE','A Fast-Paced Tale of a Car And a Dog who must Outgun a A Shark in Australia',2006,1,NULL,5,'0.99',130,'23.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (840,'STAMPEDE DISTURBING','A Unbelieveable Tale of a Woman And a Lumberjack who must Fight a Frisbee in A U-Boat',2006,1,NULL,5,'0.99',75,'26.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (841,'STAR OPERATION','A Insightful Character Study of a Girl And a Car who must Pursue a Mad Cow in A Shark Tank',2006,1,NULL,5,'2.99',181,'9.99','PG','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (842,'STATE WASTELAND','A Beautiful Display of a Cat And a Pastry Chef who must Outrace a Mad Cow in A Jet Boat',2006,1,NULL,4,'2.99',113,'13.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (843,'STEEL SANTA','A Fast-Paced Yarn of a Composer And a Frisbee who must Face a Moose in Nigeria',2006,1,NULL,4,'4.99',143,'15.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (844,'STEERS ARMAGEDDON','A Stunning Character Study of a Car And a Girl who must Succumb a Car in A MySQL Convention',2006,1,NULL,6,'4.99',140,'16.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (845,'STEPMOM DREAM','A Touching Epistle of a Crocodile And a Teacher who must Build a Forensic Psychologist in A MySQL Convention',2006,1,NULL,7,'4.99',48,'9.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (846,'STING PERSONAL','A Fanciful Drama of a Frisbee And a Dog who must Fight a Madman in A Jet Boat',2006,1,NULL,3,'4.99',93,'9.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (847,'STOCK GLASS','A Boring Epistle of a Crocodile And a Lumberjack who must Outgun a Moose in Ancient China',2006,1,NULL,7,'2.99',160,'10.99','PG','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (848,'STONE FIRE','A Intrepid Drama of a Astronaut And a Crocodile who must Find a Boat in Soviet Georgia',2006,1,NULL,3,'0.99',94,'19.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (849,'STORM HAPPINESS','A Insightful Drama of a Feminist And a A Shark who must Vanquish a Boat in A Shark Tank',2006,1,NULL,6,'0.99',57,'28.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (850,'STORY SIDE','A Lacklusture Saga of a Boy And a Cat who must Sink a Dentist in An Abandoned Mine Shaft',2006,1,NULL,7,'0.99',163,'27.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (851,'STRAIGHT HOURS','A Boring Panorama of a Secret Agent And a Girl who must Sink a Waitress in The Outback',2006,1,NULL,3,'0.99',151,'19.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (852,'STRANGELOVE DESIRE','A Awe-Inspiring Panorama of a Lumberjack And a Waitress who must Defeat a Crocodile in An Abandoned Amusement Park',2006,1,NULL,4,'0.99',103,'27.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (853,'STRANGER STRANGERS','A Awe-Inspiring Yarn of a Womanizer And a Explorer who must Fight a Woman in The First Manned Space Station',2006,1,NULL,3,'4.99',139,'12.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (854,'STRANGERS GRAFFITI','A Brilliant Character Study of a Secret Agent And a Man who must Find a Cat in The Gulf of Mexico',2006,1,NULL,4,'4.99',119,'22.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (855,'STREAK RIDGEMONT','A Astounding Character Study of a Hunter And a Waitress who must Sink a Man in New Orleans',2006,1,NULL,7,'0.99',132,'28.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (856,'STREETCAR INTENTIONS','A Insightful Character Study of a Waitress And a Crocodile who must Sink a Waitress in The Gulf of Mexico',2006,1,NULL,5,'4.99',73,'11.99','R','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (857,'STRICTLY SCARFACE','A Touching Reflection of a Crocodile And a Dog who must Chase a Hunter in An Abandoned Fun House',2006,1,NULL,3,'2.99',144,'24.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (858,'SUBMARINE BED','A Amazing Display of a Car And a Monkey who must Fight a Teacher in Soviet Georgia',2006,1,NULL,5,'4.99',127,'21.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (859,'SUGAR WONKA','A Touching Story of a Dentist And a Database Administrator who must Conquer a Astronaut in An Abandoned Amusement Park',2006,1,NULL,3,'4.99',114,'20.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (860,'SUICIDES SILENCE','A Emotional Character Study of a Car And a Girl who must Face a Composer in A U-Boat',2006,1,NULL,4,'4.99',93,'13.99','G','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (861,'SUIT WALLS','A Touching Panorama of a Lumberjack And a Frisbee who must Build a Dog in Australia',2006,1,NULL,3,'4.99',111,'12.99','R','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (862,'SUMMER SCARFACE','A Emotional Panorama of a Lumberjack And a Hunter who must Meet a Girl in A Shark Tank',2006,1,NULL,5,'0.99',53,'25.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (863,'SUN CONFESSIONS','A Beautiful Display of a Mad Cow And a Dog who must Redeem a Waitress in An Abandoned Amusement Park',2006,1,NULL,5,'0.99',141,'9.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (864,'SUNDANCE INVASION','A Epic Drama of a Lumberjack And a Explorer who must Confront a Hunter in A Baloon Factory',2006,1,NULL,5,'0.99',92,'21.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (865,'SUNRISE LEAGUE','A Beautiful Epistle of a Madman And a Butler who must Face a Crocodile in A Manhattan Penthouse',2006,1,NULL,3,'4.99',135,'19.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (866,'SUNSET RACER','A Awe-Inspiring Reflection of a Astronaut And a A Shark who must Defeat a Forensic Psychologist in California',2006,1,NULL,6,'0.99',48,'28.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (867,'SUPER WYOMING','A Action-Packed Saga of a Pastry Chef And a Explorer who must Discover a A Shark in The Outback',2006,1,NULL,5,'4.99',58,'10.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (868,'SUPERFLY TRIP','A Beautiful Saga of a Lumberjack And a Teacher who must Build a Technical Writer in An Abandoned Fun House',2006,1,NULL,5,'0.99',114,'27.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (869,'SUSPECTS QUILLS','A Emotional Epistle of a Pioneer And a Crocodile who must Battle a Man in A Manhattan Penthouse',2006,1,NULL,4,'2.99',47,'22.99','PG','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (870,'SWARM GOLD','A Insightful Panorama of a Crocodile And a Boat who must Conquer a Sumo Wrestler in A MySQL Convention',2006,1,NULL,4,'0.99',123,'12.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (871,'SWEDEN SHINING','A Taut Documentary of a Car And a Robot who must Conquer a Boy in The Canadian Rockies',2006,1,NULL,6,'4.99',176,'19.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (872,'SWEET BROTHERHOOD','A Unbelieveable Epistle of a Sumo Wrestler And a Hunter who must Chase a Forensic Psychologist in A Baloon',2006,1,NULL,3,'2.99',185,'27.99','R','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (873,'SWEETHEARTS SUSPECTS','A Brilliant Character Study of a Frisbee And a Sumo Wrestler who must Confront a Woman in The Gulf of Mexico',2006,1,NULL,3,'0.99',108,'13.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (874,'TADPOLE PARK','A Beautiful Tale of a Frisbee And a Moose who must Vanquish a Dog in An Abandoned Amusement Park',2006,1,NULL,6,'2.99',155,'13.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (875,'TALENTED HOMICIDE','A Lacklusture Panorama of a Dentist And a Forensic Psychologist who must Outrace a Pioneer in A U-Boat',2006,1,NULL,6,'0.99',173,'9.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (876,'TARZAN VIDEOTAPE','A Fast-Paced Display of a Lumberjack And a Mad Scientist who must Succumb a Sumo Wrestler in The Sahara Desert',2006,1,NULL,3,'2.99',91,'11.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (877,'TAXI KICK','A Amazing Epistle of a Girl And a Woman who must Outrace a Waitress in Soviet Georgia',2006,1,NULL,4,'0.99',64,'23.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (878,'TEEN APOLLO','A Awe-Inspiring Drama of a Dog And a Man who must Escape a Robot in A Shark Tank',2006,1,NULL,3,'4.99',74,'25.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (879,'TELEGRAPH VOYAGE','A Fateful Yarn of a Husband And a Dog who must Battle a Waitress in A Jet Boat',2006,1,NULL,3,'4.99',148,'20.99','PG','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (880,'TELEMARK HEARTBREAKERS','A Action-Packed Panorama of a Technical Writer And a Man who must Build a Forensic Psychologist in A Manhattan Penthouse',2006,1,NULL,6,'2.99',152,'9.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (881,'TEMPLE ATTRACTION','A Action-Packed Saga of a Forensic Psychologist And a Woman who must Battle a Womanizer in Soviet Georgia',2006,1,NULL,5,'4.99',71,'13.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (882,'TENENBAUMS COMMAND','A Taut Display of a Pioneer And a Man who must Reach a Girl in The Gulf of Mexico',2006,1,NULL,4,'0.99',99,'24.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (883,'TEQUILA PAST','A Action-Packed Panorama of a Mad Scientist And a Robot who must Challenge a Student in Nigeria',2006,1,NULL,6,'4.99',53,'17.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (884,'TERMINATOR CLUB','A Touching Story of a Crocodile And a Girl who must Sink a Man in The Gulf of Mexico',2006,1,NULL,5,'4.99',88,'11.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (885,'TEXAS WATCH','A Awe-Inspiring Yarn of a Student And a Teacher who must Fight a Teacher in An Abandoned Amusement Park',2006,1,NULL,7,'0.99',179,'22.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (886,'THEORY MERMAID','A Fateful Yarn of a Composer And a Monkey who must Vanquish a Womanizer in The First Manned Space Station',2006,1,NULL,5,'0.99',184,'9.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (887,'THIEF PELICAN','A Touching Documentary of a Madman And a Mad Scientist who must Outrace a Feminist in An Abandoned Mine Shaft',2006,1,NULL,5,'4.99',135,'28.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (888,'THIN SAGEBRUSH','A Emotional Drama of a Husband And a Lumberjack who must Build a Cat in Ancient India',2006,1,NULL,5,'4.99',53,'9.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (889,'TIES HUNGER','A Insightful Saga of a Astronaut And a Explorer who must Pursue a Mad Scientist in A U-Boat',2006,1,NULL,3,'4.99',111,'28.99','R','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (890,'TIGHTS DAWN','A Thrilling Epistle of a Boat And a Secret Agent who must Face a Boy in A Baloon',2006,1,NULL,5,'0.99',172,'14.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (891,'TIMBERLAND SKY','A Boring Display of a Man And a Dog who must Redeem a Girl in A U-Boat',2006,1,NULL,3,'0.99',69,'13.99','G','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (892,'TITANIC BOONDOCK','A Brilliant Reflection of a Feminist And a Dog who must Fight a Boy in A Baloon Factory',2006,1,NULL,3,'4.99',104,'18.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (893,'TITANS JERK','A Unbelieveable Panorama of a Feminist And a Sumo Wrestler who must Challenge a Technical Writer in Ancient China',2006,1,NULL,4,'4.99',91,'11.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (894,'TOMATOES HELLFIGHTERS','A Thoughtful Epistle of a Madman And a Astronaut who must Overcome a Monkey in A Shark Tank',2006,1,NULL,6,'0.99',68,'23.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (895,'TOMORROW HUSTLER','A Thoughtful Story of a Moose And a Husband who must Face a Secret Agent in The Sahara Desert',2006,1,NULL,3,'2.99',142,'21.99','R','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (896,'TOOTSIE PILOT','A Awe-Inspiring Documentary of a Womanizer And a Pastry Chef who must Kill a Lumberjack in Berlin',2006,1,NULL,3,'0.99',157,'10.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (897,'TORQUE BOUND','A Emotional Display of a Crocodile And a Husband who must Reach a Man in Ancient Japan',2006,1,NULL,3,'4.99',179,'27.99','G','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (898,'TOURIST PELICAN','A Boring Story of a Butler And a Astronaut who must Outrace a Pioneer in Australia',2006,1,NULL,4,'4.99',152,'18.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (899,'TOWERS HURRICANE','A Fateful Display of a Monkey And a Car who must Sink a Husband in A MySQL Convention',2006,1,NULL,7,'0.99',144,'14.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (900,'TOWN ARK','A Awe-Inspiring Documentary of a Moose And a Madman who must Meet a Dog in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',136,'17.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (901,'TRACY CIDER','A Touching Reflection of a Database Administrator And a Madman who must Build a Lumberjack in Nigeria',2006,1,NULL,3,'0.99',142,'29.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (902,'TRADING PINOCCHIO','A Emotional Character Study of a Student And a Explorer who must Discover a Frisbee in The First Manned Space Station',2006,1,NULL,6,'4.99',170,'22.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (903,'TRAFFIC HOBBIT','A Amazing Epistle of a Squirrel And a Lumberjack who must Succumb a Database Administrator in A U-Boat',2006,1,NULL,5,'4.99',139,'13.99','G','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (904,'TRAIN BUNCH','A Thrilling Character Study of a Robot And a Squirrel who must Face a Dog in Ancient India',2006,1,NULL,3,'4.99',71,'26.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (905,'TRAINSPOTTING STRANGERS','A Fast-Paced Drama of a Pioneer And a Mad Cow who must Challenge a Madman in Ancient Japan',2006,1,NULL,7,'4.99',132,'10.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (906,'TRAMP OTHERS','A Brilliant Display of a Composer And a Cat who must Succumb a A Shark in Ancient India',2006,1,NULL,4,'0.99',171,'27.99','PG','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (907,'TRANSLATION SUMMER','A Touching Reflection of a Man And a Monkey who must Pursue a Womanizer in A MySQL Convention',2006,1,NULL,4,'0.99',168,'10.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (908,'TRAP GUYS','A Unbelieveable Story of a Boy And a Mad Cow who must Challenge a Database Administrator in The Sahara Desert',2006,1,NULL,3,'4.99',110,'11.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (909,'TREASURE COMMAND','A Emotional Saga of a Car And a Madman who must Discover a Pioneer in California',2006,1,NULL,3,'0.99',102,'28.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (910,'TREATMENT JEKYLL','A Boring Story of a Teacher And a Student who must Outgun a Cat in An Abandoned Mine Shaft',2006,1,NULL,3,'0.99',87,'19.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (911,'TRIP NEWTON','A Fanciful Character Study of a Lumberjack And a Car who must Discover a Cat in An Abandoned Amusement Park',2006,1,NULL,7,'4.99',64,'14.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (912,'TROJAN TOMORROW','A Astounding Panorama of a Husband And a Sumo Wrestler who must Pursue a Boat in Ancient India',2006,1,NULL,3,'2.99',52,'9.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (913,'TROOPERS METAL','A Fanciful Drama of a Monkey And a Feminist who must Sink a Man in Berlin',2006,1,NULL,3,'0.99',115,'20.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (914,'TROUBLE DATE','A Lacklusture Panorama of a Forensic Psychologist And a Woman who must Kill a Explorer in Ancient Japan',2006,1,NULL,6,'2.99',61,'13.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (915,'TRUMAN CRAZY','A Thrilling Epistle of a Moose And a Boy who must Meet a Database Administrator in A Monastery',2006,1,NULL,7,'4.99',92,'9.99','G','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (916,'TURN STAR','A Stunning Tale of a Man And a Monkey who must Chase a Student in New Orleans',2006,1,NULL,3,'2.99',80,'10.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (917,'TUXEDO MILE','A Boring Drama of a Man And a Forensic Psychologist who must Face a Frisbee in Ancient India',2006,1,NULL,3,'2.99',152,'24.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (918,'TWISTED PIRATES','A Touching Display of a Frisbee And a Boat who must Kill a Girl in A MySQL Convention',2006,1,NULL,4,'4.99',152,'23.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (919,'TYCOON GATHERING','A Emotional Display of a Husband And a A Shark who must Succumb a Madman in A Manhattan Penthouse',2006,1,NULL,3,'4.99',82,'17.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (920,'UNBREAKABLE KARATE','A Amazing Character Study of a Robot And a Student who must Chase a Robot in Australia',2006,1,NULL,3,'0.99',62,'16.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (921,'UNCUT SUICIDES','A Intrepid Yarn of a Explorer And a Pastry Chef who must Pursue a Mad Cow in A U-Boat',2006,1,NULL,7,'2.99',172,'29.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (922,'UNDEFEATED DALMATIONS','A Unbelieveable Display of a Crocodile And a Feminist who must Overcome a Moose in An Abandoned Amusement Park',2006,1,NULL,7,'4.99',107,'22.99','PG-13','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (923,'UNFAITHFUL KILL','A Taut Documentary of a Waitress And a Mad Scientist who must Battle a Technical Writer in New Orleans',2006,1,NULL,7,'2.99',78,'12.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (924,'UNFORGIVEN ZOOLANDER','A Taut Epistle of a Monkey And a Sumo Wrestler who must Vanquish a A Shark in A Baloon Factory',2006,1,NULL,7,'0.99',129,'15.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (925,'UNITED PILOT','A Fast-Paced Reflection of a Cat And a Mad Cow who must Fight a Car in The Sahara Desert',2006,1,NULL,3,'0.99',164,'27.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (926,'UNTOUCHABLES SUNRISE','A Amazing Documentary of a Woman And a Astronaut who must Outrace a Teacher in An Abandoned Fun House',2006,1,NULL,5,'2.99',120,'11.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (927,'UPRISING UPTOWN','A Fanciful Reflection of a Boy And a Butler who must Pursue a Woman in Berlin',2006,1,NULL,6,'2.99',174,'16.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (928,'UPTOWN YOUNG','A Fateful Documentary of a Dog And a Hunter who must Pursue a Teacher in An Abandoned Amusement Park',2006,1,NULL,5,'2.99',84,'16.99','PG','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (929,'USUAL UNTOUCHABLES','A Touching Display of a Explorer And a Lumberjack who must Fight a Forensic Psychologist in A Shark Tank',2006,1,NULL,5,'4.99',128,'21.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (930,'VACATION BOONDOCK','A Fanciful Character Study of a Secret Agent And a Mad Scientist who must Reach a Teacher in Australia',2006,1,NULL,4,'2.99',145,'23.99','R','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (931,'VALENTINE VANISHING','A Thrilling Display of a Husband And a Butler who must Reach a Pastry Chef in California',2006,1,NULL,7,'0.99',48,'9.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (932,'VALLEY PACKER','A Astounding Documentary of a Astronaut And a Boy who must Outrace a Sumo Wrestler in Berlin',2006,1,NULL,3,'0.99',73,'21.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (933,'VAMPIRE WHALE','A Epic Story of a Lumberjack And a Monkey who must Confront a Pioneer in A MySQL Convention',2006,1,NULL,4,'4.99',126,'11.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (934,'VANILLA DAY','A Fast-Paced Saga of a Girl And a Forensic Psychologist who must Redeem a Girl in Nigeria',2006,1,NULL,7,'4.99',122,'20.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (935,'VANISHED GARDEN','A Intrepid Character Study of a Squirrel And a A Shark who must Kill a Lumberjack in California',2006,1,NULL,5,'0.99',142,'17.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (936,'VANISHING ROCKY','A Brilliant Reflection of a Man And a Woman who must Conquer a Pioneer in A MySQL Convention',2006,1,NULL,3,'2.99',123,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (937,'VARSITY TRIP','A Action-Packed Character Study of a Astronaut And a Explorer who must Reach a Monkey in A MySQL Convention',2006,1,NULL,7,'2.99',85,'14.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (938,'VELVET TERMINATOR','A Lacklusture Tale of a Pastry Chef And a Technical Writer who must Confront a Crocodile in An Abandoned Amusement Park',2006,1,NULL,3,'4.99',173,'14.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (939,'VERTIGO NORTHWEST','A Unbelieveable Display of a Mad Scientist And a Mad Scientist who must Outgun a Mad Cow in Ancient Japan',2006,1,NULL,4,'2.99',90,'17.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (940,'VICTORY ACADEMY','A Insightful Epistle of a Mad Scientist And a Explorer who must Challenge a Cat in The Sahara Desert',2006,1,NULL,6,'0.99',64,'19.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (941,'VIDEOTAPE ARSENIC','A Lacklusture Display of a Girl And a Astronaut who must Succumb a Student in Australia',2006,1,NULL,4,'4.99',145,'10.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (942,'VIETNAM SMOOCHY','A Lacklusture Display of a Butler And a Man who must Sink a Explorer in Soviet Georgia',2006,1,NULL,7,'0.99',174,'27.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (943,'VILLAIN DESPERATE','A Boring Yarn of a Pioneer And a Feminist who must Redeem a Cat in An Abandoned Amusement Park',2006,1,NULL,4,'4.99',76,'27.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (944,'VIRGIN DAISY','A Awe-Inspiring Documentary of a Robot And a Mad Scientist who must Reach a Database Administrator in A Shark Tank',2006,1,NULL,6,'4.99',179,'29.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (945,'VIRGINIAN PLUTO','A Emotional Panorama of a Dentist And a Crocodile who must Meet a Boy in Berlin',2006,1,NULL,5,'0.99',164,'22.99','R','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (946,'VIRTUAL SPOILERS','A Fateful Tale of a Database Administrator And a Squirrel who must Discover a Student in Soviet Georgia',2006,1,NULL,3,'4.99',144,'14.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (947,'VISION TORQUE','A Thoughtful Documentary of a Dog And a Man who must Sink a Man in A Shark Tank',2006,1,NULL,5,'0.99',59,'16.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (948,'VOICE PEACH','A Amazing Panorama of a Pioneer And a Student who must Overcome a Mad Scientist in A Manhattan Penthouse',2006,1,NULL,6,'0.99',139,'22.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (949,'VOLCANO TEXAS','A Awe-Inspiring Yarn of a Hunter And a Feminist who must Challenge a Dentist in The Outback',2006,1,NULL,6,'0.99',157,'27.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (950,'VOLUME HOUSE','A Boring Tale of a Dog And a Woman who must Meet a Dentist in California',2006,1,NULL,7,'4.99',132,'12.99','PG','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (951,'VOYAGE LEGALLY','A Epic Tale of a Squirrel And a Hunter who must Conquer a Boy in An Abandoned Mine Shaft',2006,1,NULL,6,'0.99',78,'28.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (952,'WAGON JAWS','A Intrepid Drama of a Moose And a Boat who must Kill a Explorer in A Manhattan Penthouse',2006,1,NULL,7,'2.99',152,'17.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (953,'WAIT CIDER','A Intrepid Epistle of a Woman And a Forensic Psychologist who must Succumb a Astronaut in A Manhattan Penthouse',2006,1,NULL,3,'0.99',112,'9.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (954,'WAKE JAWS','A Beautiful Saga of a Feminist And a Composer who must Challenge a Moose in Berlin',2006,1,NULL,7,'4.99',73,'18.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (955,'WALLS ARTIST','A Insightful Panorama of a Teacher And a Teacher who must Overcome a Mad Cow in An Abandoned Fun House',2006,1,NULL,7,'4.99',135,'19.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (956,'WANDA CHAMBER','A Insightful Drama of a A Shark And a Pioneer who must Find a Womanizer in The Outback',2006,1,NULL,7,'4.99',107,'23.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (957,'WAR NOTTING','A Boring Drama of a Teacher And a Sumo Wrestler who must Challenge a Secret Agent in The Canadian Rockies',2006,1,NULL,7,'4.99',80,'26.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (958,'WARDROBE PHANTOM','A Action-Packed Display of a Mad Cow And a Astronaut who must Kill a Car in Ancient India',2006,1,NULL,6,'2.99',178,'19.99','G','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (959,'WARLOCK WEREWOLF','A Astounding Yarn of a Pioneer And a Crocodile who must Defeat a A Shark in The Outback',2006,1,NULL,6,'2.99',83,'10.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (960,'WARS PLUTO','A Taut Reflection of a Teacher And a Database Administrator who must Chase a Madman in The Sahara Desert',2006,1,NULL,5,'2.99',128,'15.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (961,'WASH HEAVENLY','A Awe-Inspiring Reflection of a Cat And a Pioneer who must Escape a Hunter in Ancient China',2006,1,NULL,7,'4.99',161,'22.99','R','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (962,'WASTELAND DIVINE','A Fanciful Story of a Database Administrator And a Womanizer who must Fight a Database Administrator in Ancient China',2006,1,NULL,7,'2.99',85,'18.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (963,'WATCH TRACY','A Fast-Paced Yarn of a Dog And a Frisbee who must Conquer a Hunter in Nigeria',2006,1,NULL,5,'0.99',78,'12.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (964,'WATERFRONT DELIVERANCE','A Unbelieveable Documentary of a Dentist And a Technical Writer who must Build a Womanizer in Nigeria',2006,1,NULL,4,'4.99',61,'17.99','G','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (965,'WATERSHIP FRONTIER','A Emotional Yarn of a Boat And a Crocodile who must Meet a Moose in Soviet Georgia',2006,1,NULL,6,'0.99',112,'28.99','G','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (966,'WEDDING APOLLO','A Action-Packed Tale of a Student And a Waitress who must Conquer a Lumberjack in An Abandoned Mine Shaft',2006,1,NULL,3,'0.99',70,'14.99','PG','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (967,'WEEKEND PERSONAL','A Fast-Paced Documentary of a Car And a Butler who must Find a Frisbee in A Jet Boat',2006,1,NULL,5,'2.99',134,'26.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (968,'WEREWOLF LOLA','A Fanciful Story of a Man And a Sumo Wrestler who must Outrace a Student in A Monastery',2006,1,NULL,6,'4.99',79,'19.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (969,'WEST LION','A Intrepid Drama of a Butler And a Lumberjack who must Challenge a Database Administrator in A Manhattan Penthouse',2006,1,NULL,4,'4.99',159,'29.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (970,'WESTWARD SEABISCUIT','A Lacklusture Tale of a Butler And a Husband who must Face a Boy in Ancient China',2006,1,NULL,7,'0.99',52,'11.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (971,'WHALE BIKINI','A Intrepid Story of a Pastry Chef And a Database Administrator who must Kill a Feminist in A MySQL Convention',2006,1,NULL,4,'4.99',109,'11.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (972,'WHISPERER GIANT','A Intrepid Story of a Dentist And a Hunter who must Confront a Monkey in Ancient Japan',2006,1,NULL,4,'4.99',59,'24.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (973,'WIFE TURN','A Awe-Inspiring Epistle of a Teacher And a Feminist who must Confront a Pioneer in Ancient Japan',2006,1,NULL,3,'4.99',183,'27.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (974,'WILD APOLLO','A Beautiful Story of a Monkey And a Sumo Wrestler who must Conquer a A Shark in A MySQL Convention',2006,1,NULL,4,'0.99',181,'24.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (975,'WILLOW TRACY','A Brilliant Panorama of a Boat And a Astronaut who must Challenge a Teacher in A Manhattan Penthouse',2006,1,NULL,6,'2.99',137,'22.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (976,'WIND PHANTOM','A Touching Saga of a Madman And a Forensic Psychologist who must Build a Sumo Wrestler in An Abandoned Mine Shaft',2006,1,NULL,6,'0.99',111,'12.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (977,'WINDOW SIDE','A Astounding Character Study of a Womanizer And a Hunter who must Escape a Robot in A Monastery',2006,1,NULL,3,'2.99',85,'25.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (978,'WISDOM WORKER','A Unbelieveable Saga of a Forensic Psychologist And a Student who must Face a Squirrel in The First Manned Space Station',2006,1,NULL,3,'0.99',98,'12.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (979,'WITCHES PANIC','A Awe-Inspiring Drama of a Secret Agent And a Hunter who must Fight a Moose in Nigeria',2006,1,NULL,6,'4.99',100,'10.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (980,'WIZARD COLDBLOODED','A Lacklusture Display of a Robot And a Girl who must Defeat a Sumo Wrestler in A MySQL Convention',2006,1,NULL,4,'4.99',75,'12.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (981,'WOLVES DESIRE','A Fast-Paced Drama of a Squirrel And a Robot who must Succumb a Technical Writer in A Manhattan Penthouse',2006,1,NULL,7,'0.99',55,'13.99','NC-17','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (982,'WOMEN DORADO','A Insightful Documentary of a Waitress And a Butler who must Vanquish a Composer in Australia',2006,1,NULL,4,'0.99',126,'23.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (983,'WON DARES','A Unbelieveable Documentary of a Teacher And a Monkey who must Defeat a Explorer in A U-Boat',2006,1,NULL,7,'2.99',105,'18.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (984,'WONDERFUL DROP','A Boring Panorama of a Woman And a Madman who must Overcome a Butler in A U-Boat',2006,1,NULL,3,'2.99',126,'20.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (985,'WONDERLAND CHRISTMAS','A Awe-Inspiring Character Study of a Waitress And a Car who must Pursue a Mad Scientist in The First Manned Space Station',2006,1,NULL,4,'4.99',111,'19.99','PG','Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (986,'WONKA SEA','A Brilliant Saga of a Boat And a Mad Scientist who must Meet a Moose in Ancient India',2006,1,NULL,6,'2.99',85,'24.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (987,'WORDS HUNTER','A Action-Packed Reflection of a Composer And a Mad Scientist who must Face a Pioneer in A MySQL Convention',2006,1,NULL,3,'2.99',116,'13.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (988,'WORKER TARZAN','A Action-Packed Yarn of a Secret Agent And a Technical Writer who must Battle a Sumo Wrestler in The First Manned Space Station',2006,1,NULL,7,'2.99',139,'26.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (989,'WORKING MICROCOSMOS','A Stunning Epistle of a Dentist And a Dog who must Kill a Madman in Ancient China',2006,1,NULL,4,'4.99',74,'22.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (990,'WORLD LEATHERNECKS','A Unbelieveable Tale of a Pioneer And a Astronaut who must Overcome a Robot in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',171,'13.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (991,'WORST BANGER','A Thrilling Drama of a Madman And a Dentist who must Conquer a Boy in The Outback',2006,1,NULL,4,'2.99',185,'26.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (992,'WRATH MILE','A Intrepid Reflection of a Technical Writer And a Hunter who must Defeat a Sumo Wrestler in A Monastery',2006,1,NULL,5,'0.99',176,'17.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (993,'WRONG BEHAVIOR','A Emotional Saga of a Crocodile And a Sumo Wrestler who must Discover a Mad Cow in New Orleans',2006,1,NULL,6,'2.99',178,'10.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (994,'WYOMING STORM','A Awe-Inspiring Panorama of a Robot And a Boat who must Overcome a Feminist in A U-Boat',2006,1,NULL,6,'4.99',100,'29.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (995,'YENTL IDAHO','A Amazing Display of a Robot And a Astronaut who must Fight a Womanizer in Berlin',2006,1,NULL,5,'4.99',86,'11.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (996,'YOUNG LANGUAGE','A Unbelieveable Yarn of a Boat And a Database Administrator who must Meet a Boy in The First Manned Space Station',2006,1,NULL,6,'0.99',183,'9.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (997,'YOUTH KICK','A Touching Drama of a Teacher And a Cat who must Challenge a Technical Writer in A U-Boat',2006,1,NULL,4,'0.99',179,'14.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (998,'ZHIVAGO CORE','A Fateful Yarn of a Composer And a Man who must Face a Boy in The Canadian Rockies',2006,1,NULL,6,'0.99',105,'10.99','NC-17','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (999,'ZOOLANDER FICTION','A Fateful Reflection of a Waitress And a Boat who must Discover a Sumo Wrestler in Ancient China',2006,1,NULL,5,'2.99',101,'28.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `film` VALUES   (1000,'ZORRO ARK','A Intrepid Panorama of a Mad Scientist And a Boy who must Redeem a Boy in A Monastery',2006,1,NULL,3,'4.99',50,'18.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');

DROP TRIGGER /*!50030 IF EXISTS */ `ins_film`;

DELIMITER $$

CREATE DEFINER = `root`@`%` TRIGGER `ins_film` AFTER INSERT ON `film` FOR EACH ROW BEGIN
    INSERT INTO film_text (film_id, title, description)
        VALUES (new.film_id, new.title, new.description);
  END $$

DELIMITER ;

DROP TRIGGER /*!50030 IF EXISTS */ `upd_film`;

DELIMITER $$

CREATE DEFINER = `root`@`%` TRIGGER `upd_film` AFTER UPDATE ON `film` FOR EACH ROW BEGIN
    IF (old.title != new.title) or (old.description != new.description)
    THEN
        UPDATE film_text
            SET title=new.title,
                description=new.description,
                film_id=new.film_id
        WHERE film_id=old.film_id;
    END IF;
  END $$

DELIMITER ;

DROP TRIGGER /*!50030 IF EXISTS */ `del_film`;

DELIMITER $$

CREATE DEFINER = `root`@`%` TRIGGER `del_film` AFTER DELETE ON `film` FOR EACH ROW BEGIN
    DELETE FROM film_text WHERE film_id = old.film_id;
  END $$

DELIMITER ;

DROP TABLE IF EXISTS `city`;
CREATE TABLE `city` (
  `city_id` smallint(5) unsigned NOT NULL auto_increment,
  `city` varchar(50) NOT NULL,
  `country_id` smallint(5) unsigned NOT NULL,
  `last_update` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`city_id`),
  KEY `idx_fk_country_id` (`country_id`),
  CONSTRAINT `fk_city_country` FOREIGN KEY (`country_id`) REFERENCES `country` (`country_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `city` VALUES   (1,'A Corua (La Corua)',87,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (2,'Abha',82,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (3,'Abu Dhabi',101,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (4,'Acua',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (5,'Adana',97,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (6,'Addis Abeba',31,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (7,'Aden',107,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (8,'Adoni',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (9,'Ahmadnagar',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (10,'Akishima',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (11,'Akron',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (12,'al-Ayn',101,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (13,'al-Hawiya',82,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (14,'al-Manama',11,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (15,'al-Qadarif',89,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (16,'al-Qatif',82,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (17,'Alessandria',49,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (18,'Allappuzha (Alleppey)',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (19,'Allende',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (20,'Almirante Brown',6,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (21,'Alvorada',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (22,'Ambattur',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (23,'Amersfoort',67,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (24,'Amroha',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (25,'Angra dos Reis',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (26,'Anpolis',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (27,'Antofagasta',22,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (28,'Aparecida de Goinia',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (29,'Apeldoorn',67,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (30,'Araatuba',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (31,'Arak',46,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (32,'Arecibo',77,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (33,'Arlington',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (34,'Ashdod',48,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (35,'Ashgabat',98,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (36,'Ashqelon',48,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (37,'Asuncin',73,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (38,'Athenai',39,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (39,'Atinsk',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (40,'Atlixco',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (41,'Augusta-Richmond County',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (42,'Aurora',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (43,'Avellaneda',6,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (44,'Bag',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (45,'Baha Blanca',6,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (46,'Baicheng',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (47,'Baiyin',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (48,'Baku',10,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (49,'Balaiha',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (50,'Balikesir',97,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (51,'Balurghat',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (52,'Bamenda',19,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (53,'Bandar Seri Begawan',16,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (54,'Banjul',37,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (55,'Barcelona',104,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (56,'Basel',91,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (57,'Bat Yam',48,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (58,'Batman',97,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (59,'Batna',2,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (60,'Battambang',18,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (61,'Baybay',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (62,'Bayugan',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (63,'Bchar',2,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (64,'Beira',63,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (65,'Bellevue',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (66,'Belm',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (67,'Benguela',4,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (68,'Beni-Mellal',62,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (69,'Benin City',69,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (70,'Bergamo',49,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (71,'Berhampore (Baharampur)',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (72,'Bern',91,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (73,'Bhavnagar',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (74,'Bhilwara',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (75,'Bhimavaram',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (76,'Bhopal',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (77,'Bhusawal',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (78,'Bijapur',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (79,'Bilbays',29,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (80,'Binzhou',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (81,'Birgunj',66,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (82,'Bislig',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (83,'Blumenau',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (84,'Boa Vista',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (85,'Boksburg',85,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (86,'Botosani',78,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (87,'Botshabelo',85,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (88,'Bradford',102,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (89,'Braslia',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (90,'Bratislava',84,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (91,'Brescia',49,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (92,'Brest',34,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (93,'Brindisi',49,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (94,'Brockton',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (95,'Bucuresti',78,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (96,'Buenaventura',24,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (97,'Bydgoszcz',76,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (98,'Cabuyao',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (99,'Callao',74,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (100,'Cam Ranh',105,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (101,'Cape Coral',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (102,'Caracas',104,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (103,'Carmen',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (104,'Cavite',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (105,'Cayenne',35,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (106,'Celaya',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (107,'Chandrapur',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (108,'Changhwa',92,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (109,'Changzhou',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (110,'Chapra',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (111,'Charlotte Amalie',106,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (112,'Chatsworth',85,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (113,'Cheju',86,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (114,'Chiayi',92,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (115,'Chisinau',61,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (116,'Chungho',92,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (117,'Cianjur',45,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (118,'Ciomas',45,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (119,'Ciparay',45,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (120,'Citrus Heights',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (121,'Citt del Vaticano',41,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (122,'Ciudad del Este',73,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (123,'Clarksville',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (124,'Coacalco de Berriozbal',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (125,'Coatzacoalcos',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (126,'Compton',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (127,'Coquimbo',22,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (128,'Crdoba',6,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (129,'Cuauhtmoc',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (130,'Cuautla',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (131,'Cuernavaca',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (132,'Cuman',104,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (133,'Czestochowa',76,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (134,'Dadu',72,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (135,'Dallas',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (136,'Datong',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (137,'Daugavpils',54,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (138,'Davao',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (139,'Daxian',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (140,'Dayton',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (141,'Deba Habe',69,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (142,'Denizli',97,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (143,'Dhaka',12,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (144,'Dhule (Dhulia)',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (145,'Dongying',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (146,'Donostia-San Sebastin',87,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (147,'Dos Quebradas',24,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (148,'Duisburg',38,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (149,'Dundee',102,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (150,'Dzerzinsk',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (151,'Ede',67,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (152,'Effon-Alaiye',69,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (153,'El Alto',14,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (154,'El Fuerte',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (155,'El Monte',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (156,'Elista',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (157,'Emeishan',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (158,'Emmen',67,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (159,'Enshi',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (160,'Erlangen',38,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (161,'Escobar',6,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (162,'Esfahan',46,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (163,'Eskisehir',97,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (164,'Etawah',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (165,'Ezeiza',6,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (166,'Ezhou',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (167,'Faaa',36,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (168,'Fengshan',92,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (169,'Firozabad',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (170,'Florencia',24,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (171,'Fontana',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (172,'Fukuyama',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (173,'Funafuti',99,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (174,'Fuyu',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (175,'Fuzhou',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (176,'Gandhinagar',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (177,'Garden Grove',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (178,'Garland',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (179,'Gatineau',20,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (180,'Gaziantep',97,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (181,'Gijn',87,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (182,'Gingoog',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (183,'Goinia',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (184,'Gorontalo',45,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (185,'Grand Prairie',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (186,'Graz',9,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (187,'Greensboro',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (188,'Guadalajara',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (189,'Guaruj',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (190,'guas Lindas de Gois',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (191,'Gulbarga',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (192,'Hagonoy',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (193,'Haining',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (194,'Haiphong',105,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (195,'Haldia',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (196,'Halifax',20,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (197,'Halisahar',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (198,'Halle/Saale',38,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (199,'Hami',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (200,'Hamilton',68,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (201,'Hanoi',105,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (202,'Hidalgo',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (203,'Higashiosaka',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (204,'Hino',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (205,'Hiroshima',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (206,'Hodeida',107,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (207,'Hohhot',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (208,'Hoshiarpur',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (209,'Hsichuh',92,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (210,'Huaian',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (211,'Hubli-Dharwad',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (212,'Huejutla de Reyes',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (213,'Huixquilucan',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (214,'Hunuco',74,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (215,'Ibirit',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (216,'Idfu',29,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (217,'Ife',69,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (218,'Ikerre',69,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (219,'Iligan',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (220,'Ilorin',69,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (221,'Imus',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (222,'Inegl',97,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (223,'Ipoh',59,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (224,'Isesaki',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (225,'Ivanovo',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (226,'Iwaki',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (227,'Iwakuni',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (228,'Iwatsuki',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (229,'Izumisano',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (230,'Jaffna',88,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (231,'Jaipur',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (232,'Jakarta',45,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (233,'Jalib al-Shuyukh',53,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (234,'Jamalpur',12,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (235,'Jaroslavl',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (236,'Jastrzebie-Zdrj',76,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (237,'Jedda',82,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (238,'Jelets',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (239,'Jhansi',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (240,'Jinchang',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (241,'Jining',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (242,'Jinzhou',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (243,'Jodhpur',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (244,'Johannesburg',85,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (245,'Joliet',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (246,'Jos Azueta',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (247,'Juazeiro do Norte',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (248,'Juiz de Fora',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (249,'Junan',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (250,'Jurez',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (251,'Kabul',1,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (252,'Kaduna',69,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (253,'Kakamigahara',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (254,'Kaliningrad',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (255,'Kalisz',76,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (256,'Kamakura',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (257,'Kamarhati',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (258,'Kamjanets-Podilskyi',100,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (259,'Kamyin',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (260,'Kanazawa',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (261,'Kanchrapara',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (262,'Kansas City',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (263,'Karnal',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (264,'Katihar',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (265,'Kermanshah',46,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (266,'Kilis',97,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (267,'Kimberley',85,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (268,'Kimchon',86,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (269,'Kingstown',81,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (270,'Kirovo-Tepetsk',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (271,'Kisumu',52,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (272,'Kitwe',109,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (273,'Klerksdorp',85,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (274,'Kolpino',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (275,'Konotop',100,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (276,'Koriyama',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (277,'Korla',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (278,'Korolev',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (279,'Kowloon and New Kowloon',42,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (280,'Kragujevac',108,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (281,'Ktahya',97,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (282,'Kuching',59,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (283,'Kumbakonam',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (284,'Kurashiki',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (285,'Kurgan',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (286,'Kursk',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (287,'Kuwana',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (288,'La Paz',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (289,'La Plata',6,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (290,'La Romana',27,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (291,'Laiwu',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (292,'Lancaster',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (293,'Laohekou',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (294,'Lapu-Lapu',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (295,'Laredo',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (296,'Lausanne',91,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (297,'Le Mans',34,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (298,'Lengshuijiang',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (299,'Leshan',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (300,'Lethbridge',20,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (301,'Lhokseumawe',45,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (302,'Liaocheng',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (303,'Liepaja',54,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (304,'Lilongwe',58,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (305,'Lima',74,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (306,'Lincoln',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (307,'Linz',9,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (308,'Lipetsk',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (309,'Livorno',49,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (310,'Ljubertsy',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (311,'Loja',28,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (312,'London',102,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (313,'London',20,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (314,'Lublin',76,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (315,'Lubumbashi',25,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (316,'Lungtan',92,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (317,'Luzinia',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (318,'Madiun',45,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (319,'Mahajanga',57,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (320,'Maikop',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (321,'Malm',90,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (322,'Manchester',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (323,'Mandaluyong',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (324,'Mandi Bahauddin',72,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (325,'Mannheim',38,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (326,'Maracabo',104,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (327,'Mardan',72,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (328,'Maring',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (329,'Masqat',71,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (330,'Matamoros',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (331,'Matsue',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (332,'Meixian',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (333,'Memphis',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (334,'Merlo',6,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (335,'Mexicali',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (336,'Miraj',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (337,'Mit Ghamr',29,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (338,'Miyakonojo',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (339,'Mogiljov',13,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (340,'Molodetno',13,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (341,'Monclova',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (342,'Monywa',64,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (343,'Moscow',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (344,'Mosul',47,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (345,'Mukateve',100,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (346,'Munger (Monghyr)',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (347,'Mwanza',93,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (348,'Mwene-Ditu',25,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (349,'Myingyan',64,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (350,'Mysore',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (351,'Naala-Porto',63,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (352,'Nabereznyje Telny',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (353,'Nador',62,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (354,'Nagaon',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (355,'Nagareyama',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (356,'Najafabad',46,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (357,'Naju',86,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (358,'Nakhon Sawan',94,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (359,'Nam Dinh',105,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (360,'Namibe',4,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (361,'Nantou',92,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (362,'Nanyang',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (363,'NDjamna',21,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (364,'Newcastle',85,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (365,'Nezahualcyotl',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (366,'Nha Trang',105,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (367,'Niznekamsk',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (368,'Novi Sad',108,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (369,'Novoterkassk',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (370,'Nukualofa',95,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (371,'Nuuk',40,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (372,'Nyeri',52,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (373,'Ocumare del Tuy',104,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (374,'Ogbomosho',69,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (375,'Okara',72,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (376,'Okayama',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (377,'Okinawa',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (378,'Olomouc',26,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (379,'Omdurman',89,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (380,'Omiya',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (381,'Ondo',69,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (382,'Onomichi',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (383,'Oshawa',20,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (384,'Osmaniye',97,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (385,'ostka',100,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (386,'Otsu',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (387,'Oulu',33,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (388,'Ourense (Orense)',87,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (389,'Owo',69,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (390,'Oyo',69,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (391,'Ozamis',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (392,'Paarl',85,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (393,'Pachuca de Soto',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (394,'Pak Kret',94,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (395,'Palghat (Palakkad)',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (396,'Pangkal Pinang',45,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (397,'Papeete',36,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (398,'Parbhani',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (399,'Pathankot',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (400,'Patiala',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (401,'Patras',39,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (402,'Pavlodar',51,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (403,'Pemalang',45,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (404,'Peoria',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (405,'Pereira',24,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (406,'Phnom Penh',18,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (407,'Pingxiang',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (408,'Pjatigorsk',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (409,'Plock',76,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (410,'Po',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (411,'Ponce',77,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (412,'Pontianak',45,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (413,'Poos de Caldas',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (414,'Portoviejo',28,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (415,'Probolinggo',45,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (416,'Pudukkottai',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (417,'Pune',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (418,'Purnea (Purnia)',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (419,'Purwakarta',45,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (420,'Pyongyang',70,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (421,'Qalyub',29,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (422,'Qinhuangdao',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (423,'Qomsheh',46,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (424,'Quilmes',6,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (425,'Rae Bareli',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (426,'Rajkot',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (427,'Rampur',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (428,'Rancagua',22,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (429,'Ranchi',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (430,'Richmond Hill',20,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (431,'Rio Claro',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (432,'Rizhao',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (433,'Roanoke',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (434,'Robamba',28,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (435,'Rockford',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (436,'Ruse',17,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (437,'Rustenburg',85,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (438,'s-Hertogenbosch',67,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (439,'Saarbrcken',38,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (440,'Sagamihara',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (441,'Saint Louis',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (442,'Saint-Denis',79,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (443,'Sal',62,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (444,'Salala',71,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (445,'Salamanca',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (446,'Salinas',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (447,'Salzburg',9,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (448,'Sambhal',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (449,'San Bernardino',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (450,'San Felipe de Puerto Plata',27,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (451,'San Felipe del Progreso',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (452,'San Juan Bautista Tuxtepec',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (453,'San Lorenzo',73,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (454,'San Miguel de Tucumn',6,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (455,'Sanaa',107,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (456,'Santa Brbara dOeste',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (457,'Santa F',6,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (458,'Santa Rosa',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (459,'Santiago de Compostela',87,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (460,'Santiago de los Caballeros',27,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (461,'Santo Andr',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (462,'Sanya',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (463,'Sasebo',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (464,'Satna',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (465,'Sawhaj',29,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (466,'Serpuhov',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (467,'Shahr-e Kord',46,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (468,'Shanwei',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (469,'Shaoguan',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (470,'Sharja',101,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (471,'Shenzhen',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (472,'Shikarpur',72,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (473,'Shimoga',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (474,'Shimonoseki',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (475,'Shivapuri',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (476,'Shubra al-Khayma',29,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (477,'Siegen',38,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (478,'Siliguri (Shiliguri)',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (479,'Simferopol',100,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (480,'Sincelejo',24,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (481,'Sirjan',46,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (482,'Sivas',97,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (483,'Skikda',2,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (484,'Smolensk',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (485,'So Bernardo do Campo',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (486,'So Leopoldo',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (487,'Sogamoso',24,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (488,'Sokoto',69,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (489,'Songkhla',94,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (490,'Sorocaba',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (491,'Soshanguve',85,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (492,'Sousse',96,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (493,'South Hill',5,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (494,'Southampton',102,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (495,'Southend-on-Sea',102,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (496,'Southport',102,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (497,'Springs',85,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (498,'Stara Zagora',17,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (499,'Sterling Heights',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (500,'Stockport',102,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (501,'Sucre',14,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (502,'Suihua',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (503,'Sullana',74,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (504,'Sultanbeyli',97,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (505,'Sumqayit',10,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (506,'Sumy',100,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (507,'Sungai Petani',59,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (508,'Sunnyvale',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (509,'Surakarta',45,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (510,'Syktyvkar',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (511,'Syrakusa',49,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (512,'Szkesfehrvr',43,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (513,'Tabora',93,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (514,'Tabriz',46,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (515,'Tabuk',82,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (516,'Tafuna',3,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (517,'Taguig',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (518,'Taizz',107,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (519,'Talavera',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (520,'Tallahassee',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (521,'Tama',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (522,'Tambaram',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (523,'Tanauan',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (524,'Tandil',6,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (525,'Tangail',12,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (526,'Tanshui',92,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (527,'Tanza',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (528,'Tarlac',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (529,'Tarsus',97,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (530,'Tartu',30,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (531,'Teboksary',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (532,'Tegal',45,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (533,'Tel Aviv-Jaffa',48,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (534,'Tete',63,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (535,'Tianjin',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (536,'Tiefa',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (537,'Tieli',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (538,'Tokat',97,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (539,'Tonghae',86,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (540,'Tongliao',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (541,'Torren',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (542,'Touliu',92,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (543,'Toulon',34,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (544,'Toulouse',34,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (545,'Trshavn',32,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (546,'Tsaotun',92,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (547,'Tsuyama',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (548,'Tuguegarao',75,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (549,'Tychy',76,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (550,'Udaipur',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (551,'Udine',49,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (552,'Ueda',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (553,'Uijongbu',86,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (554,'Uluberia',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (555,'Urawa',50,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (556,'Uruapan',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (557,'Usak',97,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (558,'Usolje-Sibirskoje',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (559,'Uttarpara-Kotrung',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (560,'Vaduz',55,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (561,'Valencia',104,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (562,'Valle de la Pascua',104,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (563,'Valle de Santiago',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (564,'Valparai',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (565,'Vancouver',20,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (566,'Varanasi (Benares)',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (567,'Vicente Lpez',6,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (568,'Vijayawada',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (569,'Vila Velha',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (570,'Vilnius',56,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (571,'Vinh',105,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (572,'Vitria de Santo Anto',15,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (573,'Warren',103,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (574,'Weifang',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (575,'Witten',38,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (576,'Woodridge',8,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (577,'Wroclaw',76,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (578,'Xiangfan',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (579,'Xiangtan',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (580,'Xintai',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (581,'Xinxiang',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (582,'Yamuna Nagar',44,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (583,'Yangor',65,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (584,'Yantai',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (585,'Yaound',19,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (586,'Yerevan',7,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (587,'Yinchuan',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (588,'Yingkou',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (589,'York',102,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (590,'Yuncheng',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (591,'Yuzhou',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (592,'Zalantun',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (593,'Zanzibar',93,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (594,'Zaoyang',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (595,'Zapopan',60,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (596,'Zaria',69,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (597,'Zeleznogorsk',80,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (598,'Zhezqazghan',51,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (599,'Zhoushan',23,'2006-02-15 04:45:25');
INSERT INTO `city` VALUES   (600,'Ziguinchor',83,'2006-02-15 04:45:25');

DROP FUNCTION IF EXISTS `get_customer_balance`;

DELIMITER $$

/*!50003 SET @TEMP_SQL_MODE=@@SQL_MODE, SQL_MODE='STRICT_TRANS_TABLES,STRICT_ALL_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,TRADITIONAL,NO_AUTO_CREATE_USER' */ $$
CREATE DEFINER=`root`@`%` FUNCTION `get_customer_balance`(p_customer_id INT, p_effective_date DATETIME) RETURNS decimal(5,2)
    READS SQL DATA
    DETERMINISTIC
BEGIN

       #OK, WE NEED TO CALCULATE THE CURRENT BALANCE GIVEN A CUSTOMER_ID AND A DATE
       #THAT WE WANT THE BALANCE TO BE EFFECTIVE FOR. THE BALANCE IS:
       #   1) RENTAL FEES FOR ALL PREVIOUS RENTALS
       #   2) ONE DOLLAR FOR EVERY DAY THE PREVIOUS RENTALS ARE OVERDUE
       #   3) IF A FILM IS MORE THAN RENTAL_DURATION * 2 OVERDUE, CHARGE THE REPLACEMENT_COST
       #   4) SUBTRACT ALL PAYMENTS MADE BEFORE THE DATE SPECIFIED

  DECLARE v_rentfees DECIMAL(5,2); #FEES PAID TO RENT THE VIDEOS INITIALLY
  DECLARE v_overfees INTEGER;      #LATE FEES FOR PRIOR RENTALS
  DECLARE v_payments DECIMAL(5,2); #SUM OF PAYMENTS MADE PREVIOUSLY

  SELECT IFNULL(SUM(film.rental_rate),0) INTO v_rentfees
    FROM film, inventory, rental
    WHERE film.film_id = inventory.film_id
      AND inventory.inventory_id = rental.inventory_id
      AND rental.rental_date <= p_effective_date
      AND rental.customer_id = p_customer_id;

  SELECT IFNULL(SUM(IF((TO_DAYS(rental.return_date) - TO_DAYS(rental.rental_date)) > film.rental_duration,
        ((TO_DAYS(rental.return_date) - TO_DAYS(rental.rental_date)) - film.rental_duration),0)),0) INTO v_overfees
    FROM rental, inventory, film
    WHERE film.film_id = inventory.film_id
      AND inventory.inventory_id = rental.inventory_id
      AND rental.rental_date <= p_effective_date
      AND rental.customer_id = p_customer_id;


  SELECT IFNULL(SUM(payment.amount),0) INTO v_payments
    FROM payment

    WHERE payment.payment_date <= p_effective_date
    AND payment.customer_id = p_customer_id;

  RETURN v_rentfees + v_overfees - v_payments;
END $$
/*!50003 SET SESSION SQL_MODE=@TEMP_SQL_MODE */  $$

DELIMITER ;

DROP FUNCTION IF EXISTS `inventory_in_stock`;

DELIMITER $$

/*!50003 SET @TEMP_SQL_MODE=@@SQL_MODE, SQL_MODE='STRICT_TRANS_TABLES,STRICT_ALL_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,TRADITIONAL,NO_AUTO_CREATE_USER' */ $$
CREATE DEFINER=`root`@`%` FUNCTION `inventory_in_stock`(p_inventory_id INT) RETURNS tinyint(1)
    READS SQL DATA
BEGIN
    DECLARE v_rentals INT;
    DECLARE v_out     INT;

    #AN ITEM IS IN-STOCK IF THERE ARE EITHER NO ROWS IN THE rental TABLE
    #FOR THE ITEM OR ALL ROWS HAVE return_date POPULATED

    SELECT COUNT(*) INTO v_rentals
    FROM rental
    WHERE inventory_id = p_inventory_id;

    IF v_rentals = 0 THEN
      RETURN TRUE;
    END IF;

    SELECT COUNT(rental_id) INTO v_out
    FROM inventory LEFT JOIN rental USING(inventory_id)
    WHERE inventory.inventory_id = p_inventory_id
    AND rental.return_date IS NULL;

    IF v_out > 0 THEN
      RETURN FALSE;
    ELSE
      RETURN TRUE;
    END IF;
END $$
/*!50003 SET SESSION SQL_MODE=@TEMP_SQL_MODE */  $$

DELIMITER ;

DROP PROCEDURE IF EXISTS `film_in_stock`;

DELIMITER $$

/*!50003 SET @TEMP_SQL_MODE=@@SQL_MODE, SQL_MODE='STRICT_TRANS_TABLES,STRICT_ALL_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,TRADITIONAL,NO_AUTO_CREATE_USER' */ $$
CREATE DEFINER=`root`@`%` PROCEDURE `film_in_stock`(IN p_film_id INT, IN p_store_id INT, OUT p_film_count INT)
    READS SQL DATA
BEGIN
     SELECT inventory_id
     FROM inventory
     WHERE film_id = p_film_id
     AND store_id = p_store_id
     AND inventory_in_stock(inventory_id);

     SELECT FOUND_ROWS() INTO p_film_count;
END $$
/*!50003 SET SESSION SQL_MODE=@TEMP_SQL_MODE */  $$

DELIMITER ;

DROP PROCEDURE IF EXISTS `film_not_in_stock`;

DELIMITER $$

/*!50003 SET @TEMP_SQL_MODE=@@SQL_MODE, SQL_MODE='STRICT_TRANS_TABLES,STRICT_ALL_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,TRADITIONAL,NO_AUTO_CREATE_USER' */ $$
CREATE DEFINER=`root`@`%` PROCEDURE `film_not_in_stock`(IN p_film_id INT, IN p_store_id INT, OUT p_film_count INT)
    READS SQL DATA
BEGIN
     SELECT inventory_id
     FROM inventory
     WHERE film_id = p_film_id
     AND store_id = p_store_id
     AND NOT inventory_in_stock(inventory_id);

     SELECT FOUND_ROWS() INTO p_film_count;
END $$
/*!50003 SET SESSION SQL_MODE=@TEMP_SQL_MODE */  $$

DELIMITER ;

DROP TABLE IF EXISTS `film_list`;
DROP VIEW IF EXISTS `film_list`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `film_list` AS select `film`.`film_id` AS `FID`,`film`.`title` AS `title`,`film`.`description` AS `description`,`category`.`name` AS `category`,`film`.`rental_rate` AS `price`,`film`.`length` AS `length`,`film`.`rating` AS `rating`,group_concat(concat(`actor`.`first_name`,_utf8' ',`actor`.`last_name`) separator ', ') AS `actors` from ((((`category` left join `film_category` on((`category`.`category_id` = `film_category`.`category_id`))) left join `film` on((`film_category`.`film_id` = `film`.`film_id`))) join `film_actor` on((`film`.`film_id` = `film_actor`.`film_id`))) join `actor` on((`film_actor`.`actor_id` = `actor`.`actor_id`))) group by `film`.`film_id`;

DROP TABLE IF EXISTS `actor_info`;
DROP VIEW IF EXISTS `actor_info`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY INVOKER VIEW `actor_info` AS select `a`.`actor_id` AS `actor_id`,`a`.`first_name` AS `first_name`,`a`.`last_name` AS `last_name`,group_concat(distinct concat(`c`.`name`,_utf8': ',(select group_concat(`f`.`title` order by `f`.`title` ASC separator ', ') AS `GROUP_CONCAT(f.title ORDER BY f.title SEPARATOR ', ')` from ((`film` `f` join `film_category` `fc` on((`f`.`film_id` = `fc`.`film_id`))) join `film_actor` `fa` on((`f`.`film_id` = `fa`.`film_id`))) where ((`fc`.`category_id` = `c`.`category_id`) and (`fa`.`actor_id` = `a`.`actor_id`)))) order by `c`.`name` ASC separator '; ') AS `film_info` from (((`actor` `a` left join `film_actor` `fa` on((`a`.`actor_id` = `fa`.`actor_id`))) left join `film_category` `fc` on((`fa`.`film_id` = `fc`.`film_id`))) left join `category` `c` on((`fc`.`category_id` = `c`.`category_id`))) group by `a`.`actor_id`,`a`.`first_name`,`a`.`last_name`;

DROP TABLE IF EXISTS `sales_by_store`;
DROP VIEW IF EXISTS `sales_by_store`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `sales_by_store` AS select concat(`c`.`city`,_utf8',',`cy`.`country`) AS `store`,concat(`m`.`first_name`,_utf8' ',`m`.`last_name`) AS `manager`,sum(`p`.`amount`) AS `total_sales` from (((((((`payment` `p` join `rental` `r` on((`p`.`rental_id` = `r`.`rental_id`))) join `inventory` `i` on((`r`.`inventory_id` = `i`.`inventory_id`))) join `store` `s` on((`i`.`store_id` = `s`.`store_id`))) join `address` `a` on((`s`.`address_id` = `a`.`address_id`))) join `city` `c` on((`a`.`city_id` = `c`.`city_id`))) join `country` `cy` on((`c`.`country_id` = `cy`.`country_id`))) join `staff` `m` on((`s`.`manager_staff_id` = `m`.`staff_id`))) group by `s`.`store_id` order by `cy`.`country`,`c`.`city`;



/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
