#include "DragWidget.h"

DragWidget::DragWidget(QWidget *parent, const char *name, WFlags f) : QWidget(parent,name,f)
{
	dragP=QPoint(0,0);
	drag=false;
	locked=false;
}
DragWidget::~DragWidget()
{

}

void DragWidget::mousePressEvent(QMouseEvent *e)
{
	
	dragP=e->pos();
	gpress=e->globalPos();
	if (locked)return;
	drag=true;

}
void DragWidget::mouseReleaseEvent(QMouseEvent *)
{

	drag=false;
}
void DragWidget::mouseMoveEvent(QMouseEvent *e)
{
	if (!drag) {
		return;
	}
	QPoint curr(e->globalPos().x()-dragP.x(),e->globalPos().y()-dragP.y());
	QWidget::move(curr);
	
}

void DragWidget::setLocked(bool mode)
{
	locked=mode;
}

const bool DragWidget::isLocked() const
{
	return locked;
}


