/***************************************************************************
 *   Weather module for Kadu communicator                                  *
 *   2004 Micha Maek (bysk)                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CITYSEARCHRESULT_H
#define CITYSEARCHRESULT_H

#include <qvaluelist.h>
#include "userlistelement.h"

struct CitySearchResult
{
	QString cityName_;
	QString cityId_;
	QString server_;
	
	CitySearchResult() {}
	
	CitySearchResult( const QString& cityName, const QString& cityId, const QString& server )
		: cityName_(cityName), cityId_(cityId), server_(server) {}
		
	CitySearchResult( const CitySearchResult& r )
	{
		cityName_ = r.cityName_;
		cityId_ = r.cityId_;
		server_ = r.server_;
	}
	
	bool writeUserWeatherData( UserListElement user ) const;
	bool readUserWeatherData( UserListElement user );
	bool writeMyWeatherData() const;
	bool readMyWeatherData();
};

typedef QValueList<CitySearchResult> CITYSEARCHRESULTS;

#endif
