/*
 * qimage_manips.h - some functions for fast manipulating of QImage-objects
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _Q_IMGAGE_MANIPS_H
#define _Q_IMGAGE_MANIPS_H


#include <memory.h>

#include <qimage.h>



inline void fillRect( QImage & _i, Q_UINT16 rx, Q_UINT16 ry, Q_UINT16 rw, Q_UINT16 rh, QRgb pix )
{
	const Q_UINT16 x2 = rx+rw;
	const Q_UINT16 y2 = ry+rh;

	for( Q_UINT16 y = ry; y < y2; ++y )
	{
		register QRgb * dest = (QRgb *) _i.scanLine( y ) + rx;
		for( register Q_UINT16 x = rx; x < x2; ++x, ++dest )
		{
			*dest = pix;
		}
	}
}



inline void copyRect( QImage & _i, Q_UINT16 rx, Q_UINT16 ry, Q_UINT16 rw, Q_UINT16 rh, QRgb * buf )
{
	const Q_UINT16 x2 = rx+rw;
	const Q_UINT16 y2 = ry+rh;

	for( Q_UINT16 y = ry; y < y2; ++y )
	{
		register QRgb * dest = (QRgb *) _i.scanLine( y ) + rx;
		memcpy( dest, buf, ( x2-rx ) * sizeof( QRgb ) );
		buf += x2-rx;
/*		for( register Q_UINT16 x = rx; x < x2; ++x, ++dest, ++buf )
		{
			*dest = *buf;
		}*/
	}
}



inline void copyExistingRect( QImage & _i, Q_UINT16 src_x, Q_UINT16 src_y, Q_UINT16 rw, Q_UINT16 rh, Q_UINT16 dest_x, Q_UINT16 dest_y )
{
	for( Q_UINT16 y = 0; y < rh; ++y )
	{
		register QRgb * src = (QRgb *) _i.scanLine( y+src_y ) + src_x;
		register QRgb * dest = (QRgb *) _i.scanLine( y+dest_y ) + dest_x;
		memcpy( dest, src, rw * sizeof( QRgb ) );
/*		for( register Q_UINT16 x = 0; x < rw; ++x, ++src, ++dest )
		{
			*dest = *src;
		}*/
	}
}



void fastScaleImage (const QImage & src, QImage & dst);


#endif
