/*************************************************************************
 * 
 * irmp3 - Multimedia Audio Jukebox for Linux
 * http://irmp3.sourceforge.net
 *
 * $Source: /cvsroot/irmp3/irmp3/src/irmp3d/mod_player.c,v $ -- playlist support
 * $Id: mod_player.c,v 1.8 2004/02/17 20:40:36 boucman Exp $
 *
 * Copyright (C) by Andreas Neuhaus
 *
 * Please contact the current maintainer, Jeremy Rosen <jeremy.rosen@enst-bretagne.fr>
 * for information and support regarding irmp3.
 *
 *
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "config.h"
#include "irmp3config.h"
#include "irmp3log.h"
#include "irmp3mod.h"
#include "mod_player.h"
#define PLAYER_STATUS_HALT	0
#define PLAYER_STATUS_STOP	1
#define PLAYER_STATUS_PLAY	2
#define PLAYER_STATUS_PAUSE	3
int mod_player_status = PLAYER_STATUS_HALT;
/*************************************************************************
 * GLOBALS
 */
/* info about current song */
char *mod_player_song = NULL;
mod_message_t* mod_player_player = NULL;
mod_message_t* mod_player_type = NULL;
mod_message_t* mod_player_player_extra = NULL;



/*************************************************************************
 * MODULE INFO
 */
mod_t mod_player = {
	"mod_player",
	mod_player_deinit,	// deinit
	NULL,			// reload
	&blank_fd,		// watchfd
	NULL,			// poll
	NULL,			// update
	mod_player_message,	// message
	NULL,			// SIGCHLD handler
	NULL,
	NULL,			// avoid warning
};


void launch_song()
{
	char tmp[256];
	char *player, *c1;
	int skip_type_advance = 0;
	mod_message_t *answer;
	mod_message_t *tmp_msg;
	/* remove leading player if any, it's the one 
	 * we just tried and failed with
	 * */
	if(mod_player_player) {
		log_printf(LOG_VERBOSE,"player %s seems incorrect for song %s\n",mod_player_player->msg,mod_player_song);
		tmp_msg = mod_player_player;
		mod_player_player = mod_player_player->next;
		free(tmp_msg->msg);
		free(tmp_msg);
	} else {
		// we had no players, but types.
		// this means we arn't playing, 
		// don't advance
		skip_type_advance = 1;
	}
	// no more players ? load the next set...
	while (!mod_player_player) {
		// go to next type
		if(mod_player_type && !skip_type_advance) {
		log_printf(LOG_VERBOSE,"type %s seems incorrect for song %s\n",mod_player_type->msg,mod_player_song);
			tmp_msg = mod_player_type;
			mod_player_type = mod_player_type->next;
			free(tmp_msg->msg);
			free(tmp_msg);
		}
		skip_type_advance = 0;
		if(!mod_player_type) {
			if(mod_player_player_extra) {
				log_printf(LOG_VERBOSE,"all types failed, trying extra players\n");

				mod_player_player = mod_player_player_extra;
				mod_player_player_extra = NULL;
			} else {
				// we've tried everything...
				mod_sendmsgf(MSGTYPE_EVENT,"player error");
				mod_sendmsgf(MSGTYPE_EVENT,"halt");
				mod_player_status = PLAYER_STATUS_HALT;
				return;
			}
		} else {
			sprintf(tmp,"playtype_%s",mod_player_type->msg);
			player = config_getstr(tmp,NULL);
			if(player) {
				mod_player_player = malloc(sizeof(mod_message_t));
				mod_player_player->next = NULL;
				mod_player_player->msgtype = MSGTYPE_INFO;
				mod_player_player->msg = strdup(player);
			} else{
				answer = mod_queryf(MSGTYPE_QUERY,"whocanplay %s",mod_player_type->msg);
				while(answer) {
					if( answer->msgtype != MSGTYPE_INFO) {
						tmp_msg = answer;
						answer =  answer->next;
						free(tmp_msg->msg);
						free(tmp_msg);
						continue;
					}
					strcpy(tmp,answer->msg);
					c1 = strtok(tmp," \t");
					if(!strcasecmp(c1,"canplay")) {
						c1 = strtok(NULL," \t");
						if(!mod_player_player) {
							mod_player_player = malloc(sizeof(mod_message_t));
							mod_player_player->msgtype = MSGTYPE_INFO;
							mod_player_player->next = NULL;
							mod_player_player->msg = strdup(c1);
							tmp_msg = answer;
							answer =  answer->next;
							free(tmp_msg->msg);
							free(tmp_msg);
						} else {
							tmp_msg = mod_player_player;
							while(tmp_msg) {
								if(!strcasecmp(c1,tmp_msg->msg)) {
									tmp_msg = answer;
									answer =  answer->next;
									free(tmp_msg->msg);
									free(tmp_msg);
									tmp_msg = NULL;
								} else if(!tmp_msg->next) {
									tmp_msg->next = malloc(sizeof(mod_message_t));
									tmp_msg->next->msgtype = MSGTYPE_INFO;
									tmp_msg->next->next = NULL;
									tmp_msg->next->msg = strdup(c1);
									answer =  answer->next;

									tmp_msg = NULL;
								} else {
									tmp_msg = tmp_msg->next;
								}
							}
						}
					} else {
						tmp_msg = answer;
						answer =  answer->next;
						free(tmp_msg->msg);
						free(tmp_msg);
					}
				}

			}
		}
	}

	mod_sendmsgf(MSGTYPE_PLAYER, "play %s %s", mod_player_player->msg,mod_player_song);
}




void start_play(const char *song, const char *type)
{
	char tmp[256];
	char*  c1;
	mod_message_t *answer = NULL;
	mod_message_t *tmp_msg = NULL;
	free_message(mod_player_type);
	free_message(mod_player_player);
	free_message(mod_player_player_extra);
	if(mod_player_song) free(mod_player_song);
	mod_player_song = strdup(song);
	mod_player_type = NULL;
	mod_player_player = NULL;
	mod_player_player_extra = NULL;
	if (!type) {
		answer = mod_queryf(MSGTYPE_QUERY,"songtype %s",song);
		if (!answer) {
			log_printf(LOG_VERBOSE,"Nobody recognised, %s, trying extra recognition\n",song);

			answer = mod_queryf(MSGTYPE_QUERY,"songtypeguess %s",song);
		}
		while(answer) {
			if( answer->msgtype != MSGTYPE_INFO) {
				tmp_msg = answer;
				answer =  answer->next;
				free(tmp_msg->msg);
				free(tmp_msg);
				continue;
			}
			strcpy(tmp,answer->msg);
			c1 = strtok(tmp," \t");
			if(!strcasecmp(c1,"knowntype")) {
				c1 = strtok(NULL," \t");
				if(!mod_player_type) {
					mod_player_type = malloc(sizeof(mod_message_t));
					mod_player_type->msgtype = MSGTYPE_INFO;
					mod_player_type->next = NULL;
					mod_player_type->msg = strdup(c1);
					tmp_msg = answer;
					answer =  answer->next;
					free(tmp_msg->msg);
					free(tmp_msg);
				} else {
					tmp_msg = mod_player_type;
					while(tmp_msg) {
						if(!strcasecmp(c1,tmp_msg->msg)) {
							tmp_msg = answer;
							answer =  answer->next;
							free(tmp_msg->msg);
							free(tmp_msg);
							tmp_msg = NULL;
						} else if(!tmp_msg->next) {
							tmp_msg->next = malloc(sizeof(mod_message_t));
							tmp_msg->next->msgtype = MSGTYPE_INFO;
							tmp_msg->next->next = NULL;
							tmp_msg->next->msg = strdup(c1);
							answer =  answer->next;
							tmp_msg = NULL;
						} else {
							tmp_msg = tmp_msg->next;
						}
						
					}
				}
			} else if(!strcasecmp(c1,"canplay")) {
				c1 = strtok(NULL," \t");
				if(!mod_player_player_extra) {
					mod_player_player_extra = malloc(sizeof(mod_message_t));
					mod_player_player_extra->msgtype = MSGTYPE_INFO;
					mod_player_player_extra->next = NULL;
					mod_player_player_extra->msg = strdup(c1);
					tmp_msg = answer;
					answer =  answer->next;
					free(tmp_msg->msg);
					free(tmp_msg);
				}else {
					tmp_msg = mod_player_player_extra;
					while(tmp_msg) {
						if(strcasecmp(c1,tmp_msg->msg)) {
							tmp_msg = answer;
							answer =  answer->next;
							free(tmp_msg->msg);
							free(tmp_msg);
							tmp_msg = NULL;
						} else if(!tmp_msg->next) {
							// add at HEAD of list
							tmp_msg->next = malloc(sizeof(mod_message_t));
							tmp_msg->next->msgtype = MSGTYPE_INFO;
							tmp_msg->next->next = NULL;
							tmp_msg->next->msg = strdup(c1);
							answer =  answer->next;
							tmp_msg = NULL;
						} else {
							tmp_msg = tmp_msg->next;
						}
					}
				}
			} else {
				tmp_msg = answer;
				answer =  answer->next;
				free(tmp_msg->msg);
				free(tmp_msg);
				continue;
			}
		}
	} else {
		mod_player_type = malloc(sizeof(mod_message_t));
		mod_player_type->msgtype = MSGTYPE_INFO;
		mod_player_type->next =NULL;
		mod_player_type->msg = strdup(type);
	}
	// add dummy entry
	launch_song();
}


/*************************************************************************
 * RECEIVE MESSAGE
 */
void mod_player_message (int msgtype, char *rawmsg,const char __attribute__((unused))*sender)
{
	char *c1, *c2, *c3, msg[512];

	strncpy(msg,rawmsg,sizeof(msg));	// pad msg with nulls

	// handle input messages
	if (msgtype == MSGTYPE_INPUT) {
		c1 = strtok(msg, " \t");
		if(!c1) return;
		if (!strcasecmp(c1, "play")) {
			c2 = strtok(NULL, "");
			if(!c2) return ;
			start_play(c2,NULL);

		} else if (!strcasecmp(c1, "playtype")) {
			c2 = strtok(NULL, " \t");
			c3 = strtok(NULL, "");
			if(!c2) return ;
			start_play(c3,c2);
		} else if (!strcasecmp(c1, "stop")) {
				mod_sendmsgf(MSGTYPE_PLAYER,rawmsg);
				mod_sendmsgf(MSGTYPE_EVENT,rawmsg);
				mod_player_status = PLAYER_STATUS_STOP;
		} else if ( !strcasecmp(c1, "stopall")) {
				mod_sendmsgf(MSGTYPE_PLAYER,"play none");
				mod_player_status = PLAYER_STATUS_HALT;
				mod_sendmsgf(MSGTYPE_EVENT,"halt");
		} else if (!strcasecmp(c1, "pause")) {
				mod_sendmsgf(MSGTYPE_PLAYER,rawmsg);
				if(mod_player_status == PLAYER_STATUS_PAUSE) {
					mod_sendmsgf(MSGTYPE_EVENT,"unpause");
					mod_player_status = PLAYER_STATUS_PLAY;
				} else if (mod_player_status == PLAYER_STATUS_PLAY){
					mod_sendmsgf(MSGTYPE_EVENT,"pause");
					mod_player_status = PLAYER_STATUS_PAUSE;
				} else {
					log_printf(LOG_VERBOSE,"pause order not applied, neither playing nor paused\n");
				}
		} else if ( !strcasecmp(c1, "seek")) {
				mod_sendmsgf(MSGTYPE_PLAYER,rawmsg);
		}

	// handle player messages
	} else if (msgtype == MSGTYPE_PLAYER) {
		c1 =  strtok(msg, " \t") ;
		if(!c1) return;
		if ( !strcasecmp(c1, "endofsong")) {
			mod_sendmsgf(MSGTYPE_EVENT,"endofsong");
			mod_player_status = PLAYER_STATUS_STOP;
		} else if (!strcasecmp(c1, "error")) {
			launch_song();
		} else if(!strcasecmp(c1, "playing")) {
			mod_sendmsgf(MSGTYPE_EVENT,"play %s %s",mod_player_player->msg, mod_player_song);
			mod_player_status = PLAYER_STATUS_PLAY;
			// we've start playing, don't start the next one even in case of error
			// this is not NULL, or the message wouldn't be generated
			free_message(mod_player_player->next);
			mod_player_player->next = NULL;
			free_message(mod_player_player_extra);
			mod_player_player_extra = NULL;
			if(mod_player_type) {
				free_message(mod_player_type->next);
				mod_player_type->next = NULL;
			}
		}
	} else if (msgtype == MSGTYPE_QUERY) {
		c1 =  strtok(msg, " \t") ;
		if(!c1) return;
		if ( !strcasecmp(c1, "status")) {
			switch (mod_player_status) {
				case PLAYER_STATUS_STOP:
					mod_sendmsgf(MSGTYPE_INFO,"stop");
					break;
				case PLAYER_STATUS_HALT:
					mod_sendmsgf(MSGTYPE_INFO,"stop");
					break;
				case PLAYER_STATUS_PLAY:
					mod_sendmsgf(MSGTYPE_INFO,"play %s %s", mod_player_player->msg,mod_player_song);;
					break;
				case PLAYER_STATUS_PAUSE:
					mod_sendmsgf(MSGTYPE_INFO,"pause");
					break;
			}
		}else if(!strcasecmp(c1,"songcmd") && mod_player_song) {
				mod_sendmsgf(MSGTYPE_INFO,"songcmd %s",mod_player_song);
		}else if(!strcasecmp(c1,"songtype") && mod_player_type) {
				mod_sendmsgf(MSGTYPE_INFO,"songtype %s",mod_player_type->msg);
		}else if(!strcasecmp(c1,"songplayer") && mod_player_player) {
				mod_sendmsgf(MSGTYPE_INFO,"songplayer %s",mod_player_player->msg);
		}
	}
}




/*************************************************************************
 * MODULE DEINIT FUNCTION
 */
void mod_player_deinit (void)
{

	log_printf(LOG_DEBUG, "mod_player_deinit(): deinitialized\n");
}


/*************************************************************************
 * EOF
 */
