/*
     This file is part of GNUnet.
     (C) 2005, 2006 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/core/main.c
 * @brief Main function of gnunet-gtk
 * @author Christian Grothoff
 */

#include "platform.h"
#include "gnunetgtk_common.h"
#include "eggtrayicon.h"



/**
 * Prints the usage information for this command if the user errs.
 */
static void printhelp() {
  static Help help[] = {
    HELP_CONFIG,
    HELP_HELP,
    HELP_HOSTNAME,
    HELP_LOGLEVEL,
    HELP_VERSION,
    HELP_END,
  };
  formatHelp("gnunet-gtk [OPTIONS]",
	     _("GNUnet GTK user interface."),
	     help);
}

/**
 * Parse the options, set the timeout.
 * @param argc the number of options
 * @param argv the option list (including keywords)
 * @return SYSERR if we should exit, OK otherwise
 */
static int parseOptions(int argc,
			char ** argv) {
  int c;

  while (1) {
    int option_index = 0;
    static struct GNoption long_options[] = {
      LONG_DEFAULT_OPTIONS,
      { 0,0,0,0 }
    };
    c = GNgetopt_long(argc,
		      argv,
		      "c:dhH:L:v",
		      long_options,
		      &option_index);
    if (c == -1)
      break;  /* No more flags to process */
    if (YES == parseDefaultOptions(c, GNoptarg))
      continue;
    switch(c) {
    case 'h':
      printhelp();
      return SYSERR;
    case 'v':
      printf("gnunet-gtk v%s\n",
	     VERSION);
      return SYSERR;
    default:
      LOG(LOG_FAILURE,
	  _("Use --help to get a list of options.\n"));
      return SYSERR;
    } /* end of parsing commandline */
  } /* while (1) */
  setConfigurationStringList(&argv[GNoptind],
			     argc-GNoptind);
  return OK;
}

static void * shutdownCode(void * unused) {
  stopCron();
  shutdownPlugins();
  return NULL;
}

static void gnunet_gtk_main_quit() {
  setCustomLogProc(NULL);
  run_with_save_calls(&shutdownCode,
		      NULL);
  gtk_main_quit();
}

static void customLog(const char * msg) {
  addLogEntry("%s", msg);
}


int main(int argc,
	 char *argv[]) {
  GtkWidget * root;

  g_thread_init(NULL);
  gtk_init(&argc, &argv);
  if (SYSERR == initUtil(argc,
			 argv,
			 &parseOptions))
    return 0;

#ifdef WINDOWS
  FreeConsole();
#endif

#if ENABLE_NLS
  BINDTEXTDOMAIN("gnunet-gtk", PACKAGE_LOCALE_DIR);
  textdomain("gnunet-gtk");
  bind_textdomain_codeset("GNUnet", "UTF-8");
  bind_textdomain_codeset("gnunet-gtk", "UTF-8");
#endif
  startCron();
  initGNUnetGTKCommon(&gnunet_gtk_main_quit);
  root
    = glade_xml_get_widget(getMainXML(),
			   "mainWindow");
  gtk_window_maximize(GTK_WINDOW(root));
#ifndef WINDOWS
  initTrayIcon();
#endif
  gtk_widget_show(root);
  setCustomLogProc(&customLog);
  /* start the event loop */
  gdk_threads_enter();
  gtk_main();
  gdk_threads_leave();
  doneGNUnetGTKCommon();
  doneUtil();
  return 0;
}

/* ************* end of main.c ************ */
