#   Confirm Window Close - Epiphany Extension
#   Copyright (C) 2006  Stefan Stuhr
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program; if not, write to the Free Software Foundation, Inc.,
#   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


import gtk
import epiphany

def _cwc_window_delete_event_cb(window, event):
	notebook = window.get_notebook()
	tab_count = notebook.get_n_pages()

	if tab_count <= 1:
		return False

	dialog = gtk.MessageDialog(window,
	                           gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
	                           gtk.MESSAGE_WARNING, gtk.BUTTONS_NONE,
	                           "You are about to close a window with %i open tabs" % tab_count)
	dialog.set_title("Confirm window close")
	window.group.add_window(dialog)
	dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL).grab_focus()
	dialog.add_button(gtk.STOCK_CLOSE, gtk.RESPONSE_OK)
	dialog.set_default_response(gtk.RESPONSE_CANCEL)

	result = dialog.run()
	dialog.hide()
	dialog.destroy()

	return result not in (gtk.RESPONSE_OK,)

def attach_window(window):
	signal = window.connect("delete-event", _cwc_window_delete_event_cb)
	window._cwc_window_delete_sig = signal

def detach_window(window):
	if hasattr(window, "_cwc_window_delete_sig"):
		window.disconnect(window._cwc_window_delete_sig)
		delattr(window, "_cwc_window_delete_sig")
