# -*- encoding: utf-8 -*-
#
#   Widetabs - Epiphany Extension
#   Copyright © 2008  Diego Escalante Urrelo <diegoe@gnome.org>
#   Based on:
#      Only One Close Button - Epiphany Extension
#      Copyright © 2006  Stefan Stuhr
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program; if not, write to the Free Software Foundation, Inc.,
#   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


import gtk
import epiphany


class WideTab:
	def __init__(self):
		self.win_data = {}
	def attach_window(self, window):
		data = self.win_data[window] = {"tab_data": {}}

		notebook = window.get_notebook()

		initially_homogeneous = notebook.get_property("homogeneous")
		data["initially_homogeneous"] = initially_homogeneous
		notebook.set_property("homogeneous", True)
		
		initially_scrollable = notebook.get_property("scrollable")
		data["initially_scrollable"] = initially_scrollable
		notebook.set_property("scrollable", False)

	def detach_window(self, window):
		data = self.win_data.pop(window)

		notebook = window.get_notebook()

		initially_homogeneous = data["initially_homogeneous"]
		notebook.set_property("homogeneous", initially_homogeneous)

	def hbox_style_set_cb(self, hbox, previous_style, window, tab):
		data = self.win_data[window]
		tab_data = data["tab_data"][tab]

		tab_data["tab_initial_width"] = hbox.get_size_request()[0]
		hbox.set_size_request(16, -1)

	def attach_tab(self, window, tab):
		data = self.win_data[window]
		tab_data = data["tab_data"][tab] = {}

		notebook = window.get_notebook()
		widget = notebook.get_tab_label(tab)

		if isinstance(widget, gtk.HBox):
			tab_data["tab_initial_width"] = widget.get_size_request()[0]
			widget.set_size_request(16, -1)

			handler_id = widget.connect("style-set", self.hbox_style_set_cb, window, tab)
			tab_data["hbox_style_set_hid"] = handler_id

			notebook.child_set(tab, "tab-expand", True)

	def detach_tab(self, window, tab):
		data = self.win_data[window]
		tab_data = data["tab_data"].pop(tab)

		notebook = window.get_notebook()
		widget = notebook.get_tab_label(tab)

		if tab.parent == notebook:
			notebook.child_set(tab, "tab-expand", False)

		if isinstance(widget, gtk.HBox):
			handler_id = tab_data["hbox_style_set_hid"]
			widget.disconnect(handler_id)

			widget.set_size_request(tab_data["tab_initial_width"], -1)

wt_extension = WideTab()

attach_window = wt_extension.attach_window
detach_window = wt_extension.detach_window

attach_tab = wt_extension.attach_tab
detach_tab = wt_extension.detach_tab
