#   Automatic Find Links As You Type - Epiphany Extension
#   Copyright (C) 2006-2007  Stefan Stuhr
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program; if not, write to the Free Software Foundation, Inc.,
#   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


import gtk
import gobject
import epiphany

def aflayt_get_entry(widget):
	for child in widget.get_children():
		if isinstance(child, gtk.Entry):
			return child
		elif hasattr(child, "get_children"):
			result = aflayt_get_entry(child)
			if result != None and isinstance(result, gtk.Entry):
				return result

	return None

def aflayt_idle_cb(window, entry):
	entry.emit("changed")

	delattr(window, "_aflayt_idle_id")

def aflayt_search_key_press_cb(embed, event, window, toolbar):
	if hasattr(window, "_aflayt_idle_id"):
		gobject.source_remove(window._aflayt_idle_id)
		delattr(window, "_aflayt_idle_id")

	if window.get_is_print_preview():
		return

	unival = gtk.gdk.keyval_to_unicode(event.keyval)
	if unival == 0:
		unistr = u""
	else:
		unistr = unichr(unival)

	if unistr in (u"", u"'", u"/", u" "):
		return

	entry = aflayt_get_entry(toolbar)
	entry.set_text("")

	if hasattr(toolbar, "open"):
		toolbar.open(True, True)
	else:
		toolbar.show()

	entry.insert_text(unistr, 0)
	entry.grab_focus()
	entry.set_position(-1)

	window._aflayt_idle_id = gobject.idle_add(aflayt_idle_cb, window, entry)

	return True

def detach_window(window):
	if hasattr(window, "_aflayt_idle_id"):
		gobject.source_remove(window._aflayt_idle_id)
		delattr(window, "_aflayt_idle_id")

def attach_tab(window, tab):
	if hasattr(tab, "get_embed"):
		embed = tab.get_embed()
	else:
		embed = tab
	signal = embed.connect("ge-search-key-press", aflayt_search_key_press_cb, window, window.get_find_toolbar())

	tab._aflayt_search_key_press_sig = signal

def detach_tab(window, tab):
	if not hasattr(tab, "_aflayt_search_key_press_sig"):
		return

	if hasattr(tab, "get_embed"):
		embed = tab.get_embed()
	else:
		embed = tab
	embed.disconnect(tab._aflayt_search_key_press_sig)

	delattr(tab, "_aflayt_search_key_press_sig")

