#include <glib.h>

#include "edv_types.h"
#include "edv_obj.h"
#include "edv_recycled_obj.h"
#include "edv_recbin_index.h"
#include "edv_recbin_stat.h"


edv_recycled_object_struct *EDVRecBinObjectStat(
	const gchar *filename,
	const guint index
);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Gets the statistics of the recycled object in the recycle bin.
 *
 *	The filename specifies the full path to the recycle bin index
 *	file.
 *
 *	The index specifies the index of recycled object who stats are
 *	to be obtained.
 *
 *	Returns a dynamically allocated recycled object containing the
 *	statistics of the recycled object or NULL on error.
 */
edv_recycled_object_struct *EDVRecBinObjectStat(
	const gchar *filename,
	const guint index
)
{
	edv_recycled_object_struct *obj;

	if(STRISEMPTY(filename))
	    return(NULL);

	obj = EDVRecycledObjectNew();

	/* Open the recycle bin index file and get values for the
	 * recycled object
	 */
	if(EDVRecBinObjectGetFromIndexFile(filename, index, obj))
	{
	    /* Unable to get the recycled object's stats */
	    EDVRecycledObjectDelete(obj);
	    return(NULL);
	}

	return(obj);
}
