#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "../include/fio.h"
#include "../include/disk.h"

#include "guiutils.h"

#include "cfg.h"
#include "edv_list_cb.h"
#include "about_dlg.h"
#include "endeavour2.h"
#include "edv_cfg_list.h"  
#include "config.h"
#include "compiletimeinfo.h"

#include "images/icon_ok_20x20.xpm"
#include "images/icon_endeavour_logo_48x48.xpm"


static void AboutDlgSwitchPageCB(
	GtkNotebook *notebook, GtkNotebookPage *page, guint page_num,
	gpointer data
);
static void AboutDlgOKCB(GtkWidget *widget, gpointer data);
static gint AboutDlgCloseCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);

about_dlg_struct *AboutDlgNew(edv_core_struct *core);
gboolean AboutDlgIsMapped(about_dlg_struct *d);
void AboutDlgMap(about_dlg_struct *d);
void AboutDlgUnmap(about_dlg_struct *d);
void AboutDlgDelete(about_dlg_struct *d);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


#define ABOUT_DLG_WIDTH		500
#define ABOUT_DLG_HEIGHT	420


/*
 *      GtkNotebook "switch_page" signal callback.
 */
static void AboutDlgSwitchPageCB(
	GtkNotebook *notebook, GtkNotebookPage *page, guint page_num,
	gpointer data
)
{
	about_dlg_struct *d = ABOUT_DLG(data);
	if((notebook == NULL) || (d == NULL))
	    return;

	if(d->freeze_count > 0)
	    return;

	d->freeze_count++;

	if(GTK_WIDGET(notebook) == d->notebook)
	{



	}

	d->freeze_count--;
}

/*
 *	Ok callback.
 */
static void AboutDlgOKCB(GtkWidget *widget, gpointer data)
{
	about_dlg_struct *d = ABOUT_DLG(data);
	if(d == NULL)
	    return;

	AboutDlgUnmap(d);
}

/*
 *	Close callback.
 */
static gint AboutDlgCloseCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	AboutDlgOKCB(widget, data);
	return(TRUE);
}

/*
 *	Create a new About Dialog.
 */
about_dlg_struct *AboutDlgNew(edv_core_struct *core)
{
	const gint	border_major = 5,
			border_minor = 2;
	gchar *heading[1];
	GdkColor color_fg, color_bg;
	GdkWindow *window;
	GtkStyle *style;
	GtkWidget *w, *parent, *parent2, *parent3, *parent4, *main_vbox;
	GtkAccelGroup *accelgrp;
	gpointer w_rtn1, w_rtn2;
	GtkEntry *entry;
	GtkRcStyle *rcstyle;
	GtkCList *clist;
	const cfg_item_struct *cfg_list;
	about_dlg_struct *d = ABOUT_DLG(g_malloc0(
	    sizeof(about_dlg_struct)
	));
	if((d == NULL) || (core == NULL))
	    return(NULL);

	cfg_list = core->cfg_list;

	d->accelgrp = accelgrp = gtk_accel_group_new();
	d->processing = FALSE;
	d->busy_count = 0;
	d->freeze_count = 0;
	d->core = core;

	/* Begin creating widgets */

	/* Toplevel */
	d->toplevel = w = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_widget_set_usize(w, ABOUT_DLG_WIDTH, ABOUT_DLG_HEIGHT);
#ifdef PROG_NAME_FULL
	gtk_window_set_title(
	    GTK_WINDOW(w),
#if defined(PROG_LANGUAGE_SPANISH)
"Acerca De"
#elif defined(PROG_LANGUAGE_FRENCH)
"De"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ungefhr"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Circa"
#elif defined(PROG_LANGUAGE_DUTCH)
"Over"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Sobre"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Omtrent"
#elif defined(PROG_LANGUAGE_POLISH)
"O programie"
#else
"About"
#endif
	    " " PROG_NAME_FULL
	);
#endif
#ifdef PROG_NAME
	gtk_window_set_wmclass(
	    GTK_WINDOW(w), "dialog", PROG_NAME
	);
#endif
	gtk_widget_realize(w);
	window = w->window;
	if(window != NULL)
	{
	    GdkWindow *root = gdk_window_get_parent(window);

	    gdk_window_set_decorations(
		window,
		GDK_DECOR_BORDER | GDK_DECOR_TITLE | GDK_DECOR_MENU |
		GDK_DECOR_MINIMIZE
	    );
	    gdk_window_set_functions(
		window,
		GDK_FUNC_MOVE | GDK_FUNC_MINIMIZE | GDK_FUNC_CLOSE
	    );
	    GUISetWMIcon(
		window,
		(guint8 **)icon_endeavour_logo_48x48_xpm
	    );

	    if(root != NULL)
	    {
		gint rx, ry, rw, rh, rd;

		gdk_window_get_geometry(
		    root, &rx, &ry, &rw, &rh, &rd
		);
		/* Move to center of desktop */
		gtk_widget_set_uposition(
		    w,
		    (rw / 2) - (w->allocation.width / 2),
		    (rh / 2) - (w->allocation.height / 2)
		);
	    }
	}
	gtk_signal_connect(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(AboutDlgCloseCB), d
	);
	gtk_window_add_accel_group(GTK_WINDOW(w), accelgrp);
	style = gtk_widget_get_style(w);
	parent = w;


	/* Main vbox */
	d->main_vbox = main_vbox = w = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;

	/* Vbox to hold notebook */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent = w;

	/* Notebook */
	d->notebook = w = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
	gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
#if 0
	gtk_notebook_set_page(GTK_NOTEBOOK(w), 0);
#endif
	gtk_signal_connect(
	    GTK_OBJECT(w), "switch_page",
	    GTK_SIGNAL_FUNC(AboutDlgSwitchPageCB), d
	);
	gtk_widget_show(w);
	parent2 = w;


	/* Credits Page ********************************************* */

	/* Credits page vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_notebook_append_page(
	    GTK_NOTEBOOK(parent2),
	    w,
	    gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Los Crditos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Crdits"
#elif defined(PROG_LANGUAGE_GERMAN)
"Kredite"
#elif defined(PROG_LANGUAGE_ITALIAN)
"I Crediti"
#elif defined(PROG_LANGUAGE_DUTCH)
"Kredieten"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Crditos"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Kreditter"
#elif defined(PROG_LANGUAGE_POLISH)
"Autorzy"
#else
"Credits"
#endif
	    )
	);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

#if defined(EDV_DEF_ABOUT_IMAGE_FILE)
	/* Hbox for about image */
	w = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* Frame for about image */
	w = gtk_frame_new(NULL);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_OUT);
	gtk_widget_show(w);
	parent4 = w;

	/* About image */
	if(cfg_list != NULL)
	{
	    /* Get path to image */
	    const gchar *data_dir = CFGItemListGetValueS(
		cfg_list, EDV_CFG_PARM_DIR_GLOBAL
	    );
	    gchar *path = STRDUP(PrefixPaths(
		data_dir, EDV_DEF_ABOUT_IMAGE_FILE
	    ));
	    if(!STRISEMPTY(path))
	    {
		/* Open image */
		GdkBitmap *mask;
		GdkPixmap *pixmap = GDK_PIXMAP_NEW_FROM_XPM_FILE(
		    &mask, path
		);
		if(pixmap != NULL)
		{
		    gint width, height;
		    gdk_window_get_size(pixmap, &width, &height);

		    w = gtk_pixmap_new(pixmap, mask);
		    gtk_widget_set_usize(w, width, height);
		    gtk_container_add(GTK_CONTAINER(parent4), w);
		    gtk_widget_show(w);

		    GDK_PIXMAP_UNREF(pixmap)
		    GDK_BITMAP_UNREF(mask)
		}
	    }
	    g_free(path);
	}
#endif

	/* Version banner */
	GDK_COLOR_SET_COEFF(&color_fg, 1.0f, 1.0f, 1.0f);
	GDK_COLOR_SET_COEFF(&color_bg, 0.0f, 0.0f, 0.0f);
	w = GUIBannerCreate(
#if defined(PROG_LANGUAGE_SPANISH)
"La Versin"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Version"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausfhrung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Versione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitvoering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Verso"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Versjon"
#elif defined(PROG_LANGUAGE_POLISH)
"Wersja"
#else
"Version"
#endif
	    " " PROG_VERSION, PROG_GTK_FONT_NAME_TEXT_HEADING3,
	    color_fg, color_bg,
	    GTK_JUSTIFY_CENTER,
	    TRUE
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Scrolled window for clist */
	w = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(
	    GTK_SCROLLED_WINDOW(w),
	    GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Credits clist */
	rcstyle = gtk_rc_style_new();
	rcstyle->font_name = STRDUP(PROG_GTK_FONT_NAME_TEXT_TERMINAL);
	heading[0] = "";
	d->credits_clist = w = gtk_clist_new_with_titles(1, heading);
	clist = GTK_CLIST(w);
	gtk_widget_add_events(
	    w,
	    GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
	    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
	    GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(EDVCListKeyEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(EDVCListKeyEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(EDVCListButtonEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_release_event",
	    GTK_SIGNAL_FUNC(EDVCListButtonEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "motion_notify_event",
	    GTK_SIGNAL_FUNC(EDVCListMotionEventCB), core
	);
	gtk_clist_column_titles_passive(clist);
	gtk_clist_column_titles_hide(clist);
	gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
/*	gtk_clist_set_selection_mode(clist, GTK_SELECTION_BROWSE); */
	gtk_clist_set_column_width(clist, 0, 10);
	gtk_container_add(GTK_CONTAINER(parent4), w);
	gtk_widget_modify_style(w, rcstyle);
	gtk_widget_show(w);
	GTK_RC_STYLE_UNREF(rcstyle)

#if defined(PROG_CREDITS_LINES)
	/* Add credits to credits clist */
	if(clist->columns > 0)
	{
	    gint i, row;
	    gchar **strv = (gchar **)g_malloc(
		clist->columns * sizeof(gchar *)
	    );
	    const gchar *credits_lines[] = PROG_CREDITS_LINES;

	    for(i = 0; i < clist->columns; i++)
		strv[i] = "";

	    gtk_clist_freeze(clist);
	    for(i = 0; credits_lines[i] != NULL; i++)
	    {
		strv[0] = (gchar *)credits_lines[i];
		row = gtk_clist_append(clist, strv);
		if(row > -1)
		{
		    gtk_clist_set_selectable(clist, row, FALSE);
		}
		else
		{
		    break;
		}
	    }
	    gtk_clist_thaw(clist);

	    g_free(strv);
	}
#endif


	/* Copyright Page ***************************************** */

	/* Copyright page vbox */   
	w = gtk_vbox_new(FALSE, border_major);
	gtk_notebook_append_page(    
	    GTK_NOTEBOOK(parent2),
	    w,
	    gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Derecho De Autor"
#elif defined(PROG_LANGUAGE_FRENCH)
"Dpose"
#elif defined(PROG_LANGUAGE_GERMAN)
"Urheberrecht"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Copyright"
#elif defined(PROG_LANGUAGE_DUTCH)
"Auteursrecht"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Direitos Autorais"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Copyright"
#elif defined(PROG_LANGUAGE_POLISH)
"Prawa autorskie"
#else
"Copyright"
#endif
	    )
	);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

#if defined(PROG_COPYRIGHT)
	/* Hbox for copyright label */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Copyright label */
	rcstyle = gtk_rc_style_new();
	rcstyle->font_name = STRDUP(PROG_GTK_FONT_NAME_TEXT_HEADING6);
	w = gtk_label_new(PROG_COPYRIGHT);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
/*	gtk_widget_modify_style(w, rcstyle); */
	gtk_widget_show(w);
	GTK_RC_STYLE_UNREF(rcstyle)
#endif

	/* Scrolled window for clist */
	w = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(
	    GTK_SCROLLED_WINDOW(w),
	    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* License clist */
	rcstyle = gtk_rc_style_new();
	rcstyle->font_name = STRDUP(PROG_GTK_FONT_NAME_TEXT_LICENSE);
	heading[0] = "";
	d->license_clist = w = gtk_clist_new_with_titles(1, heading);
	clist = GTK_CLIST(w);
	gtk_widget_add_events(
	    w,
	    GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
	    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
	    GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(EDVCListKeyEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(EDVCListKeyEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(EDVCListButtonEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_release_event",
	    GTK_SIGNAL_FUNC(EDVCListButtonEventCB), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "motion_notify_event",
	    GTK_SIGNAL_FUNC(EDVCListMotionEventCB), core
	);
	gtk_clist_column_titles_passive(clist);
	gtk_clist_column_titles_hide(clist);
	gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
/*	gtk_clist_set_selection_mode(clist, GTK_SELECTION_BROWSE); */
	gtk_clist_set_column_width(clist, 0, 10);
	gtk_container_add(GTK_CONTAINER(parent4), w);
	gtk_widget_modify_style(w, rcstyle);
	gtk_widget_show(w);
	GTK_RC_STYLE_UNREF(rcstyle)

#if defined(EDV_DEF_LICENSE_FILE)
	/* Read license file and load it to the clist */
	if((clist->columns > 0) && (cfg_list != NULL))
	{
	    /* Get path to license file */
	    const gchar *data_dir = CFGItemListGetValueS(
		cfg_list, EDV_CFG_PARM_DIR_GLOBAL
	    );
	    gchar *path = STRDUP(PrefixPaths(
		data_dir, EDV_DEF_LICENSE_FILE
	    ));

	    /* Open the license file for reading */
	    FILE *fp = FOpen(path, "rb");
	    if(fp != NULL)
	    {
		gint i, row;
		gchar **strv = (gchar **)g_malloc(
		    clist->columns * sizeof(gchar *)
		);
		for(i = 0; i < clist->columns; i++)
		    strv[i] = "";

		/* Add lines from file to clist */
		gtk_clist_freeze(clist);
		while(TRUE)
		{
		    strv[0] = FGetStringLiteral(fp);
		    if(strv[0] == NULL)
			break;

		    row = gtk_clist_append(clist, strv);
		    g_free(strv[0]);

		    if(row > -1)
		    {
			gtk_clist_set_selectable(clist, row, FALSE);
		    }
		    else
		    {
			break;
		    }
		}
		gtk_clist_thaw(clist);

		g_free(strv);

		/* Close the license file */
		FClose(fp);
	    }

	    g_free(path);
	}
#endif


	/* Version Page ********************************************** */

	/* Version page vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_notebook_append_page(
	    GTK_NOTEBOOK(parent2),
	    w,
	    gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Versin"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Version"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausfhrung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Versione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitvoering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Verso"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Versjon"
#elif defined(PROG_LANGUAGE_POLISH)
"Wersja"
#else
"Version"
#endif
	    )
	);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;


	/* Main Program Information */
	/* Frame */
	w = gtk_frame_new(
#ifdef PROG_NAME_FULL
	    PROG_NAME_FULL
#else
	    "Untitled Program"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Vbox in frame */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent4), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent4 = w;
	/* Version prompt */
	w = GUIPromptBar(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"La Versin"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Version"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausfhrung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Versione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitvoering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Verso"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Versjon"
#elif defined(PROG_LANGUAGE_POLISH)
"Wersja"
#else
"Version"
#endif
	    ":" , &w_rtn1, &w_rtn2
	);
	entry = (GtkEntry *)w_rtn2;
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_entry_set_editable(entry, FALSE);
	gtk_widget_set_usize(GTK_WIDGET(entry), 200, -1);
	gtk_widget_show(w);
#if defined(PROG_VERSION)
	gtk_entry_set_text(entry, PROG_VERSION);
#endif
	/* Language prompt */
	/* Compiler prompt */
	w = GUIPromptBar(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"El Idioma"
#elif defined(PROG_LANGUAGE_FRENCH)
"Langue"
#elif defined(PROG_LANGUAGE_GERMAN)
"Sprache"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Lingua"
#elif defined(PROG_LANGUAGE_DUTCH)
"Taal"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Linguagem"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sprk"
#elif defined(PROG_LANGUAGE_POLISH)
"Jzyk"
#else
"Language"
#endif
	    ":", &w_rtn1, &w_rtn2
	);
	entry = (GtkEntry *)w_rtn2;
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_entry_set_editable(entry, FALSE);
	gtk_widget_set_usize(GTK_WIDGET(entry), 200, -1);
	gtk_widget_show(w);
	gtk_entry_set_text(
	    entry,
#if defined(PROG_LANGUAGE_SPANISH)
"El Espaol"
#elif defined(PROG_LANGUAGE_FRENCH)
"Franais"
#elif defined(PROG_LANGUAGE_GERMAN)
"Deutsch"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Italiano"
#elif defined(PROG_LANGUAGE_DUTCH)
"Nederlands"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Portugus"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Norsk"
#elif defined(PROG_LANGUAGE_POLISH)
"Polski"
#else
"English"
#endif
	);

	/* Compile date prompt */
	w = GUIPromptBar(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Compile La Fecha"
#elif defined(PROG_LANGUAGE_FRENCH)
"Compiler La Date"
#elif defined(PROG_LANGUAGE_GERMAN)
"Kompilieren Sie Datum"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Compilare La Data"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verzameel Datum"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Compile Data"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Kompiler Date"
#elif defined(PROG_LANGUAGE_POLISH)
"Data kompilacji"
#else
"Compile Date"
#endif
	    ":", &w_rtn1, &w_rtn2
	);
	entry = (GtkEntry *)w_rtn2;
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_entry_set_editable(entry, FALSE);
	gtk_widget_set_usize(GTK_WIDGET(entry), 200, -1);
	gtk_widget_show(w);
#if defined(COMPILE_DATE)
	if(COMPILE_DATE > 0)
	{
	    time_t t = COMPILE_DATE;
	    gchar *s = STRDUP(ctime(&t));
	    if(s != NULL)
	    {
		gchar *s2 = strchr(s, '\n');
		if(s2 != NULL)
		    *s2 = '\0';
		gtk_entry_set_text(entry, s);
		g_free(s);
	    }
	}
#endif
	/* Compiler prompt */
	w = GUIPromptBar(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"El Compilador"
#elif defined(PROG_LANGUAGE_FRENCH)
"Compilateur"
#elif defined(PROG_LANGUAGE_GERMAN)
"Compiler"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Compilatore"
#elif defined(PROG_LANGUAGE_DUTCH)
"Compilator"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Compilador"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Kompilator"
#elif defined(PROG_LANGUAGE_POLISH)
"Kompilator"
#else
"Compiler"
#endif
	    ":", &w_rtn1, &w_rtn2
	);
	entry = (GtkEntry *)w_rtn2;
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_entry_set_editable(entry, FALSE);
	gtk_widget_set_usize(GTK_WIDGET(entry), 200, -1);
	gtk_widget_show(w);
#if defined(COMPILE_COMPILER)
	gtk_entry_set_text(entry, COMPILE_COMPILER);
#endif
	/* Location prompt */
	w = GUIPromptBar(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Compilado En"
#elif defined(PROG_LANGUAGE_FRENCH)
"Compil A"
#elif defined(PROG_LANGUAGE_GERMAN)
"Kompiliert An"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Compilato A"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verzamelde Aan"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Compilado Em"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Kompilert At"
#elif defined(PROG_LANGUAGE_POLISH)
"Skompilowano na"
#else
"Compiled At"
#endif
	    ":" , &w_rtn1, &w_rtn2
	);
	entry = (GtkEntry *)w_rtn2;
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_entry_set_editable(entry, FALSE);
	gtk_widget_set_usize(GTK_WIDGET(entry), 200, -1);
	gtk_widget_show(w);
#if defined(COMPILE_LOCATION)
	gtk_entry_set_text(entry, COMPILE_LOCATION);
#endif

#ifdef IMLIB_VERSION
	/* Imlib Information */
	/* Frame */
	w = gtk_frame_new("Imlib");
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Vbox in frame */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent4), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent4 = w;
	/* Version prompt */
	w = GUIPromptBar(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"La Versin"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Version"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausfhrung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Versione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitvoering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Verso"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Versjon"
#elif defined(PROG_LANGUAGE_POLISH)
"Wersja"
#else
"Version"
#endif
	    ":" , &w_rtn1, &w_rtn2
	);
	entry = (GtkEntry *)w_rtn2;
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_entry_set_editable(entry, FALSE);
	gtk_widget_set_usize(GTK_WIDGET(entry), 200, -1);
	gtk_widget_show(w);

	gtk_entry_set_text(entry, IMLIB_VERSION);
#endif

	/* GTK+ Information */
	/* Frame */
	w = gtk_frame_new("GTK+");
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Vbox in frame */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent4), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent4 = w;
	/* Version prompt */
	w = GUIPromptBar(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"La Versin"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Version"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausfhrung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Versione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitvoering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Verso"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Versjon"
#elif defined(PROG_LANGUAGE_POLISH)
"Wersja"
#else
"Version"
#endif
	    ":" , &w_rtn1, &w_rtn2
	);
	entry = (GtkEntry *)w_rtn2;
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_entry_set_editable(entry, FALSE);
	gtk_widget_set_usize(GTK_WIDGET(entry), 200, -1);
	gtk_widget_show(w);

	if((gtk_major_version != 0) || (gtk_minor_version != 0) ||
	   (gtk_micro_version != 0)
	)
	{
	    gchar *s = g_strdup_printf(
		"%i.%i.%i",
		gtk_major_version, gtk_minor_version, gtk_micro_version
	    );
	    gtk_entry_set_text(entry, s);
	    g_free(s);
	}


	/* End Of Pages ********************************************* */


	/* Hbox to hold buttons homogeniously */
	w = gtk_hbox_new(TRUE, 0);   
	gtk_box_pack_start(
	    GTK_BOX(main_vbox), w, FALSE, FALSE, border_major
	);
	gtk_widget_show(w);
	parent2 = w;

	/* Ok button */
	d->ok_btn = w = GUIButtonPixmapLabelH(
	    (guint8 **)icon_ok_20x20_xpm, "OK", NULL
	);
	GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
	gtk_widget_set_usize(
	    w,
	    GUI_BUTTON_HLABEL_WIDTH_DEF, GUI_BUTTON_HLABEL_HEIGHT_DEF
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(AboutDlgOKCB), d
	);
	gtk_accel_group_add(
	    accelgrp, GDK_Escape, 0, GTK_ACCEL_VISIBLE,
	    GTK_OBJECT(w), "clicked"
	);
	gtk_accel_group_add(
	    accelgrp, GDK_o, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE,
	    GTK_OBJECT(w), "clicked"
	);
	GUIButtonLabelUnderline(w, GDK_o);
	gtk_widget_show(w);

	return(d);
}

/*
 *	Checks if the About Dialog is mapped.
 */
gboolean AboutDlgIsMapped(about_dlg_struct *d)
{
	GtkWidget *w = (d != NULL) ? d->toplevel : NULL;
	return((w != NULL) ? GTK_WIDGET_MAPPED(w) : FALSE);
}

/*
 *	Map the About Dialog.
 */
void AboutDlgMap(about_dlg_struct *d)
{
	GtkWidget *w = (d != NULL) ? d->toplevel : NULL;
	if(w == NULL)
	    return;
  
	gtk_widget_show_raise(w);

	/* Grab focus on the OK button */
	w = d->ok_btn;
	if(w != NULL)
	{
	    gtk_widget_grab_focus(w);
	    gtk_widget_grab_default(w);
	}
}

/*
 *	Unmap the About Dialog.
 */
void AboutDlgUnmap(about_dlg_struct *d)
{
	GtkWidget *w = (d != NULL) ? d->toplevel : NULL;
	if(w == NULL)
	    return;

	gtk_widget_hide(w);
}

/*
 *	Deletes the About Dialog.
 */
void AboutDlgDelete(about_dlg_struct *d)
{
	if(d == NULL)
	    return;

	GTK_WIDGET_DESTROY(d->credits_clist)
	GTK_WIDGET_DESTROY(d->license_clist)
	GTK_WIDGET_DESTROY(d->notebook)
	GTK_WIDGET_DESTROY(d->ok_btn)
	GTK_WIDGET_DESTROY(d->main_vbox)
	GTK_WIDGET_DESTROY(d->toplevel)
	GTK_ACCEL_GROUP_UNREF(d->accelgrp)

	g_free(d);
}
