/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import com.stevesoft.pat.Regex;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.FileParse;
import jalview.schemes.ResidueProperties;
import jalview.util.DBRefUtils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class StockholmFile
extends AlignFile {
    private static Hashtable typeIds = null;

    public StockholmFile() {
    }

    public StockholmFile(String inFile, String type) throws IOException {
        super(inFile, type);
    }

    public StockholmFile(FileParse source) throws IOException {
        super(source);
    }

    public void initData() {
        super.initData();
    }

    public void parse() throws IOException {
        String line;
        StringBuffer treeString = new StringBuffer();
        String treeName = null;
        Hashtable<String, Hashtable> seqAnn = new Hashtable<String, Hashtable>();
        Hashtable<String, String> seqs = new Hashtable<String, String>();
        Regex r = new Regex("# STOCKHOLM ([\\d\\.]+)");
        if (!r.search(this.nextLine())) {
            throw new IOException("This file is not in valid STOCKHOLM format: First line does not contain '# STOCKHOLM'");
        }
        String version = r.stringMatched(1);
        Regex rend = new Regex("\\/\\/");
        Regex p = new Regex("(\\S+)\\/(\\d+)\\-(\\d+)");
        Regex s = new Regex("(\\S+)\\s+(\\S*)\\s+(.*)");
        r = new Regex("#=(G[FSRC]?)\\s+(.*)");
        Regex x = new Regex("(\\S+)\\s+(\\S+)");
        rend.optimize();
        p.optimize();
        s.optimize();
        r.optimize();
        x.optimize();
        while ((line = this.nextLine()) != null) {
            String type;
            String acc;
            Hashtable features;
            if (line.length() == 0) continue;
            if (rend.search(line)) {
                this.noSeqs = seqs.size();
                Enumeration accs = seqs.keys();
                while (accs.hasMoreElements()) {
                    String dbr;
                    String acc2 = (String)accs.nextElement();
                    String seq = (String)seqs.remove(acc2);
                    if (this.maxLength < seq.length()) {
                        this.maxLength = seq.length();
                    }
                    int start = 1;
                    int end = -1;
                    String sid = acc2;
                    Hashtable accAnnotations = null;
                    if (seqAnn != null && seqAnn.containsKey(acc2)) {
                        accAnnotations = (Hashtable)seqAnn.remove(acc2);
                    }
                    if (p.search(acc2)) {
                        sid = p.stringMatched(1);
                        start = Integer.parseInt(p.stringMatched(2));
                        end = Integer.parseInt(p.stringMatched(3));
                    }
                    Sequence seqO = new Sequence(sid, seq, start, end);
                    if (accAnnotations != null && accAnnotations.containsKey("DE")) {
                        String desc = (String)accAnnotations.get("DE");
                        seqO.setDescription(desc == null ? "" : desc);
                    }
                    if (accAnnotations != null && accAnnotations.containsKey("DR") && (dbr = (String)accAnnotations.get("DR")) != null && dbr.indexOf(";") > -1) {
                        String src = dbr.substring(0, dbr.indexOf(";"));
                        String acn = dbr.substring(dbr.indexOf(";") + 1);
                        DBRefUtils.parseToDbRef(seqO, src, "0", acn);
                    }
                    features = null;
                    try {
                        features = (Hashtable)accAnnotations.remove("features");
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    if (features != null) {
                        int[] posmap = seqO.findPositionMap();
                        Enumeration i = features.keys();
                        while (i.hasMoreElements()) {
                            String type2 = i.nextElement().toString();
                            Hashtable content = (Hashtable)features.remove(type2);
                            Enumeration j = content.keys();
                            while (j.hasMoreElements()) {
                                String desc = j.nextElement().toString();
                                String ns = content.get(desc).toString();
                                char[] byChar = ns.toCharArray();
                                for (int k = 0; k < byChar.length; ++k) {
                                    char c = byChar[k];
                                    if (c == ' ' || c == '_' || c == '-' || c == '.') continue;
                                    int new_pos = posmap[k];
                                    SequenceFeature feat = new SequenceFeature(type2, desc, new_pos, new_pos, 0.0f, null);
                                    seqO.addSequenceFeature(feat);
                                }
                            }
                        }
                    }
                    this.seqs.addElement(seqO);
                }
                return;
            }
            if (!r.search(line)) {
                if (!x.search(line)) {
                    throw new IOException("Could not parse sequence line: " + line);
                }
                String ns = (String)seqs.get(x.stringMatched(1));
                if (ns == null) {
                    ns = "";
                }
                ns = ns + x.stringMatched(2);
                seqs.put(x.stringMatched(1), ns);
                continue;
            }
            String annType = r.stringMatched(1);
            String annContent = r.stringMatched(2);
            if (annType.equals("GF")) {
                Regex an = new Regex("(\\w+)\\s*(.*)");
                if (!an.search(annContent)) continue;
                if (an.stringMatched(1).equals("NH")) {
                    treeString.append(an.stringMatched(2));
                } else if (an.stringMatched(1).equals("TN")) {
                    if (treeString.length() > 0) {
                        if (treeName == null) {
                            treeName = "Tree " + (this.getTreeCount() + 1);
                        }
                        this.addNewickTree(treeName, treeString.toString());
                    }
                    treeName = an.stringMatched(2);
                    treeString = new StringBuffer();
                }
                this.setAlignmentProperty(an.stringMatched(1), an.stringMatched(2));
                continue;
            }
            if (annType.equals("GS")) {
                if (s.search(annContent)) {
                    acc = s.stringMatched(1);
                    type = s.stringMatched(2);
                    String content = s.stringMatched(3);
                    Hashtable ann = seqAnn.containsKey(acc) ? (Hashtable)seqAnn.get(acc) : new Hashtable();
                    ann.put(type, content);
                    seqAnn.put(acc, ann);
                    continue;
                }
                throw new IOException("Error parsing " + line);
            }
            if (annType.equals("GC")) {
                if (!x.search(annContent)) continue;
                this.parseAnnotationRow(this.annotations, x.stringMatched(1), x.stringMatched(2));
                continue;
            }
            if (annType.equals("GR")) {
                if (s.search(annContent)) {
                    Hashtable content;
                    Hashtable ann;
                    acc = s.stringMatched(1);
                    type = s.stringMatched(2);
                    String seq = new String(s.stringMatched(3));
                    String description = null;
                    StringTokenizer sep = new StringTokenizer(seq, " \t");
                    description = sep.nextToken();
                    if (sep.hasMoreTokens()) {
                        seq = sep.nextToken();
                    } else {
                        seq = description;
                        description = new String();
                    }
                    if (seqAnn.containsKey(acc)) {
                        ann = (Hashtable)seqAnn.get(acc);
                    } else {
                        ann = new Hashtable();
                        seqAnn.put(acc, ann);
                    }
                    if (ann.containsKey("features")) {
                        features = (Hashtable)ann.get("features");
                    } else {
                        features = new Hashtable();
                        ann.put("features", features);
                    }
                    if (features.containsKey(this.id2type(type))) {
                        content = (Hashtable)features.get(this.id2type(type));
                    } else {
                        content = new Hashtable();
                        features.put(this.id2type(type), content);
                    }
                    String ns = (String)content.get(description);
                    if (ns == null) {
                        ns = "";
                    }
                    ns = ns + seq;
                    content.put(description, seq);
                    continue;
                }
                System.err.println("Warning - couldn't parse sequence annotation row line:\n" + line);
                continue;
            }
            throw new IOException("Unknown annotation detected: " + annType + " " + annContent);
        }
        if (treeString.length() > 0) {
            if (treeName == null) {
                treeName = "Tree " + (1 + this.getTreeCount());
            }
            this.addNewickTree(treeName, treeString.toString());
        }
    }

    private AlignmentAnnotation parseAnnotationRow(Vector annotation, String label, String annots) {
        String type = label.indexOf("_cons") == label.length() - 5 ? label.substring(0, label.length() - 5) : label;
        boolean ss = false;
        if ((type = this.id2type(type)).equals("secondary structure")) {
            ss = true;
        }
        Annotation[] els = new Annotation[annots.length()];
        for (int i = 0; i < annots.length(); ++i) {
            String pos = annots.substring(i, i + 1);
            Annotation ann = new Annotation(pos, "", ' ', 0.0f);
            if (ss) {
                ann.secondaryStructure = ResidueProperties.getDssp3state(pos).charAt(0);
                ann.displayCharacter = ann.secondaryStructure == pos.charAt(0) || pos.charAt(0) == 'C' ? "" : " " + ann.displayCharacter;
            }
            els[i] = ann;
        }
        AlignmentAnnotation annot = null;
        Enumeration e = annotation.elements();
        while (e.hasMoreElements()) {
            annot = (AlignmentAnnotation)e.nextElement();
            if (annot.label.equals(type)) break;
            annot = null;
        }
        if (annot == null) {
            annot = new AlignmentAnnotation(type, type, els);
            annotation.addElement(annot);
        } else {
            Annotation[] anns = new Annotation[annot.annotations.length + els.length];
            System.arraycopy(annot.annotations, 0, anns, 0, annot.annotations.length);
            System.arraycopy(els, 0, anns, annot.annotations.length, els.length);
            annot.annotations = anns;
        }
        return annot;
    }

    public static String print(SequenceI[] s) {
        return "not yet implemented";
    }

    public String print() {
        return StockholmFile.print(this.getSeqsAsArray());
    }

    private String id2type(String id) {
        if (typeIds.containsKey(id)) {
            return (String)typeIds.get(id);
        }
        System.err.println("Warning : Unknown Stockholm annotation type code " + id);
        return id;
    }

    static {
        if (typeIds == null) {
            typeIds = new Hashtable();
            typeIds.put("SS", "secondary structure");
            typeIds.put("SA", "surface accessibility");
            typeIds.put("TM", "transmembrane");
            typeIds.put("PP", "posterior probability");
            typeIds.put("LI", "ligand binding");
            typeIds.put("AS", "active site");
            typeIds.put("IN", "intron");
            typeIds.put("IR", "interacting residue");
            typeIds.put("AC", "accession");
            typeIds.put("OS", "organism");
            typeIds.put("CL", "class");
            typeIds.put("DE", "description");
            typeIds.put("DR", "reference");
            typeIds.put("LO", "look");
            typeIds.put("RF", "reference positions");
        }
    }
}

