<?
/*
 * dsyslog - a dumb syslog (e.g. syslog for people who have a clue)
 * Copyright (c) 2008 William Pitcock <nenolod@sacredspiral.co.uk>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice is present in all copies.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
$_title = "Home";
include "functions.php";
include "header.php";
?>
<? divboxstart("Machines"); ?>
Showing the last 100 entries. Select a machine to view all available logs for that machine.<br>
Logs are available for these machines:
<?
	$res = get_db_rows("SELECT DISTINCT source FROM log ORDER BY source DESC;");
	while ($row = get_db_tuple($res)) {
		echo "$delim<a href=\"logs.php?source=$row[source]\">$row[source]</a>";
		if (!$delim) $delim = " | ";
	}
?>
 | <a href="logs.php">All machines</a>.
</ul>
<? divboxend(); ?>
<br>
<? divboxstart("Programs"); ?>
Logs are available for these programs:
<?
        $res = get_db_rows("SELECT DISTINCT program FROM log ORDER BY source DESC;");
        while ($row = get_db_tuple($res)) {
                echo "$delim<a href=\"logs.php?program=$row[program]\">$row[program]</a>";
                if (!$delim) $delim = " | ";
        }
?>
 | <a href="logs.php">All logs</a>.
</ul>
<? divboxend(); ?>
<br>
<? divboxstart("Last 100 log entries", "#fcfcfc"); ?>
These are the last 100 log entries recorded by dsyslog.
<table class="logviewer" width="100%">
<tr>
<td style="font-weight: bold;">Service</td>
<td style="text-align: right; font-weight: bold;">Time</td>
</tr>
<tr>
<td style="font-weight: bold; border-bottom: 1px #000 solid;" colspan="2">Message</td>
</tr>
<?
	$res = get_db_rows("SELECT datestamp,source,program,message FROM log ORDER BY timestamp DESC LIMIT 100;");
	while ($row = get_db_tuple($res)) {
?>
<tr>
<td><a href="logs.php?source=<?= $row[source] ?>"><?= $row[source] ?></a>'s <a href="logs.php?program=<?= $row[program] ?>"><?= $row[program] ?></a></td>
<td style="text-align: right;"><?= $row[datestamp] ?></td>
</tr>
<tr>
<td style="border-bottom: 1px #000 solid;" colspan="2"><?= $row[message] ?>&nbsp;</td>
</tr>
<?
	}
?>
</table>
<? divboxend(); ?>
<?
include "footer.php";
?>
