/*
 * File: pixmaps.h
 *
 * Copyright (C) 2000, 2001 Jorge Arellano Cid <jcid@dillo.org>
 * Design by John Grantham, Dipl.-Designer; http://www.grantham.de/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef __PIXMAPS_H__
#define __PIXMAPS_H__

/* XPM
static char * history_xpm[] = {
"11 20 6 1",
"       c None",
".      c #000000000000",
"X      c #9658A289BEFB",
"O      c #FFFF9A690000",
"+      c #FFFFFFFF0000",
"@      c #FFFFFFFFFFFF",
"           ",
"     .     ",
"    .X.    ",
"   .XXX.   ",
"  .XXXXX.  ",
" .XXXXXXX. ",
" ...XXX... ",
"   .XXX.   ",
"   .XXX.   ",
"   .XXX.   ",
"   OOOOO   ",
"   .XXX.   ",
"   .XXX.   ",
" ...XXX... ",
" .XXXXXXX. ",
"  .XXXXX.  ",
"   .XXX.   ",
"    .X.    ",
"     .     ",
"           "};
*/
/* XPM */
static char * left_xpm[] = {
"22 22 46 1",
"       c None",
".      c #000000",
"+      c #FF7856",
"@      c #FF8361",
"#      c #FF5325",
"$      c #FF8C68",
"%      c #FF6636",
"&      c #FF6333",
"*      c #FF936B",
"=      c #FF6E39",
"-      c #FF5111",
";      c #FF8C61",
">      c #FFA685",
",      c #FF8659",
"'      c #FF996E",
")      c #FF773D",
"!      c #FF5C16",
"~      c #FF570F",
"{      c #EC510E",
"]      c #FF894C",
"^      c #FF7E3B",
"/      c #FF681A",
"(      c #FF6414",
"_      c #EC5D13",
":      c #C56932",
"<      c #CB5A15",
"[      c #F86E19",
"}      c #FF711A",
"|      c #EC6918",
"1      c #9F5F31",
"2      c #C56118",
"3      c #F87A1E",
"4      c #FF7D1F",
"5      c #EC741D",
"6      c #9F6532",
"7      c #C56A1C",
"8      c #F88523",
"9      c #8C4B14",
"0      c #582F0C",
"a      c #894A13",
"b      c #9F6B35",
"c      c #C57320",
"d      c #B96C1E",
"e      c #A47339",
"f      c #C77C23",
"g      c #93601C",
"                      ",
"                      ",
"                      ",
"                      ",
"        ..            ",
"       .+.            ",
"      .@#.            ",
"     .$%&...... ....  ",
"    .*=-=;>>>,. .,,.  ",
"   .')!~~~~~~{. .{{.  ",
"  .]^/(((((((_. .__.  ",
"  .:<[}}}}}}}|. .||.  ",
"   .1234444445. .55.  ",
"    .67879000a. .aa.  ",
"     .bcd...... ....  ",
"      .ef.            ",
"       .g.            ",
"        ..            ",
"                 .....",
"                  .>. ",
"                   .  ",
"                      "};
/* XPM */
static char * right_xpm[] = {
"22 22 46 1",
"       c None",
".      c #000000",
"+      c #569A59",
"@      c #228126",
"#      c #60A463",
"$      c #2E9132",
"%      c #319335",
"&      c #65AE68",
"*      c #52AC55",
"=      c #80C282",
"-      c #5BB15E",
";      c #319C35",
">      c #07880C",
",      c #65B568",
"'      c #008905",
")      c #009405",
"!      c #07970C",
"~      c #31A935",
"{      c #65BF68",
"]      c #009705",
"^      c #00A305",
"/      c #07A60C",
"(      c #2AB22E",
"_      c #3CB83F",
":      c #00A605",
"<      c #00B305",
"[      c #00AE05",
"}      c #008E04",
"|      c #219424",
"1      c #00B405",
"2      c #00C205",
"3      c #00BD05",
"4      c #009604",
"5      c #218124",
"6      c #007003",
"7      c #004802",
"8      c #007303",
"9      c #00A104",
"0      c #00CB05",
"a      c #218924",
"b      c #00A304",
"c      c #00AD04",
"d      c #219024",
"e      c #00B804",
"f      c #219B24",
"g      c #008E03",
"                      ",
"                      ",
"                      ",
"                      ",
"            ..        ",
"            .+.       ",
"            .@#.      ",
"  .... ......$%&.     ",
"  .**. .*===-;>;,.    ",
"  .''. .'))))))!~{.   ",
"  .]]. .]^^^^^^^/(_.  ",
"  .::. .:<<<<<<<[}|.  ",
"  .11. .1222222345.   ",
"  .66. .67778909a.    ",
"  .... ......bcd.     ",
"            .ef.      ",
"            .g.       ",
"            ..        ",
"                 .....",
"                  .=. ",
"                   .  ",
"                      "};
/* XPM */
static char * reload_xpm[] = {
"22 22 147 2",
"       c None",
".      c #000000",
"+      c #BABABA",
"@      c #CCCCCC",
"#      c #CBCBCB",
"$      c #5D5D5D",
"%      c #909090",
"&      c #9C9C9C",
"*      c #A0A0A0",
"=      c #EBEBEB",
"-      c #4C4C4C",
";      c #949494",
">      c #8D8D8D",
",      c #FFFFFF",
"'      c #E4E4E4",
")      c #424242",
"!      c #989898",
"~      c #A4A4A4",
"{      c #878787",
"]      c #FBFBFB",
"^      c #E1E1E1",
"/      c #393939",
"(      c #9B9B9B",
"_      c #A8A8A8",
":      c #898989",
"<      c #ECECEC",
"[      c #DEDEDE",
"}      c #313131",
"|      c #0B0B0B",
"1      c #0C0C0C",
"2      c #2B2B2B",
"3      c #575757",
"4      c #8B8B8B",
"5      c #AEAEAE",
"6      c #8E8E8E",
"7      c #DDDDDD",
"8      c #2C2C2C",
"9      c #282828",
"0      c #666666",
"a      c #A3A3A3",
"b      c #C0C0C0",
"c      c #7D7D7D",
"d      c #3F3F3F",
"e      c #1D1D1D",
"f      c #6B6B6B",
"g      c #929292",
"h      c #585858",
"i      c #BEBEBE",
"j      c #4F4F4F",
"k      c #A5A5A5",
"l      c #BDBDBD",
"m      c #B1B1B1",
"n      c #A9A9A9",
"o      c #AAAAAA",
"p      c #696969",
"q      c #0A0A0A",
"r      c #5F5F5F",
"s      c #515151",
"t      c #545454",
"u      c #686868",
"v      c #868686",
"w      c #B5B5B5",
"x      c #B4B4B4",
"y      c #7F907F",
"z      c #436B43",
"A      c #144F14",
"B      c #004800",
"C      c #1E1E1E",
"D      c #838383",
"E      c #9F9F9F",
"F      c #262626",
"G      c #9D9D9D",
"H      c #B8B8B8",
"I      c #839583",
"J      c #577A57",
"K      c #7E917E",
"L      c #A7AAA7",
"M      c #426D42",
"N      c #004600",
"O      c #A1A1A1",
"P      c #404040",
"Q      c #636363",
"R      c #C6C6C6",
"S      c #B7B7B7",
"T      c #728C72",
"U      c #B0B2B0",
"V      c #777777",
"W      c #323232",
"X      c #C2C2C2",
"Y      c #BCBCBC",
"Z      c #8EA18E",
"`      c #004B00",
" .     c #979797",
"..     c #0F0F0F",
"+.     c #D2D2D2",
"@.     c #AFAFAF",
"#.     c #C4C4C4",
"$.     c #B0B0B0",
"%.     c #D9D9D9",
"&.     c #C9C9C9",
"*.     c #7A5200",
"=.     c #B8AE9A",
"-.     c #101010",
";.     c #DFDFDF",
">.     c #CECECE",
",.     c #BFBFBF",
"'.     c #D4D4D4",
").     c #7F5500",
"!.     c #D2D1CE",
"~.     c #B4A585",
"{.     c #E5E5E5",
"].     c #845800",
"^.     c #A58A53",
"/.     c #C3B79F",
"(.     c #D9D7D3",
"_.     c #B09A6E",
":.     c #C6BBA5",
"<.     c #747474",
"[.     c #3A3A3A",
"}.     c #EAEAEA",
"|.     c #222222",
"1.     c #865A00",
"2.     c #CCC1AA",
"3.     c #AC915B",
"4.     c #936C1C",
"5.     c #E0E0E0",
"6.     c #414141",
"7.     c #787878",
"8.     c #F0F0F0",
"9.     c #8C8C8C",
"0.     c #C3C3C3",
"a.     c #E2E2E2",
"b.     c #F4F4F4",
"c.     c #646464",
"d.     c #9E9E9E",
"e.     c #DCDCDC",
"f.     c #6A6A6A",
"g.     c #555555",
"h.     c #0E0E0E",
"i.     c #F8F8F8",
"j.     c #E6E6E6",
"k.     c #191919",
"l.     c #2F2F2F",
"m.     c #464646",
"n.     c #444444",
"o.     c #242424",
"p.     c #343434",
"          . . . . . . . . . . .             ",
"          . + @ @ @ @ @ @ @ # $ .           ",
"          . % & & & & & & & * = - .         ",
"          . ; * * * * * * * > , ' ) .       ",
"          . ! ~ ~ ~ ~ ~ ~ ~ { ] , ^ / .     ",
"          . ( _ _ _ _ _ _ _ : < , , [ } .   ",
"          . | 1 1 1 2 3 4 5 6 < , , , 7 8 . ",
"      . 9 0 a b b a c d e f g : h h f * i . ",
"    . j k l m n n m l o p q r f s s t u v . ",
"  . - w x y z A A z y B w u C D & & & E * . ",
"  F G H I J K L K M N N H O P Q R R R R S . ",
". $ i S T U w w w B B B S i V W @ @ @ @ l . ",
". 6 X Y Z Y Y Y ` ` ` ` Y X  ...+.+.+.+.X . ",
". @.R #.#.#.#.#.#.#.#.#.#.R $...%.%.%.%.&.. ",
". n #.@ *.*.*.*.@ @ @ =.@ #.o -.;.;.;.;.>.. ",
". v ,.'.).).).'.'.'.!.~.'.,.% -.{.{.{.{.'.. ",
". 3 w '.].].^./.(./._.:.'.w <.[.}.}.}.}.%.. ",
"  |.{ X 1.2.3.4.4.3.2.5.X > 6.7.8.8.8.8.[ . ",
"  . [.9.0.a.}.}.}.}.a.0.> $ 9 X b.b.b.b.a.. ",
"    . W c.d.R e.e.R d.f.g.h.; i.i.i.i.i.j.. ",
"      . k.l.m.j j n.[.o.h.p.3 3 3 3 3 3 { . ",
"          . . . . . . . . . . . . . . . . . "};
/* XPM */
static char * home_xpm[] = {
"22 22 106 2",
"       c None",
".      c #190E0B",
"+      c #180D09",
"@      c #D8947D",
"#      c #000000",
"$      c #190D09",
"%      c #CC6746",
"&      c #A7401F",
"*      c #C65834",
"=      c #1A0D09",
"-      c #D16746",
";      c #A63F1F",
">      c #160D09",
",      c #C13206",
"'      c #D86746",
")      c #AD3F1F",
"!      c #1C0F0A",
"~      c #9B9376",
"{      c #D2502A",
"]      c #1B0D09",
"^      c #DF6746",
"/      c #B43F1F",
"(      c #999174",
"_      c #C1B588",
":      c #D34721",
"<      c #D8461E",
"[      c #1C0D09",
"}      c #E76746",
"|      c #BB3F1F",
"1      c #1D0F0A",
"2      c #C5B98B",
"3      c #C4B889",
"4      c #93371F",
"5      c #E14821",
"6      c #1B0803",
"7      c #1D0D09",
"8      c #EE6746",
"9      c #C33F1F",
"0      c #1E0F0A",
"a      c #9E9678",
"b      c #CABD8F",
"c      c #CCBF8E",
"d      c #CFC290",
"e      c #1E0D09",
"f      c #F56746",
"g      c #CA3F1F",
"h      c #21110A",
"i      c #A09879",
"j      c #CDC091",
"k      c #D2C593",
"l      c #D8CA97",
"m      c #DCCE9A",
"n      c #1D0500",
"o      c #C63F21",
"p      c #9E361F",
"q      c #130300",
"r      c #988E6A",
"s      c #D1C492",
"t      c #D5C895",
"u      c #DDCF9A",
"v      c #E4D69F",
"w      c #E9DAA3",
"x      c #C9BC8C",
"y      c #DACC98",
"z      c #E0D29C",
"A      c #E8D9A2",
"B      c #EFE0A7",
"C      c #F2E3A9",
"D      c #5E5842",
"E      c #676047",
"F      c #F9E9AE",
"G      c #655F46",
"H      c #DBCD99",
"I      c #C16C4E",
"J      c #D3927C",
"K      c #C86F51",
"L      c #FCECB0",
"M      c #D6D6D6",
"N      c #D2D2D2",
"O      c #E3D49F",
"P      c #A82900",
"Q      c #B82C00",
"R      c #AB2A00",
"S      c #FEEEB1",
"T      c #6F6D6D",
"U      c #6D6B6B",
"V      c #E7D9A2",
"W      c #B52A00",
"X      c #C42D00",
"Y      c #B62A00",
"Z      c #FFEFB2",
"`      c #696249",
" .     c #676048",
"..     c #EADBA4",
"+.     c #C12A00",
"@.     c #D22D00",
"#.     c #C22A00",
"$.     c #ECDDA5",
"%.     c #CE2A00",
"&.     c #DF2D00",
"*.     c #DA2A00",
"=.     c #EC2D00",
"-.     c #898060",
";.     c #851800",
">.     c #551000",
",.     c #58523D",
"                                            ",
"                    . .                     ",
"                  + @ @ +     # # #         ",
"                $ % & & % $   # * #         ",
"              = - ; > > ; - = # , #         ",
"            = ' ) ! ~ ~ ! ) ' = { #         ",
"          ] ^ / ! ( _ _ ( ! / : < #         ",
"        [ } | 1 ~ 2 3 3 2 ~ 1 4 5 6         ",
"      7 8 9 0 a b c d d c b a 0 9 8 7       ",
"    e f g h i j k l m m l k j i h g f e     ",
"  n o p q r s t u v w w v u t s r q p o n   ",
"  # # # # x y z A B C C B A z y x # # # #   ",
"        # s D # # # E F G # # D s #         ",
"        # H # I J K # L # M N # H #         ",
"        # O # P Q R # S # T U # O #         ",
"        # V # W X Y # Z ` # #  .V #         ",
"        # ..# +.@.#.# Z Z Z S S ..#         ",
"        # $.# %.&.%.# Z Z Z Z Z $.#         ",
"        # $.# *.=.*.# Z Z Z Z Z $.#         ",
"        # -.# ;.>.;.# ,.,.,.,.,.-.#         ",
"        # # # # # # # # # # # # # #         ",
"                                            "};
/* XPM */
static char * save_xpm[] = {
"22 22 59 1",
"       c None",
".      c #000000",
"+      c #638163",
"@      c #4D5A4D",
"#      c #A4BDA4",
"$      c #184318",
"%      c #0E280E",
"&      c #4B7E4B",
"*      c #194419",
"=      c #0F290F",
"-      c #508350",
";      c #1B481B",
">      c #102B10",
",      c #568956",
"'      c #1D4C1D",
")      c #112D11",
"!      c #5D905D",
"~      c #205020",
"{      c #133013",
"]      c #639663",
"^      c #235223",
"/      c #153115",
"(      c #6B9E6B",
"_      c #275627",
":      c #173317",
"<      c #73A673",
"[      c #2B5A2B",
"}      c #2E612E",
"|      c #193619",
"1      c #2E5D2E",
"2      c #152A15",
"3      c #326132",
"4      c #838383",
"5      c #9D9D9D",
"6      c #B3B3B3",
"7      c #979797",
"8      c #366536",
"9      c #585858",
"0      c #565656",
"a      c #727272",
"b      c #6A6A6A",
"c      c #386838",
"d      c #848484",
"e      c #7A7A7A",
"f      c #3C6B3C",
"g      c #999999",
"h      c #8E8E8E",
"i      c #366036",
"j      c #3F6E3F",
"k      c #BDBDBD",
"l      c #BABABA",
"m      c #ADADAD",
"n      c #A0A0A0",
"o      c #162616",
"p      c #264126",
"q      c #949494",
"r      c #696969",
"s      c #424242",
"t      c #676767",
"                      ",
"                      ",
"   ................   ",
"  .+@############@+.  ",
"  .$%&&&&&&&&&&&&%$.  ",
"  .*=------------=*.  ",
"  .;>,,,,,,,,,,,,>;.  ",
"  .')!!!!!!!!!!!!)'.  ",
"  .~{]]]]]]]]]]]]{~.  ",
"  .^/((((((((((((/^.  ",
"  ._:<<<<<<<<<<<<:_.  ",
"  .[}||||||||||||}[.  ",
"  .12............21.  ",
"  .3.444566666667.3.  ",
"  .8.9..0aaaaaaab.8.  ",
"  .c.d..eddddddde.c.  ",
"  .f.g..hgggggggh.i.  ",
"  .j.k..lmmmmmmmn.o.  ",
"  .p.qqqrssssssst..   ",
"   ...............    ",
"                      ",
"                      "};

/* XPM */
static char * stop_xpm[] = {
"22 22 77 1",
"       c None",
".      c #000000",
"+      c #703434",
"@      c #E57F7F",
"#      c #E68080",
"$      c #6F2929",
"%      c #DB4343",
"&      c #D31A1A",
"*      c #CE0000",
"=      c #DC4343",
"-      c #D51A1A",
";      c #D00000",
">      c #702929",
",      c #DF4343",
"'      c #D71A1A",
")      c #D30000",
"!      c #6F1B1B",
"~      c #E14343",
"{      c #DA1A1A",
"]      c #D60000",
"^      c #A66666",
"/      c #841717",
"(      c #DA0404",
"_      c #DD1A1A",
":      c #D90000",
"<      c #D56B6B",
"[      c #FFFFFF",
"}      c #E7D5D5",
"|      c #861717",
"1      c #CC0000",
"2      c #DC0000",
"3      c #E64C4C",
"4      c #FADEDE",
"5      c #EAD5D5",
"6      c #722C2C",
"7      c #CF0000",
"8      c #E00000",
"9      c #EB5C5C",
"0      c #FBDFDF",
"a      c #FDF8F8",
"b      c #E40000",
"c      c #DE3535",
"d      c #FEF8F8",
"e      c #E70000",
"f      c #971C1C",
"g      c #EED5D5",
"h      c #FEFAFA",
"i      c #EB0000",
"j      c #AA1C1C",
"k      c #EFD5D5",
"l      c #FDE3E3",
"m      c #F69595",
"n      c #C50000",
"o      c #D50000",
"p      c #EF0000",
"q      c #F77777",
"r      c #FDE4E4",
"s      c #F56565",
"t      c #4D0000",
"u      c #9E0000",
"v      c #D70000",
"w      c #F20000",
"x      c #FAA7A7",
"y      c #F76969",
"z      c #420000",
"A      c #A00000",
"B      c #DA0000",
"C      c #F50000",
"D      c #A20000",
"E      c #DD0000",
"F      c #F80000",
"G      c #430000",
"H      c #A40000",
"I      c #DF0000",
"J      c #FB0000",
"K      c #380000",
"L      c #570000",
"                      ",
"                      ",
"      .........       ",
"     .+@#####@+.      ",
"    .$%&*****&%$.     ",
"   .$=-;;;;;;;-=$.    ",
"  .>,')))))))))',>.   ",
" .!~{]]^/]]]/^]]{~!.  ",
" .(_::<[}|:|}[<::_(.  ",
" .122234[565[432221.  ",
" .7888890[a[0988887.  ",
" .)bbbbbcd[dcbbbbb).  ",
" .]eeeefg[h[gfeeee].  ",
" .:iiijk[lml[kjiii:.  ",
" .noppq[rspsr[qppon.  ",
" .tuvwwxywwwyxwwvut.  ",
"  .zABCCCCCCCCCBAz.   ",
"   .zDEFFFFFFFEDz.    ",
"    .GHIJJJJJIHG.     ",
"     .KLLLLLLLK.      ",
"      .........       ",
"                      "};
/* XPM */
static char * bm_xpm[] = {
"22 22 86 1",
"       c None",
".      c #000000",
"+      c #150B0A",
"@      c #A46C6A",
"#      c #B15652",
"$      c #C68380",
"%      c #840600",
"&      c #8F0600",
"*      c #979797",
"=      c #B3B3B3",
"-      c #880600",
";      c #930600",
">      c #616161",
",      c #696969",
"'      c #595959",
")      c #8D0600",
"!      c #980600",
"~      c #666666",
"{      c #6E6E6E",
"]      c #5E5E5E",
"^      c #920600",
"/      c #9E0700",
"(      c #6B6B6B",
"_      c #747474",
":      c #636363",
"<      c #970600",
"[      c #A30700",
"}      c #727272",
"|      c #7B7B7B",
"1      c #9D0600",
"2      c #AA0700",
"3      c #777777",
"4      c #818181",
"5      c #A40600",
"6      c #B10700",
"7      c #7F7F7F",
"8      c #898989",
"9      c #757575",
"0      c #A90700",
"a      c #B70800",
"b      c #868686",
"c      c #919191",
"d      c #7C7C7C",
"e      c #BF0800",
"f      c #8E8E8E",
"g      c #999999",
"h      c #828282",
"i      c #C60900",
"j      c #959595",
"k      c #A1A1A1",
"l      c #BD0800",
"m      c #CC0900",
"n      c #9C9C9C",
"o      c #A9A9A9",
"p      c #909090",
"q      c #C40800",
"r      c #D40900",
"s      c #A3A3A3",
"t      c #B0B0B0",
"u      c #969696",
"v      c #CA0900",
"w      c #DA0A00",
"x      c #B7B7B7",
"y      c #D00900",
"z      c #E10A00",
"A      c #AFAFAF",
"B      c #BDBDBD",
"C      c #D70900",
"D      c #E80A00",
"E      c #B4B4B4",
"F      c #C3C3C3",
"G      c #A6A6A6",
"H      c #DB0900",
"I      c #E10900",
"J      c #454545",
"K      c #CD0900",
"L      c #A00700",
"M      c #7B1510",
"N      c #A40700",
"O      c #A20700",
"P      c #3E0300",
"Q      c #4A0300",
"R      c #A90800",
"S      c #540400",
"T      c #010000",
"U      c #660400",
"         ......       ",
"        +@#$$$#.      ",
"   .......%&&&%....   ",
"   .*====.-;;;-.=*.   ",
"   .>,',,.)!!!).,>.   ",
"   .~{]{{.^///^.{~.   ",
"   .(_:__.<[[[<._(.   ",
"   .}|,||.12221.|}.   ",
"   .34{44.56665.43.   ",
"   .78988.0aaa0.87.   ",
"   .bcdcc.6eee6.cb.   ",
"   .fghgg.aiiia.gf.   ",
"   .jk8kk.lmmml.kj.   ",
"   .nopoo.qrrrq.on.   ",
"   .stutt.vwwwv.ts.   ",
"   .oxnxx.yzzzy.xo.   ",
"   .ABkBB.CDDDC.BA.   ",
"   .EFGFF.HIIIH.FE.   ",
"   .(JJJJ.KLMNy.J(.   ",
"   .......OP.QR....   ",
"         .S. TU.      ",
"          .   .       "};

/* Small icons here */

/* XPM */
static char * s_left_xpm[] = {
"16 16 33 1",
"       c None",
".      c #000000",
"+      c #1F120A",
"@      c #FF9A59",
"#      c #DE7E42",
"$      c #FF7A26",
"%      c #DE8247",
"&      c #FF8335",
"*      c #FF8232",
"=      c #FF6A0C",
"-      c #FF9D5E",
";      c #FFB382",
">      c #FF9755",
",      c #FF6605",
"'      c #EC5E05",
")      c #1F0F05",
"!      c #DE691E",
"~      c #FF7F2E",
"{      c #180A00",
"]      c #A44103",
"^      c #CB5104",
"/      c #F86305",
"(      c #120700",
"_      c #7E3203",
":      c #C54F04",
"<      c #8C3803",
"[      c #582302",
"}      c #893703",
"|      c #B94A04",
"1      c #833403",
"2      c #C75004",
"3      c #110700",
"4      c #933B03",
"                ",
"      ..        ",
"     +@.        ",
"    +#$.        ",
"   +%&*.... ....",
"  +%&=&-;>. .>>.",
" +%&=,,,,'. .''.",
")!~=,,,,,'. .''.",
"{]^/,,,,,'. .''.",
" (_:/,,,,'. .''.",
"  (_:/:<[}. .}}.",
"   (_:|.... ....",
"    (12.        ",
"     34.   .....",
"      ..    .;. ",
"             .  "};
/* XPM */
static char * s_right_xpm[] = {
"16 16 56 1",
"       c None",
".      c #000000",
"+      c #569A59",
"@      c #0A120A",
"#      c #228126",
"$      c #3F8342",
"%      c #09130A",
"&      c #2E9132",
"*      c #319335",
"=      c #448D47",
"-      c #09140A",
";      c #52AC55",
">      c #80C282",
",      c #5BB15E",
"'      c #319C35",
")      c #07880C",
"!      c #449447",
"~      c #09150A",
"{      c #008905",
"]      c #009405",
"^      c #07970C",
"/      c #31A935",
"(      c #449E47",
"_      c #09160A",
":      c #009705",
"<      c #00A305",
"[      c #07A60C",
"}      c #2AB22E",
"|      c #1B971E",
"1      c #041505",
"2      c #00A605",
"3      c #00B305",
"4      c #00AE05",
"5      c #008E04",
"6      c #007303",
"7      c #001100",
"8      c #00B405",
"9      c #00C205",
"0      c #00BD05",
"a      c #009604",
"b      c #006003",
"c      c #000D00",
"d      c #007003",
"e      c #004802",
"f      c #00A104",
"g      c #00CB05",
"h      c #006803",
"i      c #000E00",
"j      c #00A304",
"k      c #00AD04",
"l      c #006F03",
"m      c #000F00",
"n      c #00B804",
"o      c #007A03",
"p      c #001000",
"q      c #008E03",
"                ",
"        ..      ",
"        .+@     ",
"        .#$%    ",
".... ....&*=-   ",
".;;. .;>,')'!~  ",
".{{. .{]]]]^/(_ ",
".::. .:<<<<<[}|1",
".22. .2333334567",
".88. .899990abc ",
".dd. .de6fgfhi  ",
".... ....jklm   ",
"        .nop    ",
"        .qpb....",
"        ..  .>. ",
"             .  "};
/* XPM */
static char * s_home_xpm[] = {
"16 16 54 1",
"       c None",
".      c #170E0B",
"+      c #000000",
"@      c #170C09",
"#      c #B0705B",
"$      c #B35636",
"%      c #A13F20",
"&      c #661B03",
"*      c #AA3009",
"=      c #190C09",
"-      c #AC3F20",
";      c #721C03",
">      c #8E8875",
",      c #C24F2D",
"'      c #1A0C09",
")      c #B93F20",
"!      c #7C1C03",
"~      c #8F876F",
"{      c #A9A081",
"]      c #A72403",
"^      c #CE4522",
"/      c #1B0C09",
"(      c #C63F20",
"_      c #861C03",
":      c #A9A080",
"<      c #FDEDB3",
"[      c #631503",
"}      c #CC2903",
"|      c #1B0703",
"1      c #1D0C08",
"2      c #D03E20",
"3      c #871902",
"4      c #847C67",
"5      c #FFEFB2",
"6      c #847C68",
"7      c #851902",
"8      c #CF3A1B",
"9      c #A81E02",
"0      c #721402",
"a      c #9A9070",
"b      c #8B8163",
"c      c #9C926D",
"d      c #FDEDB1",
"e      c #EADBA4",
"f      c #696249",
"g      c #ECDDA5",
"h      c #C25834",
"i      c #FFFFFF",
"j      c #BE2D00",
"k      c #BF0000",
"l      c #898060",
"m      c #58523D",
"n      c #D90000",
"o      c #BB0000",
"                ",
"       ..  +++  ",
"      @##@ +$+  ",
"     @%&&%@+*+  ",
"    =-;>>;-=,+  ",
"   ')!~{{~!]^+  ",
"  /(_~:<<:~[}|  ",
" 1234:<55<:6781 ",
"+90a{<5555<:b09+",
"+++cd555555dc+++",
"  +e5f+f5f+fe+  ",
"  +g5+h+5+i+g+  ",
"  +g5+j+5f+fg+  ",
"  +g5+k+5555g+  ",
"  +lm+n+mmmml+  ",
"  ++++o+++++++  "};
/* XPM */
static char * s_reload_xpm[] = {
"16 16 74 1",
"       c None",
".      c #000000",
"+      c #282828",
"@      c #666666",
"#      c #9B9B9B",
"$      c #BFBFBF",
"%      c #4F4F4F",
"&      c #A5A5A5",
"*      c #BDBDBD",
"=      c #B1B1B1",
"-      c #A9A9A9",
";      c #4C4C4C",
">      c #B5B5B5",
",      c #B4B4B4",
"'      c #7F907F",
")      c #436B43",
"!      c #144F14",
"~      c #004800",
"{      c #262626",
"]      c #9D9D9D",
"^      c #B8B8B8",
"/      c #839583",
"(      c #577A57",
"_      c #7E917E",
":      c #A7AAA7",
"<      c #426D42",
"[      c #004600",
"}      c #5D5D5D",
"|      c #BEBEBE",
"1      c #B7B7B7",
"2      c #728C72",
"3      c #B0B2B0",
"4      c #8E8E8E",
"5      c #C2C2C2",
"6      c #BCBCBC",
"7      c #8EA18E",
"8      c #004B00",
"9      c #AFAFAF",
"0      c #C6C6C6",
"a      c #C4C4C4",
"b      c #CCCCCC",
"c      c #7A5200",
"d      c #B8AE9A",
"e      c #868686",
"f      c #D4D4D4",
"g      c #7F5500",
"h      c #D2D1CE",
"i      c #B4A585",
"j      c #575757",
"k      c #845800",
"l      c #A58A53",
"m      c #C3B79F",
"n      c #D9D7D3",
"o      c #B09A6E",
"p      c #C6BBA5",
"q      c #222222",
"r      c #878787",
"s      c #865A00",
"t      c #CCC1AA",
"u      c #AC915B",
"v      c #936C1C",
"w      c #E0E0E0",
"x      c #3A3A3A",
"y      c #8C8C8C",
"z      c #C3C3C3",
"A      c #E2E2E2",
"B      c #EAEAEA",
"C      c #323232",
"D      c #646464",
"E      c #9E9E9E",
"F      c #DCDCDC",
"G      c #191919",
"H      c #2F2F2F",
"I      c #404040",
"     ......     ",
"   .+@#$$#@+.   ",
"  .%&*=--=*&%.  ",
" .;>,')!!)'~>;. ",
" {]^/(_:_<[[^]{ ",
".}|123>>>~~~1|}.",
".45676668888654.",
".90aaaaaaaaaa09.",
".-abccccbbbdba-.",
".e$fgggfffhif$e.",
".j>fkklmnmopf>j.",
" qr5stuvvutw5rq ",
" .xyzABBBBAzyx. ",
"  .CDE0FF0EDC.  ",
"   .GHI%%IHG.   ",
"     ......     "};
/* XPM */
static char * s_save_xpm[] = {
"16 16 51 1",
"       c None",
".      c #000000",
"+      c #638163",
"@      c #8CA28C",
"#      c #A4BDA4",
"$      c #184318",
"%      c #1A481A",
"&      c #4C7F4C",
"*      c #1A461A",
"=      c #1C4C1C",
"-      c #528552",
";      c #1B4A1B",
">      c #1D501D",
",      c #598C59",
"'      c #1F4E1F",
")      c #215421",
"!      c #619461",
"~      c #225122",
"{      c #255825",
"]      c #699C69",
"^      c #275627",
"/      c #2A5D2A",
"(      c #72A572",
"_      c #2B5A2B",
":      c #2E612E",
"<      c #2F5E2F",
"[      c #152A15",
"}      c #336233",
"|      c #838383",
"1      c #9D9D9D",
"2      c #B3B3B3",
"3      c #979797",
"4      c #376637",
"5      c #5A5A5A",
"6      c #585858",
"7      c #757575",
"8      c #6C6C6C",
"9      c #3A6A3A",
"0      c #8C8C8C",
"a      c #828282",
"b      c #345E34",
"c      c #3E6D3E",
"d      c #B6B6B6",
"e      c #A5A5A5",
"f      c #999999",
"g      c #162616",
"h      c #264126",
"i      c #919191",
"j      c #676767",
"k      c #414141",
"l      c #656565",
"................",
".+@##########@+.",
".$%&&&&&&&&&&%$.",
".*=----------=*.",
".;>,,,,,,,,,,>;.",
".')!!!!!!!!!!)'.",
".~{]]]]]]]]]]{~.",
".^/((((((((((/^.",
"._::::::::::::_.",
".<[..........[<.",
".}.|||1222223.}.",
".4.5..6777778.4.",
".9.0..a00000a.b.",
".c.d..2eeeeef.g.",
".h.iiijkkkkkl.. ",
" .............  "};
/* XPM */
static char * s_stop_xpm[] = {
"16 16 65 1",
"       c None",
".      c #000000",
"+      c #5A3435",
"@      c #BF7F80",
"#      c #BF8081",
"$      c #562929",
"%      c #A54344",
"&      c #911A1C",
"*      c #850002",
"=      c #582929",
"-      c #AA4344",
";      c #981A1C",
">      c #8C0002",
",      c #551B1C",
"'      c #B04345",
")      c #9F1A1D",
"!      c #940003",
"~      c #926667",
"{      c #661C1E",
"]      c #A00407",
"^      c #A81A1D",
"/      c #9E0003",
"(      c #B86B6D",
"_      c #FFFFFF",
":      c #E2D5D5",
"<      c #581C1D",
"[      c #9C0003",
"}      c #A90003",
"|      c #C24C4E",
"1      c #F4DDDE",
"2      c #E9DADA",
"3      c #A70003",
"4      c #B40003",
"5      c #C4383A",
"6      c #F5DEDE",
"7      c #B10004",
"8      c #BF0004",
"9      c #9A1C1F",
"0      c #F0D9D9",
"a      c #BB0004",
"b      c #CA0004",
"c      c #971C1F",
"d      c #ECD5D5",
"e      c #FAE6E6",
"f      c #AF0003",
"g      c #BE0004",
"h      c #D50004",
"i      c #E87779",
"j      c #FBE5E5",
"k      c #EA7E80",
"l      c #470001",
"m      c #930003",
"n      c #C70004",
"o      c #E00004",
"p      c #F5A7A9",
"q      c #EC6568",
"r      c #3F0001",
"s      c #990003",
"t      c #D00004",
"u      c #EA0004",
"v      c #410001",
"w      c #D70004",
"x      c #F20005",
"y      c #370001",
"z      c #560002",
"    ........    ",
"   .+@####@+.   ",
"  .$%&****&%$.  ",
" .=-;>>>>>>;-=. ",
".,')!~{!!{~!)',.",
".]^/(_:<<:_(/^].",
".[}}|1_22_1|}}[.",
".344456__654443.",
".788890__098887.",
".abbcd_ee_dcbba.",
".fghi_jkkj_ihgf.",
".lmnopqooqponml.",
" .rstuuuuuutsr. ",
"  .v/wxxxxw/v.  ",
"   .yzzzzzzy.   ",
"    ........    "};

/* XPM */
static char * s_bm_xpm[] = {
"16 16 63 1",
"       c None",
".      c #000000",
"+      c #B15652",
"@      c #C68380",
"#      c #979797",
"$      c #B3B3B3",
"%      c #999999",
"&      c #860600",
"*      c #910600",
"=      c #646464",
"-      c #6C6C6C",
";      c #5C5C5C",
">      c #8B0600",
",      c #960600",
"'      c #6A6A6A",
")      c #737373",
"!      c #626262",
"~      c #920600",
"{      c #9E0700",
"]      c #747474",
"^      c #7D7D7D",
"/      c #990600",
"(      c #A50700",
"_      c #7E7E7E",
":      c #888888",
"<      c #A10600",
"[      c #AE0700",
"}      c #939393",
"|      c #A90700",
"1      c #B70800",
"2      c #9F9F9F",
"3      c #B30700",
"4      c #C10800",
"5      c #9D9D9D",
"6      c #AAAAAA",
"7      c #919191",
"8      c #BB0800",
"9      c #CA0900",
"0      c #A8A8A8",
"a      c #B5B5B5",
"b      c #9A9A9A",
"c      c #C40800",
"d      c #D40900",
"e      c #B0B0B0",
"f      c #BEBEBE",
"g      c #A2A2A2",
"h      c #CD0900",
"i      c #DD0A00",
"j      c #444444",
"k      c #3A3A3A",
"l      c #D50900",
"m      c #DA0900",
"n      c #C80800",
"o      c #9C0700",
"p      c #680500",
"q      c #A00700",
"r      c #CB0900",
"s      c #3D0300",
"t      c #490300",
"u      c #A70800",
"v      c #540400",
"w      c #010000",
"x      c #660400",
"      .......   ",
" ......+@@@+... ",
" .#$%$.&***&.#. ",
" .=-;-.>,,,>.=. ",
" .')!).~{{{~.'. ",
" .]^'^./(((/.]. ",
" ._:]:.<[[[<._. ",
" .:}^}.|111|.:. ",
" .}2:2.34443.}. ",
" .5676.89998.5. ",
" .0aba.cdddc.0. ",
" .efgf.hiiih.e. ",
" .'jkj.lmmml.'. ",
" ......nopqr... ",
"      .qs.tu.   ",
"      .v. wx.   "};

/* XPM */
static char * s_new_xpm[] = {
"11 11 35 1",
"       c None",
".      c #000000",
"+      c #482929",
"@      c #0F0808",
"#      c #390606",
"$      c #A04242",
"%      c #925050",
"&      c #0F0707",
"*      c #0B0000",
"=      c #500000",
"-      c #8C0101",
";      c #944444",
">      c #221515",
",      c #0A0000",
"'      c #560000",
")      c #A10909",
"!      c #AE3636",
"~      c #230000",
"{      c #AE0000",
"]      c #B40000",
"^      c #180808",
"/      c #B43535",
"(      c #C40000",
"_      c #960000",
":      c #190606",
"<      c #C02B2B",
"[      c #E00000",
"}      c #6B0000",
"|      c #120000",
"1      c #590000",
"2      c #A30000",
"3      c #680000",
"4      c #0F0000",
"5      c #350000",
"6      c #100000",
"  .     .  ",
" .+@   @+. ",
".#$%& &%$#.",
" *=-;>;-=* ",
"  ,')!)',  ",
"   ~{]{~   ",
"  ^/(_(/^  ",
" :<[}|}[<: ",
".1234 4321.",
" .56   65. ",
"  .     .  "};

/* XPM */
static char * search_xpm[] = {
"14 16 11 1",
"       c None",
".      c #000000",
"+      c #EEEEEE",
"[      c #EE0000",
"}      c #CC0000",
"|      c #BB0000",
"1      c #AA0000",
"2      c #880000",
"3      c #660000",
"4      c #440000",
"5      c #330000",
"   .....      ",
"  .     .     ",
" .  +    .    ",
".  +++    .   ",
".   +     .   ",
".         .   ",
".         .   ",
" .       .    ",
"  .     .     ",
"   ...545     ",
"       424    ",
"       313    ",
"        2|2   ",
"        2}2   ",
"         2}2  ",
"         11   "};

/* XPM */
static char * full_screen_on_xpm[] = {
"13 15 2 1",
"       c None",
".      c #000000",
"             ",
".............",
".     .     .",
".    ...    .",
".   .....   .",
".  .......  .",
".     .     .",
".     .     .",
".     .     .",
".  .......  .",
".   .....   .",
".    ...    .",
".     .     .",
".............",
"             "};

/* XPM */
static char * full_screen_off_xpm[] = {
"13 15 2 1",
"       c None",
".      c #000000",
"             ",
".............",
". . . . . . .",
".. . . . . ..",
".............",
".           .",
".           .",
".           .",
".           .",
".           .",
".           .",
".............",
". . . . . . .",
".............",
"             "};

/* XPM */
static char * mini_bug_xpm[] = {
"15 16 6 1",
"       c None",
".      c black",
"X      c #c0c0c0",
"o      c #808080",
"b      c #303030",
"#      c white"
"               ",
"    .   .      ",
"     ...       ",
"   X.....X     ",
"   o.#...o     ",
"  o.#...o.o    ",
"  ..#oXo...    ",
" .....X.....   ",
"  ....X....    ",
" .o...X...o.   ",
"   ...X...     ",
"  .X..X..X.    ",
"     .o.       ",
"          .bbb.",
"           .o. ",
"            .  "};

/* XPM */
static char * mini_ok_xpm[] = {
"15 15 5 1",
"@ c #000000",
"a c #808080",
"b c #303030",
"c c #606060",
"  s none m none c none",
"               ",
"               ",
"            @  ",
"           @@  ",
"          @@@  ",
"         @@@   ",
"   @@   @@@    ",
"  @@@  @@@     ",
"  @@@ @@@      ",
"  @@@@@@       ",
"  @@@@@        ",
"  @@@@         ",
"   @@     @bbb@",
"           @a@ ",
"            @  "
};

#endif /* __PIXMAPS_H__ */
