#!/bin/sh
set -ev

test $DARCS || DARCS=$PWD/../darcs

rm -rf temp1
mkdir temp1
cd temp1
$DARCS init
mkdir foo
echo hello world > foo/bar
echo hello world > foo/baz
mkdir foo/dir
$DARCS add foo foo/bar foo/dir foo/baz
$DARCS record -a -m add -A x
rm -rf foo
test -e _darcs/pristine/foo/baz
test -d _darcs/pristine/foo/dir
test -e _darcs/pristine/foo/bar
test -d _darcs/pristine/foo
$DARCS record -a -m del -A x
test ! -e _darcs/pristine/foo/baz
test ! -d _darcs/pristine/foo/dir
test ! -e _darcs/pristine/foo/bar
test ! -d _darcs/pristine/foo
cd ..
rm -rf temp1

# it should be ok to apply a rmdir patch on a non-empty directory in working
mkdir temp1
cd temp1
$DARCS init
mkdir foo
echo hello world > foo/bar
$DARCS add foo foo/bar
$DARCS record -a -m add -A x
cd ..
# get temp2 and add some extra stuff to the directory
rm -rf temp2
$DARCS get temp1 temp2
cd temp2
echo hello world > foo/baz
cd ..
# create the darcs rmdir patch
cd temp1
rm -rf foo
$DARCS record -a -m del -A x
cd ..
# pull the rmdir patch into temp2
cd temp2
test -e foo/baz
test -e foo/bar
test -d foo
test -e _darcs/pristine/foo/bar
test -d _darcs/pristine/foo
$DARCS pull -a
# the directory and temp2-specific file should still be there
test -e foo
test -e foo/baz
# but the pristine stuff should be gone
test ! -e _darcs/pristine/foo/bar
test ! -d _darcs/pristine/foo
cd ..
#
rm -rf temp1 temp2
