#!/bin/sh

# This test script, originally written by David Roundy and Ian Lynagh is in
# the public domain.

set -ev

test $DARCS || DARCS=$PWD/../darcs
ACTUAL_DARCS=`which $DARCS`
DARCSPATH=`dirname $ACTUAL_DARCS`
export PATH="$DARCSPATH:$PATH"

rm -rf temp1

mkdir temp1
cd temp1

$DARCS initialize --no-pristine-tree
echo ALL --author Testing Person >> _darcs/prefs/defaults
echo ALL --ignore-times

echo foo > bar
$DARCS add bar
$DARCS record -a -m baz bar

date > bar
$DARCS record --no-test -a -m 'patch 2'

$DARCS setpref test 'echo hello world'
$DARCS record -a -m 'setpref'

date >> bar
$DARCS record -a -m 'record with test'

cd ..

rm -rf temp*
