//  Written by Aecio F. Neto (afn@harvest.com.br) - Harvest Consultoria (www.harvest.com.br)
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "ClamAV.hpp"
#include "OptionContainer.hpp"
#include <syslog.h>
#include <time.h>

extern OptionContainer o;
extern struct cl_limits limits;
extern struct cl_stat dbstat;

ClamAV::ClamAV()
:virname(0),root(NULL) {}

int ClamAV::scanFile(char* filename) {

    int isinfected = 0;
    
    isinfected = cl_scanfile(filename, &virname, NULL, root, &limits, CL_ARCHIVE| CL_MAIL | CL_OLE2 | CL_SCAN_PE | CL_SCAN_BLOCKBROKEN | CL_SCAN_HTML);
    return isinfected;
}

int ClamAV::loadDB() {

    int ret = 0;
    unsigned int no = 0;
    const char* dbdir = cl_retdbdir();
    
#ifdef DGDEBUG
system("date");
std::cout << "Start ClamAV DB load." << std::endl;
#endif

    if (root != NULL) {
	cl_free(root);
	root = NULL;
    }
    if ((ret = cl_loaddbdir(dbdir, &root, &no))) {
	syslog(LOG_ERR, "Error loading ClamAV DB: %s", cl_perror(ret));
	return ret;
    }
    else {
	syslog(LOG_INFO, "ClamAV DB loaded: %i signatures known", no);
	cl_build(root);
	cl_statfree(&dbstat);
	cl_statinidir(dbdir, &dbstat);
    }
    
#ifdef DGDEBUG
std::cout << "End of ClamAV DB load." << std::endl;
system("date");
#endif
    
    limits.maxratio = o.cl_max_ratio;
    limits.maxfiles = o.cl_max_files;
    limits.maxfilesize = o.cl_max_file_size;
    limits.maxreclevel = o.cl_max_rec_level;

    return 0;
}

int ClamAV::checkDB() {

    int ret = 0;
    
    if (cl_statchkdir(&dbstat) == 1) {
    
#ifdef DGDEBUG
std::cout << "ClamAV virus database has changed. Reloading..." << std::endl;
#endif

	ret = loadDB();
    }
    
    return ret;
}
