/*
 * Copyright (c) 2003-2011
 * Distributed Systems Software.  All rights reserved.
 * See the file LICENSE for redistribution information.
 *
 * $Id: vfs_conf.h 2528 2011-09-23 21:54:05Z brachman $
 */

/*****************************************************************************
 * COPYRIGHT AND PERMISSION NOTICE
 * 
 * Copyright (c) 2001-2003 The Queen in Right of Canada
 * 
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation 
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, provided that the above copyright notice(s) and this
 * permission notice appear in all copies of the Software and that both the
 * above copyright notice(s) and this permission notice appear in supporting
 * documentation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE 
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 * 
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in this Software without prior written authorization of the
 * copyright holder.
 ***************************************************************************/

#ifndef _VFS_CONF_H_
#define _VFS_CONF_H_

/* XXX This file could be automagically created by a configuration script... */

/* Declare each supported store method here */
#ifdef __cplusplus
extern "C" {
#endif

extern Vfs_switch *vfs_db_init(char *store_name);
extern Vfs_switch *vfs_file_init(char *store_name);
extern Vfs_switch *vfs_http_init(char *store_name);
extern Vfs_switch *vfs_ndbm_init(char *store_name);
extern Vfs_switch *vfs_pseudo_init(char *store_name);
#ifdef ENABLE_SDBM
extern Vfs_switch *vfs_sdbm_init(char *store_name);
#endif
extern Vfs_switch *vfs_sqlite_init(char *store_name);
extern Vfs_switch *vfs_vfsc_init(char *store_name);

extern void vfs_file_term(char *store_name);

#ifdef __cplusplus
}
#endif

/* Define init and close operations for each supported store method. */
static MAYBE_UNUSED Vfs_def vfs_defs[] = {
	{ "db",     vfs_db_init,     NULL },
	{ "file",   vfs_file_init,   vfs_file_term },
	{ "fs",     vfs_file_init,   vfs_file_term },
	{ "http",   vfs_http_init,   NULL },
	{ "https",  vfs_http_init,   NULL },
	{ "kwv",    vfs_pseudo_init, NULL },
	{ "ndbm",   vfs_ndbm_init,   NULL },
#ifdef ENABLE_SDBM
	{ "sdbm",   vfs_sdbm_init,   NULL },
#endif
	{ "sqlite", vfs_sqlite_init, NULL },
	{ "vfs",    vfs_vfsc_init,   NULL },
	{ NULL,     NULL,            NULL }
};

#endif
