// apt_config_widgets.h     -*-c++-*-
//
//  Copyright 2000 Daniel Burrows
//
//  Our friends the "apt config widgets".  These little fellas know how to
// get their state from the libapt configuration and how to set the
// configuration on demand.  Aren't they cute?

#ifndef APT_CONFIG_WIDGETS_H
#define APT_CONFIG_WIDGETS_H

#include <vscreen/vs_togglebutton.h>
#include <vscreen/vs_editline.h>

#include <sigc++/object.h>

// This basically just provides a generic interface to commit changes to apt
// options.  Not a descendant of Object because the classes below get Object
// via vscreen_widget, and things get confused if Object is included twice.
// (the compiler gets unhappy)
class apt_config_widget
{
public:
  virtual ~apt_config_widget() {}

  virtual void commit()=0;
};

class apt_bool_widget:public apt_config_widget, public vs_checkbutton
{
  std::string item; // the config-item we're associated with.

  bool my_default;
public:
  apt_bool_widget(std::string _label, std::string _item, bool _default);

  void commit();
};

class apt_string_widget:public apt_config_widget, public vs_editline
{
  std::string item; // the config-item we're associated with.

  std::string my_default;
public:
  apt_string_widget(std::string _item, std::string _default);

  void commit();
};

#endif
