/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dbqryobj.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:47:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SBA_DBQRYOBJ_HXX
#define _SBA_DBQRYOBJ_HXX

#ifndef _SBA_DBDATDEF_HXX
#include "dbdatdef.hxx"
#endif

#ifndef _SBA_SBADBIT_HXX
#include "sbadbit.hxx"
#endif
class SfxItemPool; 
class SfxItemSet; 

namespace binfilter {

class SbaDBDefList;

//==================================================================
// SbaQueryObj
//==================================================================
class SbaQueryObj : public SbaDataObj
{
	friend class SbaObjectExt;

	SdbSqlParseNode* pParseTree;
	SbaParseIterator aParseIterator;
	SbaDBDataDef*	 pUpdTable;

	BOOL	m_bSettingSpecialConditions;
		// TRUE innerhalb von SetFilter, SetOrder, ...
	String	m_strOriginalSqlStatement;
		// siehe Reset
	String	m_strOriginalWherePart;
	String	m_strOriginalOrderPart;

public:
	TYPEINFO();
	SbaQueryObj(SbaDBDataDef* pDef,
				const String& rSQLStatement,
				BOOL bNative,
				BOOL bShow = TRUE);			// Sollen Fehler angezeigt werden

	virtual BOOL Prepare();
	virtual BOOL IsPrepared() const;
	virtual BOOL IsUpdateAllowed() const;
	virtual BOOL Open();
	virtual void Close();

	inline SbaParseIterator& Iterator() const;
	SdbSqlParseNode*const ParseTree() const {return pParseTree;}

	SbaPredicateItem* CreatePredicateItem( const String& rFieldName, const ODbVariantRef& xVar );
	void SetFilter(const String& rFilter);
	void SetOrder(const String& rOrder);
	void SetAutoFilter(const String& rFieldName, const ODbVariantRef& xVar, BOOL bAppend = TRUE);
	void SetAutoOrder(const String& rFieldName, const ODbVariantRef& xVar, BOOL bDesc);
	void Reset();
		// die Abfrage kann durch SetFilter u.ae. veraendert werden, Reset schaltet dann wieder auf das originale Statement
		// (m_strOriginalSqlStatement) - das heisst das Statement, dass im Constructor oder im letzten ReInit uebergeben wurde -
		// zurueck
	String OriginalStatement() const { return m_strOriginalSqlStatement; }

	static String GetQueryString(SdbDatabase eType, const ODbVariantRef& xVar);

protected:
	virtual	~SbaQueryObj();

public:
	virtual BOOL Refresh();
};

SV_DECL_IMPL_REF(SbaQueryObj);

//==================================================================
// SbaQueryDef
//==================================================================
class SbaQueryDef : public SbaDBDataDef
{
	friend class SbaObject;
	friend class SbaQueryDocSh;			// darf noch UI-Info zur Abfrage ablegen
	friend class SbaDatabase;
	friend class SbaQueryObj;

	String			aStatement;
	SdbQuery*		pQuery;
	BOOL			bNative : 1;

public:
	TYPEINFO();

	virtual BOOL	Update(const String& aStmt, BOOL bNative);
	const String&	Statement() const {return aStatement;}
	BOOL			IsNative() const {return bNative;}
	virtual BOOL	SetLock(BOOL _bLocked);

protected:
	SbaQueryDef(SbaDatabase* pDB,
				const String& rName,
				BOOL bNew = TRUE,
				BOOL bShow = TRUE);

	virtual	~SbaQueryDef();
	// Temp Objekte werden sofort geloescht, da sie in keiner Liste gehalten
	// werden
	virtual void QueryDelete();

	virtual BOOL Open();
	virtual BOOL DropImpl();
	virtual BOOL RenameImpl(const String& rNewName);
	virtual BOOL DoRefresh();
	virtual SbaDataObj* CreateDataObjImpl();

	// Update mit UI Info fuer Abfrage
	BOOL GetUIInfo(SvStream& rTarget);
	BOOL Update(const String& rStmt, BOOL bNative, SvStream* pStream);

private:
	BOOL UpdateImpl(const String& aStmt, BOOL bNative);
	BOOL Init();
	void DeInit();
	BOOL DescribeCols(const String& aStmt, BOOL bNative);
	BOOL SetColumns(const SdbColumnsRef& rCols, const String& aStmt, BOOL _bNative);
	void FillCols(const SdbColumnsRef& rCols,const SbaDBDefList& rTableList,
				  const SdbTableRangeMap& rTableMap);
	void ReadTables(SbaDBDefList& rTableList,const SdbTableRangeMap& rTableItemList);
};

SV_DECL_IMPL_REF(SbaQueryDef);


//inline Implementation
inline SbaParseIterator& SbaQueryObj::Iterator() const
{
	return ((SbaQueryObj *) this)->aParseIterator;				// const cast !!!
}

} //namespace binfilter
#endif


