/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: wizmm.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 07:27:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _WIZMM_HXX
#define _WIZMM_HXX

#include "wizmmdlg.hxx"
#include "wizgo.hxx"
#ifndef _WIZCFG_HXX
#include <wizcfg.hxx>
#endif
namespace binfilter {

class MemoDialog: public WizardMemoDialog, private WizardGo
{
	WizardMemoPage aPage1;
	SwMemoWizardCfg   aConfig;
public:
	MemoDialog( Window* pParent );

	virtual void Fill(USHORT StepNum, MultiOne& WinArr);
	virtual BOOL Possible(USHORT StepNum);
	virtual void Enter(USHORT StepNum);
	virtual void Leave(USHORT StepNum);

	void GetFromDef();  // Harte Defaults setzen
	void GetFromIni();  // Defaults vom Inifile holen

	virtual void WriteToIni();
	virtual BOOL MakeDoc();

	void InitElemUI();  // Datelistbox fuellen
	void LogoToUI();

	void ArrangeObjects();
	void CheckTitlOnOff();
	void CheckKopzFusz();
	void CheckElements();
	void FillDocInfoList();
	BOOL   GetDocInfOn(USHORT nNum);
	String GetDocInfStr(USHORT nNum);
	BOOL   GetDocInfStrOk(USHORT nNum);
	void SetElemDisable();

	void SetEventHandler();
	DECL_LINK( StyleClickHdl, RadioButton * );
	DECL_LINK( TitlModifyHdl, Edit * );
	DECL_LINK( TitlRBtnHdl, RadioButton * );
	DECL_LINK( TitlPBtnHdl, PushButton * );
	DECL_LINK( DatmCheckHdl, CheckBox * );
	DECL_LINK( ElemCheckHdl, CheckBox * );
	DECL_LINK( ElemModifyHdl, Edit * );
	DECL_LINK( KopzCheckHdl, CheckBox * );
	DECL_LINK( FuszCheckHdl, CheckBox * );


private:
	void InsTitl();
	void InsElem();
	void InsFusz();
	void InsKopz();
	void DelFusz();
	void DelFuszTr();
	void DelKopz();
	void DelKopzTr();
	void CreateMacro();
	void SaveMacro();
	void InsDocInfBookmark(USHORT nElemNum);
};

} //namespace binfilter
#endif  //_WIZMM_HXX


