/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: wizdoku.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 07:24:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _WIZDOKU_HXX
#define _WIZDOKU_HXX

#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif

#include "wizmulti.hxx"
namespace binfilter {

class WizardDokuDlg
{
	SwWizardDialog* pWizDlg;
public:
	FixedText*	pD_Text_SavOpt;
	FixedText*	pD_Text_InfTit;
	ListBox*	pD_List_InfTit;
	FixedText*	pD_Text_InfTem;
	ListBox*	pD_List_InfTem;
    FixedLine*   pD_FL_DokInf;
	CheckBox*	pD_CBox_AutoFN;
	FixedText*	pD_Text_AutoFN;
	Edit*		pD_Edit_AutoFN;

	PushButton*	pD_PBtn_Folder;
	FixedText*	pD_Text_Folder;

    FixedLine*   pD_FL_DokSav;
	FixedText*	pD_Text_VorNam;
	Edit*		pD_Edit_VorNam;
	FixedText*	pD_Text_VorInf;
	Edit*		pD_Edit_VorInf;
    FixedLine*   pD_FL_VorSav;
	PushButton*	pOkayBtn;
	String		aMerk1;
	String		aMerk2;
	USHORT		nDBFieldAnz;
public:
	WizardDokuDlg(SwWizardDialog* pDlgWin);
	~WizardDokuDlg();

	void Fill(MultiOne& WinArr);
	void SetPtr(PushButton* pBtn);
	void SetEventHandler();
	void InitUI();
	void ToUI();
	void SetDisable();
	void SetDocInfDisable();
	void SetAutoFNDisable();
	DECL_LINK( ClckHdl, CheckBox * );
	DECL_LINK( FldClckHdl, PushButton * );
	DECL_LINK( ModifyHdl, Edit * );
	DECL_LINK( OkClckHdl, PushButton * );
	void SetOkayDisable();

	void SetDBFieldAnz(USHORT nAnz);
	void SetDBFieldNam(USHORT nNum, const String& aNam);
	void SetTxFieldAnz(USHORT nAnz);
	void SetTxFieldNam(USHORT nNum, const String& aNam);
	USHORT GetDBFieldAnz() { return nDBFieldAnz; }
	USHORT GetTxFieldAnz() { return USHORT(pD_List_InfTit->GetEntryCount()-nDBFieldAnz-1); }
	USHORT GetDBFieldOfs() { return 1; }
	USHORT GetTxFieldOfs() { return GetDBFieldOfs()+GetDBFieldAnz(); }

	void MerkDocInfListSel();
	void RestDocInfListSel();

	BOOL IsDocInfoDBFeld(USHORT nNum)
		{ return nNum >= 1 && nNum < 1 + nDBFieldAnz; }
	BOOL IsDocInfoTxFeld( USHORT nNum )
		{ return nNum >= 1 + nDBFieldAnz; }

	BOOL IsDocInfoDBFeldSelected(USHORT nTyp); // 0=Titel 1=Thema
private:
	void SetDocInfListEntryOne(USHORT nNum, const String& aNam, ListBox& rLst);
	void SetDocInfListEntry(USHORT nNum, const String& aNam);
};


} //namespace binfilter
#endif  //_WIZDOKU_HXX

