/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_wizmarg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 07:20:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#include "swtypes.hxx"
#include "uitool.hxx"
#include "wizard.hrc"
#include "wizmarg.hxx"
namespace binfilter {



WizardMargDlg::WizardMargDlg(SwWizardDialog* pDlgWin)
{
	pM_Text_VonLks=new FixedText  (pDlgWin,SW_RES(DLG_Mrg_Text_VonLks));
	pM_MFld_VonLks=new MetricField(pDlgWin,SW_RES(DLG_Mrg_MFld_VonLks));
	pM_Text_VonRts=new FixedText  (pDlgWin,SW_RES(DLG_Mrg_Text_VonRts));
	pM_MFld_VonRts=new MetricField(pDlgWin,SW_RES(DLG_Mrg_MFld_VonRts));
    pM_FL_PgMarg=new FixedLine   (pDlgWin,SW_RES(DLG_Mrg_FL_PgMarg));
	pWizDlg=pDlgWin;
	pPage1=NULL;
	pPage2=NULL;

	FieldUnit eMetric = ::GetDfltMetric(FALSE);
	pM_MFld_VonLks->SetUnit(eMetric);
	pM_MFld_VonRts->SetUnit(eMetric);

	SetEventHandler();
}

WizardMargDlg::~WizardMargDlg()
{
	delete pM_Text_VonLks;
	delete pM_MFld_VonLks;
	delete pM_Text_VonRts;
	delete pM_MFld_VonRts;
    delete pM_FL_PgMarg;
}

void WizardMargDlg::Fill(MultiOne& WinArr)
{
	WinArr.AddWin(pM_Text_VonLks);
	WinArr.AddWin(pM_MFld_VonLks);
	WinArr.AddWin(pM_Text_VonRts);
	WinArr.AddWin(pM_MFld_VonRts);
    WinArr.AddWin(pM_FL_PgMarg,FALSE,TRUE);
}

void WizardMargDlg::SetPtr(WizardPage* pPg1, WizardPage* pPg2)
{
	pPage1=pPg1;
	pPage2=pPg2;
	ToUI();
}

void WizardMargDlg::ToUI()
{
	if (pPage1==NULL) return;
	pM_MFld_VonLks->SetValue(pPage1->RandL, FUNIT_CM);
	pM_MFld_VonRts->SetValue(pPage1->RandR, FUNIT_CM);
}

IMPL_LINK( WizardMargDlg, MFldHdl, MetricField *, pEdt )
{
	USHORT nVal=USHORT(pEdt->GetValue(FUNIT_CM));
	if (pEdt==pM_MFld_VonLks) {
		if (pPage1!=NULL) pPage1->SetRandL(nVal,&pWizDlg->aPrevWin);
		if (pPage2!=NULL) pPage2->SetRandL(nVal,&pWizDlg->aPrevWin);
	}
	if (pEdt==pM_MFld_VonRts) {
		if (pPage1!=NULL) pPage1->SetRandR(nVal,&pWizDlg->aPrevWin);
		if (pPage2!=NULL) pPage2->SetRandR(nVal,&pWizDlg->aPrevWin);
	}
	return 0;
}

void WizardMargDlg::SetEventHandler()
{
	pM_MFld_VonLks->SetModifyHdl(LINK(this,WizardMargDlg,MFldHdl));
	pM_MFld_VonRts->SetModifyHdl(LINK(this,WizardMargDlg,MFldHdl));
}


}
