/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_uinums.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 04:21:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop


#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

// auto strip #ifndef SVTOOLS_URIHELPER_HXX
// auto strip #include <svtools/urihelper.hxx>
// auto strip #endif
// auto strip #ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
// auto strip #include <svtools/pathoptions.hxx>
// auto strip #endif
// auto strip #ifndef _STREAM_HXX //autogen
// auto strip #include <tools/stream.hxx>
// auto strip #endif
#ifndef _SFX_INIMGR_HXX
#endif
// auto strip #ifndef _SFXDOCFILE_HXX
// auto strip #include <bf_sfx2/docfile.hxx>
// auto strip #endif
// auto strip #ifndef _SFXITEMITER_HXX //autogen
// auto strip #include <svtools/itemiter.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_BRSHITEM_HXX //autogen
// auto strip #include <bf_svx/brshitem.hxx>
// auto strip #endif


// auto strip #ifndef _TOOLS_RESID_HXX
// auto strip #include <tools/resid.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

// auto strip #ifndef _FMTORNT_HXX //autogen
// auto strip #include <fmtornt.hxx>
// auto strip #endif
// auto strip #ifndef _SWTYPES_HXX
// auto strip #include <swtypes.hxx>		// Leerstring
// auto strip #endif
// auto strip #ifndef _WRTSH_HXX
// auto strip #include <wrtsh.hxx>
// auto strip #endif
// auto strip #ifndef _UINUMS_HXX
// auto strip #include <uinums.hxx>
// auto strip #endif
// auto strip #ifndef _POOLFMT_HXX
// auto strip #include <poolfmt.hxx>
// auto strip #endif
// auto strip #ifndef _CHARFMT_HXX
// auto strip #include <charfmt.hxx>
// auto strip #endif
// auto strip #ifndef _FRMATR_HXX
// auto strip #include <frmatr.hxx>
// auto strip #endif
#include "so3/staticbaseurl.hxx"
namespace binfilter {

//STRIP001 #define VERSION_30B		((USHORT)250)
//STRIP001 #define VERSION_31B		((USHORT)326)
//STRIP001 #define VERSION_40A		((USHORT)364)
//STRIP001 #define VERSION_50A     ((USHORT)373)
//STRIP001 #define VERSION_53A     ((USHORT)596)
//STRIP001 #define ACT_NUM_VERSION	VERSION_53A
//STRIP001 
//STRIP001 #define NUMRULE_FILENAME "numrule.cfg"
//STRIP001 #define CHAPTER_FILENAME "chapter.cfg"
//STRIP001 #define C2S(cChar) String::CreateFromAscii(cChar)
/*------------------------------------------------------------------------
 Beschreibung:	Ops. zum Laden / Speichern
------------------------------------------------------------------------*/


//STRIP001 SV_IMPL_PTRARR( _SwNumFmtsAttrs, SfxPoolItem* )


// SwNumRulesWithName ----------------------------------------------------
// PUBLIC METHODES -------------------------------------------------------
/*------------------------------------------------------------------------
 Beschreibung:	Speichern einer Regel
 Parameter:		rCopy -- die zu speichernde Regel
				nIdx -- Position, an der die Regel zu speichern ist.
						Eine alte Regel an dieser Position wird ueberschrieben.
------------------------------------------------------------------------*/

//STRIP001 SwBaseNumRules::SwBaseNumRules( const String& rFileName )
//STRIP001 	: nVersion(0),
//STRIP001 	sFileName( rFileName ),
//STRIP001 	bModified( FALSE )
//STRIP001 {
//STRIP001 	Init();
//STRIP001 }

/*-----------------26.06.97 08.30-------------------

--------------------------------------------------*/
//STRIP001 SwBaseNumRules::~SwBaseNumRules()
//STRIP001 {
//STRIP001 	if( bModified )
//STRIP001 	{
//STRIP001 		SvtPathOptions aPathOpt;
//STRIP001 		String sNm( so3::StaticBaseUrl::SmartRelToAbs( aPathOpt.GetUserConfigPath() ));
//STRIP001 		sNm += INET_PATH_TOKEN;
//STRIP001 		sNm += sFileName;
//STRIP001 		INetURLObject aTempObj(sNm);
//STRIP001 		sNm = aTempObj.GetFull();
//STRIP001 		SfxMedium aStrm( sNm, STREAM_WRITE | STREAM_TRUNC |
//STRIP001 										STREAM_SHARE_DENYALL, TRUE );
//STRIP001 		Store( *aStrm.GetOutStream() );
//STRIP001 	}
//STRIP001 
//STRIP001 	for( USHORT i = 0; i < nMaxRules; ++i )
//STRIP001 		delete pNumRules[i];
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/
//STRIP001 void  SwBaseNumRules::Init()
//STRIP001 {
//STRIP001 	for(USHORT i = 0; i < nMaxRules; ++i )
//STRIP001 		pNumRules[i] = 0;
//STRIP001 
//STRIP001 	String sNm( sFileName );
//STRIP001 	SvtPathOptions aOpt;
//STRIP001 	if( aOpt.SearchFile( sNm, SvtPathOptions::PATH_USERCONFIG ))
//STRIP001 	{
//STRIP001 		SfxMedium aStrm( sNm, STREAM_STD_READ, TRUE );
//STRIP001 		Load( *aStrm.GetInStream() );
//STRIP001 	}
//STRIP001 }

/*-----------------26.06.97 08.30-------------------

--------------------------------------------------*/

//STRIP001 void SwBaseNumRules::ApplyNumRules(const SwNumRulesWithName &rCopy, USHORT nIdx)
//STRIP001 {
//STRIP001 	ASSERT(nIdx < nMaxRules, Array der NumRules ueberindiziert.);
//STRIP001 	if( !pNumRules[nIdx] )
//STRIP001 		pNumRules[nIdx] = new SwNumRulesWithName( rCopy );
//STRIP001 	else
//STRIP001 		*pNumRules[nIdx] = rCopy;
//STRIP001 }
/*------------------------------------------------------------------------
 Beschreibung:	Zugriff auf eine Regel ueber ihren Namen
 Return:		Pointer auf die Regel oder Nullptr, wenn nicht vorhanden
------------------------------------------------------------------------*/


//STRIP001 const SwNumRulesWithName *SwBaseNumRules::GetRules(const String &rName) const
//STRIP001 {
//STRIP001 	for(USHORT i = 0; i < nMaxRules; ++i)
//STRIP001 	{
//STRIP001 		SwNumRulesWithName *pRule = pNumRules[i];
//STRIP001 		if( pRule && pRule->GetName() == rName)
//STRIP001 			return pRule;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
// PROTECTED METHODES ----------------------------------------------------
/*------------------------------------------------------------------------
 Beschreibung:	Speichern
------------------------------------------------------------------------*/

//STRIP001 BOOL /**/ SwBaseNumRules::Store(SvStream &rStream)
//STRIP001 {
//STRIP001 	rStream << ACT_NUM_VERSION;
//STRIP001 		// Schreiben, welche Positionen durch eine Regel belegt sind
//STRIP001 		// Anschliessend Schreiben der einzelnen Rules
//STRIP001 	for(USHORT i = 0; i < nMaxRules; ++i)
//STRIP001 	{
//STRIP001 		if(pNumRules[i])
//STRIP001 		{
//STRIP001 			rStream << (unsigned char) TRUE;
//STRIP001 			pNumRules[i]->Store( rStream );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			rStream << (unsigned char) FALSE;
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }



/*------------------------------------------------------------------------
 Beschreibung:	Speichern / Laden
------------------------------------------------------------------------*/


//STRIP001 int SwBaseNumRules::Load(SvStream &rStream)
//STRIP001 {
//STRIP001 	int			rc = 0;
//STRIP001 
//STRIP001 	rStream >> nVersion;
//STRIP001 
//STRIP001 	// wegen eines kleinen aber schweren Fehlers schreibt die PreFinal die
//STRIP001 	// gleiche VERSION_40A wie das SP2 #55402#
//STRIP001 	if(VERSION_40A == nVersion)
//STRIP001 	{
//STRIP001 		DBG_ERROR("Version 364 ist nicht eindeutig #55402#")
//STRIP001 	}
//STRIP001 	else if( VERSION_30B == nVersion || VERSION_31B == nVersion ||
//STRIP001 			 ACT_NUM_VERSION >= nVersion )
//STRIP001 	{
//STRIP001 		unsigned char bRule = FALSE;
//STRIP001 		for(USHORT i = 0; i < nMaxRules; ++i)
//STRIP001 		{
//STRIP001 			rStream >> bRule;
//STRIP001 			if(bRule)
//STRIP001 				pNumRules[i] = new SwNumRulesWithName( rStream, nVersion );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		rc = 1;
//STRIP001 	}
//STRIP001 
//STRIP001 	return rc;
//STRIP001 }

/*-----------------26.06.97 08.34-------------------

--------------------------------------------------*/

/*------------------------------------------------------------------------*/


//STRIP001 SwChapterNumRules::SwChapterNumRules() :
//STRIP001 	SwBaseNumRules(C2S(CHAPTER_FILENAME))
//STRIP001 {
//STRIP001 }

/*------------------------------------------------------------------------*/

//STRIP001  SwChapterNumRules::~SwChapterNumRules()
//STRIP001 {
//STRIP001 }

/*-----------------26.06.97 08.23-------------------

--------------------------------------------------*/
//STRIP001 void SwChapterNumRules::ApplyNumRules(const SwNumRulesWithName &rCopy, USHORT nIdx)
//STRIP001 {
//STRIP001 	bModified = TRUE;
//STRIP001 	SwBaseNumRules::ApplyNumRules(rCopy, nIdx);
//STRIP001 }

/*------------------------------------------------------------------------*/

//STRIP001 SwNumRulesWithName::SwNumRulesWithName(const SwNumRule &rCopy,
//STRIP001 										const String &rName)
//STRIP001 	: aName(rName)
//STRIP001 {
//STRIP001 	for( int n = 0; n < MAXLEVEL; ++n )
//STRIP001 	{
//STRIP001 		const SwNumFmt* pFmt = rCopy.GetNumFmt( n );
//STRIP001 		if( pFmt )
//STRIP001 			aFmts[ n ] = new _SwNumFmtGlobal( *pFmt );
//STRIP001 		else
//STRIP001 			aFmts[ n ] = 0;
//STRIP001 	}
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/
//STRIP001 SwNumRulesWithName::SwNumRulesWithName( const SwNumRulesWithName& rCopy )
//STRIP001 {
//STRIP001 	memset( aFmts, 0, sizeof( aFmts ));
//STRIP001 	*this = rCopy;
//STRIP001 }


/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/
//STRIP001 SwNumRulesWithName::~SwNumRulesWithName()
//STRIP001 {
//STRIP001 	for( int n = 0; n < MAXLEVEL; ++n )
//STRIP001 		delete aFmts[ n ];
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/
//STRIP001 const SwNumRulesWithName& SwNumRulesWithName::operator=(const SwNumRulesWithName &rCopy)
//STRIP001 {
//STRIP001 	if( this != &rCopy )
//STRIP001 	{
//STRIP001 		aName = rCopy.aName;
//STRIP001 		for( int n = 0; n < MAXLEVEL; ++n )
//STRIP001 		{
//STRIP001 			delete aFmts[ n ];
//STRIP001 
//STRIP001 			_SwNumFmtGlobal* pFmt = rCopy.aFmts[ n ];
//STRIP001 			if( pFmt )
//STRIP001 				aFmts[ n ] = new _SwNumFmtGlobal( *pFmt );
//STRIP001 			else
//STRIP001 				aFmts[ n ] = 0;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return *this;
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/
//STRIP001 SwNumRulesWithName::SwNumRulesWithName( SvStream &rStream, USHORT nVersion )
//STRIP001 {
//STRIP001 	CharSet eEncoding = gsl_getSystemTextEncoding();
//STRIP001 	rStream.ReadByteString(aName, eEncoding);
//STRIP001 
//STRIP001 	char c;
//STRIP001 	for(USHORT n = 0; n < MAXLEVEL; ++n )
//STRIP001 	{
//STRIP001 		if( VERSION_30B == nVersion )
//STRIP001 			c = 1;
//STRIP001 		// wegen eines kleinen aber schweren Fehlers schreibt die PreFinal die
//STRIP001 		// gleiche VERSION_40A wie das SP2 #55402#
//STRIP001 		else if(nVersion < VERSION_40A && n > 5)
//STRIP001 //		else if(nVersion < VERSION_50A && n > 5)
//STRIP001 			c = 0;
//STRIP001 		else
//STRIP001 			rStream >> c;
//STRIP001 
//STRIP001 		if( c )
//STRIP001 			aFmts[ n ] = new _SwNumFmtGlobal( rStream, nVersion );
//STRIP001 		else
//STRIP001 			aFmts[ n ] = 0;
//STRIP001 	}
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/

//STRIP001 void SwNumRulesWithName::MakeNumRule( SwWrtShell& rSh, SwNumRule& rChg ) const
//STRIP001 {
//STRIP001 	rChg = SwNumRule( aName );
//STRIP001 	rChg.SetAutoRule( FALSE );
//STRIP001 	_SwNumFmtGlobal* pFmt;
//STRIP001 	for( USHORT n = 0; n < MAXLEVEL; ++n )
//STRIP001 		if( 0 != ( pFmt = aFmts[ n ] ) )
//STRIP001 		{
//STRIP001 			SwNumFmt aNew;
//STRIP001 			pFmt->ChgNumFmt( rSh, aNew );
//STRIP001 			rChg.Set( n, aNew );
//STRIP001 		}
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/
//STRIP001 void SwNumRulesWithName::Store( SvStream &rStream )
//STRIP001 {
//STRIP001 	CharSet eEncoding = gsl_getSystemTextEncoding();
//STRIP001 	rStream.WriteByteString(aName, eEncoding);
//STRIP001 
//STRIP001 	for( USHORT n = 0; n < MAXLEVEL; ++n )
//STRIP001 	{
//STRIP001 		_SwNumFmtGlobal* pFmt = aFmts[ n ];
//STRIP001 		if( pFmt )
//STRIP001 		{
//STRIP001 			rStream << (char)1;
//STRIP001 			pFmt->Store( rStream );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			rStream << (char)0;
//STRIP001 	}
//STRIP001 }
/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/


//STRIP001 SwNumRulesWithName::_SwNumFmtGlobal::_SwNumFmtGlobal( const SwNumFmt& rFmt )
//STRIP001 	: aFmt( rFmt ), nCharPoolId( USHRT_MAX )
//STRIP001 {
//STRIP001 	// relative Abstaende ?????
//STRIP001 
//STRIP001 	SwCharFmt* pFmt = rFmt.GetCharFmt();
//STRIP001 	if( pFmt )
//STRIP001 	{
//STRIP001 		sCharFmtName = pFmt->GetName();
//STRIP001 		nCharPoolId = pFmt->GetPoolFmtId();
//STRIP001 		if( pFmt->GetAttrSet().Count() )
//STRIP001 		{
//STRIP001 			SfxItemIter aIter( pFmt->GetAttrSet() );
//STRIP001 			const SfxPoolItem *pCurr = aIter.GetCurItem();
//STRIP001 			while( TRUE )
//STRIP001 			{
//STRIP001 				aItems.Insert( pCurr->Clone(), aItems.Count() );
//STRIP001 				if( aIter.IsAtEnd() )
//STRIP001 					break;
//STRIP001 				pCurr = aIter.NextItem();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		aFmt.SetCharFmt( 0 );
//STRIP001 	}
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/

//STRIP001 SwNumRulesWithName::_SwNumFmtGlobal::_SwNumFmtGlobal( const _SwNumFmtGlobal& rFmt )
//STRIP001 	: aFmt( rFmt.aFmt ), nCharPoolId( rFmt.nCharPoolId ),
//STRIP001 	sCharFmtName( rFmt.sCharFmtName )
//STRIP001 {
//STRIP001 	for( USHORT n = rFmt.aItems.Count(); n; )
//STRIP001 		aItems.Insert( rFmt.aItems[ --n ]->Clone(), aItems.Count() );
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/

//STRIP001 SwNumRulesWithName::_SwNumFmtGlobal::_SwNumFmtGlobal( SvStream& rStream,
//STRIP001 														USHORT nVersion )
//STRIP001 	: nCharPoolId( USHRT_MAX )
//STRIP001 {
//STRIP001 	CharSet eEncoding = gsl_getSystemTextEncoding();
//STRIP001 	{
//STRIP001 		USHORT nUS;
//STRIP001 		sal_Char cChar;
//STRIP001 		short nShort;
//STRIP001 		BOOL bFlag;
//STRIP001 		String sStr;
//STRIP001 
//STRIP001 		rStream >> nUS;				aFmt.SetNumberingType((sal_Int16)nUS );
//STRIP001 		if( VERSION_53A > nVersion )
//STRIP001 		{
//STRIP001 			rStream >> cChar;		aFmt.SetBulletChar( cChar );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rStream >> nUS; 		aFmt.SetBulletChar( nUS );
//STRIP001 		}
//STRIP001 
//STRIP001 		rStream >> bFlag;			aFmt.SetIncludeUpperLevels( bFlag );
//STRIP001 
//STRIP001 		if( VERSION_30B == nVersion )
//STRIP001 		{
//STRIP001 			long nL;
//STRIP001 			rStream >> cChar;		aFmt.SetStart( (USHORT)cChar );
//STRIP001 
//STRIP001 			rStream.ReadByteString(sStr, eEncoding);
//STRIP001 			aFmt.SetPrefix( sStr );
//STRIP001 			rStream.ReadByteString(sStr, eEncoding);
//STRIP001 			aFmt.SetSuffix( sStr );
//STRIP001 			rStream >> nUS;			aFmt.SetNumAdjust( SvxAdjust( nUS ) );
//STRIP001 			rStream >> nL;			aFmt.SetLSpace( lNumIndent );
//STRIP001 			rStream >> nL;			aFmt.SetFirstLineOffset( (short)nL );
//STRIP001 		}
//STRIP001 		else 				// alter StartWert war ein Byte
//STRIP001 		{
//STRIP001 			rStream >> nUS;			aFmt.SetStart( nUS );
//STRIP001 			rStream.ReadByteString(sStr, eEncoding);
//STRIP001 			aFmt.SetPrefix( sStr );
//STRIP001 			rStream.ReadByteString(sStr, eEncoding);
//STRIP001 			aFmt.SetSuffix( sStr );
//STRIP001 			rStream >> nUS;			aFmt.SetNumAdjust( SvxAdjust( nUS ) );
//STRIP001 			rStream >> nUS;			aFmt.SetAbsLSpace( nUS );
//STRIP001 			rStream >> nShort;		aFmt.SetFirstLineOffset( nShort );
//STRIP001 			rStream >> nUS;			aFmt.SetCharTextDistance( nUS );
//STRIP001 			rStream >> nShort;		aFmt.SetLSpace( nShort );
//STRIP001 			rStream >> bFlag;
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT	nFamily;
//STRIP001 		USHORT  nCharSet;
//STRIP001 		short   nWidth;
//STRIP001 		short   nHeight;
//STRIP001 		USHORT  nPitch;
//STRIP001 		String aName;
//STRIP001 
//STRIP001 		rStream.ReadByteString(aName, eEncoding);
//STRIP001 		rStream >> nFamily >> nCharSet >> nWidth >> nHeight >> nPitch;
//STRIP001 
//STRIP001 		if( aName.Len() )
//STRIP001 		{
//STRIP001 			Font aFont( nFamily, Size( nWidth, nHeight ) );
//STRIP001 			aFont.SetName( aName );
//STRIP001 			aFont.SetCharSet( (CharSet)nCharSet );
//STRIP001 			aFont.SetPitch( (FontPitch)nPitch );
//STRIP001 
//STRIP001 			aFmt.SetBulletFont( &aFont );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			nCharSet = RTL_TEXTENCODING_SYMBOL;
//STRIP001 
//STRIP001 		if( VERSION_53A > nVersion )
//STRIP001 			aFmt.SetBulletChar( ByteString::ConvertToUnicode(
//STRIP001 											aFmt.GetBulletChar(), nCharSet ));
//STRIP001 	}
//STRIP001 
//STRIP001 	if( VERSION_30B != nVersion )
//STRIP001 	{
//STRIP001 		USHORT nItemCount;
//STRIP001 		rStream >> nCharPoolId;
//STRIP001 		rStream.ReadByteString(sCharFmtName, eEncoding);
//STRIP001 		rStream >> nItemCount;
//STRIP001 
//STRIP001 		while( nItemCount-- )
//STRIP001 		{
//STRIP001 			USHORT nWhich, nVers;
//STRIP001 			rStream >> nWhich >> nVers;
//STRIP001 			aItems.Insert( GetDfltAttr( nWhich )->Create( rStream, nVers ),
//STRIP001 							aItems.Count() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( VERSION_40A == nVersion && SVX_NUM_BITMAP == aFmt.GetNumberingType() )
//STRIP001 	{
//STRIP001 		BYTE cF;
//STRIP001 		Size aSz;
//STRIP001 
//STRIP001 		rStream >> aSz.Width() >> aSz.Height();
//STRIP001 
//STRIP001 		rStream >> cF;
//STRIP001 		if( cF )
//STRIP001 		{
//STRIP001 			SvxBrushItem* pBrush = 0;
//STRIP001 			SwFmtVertOrient* pVOrient = 0;
//STRIP001 			USHORT nVer;
//STRIP001 
//STRIP001 			if( cF & 1 )
//STRIP001 			{
//STRIP001 				rStream >> nVer;
//STRIP001 				pBrush = (SvxBrushItem*)GetDfltAttr( RES_BACKGROUND )
//STRIP001 										->Create( rStream, nVer );
//STRIP001 			}
//STRIP001 
//STRIP001 			if( cF & 2 )
//STRIP001 			{
//STRIP001 				rStream >> nVer;
//STRIP001 				pVOrient = (SwFmtVertOrient*)GetDfltAttr( RES_VERT_ORIENT )
//STRIP001 										->Create( rStream, nVer );
//STRIP001 			}
//STRIP001 			SvxFrameVertOrient eOrient = SVX_VERT_NONE;
//STRIP001 			if(pVOrient)
//STRIP001 				eOrient = (SvxFrameVertOrient)pVOrient->GetVertOrient();
//STRIP001 			aFmt.SetGraphicBrush( pBrush, &aSz, pVOrient ? &eOrient : 0 );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/

//STRIP001 SwNumRulesWithName::_SwNumFmtGlobal::~_SwNumFmtGlobal()
//STRIP001 {
//STRIP001 }
/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/


//STRIP001 void SwNumRulesWithName::_SwNumFmtGlobal::Store( SvStream& rStream )
//STRIP001 {
//STRIP001 	CharSet eEncoding = gsl_getSystemTextEncoding();
//STRIP001 	{
//STRIP001 		String aName;
//STRIP001 		USHORT nFamily = FAMILY_DONTKNOW, nCharSet = 0, nPitch = 0;
//STRIP001 		short  nWidth = 0, nHeight = 0;
//STRIP001 
//STRIP001 		const Font* pFnt = aFmt.GetBulletFont();
//STRIP001 		if( pFnt )
//STRIP001 		{
//STRIP001 			aName = pFnt->GetName();
//STRIP001 			nFamily = (USHORT)pFnt->GetFamily();
//STRIP001 			nCharSet = (USHORT)pFnt->GetCharSet();
//STRIP001 			nWidth = (short)pFnt->GetSize().Width();
//STRIP001 			nHeight = (short)pFnt->GetSize().Height();
//STRIP001 			nPitch = (USHORT)pFnt->GetPitch();
//STRIP001 		}
//STRIP001 
//STRIP001 		rStream << USHORT(aFmt.GetNumberingType())
//STRIP001 				<< aFmt.GetBulletChar()
//STRIP001 				<< (aFmt.GetIncludeUpperLevels() > 0)
//STRIP001 				<< aFmt.GetStart();
//STRIP001 		rStream.WriteByteString( aFmt.GetPrefix(), eEncoding );
//STRIP001 		rStream.WriteByteString( aFmt.GetSuffix(), eEncoding );
//STRIP001 		rStream << USHORT( aFmt.GetNumAdjust() )
//STRIP001 				<< aFmt.GetAbsLSpace()
//STRIP001 				<< aFmt.GetFirstLineOffset()
//STRIP001 				<< aFmt.GetCharTextDistance()
//STRIP001 				<< aFmt.GetLSpace()
//STRIP001 				<< FALSE;//aFmt.IsRelLSpace();
//STRIP001 		rStream.WriteByteString( aName, eEncoding );
//STRIP001 		rStream << nFamily
//STRIP001 				<< nCharSet
//STRIP001 				<< nWidth
//STRIP001 				<< nHeight
//STRIP001 				<< nPitch;
//STRIP001 	}
//STRIP001 	rStream << nCharPoolId;
//STRIP001 	rStream.WriteByteString( sCharFmtName, eEncoding );
//STRIP001 	rStream << aItems.Count();
//STRIP001 
//STRIP001 	for( USHORT n = aItems.Count(); n; )
//STRIP001 	{
//STRIP001 		SfxPoolItem* pItem = aItems[ --n ];
//STRIP001 		USHORT nIVers = pItem->GetVersion( SOFFICE_FILEFORMAT_50 );
//STRIP001 		ASSERT( nIVers != USHRT_MAX,
//STRIP001 				"Was'n das: Item-Version USHRT_MAX in der aktuellen Version" );
//STRIP001 		rStream << pItem->Which()
//STRIP001 				<< nIVers;
//STRIP001 		pItem->Store( rStream, nIVers );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Erweiterungen fuer Version 40A
//STRIP001 
//STRIP001 	if( SVX_NUM_BITMAP == aFmt.GetNumberingType() )
//STRIP001 	{
//STRIP001 		rStream << (INT32)aFmt.GetGraphicSize().Width()
//STRIP001 				<< (INT32)aFmt.GetGraphicSize().Height();
//STRIP001 		BYTE cFlg = ( 0 != aFmt.GetBrush() ? 1 : 0 ) +
//STRIP001 					( 0 != aFmt.GetGraphicOrientation() ? 2 : 0 );
//STRIP001 		rStream << cFlg;
//STRIP001 
//STRIP001 		if( aFmt.GetBrush() )
//STRIP001 		{
//STRIP001 			USHORT nVersion = aFmt.GetBrush()->GetVersion( SOFFICE_FILEFORMAT_50 );
//STRIP001 			rStream << nVersion;
//STRIP001 			aFmt.GetBrush()->Store( rStream, nVersion );
//STRIP001 		}
//STRIP001 		if( aFmt.GetGraphicOrientation() )
//STRIP001 		{
//STRIP001 			USHORT nVersion = aFmt.GetGraphicOrientation()->GetVersion( SOFFICE_FILEFORMAT_50 );
//STRIP001 			rStream << nVersion;
//STRIP001 			aFmt.GetGraphicOrientation()->Store( rStream, nVersion );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/

//STRIP001 void SwNumRulesWithName::_SwNumFmtGlobal::ChgNumFmt( SwWrtShell& rSh,
//STRIP001 							SwNumFmt& rNew ) const
//STRIP001 {
//STRIP001 	SwCharFmt* pFmt = 0;
//STRIP001 	if( sCharFmtName.Len() )
//STRIP001 	{
//STRIP001 		// suche erstmal ueber den Namen
//STRIP001 		USHORT nArrLen = rSh.GetCharFmtCount();
//STRIP001 		for( USHORT i = 1; i < nArrLen; ++i )
//STRIP001 		{
//STRIP001 			pFmt = &rSh.GetCharFmt( i );
//STRIP001 			if( COMPARE_EQUAL == pFmt->GetName().CompareTo( sCharFmtName ))
//STRIP001 				// ist vorhanden, also belasse die Attribute wie sie sind!
//STRIP001 				break;
//STRIP001 			pFmt = 0;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( !pFmt )
//STRIP001 		{
//STRIP001 			if( IsPoolUserFmt( nCharPoolId ) )
//STRIP001 			{
//STRIP001 				pFmt = rSh.MakeCharFmt( sCharFmtName );
//STRIP001 				pFmt->SetAuto( FALSE );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pFmt = rSh.GetCharFmtFromPool( nCharPoolId );
//STRIP001 
//STRIP001 			if( !pFmt->GetDepends() )		// Attribute setzen
//STRIP001 				for( USHORT n = aItems.Count(); n; )
//STRIP001 					pFmt->SetAttr( *aItems[ --n ] );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	((SwNumFmt&)aFmt).SetCharFmt( pFmt );
//STRIP001 	rNew = aFmt;
//STRIP001 	if( pFmt )
//STRIP001 		((SwNumFmt&)aFmt).SetCharFmt( 0 );
//STRIP001 }

}
