/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_tpbitmap.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:10:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

//svdraw.hxx
#define _SVDRAW_HXX
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SDR_NOOBJECTS
#define _SDR_NOVIEWS
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV

#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _UNOTOOLS_UCBSTREAMHELPER_HXX
#include <unotools/ucbstreamhelper.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif
#ifndef _FILEDLGHELPER_HXX
#include <bf_sfx2/filedlghelper.hxx>
#endif
#ifndef _UNOTOOLS_LOCALFILEHELPER_HXX
#include <unotools/localfilehelper.hxx>
#endif
#pragma hdrstop

#ifndef _SV_BMPACC_HXX
#include <vcl/bmpacc.hxx>
#endif

#define _SVX_TPBITMAP_CXX
#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE
#define ITEMID_BITMAP_LIST		SID_BITMAP_LIST

#include "dialogs.hrc"

#include "helpid.hrc"
#include "xattr.hxx"
#include "xpool.hxx"
#include "xtable.hxx"
#include "xoutbmp.hxx"
#include "drawitem.hxx"
#include "tabarea.hxx"
#include "tabarea.hrc"
#include "dlgname.hxx"
#include "dlgname.hrc"
#include "dialmgr.hxx"
#include "opengrf.hxx"
namespace binfilter {

//STRIP001 #define DLGWIN this->GetParent()->GetParent()
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	Dialog zum Aendern und Definieren der Bitmaps
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxBitmapTabPage::SvxBitmapTabPage
//STRIP001 (
//STRIP001 	Window* pParent,
//STRIP001 	const SfxItemSet& rInAttrs
//STRIP001 ) :
//STRIP001 
//STRIP001 	SvxTabPage			( pParent, SVX_RES( RID_SVXPAGE_BITMAP ), rInAttrs ),
//STRIP001 
//STRIP001 	pXPool				( (XOutdevItemPool*) rInAttrs.GetPool() ),
//STRIP001 	XOut				( &aCtlPreview ),
//STRIP001 	aXFillAttr			( pXPool ),
//STRIP001 	rXFSet				( aXFillAttr.GetItemSet() ),
//STRIP001 	aXFStyleItem		( XFILL_BITMAP ),
//STRIP001 	aXBitmapItem		( String(), XOBitmap() ),
//STRIP001 
//STRIP001 	aCtlPixel			( this, ResId( CTL_PIXEL ) ),
//STRIP001     aFtPixelEdit        ( this, ResId( FT_PIXEL_EDIT ) ),
//STRIP001     aFtColor            ( this, ResId( FT_COLOR ) ),
//STRIP001 	aLbColor			( this, ResId( LB_COLOR ) ),
//STRIP001 	aFtBackgroundColor	( this, ResId( FT_BACKGROUND_COLOR ) ),
//STRIP001 	aLbBackgroundColor	( this, ResId( LB_BACKGROUND_COLOR ) ),
//STRIP001     // This fix text is used only to provide the name for the following
//STRIP001     // bitmap list box.  The fixed text is not displayed.
//STRIP001     aLbBitmapsHidden    ( this, ResId( FT_BITMAPS_HIDDEN ) ),
//STRIP001 	aLbBitmaps			( this, ResId( LB_BITMAPS ) ),
//STRIP001     aFlProp             ( this, ResId( FL_PROP ) ),
//STRIP001 	aCtlPreview			( this, ResId( CTL_PREVIEW ), &XOut ),
//STRIP001 	aBtnAdd				( this, ResId( BTN_ADD ) ),
//STRIP001 	aBtnImport			( this, ResId( BTN_IMPORT ) ),
//STRIP001 	aBtnModify			( this, ResId( BTN_MODIFY ) ),
//STRIP001 	aBtnDelete			( this, ResId( BTN_DELETE ) ),
//STRIP001 	aBtnLoad			( this, ResId( BTN_LOAD ) ),
//STRIP001 	aBtnSave			( this, ResId( BTN_SAVE ) ),
//STRIP001 	aBitmapCtl			( this, aCtlPreview.GetSizePixel() ),
//STRIP001 	rOutAttrs			( rInAttrs )
//STRIP001 
//STRIP001 {
//STRIP001 	aBtnLoad.SetModeImage( Image( ResId( RID_SVXIMG_LOAD_H ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 	aBtnSave.SetModeImage( Image( ResId( RID_SVXIMG_SAVE_H ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	// Setzen des Output-Devices
//STRIP001 	rXFSet.Put( aXFStyleItem );
//STRIP001 	rXFSet.Put( aXBitmapItem );
//STRIP001 	//XOut.SetFillAttr( aXFillAttr );
//STRIP001 
//STRIP001     // Set line at the OutputDevice
//STRIP001 	XLineAttrSetItem aXLineAttr( pXPool );
//STRIP001     aXLineAttr.GetItemSet().Put( XLineStyleItem( XLINE_SOLID ) );
//STRIP001     aXLineAttr.GetItemSet().Put( XLineWidthItem( 1 ));
//STRIP001 	XOut.SetLineAttr( aXLineAttr.GetItemSet() );
//STRIP001 
//STRIP001 	aBtnAdd.SetClickHdl( LINK( this, SvxBitmapTabPage, ClickAddHdl_Impl ) );
//STRIP001 	aBtnImport.SetClickHdl(
//STRIP001 		LINK( this, SvxBitmapTabPage, ClickImportHdl_Impl ) );
//STRIP001 	aBtnModify.SetClickHdl(
//STRIP001 		LINK( this, SvxBitmapTabPage, ClickModifyHdl_Impl ) );
//STRIP001 	aBtnDelete.SetClickHdl(
//STRIP001 		LINK( this, SvxBitmapTabPage, ClickDeleteHdl_Impl ) );
//STRIP001 	aBtnLoad.SetClickHdl( LINK( this, SvxBitmapTabPage, ClickLoadHdl_Impl ) );
//STRIP001 	aBtnSave.SetClickHdl( LINK( this, SvxBitmapTabPage, ClickSaveHdl_Impl ) );
//STRIP001 
//STRIP001 	aLbBitmaps.SetSelectHdl(
//STRIP001 		LINK( this, SvxBitmapTabPage, ChangeBitmapHdl_Impl ) );
//STRIP001 	aLbColor.SetSelectHdl(
//STRIP001 		LINK( this, SvxBitmapTabPage, ChangePixelColorHdl_Impl ) );
//STRIP001 	aLbBackgroundColor.SetSelectHdl(
//STRIP001 		LINK( this, SvxBitmapTabPage, ChangeBackgrndColorHdl_Impl ) );
//STRIP001 
//STRIP001 	pColorTab = NULL;
//STRIP001 	pBitmapList = NULL;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBitmapTabPage::Construct()
//STRIP001 {
//STRIP001 	// Farbtabellen
//STRIP001 	aLbColor.Fill( pColorTab );
//STRIP001 	aLbBackgroundColor.CopyEntries( aLbColor );
//STRIP001 
//STRIP001 	// Bitmaptabelle
//STRIP001 	aLbBitmaps.Fill( pBitmapList );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBitmapTabPage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	int nPos;
//STRIP001 	int nCount;
//STRIP001 
//STRIP001 	if( *pDlgType == 0 ) // Flaechen-Dialog
//STRIP001 	{
//STRIP001 		*pbAreaTP = FALSE;
//STRIP001 
//STRIP001 		if( pColorTab )
//STRIP001 		{
//STRIP001 			// ColorTable
//STRIP001 			if( *pnColorTableState & CT_CHANGED ||
//STRIP001 				*pnColorTableState & CT_MODIFIED )
//STRIP001 			{
//STRIP001 				if( *pnColorTableState & CT_CHANGED )
//STRIP001 					pColorTab = ( (SvxAreaTabDialog*) DLGWIN )->GetNewColorTable();
//STRIP001 
//STRIP001 				// LbColor
//STRIP001 				nPos = aLbColor.GetSelectEntryPos();
//STRIP001 				aLbColor.Clear();
//STRIP001 				aLbColor.Fill( pColorTab );
//STRIP001 				nCount = aLbColor.GetEntryCount();
//STRIP001 				if( nCount == 0 )
//STRIP001 					; // Dieser Fall sollte nicht auftreten
//STRIP001 				else if( nCount <= nPos )
//STRIP001 					aLbColor.SelectEntryPos( 0 );
//STRIP001 				else
//STRIP001 					aLbColor.SelectEntryPos( nPos );
//STRIP001 
//STRIP001 				// LbColorBackground
//STRIP001 				nPos = aLbBackgroundColor.GetSelectEntryPos();
//STRIP001 				aLbBackgroundColor.Clear();
//STRIP001 				aLbBackgroundColor.CopyEntries( aLbColor );
//STRIP001 				nCount = aLbBackgroundColor.GetEntryCount();
//STRIP001 				if( nCount == 0 )
//STRIP001 					; // Dieser Fall sollte nicht auftreten
//STRIP001 				else if( nCount <= nPos )
//STRIP001 					aLbBackgroundColor.SelectEntryPos( 0 );
//STRIP001 				else
//STRIP001 					aLbBackgroundColor.SelectEntryPos( nPos );
//STRIP001 
//STRIP001 				ChangePixelColorHdl_Impl( this );
//STRIP001 				ChangeBackgrndColorHdl_Impl( this );
//STRIP001 			}
//STRIP001 
//STRIP001 			// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 			// der GroupBox darstellen
//STRIP001 			String			aString( SVX_RES( RID_SVXSTR_TABLE ) ); aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 			INetURLObject	aURL( pBitmapList->GetPath() );
//STRIP001 
//STRIP001 			aURL.Append( pBitmapList->GetName() );
//STRIP001 			DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 			if( aURL.getBase().Len() > 18 )
//STRIP001 			{
//STRIP001 				aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 				aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aString += aURL.getBase();
//STRIP001 
//STRIP001 			if( *pPageType == PT_BITMAP && *pPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 			{
//STRIP001 				aLbBitmaps.SelectEntryPos( *pPos );
//STRIP001 			}
//STRIP001 			// Farben koennten geloescht worden sein
//STRIP001 			ChangeBitmapHdl_Impl( this );
//STRIP001 
//STRIP001 			*pPageType = PT_BITMAP;
//STRIP001 			*pPos = LISTBOX_ENTRY_NOTFOUND;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxBitmapTabPage::DeactivatePage( SfxItemSet* pSet)
//STRIP001 {
//STRIP001 	if ( CheckChanges_Impl() == -1L )
//STRIP001 		return KEEP_PAGE;
//STRIP001 
//STRIP001 	if( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxBitmapTabPage::FillItemSet( SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	if( *pDlgType == 0 && *pbAreaTP == FALSE ) // Flaechen-Dialog
//STRIP001 	{
//STRIP001 		if( *pPageType == PT_BITMAP )
//STRIP001 		{
//STRIP001 			// CheckChanges_Impl(); <-- doppelte Abfrage ?
//STRIP001 
//STRIP001 			XOBitmap aXOBitmap;
//STRIP001 			String aString;
//STRIP001 			USHORT nPos = aLbBitmaps.GetSelectEntryPos();
//STRIP001 			if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 			{
//STRIP001 				aXOBitmap = pBitmapList->Get( nPos )->GetXBitmap();
//STRIP001 				aString = aLbBitmaps.GetSelectEntry();
//STRIP001 
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aXOBitmap = aBitmapCtl.GetXBitmap();
//STRIP001 
//STRIP001 				// #85339# if it's an array, force conversion to bitmap before using it.
//STRIP001 				if(aXOBitmap.GetBitmapType() == XBITMAP_8X8)
//STRIP001 					aXOBitmap.GetBitmap();
//STRIP001 
//STRIP001 			}
//STRIP001 			rOutAttrs.Put( XFillStyleItem( XFILL_BITMAP ) );
//STRIP001 			rOutAttrs.Put( XFillBitmapItem( aString, aXOBitmap ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBitmapTabPage::Reset( const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	// aLbBitmaps.SelectEntryPos( 0 );
//STRIP001 
//STRIP001 	aBitmapCtl.SetLines( aCtlPixel.GetLineCount() );
//STRIP001 	aBitmapCtl.SetPixelColor( aLbColor.GetSelectEntryColor() );
//STRIP001 	aBitmapCtl.SetBackgroundColor( aLbBackgroundColor.GetSelectEntryColor() );
//STRIP001 	aBitmapCtl.SetBmpArray( aCtlPixel.GetPixelPtr() );
//STRIP001 
//STRIP001 	// Bitmap holen und darstellen
//STRIP001 	XFillBitmapItem aBmpItem( (const String &) String(), aBitmapCtl.GetXBitmap() );
//STRIP001 	rXFSet.Put( aBmpItem );
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	aCtlPreview.Invalidate();
//STRIP001 
//STRIP001 	ChangeBitmapHdl_Impl( this );
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( pBitmapList->Count() )
//STRIP001 	{
//STRIP001 		aBtnAdd.Enable();
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxBitmapTabPage::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	return new SvxBitmapTabPage( pWindow, rOutAttrs );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBitmapTabPage, ChangeBitmapHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	XOBitmap* pXOBitmap = NULL;
//STRIP001 	int nPos = aLbBitmaps.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		pXOBitmap = new XOBitmap( ( (XBitmapEntry*) pBitmapList->Get( nPos ) )->GetXBitmap() );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		const SfxPoolItem* pPoolItem = NULL;
//STRIP001 		if( SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLSTYLE ), TRUE, &pPoolItem ) )
//STRIP001 		{
//STRIP001 			XFillStyle eXFS = (XFillStyle) ( ( const XFillStyleItem* ) pPoolItem )->GetValue();
//STRIP001 			if( ( XFILL_BITMAP == eXFS ) &&
//STRIP001 				( SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLBITMAP ), TRUE, &pPoolItem ) ) )
//STRIP001 			{
//STRIP001 				pXOBitmap = new XOBitmap( ( ( const XFillBitmapItem* ) pPoolItem )->GetValue() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if( !pXOBitmap )
//STRIP001 		{
//STRIP001 			aLbBitmaps.SelectEntryPos( 0 );
//STRIP001 			nPos = aLbBitmaps.GetSelectEntryPos();
//STRIP001 			if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 				pXOBitmap = new XOBitmap( ( (XBitmapEntry*) pBitmapList->Get( nPos ) )->GetXBitmap() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if( pXOBitmap )
//STRIP001 	{
//STRIP001 		//WorkWindow		aTmpWW( DLGWIN );
//STRIP001 		//VirtualDevice	aVD( aTmpWW );
//STRIP001 		//USHORT	nLines = aCtlPixel.GetLineCount();
//STRIP001 		//Color	aPixelColor, aBackColor;
//STRIP001 		//BOOL	bPixelColor = FALSE;
//STRIP001 		//USHORT	nWidth  = pBitmap->GetSizePixel().Width();
//STRIP001 		//USHORT	nHeight = pBitmap->GetSizePixel().Height();
//STRIP001 
//STRIP001 		// #85339# try to convert bitmapped item to array item.
//STRIP001 		if(pXOBitmap->GetBitmapType() == XBITMAP_IMPORT)
//STRIP001 		{
//STRIP001 			Bitmap aBitmap(pXOBitmap->GetBitmap());
//STRIP001 			Size aSizePixel(aBitmap.GetSizePixel());
//STRIP001 
//STRIP001 			if(8 == aSizePixel.Width() && 8 == aSizePixel.Height())
//STRIP001 			{
//STRIP001 				sal_uInt16* pPixelArray = new sal_uInt16[64];
//STRIP001 				sal_uInt32 nCol1(0xffffffff); // background
//STRIP001 				sal_uInt32 nCol2(0xffffffff); // pixel
//STRIP001 				BitmapReadAccess* pAccess = aBitmap.AcquireReadAccess();
//STRIP001 				sal_Bool bValid(TRUE);
//STRIP001 
//STRIP001 				if(pAccess)
//STRIP001 				{
//STRIP001 					for(sal_uInt32 a(0); bValid && a < 64; a++)
//STRIP001 					{
//STRIP001 						const BitmapColor aBmCol = pAccess->GetColor(a>>3, a%8);
//STRIP001 						Color aRgbCol(aBmCol.GetRed(), aBmCol.GetGreen(), aBmCol.GetBlue());
//STRIP001 						sal_uInt32 nColVal = aRgbCol.GetRGBColor();
//STRIP001 
//STRIP001 						// test with nCol1
//STRIP001 						if(nCol1 != nColVal)
//STRIP001 						{
//STRIP001 							if(0xffffffff == nCol1)
//STRIP001 							{
//STRIP001 								// nCol1 is used first time
//STRIP001 								nCol1 = nColVal;
//STRIP001 								pPixelArray[a] = 0;
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{
//STRIP001 								// test with nCol2
//STRIP001 								if(nCol2 != nColVal)
//STRIP001 								{
//STRIP001 									if(0xffffffff == nCol2)
//STRIP001 									{
//STRIP001 										// nCol2 used first time
//STRIP001 										nCol2 = nColVal;
//STRIP001 										pPixelArray[a] = 1;
//STRIP001 									}
//STRIP001 									else
//STRIP001 									{
//STRIP001 										// Third color detected
//STRIP001 										bValid = FALSE;
//STRIP001 									}
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									// color is pixel color
//STRIP001 									pPixelArray[a] = 1;
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							// color is background color
//STRIP001 							pPixelArray[a] = 0;
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					// release ReadAccess
//STRIP001 					aBitmap.ReleaseAccess(pAccess);
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					// no access -> no success
//STRIP001 					bValid = FALSE;
//STRIP001 				}
//STRIP001 
//STRIP001 				if(bValid)
//STRIP001 				{
//STRIP001 					Color aCol1(nCol1);
//STRIP001 					Color aCol2(nCol2);
//STRIP001 
//STRIP001 					// no pixel color found? Use opposite od background color.
//STRIP001 					if(0xffffffff == nCol2)
//STRIP001 					{
//STRIP001 						aCol2 = Color(
//STRIP001 							0xff - aCol1.GetRed(),
//STRIP001 							0xff - aCol1.GetGreen(),
//STRIP001 							0xff - aCol1.GetBlue());
//STRIP001 					}
//STRIP001 
//STRIP001 					// transformation did work, create a new Item
//STRIP001 					delete pXOBitmap;
//STRIP001 					pXOBitmap = new XOBitmap(pPixelArray, aCol2, aCol1);
//STRIP001 				}
//STRIP001 
//STRIP001 				// cleanup
//STRIP001 				delete[] pPixelArray;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		aLbColor.SetNoSelection();
//STRIP001 		aLbBackgroundColor.SetNoSelection();
//STRIP001 
//STRIP001 		if( pXOBitmap->GetBitmapType() == XBITMAP_IMPORT )
//STRIP001 		{
//STRIP001 			aCtlPixel.Reset();
//STRIP001 			aCtlPixel.SetPaintable( FALSE );
//STRIP001 			aCtlPixel.Disable();
//STRIP001             aFtPixelEdit.Disable();
//STRIP001 			aFtColor.Disable();
//STRIP001 			aLbColor.Disable();
//STRIP001 			aFtBackgroundColor.Disable();
//STRIP001 			aLbBackgroundColor.Disable();
//STRIP001 			aBtnModify.Disable();
//STRIP001 			aBtnAdd.Disable();
//STRIP001 		}
//STRIP001 		else if( pXOBitmap->GetBitmapType() == XBITMAP_8X8 )
//STRIP001 		{
//STRIP001 			aCtlPixel.SetPaintable( TRUE );
//STRIP001 			aCtlPixel.Enable();
//STRIP001             aFtPixelEdit.Enable();
//STRIP001 			aFtColor.Enable();
//STRIP001 			aLbColor.Enable();
//STRIP001 			aFtBackgroundColor.Enable();
//STRIP001 			aLbBackgroundColor.Enable();
//STRIP001 			aBtnModify.Enable();
//STRIP001 			aBtnAdd.Enable();
//STRIP001 
//STRIP001 			// Setzen des PixelControls
//STRIP001 			aCtlPixel.SetXBitmap( *pXOBitmap );
//STRIP001 
//STRIP001 			Color aPixelColor = pXOBitmap->GetPixelColor();
//STRIP001 			Color aBackColor  = pXOBitmap->GetBackgroundColor();
//STRIP001 
//STRIP001 			aBitmapCtl.SetPixelColor( aPixelColor );
//STRIP001 			aBitmapCtl.SetBackgroundColor( aBackColor );
//STRIP001 
//STRIP001 			// Wenn der Eintrag nicht in der Listbox ist, wird die Farbe
//STRIP001 			// temporaer hinzugenommen
//STRIP001 			if( 0 == aLbBitmaps.GetSelectEntryPos() )
//STRIP001 			{
//STRIP001 				aLbColor.SelectEntry( Color( COL_BLACK ) );
//STRIP001 				ChangePixelColorHdl_Impl( this );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aLbColor.SelectEntry( aPixelColor );
//STRIP001 			if( aLbColor.GetSelectEntryCount() == 0 )
//STRIP001 			{
//STRIP001 				aLbColor.InsertEntry( aPixelColor, String() );
//STRIP001 				aLbColor.SelectEntry( aPixelColor );
//STRIP001 			}
//STRIP001 			aLbBackgroundColor.SelectEntry( aBackColor );
//STRIP001 			if( aLbBackgroundColor.GetSelectEntryCount() == 0 )
//STRIP001 			{
//STRIP001 				aLbBackgroundColor.InsertEntry( aBackColor, String() );
//STRIP001 				aLbBackgroundColor.SelectEntry( aBackColor );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		aCtlPixel.Invalidate();
//STRIP001 
//STRIP001 		// Bitmap darstellen
//STRIP001 		XFillBitmapItem aXBmpItem( (const String &) String(), *pXOBitmap );
//STRIP001 		rXFSet.Put( aXBmpItem );
//STRIP001 
//STRIP001 		XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 		aCtlPreview.Invalidate();
//STRIP001 
//STRIP001 		bBmpChanged = FALSE;
//STRIP001 		delete pXOBitmap;
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long SvxBitmapTabPage::CheckChanges_Impl()
//STRIP001 {
//STRIP001 	USHORT nPos = aLbBitmaps.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		String aString = aLbBitmaps.GetSelectEntry();
//STRIP001 
//STRIP001 		if( bBmpChanged )
//STRIP001 		{
//STRIP001 			ResMgr* pMgr = DIALOG_MGR();
//STRIP001             Image aWarningBoxImage = WarningBox::GetStandardImage();
//STRIP001 			SvxMessDialog aMessDlg( DLGWIN,
//STRIP001 				String( ResId( RID_SVXSTR_BITMAP, pMgr ) ),
//STRIP001 				String( ResId( RID_SVXSTR_ASK_CHANGE_BITMAP, pMgr ) ),
//STRIP001 				&aWarningBoxImage );
//STRIP001 
//STRIP001 			aMessDlg.SetButtonText( MESS_BTN_1,
//STRIP001 									String( ResId( RID_SVXSTR_CHANGE, pMgr ) ) );
//STRIP001 			aMessDlg.SetButtonText( MESS_BTN_2,
//STRIP001 									String( ResId( RID_SVXSTR_ADD, pMgr ) ) );
//STRIP001 
//STRIP001 			short nRet = aMessDlg.Execute();
//STRIP001 
//STRIP001 			switch( nRet )
//STRIP001 			{
//STRIP001 				case RET_BTN_1: // Aendern
//STRIP001 				{
//STRIP001 					ClickModifyHdl_Impl( this );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case RET_BTN_2: // Hinzufuegen
//STRIP001 				{
//STRIP001 					ClickAddHdl_Impl( this );
//STRIP001 					nPos = aLbBitmaps.GetSelectEntryPos();
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case RET_CANCEL:
//STRIP001 					// return( -1L );
//STRIP001 				break;
//STRIP001 				// return( TRUE ); // Abbruch
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	nPos = aLbBitmaps.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		*pPos = nPos;
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBitmapTabPage, ClickAddHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 	String aNewName( ResId( RID_SVXSTR_BITMAP, pMgr ) );
//STRIP001 	String aDesc( ResId( RID_SVXSTR_DESC_NEW_BITMAP, pMgr ) );
//STRIP001 	String aName;
//STRIP001 
//STRIP001 	long nCount = pBitmapList->Count();
//STRIP001 	long j = 1;
//STRIP001 	BOOL bDifferent = FALSE;
//STRIP001 
//STRIP001 	while( !bDifferent )
//STRIP001 	{
//STRIP001 		aName  = aNewName;
//STRIP001 		aName += sal_Unicode(' ');
//STRIP001 		aName += UniString::CreateFromInt32( j++ );
//STRIP001 		bDifferent = TRUE;
//STRIP001 
//STRIP001 		for( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 			if( aName == pBitmapList->Get( i )->GetName() )
//STRIP001 				bDifferent = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	SvxNameDialog* pDlg     = new SvxNameDialog( DLGWIN, aName, aDesc );
//STRIP001 	WarningBox*    pWarnBox = NULL;
//STRIP001 	USHORT         nError   = RID_SVXSTR_WARN_NAME_DUPLICATE;
//STRIP001 
//STRIP001 	while( pDlg->Execute() == RET_OK )
//STRIP001 	{
//STRIP001 		pDlg->GetName( aName );
//STRIP001 
//STRIP001 		bDifferent = TRUE;
//STRIP001 
//STRIP001 		for( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 			if( aName == pBitmapList->Get( i )->GetName() )
//STRIP001 				bDifferent = FALSE;
//STRIP001 
//STRIP001 		if( bDifferent ) {
//STRIP001 			nError = 0;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( !pWarnBox )
//STRIP001 		{
//STRIP001 			pWarnBox = new WarningBox( DLGWIN,
//STRIP001 									   WinBits( WB_OK_CANCEL ),
//STRIP001 									   String( ResId( nError, pMgr ) ) );
//STRIP001 			pWarnBox->SetHelpId( HID_WARN_NAME_DUPLICATE );
//STRIP001 		}
//STRIP001 
//STRIP001 		if( pWarnBox->Execute() != RET_OK )
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	//Rectangle aDlgRect( pDlg->GetPosPixel(), pDlg->GetSizePixel() );
//STRIP001 	delete pDlg;
//STRIP001 	delete pWarnBox;
//STRIP001 
//STRIP001 	if( !nError )
//STRIP001 	{
//STRIP001 		XBitmapEntry* pEntry;
//STRIP001 		if( aCtlPixel.IsEnabled() )
//STRIP001 		{
//STRIP001 			XOBitmap aXOBitmap = aBitmapCtl.GetXBitmap();
//STRIP001 
//STRIP001 			// #85339# if it's an array, force conversion to bitmap before using it.
//STRIP001 			if(aXOBitmap.GetBitmapType() == XBITMAP_8X8)
//STRIP001 				aXOBitmap.GetBitmap();
//STRIP001 
//STRIP001 			pEntry = new XBitmapEntry( aXOBitmap, aName );
//STRIP001 		}
//STRIP001 		else // Es muss sich um eine nicht vorhandene importierte Bitmap handeln
//STRIP001 		{
//STRIP001 			const SfxPoolItem* pPoolItem = NULL;
//STRIP001 			if( SFX_ITEM_SET == rOutAttrs.GetItemState( XATTR_FILLBITMAP, TRUE, &pPoolItem ) )
//STRIP001 			{
//STRIP001 				XOBitmap aXOBitmap( ( ( const XFillBitmapItem* ) pPoolItem )->GetValue() );
//STRIP001 				pEntry = new XBitmapEntry( aXOBitmap, aName );
//STRIP001 			}
//STRIP001 			else { DBG_ERROR( "pEntry is undfined -> GPF" ) }
//STRIP001 		}
//STRIP001 
//STRIP001 		pBitmapList->Insert( pEntry );
//STRIP001 
//STRIP001 		aLbBitmaps.Append( pEntry );
//STRIP001 		aLbBitmaps.SelectEntryPos( aLbBitmaps.GetEntryCount() - 1 );
//STRIP001 
//STRIP001 #ifdef WNT
//STRIP001 		// hack: #31355# W.P.
//STRIP001 		Rectangle aRect( aLbBitmaps.GetPosPixel(), aLbBitmaps.GetSizePixel() );
//STRIP001 		if( TRUE ) {				// ??? overlapped with pDlg
//STRIP001 									// and srolling
//STRIP001 			Invalidate( aRect );
//STRIP001 			//aLbBitmaps.Invalidate();
//STRIP001 		}
//STRIP001 #endif
//STRIP001 
//STRIP001 		// Flag fuer modifiziert setzen
//STRIP001 		*pnBitmapListState |= CT_MODIFIED;
//STRIP001 
//STRIP001 		ChangeBitmapHdl_Impl( this );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( pBitmapList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /******************************************************************************/
//STRIP001 /******************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 #ifdef WNT
//STRIP001 #pragma optimize ( "", off )
//STRIP001 #endif
//STRIP001 
//STRIP001 IMPL_LINK( SvxBitmapTabPage, ClickImportHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 	SvxOpenGraphicDialog aDlg( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "Import" ) ) );
//STRIP001 	aDlg.EnableLink(sal_False);
//STRIP001 
//STRIP001 	if( !aDlg.Execute() )
//STRIP001 	{
//STRIP001 		Graphic 		aGraphic;
//STRIP001 		USHORT			nError = 1;
//STRIP001 
//STRIP001 		EnterWait();
//STRIP001 		nError = aDlg.GetGraphic( aGraphic );
//STRIP001 		LeaveWait();
//STRIP001 
//STRIP001 		if( !nError )
//STRIP001 		{
//STRIP001 			String aDesc( ResId(RID_SVXSTR_DESC_EXT_BITMAP, pMgr) );
//STRIP001 			WarningBox*    pWarnBox = NULL;
//STRIP001 
//STRIP001 			// convert file URL to UI name 
//STRIP001 			String 			aName;
//STRIP001 			INetURLObject	aURL( aDlg.GetPath() );
//STRIP001     		SvxNameDialog*  pDlg = new SvxNameDialog( DLGWIN, aURL.GetName().GetToken( 0, '.' ), aDesc );
//STRIP001 			nError = RID_SVXSTR_WARN_NAME_DUPLICATE;
//STRIP001 
//STRIP001 			while( pDlg->Execute() == RET_OK )
//STRIP001 			{
//STRIP001 				pDlg->GetName( aName );
//STRIP001 
//STRIP001 				BOOL bDifferent = TRUE;
//STRIP001 				long nCount     = pBitmapList->Count();
//STRIP001 
//STRIP001 				for( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 					if( aName == pBitmapList->Get( i )->GetName() )
//STRIP001 						bDifferent = FALSE;
//STRIP001 
//STRIP001 				if( bDifferent ) {
//STRIP001 					nError = 0;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( !pWarnBox )
//STRIP001 				{
//STRIP001 					pWarnBox = new WarningBox( DLGWIN,
//STRIP001 											   WinBits( WB_OK_CANCEL ),
//STRIP001 											   String( ResId( nError, pMgr ) ) );
//STRIP001 					pWarnBox->SetHelpId( HID_WARN_NAME_DUPLICATE );
//STRIP001 				}
//STRIP001 
//STRIP001 
//STRIP001 				if( pWarnBox->Execute() != RET_OK )
//STRIP001 					break;
//STRIP001 			}
//STRIP001 			//Rectangle aDlgRect( pDlg->GetPosPixel(), pDlg->GetSizePixel() );
//STRIP001 			delete pDlg;
//STRIP001 			delete pWarnBox;
//STRIP001 
//STRIP001 			if( !nError )
//STRIP001 			{
//STRIP001 				Bitmap aBmp( aGraphic.GetBitmap() );
//STRIP001 				XBitmapEntry* pEntry =
//STRIP001 					new XBitmapEntry( XOBitmap( aBmp ), aName );
//STRIP001 				pBitmapList->Insert( pEntry );
//STRIP001 
//STRIP001 				aLbBitmaps.Append( pEntry );
//STRIP001 				aLbBitmaps.SelectEntryPos( aLbBitmaps.GetEntryCount() - 1 );
//STRIP001 
//STRIP001 #ifdef WNT
//STRIP001 				// hack: #31355# W.P.
//STRIP001 				Rectangle aRect( aLbBitmaps.GetPosPixel(), aLbBitmaps.GetSizePixel() );
//STRIP001 				if( TRUE ) {				// ??? overlapped with pDlg
//STRIP001 											// and srolling
//STRIP001 					Invalidate( aRect );
//STRIP001 					//aLbBitmaps.Invalidate();
//STRIP001 				}
//STRIP001 #endif
//STRIP001 
//STRIP001 				// Flag fuer modifiziert setzen
//STRIP001 				*pnBitmapListState |= CT_MODIFIED;
//STRIP001 
//STRIP001 				ChangeBitmapHdl_Impl( this );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			// Graphik konnte nicht geladen werden
//STRIP001 			ErrorBox( DLGWIN,
//STRIP001 					  WinBits( WB_OK ),
//STRIP001 					  String( ResId( RID_SVXSTR_READ_DATA_ERROR, pMgr ) ) ).Execute();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 #ifdef WNT
//STRIP001 #pragma optimize ( "", on )
//STRIP001 #endif
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBitmapTabPage, ClickModifyHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	int nPos = aLbBitmaps.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if ( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		ResMgr* pMgr = DIALOG_MGR();
//STRIP001 		String aNewName( ResId( RID_SVXSTR_BITMAP, pMgr ) );
//STRIP001 		String aDesc( ResId( RID_SVXSTR_DESC_NEW_BITMAP, pMgr ) );
//STRIP001 		String aName( pBitmapList->Get( nPos )->GetName() );
//STRIP001 		String aOldName = aName;
//STRIP001 
//STRIP001 		SvxNameDialog* pDlg = new SvxNameDialog( DLGWIN, aName, aDesc );
//STRIP001 
//STRIP001 		long nCount = pBitmapList->Count();
//STRIP001 		BOOL bDifferent = FALSE;
//STRIP001 		BOOL bLoop = TRUE;
//STRIP001 
//STRIP001 		while( bLoop && pDlg->Execute() == RET_OK )
//STRIP001 		{
//STRIP001 			pDlg->GetName( aName );
//STRIP001 			bDifferent = TRUE;
//STRIP001 
//STRIP001 			for( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 			{
//STRIP001 				if( aName == pBitmapList->Get( i )->GetName() &&
//STRIP001 					aName != aOldName )
//STRIP001 					bDifferent = FALSE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if( bDifferent )
//STRIP001 			{
//STRIP001 				bLoop = FALSE;
//STRIP001 				XBitmapEntry* pEntry = pBitmapList->Get( nPos );
//STRIP001 
//STRIP001 				pEntry->SetName( aName );
//STRIP001 
//STRIP001 				XOBitmap aXOBitmap = aBitmapCtl.GetXBitmap();
//STRIP001 
//STRIP001 				// #85339# if it's an array, force conversion to bitmap before using it.
//STRIP001 				if(aXOBitmap.GetBitmapType() == XBITMAP_8X8)
//STRIP001 					aXOBitmap.GetBitmap();
//STRIP001 
//STRIP001 				pEntry->SetXBitmap( aXOBitmap );
//STRIP001 
//STRIP001 				aLbBitmaps.Modify( pEntry, nPos );
//STRIP001 				aLbBitmaps.SelectEntryPos( nPos );
//STRIP001 
//STRIP001 				// Flag fuer modifiziert setzen
//STRIP001 				*pnBitmapListState |= CT_MODIFIED;
//STRIP001 
//STRIP001 				bBmpChanged = FALSE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				WarningBox aBox( DLGWIN, WinBits( WB_OK ), String( ResId( RID_SVXSTR_WARN_NAME_DUPLICATE, pMgr ) ) );
//STRIP001 				aBox.SetHelpId( HID_WARN_NAME_DUPLICATE );
//STRIP001 				aBox.Execute();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		delete pDlg;
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBitmapTabPage, ClickDeleteHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	int nPos = aLbBitmaps.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		QueryBox aQueryBox( DLGWIN, WinBits( WB_YES_NO | WB_DEF_NO ),
//STRIP001 //!			SVX_RES( RID_SVXSTR_DEL_BITMAP ),
//STRIP001 			String( SVX_RES( RID_SVXSTR_ASK_DEL_BITMAP ) ) );
//STRIP001 
//STRIP001 		if( aQueryBox.Execute() == RET_YES )
//STRIP001 		{
//STRIP001 			delete pBitmapList->Remove( nPos );
//STRIP001 			aLbBitmaps.RemoveEntry( nPos );
//STRIP001 			aLbBitmaps.SelectEntryPos( 0 );
//STRIP001 
//STRIP001 			aCtlPreview.Invalidate();
//STRIP001 			aCtlPixel.Invalidate();
//STRIP001 
//STRIP001 			ChangeBitmapHdl_Impl( this );
//STRIP001 
//STRIP001 			// Flag fuer modifiziert setzen
//STRIP001 			*pnBitmapListState |= CT_MODIFIED;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( !pBitmapList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBitmapTabPage, ClickLoadHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 	USHORT nReturn = RET_YES;
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 
//STRIP001 	if ( *pnBitmapListState & CT_MODIFIED )
//STRIP001 	{
//STRIP001 		nReturn = WarningBox( DLGWIN, WinBits( WB_YES_NO_CANCEL ),
//STRIP001 			String( ResId( RID_SVXSTR_WARN_TABLE_OVERWRITE, pMgr ) ) ).Execute();
//STRIP001 
//STRIP001 		if ( nReturn == RET_YES )
//STRIP001 			pBitmapList->Save();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nReturn != RET_CANCEL )
//STRIP001 	{
//STRIP001     	::sfx2::FileDialogHelper aDlg( ::sfx2::FILEOPEN_SIMPLE, 0 );
//STRIP001 		String aStrFilterType( RTL_CONSTASCII_USTRINGPARAM( "*.sob" ) );
//STRIP001 		aDlg.AddFilter( aStrFilterType, aStrFilterType );
//STRIP001 		INetURLObject aFile( SvtPathOptions().GetPalettePath() );
//STRIP001 		aDlg.SetDisplayDirectory( aFile.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001     	if ( aDlg.Execute() == ERRCODE_NONE )
//STRIP001 		{
//STRIP001 			EnterWait();
//STRIP001 			INetURLObject aURL( aDlg.GetPath() );
//STRIP001 			INetURLObject aPathURL( aURL );
//STRIP001 
//STRIP001 			aPathURL.removeSegment();
//STRIP001 			aPathURL.removeFinalSlash();
//STRIP001 
//STRIP001 			// Tabelle speichern
//STRIP001 			XBitmapList* pBmpList = new XBitmapList( aPathURL.GetMainURL( INetURLObject::NO_DECODE ), pXPool );
//STRIP001 			pBmpList->SetName( aURL.getName() );
//STRIP001 			if( pBmpList->Load() )
//STRIP001 			{
//STRIP001 				if( pBmpList )
//STRIP001 				{
//STRIP001 					// Pruefen, ob Tabelle geloescht werden darf:
//STRIP001 					if( pBitmapList != ( (SvxAreaTabDialog*) DLGWIN )->GetBitmapList() )
//STRIP001 						delete pBitmapList;
//STRIP001 
//STRIP001 					pBitmapList = pBmpList;
//STRIP001 					( (SvxAreaTabDialog*) DLGWIN )->SetNewBitmapList( pBitmapList );
//STRIP001 
//STRIP001 					aLbBitmaps.Clear();
//STRIP001 					aLbBitmaps.Fill( pBitmapList );
//STRIP001 					Reset( rOutAttrs );
//STRIP001 
//STRIP001 					pBitmapList->SetName( aURL.getName() );
//STRIP001 
//STRIP001 					// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 					// der GroupBox darstellen
//STRIP001 					String aString( ResId( RID_SVXSTR_TABLE, pMgr ) );
//STRIP001 					aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 
//STRIP001 					if ( aURL.getBase().Len() > 18 )
//STRIP001 					{
//STRIP001 						aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 						aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 					}
//STRIP001 					else
//STRIP001 						aString += aURL.getBase();
//STRIP001 
//STRIP001 					// Flag fuer gewechselt setzen
//STRIP001 					*pnBitmapListState |= CT_CHANGED;
//STRIP001 					// Flag fuer modifiziert entfernen
//STRIP001 					*pnBitmapListState &= ~CT_MODIFIED;
//STRIP001 				}
//STRIP001 				LeaveWait();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				LeaveWait();
//STRIP001 				ErrorBox( DLGWIN, WinBits( WB_OK ),
//STRIP001 					String( ResId( RID_SVXSTR_READ_DATA_ERROR, pMgr ) ) ).Execute();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( pBitmapList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBitmapTabPage, ClickSaveHdl_Impl, void *, p )
//STRIP001 {
//STRIP001    	::sfx2::FileDialogHelper aDlg( ::sfx2::FILESAVE_SIMPLE, 0 );
//STRIP001 	String aStrFilterType( RTL_CONSTASCII_USTRINGPARAM( "*.sob" ) );
//STRIP001 	aDlg.AddFilter( aStrFilterType, aStrFilterType );
//STRIP001 
//STRIP001 	INetURLObject aFile( SvtPathOptions().GetPalettePath() );
//STRIP001 	DBG_ASSERT( aFile.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 	if( pBitmapList->GetName().Len() )
//STRIP001 	{
//STRIP001 		aFile.Append( pBitmapList->GetName() );
//STRIP001 
//STRIP001 		if( !aFile.getExtension().Len() )
//STRIP001 			aFile.SetExtension( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "sob" ) ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	aDlg.SetDisplayDirectory( aFile.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 	if ( aDlg.Execute() == ERRCODE_NONE )
//STRIP001 	{
//STRIP001 		INetURLObject	aURL( aDlg.GetPath() );
//STRIP001 		INetURLObject	aPathURL( aURL );
//STRIP001 
//STRIP001 		aPathURL.removeSegment();
//STRIP001 		aPathURL.removeFinalSlash();
//STRIP001 
//STRIP001 		pBitmapList->SetName( aURL.getName() );
//STRIP001 		pBitmapList->SetPath( aPathURL.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 		if( pBitmapList->Save() )
//STRIP001 		{
//STRIP001 			// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 			// der GroupBox darstellen
//STRIP001 			String aString( SVX_RES( RID_SVXSTR_TABLE ) );
//STRIP001 			aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 
//STRIP001 			if ( aURL.getBase().Len() > 18 )
//STRIP001 			{
//STRIP001 				aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 				aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aString += aURL.getBase();
//STRIP001 
//STRIP001 			// Flag fuer gespeichert setzen
//STRIP001 			*pnBitmapListState |= CT_SAVED;
//STRIP001 			// Flag fuer modifiziert entfernen
//STRIP001 			*pnBitmapListState &= ~CT_MODIFIED;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ErrorBox( DLGWIN, WinBits( WB_OK ),
//STRIP001 				String( SVX_RES( RID_SVXSTR_WRITE_DATA_ERROR ) ) ).Execute();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBitmapTabPage, ChangePixelColorHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	aCtlPixel.SetPixelColor( aLbColor.GetSelectEntryColor() );
//STRIP001 	aCtlPixel.Invalidate();
//STRIP001 
//STRIP001 	aBitmapCtl.SetPixelColor( aLbColor.GetSelectEntryColor() );
//STRIP001 
//STRIP001 	// Bitmap holen und darstellen
//STRIP001 	rXFSet.Put( XFillBitmapItem( String(), aBitmapCtl.GetXBitmap() ) );
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	aCtlPreview.Invalidate();
//STRIP001 
//STRIP001 	bBmpChanged = TRUE;
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBitmapTabPage, ChangeBackgrndColorHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	aCtlPixel.SetBackgroundColor( aLbBackgroundColor.GetSelectEntryColor() );
//STRIP001 	aCtlPixel.Invalidate();
//STRIP001 
//STRIP001 	aBitmapCtl.SetBackgroundColor( aLbBackgroundColor.GetSelectEntryColor() );
//STRIP001 
//STRIP001 	// Bitmap holen und darstellen
//STRIP001 	rXFSet.Put( XFillBitmapItem( String(), aBitmapCtl.GetXBitmap() ) );
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 	aCtlPreview.Invalidate();
//STRIP001 
//STRIP001 	bBmpChanged = TRUE;
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBitmapTabPage::PointChanged( Window* pWindow, RECT_POINT eRcPt )
//STRIP001 {
//STRIP001 	if( pWindow == &aCtlPixel )
//STRIP001 	{
//STRIP001 		aBitmapCtl.SetBmpArray( aCtlPixel.GetPixelPtr() );
//STRIP001 
//STRIP001 		// Bitmap holen und darstellen
//STRIP001 		rXFSet.Put( XFillBitmapItem( String(), aBitmapCtl.GetXBitmap() ) );
//STRIP001 		XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 		aCtlPreview.Invalidate();
//STRIP001 
//STRIP001 		bBmpChanged = TRUE;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 Window*	SvxBitmapTabPage::GetParentLabeledBy( const Window* pLabeled ) const
//STRIP001 {
//STRIP001     if (pLabeled == &aLbBitmaps)
//STRIP001         return const_cast<FixedText*>(&aLbBitmapsHidden);
//STRIP001     else
//STRIP001         return SvxTabPage::GetParentLabeledBy (pLabeled);
//STRIP001 }
}
