/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_ctredlin.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:39:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// System - Includes ---------------------------------------------------------
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif
#ifndef _TXTCMP_HXX //autogen
#include <svtools/txtcmp.hxx>
#endif

#pragma hdrstop

// INCLUDE -------------------------------------------------------------------


#include <dialmgr.hxx>
#include "ctredlin.hrc"
#include "ctredlin.hxx"
#include "helpid.hrc"
namespace binfilter {

//============================================================================
//	Local Defines and Function
//----------------------------------------------------------------------------

//STRIP001 inline void EnableDisable( Window& rWin, BOOL bEnable )
//STRIP001 {
//STRIP001 	if (bEnable)
//STRIP001 		rWin.Enable();
//STRIP001 	else
//STRIP001 		rWin.Disable();
//STRIP001 }

//STRIP001 static long nStaticTabs[]=
//STRIP001 {
//STRIP001 	5,10,65,120,170,220
//STRIP001 };

//STRIP001 #define	MIN_DISTANCE	6
//STRIP001 #define WRITER_AUTHOR   1
//STRIP001 #define WRITER_DATE		2
//STRIP001 #define CALC_AUTHOR		2
//STRIP001 #define CALC_DATE		3

//STRIP001 RedlinData::RedlinData()
//STRIP001 {
//STRIP001 	bDisabled=FALSE;
//STRIP001 	pData=NULL;
//STRIP001 }
//STRIP001 RedlinData::~RedlinData()
//STRIP001 {
//STRIP001 }

//============================================================================
//	class SvxRedlinEntry (Eintraege fuer Liste)
//----------------------------------------------------------------------------

//STRIP001 SvxRedlinEntry::SvxRedlinEntry()
//STRIP001 	:SvLBoxEntry()
//STRIP001 {
//STRIP001 }

//STRIP001 SvxRedlinEntry::~SvxRedlinEntry()
//STRIP001 {
//STRIP001 	RedlinData* pRedDat=(RedlinData*) GetUserData();
//STRIP001 	if(pRedDat!=NULL)
//STRIP001 	{
//STRIP001 		delete pRedDat;
//STRIP001 	}
//STRIP001 }

/*************************************************************************
#* Funktionen der in den SvxRedlinTable eingefuegten Items
#************************************************************************/

//STRIP001 DBG_NAME(SvLBoxColorString)

/*************************************************************************
#*	Member:		SvLBoxColorString							Datum:23.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvLBoxColorString
#*
#*  Funktion:	Konstruktor der Klasse SvLBoxColorString
#*
#*  Input:		Box- Entry,Flags, Text fuer Anzeige, Schrift
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 SvLBoxColorString::SvLBoxColorString( SvLBoxEntry*pEntry,USHORT nFlags,const XubString& rStr,
//STRIP001 									const Color& rCol)
//STRIP001 
//STRIP001 : SvLBoxString( pEntry, nFlags, rStr )
//STRIP001 {
//STRIP001 	DBG_CTOR(SvLBoxColorString,0);
//STRIP001 	aPrivColor=rCol;
//STRIP001 	SetText( pEntry, rStr );
//STRIP001 }

/*************************************************************************
#*	Member:		SvLBoxColorString							Datum:23.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvLBoxColorString
#*
#*  Funktion:	Default Konstruktor der Klasse SvLBoxColorString
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 SvLBoxColorString::SvLBoxColorString()
//STRIP001 : SvLBoxString()
//STRIP001 {
//STRIP001 	DBG_CTOR(SvLBoxColorString,0);
//STRIP001 }

/*************************************************************************
#*	Member:		~SvLBoxColorString							Datum:23.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvLBoxColorString
#*
#*  Funktion:	Destruktor der Klasse SvLBoxColorString
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 SvLBoxColorString::~SvLBoxColorString()
//STRIP001 {
//STRIP001 	DBG_DTOR(SvLBoxColorString,0);
//STRIP001 }


/*************************************************************************
#*	Member:		SvLBoxColorString							Datum:23.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvLBoxColorString
#*
#*  Funktion:	Erzeugt einen neuen SvLBoxColorString
#*
#*  Input:		---
#*
#*	Output:		SvLBoxColorString
#*
#************************************************************************/

//STRIP001 SvLBoxItem* SvLBoxColorString::Create() const
//STRIP001 {
//STRIP001 	DBG_CHKTHIS(SvLBoxColorString,0);
//STRIP001 	return new SvLBoxColorString;
//STRIP001 }



/*************************************************************************
#*	Member:		SvLBoxColorString							Datum:23.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvLBoxColorString
#*
#*  Funktion:	Zeichenroutine des SvLBoxColorString. Gezeichnet wird
#*				der entsprechende Text mit der eingestellten Farbe
#*				im Ausgabe- Device.
#*
#*  Input:		Position, Ausgabe- Device, Flag fuer Selection,
#*				Zeiger auf den Eintrag
#*
#*	Output:		---
#*
#************************************************************************/

//STRIP001 void SvLBoxColorString::Paint( const Point& rPos, SvLBox& rDev,
//STRIP001 							 USHORT nFlags,	SvLBoxEntry* pEntry )
//STRIP001 {
//STRIP001 	Color aColor=rDev.GetTextColor();
//STRIP001 	Color a2Color=aColor;
//STRIP001 	if(!(nFlags & SVLISTENTRYFLAG_SELECTED))
//STRIP001 	{
//STRIP001 		rDev.SetTextColor(aPrivColor);
//STRIP001 	}
//STRIP001 	SvLBoxString::Paint(rPos,rDev,nFlags,pEntry );
//STRIP001 	rDev.SetTextColor(a2Color);
//STRIP001 }

//============================================================================
//	class SvxRedlinTable
//----------------------------------------------------------------------------

//STRIP001 SvxRedlinTable::SvxRedlinTable( Window* pParent,WinBits nBits ):
//STRIP001 		SvxSimpleTable(pParent,nBits )
//STRIP001 {
//STRIP001 	bAuthor=FALSE;
//STRIP001 	bDate=FALSE;
//STRIP001 	bIsCalc=FALSE;
//STRIP001 	bComment=FALSE;
//STRIP001 	nDatePos=WRITER_DATE;
//STRIP001 	pCommentSearcher=NULL;
//STRIP001     SetNodeDefaultImages();
//STRIP001 }

//STRIP001 SvxRedlinTable::SvxRedlinTable( Window* pParent,const ResId& rResId):
//STRIP001 		SvxSimpleTable(pParent,rResId)
//STRIP001 {
//STRIP001 	bAuthor=FALSE;
//STRIP001 	bDate=FALSE;
//STRIP001 	bIsCalc=FALSE;
//STRIP001 	bComment=FALSE;
//STRIP001 	nDatePos=WRITER_DATE;
//STRIP001 	pCommentSearcher=NULL;
//STRIP001     SetNodeDefaultImages();
//STRIP001 }

//STRIP001 SvxRedlinTable::~SvxRedlinTable()
//STRIP001 {
//STRIP001 	if(pCommentSearcher!=NULL)
//STRIP001 		delete pCommentSearcher;
//STRIP001 }

//STRIP001 StringCompare SvxRedlinTable::ColCompare(SvLBoxEntry* pLeft,SvLBoxEntry* pRight)
//STRIP001 {
//STRIP001 	StringCompare eCompare=COMPARE_EQUAL;
//STRIP001 
//STRIP001 	if(aColCompareLink.IsSet())
//STRIP001 	{
//STRIP001 		SvSortData aRedlinCompare;
//STRIP001 		aRedlinCompare.pLeft=pLeft;
//STRIP001 		aRedlinCompare.pRight=pRight;
//STRIP001 		eCompare=(StringCompare) aColCompareLink.Call(&aRedlinCompare);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if(nDatePos==GetSortedCol())
//STRIP001 		{
//STRIP001 			RedlinData *pLeftData=(RedlinData *)(pLeft->GetUserData());
//STRIP001 			RedlinData *pRightData=(RedlinData *)(pRight->GetUserData());
//STRIP001 
//STRIP001 			if(pLeftData!=NULL && pRightData!=NULL)
//STRIP001 			{
//STRIP001 				if(pLeftData->aDateTime < pRightData->aDateTime)
//STRIP001 				{
//STRIP001 					eCompare=COMPARE_LESS;
//STRIP001 				}
//STRIP001 				else if(pLeftData->aDateTime > pRightData->aDateTime)
//STRIP001 				{
//STRIP001 					eCompare=COMPARE_GREATER;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 				eCompare=SvxSimpleTable::ColCompare(pLeft,pRight);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			eCompare=SvxSimpleTable::ColCompare(pLeft,pRight);
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	return eCompare;
//STRIP001 }
//STRIP001 void SvxRedlinTable::SetCalcView(BOOL bFlag)
//STRIP001 {
//STRIP001 	bIsCalc=bFlag;
//STRIP001 	if(bFlag)
//STRIP001 	{
//STRIP001 		nDatePos=CALC_DATE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nDatePos=WRITER_DATE;
//STRIP001 	}
//STRIP001 }


//STRIP001 void SvxRedlinTable::UpdateFilterTest()
//STRIP001 {
//STRIP001 	Date aDateMax;
//STRIP001 	USHORT nYEAR=aDateMax.GetYear()+100;
//STRIP001 	aDateMax.SetYear(nYEAR);
//STRIP001 	Date aDateMin(1,1,1989);
//STRIP001 	Time aTMin(0);
//STRIP001 	Time aTMax(23,59,59);
//STRIP001 
//STRIP001 
//STRIP001 	DateTime aDTMin(aDateMin);
//STRIP001 	DateTime aDTMax(aDateMax);
//STRIP001 
//STRIP001 	switch(nDaTiMode)
//STRIP001 	{
//STRIP001 		case FLT_DATE_BEFORE:
//STRIP001 								aDaTiFilterFirst=aDTMin;
//STRIP001 								aDaTiFilterLast=aDaTiFirst;
//STRIP001 								break;
//STRIP001 		case FLT_DATE_SAVE:
//STRIP001 		case FLT_DATE_SINCE:
//STRIP001 								aDaTiFilterFirst=aDaTiFirst;
//STRIP001 								aDaTiFilterLast=aDTMax;
//STRIP001 								break;
//STRIP001 		case FLT_DATE_EQUAL:
//STRIP001 								aDaTiFilterFirst=aDaTiFirst;
//STRIP001 								aDaTiFilterLast=aDaTiFirst;
//STRIP001 								aDaTiFilterFirst.SetTime(aTMin.GetTime());
//STRIP001 								aDaTiFilterLast.SetTime(aTMax.GetTime());
//STRIP001 								break;
//STRIP001 		case FLT_DATE_NOTEQUAL:
//STRIP001 								aDaTiFilterFirst=aDaTiFirst;
//STRIP001 								aDaTiFilterLast=aDaTiFirst;
//STRIP001 								aDaTiFilterFirst.SetTime(aTMin.GetTime());
//STRIP001 								aDaTiFilterLast.SetTime(aTMax.GetTime());
//STRIP001 								break;
//STRIP001 		case FLT_DATE_BETWEEN:
//STRIP001 								aDaTiFilterFirst=aDaTiFirst;
//STRIP001 								aDaTiFilterLast=aDaTiLast;
//STRIP001 								break;
//STRIP001 	}
//STRIP001 }


//STRIP001 void SvxRedlinTable::SetFilterDate(BOOL bFlag)
//STRIP001 {
//STRIP001 	bDate=bFlag;
//STRIP001 }

//STRIP001 void SvxRedlinTable::SetDateTimeMode(USHORT nMode)
//STRIP001 {
//STRIP001 	nDaTiMode=nMode;
//STRIP001 }

//STRIP001 void SvxRedlinTable::SetFirstDate(const Date& aDate)
//STRIP001 {
//STRIP001 	aDaTiFirst.SetDate(aDate.GetDate());
//STRIP001 }

//STRIP001 void SvxRedlinTable::SetLastDate(const Date& aDate)
//STRIP001 {
//STRIP001 	aDaTiLast.SetDate(aDate.GetDate());
//STRIP001 }

//STRIP001 void SvxRedlinTable::SetFirstTime(const Time& aTime)
//STRIP001 {
//STRIP001 	aDaTiFirst.SetTime(aTime.GetTime());
//STRIP001 }

//STRIP001 void SvxRedlinTable::SetLastTime(const Time& aTime)
//STRIP001 {
//STRIP001 	aDaTiLast.SetTime(aTime.GetTime());
//STRIP001 }

//STRIP001 void SvxRedlinTable::SetFilterAuthor(BOOL bFlag)
//STRIP001 {
//STRIP001 	bAuthor=bFlag;
//STRIP001 }

//STRIP001 void SvxRedlinTable::SetAuthor(const String &aString)
//STRIP001 {
//STRIP001 	aAuthor=aString;
//STRIP001 }

//STRIP001 void SvxRedlinTable::SetFilterComment(BOOL bFlag)
//STRIP001 {
//STRIP001 	bComment=bFlag;
//STRIP001 }

//STRIP001 void SvxRedlinTable::SetCommentParams( const utl::SearchParam* pSearchPara )
//STRIP001 {
//STRIP001 	if(pSearchPara!=NULL)
//STRIP001 	{
//STRIP001 		if(pCommentSearcher!=NULL) delete pCommentSearcher;
//STRIP001 
//STRIP001 		pCommentSearcher=new utl::TextSearch(*pSearchPara, LANGUAGE_SYSTEM );
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL SvxRedlinTable::IsValidWriterEntry(const String& rString,RedlinData *pUserData)
//STRIP001 {
//STRIP001 	BOOL nTheFlag=TRUE;
//STRIP001 	String aString=rString.GetToken(WRITER_AUTHOR,'\t');
//STRIP001 	if(pUserData==NULL)
//STRIP001 	{
//STRIP001 		if(bAuthor)
//STRIP001 		{
//STRIP001 			if(aAuthor.CompareTo(aString)==COMPARE_EQUAL)
//STRIP001 				nTheFlag=TRUE;
//STRIP001 			else
//STRIP001 				nTheFlag=FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DateTime aDateTime=pUserData->aDateTime;
//STRIP001 		nTheFlag=IsValidEntry(&aString,&aDateTime);
//STRIP001 	}
//STRIP001 	return nTheFlag;
//STRIP001 }

//STRIP001 BOOL SvxRedlinTable::IsValidCalcEntry(const String& rString,RedlinData *pUserData)
//STRIP001 {
//STRIP001 	BOOL nTheFlag=TRUE;
//STRIP001 	String aString=rString.GetToken(CALC_AUTHOR,'\t');
//STRIP001 	if(pUserData==NULL)
//STRIP001 	{
//STRIP001 		if(bAuthor)
//STRIP001 		{
//STRIP001 			if(aAuthor.CompareTo(aString)==COMPARE_EQUAL)
//STRIP001 				nTheFlag=TRUE;
//STRIP001 			else
//STRIP001 				nTheFlag=FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DateTime aDateTime=pUserData->aDateTime;
//STRIP001 		nTheFlag=IsValidEntry(&aString,&aDateTime);
//STRIP001 	}
//STRIP001 	return nTheFlag;
//STRIP001 }

//STRIP001 BOOL SvxRedlinTable::IsValidEntry(const String* pAuthorStr,
//STRIP001 								  const DateTime *pDateTime,const String* pCommentStr)
//STRIP001 {
//STRIP001 	BOOL nTheFlag=TRUE;
//STRIP001 	if(bAuthor)
//STRIP001 	{
//STRIP001 		if(aAuthor.CompareTo(*pAuthorStr)==COMPARE_EQUAL)
//STRIP001 			nTheFlag=TRUE;
//STRIP001 		else
//STRIP001 			nTheFlag=FALSE;
//STRIP001 	}
//STRIP001 	if(bDate && nTheFlag)
//STRIP001 	{
//STRIP001 		if(nDaTiMode!=FLT_DATE_NOTEQUAL)
//STRIP001 		{
//STRIP001 			nTheFlag=pDateTime->IsBetween(aDaTiFilterFirst,aDaTiFilterLast);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nTheFlag=!(pDateTime->IsBetween(aDaTiFilterFirst,aDaTiFilterLast));
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if(bComment && nTheFlag)
//STRIP001 	{
//STRIP001 		xub_StrLen nStartPos = 0;
//STRIP001 		xub_StrLen nEndPos = pCommentStr->Len();
//STRIP001 
//STRIP001 		nTheFlag=pCommentSearcher->SearchFrwrd( *pCommentStr, &nStartPos, &nEndPos);
//STRIP001 	}
//STRIP001 	return nTheFlag;
//STRIP001 }

//STRIP001 BOOL SvxRedlinTable::IsValidEntry(const String* pAuthorStr,const DateTime *pDateTime)
//STRIP001 {
//STRIP001 	BOOL nTheFlag=TRUE;
//STRIP001 	if(bAuthor)
//STRIP001 	{
//STRIP001 		if(aAuthor.CompareTo(*pAuthorStr)==COMPARE_EQUAL)
//STRIP001 			nTheFlag=TRUE;
//STRIP001 		else
//STRIP001 			nTheFlag=FALSE;
//STRIP001 	}
//STRIP001 	if(bDate && nTheFlag)
//STRIP001 	{
//STRIP001 		if(nDaTiMode!=FLT_DATE_NOTEQUAL)
//STRIP001 		{
//STRIP001 			nTheFlag=pDateTime->IsBetween(aDaTiFilterFirst,aDaTiFilterLast);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nTheFlag=!(pDateTime->IsBetween(aDaTiFilterFirst,aDaTiFilterLast));
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return nTheFlag;
//STRIP001 }

//STRIP001 BOOL SvxRedlinTable::IsValidComment(const String* pCommentStr)
//STRIP001 {
//STRIP001 	BOOL nTheFlag=TRUE;
//STRIP001 
//STRIP001 	if(bComment)
//STRIP001 	{
//STRIP001 		xub_StrLen nStartPos = 0;
//STRIP001 		xub_StrLen nEndPos = pCommentStr->Len();
//STRIP001 
//STRIP001 		nTheFlag=pCommentSearcher->SearchFrwrd( *pCommentStr, &nStartPos, &nEndPos);
//STRIP001 	}
//STRIP001 	return nTheFlag;
//STRIP001 }

//STRIP001 SvLBoxEntry* SvxRedlinTable::InsertEntry(const String& rStr,RedlinData *pUserData,
//STRIP001 								SvLBoxEntry* pParent,ULONG nPos)
//STRIP001 {
//STRIP001 	aEntryColor=GetTextColor();
//STRIP001 	if(pUserData!=NULL)
//STRIP001 	{
//STRIP001 		if(pUserData->bDisabled)
//STRIP001 			aEntryColor=Color(COL_GRAY);
//STRIP001 	}
//STRIP001 
//STRIP001 	XubString aStr= rStr;
//STRIP001 
//STRIP001 	XubString aFirstStr( aStr );
//STRIP001 	xub_StrLen nEnd = aFirstStr.Search( sal_Unicode( '\t' ) );
//STRIP001 	if( nEnd != STRING_NOTFOUND )
//STRIP001 	{
//STRIP001 		aFirstStr.Erase( nEnd );
//STRIP001 		aCurEntry = aStr;
//STRIP001 		aCurEntry.Erase( 0, ++nEnd );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aCurEntry.Erase();
//STRIP001 
//STRIP001 	return SvTreeListBox::InsertEntry( aFirstStr, pParent, FALSE, nPos, pUserData );
//STRIP001 
//STRIP001 }

//STRIP001 SvLBoxEntry* SvxRedlinTable::InsertEntry(const String& rStr,RedlinData *pUserData,const Color& aColor,
//STRIP001 								SvLBoxEntry* pParent,ULONG nPos)
//STRIP001 {
//STRIP001 	aEntryColor=aColor;
//STRIP001 
//STRIP001 	XubString aStr= rStr;
//STRIP001 
//STRIP001 	XubString aFirstStr( aStr );
//STRIP001 	xub_StrLen nEnd = aFirstStr.Search( sal_Unicode ( '\t' ) );
//STRIP001 	if( nEnd != STRING_NOTFOUND )
//STRIP001 	{
//STRIP001 		aFirstStr.Erase( nEnd );
//STRIP001 		aCurEntry = aStr;
//STRIP001 		aCurEntry.Erase( 0, ++nEnd );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aCurEntry.Erase();
//STRIP001 
//STRIP001 	return SvTreeListBox::InsertEntry( aFirstStr, pParent, FALSE, nPos, pUserData );
//STRIP001 }

//STRIP001 SvLBoxEntry* SvxRedlinTable::CreateEntry() const
//STRIP001 {
//STRIP001 	return new SvxRedlinEntry;
//STRIP001 }

//STRIP001 void SvxRedlinTable::InitEntry( SvLBoxEntry* pEntry, const XubString& rStr,
//STRIP001 	const Image& rColl, const Image& rExp )
//STRIP001 {
//STRIP001 	SvLBoxButton* pButton;
//STRIP001 	SvLBoxString* pString;
//STRIP001 	SvLBoxContextBmp* pContextBmp;
//STRIP001 
//STRIP001 	if( nTreeFlags & TREEFLAG_CHKBTN )
//STRIP001 	{
//STRIP001 		pButton= new SvLBoxButton( pEntry,0,pCheckButtonData );
//STRIP001 		pEntry->AddItem( pButton );
//STRIP001 	}
//STRIP001 
//STRIP001 	pContextBmp= new SvLBoxContextBmp( pEntry,0, rColl,rExp,
//STRIP001 									 SVLISTENTRYFLAG_EXPANDED);
//STRIP001 	pEntry->AddItem( pContextBmp );
//STRIP001 
//STRIP001 	pString = new SvLBoxColorString( pEntry, 0, rStr ,aEntryColor);
//STRIP001 	pEntry->AddItem( pString );
//STRIP001 
//STRIP001 	XubString aToken;
//STRIP001 
//STRIP001 	xub_Unicode* pCurToken = (xub_Unicode*)aCurEntry.GetBuffer();
//STRIP001 	USHORT nCurTokenLen;
//STRIP001 	xub_Unicode* pNextToken = (xub_Unicode*)GetToken( pCurToken, nCurTokenLen );
//STRIP001 	USHORT nCount = TabCount(); nCount--;
//STRIP001 
//STRIP001 	for( USHORT nToken = 0; nToken < nCount; nToken++ )
//STRIP001 	{
//STRIP001 		if( pCurToken && nCurTokenLen )
//STRIP001 			// aToken.Assign( pCurToken, nCurTokenLen );
//STRIP001 			aToken = XubString( pCurToken, nCurTokenLen );
//STRIP001 		else
//STRIP001 			aToken.Erase();
//STRIP001 
//STRIP001 		SvLBoxColorString* pStr = new SvLBoxColorString( pEntry, 0, aToken ,aEntryColor);
//STRIP001 		pEntry->AddItem( pStr );
//STRIP001 
//STRIP001 		pCurToken = pNextToken;
//STRIP001 		if( pCurToken )
//STRIP001 			pNextToken = (xub_Unicode*)GetToken( pCurToken, nCurTokenLen );
//STRIP001 		else
//STRIP001 			nCurTokenLen = 0;
//STRIP001 	}
//STRIP001 }




//============================================================================
//	class SvxTPView
//----------------------------------------------------------------------------

//STRIP001 SvxTPView::SvxTPView( Window * pParent)
//STRIP001 	: TabPage( pParent, SVX_RES(SID_REDLIN_VIEW_PAGE)),
//STRIP001 	aViewData	( this, ResId( DG_VIEW) ),
//STRIP001 	PbAccept	( this, ResId(PB_ACCEPT	 ) ),
//STRIP001 	PbAcceptAll	( this, ResId(PB_ACCEPTALL  ) ),
//STRIP001 	PbReject	( this, ResId(PB_REJECT	 ) ),
//STRIP001 	PbRejectAll	( this, ResId(PB_REJECTALL  ) ),
//STRIP001 	PbUndo		( this, ResId(PB_UNDO  ) ),
//STRIP001 	aTitle1		( ResId( STR_TITLE1 ) ),		// lokale Resource
//STRIP001 	aTitle2		( ResId( STR_TITLE2 ) ),
//STRIP001 	aTitle3		( ResId( STR_TITLE3 ) ),
//STRIP001 	aTitle4		( ResId( STR_TITLE4 ) ),
//STRIP001 	aTitle5		( ResId( STR_TITLE5 ) ),
//STRIP001 	aStrMyName	( ResId( STR_VIEW) )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001     aViewData.SetHelpId(HID_REDLINING_VIEW_DG_VIEW_TABLE);
//STRIP001     aViewData.SetHeaderBarHelpId(HID_REDLINING_VIEW_DG_VIEW_HEADER);
//STRIP001 
//STRIP001 	aMinSize=GetSizePixel();
//STRIP001 
//STRIP001 	Link aLink=LINK( this, SvxTPView, PbClickHdl);
//STRIP001 
//STRIP001 	PbAccept.SetClickHdl(aLink);
//STRIP001 	PbAcceptAll.SetClickHdl(aLink);
//STRIP001 	PbReject.SetClickHdl(aLink);
//STRIP001 	PbRejectAll.SetClickHdl(aLink);
//STRIP001 	PbUndo.SetClickHdl(aLink);
//STRIP001 
//STRIP001 	long nSize=(aViewData.GetOutputSizePixel().Width())/5;
//STRIP001 	nDistance=PbAccept.GetSizePixel().Height()+2*MIN_DISTANCE;
//STRIP001 	aViewData.SetTabs(nStaticTabs);
//STRIP001 }

//STRIP001 String SvxTPView::GetMyName() const
//STRIP001 {
//STRIP001 	return aStrMyName;
//STRIP001 }

//STRIP001 void SvxTPView::Resize()
//STRIP001 {
//STRIP001 	Size aSize=GetOutputSizePixel();
//STRIP001 	Point aPos=aViewData.GetPosPixel();
//STRIP001 	aSize.Height()-=aPos.Y()+nDistance;
//STRIP001 	aSize.Width()-=2*aPos.X();
//STRIP001 
//STRIP001 	USHORT newY=aPos.Y()+aSize.Height()+MIN_DISTANCE;
//STRIP001 	aPos=PbAccept.GetPosPixel();
//STRIP001 	aPos.Y()=newY;
//STRIP001 	PbAccept.SetPosPixel(aPos);
//STRIP001 	aPos=PbAcceptAll.GetPosPixel();
//STRIP001 	aPos.Y()=newY;
//STRIP001 	PbAcceptAll.SetPosPixel(aPos);
//STRIP001 	aPos=PbReject.GetPosPixel();
//STRIP001 	aPos.Y()=newY;
//STRIP001 	PbReject.SetPosPixel(aPos);
//STRIP001 	aPos=PbRejectAll.GetPosPixel();
//STRIP001 	aPos.Y()=newY;
//STRIP001 	PbRejectAll.SetPosPixel(aPos);
//STRIP001 
//STRIP001 	if(PbUndo.IsVisible())
//STRIP001 	{
//STRIP001 		aPos=PbUndo.GetPosPixel();
//STRIP001 		aPos.Y()=newY;
//STRIP001 		PbUndo.SetPosPixel(aPos);
//STRIP001 	}
//STRIP001 	aViewData.SetSizePixel(aSize);
//STRIP001 }

//STRIP001 void SvxTPView::InsertWriterHeader()
//STRIP001 {
//STRIP001 	String aStrTab(sal_Unicode('\t'));
//STRIP001 	String aString(aTitle1);
//STRIP001 	aString+=aStrTab;
//STRIP001 	aString+=aTitle3;
//STRIP001 	aString+=aStrTab;
//STRIP001 	aString+=aTitle4;
//STRIP001 	aString+=aStrTab;
//STRIP001 	aString+=aTitle5;
//STRIP001 	aViewData.ClearHeader();
//STRIP001 	aViewData.InsertHeaderEntry(aString);
//STRIP001 }

//STRIP001 void SvxTPView::InsertCalcHeader()
//STRIP001 {
//STRIP001 	String aStrTab(sal_Unicode('\t'));
//STRIP001 	String aString(aTitle1);
//STRIP001 	aString+=aStrTab;
//STRIP001 	aString+=aTitle2;
//STRIP001 	aString+=aStrTab;
//STRIP001 	aString+=aTitle3;
//STRIP001 	aString+=aStrTab;
//STRIP001 	aString+=aTitle4;
//STRIP001 	aString+=aStrTab;
//STRIP001 	aString+=aTitle5;
//STRIP001 	aViewData.ClearHeader();
//STRIP001 	aViewData.InsertHeaderEntry(aString);
//STRIP001 }

//STRIP001 void SvxTPView::EnableAccept(BOOL nFlag)
//STRIP001 {
//STRIP001 	PbAccept.Enable(nFlag);
//STRIP001 }

//STRIP001 void SvxTPView::EnableAcceptAll(BOOL nFlag)
//STRIP001 {
//STRIP001 	PbAcceptAll.Enable(nFlag);
//STRIP001 }

//STRIP001 void SvxTPView::EnableReject(BOOL nFlag)
//STRIP001 {
//STRIP001 	PbReject.Enable(nFlag);
//STRIP001 }

//STRIP001 void SvxTPView::EnableRejectAll(BOOL nFlag)
//STRIP001 {
//STRIP001 	PbRejectAll.Enable(nFlag);
//STRIP001 }

//STRIP001 void SvxTPView::ShowUndo(BOOL nFlag)
//STRIP001 {
//STRIP001 	PbUndo.Show(nFlag);
//STRIP001 }

//STRIP001 void SvxTPView::EnableUndo(BOOL nFlag)
//STRIP001 {
//STRIP001 	PbUndo.Enable(nFlag);
//STRIP001 }

//STRIP001 Size SvxTPView::GetMinSizePixel()
//STRIP001 {
//STRIP001 	Size aSize=aMinSize;
//STRIP001 	if(PbUndo.IsVisible())
//STRIP001 	{
//STRIP001 		ULONG nSize=PbUndo.GetSizePixel().Width()
//STRIP001 					+PbUndo.GetPosPixel().X()
//STRIP001 					+PbAccept.GetPosPixel().X();
//STRIP001 
//STRIP001 		aSize.Width()=nSize;
//STRIP001 	}
//STRIP001 
//STRIP001 	return aSize;
//STRIP001 }


//STRIP001 SvxRedlinTable* SvxTPView::GetTableControl()
//STRIP001 {
//STRIP001 	return &aViewData;
//STRIP001 }

//STRIP001 IMPL_LINK( SvxTPView, PbClickHdl, PushButton*, pPushB )
//STRIP001 {
//STRIP001 	if(pPushB==&PbAccept)
//STRIP001 	{
//STRIP001 		AcceptClickLk.Call(this);
//STRIP001 	}
//STRIP001 	else if(pPushB==&PbAcceptAll)
//STRIP001 	{
//STRIP001 		AcceptAllClickLk.Call(this);
//STRIP001 	}
//STRIP001 	else if(pPushB==&PbReject)
//STRIP001 	{
//STRIP001 		RejectClickLk.Call(this);
//STRIP001 	}
//STRIP001 	else if(pPushB==&PbRejectAll)
//STRIP001 	{
//STRIP001 		RejectAllClickLk.Call(this);
//STRIP001 	}
//STRIP001 	else if(pPushB==&PbUndo)
//STRIP001 	{
//STRIP001 		UndoClickLk.Call(this);
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }




//============================================================================
//	class SvxTPFilter
//----------------------------------------------------------------------------

//STRIP001 SvxTPFilter::SvxTPFilter( Window * pParent)
//STRIP001 	: TabPage( pParent, SVX_RES(SID_REDLIN_FILTER_PAGE)),
//STRIP001 	aCbDate		( this, ResId( CB_DATE ) ),
//STRIP001 	aLbDate		( this, ResId( LB_DATE ) ),
//STRIP001 	aDfDate		( this, ResId( DF_DATE ) ),
//STRIP001 	aTfDate		( this, ResId( TF_DATE ) ),
//STRIP001 	aIbClock 	( this, ResId( IB_CLOCK ) ),
//STRIP001 	aFtDate2	( this, ResId( FT_DATE2 ) ),
//STRIP001 	aDfDate2	( this, ResId( DF_DATE2 ) ),
//STRIP001 	aTfDate2	( this, ResId( TF_DATE2 ) ),
//STRIP001 	aIbClock2 	( this, ResId( IB_CLOCK2) ),
//STRIP001 	aCbAuthor	( this, ResId( CB_AUTOR ) ),
//STRIP001 	aLbAuthor	( this, ResId( LB_AUTOR ) ),
//STRIP001 	aCbRange 	( this, ResId( CB_RANGE ) ),
//STRIP001 	aEdRange 	( this, ResId( ED_RANGE ) ),
//STRIP001 	aBtnRange 	( this, ResId( BTN_REF ) ),
//STRIP001 	aLbAction	( this, ResId( LB_ACTION ) ),
//STRIP001 	aCbComment	( this, ResId( CB_COMMENT) ),
//STRIP001 	aEdComment	( this, ResId( ED_COMMENT) ),
//STRIP001 	aStrMyName	(		ResId( STR_FILTER) ),
//STRIP001 	aActionStr  (		ResId( STR_ACTION) ),
//STRIP001 	bModified	(FALSE),
//STRIP001 	pRedlinTable(NULL)
//STRIP001 {
//STRIP001     Image aImgTimeHC( ResId( IMG_TIME_H ) );
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001     aIbClock.SetModeImage( aImgTimeHC, BMP_COLOR_HIGHCONTRAST );
//STRIP001     aIbClock2.SetModeImage( aImgTimeHC, BMP_COLOR_HIGHCONTRAST );
//STRIP001 
//STRIP001 	aDfDate.SetShowDateCentury( TRUE );
//STRIP001 	aDfDate2.SetShowDateCentury( TRUE );
//STRIP001 
//STRIP001 	aRangeStr=aCbRange.GetText();
//STRIP001 	aLbDate.SelectEntryPos(0);
//STRIP001 	aLbDate.SetSelectHdl( LINK( this, SvxTPFilter, SelDateHdl ) );
//STRIP001 	aIbClock.SetClickHdl( LINK( this, SvxTPFilter, TimeHdl) );
//STRIP001 	aIbClock2.SetClickHdl( LINK( this, SvxTPFilter,TimeHdl) );
//STRIP001 	aBtnRange.SetClickHdl( LINK( this, SvxTPFilter, RefHandle));
//STRIP001 
//STRIP001 	Link aLink=LINK( this, SvxTPFilter, RowEnableHdl) ;
//STRIP001 	aCbDate.SetClickHdl(aLink);
//STRIP001 	aCbAuthor.SetClickHdl(aLink);
//STRIP001 	aCbRange.SetClickHdl(aLink);
//STRIP001 	aCbComment.SetClickHdl(aLink);
//STRIP001 
//STRIP001 	Link a2Link=LINK( this, SvxTPFilter, ModifyDate);
//STRIP001 	aDfDate.SetModifyHdl(a2Link);
//STRIP001 	aTfDate.SetModifyHdl(a2Link);
//STRIP001 	aDfDate2.SetModifyHdl(a2Link);
//STRIP001 	aTfDate2.SetModifyHdl(a2Link);
//STRIP001 
//STRIP001 	Link a3Link=LINK( this, SvxTPFilter, ModifyHdl);
//STRIP001 	aEdRange.SetModifyHdl(a3Link);
//STRIP001 	aEdComment.SetModifyHdl(a3Link);
//STRIP001 	aLbAction.SetSelectHdl(a3Link);
//STRIP001 	aLbAuthor.SetSelectHdl(a3Link);
//STRIP001 
//STRIP001 	RowEnableHdl(&aCbDate);
//STRIP001 	RowEnableHdl(&aCbAuthor);
//STRIP001 	RowEnableHdl(&aCbRange);
//STRIP001 	RowEnableHdl(&aCbComment);
//STRIP001 
//STRIP001 	Date aDate;
//STRIP001 	Time aTime;
//STRIP001 	aDfDate.SetDate(aDate);
//STRIP001 	aTfDate.SetTime(aTime);
//STRIP001 	aDfDate2.SetDate(aDate);
//STRIP001 	aTfDate2.SetTime(aTime);
//STRIP001 	HideRange();
//STRIP001 	ShowAction();
//STRIP001 	bModified=FALSE;
//STRIP001 }

//STRIP001 void SvxTPFilter::SetRedlinTable(SvxRedlinTable* pTable)
//STRIP001 {
//STRIP001 	pRedlinTable=pTable;
//STRIP001 }

//STRIP001 String SvxTPFilter::GetMyName() const
//STRIP001 {
//STRIP001 	return aStrMyName;
//STRIP001 }

//STRIP001 void SvxTPFilter::DisableRange(BOOL bFlag)
//STRIP001 {
//STRIP001 	if(bFlag)
//STRIP001 	{
//STRIP001 		aCbRange.Disable();
//STRIP001 		aEdRange.Disable();
//STRIP001 		aBtnRange.Disable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aCbRange.Enable();
//STRIP001 		aEdRange.Enable();
//STRIP001 		aBtnRange.Enable();
//STRIP001 	}
//STRIP001 }

//STRIP001 void SvxTPFilter::ShowDateFields(USHORT nKind)
//STRIP001 {
//STRIP001 	String aEmpty;
//STRIP001 	switch(nKind)
//STRIP001 	{
//STRIP001 		case FLT_DATE_BEFORE:
//STRIP001 				EnableDateLine1(TRUE);
//STRIP001 				EnableDateLine2(FALSE);
//STRIP001 				break;
//STRIP001 		case FLT_DATE_SINCE:
//STRIP001 				EnableDateLine1(TRUE);
//STRIP001 				EnableDateLine2(FALSE);
//STRIP001 				break;
//STRIP001 		case FLT_DATE_EQUAL:
//STRIP001 				EnableDateLine1(TRUE);
//STRIP001 				aTfDate.Disable();
//STRIP001 				aTfDate.SetText(aEmpty);
//STRIP001 				EnableDateLine2(FALSE);
//STRIP001 				break;
//STRIP001 		case FLT_DATE_NOTEQUAL:
//STRIP001 				EnableDateLine1(TRUE);
//STRIP001 				aTfDate.Disable();
//STRIP001 				aTfDate.SetText(aEmpty);
//STRIP001 				EnableDateLine2(FALSE);
//STRIP001 				break;
//STRIP001 		case FLT_DATE_BETWEEN:
//STRIP001 				EnableDateLine1(TRUE);
//STRIP001 				EnableDateLine2(TRUE);
//STRIP001 				break;
//STRIP001 		case FLT_DATE_SAVE:
//STRIP001 				EnableDateLine1(FALSE);
//STRIP001 				EnableDateLine2(FALSE);
//STRIP001 				break;
//STRIP001 	}
//STRIP001 }

//STRIP001 void SvxTPFilter::EnableDateLine1(BOOL bFlag)
//STRIP001 {
//STRIP001 	if(bFlag && aCbDate.IsChecked())
//STRIP001 	{
//STRIP001 		aDfDate.Enable();
//STRIP001 		aTfDate.Enable();
//STRIP001 		aIbClock.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aDfDate.Disable();
//STRIP001 		aTfDate.Disable();
//STRIP001 		aIbClock.Disable();
//STRIP001 	}
//STRIP001 }
//STRIP001 void SvxTPFilter::EnableDateLine2(BOOL bFlag)
//STRIP001 {
//STRIP001 	String aEmpty;
//STRIP001 	if(bFlag && aCbDate.IsChecked())
//STRIP001 	{
//STRIP001 		aFtDate2.Enable();
//STRIP001 		aDfDate2.Enable();
//STRIP001 		aTfDate2.Enable();
//STRIP001 		aIbClock2.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aFtDate2.Disable();
//STRIP001 		aDfDate2.Disable();
//STRIP001 		aDfDate2.SetText(aEmpty);
//STRIP001 		aTfDate2.Disable();
//STRIP001 		aTfDate2.SetText(aEmpty);
//STRIP001 		aIbClock2.Disable();
//STRIP001 	}
//STRIP001 }

//STRIP001 Date SvxTPFilter::GetFirstDate() const
//STRIP001 {
//STRIP001 	return aDfDate.GetDate();
//STRIP001 }

//STRIP001 void SvxTPFilter::SetFirstDate(const Date &aDate)
//STRIP001 {
//STRIP001 	aDfDate.SetDate(aDate);
//STRIP001 }

//STRIP001 Time SvxTPFilter::GetFirstTime() const
//STRIP001 {
//STRIP001 	return aTfDate.GetTime();
//STRIP001 }

//STRIP001 void SvxTPFilter::SetFirstTime(const Time &aTime)
//STRIP001 {
//STRIP001 	aTfDate.SetTime(aTime);
//STRIP001 }


//STRIP001 Date SvxTPFilter::GetLastDate() const
//STRIP001 {
//STRIP001 	return aDfDate2.GetDate();
//STRIP001 }

//STRIP001 void SvxTPFilter::SetLastDate(const Date &aDate)
//STRIP001 {
//STRIP001 	aDfDate2.SetDate(aDate);
//STRIP001 }

//STRIP001 Time SvxTPFilter::GetLastTime() const
//STRIP001 {
//STRIP001 	return aTfDate2.GetTime();
//STRIP001 }

//STRIP001 void SvxTPFilter::SetLastTime(const Time &aTime)
//STRIP001 {
//STRIP001 	aTfDate2.SetTime(aTime);
//STRIP001 }

//STRIP001 void SvxTPFilter::SetDateMode(USHORT nMode)
//STRIP001 {
//STRIP001 	aLbDate.SelectEntryPos(nMode);
//STRIP001 	SelDateHdl(&aLbDate);
//STRIP001 }

//STRIP001 USHORT SvxTPFilter::GetDateMode()
//STRIP001 {
//STRIP001 	return (USHORT) aLbDate.GetSelectEntryPos();
//STRIP001 }
//STRIP001 void SvxTPFilter::ClearAuthors()
//STRIP001 {
//STRIP001 	aLbAuthor.Clear();
//STRIP001 }

//STRIP001 void SvxTPFilter::InsertAuthor( const String& rString, USHORT nPos)
//STRIP001 {
//STRIP001 	aLbAuthor.InsertEntry(rString,nPos);
//STRIP001 }

//STRIP001 String SvxTPFilter::GetSelectedAuthor()	const
//STRIP001 {
//STRIP001 	return aLbAuthor.GetSelectEntry();
//STRIP001 }

//STRIP001 USHORT	SvxTPFilter::GetSelectedAuthorPos()
//STRIP001 {
//STRIP001 	return (USHORT) aLbAuthor.GetSelectEntryPos();
//STRIP001 }

//STRIP001 void SvxTPFilter::SelectedAuthorPos(USHORT nPos)
//STRIP001 {
//STRIP001 	aLbAuthor.SelectEntryPos(nPos);
//STRIP001 }

//STRIP001 USHORT SvxTPFilter::SelectAuthor(const String& aString)
//STRIP001 {
//STRIP001 	aLbAuthor.SelectEntry(aString);
//STRIP001 	return aLbAuthor.GetSelectEntryPos();
//STRIP001 }

//STRIP001 void SvxTPFilter::SetRange(const String& rString)
//STRIP001 {
//STRIP001 	aEdRange.SetText(rString);
//STRIP001 }

//STRIP001 String SvxTPFilter::GetRange() const
//STRIP001 {
//STRIP001 	return aEdRange.GetText();
//STRIP001 }

//STRIP001 void SvxTPFilter::SetFocusToRange()
//STRIP001 {
//STRIP001 	aEdRange.GrabFocus();
//STRIP001 }

//STRIP001 void SvxTPFilter::HideRange(BOOL bHide)
//STRIP001 {
//STRIP001 	if(bHide)
//STRIP001 	{
//STRIP001 		aCbRange.Hide();
//STRIP001 		aEdRange.Hide();
//STRIP001 		aBtnRange.Hide();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		ShowAction(FALSE);
//STRIP001 		aCbRange.SetText(aRangeStr);
//STRIP001 		aCbRange.Show();
//STRIP001 		aEdRange.Show();
//STRIP001 		aBtnRange.Show();
//STRIP001 	}
//STRIP001 }

//STRIP001 void SvxTPFilter::HideClocks(BOOL bHide)
//STRIP001 {
//STRIP001 	if(bHide)
//STRIP001 	{
//STRIP001 		aIbClock. Hide();
//STRIP001 		aIbClock2.Hide();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aIbClock. Show();
//STRIP001 		aIbClock2.Show();
//STRIP001 	}
//STRIP001 }

//STRIP001 void SvxTPFilter::SetComment(const String &rComment)
//STRIP001 {
//STRIP001 	aEdComment.SetText(rComment);
//STRIP001 }
//STRIP001 String SvxTPFilter::GetComment()const
//STRIP001 {
//STRIP001 	return aEdComment.GetText();
//STRIP001 }

//STRIP001 BOOL SvxTPFilter::IsDate()
//STRIP001 {
//STRIP001 	return aCbDate.IsChecked();
//STRIP001 }

//STRIP001 BOOL SvxTPFilter::IsAuthor()
//STRIP001 {
//STRIP001 	return aCbAuthor.IsChecked();
//STRIP001 }

//STRIP001 BOOL SvxTPFilter::IsRange()
//STRIP001 {
//STRIP001 	return aCbRange.IsChecked();
//STRIP001 }
//STRIP001 BOOL SvxTPFilter::IsAction()
//STRIP001 {
//STRIP001 	return aCbRange.IsChecked();
//STRIP001 }

//STRIP001 BOOL SvxTPFilter::IsComment()
//STRIP001 {
//STRIP001 	return aCbComment.IsChecked();
//STRIP001 }

//STRIP001 void SvxTPFilter::CheckDate(BOOL bFlag)
//STRIP001 {
//STRIP001 	aCbDate.Check(bFlag);
//STRIP001 	RowEnableHdl(&aCbDate);
//STRIP001 	bModified=FALSE;
//STRIP001 }

//STRIP001 void SvxTPFilter::CheckAuthor(BOOL bFlag)
//STRIP001 {
//STRIP001 	aCbAuthor.Check(bFlag);
//STRIP001 	RowEnableHdl(&aCbAuthor);
//STRIP001 	bModified=FALSE;
//STRIP001 }

//STRIP001 void SvxTPFilter::CheckRange(BOOL bFlag)
//STRIP001 {
//STRIP001 	aCbRange.Check(bFlag);
//STRIP001 	RowEnableHdl(&aCbRange);
//STRIP001 	bModified=FALSE;
//STRIP001 }

//STRIP001 void SvxTPFilter::CheckAction(BOOL bFlag)
//STRIP001 {
//STRIP001 	aCbRange.Check(bFlag);
//STRIP001 	RowEnableHdl(&aCbRange);
//STRIP001 	bModified=FALSE;
//STRIP001 }

//STRIP001 void SvxTPFilter::CheckComment(BOOL bFlag)
//STRIP001 {
//STRIP001 	aCbComment.Check(bFlag);
//STRIP001 	RowEnableHdl(&aCbComment);
//STRIP001 	bModified=FALSE;
//STRIP001 }

//STRIP001 void SvxTPFilter::ShowAction(BOOL bShow)
//STRIP001 {
//STRIP001 	if(!bShow)
//STRIP001 	{
//STRIP001 		aCbRange.Hide();
//STRIP001 		aLbAction.Hide();
//STRIP001 		aCbRange.SetHelpId(HID_REDLINING_FILTER_CB_RANGE);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		HideRange();
//STRIP001 		aCbRange.SetText(aActionStr);
//STRIP001 		aCbRange.SetHelpId(HID_REDLINING_FILTER_CB_ACTION);
//STRIP001 		aCbRange.Show();
//STRIP001 		aLbAction.Show();
//STRIP001 
//STRIP001 	}
//STRIP001 }

//STRIP001 ListBox* SvxTPFilter::GetLbAction()
//STRIP001 {
//STRIP001 	return &aLbAction;
//STRIP001 }

//STRIP001 IMPL_LINK( SvxTPFilter, SelDateHdl, ListBox*, pLb )
//STRIP001 {
//STRIP001 	ShowDateFields((USHORT)aLbDate.GetSelectEntryPos());
//STRIP001 	ModifyHdl(pLb);
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 IMPL_LINK( SvxTPFilter, RowEnableHdl, CheckBox*, pCB )
//STRIP001 {
//STRIP001 	if(pCB==&aCbDate)
//STRIP001 	{
//STRIP001 		aLbDate.Enable(aCbDate.IsChecked());
//STRIP001 		aLbDate.Invalidate();
//STRIP001 		EnableDateLine1(FALSE);
//STRIP001 		EnableDateLine2(FALSE);
//STRIP001 		if(aCbDate.IsChecked()) SelDateHdl(&aLbDate);
//STRIP001 	}
//STRIP001 	else if(pCB==&aCbAuthor)
//STRIP001 	{
//STRIP001 		aLbAuthor.Enable(aCbAuthor.IsChecked());
//STRIP001 		aLbAuthor.Invalidate();
//STRIP001 	}
//STRIP001 	else if(pCB==&aCbRange)
//STRIP001 	{
//STRIP001 		aLbAction.Enable(aCbRange.IsChecked());
//STRIP001 		aLbAction.Invalidate();
//STRIP001 		aEdRange.Enable(aCbRange.IsChecked());
//STRIP001 		aBtnRange.Enable(aCbRange.IsChecked());
//STRIP001 	}
//STRIP001 	else if(pCB==&aCbComment)
//STRIP001 	{
//STRIP001 		aEdComment.Enable(aCbComment.IsChecked());
//STRIP001 		aEdComment.Invalidate();
//STRIP001 	}
//STRIP001 
//STRIP001 	ModifyHdl(pCB);
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 IMPL_LINK( SvxTPFilter, TimeHdl, ImageButton*,pIB )
//STRIP001 {
//STRIP001 	Date aDate;
//STRIP001 	Time aTime;
//STRIP001 	if(pIB==&aIbClock)
//STRIP001 	{
//STRIP001 		aDfDate.SetDate(aDate);
//STRIP001 		aTfDate.SetTime(aTime);
//STRIP001 	}
//STRIP001 	else if(pIB==&aIbClock2)
//STRIP001 	{
//STRIP001 		aDfDate2.SetDate(aDate);
//STRIP001 		aTfDate2.SetTime(aTime);
//STRIP001 	}
//STRIP001 	ModifyHdl(&aDfDate);
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 IMPL_LINK( SvxTPFilter, ModifyHdl, void*, pCtr)
//STRIP001 {
//STRIP001 	if(pCtr!=NULL)
//STRIP001 	{
//STRIP001 		if(pCtr==&aCbDate  || pCtr==&aLbDate ||
//STRIP001 		   pCtr==&aDfDate  || pCtr==&aTfDate ||
//STRIP001 		   pCtr==&aIbClock || pCtr==&aFtDate2||
//STRIP001 		   pCtr==&aDfDate2 || pCtr==&aTfDate2||
//STRIP001 		   pCtr==&aIbClock2)
//STRIP001 		{
//STRIP001 			aModifyDateLink.Call(this);
//STRIP001 		}
//STRIP001 		else if(pCtr==&aCbAuthor || pCtr==&aLbAuthor)
//STRIP001 		{
//STRIP001 			aModifyAuthorLink.Call(this);
//STRIP001 		}
//STRIP001 		else if(pCtr==&aCbRange  || pCtr==&aEdRange ||
//STRIP001 				pCtr==&aBtnRange )
//STRIP001 		{
//STRIP001 			aModifyRefLink.Call(this);
//STRIP001 		}
//STRIP001 		else if(pCtr==&aCbComment || pCtr==&aEdComment)
//STRIP001 		{
//STRIP001 			aModifyComLink.Call(this);
//STRIP001 		}
//STRIP001 
//STRIP001 		bModified=TRUE;
//STRIP001 		aModifyLink.Call(this);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 void SvxTPFilter::DeactivatePage()
//STRIP001 {
//STRIP001 	if(bModified)
//STRIP001 	{
//STRIP001 		if(pRedlinTable!=NULL)
//STRIP001 		{
//STRIP001 			pRedlinTable->SetFilterDate(IsDate());
//STRIP001 			pRedlinTable->SetDateTimeMode(GetDateMode());
//STRIP001 			pRedlinTable->SetFirstDate(aDfDate.GetDate());
//STRIP001 			pRedlinTable->SetLastDate(aDfDate2.GetDate());
//STRIP001 			pRedlinTable->SetFirstTime(aTfDate.GetTime());
//STRIP001 			pRedlinTable->SetLastTime(aTfDate2.GetTime());
//STRIP001 			pRedlinTable->SetFilterAuthor(IsAuthor());
//STRIP001 			pRedlinTable->SetAuthor(GetSelectedAuthor());
//STRIP001 
//STRIP001 			pRedlinTable->SetFilterComment(IsComment());
//STRIP001 
//STRIP001 			utl::SearchParam aSearchParam( aEdComment.GetText(),
//STRIP001 					utl::SearchParam::SRCH_REGEXP,FALSE,FALSE,FALSE );
//STRIP001 
//STRIP001 			pRedlinTable->SetCommentParams(&aSearchParam);
//STRIP001 
//STRIP001 			pRedlinTable->UpdateFilterTest();
//STRIP001 		}
//STRIP001 
//STRIP001 		aReadyLink.Call(this);
//STRIP001 	}
//STRIP001 	bModified=FALSE;
//STRIP001 	TabPage::DeactivatePage();
//STRIP001 }

//STRIP001 void SvxTPFilter::Enable( BOOL bEnable, BOOL bChild)
//STRIP001 {
//STRIP001 	TabPage::Enable(bEnable,bChild);
//STRIP001 	if(aCbDate.IsEnabled())
//STRIP001 	{
//STRIP001 		RowEnableHdl(&aCbDate);
//STRIP001 		RowEnableHdl(&aCbAuthor);
//STRIP001 		RowEnableHdl(&aCbRange);
//STRIP001 		RowEnableHdl(&aCbComment);
//STRIP001 	}
//STRIP001 }
//STRIP001 void SvxTPFilter::Disable( BOOL bChild)
//STRIP001 {
//STRIP001 	Enable( FALSE, bChild );
//STRIP001 }

//STRIP001 IMPL_LINK( SvxTPFilter, ModifyDate, void*,pTF)
//STRIP001 {
//STRIP001 
//STRIP001 	Date aDate;
//STRIP001 	Time aTime(0);
//STRIP001 	if(&aDfDate==pTF)
//STRIP001 	{
//STRIP001 		if(aDfDate.GetText().Len()==0)
//STRIP001 		   aDfDate.SetDate(aDate);
//STRIP001 
//STRIP001 		if(pRedlinTable!=NULL)
//STRIP001 			pRedlinTable->SetFirstDate(aDfDate.GetDate());
//STRIP001 	}
//STRIP001 	else if(&aDfDate2==pTF)
//STRIP001 	{
//STRIP001 		if(aDfDate2.GetText().Len()==0)
//STRIP001 		   aDfDate2.SetDate(aDate);
//STRIP001 
//STRIP001 		if(pRedlinTable!=NULL)
//STRIP001 			pRedlinTable->SetLastDate(aDfDate2.GetDate());
//STRIP001 	}
//STRIP001 	else if(&aTfDate==pTF)
//STRIP001 	{
//STRIP001 		if(aTfDate.GetText().Len()==0)
//STRIP001 		   aTfDate.SetTime(aTime);
//STRIP001 
//STRIP001 		if(pRedlinTable!=NULL)
//STRIP001 			pRedlinTable->SetFirstTime(aTfDate.GetTime());
//STRIP001 	}
//STRIP001 	else if(&aTfDate2==pTF)
//STRIP001 	{
//STRIP001 		if(aTfDate2.GetText().Len()==0)
//STRIP001 		   aTfDate2.SetTime(aTime);
//STRIP001 
//STRIP001 		if(pRedlinTable!=NULL)
//STRIP001 			pRedlinTable->SetLastTime(aTfDate2.GetTime());
//STRIP001 
//STRIP001 	}
//STRIP001 	ModifyHdl(&aDfDate);
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 IMPL_LINK( SvxTPFilter, RefHandle, PushButton*, pRef )
//STRIP001 {
//STRIP001 	if(pRef!=NULL)
//STRIP001 	{
//STRIP001 		aRefLink.Call(this);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 static Size gDiffSize;
//============================================================================
//	class SvxAcceptChgCtr
//----------------------------------------------------------------------------

//STRIP001 SvxAcceptChgCtr::SvxAcceptChgCtr( Window* pParent, WinBits nWinStyle)
//STRIP001 		:	Control(pParent,nWinStyle |WB_DIALOGCONTROL),
//STRIP001 			aTCAccept(this,WB_TABSTOP |WB_DIALOGCONTROL)
//STRIP001 {
//STRIP001 	pTPFilter=new SvxTPFilter(&aTCAccept);
//STRIP001 	pTPView=new SvxTPView(&aTCAccept);
//STRIP001 	aMinSize=pTPView->GetMinSizePixel();
//STRIP001 
//STRIP001 	aTCAccept.InsertPage( TP_VIEW,	 pTPView->GetMyName());
//STRIP001 	aTCAccept.InsertPage( TP_FILTER, pTPFilter->GetMyName());
//STRIP001 	aTCAccept.SetTabPage( TP_VIEW,	 pTPView);
//STRIP001 	aTCAccept.SetTabPage( TP_FILTER, pTPFilter);
//STRIP001 	aTCAccept.SetHelpId(HID_REDLINING_TABCONTROL);
//STRIP001 
//STRIP001 	aTCAccept.SetTabPageSizePixel(aMinSize);
//STRIP001 	Size aSize=aTCAccept.GetSizePixel();
//STRIP001 
//STRIP001 	gDiffSize.Height()=aSize.Height()-aMinSize.Height();
//STRIP001 	gDiffSize.Width()=aSize.Width()-aMinSize.Width();
//STRIP001 
//STRIP001 
//STRIP001 	pTPFilter->SetRedlinTable(GetViewTable());
//STRIP001 
//STRIP001 	aTCAccept.Show();
//STRIP001 	ShowViewPage();
//STRIP001 }

//STRIP001 SvxAcceptChgCtr::SvxAcceptChgCtr( Window* pParent, const ResId& rResId )
//STRIP001 		:	Control(pParent,rResId ),
//STRIP001 			aTCAccept(this,WB_TABSTOP |WB_DIALOGCONTROL)
//STRIP001 {
//STRIP001 	pTPFilter=new SvxTPFilter(&aTCAccept);
//STRIP001 	pTPView=new SvxTPView(&aTCAccept);
//STRIP001 	aMinSize=pTPView->GetMinSizePixel();
//STRIP001 
//STRIP001 	aTCAccept.InsertPage( TP_VIEW,	 pTPView->GetMyName());
//STRIP001 	aTCAccept.InsertPage( TP_FILTER, pTPFilter->GetMyName());
//STRIP001 	aTCAccept.SetTabPage( TP_VIEW,	 pTPView);
//STRIP001 	aTCAccept.SetTabPage( TP_FILTER, pTPFilter);
//STRIP001 	aTCAccept.SetHelpId(HID_REDLINING_TABCONTROL);
//STRIP001 
//STRIP001 	aTCAccept.SetTabPageSizePixel(aMinSize);
//STRIP001 	Size aSize=aTCAccept.GetSizePixel();
//STRIP001 
//STRIP001 	gDiffSize.Height()=aSize.Height()-aMinSize.Height();
//STRIP001 	gDiffSize.Width()=aSize.Width()-aMinSize.Width();
//STRIP001 
//STRIP001 
//STRIP001 	pTPFilter->SetRedlinTable(GetViewTable());
//STRIP001 	WinBits nWinStyle=GetStyle()|WB_DIALOGCONTROL;
//STRIP001 	SetStyle(nWinStyle);
//STRIP001 
//STRIP001 	aTCAccept.Show();
//STRIP001 	ShowViewPage();
//STRIP001 	Resize();
//STRIP001 }

//STRIP001 SvxAcceptChgCtr::~SvxAcceptChgCtr()
//STRIP001 {
//STRIP001 	delete pTPView;
//STRIP001 	delete pTPFilter;
//STRIP001 }

//STRIP001 void SvxAcceptChgCtr::Resize()
//STRIP001 {
//STRIP001 	aMinSize=pTPView->GetMinSizePixel();
//STRIP001 	Size aSize=GetOutputSizePixel();
//STRIP001 	BOOL bFlag=FALSE;
//STRIP001 
//STRIP001 	if(aMinSize.Height()>aSize.Height())
//STRIP001 	{
//STRIP001 		aSize.Height()=aMinSize.Height();
//STRIP001 		bFlag=TRUE;
//STRIP001 	}
//STRIP001 	if(aMinSize.Width()>aSize.Width())
//STRIP001 	{
//STRIP001 		aSize.Width()=aMinSize.Width();
//STRIP001 		bFlag=TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if(bFlag)
//STRIP001 	{
//STRIP001 		SetOutputSizePixel(aSize);
//STRIP001 		aMinSizeLink.Call(this);
//STRIP001 	}
//STRIP001 
//STRIP001 	aSize.Height()-=2;
//STRIP001 	aSize.Width()-=2;
//STRIP001 	aTCAccept.SetSizePixel(aSize);
//STRIP001 }

//STRIP001 Size SvxAcceptChgCtr::GetMinSizePixel() const
//STRIP001 {
//STRIP001 	Size aSize=pTPView->GetMinSizePixel();
//STRIP001 	aSize.Height()+=gDiffSize.Height();
//STRIP001 	aSize.Width()+=gDiffSize.Width();
//STRIP001 	return aSize;
//STRIP001 }

//STRIP001 void SvxAcceptChgCtr::ShowFilterPage()
//STRIP001 {
//STRIP001 	aTCAccept.SetCurPageId(TP_FILTER);
//STRIP001 }

//STRIP001 void SvxAcceptChgCtr::ShowViewPage()
//STRIP001 {
//STRIP001 	aTCAccept.SetCurPageId(TP_VIEW);
//STRIP001 }

//STRIP001 BOOL SvxAcceptChgCtr::IsFilterPageVisible()
//STRIP001 {
//STRIP001 	return (aTCAccept.GetCurPageId()==TP_FILTER);
//STRIP001 }

//STRIP001 BOOL SvxAcceptChgCtr::IsViewPageVisible()
//STRIP001 {
//STRIP001 	return (aTCAccept.GetCurPageId()==TP_VIEW);
//STRIP001 }

//STRIP001 SvxTPFilter* SvxAcceptChgCtr::GetFilterPage()
//STRIP001 {
//STRIP001 	return pTPFilter;
//STRIP001 }

//STRIP001 SvxTPView* SvxAcceptChgCtr::GetViewPage()
//STRIP001 {
//STRIP001 	return pTPView;
//STRIP001 }

//STRIP001 SvxRedlinTable* SvxAcceptChgCtr::GetViewTable()
//STRIP001 {
//STRIP001 	if(pTPView!=NULL)
//STRIP001 	{
//STRIP001 		return pTPView->GetTableControl();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		return NULL;
//STRIP001 	}
//STRIP001 }


}
