/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_mailcfg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:41:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_EXCEPTION_HPP_
#include <com/sun/star/uno/Exception.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYCHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertyChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCONFIGMANAGER_HPP_
#include <com/sun/star/frame/XConfigManager.hpp>
#endif
#ifndef _COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HPP_
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#endif

#if SUPD>569
#include <unotools/processfactory.hxx>
#else
#include <usr/ustring.hxx>
#include <chaos/cntbase.hxx>

#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif

// fehlt im header usr/smartservices.hxx!
//STRIP002 namespace usr
//STRIP002 {
//STRIP002 	Reference< XMultiServiceFactory > getProcessServiceFactory();
//STRIP002 }
#endif

#pragma hdrstop

#include "config.hrc"
#include "mailcfg.hxx"
#include "sfxtypes.hxx"
namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::registry;

#define VERSION 1

class SfxMailConfig_Impl : public ::cppu::WeakImplHelper1< XPropertyChangeListener >
{
public:
    Reference < XConfigManager >    xIni;
    String                          aMailPassword;
    SfxMailConfig*                  pConfigItem;
    virtual void SAL_CALL propertyChange( const PropertyChangeEvent& evt ) throw( ::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL disposing( const EventObject& obj ) throw( ::com::sun::star::uno::RuntimeException);
};

void SAL_CALL SfxMailConfig_Impl::propertyChange( const PropertyChangeEvent& evt ) throw( ::com::sun::star::uno::RuntimeException)
{
    // mail password was set in inimanager; we do the saving!
    Any aAny = evt.NewValue;
#if SUPD>569
    aAny >>= aMailPassword;
#else
    UString aTmp;
    aAny >>= aTmp;
    aMailPassword = OUStringToString( aTmp, CHARSET_SYSTEM );
#endif
    if ( pConfigItem )
        pConfigItem->SetDefault( FALSE );
}

void SAL_CALL SfxMailConfig_Impl::disposing( const EventObject& obj ) throw( ::com::sun::star::uno::RuntimeException)
{
    Reference < XInterface > xObj = obj.Source;
    if ( xObj == xIni )
    {
#if SUPD>569
        xIni->removePropertyChangeListener( DEFINE_CONST_UNICODE("INet/MailPassword"), this );
#else
        xIni->removePropertyChangeListener( StringToOUString("INet/MailPassword", CHARSET_SYSTEM), this );
#endif
        xIni = Reference < XConfigManager >();
    }
}

SfxMailConfig::SfxMailConfig() :
    SfxConfigItem(SFX_ITEMTYPE_MAILCONFIG)
{
#if SUPD>569
    Reference< ::com::sun::star::lang::XMultiServiceFactory > xFactory = ::legacy_binfilters::getLegacyProcessServiceFactory();
#else
    Reference< ::com::sun::star::lang::XMultiServiceFactory > xFactory = ::legacy_binfilters::getLegacyProcessServiceFactory();
#endif
    pImp = new SfxMailConfig_Impl();
    pImp->acquire();
    pImp->pConfigItem = this;

    // get access to inimanager
    pImp->xIni = Reference< XConfigManager > (
            xFactory->createInstance ( StringToOUString("com.sun.star.config.SpecialConfigManager", CHARSET_SYSTEM) ), UNO_QUERY ) ;

    // listen for property changes from mail password because all clients still will access the mail password through the
    // inimanager API
    if ( pImp->xIni.is() )
        pImp->xIni->addPropertyChangeListener( StringToOUString("INet/MailPassword", CHARSET_SYSTEM), pImp );
}

SfxMailConfig::~SfxMailConfig()
{
    if ( pImp->xIni.is() )
        pImp->xIni->removePropertyChangeListener( StringToOUString("INet/MailPassword", CHARSET_SYSTEM), pImp );
    pImp->pConfigItem = NULL;
    pImp->release();
}


String SfxMailConfig::GetName() const
{
    return String();
}

int SfxMailConfig::Load(SvStream& rStream)
{
	UINT16 nVersion;
	rStream >> nVersion;
    rStream >> pImp->aMailPassword;
    Reference < XSimpleRegistry > xMan( pImp->xIni, UNO_QUERY );

    // tell the inimanager the mail password
    // because all clients still will access the mail password through the inimanager API
    if ( xMan.is() )
    {
        // don't want to be notified about my own changes
        pImp->xIni->removePropertyChangeListener( StringToOUString("INet/MailPassword", CHARSET_SYSTEM), pImp );
        Reference < XRegistryKey > xRootKey = xMan->getRootKey();
        Reference < XRegistryKey > xEntryKey = xRootKey->createKey ( StringToOUString("INet/MailPassword", CHARSET_SYSTEM) );
        xEntryKey->setStringValue( StringToOUString( pImp->aMailPassword, CHARSET_SYSTEM ) );
        xEntryKey->closeKey();
        pImp->xIni->addPropertyChangeListener( StringToOUString("INet/MailPassword", CHARSET_SYSTEM), pImp );
    }

	return SfxConfigItem::ERR_OK;
}

BOOL SfxMailConfig::Store(SvStream& rStream)
{
    UINT16 nVersion = VERSION;
	rStream << nVersion;
    rStream << pImp->aMailPassword;
	return TRUE;
}

void SfxMailConfig::UseDefault()
{
    BOOL bReencoded = FALSE;
    Reference < XSimpleRegistry > xMan( pImp->xIni, UNO_QUERY );
    if ( xMan.is() )
    {
        // If a mail password has never been read, only the inimanager may have one; so get it and save it
        Reference < XRegistryKey > xRootKey = xMan->getRootKey();
        Reference < XRegistryKey > xEntryKey = xRootKey->openKey ( StringToOUString("INet/MailPassword", CHARSET_SYSTEM) );
        if ( xEntryKey.is() )
        {
            if ( !pImp->aMailPassword.Len() )
            {
                // If password was not already modified: it must be a old encoding, so first decode ...
                pImp->aMailPassword = OUStringToString( xEntryKey->getStringValue(), CHARSET_SYSTEM );
                pImp->aMailPassword = SfxStringDecode( pImp->aMailPassword );

                // ... and encode with the new method
                pImp->aMailPassword = CntStringEncode( pImp->aMailPassword );
                bReencoded = TRUE;
            }
            else
                pImp->aMailPassword = OUStringToString( xEntryKey->getStringValue(), CHARSET_SYSTEM );
            xEntryKey->closeKey();
        }
    }

    SfxConfigItem::UseDefault();
    if ( bReencoded )
    {
        Reference < XSimpleRegistry > xMan( pImp->xIni, UNO_QUERY );
        if ( xMan.is() )
        {
            // tell inimanager the new encoded password, this item should be modified afterwords, because the password can't
            // be retreived from inimanager anymore
            Reference < XRegistryKey > xRootKey = xMan->getRootKey();
            Reference < XRegistryKey > xEntryKey = xRootKey->createKey ( StringToOUString("INet/MailPassword", CHARSET_SYSTEM) );
            xEntryKey->setStringValue( StringToOUString( pImp->aMailPassword, CHARSET_SYSTEM ) );
            xEntryKey->closeKey();
        }
    }
}


}
