/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: services.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:27:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif
#ifndef _CPPU_MACROS_HXX_
#include <cppu/macros.hxx>
#endif
#ifndef _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _UNO_ENVIRONMENT_H_
#include <uno/environment.h>
#endif

#ifndef UUI_IAHNDL_HXX
#include <iahndl.hxx>
#endif

using namespace com::sun::star;

//============================================================================
//
//  component_getImplementationEnvironment
//
//============================================================================

extern "C" void SAL_CALL
component_getImplementationEnvironment(sal_Char const ** pEnvTypeName,
									   uno_Environment **)
{
	*pEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}

//============================================================================
//
//  component_writeInfo
//
//============================================================================

extern "C" sal_Bool SAL_CALL component_writeInfo(void *, void * pRegistryKey)
{
	bool bSuccess = pRegistryKey != 0;
	uno::Reference< registry::XRegistryKey > xKey;
	if (bSuccess)
	{
		rtl::OUString aKeyName(rtl::OUString::createFromAscii("/"));
		aKeyName += rtl::OUString::createFromAscii(
			            UUIInteractionHandler::m_aImplementationName);
		aKeyName += rtl::OUString::createFromAscii("/UNO/SERVICES");
		try
		{
			xKey = static_cast< registry::XRegistryKey * >(pRegistryKey)->
				       createKey(aKeyName);
		}
		catch (registry::InvalidRegistryException &) {}
		bSuccess = xKey.is() != false;
	}
	if (bSuccess)
	{
		uno::Sequence< rtl::OUString >
			aServiceNames(
				UUIInteractionHandler::getSupportedServiceNames_static());
		for (sal_Int32 i = 0; i < aServiceNames.getLength(); ++i)
			try
			{
				xKey->createKey(aServiceNames[i]);
			}
			catch (registry::InvalidRegistryException &)
			{
				bSuccess = false;
				break;
			}
	}
	return bSuccess;
}

//============================================================================
//
//  component_getFactory
//
//============================================================================

extern "C" void * SAL_CALL component_getFactory(sal_Char const * pImplName,
												void * pServiceManager,
												void *)
{
	void * pFactory = 0;
	if (pServiceManager
		&& rtl_str_compare(pImplName,
						   UUIInteractionHandler::m_aImplementationName)
		       == 0)
	{
		uno::Reference< lang::XSingleServiceFactory >
			xTheFactory(
				cppu::createSingleFactory(
					static_cast< lang::XMultiServiceFactory * >(
						pServiceManager),
					rtl::OUString::createFromAscii(
						UUIInteractionHandler::m_aImplementationName),
					&UUIInteractionHandler::createInstance,
				   UUIInteractionHandler::getSupportedServiceNames_static()));
		if (xTheFactory.is())
		{
			xTheFactory->acquire();
			pFactory = xTheFactory.get();
		}
	}
	return pFactory;
}
