#!/usr/bin/perl

# creates a tree file with all help files
# to be used for debugging
# copy the file in the $oooinstall/help/$language
# directory and restart OOo. You will then have
# a list of all files in the contents tab
#
# Usage:
# perl allfiles.pl <path>
# where
# <path> points to the path with the helpcontent2 folder
# if <path> is omitted, the script searches in the current
# working directory

use Cwd;

($wd = getcwd()) =~ s/^(.*helpcontent2\/).*$/${1}source\/text\//gi;
$hcdir = ($#ARGV > -1 ? $ARGV[0]."/source/text" : $wd);
die "Error accessing \"$hcdir\": $!\n" if (not -e $hcdir);

@allfiles = grep {!/CVS/} `find $hcdir | sed 's,^.*source/text/,,'`;

$filesfound = scalar @allfiles, " files found.\n"; 
$now = scalar localtime;

print<<"HEADER";
<?xml version="1.0" encoding="UTF-8"?>
<!-- $filesfound -->
  <tree_view version="$now">
  <help_section application="internal" id="999" title="All Help Documents for Debug Purposes">
HEADER

shift @allfiles;
$currentlevel = 0;
for (@allfiles) {
	chomp;
	if (-d $hcdir.$_ && $_ gt '') {         # directory
		$level = 1;
		while ($_ =~ /\//g) {$level++}
		#print $_;
		#print "$currentlevel - $level\n";
		if ($level > $currentlevel) {
			$nodeid++;
			print "  " x $level;
			print "    <node id=\"$nodeid\" title=\"$_\">\n";
			$currentlevel=$level;
		} elsif ($level == $currentlevel) {
			print "  " x $level;
			print "    </node>\n";
			$nodeid++;
			print "  " x $level;
			print "    <node id=\"$nodeid\" title=\"$_\">\n";
		} else {
			for ($i = $currentlevel; $i >= $level; $i--) {
				print "  " x $i;
				print "    </node>\n";
			}
			$nodeid++;
			print "  " x $level;
			print "    <node id=\"$nodeid\" title=\"$_\">\n";
			$currentlevel = $level;
		}
	} elsif (/\.xhp$/) {
		s,^([^/]+)/(.*)$,<topic id="$1/text/$2">$2</topic>,;
		print "  " x ($level+1);
		print "    $_\n";
	}
}

for ($i = $currentlevel; $i >= 1; $i--) {
	print "  " x $i;
	print "    </node>\n";
}

print<<"FOOTER";
  </help_section>
</tree_view>
FOOTER
