/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: basepoly.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:23:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _BASEPOLY_HXX
#define _BASEPOLY_HXX

#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif


class NodeListDataDescriptor
{
	const BYTE&					mrInitData;
	UINT32						mnByteSize;
	BOOL						(*mpNodeEqual)(const BYTE&, const BYTE&);

public:
	NodeListDataDescriptor(const BYTE& rInDa, UINT32 nBySi, 
		BOOL (*pFunc)(const BYTE&, const BYTE&))
	:	mrInitData(rInDa),
		mnByteSize(((nBySi + 3L) >> 2L) << 2L),
		mpNodeEqual(pFunc)
	{}

	const BYTE& GetInitData() const { return mrInitData; }
	UINT32 GetByteSize() const { return mnByteSize; }
	BOOL IsNodeEqual(const BYTE& rA, const BYTE& rB) const 
		{ if(mpNodeEqual) return mpNodeEqual(rA, rB); return FALSE; }
};

//////////////////////////////////////////////////////////////////////////////

class ImpBasePolygon;
class BasePolygon
{
	ImpBasePolygon*				mpImpPolygon;

protected:
	// protected functions
	void CheckClosed();
	void CheckReference();
	ImpBasePolygon* GetImpPolygon() { return mpImpPolygon; }

public:
	BasePolygon(const NodeListDataDescriptor& rDesc , UINT32 nCnt, BOOL bClosed = FALSE);
	BasePolygon(const BasePolygon& rSource);
	~BasePolygon();

	inline UINT32 GetNodeCount() const;
	BOOL IsSamePolyNodeType(const NodeListDataDescriptor& rDesc) const;
	const NodeListDataDescriptor& GetPolyNodeType() const;

	BasePolygon& operator= (const BasePolygon& rPoly3D);
	BOOL operator==(const BasePolygon& rPoly3D) const;
	BOOL operator!=(const BasePolygon& rPoly3D) const;

	BOOL IsClosed() const;
	void SetClosed(BOOL bNew);

	void RemoveNodes(UINT32 nPos, UINT32 nCnt = 1L);
	void RemoveDoubleNodes();
	void FlipOrientation();
	void ForceStatic();
};

//////////////////////////////////////////////////////////////////////////////

#include "vector3d.hxx"

class BPolygon3D : public BasePolygon
{
	static NodeListDataDescriptor		aDescriptor;
	static Vector3D						aInitValue;
	static BOOL IsNodeEqual(const BYTE& rA, const BYTE& rB);

public:
	BPolygon3D(UINT32 nPntCnt, BOOL bClosed = FALSE)
	:	BasePolygon(aDescriptor, nPntCnt, bClosed)
	{}
	BPolygon3D(const BPolygon3D& rSource)
	:	BasePolygon(rSource)
	{}

	const Vector3D& operator[](UINT32 nPos) const 
		{ return (const Vector3D&)((*this)[nPos]); }
	Vector3D& operator[](UINT32 nPos) 
		{ return (Vector3D&)((*this)[nPos]); }

	void InsertNodes(UINT32 nPos, UINT32 nCnt, 
		const Vector3D& rPointArray, BOOL bOneArrayValue = FALSE);
	void InsertNode(UINT32 nPos, const Vector3D& rPoint);
};

//////////////////////////////////////////////////////////////////////////////

#ifndef _VECTOR2D_HXX
#include <tools/vector2d.hxx>
#endif

class BPolygon2D : public BasePolygon
{
	static NodeListDataDescriptor		aDescriptor;
	static Vector2D						aInitValue;
	static BOOL IsNodeEqual(const BYTE& rA, const BYTE& rB);

public:
	BPolygon2D(UINT32 nPntCnt, BOOL bClosed = FALSE)
	:	BasePolygon(aDescriptor, nPntCnt, bClosed)
	{}
	BPolygon2D(const BPolygon2D& rSource)
	:	BasePolygon(rSource)
	{}

	const Vector2D& operator[](UINT32 nPos) const 
		{ return (const Vector2D&)((*this)[nPos]); }
	Vector2D& operator[](UINT32 nPos) 
		{ return (Vector2D&)((*this)[nPos]); }

	void InsertNodes(UINT32 nPos, UINT32 nCnt, 
		const Vector2D& rPointArray, BOOL bOneArrayValue = FALSE);
	void InsertNode(UINT32 nPos, const Vector2D& rPoint);
};

//////////////////////////////////////////////////////////////////////////////

class BPolygonPoint : public BasePolygon
{
	static NodeListDataDescriptor		aDescriptor;
	static Point						aInitValue;
	static BOOL IsNodeEqual(const BYTE& rA, const BYTE& rB);

public:
	BPolygonPoint(UINT32 nPntCnt, BOOL bClosed = FALSE)
	:	BasePolygon(aDescriptor, nPntCnt, bClosed)
	{}
	BPolygonPoint(const BPolygonPoint& rSource)
	:	BasePolygon(rSource)
	{}

	const Point& operator[](UINT32 nPos) const 
		{ return (const Point&)((*this)[nPos]); }
	Point& operator[](UINT32 nPos) 
		{ return (Point&)((*this)[nPos]); }

	void InsertNodes(UINT32 nPos, UINT32 nCnt, 
		const Point& rPointArray, BOOL bOneArrayValue = FALSE);
	void InsertNode(UINT32 nPos, const Point& rPoint);
};

#endif // _BASEPOLY_HXX

