/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: TableFieldData.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 16:28:52 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef DBAUI_TABLEFIELDDATA_HXX
#include "TableFieldData.hxx"
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _COMPHELPER_STREAMSECTION_HXX_
#include <comphelper/streamsection.hxx>
#endif
#ifndef _COMPHELPER_BASIC_IO_HXX_
#include <comphelper/basicio.hxx>
#endif

using namespace dbaui;
using namespace comphelper;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::uno;
DBG_NAME(OTableFieldData);
//------------------------------------------------------------------------------
OTableFieldData::OTableFieldData()
{
	DBG_CTOR(OTableFieldData,NULL);
}

//------------------------------------------------------------------------------
OTableFieldData::OTableFieldData( const ::rtl::OUString& rFieldName, const ::rtl::OUString& rTableName, const ::rtl::OUString& rAliasName ) :
	m_aFieldName( rFieldName ),
	m_aTableName( rTableName ),
	m_aAliasName( rAliasName )
{
	DBG_CTOR(OTableFieldData,NULL);
}

//------------------------------------------------------------------------------
OTableFieldData::~OTableFieldData()
{
	DBG_DTOR(OTableFieldData,NULL);
}

//------------------------------------------------------------------------------
void OTableFieldData::Load(const Reference< XObjectInputStream>& _rxIn)
{
	DBG_CHKTHIS(OTableFieldData,NULL);
	OStreamSection aSection(_rxIn.get());
	_rxIn >> m_aFieldName;
	_rxIn >> m_aTableName;
	_rxIn >> m_aAliasName;
	_rxIn >> m_nColWidth;
}
//------------------------------------------------------------------------------
void OTableFieldData::Save(const Reference< XObjectOutputStream>& _rxOut)
{
	DBG_CHKTHIS(OTableFieldData,NULL);
	OStreamSection aSection(_rxOut.get());

	_rxOut << m_aFieldName;
	_rxOut << m_aTableName;
	_rxOut << m_aAliasName;
	_rxOut << m_nColWidth;
}
// -----------------------------------------------------------------------------

