/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.impl.adt.IndexedTreeIterator;
import ca.odell.glazedlists.impl.adt.IndexedTreeNode;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;

public final class IndexedTree {
    private Comparator comparator;
    IndexedTreeNode root = null;

    public IndexedTree(Comparator comparator) {
        this.comparator = comparator;
    }

    public IndexedTree() {
        this.comparator = null;
    }

    public Object get(int index) {
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("cannot get from tree of size " + this.size() + " at " + index);
        }
        IndexedTreeNode treeNode = this.root.getNodeWithIndex(index);
        return treeNode.getValue();
    }

    public IndexedTreeNode getNode(int index) {
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("cannot get from tree of size " + this.size() + " at " + index);
        }
        return this.root.getNodeWithIndex(index);
    }

    public IndexedTreeNode getNode(Object value) {
        if (this.root == null) {
            return null;
        }
        return this.root.getShallowestNodeWithValue(this.comparator, value, false);
    }

    public int size() {
        if (this.root == null) {
            return 0;
        }
        return this.root.size();
    }

    public IndexedTreeIterator iterator(int index) {
        return new IndexedTreeIterator(this, index);
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public IndexedTreeNode removeByIndex(int index) {
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("cannot get from tree of size " + this.size() + " at " + index);
        }
        return this.root.removeNode(this, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexedTreeNode addByNode(Object value) {
        block3: {
            if (this.root != null) break block3;
            IndexedTreeNode indexedTreeNode = this.root = new IndexedTreeNode(null, value);
            return indexedTreeNode;
        }
        IndexedTreeNode indexedTreeNode = this.root.insert(this, value);
        return indexedTreeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexedTreeNode addByNode(int index, Object value) {
        block5: {
            if (index > this.size()) {
                throw new IndexOutOfBoundsException("cannot insert into tree of size " + this.size() + " at " + index);
            }
            if (value == null) {
                throw new NullPointerException("cannot insert a value that is null");
            }
            if (this.root != null) break block5;
            IndexedTreeNode indexedTreeNode = this.root = new IndexedTreeNode(null, value);
            return indexedTreeNode;
        }
        IndexedTreeNode indexedTreeNode = this.root.insert(this, index, value);
        return indexedTreeNode;
    }

    public int indexOf(Object object) {
        if (this.root == null) {
            return -1;
        }
        IndexedTreeNode shallowestNodeWithValue = this.root.getShallowestNodeWithValue(this.comparator, object, false);
        if (shallowestNodeWithValue == null) {
            return -1;
        }
        IndexedTreeIterator iterator = new IndexedTreeIterator(this, shallowestNodeWithValue);
        while (iterator.hasPrevious()) {
            IndexedTreeNode node = iterator.previous();
            if (this.comparator.compare(node.getValue(), object) == 0) continue;
            return iterator.nextIndex() + 1;
        }
        return 0;
    }

    public int indexOfSimulated(Object object) {
        if (this.root == null) {
            return 0;
        }
        IndexedTreeNode shallowestNodeWithValue = this.root.getShallowestNodeWithValue(this.comparator, object, true);
        if (shallowestNodeWithValue == null) {
            throw new IllegalStateException();
        }
        int compareResult = this.comparator.compare(shallowestNodeWithValue.getValue(), object);
        if (compareResult < 0) {
            IndexedTreeIterator iterator = new IndexedTreeIterator(this, shallowestNodeWithValue);
            while (iterator.hasNext()) {
                IndexedTreeNode node = iterator.next();
                if (this.comparator.compare(node.getValue(), object) < 0) continue;
                return iterator.previousIndex();
            }
            return this.size();
        }
        IndexedTreeIterator iterator = new IndexedTreeIterator(this, shallowestNodeWithValue);
        while (iterator.hasPrevious()) {
            IndexedTreeNode node = iterator.previous();
            if (this.comparator.compare(node.getValue(), object) >= 0) continue;
            return iterator.nextIndex() + 1;
        }
        return 0;
    }

    public int lastIndexOf(Object object) {
        if (this.root == null) {
            return -1;
        }
        IndexedTreeNode shallowestNodeWithValue = this.root.getShallowestNodeWithValue(this.comparator, object, false);
        if (shallowestNodeWithValue == null) {
            return -1;
        }
        IndexedTreeIterator iterator = new IndexedTreeIterator(this, shallowestNodeWithValue);
        while (iterator.hasNext()) {
            IndexedTreeNode node = iterator.next();
            if (this.comparator.compare(node.getValue(), object) == 0) continue;
            return iterator.previousIndex() - 1;
        }
        return this.size() - 1;
    }

    void validate() {
        Iterator i = (Iterator)((Object)this.iterator(0));
        while (i.hasNext()) {
            IndexedTreeNode node = (IndexedTreeNode)i.next();
            node.validate(this);
        }
    }

    public String toString() {
        if (this.root == null) {
            return ".";
        }
        return this.root.toString();
    }

    void setRootNode(IndexedTreeNode root) {
        this.root = root;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: IndexedTree <operations> <repetitions>");
            return;
        }
        int operations = Integer.parseInt(args[0]);
        int repetitions = Integer.parseInt(args[1]);
        Random random = new Random();
        System.out.print("Indexed Tree ");
        long start = System.currentTimeMillis();
        for (int r = 0; r < repetitions; ++r) {
            IndexedTree tree = new IndexedTree(GlazedLists.comparableComparator());
            for (int i = 0; i < operations; ++i) {
                int operation = (int)(random.nextDouble() * 3.0);
                if (operation <= 1 || tree.size() == 0) {
                    Integer value = new Integer((int)(random.nextDouble() * 2.147483647E9));
                    tree.addByNode(value);
                    continue;
                }
                int index = (int)(random.nextDouble() * (double)tree.size());
                tree.removeByIndex(index);
            }
        }
        long total = System.currentTimeMillis() - start;
        System.out.println("time: " + total);
    }
}

